#!/bin/bash

listmemberfile=`/opt/huawei/snas/sbin/nofs-snas listdiskmemberinfo | awk -F 'file' '{print $2}'`
/opt/huawei/snas/sbin/nofs-snas getpoolinfo > poolinfo
/opt/huawei/snas/sbin/nofs-snas printnofsconfigure > config

outerweight=`cat config | grep -a DataOuterWeight | awk -F '=' '{print $2}' | awk '{print $1}'`
innerweight=`cat config | grep -a DataInnerWeight | awk -F '=' '{print $2}' | awk '{print $1}'`

for pool in `/opt/huawei/snas/sbin/nofs-snas listpool | awk '{print $1}' | grep -a P`
do
    #检查硬盘状态合法性
    poolstate=`cat poolinfo | grep -aw "${pool}" | awk -F 'State:' '{print $2}' | awk '{print $1}'`
    if [ X"${poolstate}" == X" " -o ${poolstate} -ne 0 ];then
        continue;
    fi
 
    cat ${listmemberfile} | grep -aw "${pool}" | awk '{if($2==1)print}' > tmpfile
    sum1=`cat tmpfile | awk '{sum+=$10}END{print sum}'`
    
    value=`cat tmpfile | awk '{if($10==0)print}' | awk '{sum+=$11}END{print sum}'`
    if [[ X"${value}" == X"" ]];then
        value=0
    fi
    
    value=`echo $((${value}*${innerweight}))`
    sum2=`echo $((${value}/${outerweight}))`

    free=$[${sum1}+${sum2}]
    total=`cat tmpfile | awk '{sum+=$5}END{print sum}'`
    alloc=`echo $((${total}-${free}))`
    alloc=`echo "scale=2;${alloc}/1024/1024" | bc` 
    echo "pool:${pool} alloc(MB):$alloc"
done
