#!bin/bash
path_file_path=/OSM/conf/patch.yml

G_RET_NO_NEED_CHECK=0
G_RET_NEED_CHECK=1

#判断补丁版本
function CheckLessThanMaxPatchVersion()
{
    local patchMaxVer=$1
    if [ ! -f $path_file_path ] ;then # 补丁配置文件不存在，说明为基线版本，需要进行检查
        return ${G_RET_NEED_CHECK}
    fi

    local curPatchVer=`cat ${path_file_path} | grep patch_version | head -1 | awk '{print $(NF)}'`
    if [ -z $curPatchVer ] ;then	# 未获取到版本号，说明环境有问题，进行检查
        return ${G_RET_NEED_CHECK}
    fi
    if [ `expr substr $curPatchVer 4 5 \< substr $patchMaxVer 4 5` -eq 1 ] ;then
        return ${G_RET_NEED_CHECK}
    fi
}

function NeedCCDBDBMalformCheck()
{
    local manifest_file_path=/startup_disk/image/pkg_cur/manifest.yml
    curBaseVer=`cat ${manifest_file_path} | grep Version | head -1 | awk '{print $(NF)}'`

    if [ x"${curBaseVer}" == x"6200819073" ] ;then  # V5R7C73
        CheckLessThanMaxPatchVersion SPH120
        if [ "$?" == ${G_RET_NEED_CHECK} ] ;then
            return ${G_RET_NEED_CHECK}
        fi
        return ${G_RET_NO_NEED_CHECK}
    elif [ x"${curBaseVer}" == x"6200815132" ] ;then # V5R7C71
        CheckLessThanMaxPatchVersion SPH150
        if [ "$?" == ${G_RET_NEED_CHECK} ] ;then
            return ${G_RET_NEED_CHECK}
        fi
        return ${G_RET_NO_NEED_CHECK}
    else
        return ${G_RET_NO_NEED_CHECK}
    fi
}

NeedCCDBDBMalformCheck
if [ "$?" == ${G_RET_NO_NEED_CHECK} ] ;then
    echo "True"
    echo ""
    echo ""
    exit 0
fi

dbPath=/OSM/ccdb/store
#先检查元数据DB
checkRes=$(sqlite3 $dbPath/ccdb_metadata.db_0/ccdb_metadata.db --batch "pragma integrity_check;" 2>&1)
if [ "$checkRes" != "ok" ]; then
    echo "False"
    echo "10008"
    echo "ccdb_metadata.db"
    exit 0
fi

#获取业务DB
dbList=`sqlite3 $dbPath/ccdb_metadata.db_0/ccdb_metadata.db --batch "select db_file_name,import_seq from db_instance_record;" 2>&1`
if [ $? != 0 ]; then
    echo "True"
    echo ""
    echo ""
    exit 0
fi
malformedDb=""
for db in $dbList
do
    db_imprtseq=(${db/|/_}) #|替换为_
    dbname=(${db%|*}) # 去除|后的字符
    if [ ! -f $dbPath/${db_imprtseq}/$dbname ]; then 
        continue
    fi
    checkRes=$(sqlite3 $dbPath/${db_imprtseq}/$dbname --batch "pragma integrity_check;" 2>&1)
    if [ "$checkRes" != "ok" ]; then
        malformedDb="${malformedDb} ${dbname}"
    fi
done

if [ x"$malformedDb" != x"" ];then
    echo "False"
    echo "10008"
    echo ${malformedDb}
else
    echo "True"
    echo ""
    echo ""
fi

exit 0