#!/bin/bash
# ********************************************** ***************************** #
# File Name: check_fdsa_readonly.sh
# Description: fdsa系统盘检测是否只读
# Input: none        
# Output: none
# Created: 0204-09-03
# Function List：
# History
# **************************************************************************** #

source /OSM/script/os_load_base.sh

#目录检测列表：
CHECK_DIRECTORIES[0]="/startup_disk/conf"
CHECK_DIRECTORIES[1]="/OSM/coffer_data"
CHECK_DIRECTORIES[2]="/OSM/coffer_log"
CHECK_DIRECTORIES[3]="/OSM/coffer_bin"
CHECK_DIRECTORIES[4]="/OSM/coffer_runningdata"

FAULT_COUNT=0

i=0
while [ $i -lt ${#CHECK_DIRECTORIES[*]} ]
do
    md=$(cat /proc/mounts | grep ${CHECK_DIRECTORIES[$i]}\  | awk '{if (!match($0, /ro/)) print 0; else print 1}')
    if [ $md -ne 0 ]; then
        OS_echo "[check_fdsa_readonly.sh]SYS_RAID:${CHECK_DIRECTORIES[$i]} is Read-only file system."
        let FAULT_COUNT++
    fi
    let i++
done

if [ 0 -ne $FAULT_COUNT ]; then
	OS_echo "[check_fdsa_readonly.sh]ReadOnly check is error."
    echo "False"
	exit 0
fi

echo "True"
exit 0