#!/bin/bash
source /OSM/script/os_load_base.sh

#检查补丁版本，如果补丁版本是SPH203及之后版本，则检查通过，否则继续检查
function hotpatch_version_check()
{
	#不存在补丁，则继续检查
	if [ ! -f /OSM/conf/patch.yml ]; then
		OS_echo "NFS_HM_CHECK no patch.yml"
		return 1
	fi
	
	#根据问题单查询补丁号
	dst_patch=DTS2021031505HI37P1D00
	patch=`sudo livepatch -q | grep $dst_patch | awk '{print $3}'`
	if [[ "$patch" != "" ]] && [[ $patch =~ "$dst_patch" ]] ; then 
		OS_echo "NFS_HM_CHECK patch $patch PASS"
		return 0
	else
		OS_echo "NFS_HM_CHECK patch $patch CONTINUE"
		return 1
	fi
}

#检查NFSv3转发开关是否为关，为开则继续检查
function nfsv3_forward_switch_check()
{
	forward_switch=`sudo nas_proto_pum -m nfs -c get_nfsv3_forward_switch | awk '{print $2}'`
	if [[ "$forward_switch" = "Enabled" ]] ; then
		OS_echo "NFS_HM_CHECK nfsv3 forward switch $forward_switch CONTINUE"
		return 1
	else
		OS_echo "NFS_HM_CHECK nfsv3 forward switch $forward_switch PASS"
		return 0
	fi
}

#检查NFSv3开关检查，全部NFSv3开关为关，则检查通过，否则继续检查
function nfsv3_switch_check()
{
	for nfsv3_switch in $(sudo nas_proto_pum -m nfs -c get_tenant_nfs3_vers | grep -v Nfsv3 | awk '{print $2}')
	do
		if [[ "$nfsv3_switch" = "1" ]] ; then
			OS_echo "NFS_HM_CHECK nfsv3 switch $nfsv3_switch CONTINUE"
			return 1
		fi
	done
	OS_echo "NFS_HM_CHECK all nfsv3 switch off PASS"
	return 0
}

#检查是否配置了FS双活，配置了FS双活则检查不通过，否则检查通过
function fs_hm_pair_check()
{
	#获取Super_admin用户列表
	super_admin_list=$(echo -e "aa showalluser\nexit\n" |diagnose  --auto | grep "Super_admin" | awk '{print $1}')
	if [[ "$super_admin_list" = "" ]] ; then
		super_admin_list=admin
	fi
	#获取第一个Super_admin用户
	for admin_user in $super_admin_list
	do
	if [[ "$admin_user" != "" ]] ; then
		break;
	fi
	done
	#查询双活pair
	hyper_metro_vstore_pair=$(/ISM/cli/ismcli -u $admin_user -c "show hyper_metro_vstore_pair general" | grep "Running Status")
	if [[ "$hyper_metro_vstore_pair" != "" ]] ; then
		OS_echo "NFS_HM_CHECK exist hyper metro vstore pair FAIL"
		return 1
	else
		OS_echo "NFS_HM_CHECK exist hyper metro vstore pair PASS"
		return 0
	fi
}

#第一步检查补丁以及版本号
hotpatch_version_check
result=$?
OS_echo "NFS_HM_CHECK hotpatch version check $result"
if [[ $result = 0 ]] ; then 
	echo "True"
	exit 0
fi
#第二步检查nfsv3转发开关
nfsv3_forward_switch_check
result=$?
OS_echo "NFS_HM_CHECK nfsv3 forward switch check $result"
if [[ $result = 0 ]] ; then 
	echo "True"
	exit 0
fi
#第三步检查NFSv3服务开关
nfsv3_switch_check
result=$?
OS_echo "NFS_HM_CHECK nfsv3 switch check $result"
if [[ $result = 0 ]] ; then 
	echo "True"
	exit 0
fi
#第四步检查NAS双活租户pair
fs_hm_pair_check
result=$?
if [[ $result = 0 ]] ; then 
	echo "True"
	OS_echo "NFS_HM_CHECK nfs hyper metro vstore pair check PASS"
else
	echo "False"
	OS_echo "NFS_HM_CHECK nfs hyper metro vstore pair check FAIL"
fi
exit 0

