#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import random
import time

from infra.debug.log import swm_logger as log
from infra.util import shell


CMD_PREFIX = "python " if os.path.exists('/.dockerenv') or \
                          os.path.exists('/crash/permitdir') else ""

EXEC_CLI_CMD = CMD_PREFIX + "/ISM/cli/ismcli -u {0} -c '{1}'  > '{2}'"
USER_EXIST = r'id -u admin > /dev/null 2>&1'
USER_CMD = r"cat /etc/passwd | grep '/ISM/cli/ismcli' | grep ':0:root:'"


class CliExecutor(object):
    """
    CLI命令执行管理
    """

    USER_NAME = ''

    @classmethod
    def exec_show_cmd_to_file(cls, cmd):
        """
        执行查询命令，并将查询结果重定向到指定文件
        :param cmd: CLI命令
        :return:
        """
        cli_exec_tmp_file = "/OSM/coffer_data/update/{0}_{1}_{2}". \
            format("".join(str(cmd).strip().split()), ''.
                   join(random.sample('zyxwvutsrqponmlkjihgfedcba', 5)),
                   str(time.time()))

        if not cls.USER_NAME:
            ret = shell.call_system_cmd(USER_EXIST)
            if not ret[0]:
                cls.USER_NAME = 'admin'
            else:
                ret_code, output = shell.call_system_cmd(USER_CMD)
                if ret_code:
                    log.error('Get user failed, ret({0}), output: {1}'.format(ret_code, output))
                    return False, ""
                cls.USER_NAME = output.strip().split(':')[0]

        log.info('Get user: {0}'.format(cls.USER_NAME))
        show_cmd = EXEC_CLI_CMD.format(cls.USER_NAME, cmd, cli_exec_tmp_file)
        ret = os.system(show_cmd)
        if ret:
            return False, ""
        return True, cli_exec_tmp_file
