# coding: utf-8
"""
Infrastructure protocol module
"""

__all__ = ['SftpClient']

import os
import shutil
from infra.debug.log import swm_logger as log
from infra.util import shell


class SftpClient(object):
    """
    sftp client class
    """
    def __init__(self, host, port=22):
        self.host = host
        self.port = port
        return

    def get_file(self, local_path, remote_path, timeout=30, retry_times=3):
        """

        :param local_path:
        :param remote_path:
        :param timeout:
        :param retry_times: Retry times when get file failed
        :return:
        """
        local_dir = os.path.dirname(local_path)
        cmd = "os_get_file.sh %s %s %s %d" % (self.host, remote_path, local_dir, timeout)
        ret_code, output = shell.call_system_cmd(cmd)
        if ret_code:
            log.error("SFTP: Get file(%s) by os_get_file failed, ret(%d), output:\n%s\n.",
                      remote_path, ret_code, output)
            return False
        local_file = os.path.join(local_dir, os.path.basename(remote_path))
        if not os.path.isfile(local_file):
            log.error("SFTP: Get file(%s) successfully, but not exist.", local_file)
            return False
        shutil.move(local_file, local_path)
        return True
