#!/bin/bash

Power_Output="power_output"


# MPA命令执行 用户态及attach 21
function MPA_BMC_CMD_OUTPUT()
{
    local CMD_EXEC=$1
(
diagnose_usr --auto <<EOF
attach 21
${CMD_EXEC}
exit
EOF
) > ${Power_Output}
}

function PSU_echo()
{
    local loop=0
    while ((${loop}<10)); do
        if [ -S "/dev/log" ]; then
            OS_echo "$1"
            # echo "$1"
            break
        fi
        sleep 1
        let loop+=1
    done
}

function Check_Upgrade_For_Risk_PSU()
{
    local PSU_PAC2000S12_BG="50 41 43 32 30 30 30 53 31 32 2d 42 47" # 电源型号
    local PSU_02312HGY="30 32 33 31 32 48 47 59" # 电源编码
    local retCheck=0
    local retCode=0
    local loop=0

    frameType=$(grep -i "Product Name" /proc/osp/bsp |awk -F "is" '{print $2}')
    if [[ "${frameType}" =~ "HI1620_4U4C" ]]; then
        PSU_echo "[PangeaPowerProcessCheck]Device is HI1620_4U4C"
        return 0 # 高端控制框不检查电源
    fi
    
    for fruID in {0,1}; do
        loop=0
        while ((${loop}<3)); do
            psu_model=$(sudo ipmitool raw 0x32 0x2c ${fruID} 0x20 0 0 0 2>&1)
            retCode=$?
            if [[ "x${retCode}" == "x0" ]]; then
                break
            fi
            let loop+=1
            sleep 3
        done
        psu_model=${psu_model:1:38} # 截取电源model
        PSU_echo "[PangeaPowerProcessCheck]psu_model PSU${fruID}: ${psu_model}"
        if [[ "${psu_model}" != "${PSU_PAC2000S12_BG}" ]]; then
            continue
        fi
        loop=0
        while ((${loop}<3)); do
            psu_code=$(sudo ipmitool raw 0x32 0xbb ${fruID} 0x10 0 0 0x59 2>&1)
            retCode=$?
            if [[ "x${retCode}" == "x0" ]]; then
                break
            fi
            let loop+=1
            sleep 3
        done
        psu_code=${psu_code:1:23}
        PSU_echo "[PangeaPowerProcessCheck]psu_info PSU${fruID}:${psu_code}"
        if [[ "x${psu_code}" != "x${PSU_02312HGY}" ]]; then
            continue
        fi
        loop=0
        while ((${loop}<3)); do
            MPA_BMC_CMD_OUTPUT "mpa bmc getpowerversion 100${fruID} 1"
            psu_version=$(grep "Power Software Version" "${Power_Output}" |awk -F ":" '{print $2}')
            if [[ ! -z ${psu_version} ]]; then
                break
            fi
            let loop+=1
            sleep 3
        done
        PSU_echo "[PangeaPowerProcessCheck]psu_version PSU${fruID}:${psu_version}"
        if [[ "x${psu_version}" == "x111" ]] || [[ "x${psu_version}" == "x113" ]] || \
           [[ "x${psu_version}" == "x115" ]] || [[ "x${psu_version}" == "x119" ]]; then
            retCheck=1
        fi
    done
    rm -f ${Power_Output}
    return ${retCheck}
}

NODE_0_IP=""
function Get_Local_Host_Id()
{
(
swm_diagnose --auto <<EOF
host show
exit
EOF
) > ${Power_Output}

    local host_id=""
    local retCode=0

    host_id=$(grep "Local host id is:" "${Power_Output}" |awk -F "is: " '{print $2}')
    if [ "x${host_id}" != "x0" ]; then
        retCode=1
    fi
    PSU_echo "[PangeaPowerProcessCheck] Local host id is: ${host_id}"
    while read line; do
        if [[ ${line} =~ "0A" ]] && [[ ${line} =~ "(True)" ]]; then
            ip_array=($(echo ${line} |tr ',' ' '))
            for ip in ${ip_array[@]}; do
                if [[ ${ip} =~ "(True)" ]]; then
                    NODE_0_IP=$(echo ${ip} |awk -F "(" '{print $1}')
                    break
                fi
            done
            if [[ "x${NODE_0_IP}" != "x" ]]; then
                break
            fi
        fi
    done < ${Power_Output}
    rm -f ${Power_Output}
    return ${retCode}
}

function PSU_Upgrade_Process_Restart()
{
    local result=""

    result=$(ps -ef |grep power_update_daemon_process.sh |grep -v "grep" |awk '{print $2}' |sudo xargs kill -9 >/dev/null 2>&1)
    sleep 2
    result=$(ps -ef |grep power_update_daemon_process.sh |grep -v "grep")
    if [ "x${result}" != "x" ]; then
        PSU_echo "[PangeaPowerProcessCheck] kill power_update_daemon_process.sh failed."
        return 1 # kill进程失败
    fi
    
    local loop=0
    while ((${loop}<6)); do
        result=$(setsid sh /OSM/script/power_update_daemon_process.sh >/dev/null 2>&1 &) # 电源守护进程
        sleep 2
        result=$(ps -ef |grep power_update_daemon_process.sh |grep -v "grep")
        if [ "x${result}" != "x" ]; then
            break
        fi
        let loop+=1
    done
    result=$(ps -ef |grep power_update_daemon_process.sh |grep -v "grep")
    if [ "x${result}" == "x" ]; then
        PSU_echo "[PangeaPowerProcessCheck] restart power_update_daemon_process.sh failed."
        return 1 # Restart进程失败
    fi
    PSU_echo "[PangeaPowerProcessCheck] restart power_update_daemon_process.sh success."
    return 0
}

function PSU_Upgrade_Process_Check_Main()
{
    local retCode=0
    
    # 1.检查电源升级补丁存在
    if [ ! -f "/OSM/script/power_update_daemon_process.sh" ]; then
        return 0
    fi
    # 2.检查风险电源升级完成
    Check_Upgrade_For_Risk_PSU
    retCode=$?

    Get_Local_Host_Id
    host_id=$?
    local filePath="/tmp"
    if [ -f "/home/ibc_os_hs/power_upgrade_conf_data" ]; then
        filePath="/home/ibc_os_hs"
    fi
    local psu_upgrade_end=0
    # 风险电源 && 非0节点 && 0节点IP存在
    if [[ "x${retCode}" != "x0" ]] && [[ "x${host_id}" != "x0" ]] && [[ "x${NODE_0_IP}" != "x" ]]; then
        psu_upgrade_end=1
        echo "power_upgrade_check" >"${filePath}/power_upgrade_check"
        sudo sh os_put_file.sh "${NODE_0_IP}" "${filePath}/power_upgrade_check" "${filePath}/"
        PSU_echo "[PangeaPowerProcessCheck] os_put_file.sh ${NODE_0_IP} ${filePath}/power_upgrade_check ${filePath}/"
        sleep 1
        sudo rm -f "${filePath}/power_upgrade_check"
    fi
    # 0节点 && [风险电源 || 文件存在]
    if [[ "x${host_id}" == "x0" ]]; then
        local loop=0
        while ((${loop}<6)); do
            if [[ "x${retCode}" != "x0" ]] || [[ -f "${filePath}/power_upgrade_check" ]]; then
                echo "power_upgrade_check" >"${filePath}/power_upgrade_check"
                if [[ ! -f "/tmp/power_upgrade_num" && ! -f "/home/ibc_os_hs/power_upgrade_num" && \
                      ! -f "/tmp/power_upgrade_bmcisok" && ! -f "/home/ibc_os_hs/power_upgrade_bmcisok" && \
                      ! -f "/tmp/power_upgrade_permit" && ! -f "/home/ibc_os_hs/power_upgrade_permit" ]]; then
                    psu_upgrade_end=1
                fi
                if [[ ! -f "/startup_disk/conf/conf_local/power_upgrade_permit" ]]; then
                    psu_upgrade_end=1
                fi
                sudo /OSM/script/eam.sh psu_upgrade_permit_local on >/dev/null 2>&1
                PSU_echo "[PangeaPowerProcessCheck] eam.sh cmd create power_upgrade_permit file."
                break
            fi
            sleep 5
            let loop+=1
        done
    else
        local loop=0
        while ((${loop}<6)); do
            sudo sh os_get_file.sh "${NODE_0_IP}" "${filePath}/power_upgrade_check" "${filePath}/"
            PSU_echo "[PangeaPowerProcessCheck] os_get_file.sh ${NODE_0_IP} ${filePath}/power_upgrade_check ${filePath}/"
            if [[ -f "${filePath}/power_upgrade_check" ]]; then
                sudo rm -f "${filePath}/power_upgrade_check"
                if [[ ! -f "/tmp/power_upgrade_num" && ! -f "/home/ibc_os_hs/power_upgrade_num" && \
                      ! -f "/tmp/power_upgrade_bmcisok" && ! -f "/home/ibc_os_hs/power_upgrade_bmcisok" ]]; then
                    PSU_echo "[PangeaPowerProcessCheck] the power_upgrade_bmcisok and power_upgrade_num files do not exist."
                    psu_upgrade_end=1
                fi
                break
            fi
            sleep 5
            let loop+=1
        done
    fi
    if [[ "x${psu_upgrade_end}" == "x0" ]]; then # 无电源需要升级，退出
        PSU_echo "[PangeaPowerProcessCheck] power upgrade completed."
        return 0
    fi
    PSU_echo "[PangeaPowerProcessCheck] power need to be upgraded."
    sleep 30
    if [[ -f "${filePath}/power_upgrade_check" ]]; then
        sudo rm -f "${filePath}/power_upgrade_check"
    fi
    # 3.所有节点重启电源守护进程
    retCode=0
    PSU_Upgrade_Process_Restart
    retCode=$?
    
    return ${retCode}
}

PSU_Upgrade_Process_Check_Main
retCheck=$?
if [ "${retCheck}" == "0" ]; then
    echo "True"
else
    echo "False"
fi
exit 0

