#!/bin/bash
set +x

# *************************************************************************** #
# File Name: inspect_hardware.sh
# Description: ѲĿеӲ.
# Input:
# Output:
# Author:
# Created:
# Function List
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #
G_SCRIPT_PATH="/opt/inspect"
dos2unix $G_SCRIPT_PATH/inspect_lib.sh > /dev/null 2>&1
dos2unix $G_SCRIPT_PATH/inspect_map.sh > /dev/null 2>&1

. /opt/node_type_recognize.sh
. $G_SCRIPT_PATH/inspect_lib.sh
. $G_SCRIPT_PATH/inspect_map.sh
. /opt/node_devicename.sh

G_TMP_FILE="${G_TMP_INSPECT_PATH}tmpfile$$"
G_REMOTE_TMP_FILE="${G_TMP_INSPECT_PATH}tmpfilex$$"

VALID_IP_FILE="${G_TMP_INSPECT_PATH}tmp_valid_ip$$"

NID_ROLE_FILE="${G_TMP_INSPECT_PATH}tmp_nid_role"

IP_ROLE_FILE="${G_TMP_INSPECT_PATH}tmp_ip_role"

G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"
. $G_MML_FILE_PATH/CommonFunc.sh

LOG_FILE="/var/log/inspect.log"

LOG_FILE_BAK="/var/log/inspect_1.log"

SWITCH_TOPO_FILE="/opt/huawei/snas/etc/switchTopo.ini"
REPLACE_HWDIR_SEDSTR="s/\/opt\/huawei\//\/opt\/product\//g"
RepeatTimes=(1 2 3)

FIFO_OPERATE_ID=758
FIFO_THREAD_NUM_MAX=60

G_SEPARATOR="-----------------------------------------------------------------------------"

function LOG
{
    echo [`date`][$$]$@ >> $LOG_FILE
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

#ʹfifoܵ, ʵֶ̲, Ҫ׼ VALID_IP_FILE
function fifo_start
{
    trap "exec $FIFO_OPERATE_ID>&-;exec $FIFO_OPERATE_ID<&-;exit 0" 2

    mkfifo remoteFifo
    eval "exec $FIFO_OPERATE_ID<>remoteFifo"
    rm -rf remoteFifo

    local num=0
    for Item in $VALID_IP_FILE; do
        num=$((num+1))
    done

    local threadNum=$FIFO_THREAD_NUM_MAX
    if [ $threadNum -gt $num ]; then
        threadNum=$num
    fi

    for ((i=0;i<$threadNum;i++))
    do
        eval "echo >& $FIFO_OPERATE_ID"
    done
}

function fifo_finish
{
    eval "exec $FIFO_OPERATE_ID>&-"
    eval "exec $FIFO_OPERATE_ID<&-"


}

function check_pass()
{
    local list=(["2"]=0 ["1"]=1 ["4"]=2 ["0"]=3 ["3"]=4) #δ(2)>ͨ(1)>Ż(4)>ͨ(0)>漰(3)
    local isPass=$1   #Ⱥ
    local tmpIsPass=$2 #ǰ

    if [ ${list[$tmpIsPass]} -lt ${list[$isPass]} ];then
        isPass=$tmpIsPass
    fi
    echo $isPass
}


#ȡڵһõĺIP
function get_backnet_ip
{
    local snas_ini_file="/opt/huawei/snas/etc/snas.ini"
    local IpIndex=1
    local subnetwork_id
    local BackendIp
    local IpNum
    IpNum=`cat ${snas_ini_file} | grep "ipaddr_" | wc -l`

    while [ "$IpIndex" -le "$IpNum" ]; do
        subnetwork_id=`grep "subnetwork_id_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
        if [ -z "${subnetwork_id}" ]; then
            break
        fi

        if [ ${subnetwork_id} -eq 1 ]; then
            BackendIp=`grep "ipaddr_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
            ping "${BackendIp}" -f -c 2 -w 2 >/dev/null 2>&1
            if [ $? -ne 0 ]; then
                IpIndex=$((IpIndex + 1))
                continue
            else
                echo ${BackendIp}
                break
            fi
        fi

        IpIndex=$((IpIndex + 1))
    done
}

#ȡָڵһIP
function get_node_backnet_ip
{
    local nid=$1
    local temp=1
    local iRet=0
    local IpNum=0
    local BackendIp=""
    IpNum=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select COUNT(*) from (select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID);"`
    if [ "$IpNum" -eq 0 ]; then
        LOG "[$FUNCNAME]There is no back subnet IP of $nid in db"
        return 1
    fi

    while [ "$temp" -le "$IpNum" ];
    do
        BackendIp=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID limit $((temp - 1)), $temp;"`
        if [ $BackendIp = "" ]; then
            LOG "[$FUNCNAME] Get back ip of $nid failed"
            temp=$((temp + 1))
            continue
        else
            #try ping
            ping "${BackendIp}" -f -c 2 -w 2 >/dev/null 2>&1
            if [ $? -ne 0 ]; then
                temp=$((temp + 1))
                continue
            else
                break
            fi
        fi
    done
    if [ ${temp} -gt ${IpNum} ]; then
        LOG "[${FUNCNAME[@]}] back ip of $nid ping fail"
    fi
    echo ${BackendIp}
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        LOG "[${FUNCNAME}]IP:$remote_ip,item:${G_CHECK_IDLIST},Return:$iRet,TryTimes:$time,CMD:${cmd}"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#Զ첽ִУip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid="$$$2"
    local time_out=$3
    local cmd=$4
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
        local iRet=$?
        LOG "[${FUNCNAME}]IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},Return:$iRet,TryTimes:$time,CMD:${cmd}"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

function download_result()
{
    local remoteIp=$1
    local params=$2
    local TASK_ID="CheckItems"
    local iRet=0
    local G_REMOTE_EXEX_RESULT="${G_TMP_INSPECT_PATH}tmpfileRemoteResult$$"
    local G_DOWNLOAD_FILE="${G_TMP_INSPECT_PATH}inspect_downloadfile$$"
    #ѭֱسɹʧܺ˳ѭ
    while [[ ${remoteIp} != "" ]]
    do
    {
        remote_exec_checkfini $remoteIp $TASK_ID "checkwareStatusExBatch"
        iFunRet=$?
        if [ $iFunRet -eq 0 ];then
            continue
        elif [ $iFunRet -eq 2 -o $iFunRet -eq 5 ];then
            iRet=0
        elif [ $iFunRet -eq 125 ];then # timeout=125
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO: remote_exec_checkfini return ($iFunRet)download_result checkfini failed."
            iRet=125
        else
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO: remote_exec_checkfini return ($iFunRet)download_result checkfini failed."
            iRet=1
        fi

        #Ϊ100%֮ļؽнcheckfiniɹִزԶʱļ
        remote_download_sync $remoteIp $G_DOWNLOAD_FILE$remoteIp $G_REMOTE_EXEX_RESULT${params}
        iFunRet=$?
        if [ $iFunRet -ne 0 ];then
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO:remote_download_sync return ($iFunRet) download_result download file failed."
            [ ${iRet} -eq 0 ] && iRet=126 # checkfini succuss, download fail=126
        fi
        break
    }
    done
    return $iRet
}

CheckMsgParse()
{
    local Remote_ip=$1
    local CheckMsgFile=$2
    local default=$3
    local info=""
    local Result=""
    dos2unix $CheckMsgFile > /dev/null 2>&1
    local index=0
    while read var
    do
        if [ "$var" != "" ]; then
            info=`handle_remote_result "$var"`
            if [ $? -ne 0 ]; then
                if [ $default -eq 0 ];then
                    WRITE_XML_ERROR 0 "Node: $Remote_ip||${info}" >/dev/null
                elif [ $default -eq 1 ];then
                    WRITE_XML_ERROR 0 "${info}" >/dev/null
                fi
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:inspect error ${info}"
            else
                if [ $default -eq 0 ];then
                    WRITE_XML_COMMON 0 "Node: $Remote_ip||${info}" >/dev/null
                elif [ $default -eq 1 ];then
                    WRITE_XML_COMMON 0 "${info}" >/dev/null
                fi
            fi
        fi
    done < "$CheckMsgFile"
}


#ӡڵ汾
function print_NodeVersion
{
    local FILE=$1
    local IP=$2
    local nodeHardwareType=$3
    local exp_u=""
    local clusterversion=0
    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')
    netcard=`cat $FILE|grep netcard|awk -F: '{print $2}'`
    nvdimm=`cat $FILE|grep nvdimm|awk -F: '{print $2}'`
    ofed=`cat $FILE|grep ofed|awk -F: '{print $2}'`
    sascard=`cat $FILE|grep sascard|awk -F: '{print $2}'`
    bmc=`cat $FILE|grep BMC:| grep -v "\[ERR\]"|awk -F: '{print $2}'`
    bios=`cat $FILE|grep BIOS:| grep -v "\[ERR\]"|awk -F: '{print $2}'`
    mb_cpld=`cat $FILE|grep MB_CPLD:| grep -v "\[ERR\]"|awk -F: '{print $2}'`
    bootrom=`cat $FILE|grep BOOTROM|awk -F: '{print $2}'`
    exp=`cat $FILE|grep EXP|grep "CPLD:"|awk -F: '{print $2}'`
    exp_u=`cat $FILE|grep EXP|grep 4U|awk -F: '{print $2}'`
    pangeaver=`cat $FILE|grep PANGEA_Version|awk -F: '{print $2}'`
    productver=`cat $FILE|grep ExternalVersion|awk -F: '{print $2}'`
    compver=`cat $FILE|grep ComponentVersion|awk -F: '{print $2}'`
    sphver=`cat $FILE|grep SphVersion|awk -F: '{print $2}'`
    funcversion=`cat $FILE|grep FuncVersion|awk -F: '{print $2}'`
    clusterversion=`cat $FILE|grep ClusterVersion|awk -F: '{print $2}'`
    iob=`cat $FILE|grep -w IOB|awk -F: '{print $2}'`
    iobcpld=`cat $FILE|grep IOBCPLD|awk -F: '{print $2}'`
    bbu=`cat $FILE|grep BBU|awk -F: '{print $2}'`

    if [ $ProductType -eq 80 ] || [ $ProductType -eq 91 ];then
        #UDSSFSʹõͨ÷ BOOTROM EXP_CPLD PANGEA_Version汾
        Result="Node:$IP||NodeHardwareType:${nodeHardwareType}||NodeVersion:$funcversion ||ClusterVersion:$clusterversion || Netcard:$netcard|| Nvdimm:$nvdimm||OFED:$ofed|| Sascard:$sascard|| BMC:$bmc|| BIOS:$bios|| MB_CPLD:$mb_cpld||ProductVersion:$productver||SphVersion:$sphver|| EXP_CPLD(4U):$exp_u||ComponentVersion:$compver||IOB:$iob||IOBCPLD:$iobcpld||BBU:$bbu"
    else
        Result="Node:$IP||NodeHardwareType:${nodeHardwareType}||NodeVersion:$funcversion ||ClusterVersion:$clusterversion || Netcard:$netcard|| Nvdimm:$nvdimm||OFED:$ofed|| Sascard:$sascard|| BMC:$bmc|| BIOS:$bios|| MB_CPLD:$mb_cpld|| BOOTROM:$bootrom|| EXP_CPLD:$exp||ProductVersion:$productver||EXP_CPLD(4U):$exp_u||SphVersion:$sphver||PANGEA_Version:$pangeaver||ComponentVersion:$compver||IOB:$iob||IOBCPLD:$iobcpld||BBU:$bbu"
    fi
    WRITE_XML_COMMON 0 "$Result"
    LOG "$Result"
    if [ "${funcversion}" != "${clusterversion}" ];then
        WRITE_XML_ERROR 0 "Node:$IP||INFO:NodeVersion($funcversion) is not equal ClusterVersion($clusterversion)."
        LOG "[$FUNCNAME][$LINENO]IP:$IP NodeVersion:$funcversion is not equal ClusterVersion:$clusterversion."
        return 1
    fi
    return 0
}
#ԶִǷ
function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid="$$$2"
    local err_info=$3
    for time in ${RepeatTimes[*]}; do
        local proresult=`/opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid`
        local iRet=$?
        if [ $iRet -eq 101 ] || [ $iRet -eq 107 ] || [ "X${proresult}" == "X" ]; then
            LOG "[${FUNCNAME}]IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:{$le_pid},Return:$iRet,TryTimes:$time"
            sleep 10
        else
            break
        fi
    done

    local process=`echo $proresult | awk '{print $1}'`
    local errno=`echo $proresult | awk '{print $4}'`

    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #ѯִгɹԶû
    elif [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid},exec(get progress) failed.iRet($iRet)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to get command result."
        return 1    #ѯִʧ
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        LOG "[$FUNCNAME] IP:$remote_ip,le_pid:${le_pid}, exec(get progress) success.iRet($iRet),errno($errno),process($process)"
        return 2    #ɹɣ˴Ҫ0Ϊɹ
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid}, exec(get progress) failed.iRet($iRet) errno($errno)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 3    #Զִʧ
    elif [ "$process" = "" ] && [ "$errno" = "" ];then
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid}, exec(get progress) failed.process(null), ip not accessed"
        return 5    #ʱ
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid}, exec(get progress) failed.process(null)"
        return 0    #ݴ
    else
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid}, exec(get progress) failed. Undefined error info"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 4    #δ
    fi
}

#һѽڵ첽ִУҪ׼ REMOTE_IP_S
function remote_exec_async_batch
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}

    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$3"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command ($4). Error(${iRet})."
            ret=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}

#Զ̵MML
function remote_exec_async_batch_mml
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}
    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$G_MML_FILE_PATH/$3 $Item > $G_REMOTE_TMP_FILE$4 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command ($3)."
            ret=1
        else
            cat $G_REMOTE_TMP_FILE$FUNCNAME | sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}

function remote_download_sync
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
        iRet=$?
        LOG "[$FUNCNAME] download $remote_file from $remote_ip to $local_file item:${G_CHECK_IDLIST} Return:($iRet) TryTimes:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $local_file 2>&1
            break
        fi
    done

    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to get execute result (download file($remote_file) failed from $remote_ip)."
    fi

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi
    return $iRet
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    eval "read -u $FIFO_OPERATE_ID"
    {
        for time in ${RepeatTimes[*]}; do
            /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
            iRet=$?
            LOG "[$FUNCNAME] download $remote_file from $remote_ip to $local_file item:${G_CHECK_IDLIST} Return:$iRet TryTimes:$time"
            if [ $iRet -eq 101 ]; then
                sleep 10
            else
                sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $local_file 2>&1
                break
            fi
        done

        eval "echo >& $FIFO_OPERATE_ID"
    }

    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to get execute result (download file($remote_file) failed from $remote_ip)."
    fi

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi

    return $iRet
}

#Զ˷أ[ERR]ʶ
handle_remote_result()
{
    local line=$1
    echo "$line" |grep "\[ERR\]" > /dev/null
    if [ $? -eq 0 ]; then
        echo "$line" | awk -F] '{print $2}'
        return 1
    fi

    echo "$line"
    return 0
}

#104. Դ״̬
checkPowerStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local iRet=0

    #ʽPower_ID: %s || parent_ID: %s || Health_Status: %d || Running_Status: %d || Power_type: %d || Vendor: %s || Model: %s || Version: %s || ProduceDate: %s || SN: %s
    #ʽPower_Count:2

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:$(hostname)||INFO:Can't get backend IP."
            isPass=1
            break
        fi

        #״̬
        IsStandardNode
        if [ $? -eq 0 ];then
            WRITE_XML_COMMON 0 "Node:${back_ip}||INFO:This is VM. Do not involve to inspect."
            isPass=3
            break
        fi

        #ִmml cm power
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm power"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]$Info"
            errResult="Node:$back_ip||INFO:Failed to execute command(MmlBatch 4016 'cm power'). Error(${iRet})."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Power_ID"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "$javaID" = "" ];then
            errResult="Node:$back_ip||INFO:Get Power information from command(MmlBatch 4016 'cm power') failed."
            isPass=1
            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi

        set_ifs
        for line in $javaID; do
            if [ "$line" = "" ];then
                continue
            fi

            ID=`echo $line |awk '{print $2}'`
            parentID=`echo $line |awk '{print $5}'`

            cat $NID_ROLE_FILE | grep -wq $parentID >>/dev/null
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]iRet=$iRet,parentID=$parentID is not OK"
                continue
            fi
            parentIP=`get_node_backnet_ip $parentID`

            healthStatus=`echo $line |awk '{print $8}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`

            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            powerType=`echo $line |awk '{print $14}'`
            powerType=`MapPowerType $powerType`

            if [ "$runningStatus" = "NOT_EXIST" ];then
                powerType="--"
            fi

            vendor=`echo $line | awk -F: '{print $7}'|sed 's/|| Model//'`
            echo "$vendor"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                vendor="--"
            fi
            model=`echo $line |awk -F: '{print $8}'|sed 's/|| Version//'`
            echo "$model"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                model="--"
            fi
            version=`echo $line |awk -F: '{print $9}'|sed 's/|| ProduceDate//'`
            echo "$version"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                version="--"
            fi
            produceDate=`echo $line |awk -F\| '{print $17}'|awk '{print $2,$3,$4,$5,$6,$7 }'`
            echo "$produceDate"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                produceDate="--"
            fi
            SN=`echo $line |awk -F\| '{print $19}' |awk '{print $2}'`
            echo "$SN"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                SN="--"
            fi

            Result="ID:$ID||parentID:$parentID||nodeIP:$parentIP||healthStatus:$healthStatus||runningStatus:$runningStatus||powerType:$powerType||vendor:$vendor||model:$model||version:$version||produceDate:$produceDate||SN:$SN"
            WRITE_XML_COMMON 0 "$Result"
            if [ "$runningStatus" != "ONLINE" -a "$runningStatus" != "NORMAL" ] || [ "$healthStatus" != "NORMAL" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$parentIP||INFO:$ID Power runningStatus(${runningStatus}) or healthStatus(${healthStatus}) is not NORMAL!"
            fi
        done

        #жϱ׼нڵ붼˫Դ
        #жÿڵĵԴǷ2
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Power_Count"|sed 's/^ *//g'|sed "/^$/d"`
        for line in $javaID; do
            if [ $line = "" ];then
                continue
            fi

            count=`echo $line |awk -F: '{print $2}'`
            if [ "$count" != "2" ];then
                isPass=1
                errResult="Node:--||INFO:Power number count is not 2 ($line)."
            fi
        done

        restore_ifs
        break
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#105. ״̬
checkFanStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""
    local FirstString=""
    local line=""
    local new_line=""
    local iRet=0
    local allnid=""

    #ʽFan_ID: 15496.1 || Fan_Name: FAN1 || parent_ID: 15496 || Health_Status: 1 || Running_Status: 1 || Running_Level: 1 || Elabel: 02G098Z0C2000101 || Speed: 5029
    #ʽFan_ID: 15496.2 || Fan_Name: FAN2 || parent_ID: 15496 || Health_Status: 1 || Running_Status: 1 || Running_Level: 1 || Elabel: 02G098Z0C2000101 || Speed: 5076
    #ʽFan_Count:2
    allnid=$(cat $NID_ROLE_FILE)
    LOG "[$FUNCNAME][$LINENO]allnid=$allnid"
    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:$(hostname)||INFO:Can't get backend IP."
            isPass=1
            break
        fi

        #״̬
        IsStandardNode
        if [ $? -eq 0 ];then
            WRITE_XML_COMMON 0 "This is VM. Do not involve to inspect."
            isPass=3
            break
        fi
        #ִmmlcm fan
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm fan"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]$Info"
            errResult="Node:$back_ip||INFO:Failed to execute command(MmlBatch 4016 'cm fan'). Error(${iRet})."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Fan_ID"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "$javaID" = "" ];then
            errResult="Node:$back_ip||INFO:Get fan information from command(MmlBatch 4016 'cm fan') failed."
            isPass=1

            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi

        set_ifs
        for line in $javaID; do
            if [ $line = "" ];then
                continue
            fi

            #жϵһַǲǡFan_IDstart/time:08:13:35.277086 | clock:58435.277136Fan_ID: 14087.1 || Fan_Name:
            FirstString=`echo $line | awk '{print $1}'`
            if [ "$FirstString" != "Fan_ID:" ]; then
               new_line=`echo $line | awk -F"Fan_ID" '{print $2}'`
               LOG "[$FUNCNAME]:old_line:($line), new_line:($new_line)"
               line=$new_line
            fi
            ID=`echo $line |awk '{print $2}'`


            NAME=$(echo "${line}" | awk -F'\\|\\|' '{print $2}' | awk -F':' '{print $2}' | tr -d ' ')
            parentID=$(echo "${line}" | awk -F'\\|\\|' '{print $3}' | awk -F':' '{print $2}' | tr -d ' ')
            cat $NID_ROLE_FILE | grep -wq $parentID >>/dev/null
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]iRet=$iRet,parentID=$parentID is not OK"
                continue
            fi
            #parentIDIP
            parentIP=`get_node_backnet_ip $parentID`

            healthStatus=$(echo "${line}" | awk -F'\\|\\|' '{print $4}' | awk -F':' '{print $2}' | tr -d ' ')
            runningStatus=$(echo "${line}" | awk -F'\\|\\|' '{print $5}' | awk -F':' '{print $2}' | tr -d ' ')

            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            level=$(echo "${line}" | awk -F'\\|\\|' '{print $6}' | awk -F':' '{print $2}' | tr -d ' ')
            elabel=$(echo "${line}" | awk -F'\\|\\|' '{print $7}' | awk -F':' '{print $2}' | tr -d ' ')
            speed=$(echo "${line}" | awk -F'\\|\\|' '{print $8}' | awk -F':' '{print $2}' | tr -d ' ')
            Result="ID:$ID||name:$NAME||parentID:$parentID||nodeIP:$parentIP||healthStatus:$healthStatus||runningStatus:$runningStatus||level:$level||elabel:$elabel||speed(RPM):$speed"
            WRITE_XML_COMMON 0 "$Result"
            if [ "$runningStatus" != "NORMAL" ] || [ "$healthStatus" != "NORMAL" ];then
                WRITE_XML_ERROR 0 "Node:$parentIP||INFO:$ID Fan runningStatus(${runningStatus}) or healthStatus(${healthStatus}) is not NORMAL!"
                LOG "[$FUNCNAME] ${parentIP}-$ID runningStatus(${runningStatus}) or healthStatus(${healthStatus}) is not NORMAL!"
                isPass=1
            fi

        done
        restore_ifs
        #жÿڵķǷ2511
        for nid in $allnid ; do
            if [ $nid = "" ];then
                continue
            fi
            count=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Fan_ID"|sed 's/^ *//g'|sed "/^$/d" | grep -w "parent_ID: $nid"|wc -l)

            if [ "$count" != "2" ] && [ "$count" != "5" ] && [ "$count" != "11" ] && [ "$count" != "8" ] && [ "$count" != "4" ]; then
                errResult="Node:$nid(NID)||INFO: FAN number($count) is not 2, 4, 5, 8 or 11!||${errResult}"
                LOG "[$FUNCNAME] $nid Error: FAN number($count) is not 2, 4, 5, 8 or 11!"
                isPass=1
            fi
        done

        break
    done

    #жϱ׼ȫȣ2511λ
    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#108. ڵ״̬
checkNodeStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local isPass=0
    local iRet=0
    #Begin: ip޸Ϊ˽ip 2019/8/26
    #ʽNode_ID: 15425 || Node_Name: node65 || Health_Status: 1 || Running_Status: 2 || Frame: a1 || Slot: 1 || SN: 210235G78PZ0C8000011 || Device_Type: 33 || Manufacture: Huawei Technologies Co., Ltd. || Firmware_Version: V100R001C00 || Bussiness_IP: ["192.168.60.65","192.168.59.65"] || Manage_IP: 192.168.100.120 || Function_Type: 0 || Time: 0 || Time_zone:  || DevMgrIP: 192.168.60.165 || Tier_ID: 1
    #End: ip޸Ϊ˽ip 2019/8/26

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:$(hostname)||INFO:Can't get backend IP."
            isPass=1
            break
        fi

        #ִmmlcm node
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm node"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ ${iRet} -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            errResult="Node:$back_ip||INFO:Failed to execute command(MmlBatch 4016 'cm node').Error(${iRet})."
            LOG "[$FUNCNAME] $back_ip:Can not get information.exec(cm node) failed!Info($Info)"

            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Node_ID"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "$javaID" = "" ];then
            errResult="Node:-||INFO:Get node information from command(MmlBatch 4016 'cm node') failed.||${errResult}"
            LOG "[$FUNCNAME] $back_ip get javaID(javaID) failed!"
            isPass=1

            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi

        set_ifs
        for line in $javaID; do
            if [ $line = "" ];then
                continue
            fi

            ID=`echo $line |awk '{print $2}'`
            if [[ ! "${ID}" =~ ^[0-9]+$ ]]; then
                continue
            fi
            NAME=`echo $line |awk '{print $5}'`
            healthStatus=`echo $line |awk '{print $8}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
            parentIP=$(get_node_backnet_ip $ID)
            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            frame=`echo $line |awk '{print $14}'`
            slot=`echo $line |awk '{print $17}'`
            SN=`echo $line |awk '{print $20}'`
            typeid=`echo $line |awk '{print $23}'`
            nodeTypeid=`echo $line |grep -Po '(?<=Function_Type: )[0-9]*' |tr -d ' '`
            type=$(MapNodeType  $nodeTypeid)
            Result="ID:$ID||name:$NAME||parentIP:$parentIP||healthStatus:$healthStatus||runningStatus:$runningStatus||Frame:$frame||Slot:$slot||SN:$SN||Type:$type"
            LOG "[$FUNCNAME] $Result||typeid:$typeid"

            WRITE_XML_COMMON 0 "$Result"
            if [ "$runningStatus" != "ONLINE" ] || [ "$healthStatus" != "NORMAL" ];then
                isPass=1
                errResult="Node:$ID||INFO:HealthStatus($healthStatus) is not NORMAL or runningStatus($runningStatus) is not ONLINE.||${errResult}"
                LOG "[$FUNCNAME] $ID healthStatus($healthStatus) is not NORMAL or runningStatus($runningStatus) is not ONLINE."
            fi
        done

        restore_ifs
        break
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#112. ģ״̬⹦쳣㲻ͨʵֲμ澯
checkFiber_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local errResult=""
    local isPass=0
    local fiberInfo=""
    local iRet=0

    #ʽFiber_ID: %s || parent_ID: %s || location: %s || Health_Status: %d || Running_Status: %d || ModeType: %d || Identifier: %d  || WaveLen: %d || RX_Power: [%d %d %d %d] || TX_Power: [%d %d %d %d] || Speed(MB/s): %d || Temperature: %d || Voltage: %d || Vendor: %s || Model: %s || SN: %s || Node_Type: %s || NetCard_Manufacturer: %s
    #ʽFiber_Count: %d || Node_ID: %s || Node_Type: %s || NetCard_Manufacturer: %s

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:$(hostname)||INFO:Can't get backend IP."
            isPass=1
            break
        fi

        local is_lite_node=`get_cluster_lite_deploy`
        if [ $is_lite_node -eq 0 ]; then
            WRITE_XML_COMMON 0 "Node:$back_ip||INFO:It's lite node, Do not involve to inspect."
            break
        fi

        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm fiberinfo show" >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g'`
            errResult="Node:$back_ip||INFO:Failed to execute command(MmlBatch 4016 'cm fiberinfo show').Error(${iRet})!||${errResult}"
            LOG "[$FUNCNAME]$back_ip:Failed to execute command(MmlBatch 4016 'cm fiberinfo show').Error(${iRet})!Info($Info)."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME >/dev/null 2>&1
        sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' ${G_REMOTE_TMP_FILE}$FUNCNAME >/dev/null 2>&1
        #Fiber_Count: 0 || Node_ID: 124 || Node_Type: C36 || NetCard_Manufacturer: Intel
        fiberInfo=`grep "Fiber_Count" $G_REMOTE_TMP_FILE$FUNCNAME |sed 's/^ *//g'|sed "/^$/d"`

        if [ "$fiberInfo" = "" ];then
            errResult="Node:$back_ip||INFO:Get fiber count from command(MmlBatch 4016 'cm fiberinfo show') failed.||${errResult}"
            LOG "[$FUNCNAME]$back_ip:get Fiber_Count failed!"
            isPass=1
            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi

        set_ifs
        for line in $fiberInfo; do
            if [ "$line" = "" ];then
                continue
            fi
            count=`echo "$line" |awk '{print $2}'`
            nodeID=`echo "$line" |awk '{print $5}'`
            cat $NID_ROLE_FILE | grep -wq $nodeID >>/dev/null
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]iRet=$iRet,nodeID=$nodeID is not OK"
                continue
            fi
            nodeType=`echo "$line" |awk '{print $8}'`
            netCardManufacturer=`echo "$line" |awk '{print $11}'`
            nodeIP=`get_node_backnet_ip $nodeID`
            if [ "$count" = "0" ];then
                Result="Node:$nodeIP(Node type: $nodeType node, network card: $netCardManufacturer)||ID:No optical module ||parentID:--||location:--||healthStatus:--||runningStatus:--||modeType:--||waveLen:--||RX_Power:--||TX_Power:--||Speed(Gb/s):--||Temperature:--||Voltage:--||Vendor:--||Model:--||SN:--"
                WRITE_XML_COMMON 0 "$Result"
                LOG "[$FUNCNAME]-:no Fiber exists!count($count)."
            fi
        done

        fiberInfo=`grep "Fiber_ID" $G_REMOTE_TMP_FILE$FUNCNAME |sed 's/^ *//g'|sed "/^$/d"`

        for line in $fiberInfo; do
            if [ "$line" = "" ];then
                continue
            fi

            ID=`echo "$line" |awk '{print $2}'`
            parentID=`echo "$line" |awk '{print $5}'`
            cat $NID_ROLE_FILE | grep -wq $parentID >>/dev/null
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]iRet=$iRet,parentIP=$parentIP is not OK"
                continue
            fi
            #parentIDIP
            parentIP=`get_node_backnet_ip $parentID`
            location=`echo "$line" |awk '{print $8}'`
            healthStatus=`echo "$line" |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo "$line" |awk '{print $14}'|sed 's/^ *//g'|sed "/^$/d"`

            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            modeType=`echo "$line" |awk '{print $17}'`
            Identifier=`echo "$line" |awk '{print $20}'`  #ģЭ1 SFP, 3 QSFP+

            waveLen=`echo "$line" |awk '{print $23}'`
            Vendor=`echo "$line" |awk '{print $51}'`
            Speed=`echo "$line" |awk '{print $42}'`

            Voltage=`echo "$line" |awk '{print $48}'`
            Temperature=`echo "$line" |awk '{print $45}'`
            #շ⹦Ϊ4ֵͨ
            RX_Power1=`echo "$line" |awk '{print $27}'`
            RX_Power2=`echo "$line" |awk '{print $28}'`
            RX_Power3=`echo "$line" |awk '{print $29}'`
            RX_Power4=`echo "$line" |awk '{print $30}'`

            TX_Power1=`echo "$line" |awk '{print $35}'`
            TX_Power2=`echo "$line" |awk '{print $36}'`
            TX_Power3=`echo "$line" |awk '{print $37}'`
            TX_Power4=`echo "$line" |awk '{print $38}'`

            if [ $Voltage = "0" -a $Temperature = "0"];then
                Voltage="--"
                Temperature="--"
            fi

            Model=`echo "$line" | awk -F'Model:' '{print $2}'|awk '{print $1}'`
            SN=`echo "$line" | awk -F'SN:' '{print $2}'|awk '{print $1}'`
            nodeType=`echo "$line" | awk -F'Node_Type:' '{print $2}'|awk '{print $1}'`
            netCardManufacturer=`echo "$line" | awk -F'NetCard_Manufacturer:' '{print $2}'|awk '{print $1}'`

            Result="Node:$parentIP(Node type: $nodeType node, network card: $netCardManufacturer)||ID:$ID||parentID:$parentID||location:$location||healthStatus:$healthStatus||runningStatus:$runningStatus||modeType:$modeType||waveLen:$waveLen||RX_Power:[$RX_Power1 $RX_Power2 $RX_Power3 $RX_Power4]||TX_Power:[$TX_Power1 $TX_Power2 $TX_Power3 $TX_Power4]||Speed(Gb/s):$Speed||Temperature:$Temperature||Voltage:$Voltage||Vendor:$Vendor||Model:$Model||SN:$SN"

            WRITE_XML_COMMON 0 "$Result"
            if [ "$runningStatus" != "NORMAL" ] ||[ "$healthStatus" != "NORMAL" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$parentIP||INFO:ID($ID) RunningStatus($runningStatus) or HealthStatus($healthStatus) is not NORMAL."
            fi
        done

        restore_ifs
        break
    done

    if [ "" != "${errResult}" ];then
        WRITE_XML_ERROR 0 "$errResult"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#119 汾һ
checkNodeVersion()
 {
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local TASK_ID=0
    local iRet=0
    #T3000C72֮ĽڵҪӷ֧
    local NodetypeChecklist=""
    typelistfile="${G_TMP_INSPECT_PATH}tmptypelistfiletmp"
    ALLIp=`cat $IP_ROLE_FILE`

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/GetNodeVersion > $G_REMOTE_TMP_FILE$FUNCNAME" "/opt/product/snas/script/inspect_mml/GetNodeVersion"
    iRet=$?
    if [ 0 -ne $iRet ];then
        isPass=1
    fi
    ValidIP=`cat ${VALID_IP_FILE}`

    local upgradeFlag=0
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "GetNodeVersion"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by(GetNodeVersion). Error(${iRet})."
                LOG "Node: $Item||INFO: remote download file failed."
                echo "FlagDownfail" >> $G_TMP_FILE$Item 2>&1
                continue;
            fi
            errInfo=$(grep "\[ERR\]" $G_TMP_FILE$Item | awk -F] '{print $2}')
            if [[ "${errInfo}" != "" ]];then
                isPass=$(check_pass $isPass 1)
                sed -i '/\[ERR\]/d' $G_TMP_FILE$Item
                set_ifs
                for line in $errInfo; do
                    WRITE_XML_ERROR 0 "Node:$Item||${line}"
                done
                restore_ifs
            fi

            local tmpUpgradeFlag=$(cat $G_TMP_FILE$Item | grep UpgradeFlag | awk -F: '{print $2}')
            if [ "X$tmpUpgradeFlag" != "X" ] && [ $tmpUpgradeFlag -gt $upgradeFlag ];then
                upgradeFlag=$tmpUpgradeFlag
            fi
            ClusterUpdStatus=$(cat $G_TMP_FILE$Item | grep ClusterUpdStatus | awk -F: '{print $2}')
            if [ "X$ClusterUpdStatus" != "X0" ];then
                isPass=$(check_pass $isPass 1)
                LOG "[$FUNCNAME][$LINENO]IP:$Item ClusterUpdStatus:$ClusterUpdStatus is not equal 0."
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:ClusterUpdStatus $ClusterUpdStatus is not equal 0."
            fi
            #ʱ
            sed -i '/UpgradeFlag/d' $G_TMP_FILE$Item
            sed -i '/ClusterUpdStatus/d' $G_TMP_FILE$Item

            #ȡڵ
            devicetype=`cat $G_TMP_FILE$Item | grep devicetype | awk -F: '{sub("^[ \t]*","",$2);print $2}'`
            LOG "devicetype=[$devicetype]"
            echo ${NodetypeChecklist} |grep -w "${devicetype}"
            isFind=$?
            if [ 0 -ne ${isFind} ];then
                NodetypeChecklist="${NodetypeChecklist}"" ${devicetype}"
            fi
            echo "devicetype=$devicetype;IP=$Item"  >> $typelistfile
            LOG "devicetype=$devicetype;IP=$Item"
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
    wait
    fifo_finish

    if [ $upgradeFlag -eq 1 ];then
        isPass=$(check_pass $isPass 1)
        WRITE_XML_ERROR 0 "Node:master||INFO:The cluster version in the memory is not updated."
    fi

    #ֽͬڵȽ
    for Tmptype in ${NodetypeChecklist};do
        filter="^devicetype=$Tmptype;"
        mastFlag=0
        mastIP=""
        mastefile=""
        for line in `cat $typelistfile | grep $filter` ;do
            LOG "[$FUNCNAME] rh compare line info[line=$line]."
            tmpIP=`echo $line | awk -F ";" '{print $2}' | awk -F "=" '{print $2}'`
            if [ $mastFlag -eq 0 ];then
                mastefile=$G_TMP_FILE$tmpIP
                mastIP=$tmpIP
                
                # ͬһ͵ĽڵϢӡһ
                print_NodeVersion ${mastefile} ${mastIP} ${Tmptype}
                iRet=$?
                if [ 0 -ne $iRet ];then
                    isPass=$(check_pass $isPass 4)
                fi
                
                mastFlag=1
                LOG "master file=$mastefile"
                continue
            fi
            
            print_NodeVersion ${G_TMP_FILE}${tmpIP} ${tmpIP} ${Tmptype}
            iRet=$?
            if [ 0 -ne $iRet ];then
                isPass=$(check_pass $isPass 4)
            fi
            diff $mastefile $G_TMP_FILE$tmpIP > /dev/null
            if [ 0 -ne $? ]; then
                isPass=$(check_pass $isPass 4)
                WRITE_XML_ERROR 0 "Node:$tmpIP||INFO:Some hardware version is not same with $mastIP.(NodeHardwareType:${Tmptype})."
                LOG "[$FUNCNAME] Some hardware version is not same between $mastIP and $tmpIP."
                continue
            fi
        done
    done

    [ -f "${typelistfile}" ] && rm -rf "$typelistfile"

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#120. Modmem״̬
checkModmemtatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local index=0
    local failedIp=""
    local iRet=0
    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            WRITE_XML_ERROR 0 "Node:$(hostname)||INFO:Can't get backend IP."
            isPass=1
            break
        fi

        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm modemstat" |sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            WRITE_XML_ERROR 0 "Node:$back_ip||INFO:Failed to execute command(MmlBatch 4016 'cm modemstat'). Error(${iRet})."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #mml>>>NodeID:xxx
        NodeIDs=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep NodeID |awk '{print $1}'|sed 's/^.*NodeID://g'|tr -d " "`
        if [ "X${NodeIDs}" = "X" ];then
            failedIp="$back_ip ${failedIp}"
            index=$((index + 1))
            if [ $index -gt 10 ];then
                isPass=1
                WRITE_XML_ERROR 0 "INFO:Get ModemStatus failed in ${failedIp}."
                break
            fi
            continue
        fi
        for nodeid in $NodeIDs
        do
            parentIP=`get_node_backnet_ip $nodeid`
            Result=$(grep -w $nodeid $G_REMOTE_TMP_FILE$FUNCNAME |grep -Po '(?<=ModemStatus:)[a-zA-Z]*' |tr -d ' ')
            if [ $? -eq 0 ]; then
                if [ "$Result" == "Running" ]; then
                    Status="Running"
                elif [ "$Result" == "NotRunning" ]; then
                    isPass=1
                    Status="NotRunning"
                    WRITE_XML_ERROR 0 "Node:$parentIP||INFO:$nodeid Status is NotRunning."
                elif [ "$Result" == "NotExisted" ]; then
                    Status="NotExisted"
                else
                    isPass=1
                    Status="Unknown"
                    WRITE_XML_ERROR 0 "Node:$parentIP||INFO:$nodeid Status is Unknown."
                fi
            else
                isPass=1
                Status="Unknown"
                WRITE_XML_ERROR 0 "Node:$parentIP||INFO:$nodeid Status is Unknown."
            fi
            Result="Node:$parentIP||NodeID:$nodeid||Status:$Status"
            WRITE_XML_COMMON 0 "$Result"
        done
        break

    done

    if [ "$isPass" != "0" ];then
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#121. ڵʱͬ
checkNodeTime()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local Result=""
    local errResult=""
    local tmpMax=0
    local tmpMin=0
    local tmpdiff=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    index=0;
    for Item in $REMOTE_IP_S; do
    localTime=`date +%s`
        set_ifs
        remoteResult=`remote_exec $Item 30 "date +%s"`
        iRet=$?

        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] $Item Failed to execute(checkNodeTime) command.iRet($iRet)"
            isPass=1
            Result="NodeIp:$Item||INFO:Failed to execute command(date +%s)."
            WRITE_XML_ERROR 0 "$Result"
        else
            timeDelta=`expr $remoteResult - $localTime`
            if [ ${timeDelta} -gt 10 ];then
                isPass=1
                WRITE_XML_ERROR 0 "NodeIp:$Item||INFO:DiffTime(s)$timeDelta is great than 10."
            fi
            if [ ${timeDelta} -lt -10 ];then
                isPass=1
                WRITE_XML_ERROR 0 "NodeIp:$Item||INFO:DiffTime(s)$((0-$timeDelta)) is great than 10."
            fi
            #get the biggest diff
            if [ ${timeDelta} -gt ${tmpMax} ];then
                tmpMax=${timeDelta}
            fi
            #get the smallest diff
            if [ ${timeDelta} -lt ${tmpMin} ];then
                tmpMin=${timeDelta}
            fi
            Result="NodeIp:$Item||DiffTime(s):$timeDelta"
            WRITE_XML_COMMON 0 "$Result"
        fi
        restore_ifs

        done

    tmpdiff=`expr ${tmpMax} - ${tmpMin}`
    if [ ${tmpdiff} -gt 10 ];then
        isPass=1
        WRITE_XML_ERROR 0 "INFO:DiffTime(s) between max(${tmpMax}) and min(${tmpMin}) is great than 10."
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#129ӲFW汾
checkDiskFwVersion()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local errResult=""
    local isPass=0
    local ShowFlag=0
    local diskModel=""
    local diskFW=""
    local numDiskFW=0
    local iRet=0

    while true;do
        local back_ip=$(get_backnet_ip)
        if [ "${back_ip}" = "" ]; then
            errResult="Node:$(hostname)||INFO:Can't get backend IP."
            LOG "[$FUNCNAME]:${errResult}"
            isPass=1
            break
        fi

        #ִmml cm diskinfo show
        ${G_MML_FILE_PATH}/ShowInspectMml ${back_ip} 4016 "cm diskinfo"  > ${G_REMOTE_TMP_FILE}${FUNCNAME} 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=$(cat ${G_REMOTE_TMP_FILE}${FUNCNAME})
            LOG "[${FUNCNAME}]${Info}"
            errResult="NodeIp:${back_ip}||INFO:Failed to execute command(MmlBatch 4016 'cm diskinfo'). Error(${iRet})."
            isPass=1
            break
        fi

        lines=$(cat ${G_REMOTE_TMP_FILE}${FUNCNAME} | grep "Disk_ID" | sed 's/^ *//g' | sed "/^$/d" | tr -d "\r")
        if [ "${lines}" == "" ];then
            errResult="NodeIp:${back_ip}||INFO:Get disk information from command(MmlBatch 4016 'cm diskinfo') failed."
            isPass=1
            LOG "[${FUNCNAME}]:${errResult}"
            cat ${G_REMOTE_TMP_FILE}${FUNCNAME} >> ${LOG_FILE} 2>&1
            break
        fi

        set_ifs
        for line in ${lines}; do
            ShowFlag=0
            if [ "${line}" = "" ];then
                continue
            fi
            ID=$(echo "${line}" | awk -F'\\|\\|' '{print $1}' | awk -F':' '{print $2}' | tr -d ' ')
            diskModel=$(echo "${line}" | awk -F'\\|\\|' '{print $10}' | awk -F':' '{print $2}' | tr -d ' ')
            diskFW=$(echo "${line}" | awk -F'\\|\\|' '{print $11}' | awk -F':' '{print $2}' | tr -d ' ')
            diskNeedUpg=$(echo ${line} | awk -F'\\|\\|' '{print $16}' | awk -F':' '{print $2}' | tr -d ' ')
            diskUpgStrategy=$(echo ${line} | awk -F'\\|\\|' '{print $17}' | awk -F':' '{print $2}' | tr -d ' ')

            Running_Status=$(echo ${line} | awk -F'\\|\\|' '{print $5}' | awk -F':' '{print $2}' | tr -d ' ')
            if [ "4" = "${Running_Status}" ]; then
                continue
            fi

            #Disk that Models are ST1200MM0129,ST1800MM0129,ST2400MM0129 and FWversions are C001,C0B1,C003 need upgrade
            if [ "${diskModel}" = "ST1200MM0129" -o "${diskModel}" = "ST1800MM0129" -o "${diskModel}" = "ST2400MM0129" ]; then
                if [ "${diskFW}" = "C001" -o "${diskFW}" = "C0B1" -o "${diskFW}" = "C003" ]; then
                    diskNeedUpg="YES"
                    diskUpgStrategy="BLACK"
                    Result="ID:${ID}||DiskNeedUpg:${diskNeedUpg}||DiskUpgStrategy:${diskUpgStrategy}||DiskModel:${diskModel}||FWVersion:${diskFW}"
                    isPass=1
                    WRITE_XML_ERROR 0 "${Result}"
                    continue
                fi
            fi
            #Disk that Models are LT1800RO,LT0900RO and FWversions less equal than H506 need replace
            if [ "${diskModel}" = "LT1800RO" -o "${diskModel}" = "LT0900RO" ]; then
                numDiskFW=$(echo "${diskFW}" | sed 's/[^0-9]//g')
                if [ ${numDiskFW:-0} -le 506 ]; then
                    diskNeedUpg="YES"
                    diskUpgStrategy="BLACK"
                    Result="ID:${ID}||DiskNeedUpg:${diskNeedUpg}||DiskUpgStrategy:${diskUpgStrategy}||DiskModel:${diskModel}||FWVersion:${diskFW}"
                    isPass=1
                    WRITE_XML_ERROR 0 "${Result}"
                    continue
                fi
            fi
            #Disk that Models start with HSSD-D7,HWE6 and FWversions less than 6222 need replace
            if [[ "${diskModel}" =~ ^HSSD-D7 || "${diskModel}" =~ ^HWE6 ]]; then
                numDiskFW=$(echo "${diskFW}" | sed 's/[^0-9]//g')
                modelVersionList=(N P Q R S T U V W)
                modelVersion="0"
                if [[ "${diskModel}" =~ ^HSSD-D7 ]]; then
                    # HSSDϵModelŵ11λƬӿͣSATA̱־ǡS
                    typeFlag=${diskModel:10:1}
                    # HSSDϵModelŵ8λƬversion
                    modelVersion=${diskModel:7:1}
                    # HSSDSATA̲Ҫ
                    if [ ${typeFlag} == "S" ];then
                        continue
                    fi

                elif [[ "${diskModel}" =~ ^HWE6 ]]; then
                    # HWEϵModelŵ6-7λƬӿͣSATA̱־ǡST
                    typeFlag=${diskModel:5:2}
                    # HWEϵModelŵ15λƬversion
                    modelVersion=${diskModel:14:1}
                    # ES3000SATA̲Ҫ
                    if [ ${typeFlag} == "ST" ];then
                        continue
                    fi
                fi
 
                # жǷ6ϵ,6ϵ޷
                version6Flag=0
                for version6Value in "${modelVersionList[@]}"
                do
                    if [ ${modelVersion} == ${version6Value} ]; then
                        version6Flag=1
                        break
                    fi
                done

                if [[ ${numDiskFW:-0} -lt 6222 && ${version6Flag} == 0 ]]; then
                    diskNeedUpg="YES"
                    diskUpgStrategy="BLACK"
                    Result="ID:${ID}||DiskNeedUpg:${diskNeedUpg}||DiskUpgStrategy:${diskUpgStrategy}||DiskModel:${diskModel}||FWVersion:${diskFW}"
                    isPass=1
                    WRITE_XML_COMMON 0 "${Result}"
                    WRITE_XML_ERROR 0 "Node:${ID}||INFO:DiskModel:${diskModel},FWVersion:${diskFW} is less than 6222,need replace."
                    continue
                fi
            fi

            if [ "$diskNeedUpg" = "--" ] && [ "$diskUpgStrategy" = "--" ];then
                continue;
            fi

            Result="ID:${ID}||DiskNeedUpg:${diskNeedUpg}||DiskUpgStrategy:${diskUpgStrategy}||DiskModel:${diskModel}||FWVersion:${diskFW}"

            if [ "${diskUpgStrategy}" != "BLACK" -a "${diskUpgStrategy}" != "RED" ];then
                WRITE_XML_COMMON 0 "${Result}"
                continue
            fi

            if [ "${diskUpgStrategy}" == "BLACK" -a "${diskNeedUpg}" == "YES" ];then
                if [ "${isPass}" -ne 1 ];then
                    isPass=4
                fi
                ShowFlag=1
            fi

            if [ "${diskUpgStrategy}" == "RED" -a "${diskNeedUpg}" == "YES" ];then
                if [ "${isPass}" -ne 1 ];then
                    isPass=4
                fi
                ShowFlag=1
            fi

            if [ "${ShowFlag}" == "1" ];then
                WRITE_XML_ERROR 0 "${Result}"
            else
                WRITE_XML_COMMON 0 "${Result}"
            fi
        done
        break
        restore_ifs
    done
    if [ "${errResult}" != "" ]; then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE ${isPass}
    WRITE_XML_SUBCMD_TAIL
}

#131Ӳ
checkDisk()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        errResult="INFO:Can't get backend IP."
        LOG "[$FUNCNAME]:$errResult"
        isPass=1
        WRITE_XML_ERROR 0 "Node:$(hostname)||INFO:Can't get backend IP."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    local devicetypenum=$(cat /opt/huawei/deploy/etc/deploy.ini | grep devicetype |awk -F= '{print $2}')
    local devicetype=$(MapNodeType $devicetypenum)
    InspectIsFullFlash "${devicetype}"  # 0:ȫ1ȫ
    isFullFlash=$?

    $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm diskinfo" | sed 's/||/,/g' | awk -F ',' -v flag="$isFullFlash" '
    function printDiskType(type)
    {
        diskTypeName[0] = "FC"
        diskTypeName[1] = "SAS"
        diskTypeName[2] = "SATA"
        diskTypeName[3] = "SAS_SSD"
        diskTypeName[4] = "NL_SAS"
        diskTypeName[5] = "SLC_SSD"
        diskTypeName[6] = "MLC_SSD"
        diskTypeName[15] = "SMR_SATA"
        diskTypeName[16] = "NVME_SSD"
        diskTypeName[17] = "SATA_SSD"
        if (type>=0&&type<=17)
            printf("diskTpye=%s ", diskTypeName[type])
        else
            printf("%d ", type)
    }
    function printOneDiskResult()  #ӡһڵĽ
    {
        if (nodeID == -1 )
            return
        printf("nodeID=%d ",nodeID)
        printf("slotID=%s ",slotid)
        printDiskType(type)
        printf("diskSize=%d ",size)
        printf("diskFactory=%s ",facture)
        printf("\n")
    }
    function printOneNodeResult()  #ӡһڵĽ
    {
        if (nodeID == -1 )
        return
        printf("BLAG ")
    printf("nodeID=%d ",nodeID)
    printf("diskTypePass=%d ",length(diskType))
    printf("diskSizePass=%d ",length(diskSize))
    printf("diskManuFactoryPass=%d ",length(manuFacture))
    printf("\n")
    }
    function addVal2Array(val, arr)
    {
        for(i in arr)
    {
        if (arr[i] == val)
            return
    }
    printf("")
    arr[length(arr)] = val
    }
    BEGIN{nodeID=-1; slotid=""; type=-1; size=-1; facture=""; diskType[0]=-1; diskSize[0]=-1;manuFacture[0]="";}
    {
        do
    {
        if (!match($1, "Disk_ID:"))
                break;
        split($2, val, ":")   #parent_ID: xx
        nid = int(val[2])
        split($5, val, ":")   #Running_Status: x
        run = int(val[2])
        if (nid != nodeID)    #ʼһ½ڵ
        {
            if (nodeID!=-1)
            printOneNodeResult();   #ӡһڵĽ
        nodeID = nid
        delete diskType   #
        delete diskSize
        delete manuFacture
        }
        if (run == 4 || run == 0) #״̬Ϊںunknown
            break;

        split($6, val, ":")
        type = int(val[2])
            split($3, val, ":")
            slotid=val[2]
        split($14, val, ":")
        size = int(val[2])
            size = int(size/1024/1024/1024)
        split($12, val, ":")
        facture=val[2]
        if ((type == 3 || type == 17) && (flag != 0))#ȫ滷SSD
            break;
        if (type == 16) #NVME_SSDڴ˼
            break;
        #жͺʹСǷڣ
        addVal2Array(type, diskType)
        addVal2Array(size, diskSize)
        addVal2Array(facture, manuFacture)
            printOneDiskResult()
        } while(0)
    }
    END{
            printOneNodeResult()
        }' >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1


    dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
    set_ifs
    col=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "BLAG" |wc -l)
    if [ $col -eq 0 ]; then
        isPass=1
        WRITE_XML_ERROR 0 "Node:$back_ip||INFO:Get disk information from command(MmlBatch 4016 'cm diskinfo') failed."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    for ((i=1; i<=${col}; i++ ))
    do
        nid=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "BLAG" | awk "NR==$i" | awk -F= '{print $2}' |awk '{print $1}')
        disktype=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "BLAG" | awk "NR==$i" | awk -F= '{print $3}' |awk '{print $1}')
        disksize=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "BLAG" | awk "NR==$i" | awk -F= '{print $4}' |awk '{print $1}')
        if [ "$disktype" -gt 1 ] || [ "$disksize" -gt 1 ]; then
            isPass=4
        fi
    done
    if [ ${isPass} -eq 4 ];then
        WRITE_XML_ERROR 0 "INFO:DiskType or DiskSize number is great than 1."
    fi
    cat $G_REMOTE_TMP_FILE$FUNCNAME |grep -v "BLAG" |while read line
    do
        nid=$(echo $line |grep "nodeID" | awk -F= '{print $2}' |awk '{print $1}' )
        slotid=$(echo $line |grep "nodeID" | awk -F= '{print $3}' |awk '{print $1}' )
        type=$(echo $line |grep "nodeID"| awk -F= '{print $4}' |awk '{print $1}')
        size=$(echo $line |grep "nodeID" | awk -F= '{print $5}' |awk '{print $1}' )
        factory=$(echo $line |grep "nodeID" | awk -F= '{print $6}' |awk '{print $1}')
        Result="NodeID:$nid||SlotID:$slotid||DiskType:$type||DiskSize:$size(GB)||ManuFactory:$factory"
        WRITE_XML_COMMON 0 "$Result"
    done

    restore_ifs

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#ûдѲΪ
noInspectItem()
{
    WRITE_XML_SUBCMD_HEADER $1
    WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
    WRITE_XML_JUDGE 2
    WRITE_XML_SUBCMD_TAIL
}

function CompareIp()
{
    local iRet=0
    numa=$1
    numb=$2
    numa=$(echo $numa | sed 's/\.//g')
    numb=$(echo $numb | sed 's/\.//g')
    #ڵĵһIPСڵڶ1
    if [ $numa -lt $numb ];then
        iRet=1
    fi

    return $iRet
}

#142. ߼
checkEthNetLine()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local iRet=0
    local switchArray=()
    local IpArray=()
    local arraySize=0
    local count=0
    local TASK_ID=0
    local switch_big_Array=()
    local port_type_Array=()
    local cm_db="/opt/huawei/snas/etc/cm_swm_conf.db"

    LOG "[$FUNCNAME][$LINENO]start!"
    SWITCH_SMALL_FILE="${G_TMP_INSPECT_PATH}switch_small_file"
    ALL_SWITCH_IFNO="${G_TMP_INSPECT_PATH}tmpfileallswitchinfo"
    if [ -L "${SWITCH_SMALL_FILE}" ];then
        rm -f "${SWITCH_SMALL_FILE}"
    fi
    rm -f ${G_TMP_INSPECT_PATH}switch_small_file*
    if [ -L "${ALL_SWITCH_IFNO}" ];then
	    rm -f "${ALL_SWITCH_IFNO}"
    fi
    >$ALL_SWITCH_IFNO
    SWITCH_TOPO_FILE="/opt/huawei/snas/etc/switchTopo.ini"
    dos2unix $SWITCH_TOPO_FILE > /dev/null 2>&1

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            LOG "[$FUNCNAME][$LINENO]Can't get backend IP."
            isPass=1
            WRITE_XML_ERROR 0 "Node:$(hostname)||INFO:Can't get backend IP."
            break
        fi

        local is_lite_node=`get_cluster_lite_deploy`
        if [ $is_lite_node -eq 0 ]; then
            WRITE_XML_COMMON 0 "Node:$back_ip||INFO:It's lite node, Do not involve to inspect."
            break
        fi

        cp $SWITCH_TOPO_FILE ${G_TMP_INSPECT_PATH}tmpfileswitchTopo
        if [ $? -ne 0 ]; then
           LOG "[$FUNCNAME][$LINENO]Can't get the switch info"
           isPass=2
           WRITE_XML_ERROR 0 "INFO:Can't get switch information.(/opt/product/snas/etc/switchTopo.ini)"
           break
        fi
        REMOTE_IP_S=`cat $IP_ROLE_FILE`
        remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/CheckNetLine $back_ip 2>&1" "/opt/product/snas/script/inspect_mml/CheckNetLine"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            isPass=$iRet
        fi
        ValidIP=`cat ${VALID_IP_FILE}`
        ValidIPResult=$ValidIP

        LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
        fifo_start
        while [ "${ValidIP}" != "" ]; do
            >${VALID_IP_FILE}
 
            for Item in $ValidIP; do
                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "Failed to execute command(/opt/product/snas/script/inspect_mml/CheckNetLine)"
                iRet=$?
                if [ $iRet -eq 0 ]; then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 -a $iRet -ne 5 ]; then
                    isPass=1
                fi

                remote_download $Item $G_TMP_FILE$Item ${G_TMP_INSPECT_PATH}tmpfilecheckswitchinfo
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    errResult="Node:$Item||INFO:Failed to download file generated by command(CheckNetLine), Error(${iRet}).||${errResult}"
                    LOG "[$FUNCNAME][$LINENO] $Item exec(tmpfilecheckswitchinfo) failed.iRet($iRet),errno($errno),process(&process)"
                    isPass=1
                    continue
                fi
            done

            ValidIP=`cat ${VALID_IP_FILE}`
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi
            echo "" >> $G_TMP_FILE$Item
            cat $G_TMP_FILE$Item >> $ALL_SWITCH_IFNO 2>&1
        done
        tmp=$(cat $ALL_SWITCH_IFNO | grep "switchName\:NULL")
        if [ "$tmp" != "" ]; then
            local switchIdArray=$(/usr/bin/sqlite3 "${cm_db}" "select szSwId from CM_SWM_T")
            if [ -z "${switchIdArray}" ]; then
                isPass=3
                WRITE_XML_COMMON 0 "INFO:The switch is not configured so No switch info. Do not involve."
                WRITE_XML_JUDGE $isPass
                WRITE_XML_SUBCMD_TAIL
                [ -f "${SWITCH_SMALL_FILE}" ] && rm -f "${SWITCH_SMALL_FILE}"
                [ -f "${ALL_SWITCH_IFNO}" ] && rm -f "${ALL_SWITCH_IFNO}"
                rm -f ${G_TMP_INSPECT_PATH}tmpfileswitchTopo*
                return
            fi
        fi
        while read line; do
            arraySize=0
            for oneRec in $line;do
                isNode=$(echo $oneRec | awk -F ':' '{printf $1}')
                if [ "$isNode" = "nodeFunType" ]; then
                    nodeFunType=$(echo $oneRec | awk -F ',' '{printf $1}'| awk -F ':' '{printf $2}')
                    nodeName=$(echo $oneRec | awk -F ',' '{printf $2}'| awk -F ':' '{printf $2}')
                else
                    netPort=$(echo $oneRec | awk -F ',' '{printf $1}'| awk -F ':' '{printf $2}')
                    NodeIP=$(echo $oneRec | awk -F ',' '{printf $2}'| awk -F ':' '{printf $2}')
                    switchName=$(echo $oneRec | awk -F ',' '{printf $3}'| awk -F ':' '{printf $2}')
                    oneline="nodeName: $nodeName||nodeFunType: $nodeFunType||netPort: $netPort||IP: $NodeIP||switchName: $switchName"
                    LOG "$oneline"
                    WRITE_XML_COMMON 0 "$oneline"
                    switchArray[$arraySize]=$switchName
                    IpArray[$arraySize]=$NodeIP
                    arraySize=$((arraySize+1))
                fi
            done
            #ֻһIP.ж
            if [ $arraySize -eq 1 ];then
                continue
            fi
            CompareIp ${IpArray[0]} ${IpArray[1]}
            iRet=$?
            #СIPһʱļIPʱ
            if [ $iRet -eq 1 ]; then
                echo ${switchArray[0]} >>${SWITCH_SMALL_FILE}_${netPort} 2>&1
                switch_big_Array[count]=${switchArray[1]}
            else
                echo ${switchArray[1]} >>${SWITCH_SMALL_FILE}_${netPort} 2>&1
                switch_big_Array[count]=${switchArray[0]}
            fi
            port_type_Array[count]=$netPort
            count=$((count+1))
        done < $ALL_SWITCH_IFNO
        LOG "[$FUNCNAME][$LINENO] isPass=$isPass"
        if [ $isPass -ne 2 ];then
            for ((i=0; i<count; i=i+1))
            do
                #ôIPӦ ȥļƥ䣬ҵ˵нڵСIPӷʽڵ㲻ͬͨ
                grep -q ${switch_big_Array[i]} ${SWITCH_SMALL_FILE}_${port_type_Array[i]} >>/dev/null
                iRet=$?
                if [ $iRet -eq 0 ];then
                    isPass=1
                    LOG "[$FUNCNAME][$LINENO] ${switch_big_Array[i]} the same of switchName"
                fi

            done
        fi
        break
    done


    LOG "[$FUNCNAME][$LINENO]finish!"
    [ -f "${SWITCH_SMALL_FILE}" ] && rm -f "${SWITCH_SMALL_FILE}"
    [ -f "${ALL_SWITCH_IFNO}" ] && rm -f "${ALL_SWITCH_IFNO}"
    rm -f ${G_TMP_INSPECT_PATH}tmpfileswitchTopo*
    rm -f ${G_TMP_INSPECT_PATH}switch_small_file*
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#鵱ǰ汾ǷĿ汾ͬ
function CheckVersion()
{
    local currentVersion=$1
    local targetVersion=$2
    LOG "[$FUNCNAME][${LINENO}]currentVersion:${currentVersion} targetVersion:${targetVersion}"
    #echo "INFO:current version(${currentVersion})/target version(${targetVersion})">> ${RESULTFILE} 2>&1

    #汾ϢеӢַȥʹֵֵбȽ
    local tmpCurVer=${currentVersion//[^0-9]}
    local tmpTarVer=${targetVersion//[^0-9]}

    if [ -z "$tmpCurVer" ]; then
        return 0
    fi

    local tmpCurVerLen=${#tmpCurVer}
    local tmpTarVerLen=${#tmpTarVer}

    iTarLoop=1
    #ֵȽ

    for ((iLoop=0;iLoop<tmpCurVerLen;iLoop++))
    do
        #Ŀ汾ַءͨ
        if [ $iTarLoop -gt $tmpTarVerLen ]
        then
            return 0
        fi
        curWord=${tmpCurVer:$iLoop:$(($iLoop+1))}
        tarWord=${tmpTarVer:$iLoop:$(($iLoop+1))}

        #жһλ
        if [ $curWord -eq $tarWord ]
        then
            iTarLoop=$(($iTarLoop+1))
            continue
        #򷵻ءͨ
        elif [ $curWord -gt $tarWord ]
        then
            return 0
        #С򷵻ءͨ
        else
            return 1
        fi
    done
    #ǰ汾ѱϣĿ汾ַءɹ򷵻ءͨ
    if [ $(($iTarLoop-1)) -eq $tmpTarVerLen ]
    then
        return 0
    fi
    return 1
}

# 155 / 156 PFCü
function checkRoCEPfcCfg()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=3
    local checkScenario=$2
    local dailyScenario=2
    local bureauScenario=3
    local cm_db="/opt/huawei/snas/etc/cm_swm_conf.db"
    local retPfcChk=0
    local checkPFCPass=3
    local MainNodeIP=$(get_backnet_ip)

    #ýIdֶ
    local switchIdArray=$(/usr/bin/sqlite3 "${cm_db}" "select szSwId from CM_SWM_T")
    if [ -z "${switchIdArray}" ]; then
        LOG "[$FUNCNAME][${LINENO}]no switch info!"
        WRITE_XML_COMMON 0 "INFO:No switch info."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    local tmpswitchInfo=""
    for switchId in $switchIdArray
    do
        local szSwDscrpt=$(/usr/bin/sqlite3 "${cm_db}" "select szSwDscrpt from CM_SWM_T where szSwId=${switchId}")
        local switchInfo=$(echo "${szSwDscrpt}"|grep Version|awk -F '(' '{print $3}'|awk -F ' ' '{print $1}')
        local version=$(echo "${szSwDscrpt}"|grep Version|awk -F '(' '{print $3}'|awk -F ' ' '{print $2}'|awk -F ')' '{print $1}')
        if [ -z "${switchInfo}" -o -z "${version}" ]; then
            continue
        fi
        #齻ͺţС FM6857/FM6865/CE6810/CE6855/CE6857/CE6865/CE8861 żPFCͺŷز漰
        if [[ "${switchInfo}" =~ "CE6810" ]] || \
           [[ "${switchInfo}" =~ "CE6855" ]] || \
           [[ "${switchInfo}" =~ "CE6857" ]] || \
           [[ "${switchInfo}" =~ "CE6865" ]] || \
           [[ "${switchInfo}" =~ "CE8861" ]] || \
           [[ "${switchInfo}" =~ "FM6857" ]] || \
           [[ "${switchInfo}" =~ "FM6865" ]]; then
            local tmpPfcChk=0
        else
            retPfcChk=$((${retPfcChk} + 1))
            tmpswitchInfo="${switchInfo}"
            break
        fi
        #
        if [ ${checkScenario} -eq ${bureauScenario} ];then
            local szSwIp=$(/usr/bin/sqlite3 "${cm_db}" "select szSwIp from CM_SWM_T where szSwId=${switchId}")
            #齻ͺţС6810/6865/6855żPFCͺŷز漰
            local verExpected="--"
            local retVerChk=""
            #齻İ汾
            if [[ ${switchInfo} =~ "CE6810" ]]; then
                verExpected="V200R005C10SPC800"
                CheckVersion ${version} ${verExpected}
                retVerChk=$?
            elif [[ ${switchInfo} =~ "CE6855" ]]; then
                verExpected="V200R005C10SPC800"
                CheckVersion ${version} ${verExpected}
                retVerChk=$?
            elif [[ ${switchInfo} =~ "CE6865" ]]; then
                verExpected="V200R005C10SPC800"
                CheckVersion ${version} ${verExpected}
                retVerChk=$?
            elif [[ ${switchInfo} =~ "FM6857" ]]; then
                verExpected="V200R020C10SPC600"
                CheckVersion ${version} ${verExpected}
                retVerChk=$?
            elif [[ ${switchInfo} =~ "FM6865" ]]; then
                verExpected="V200R020C10SPC600"
                CheckVersion ${version} ${verExpected}
                retVerChk=$?
            else #Unknown switch
                retVerChk=3
            fi
            WRITE_XML_COMMON 0 "Node:${MainNodeIP}(master)||INFO:Switch (${szSwIp}) current version(${version})/target version(${verExpected})"
            if [ ${retVerChk} -eq 1 ]; then
                WRITE_XML_ERROR 0 "Node:${MainNodeIP}(master)||INFO:${switchInfo} version ${version} is less than ${verExpected}"
            fi
            isPass=$(check_pass $isPass $retVerChk)
        fi
    done

    #Сʶ𣬼PFC
    if [ ${retPfcChk} -ne 0 ]; then
        WRITE_XML_COMMON 0 "INFO:${tmpswitchInfo} is not FM6857/FM6865/CE6810/CE6855/CE6857/CE6865/CE8861 switch, no need to check PFC."
    else
        local REMOTE_IP_S=$(cat $IP_ROLE_FILE)
        local G_REMOTE_EXEX_RESULT="${G_TMP_INSPECT_PATH}tmpfileRemoteResult$$"
        local G_DOWNLOAD_FILE="${G_TMP_INSPECT_PATH}inspect_downloadfile$$"
        local taskids=155
        local exec_taskid="CheckItems"
        local Params=$(echo ${taskids} |awk '{printf $1}'|tr '[0-9]' '[A-J]')
        local command="${G_MML_FILE_PATH}/CheckItems '$taskids'> $G_REMOTE_EXEX_RESULT${Params} 2>&1"
        #ڵ
        for remoteIp in $REMOTE_IP_S
        do
            remote_exec_async $remoteIp $exec_taskid 600 "$command"
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME][$LINENO]Node:$remoteIp||INFO:Failed to exec_cmd command.item ${taskids}"
            fi
        done
        
        #
        for remoteIp in $REMOTE_IP_S
        do
            download_result "${remoteIp}" "$Params"
            iRet=$?
            #ʧ
            if [ ${iRet} -eq 126 ]; then
                download_result "${remoteIp}" "$Params"
            fi
        done

        #
        local fun="CheckRoCEPfcCfg"
        local CheckMsgFile="${G_TMP_INSPECT_PATH}CheckMsgFile${fun}$$"
        for Remote_ip in $REMOTE_IP_S
        do
        {
            local PassStatus=$(cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$fun/d' |eval sed '/${fun}_End/,\$\d' |eval grep '${fun}_Pass' |awk '{print $2}')
            if [ "$PassStatus" = "" ];then
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:($fun) get PassStatus failed"
                WRITE_XML_ERROR 0 "Node:$Remote_ip||INFO:Get PassStatus from output(${fun}) failed!"
                isPass=$(check_pass $isPass 1)
            else
                #ӽڵѲϢ
                cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$fun/d' |eval sed '/${fun}_Pass/,\$\d' > $CheckMsgFile
                #дѲXML
                CheckMsg=$(cat $CheckMsgFile)
                if [ "$CheckMsg" = "" ];then
                    LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:($fun) get CheckMsg failed"
                    WRITE_XML_ERROR 0 "Node:$Remote_ip||INFO:Null output($fun)!"
                    isPass=$(check_pass $isPass 1)
                else
                    CheckMsgParse "$Remote_ip" "$CheckMsgFile" 0
                    rm -rf $CheckMsgFile
                fi
                if [ "$PassStatus" !=  "0" ]; then
                    LOG "[$FUNCNAME]:Node: $Remote_ip||INFO: ${fun} check result:$PassStatus."
                fi
                isPass=$(check_pass $isPass $PassStatus)
            fi
        }
        done
    fi

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#ûдѲΪ漰
noInspectItem()
{
    WRITE_XML_SUBCMD_HEADER $1
    WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
    WRITE_XML_JUDGE 3
    WRITE_XML_SUBCMD_TAIL
}

# **************************************************************************** #
# Function Name: checkHardwareStatus
# Description: Ӳ״̬ м.
# Parameter: $1 cmditemID
# Return:
# **************************************************************************** #
checkHardwareStatus()
{
    local checkid=$1
    local startTime=0
    local endTime=0
    touch ${G_TMP_INSPECT_PATH}check_thread_count$$
    startTime=$(date +%s)
    LOG "[${FUNCNAME}]Enter ${REMOTE_IP} inspect item ${checkid}, result file $G_CHECK_RESULT_FILE"

    #GetIPAndRoleFromDB

    rm -rf ${G_TMP_INSPECT_PATH}tmpfile$$*
    rm -rf ${G_TMP_INSPECT_PATH}tmpfilex$$*

    LOG "[$FUNCNAME] param = ($1)"
    case ${checkid} in
        104)
            #5.Check Power Status
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkPowerStatus_MML 0"
            ;;
        105)
            #6.Check Fan Status
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkFanStatus_MML 0"
            ;;
        108)
            #9.Check Node Status
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkNodeStatus_MML 0"
            ;;
        112)
            #ģ
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkFiber_MML 0"
            ;;
        119)
            #汾һ¼
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkNodeVersion 0"
            ;;
        120)
            #è״̬
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkModmemtatus 0"
            ;;
        121)
            #ѯ豸ʱ
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkNodeTime 0"
            ;;
        129)
            #ӲFW汾
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkDiskFwVersion 0"
            ;;
        131)
            #Ӳ
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkDisk 0"
            ;;
        142)
            #߼
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkEthNetLine 0"
            ;;
        155)
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkRoCEPfcCfg 0 2"
            ;;
        156)
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkRoCEPfcCfg 0 3"
            ;;
        *)
        WRITE_XML_HD_AND_TL_ON_MASTER "$1" "noInspectItem 0"
        ;;
    esac
    chmod 640 $LOG_FILE
    endTime=$(date +%s)
    LOG "[${FUNCNAME}]Exit ${REMOTE_IP} inspect item ${checkid}, elapsed time $((endTime-startTime))"
    rm -f ${G_TMP_INSPECT_PATH}check_thread_count$$
}

