#!/bin/bash
CUR_PATH=$(dirname $(readlink -f $BASH_SOURCE))
SCRIPTNAME=$(basename $0)
#存储节点信息
ROOT_USER="root"
ROOT_PASSWD=""
REMOTE_USER="fsadmin"
REMOTE_PASSWD=""

#计算节点信息
COMPUTE_ROOT_USER="root"
COMPUTE_ROOT_PASSWD=""
COMPUTE_REMOTE_USER="fsp"
COMPUTE_REMOTE_PASSWD=""

SCP_TIMEOUT="300"
EXECUTE_TIMEOUT="600"

readonly PASSWD_FILE="passwd.ini"
readonly TMP_FILE="tmp.txt"
readonly TMP_RESULT_FILE="tmp_result.txt"
readonly EXPAND_NODE_MANAGE_IP_LIST=()
readonly DecryptPasswd=""
vbs_NODE_OUTFILE="${CUR_PATH}/VbsNode.List"
EBSCtrl_NODE_OUTFILE="${CUR_PATH}/EBSCtrlNode.List"
nodesentry_NODE_OUTFILE="${CUR_PATH}/NodesentryNode.List"
cm_NODE_OUTFILE="${CUR_PATH}/CmNode.List"
ccdb_monitor_NODE_OUTFILE="${CUR_PATH}/CcdbMonitorNode.List"
ccdb_server_NODE_OUTFILE="${CUR_PATH}/CcdbServerNode.List"
djob_NODE_OUTFILE="${CUR_PATH}/DjobNode.List"
dlm_vm_NODE_OUTFILE="${CUR_PATH}/DlmVmNode.List"
dlm_mm_NODE_OUTFILE="${CUR_PATH}/DlmMmNode.List"
kmm_server_NODE_OUTFILE="${CUR_PATH}/KmmServerNode.List"
mdc_NODE_OUTFILE="${CUR_PATH}/MdcNode.List"
osd_NODE_OUTFILE="${CUR_PATH}/OsdNode.List"
zk_NODE_OUTFILE="${CUR_PATH}/ZkNode.List"
IP_EXPR_IPV6="^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$"
declare -a cm_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/cm/config/cm.cfg")
declare -a ccdb_monitor_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/ccdb/ccdb_monitor/config/ccdb_monitor.cfg")
declare -a ccdb_server_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/ccdb/ccdb_server/config/ccdb_server.cfg")
declare -a djob_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/djob/config/djob.cfg")
declare -a dlm_vm_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/dlm_vm/config/dlm_vm.cfg")
declare -a dlm_mm_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/dlm_mm/config/dlm_mm.cfg")
declare -a kmm_server_COMPONENT_CONFIGRATION=("/opt/dfv/oam/oam-u/data/kmm-server/kmm_server.cfg")
#readonly CM_TOOL_NAME="cm_tool"
#readonly CM_METADATA_TOOL="cm_metadata_tool"
readonly STORAGE_ROLE="storage"
readonly COMPUTE_ROLE="compute"
readonly RESULT_SUCC_FALG="@@RESULT=0@@"
readonly RESULT_PARAM_FALG="@@PARAM="
readonly SUCC_NODE_LIST_SUFFIX="NodeSucc"
readonly FAIL_NODE_LIST_SUFFIX="NodeFail"
# expand order
declare -a EXPANDENT_COMPONENTS=("cm" "ccdb_monitor" "ccdb_server" "djob" "dlm_vm" "dlm_mm" "kmm_server")
declare -a ROLLBACK_COMPONENTS=("kmm_server" "dlm_mm" "dlm_vm" "djob" "ccdb_server" "ccdb_monitor" "cm")
declare -a CHECK_LINK_COMPONENTS=("vbs" "EBSCtrl" "nodesentry" "ccdb_monitor" "ccdb_server" "djob" "dlm_vm" "dlm_mm" "kmm_server" "cm" "osd")
# update configuration components
declare -a cm_CFG_COMPONENTS=("vbs" "EBSCtrl" "nodesentry" "ccdb_monitor" "ccdb_server" "djob" "dlm_vm" "dlm_mm" "kmm_server" "cm")
declare -a ccdb_monitor_CFG_COMPONENTS=("ccdb_monitor")
declare -a ccdb_server_CFG_COMPONENTS=("ccdb_server")
declare -a djob_CFG_COMPONENTS=()
declare -a dlm_vm_CFG_COMPONENTS=()
declare -a dlm_mm_CFG_COMPONENTS=()
declare -a kmm_server_CFG_COMPONENTS=("EBSCtrl" "osd" "kmm_server")
declare -a zk_CFG_COMPONENTS=("zk")
# old node component configration items
declare -A cm_ITEM_FUNC_MAP=(\
["cm_url"]="GET_IP_LIST_FROM_DB" \
["cm_ip_list"]="GET_IP_LIST_FROM_DB" \
["cm_be_ip_list"]="GET_BE_IP_LIST_FROM_DB" \
["cm_data_ip_list"]="GET_DATA_IP_LIST_FROM_DB" \
["ns_global_ip_list"]="GET_NS_LIST_FROM_DB" \
["cm_data_url"]="GET_DATA_IP_LIST_FROM_DB")
declare -A ccdb_monitor_ITEM_FUNC_MAP=(["deploy_ip_list"]="GET_CLUSTER_IP_LIST_FROM_DB")
declare -A ccdb_server_ITEM_FUNC_MAP=(["deploy_ip_list"]="GET_CLUSTER_IP_LIST_FROM_DB")
declare -A djob_ITEM_FUNC_MAP=()
declare -A dlm_vm_ITEM_FUNC_MAP=()
declare -A dlm_mm_ITEM_FUNC_MAP=()
declare -A kmm_server_ITEM_FUNC_MAP=(\
["deploy_ip_list"]="GET_CLUSTER_IP_LIST_FROM_DB" \
["kms_ip_list"]="GET_IP_LIST_FROM_DB" \
["g_kms_ip_list"]="GET_IP_LIST_FROM_DB")
# new node component configration items
declare -A LOCAL_COMMON_ITEM_FUNC_MAP=(\
["snm_url"]="GET_LOCAL_IP" \
["local_data_ip"]="GET_DATA_LOCAL_IP" \
["local_be_ip"]="GET_LOCAL_BE_IP" \
["local_ip"]="GET_LOCAL_IP")
declare -A cm_LOCAL_ITEM_FUNC_MAP=()
declare -A ccdb_monitor_LOCAL_ITEM_FUNC_MAP=()
declare -A ccdb_server_LOCAL_ITEM_FUNC_MAP=()
declare -A djob_LOCAL_ITEM_FUNC_MAP=()
declare -A dlm_vm_LOCAL_ITEM_FUNC_MAP=()
declare -A dlm_mm_LOCAL_ITEM_FUNC_MAP=(\
["mm_local_ip"]="GET_LOCAL_IP" \
["vm_local_ip"]="GET_LOCAL_IP")
declare -A kmm_server_LOCAL_ITEM_FUNC_MAP=()

declare -A COMPONENT_RESTART_FUNC_MAP=(
["vbs"]="VBS_BATCH_RESTART_NODE" \
["EBSCtrl"]="EBS_BATCH_RESTART_NODE" \
["nodesentry"]="GENERAL_BATCH_RESTART_NODE" \
["ccdb_monitor"]="GENERAL_SERIAL_RESTART_NODE" \
["ccdb_server"]="GENERAL_SERIAL_RESTART_NODE" \
["djob"]="GENERAL_SERIAL_RESTART_NODE" \
["dlm_vm"]="GENERAL_SERIAL_RESTART_NODE" \
["dlm_mm"]="GENERAL_SERIAL_RESTART_NODE" \
["kmm_server"]="GENERAL_SERIAL_RESTART_NODE" \
["cmsworker"]="GENERAL_BATCH_RESTART_NODE" \
["fdsaCore"]="GENERAL_SERIAL_RESTART_NODE" \
["cm"]="GENERAL_SERIAL_RESTART_NODE" \
["osd"]="GENERAL_BATCH_RESTART_NODE" \
["zk"]="ZK_SERIAL_RESTART_NODE" \
)

SHELL_LOG_FULL_PATH=""
MAX_LOG_NUM=5

readonly GLOBAL_PORT_RANGE="13000-13900"
readonly arb_ctrl_agent_GLOBAL_PORT_RANGE="13331-13340"
readonly cm_GLOBAL_PORT_RANGE="13001-13010"
readonly ccdb_monitor_GLOBAL_PORT_RANGE="13011-13020"
readonly ccdb_server_GLOBAL_PORT_RANGE="13021-13030"
readonly djob_GLOBAL_PORT_RANGE="13031-13040"
readonly dlm_vm_GLOBAL_PORT_RANGE="13041-13050"
readonly dlm_mm_GLOBAL_PORT_RANGE="13051-13060"
readonly kmm_server_GLOBAL_PORT_RANGE="13061-13070"
readonly ccdbx_GLOBAL_PORT_RANGE="13011-13020"
readonly GLOBAL_PROCESS_RANGE="327680-393215"

readonly Q_FD=9
readonly Q_SIZE=15

function InitFiFo()
{
    mkfifo $$.fifo.tmp
    eval exec "${Q_FD}""<>$$.fifo.tmp"
    rm -rf $$.fifo.tmp
    trap CleanFifo SIGINT SIGHUP SIGQUIT SIGKILL
    local i=0
    for ((i=0; i<${Q_SIZE}; ++i))
    do
        ReleaseFifo
    done
}

function CleanFifo()
{
    ScriptPrintLog "clean fifo begin. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    eval exec "${Q_FD}""<&-" # close read file description
    eval exec "${Q_FD}"">&-" # close wrie file decription
    kill 0
    kill 9 $$
    ScriptPrintLog "clean fifo end. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
}

function FreeFifo
{
    ScriptPrintLog "free fifo begin. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    eval exec "${Q_FD}""<&-" # close read file description
    eval exec "${Q_FD}"">&-" # close wrie file decription
    ScriptPrintLog "free fifo end. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
}

function AcquireFifo()
{
    read -u${Q_FD}
}

function ReleaseFifo()
{
    echo >&${Q_FD}
}

readonly SYS_CONF_XML="/opt/omm/oms/workspace/webapps/dsware/WEB-INF/SystemConfiguration.xml"
readonly LAST_GEN_EDS_LSID="last_gen_eds_lsid"
readonly DSW_SYS="DSW_SYS"
# 获取item_key的value，item_key如果存在必须唯一，item_key不存在时返回的value为空字符串
function GetXmlKeyValue()
{
    local xml_file="$1"
    local item_key="$2"

    [ ! -f "${xml_file}" ] && { ScriptPrintLog "xml_file ${xml_file} not exsit. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }
    [ -z "${item_key}" ] && { ScriptPrintLog "item_key ${item_key} is empty. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }

    local num
    num=$(grep -c "<\/${item_key}>" "${xml_file}")
    [ ${num} -gt 1 ] && { ScriptPrintLog "item_key ${item_key} num not eq 1. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }

    cat "${xml_file}" | grep "<\/${item_key}>" | awk -F'>' '{print $2}' | awk -F'<' '{print $1}' || return 1

    return 0
}

function GetXmlKeyValueByEntry()
{
    local xml_file="$1"
    local item_entry="$2"
    local item_key="$3"
    local num=0
    local enter_entry=0
    local tmp_line=""
    local find_line=""

    [ ! -f "${xml_file}" ] && { ScriptPrintLog "xml_file ${xml_file} not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }
    [ -z "${item_entry}" ] && { ScriptPrintLog "item_entry ${item_entry} is empty. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }
    [ -z "${item_key}" ] && { ScriptPrintLog "item_key ${item_key} is empty. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }

    num=$(grep -c "<\/${item_entry}>" "${xml_file}")
    [ ${num} -lt 1 ] && { ScriptPrintLog "item_entry ${item_entry} not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }

    num=$(grep -c "<\/${item_key}>" "${xml_file}")
    [ ${num} -lt 1 ] && { ScriptPrintLog "item_key ${item_key} not exist. [Line:${LINENO}]" "${FUNCNAME[0]}" ${SCRIPTNAME}; return 1; }

    while read line
    do
        if [ ${enter_entry} -eq 1 ];then
            tmp_line=$(echo ${line} | grep "<${item_key}")
            if [ -n "${tmp_line}" ];then
                find_line=${tmp_line}
                break;
            fi

            #退出了配置段
            tmp_line=$(echo ${line} | grep "<\/${item_entry}>")
            if [ -n "${tmp_line}" ];then
                break
            fi
        fi

        #进入了配置段
        if [ ${enter_entry} -eq 0 ];then
            #根据xml文件的格式，加上"<"进行匹配，解决描述和关键字相同时错误匹配的问题
            #根据xml文件的格式，加上"_"进行过滤，解决段名被其它段名包含的问题（比如：DSW_POOL和DSW_POOL_SPEC_SPECIFIED）
            tmp_line=$(echo ${line} | grep "<${item_entry}" | grep -v "<${item_entry}_")
            if [ -n "${tmp_line}" ];then
                enter_entry=$((enter_entry + 1))
            fi
        fi
    done < ${xml_file}

    if [ -z "${find_line}" ];then
        ScriptPrintLog "fail to find key ${item_key} in segment ${enter_entry}. [Line:${LINENO}]" ${FUNCNAME[0]} ${SCRIPTNAME}
        return 1
    fi

    echo "${find_line}" | awk -F'>' '{print $2}' | awk -F'<' '{print $1}' || return 1

    return 0
}

# 修改item_key的value为item_value，item_key必须存在
function SetXmlKeyValue()
{
    local xml_file="$1"
    local item_key="$2"
    local item_value="$3"

    [ ! -f "${xml_file}" ] && { ScriptPrintLog "xml_file ${xml_file} not exsit. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }
    [ -z "${item_key}" ] && { ScriptPrintLog "item_key ${item_key} is empty. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }

    local num
    num=$(grep -c "<\/${item_key}>" "${xml_file}")
    [ "${num}" -eq 0 ] && { ScriptPrintLog "item_key ${item_key} num eq 0. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }
    local revert_item_value="${item_value//\//\\/}"
    sed -i "/<\/${item_key}>/s/>.*</>${revert_item_value}</" "${xml_file}" || { ScriptPrintLog "set item_key ${item_key} value ${item_value} failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }
    ScriptPrintLog "set item_key ${item_key} value ${item_value} succeed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}

    return 0
}

function SetXmlKeyValueByEntry()
{
    local xml_file="$1"
    local item_entry="$2"
    local item_key="$3"
    local item_value="$4"
    local num=0
    local enter_entry=0
    local tmp_line=""
    local find_num=-1

    [ ! -f "${xml_file}" ] && { ScriptPrintLog "xml_file ${xml_file} not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }
    [ -z "${item_entry}" ] && { ScriptPrintLog "item_entry ${item_entry} is empty. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }
    [ -z "${item_key}" ] && { ScriptPrintLog "item_key ${item_key} is empty. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }

    num=$(grep -c "<\/${item_entry}>" "${xml_file}")
    [ ${num} -lt 1 ] && { ScriptPrintLog "item_entry ${item_entry} not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }

    num=$(grep -c "<\/${item_key}>" "${xml_file}")
    [ ${num} -lt 1 ] && { ScriptPrintLog "item_key ${item_key} not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }

    num=0
    while read line
    do
        num=$((num + 1))
        if [ ${enter_entry} -eq 1 ];then
            tmp_line=$(echo ${line} | grep "<${item_key}")
            if [ -n "${tmp_line}" ];then
                find_num=${num}
                break;
            fi

            #退出了配置段
            tmp_line=$(echo ${line} | grep "<\/${item_entry}>")
            if [ -n "${tmp_line}" ];then
                break
            fi
        fi

        #进入了配置段
        if [ ${enter_entry} -eq 0 ];then
            #根据xml文件的格式，加上"<"进行匹配，解决描述和关键字相同时错误匹配的问题
            #根据xml文件的格式，加上"_"进行过滤，解决段名被其它段名包含的问题（比如：DSW_POOL和DSW_POOL_SPEC_SPECIFIED）
            tmp_line=$(echo ${line} | grep "<${item_entry}" | grep -v "<${item_entry}_")
            if [ -n "${tmp_line}" ];then
                enter_entry=$((enter_entry + 1))
            fi
        fi
    done < ${xml_file}

    if [ ${find_num} -eq -1 ];then
        ScriptPrintLog "fail to find key ${item_key} in segment ${enter_entry}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local revert_item_value="${item_value//\//\\/}"
    sed -i "${find_num}s/>.*</>${revert_item_value}</" "${xml_file}" || { script_print_log "set item_key ${item_key} value ${item_value} failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}; return 1; }
    ScriptPrintLog "set item_key ${item_key} value ${item_value} succeed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}

    return 0
}

function GENERATE_PORT_LIST()
{
    local portNumber=$1
    local serverId=$2
    local serviceType=$3
    local usedPortListInSetp=$4

    local usedPortRangeStrArray=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select portRange from TBL_SERVICE_PROCESS_INFO where serverId=${serverId};"|sed -n '3,$p'|grep -v row)
    local usedPortList=()
    usedPortList+=(${usedPortListInSetp[*]})
    for portRangeStr in ${usedPortRangeStrArray[*]}
    do
        portRangeStr=$(echo "${portRangeStr}" | awk '{gsub(/^\s+|\s+$/, "");print}')
        portRangeList=$(echo "${portRangeStr}" | awk -F ',' 'NR==1{for(i=1;i<=NF;i++){print $i}}')

        for portRangeStr in ${portRangeList[*]}
        do
            local start=${portRangeStr%%-*}
            local end=${portRangeStr#*-}
            local seqLList=$(seq ${start} ${end})
            usedPortList+=(${seqLList[*]})
        done
    done

    local globalStart=${GLOBAL_PORT_RANGE%%-*}
    local globalEnd=${GLOBAL_PORT_RANGE#*-}
    local generateNum=0
    local generatedPortList=()
    for ((i=${globalStart};i<=${globalEnd};i++))
    do
        if [[ ${usedPortList[@]/${i}/} == ${usedPortList[@]} ]]; then
            generatedPortList+=(${i})
            let local generateNum=generateNum+1
            if [ ${generateNum} -eq ${portNumber} ]; then
                break
            fi
        fi
    done
    echo ${generatedPortList[*]}
}

function PortList2PortRangeStr()
{
    local portList=($(echo "${1}"|awk 'NR==1{for(i=1;i<=NF;i++){print $i}}'))
    if [ ${#portList[*]} -eq 0 ]; then
        echo ""
        return 0
    fi

    local pre=${portList[0]}
    local start=${portList[0]}
    local resultStr=""
    for(( i=1;i<${#portList[@]};i++))
    do
        let local nextPort=pre+1
        if [ ${portList[i]} -eq ${nextPort} -o ${portList[i]} -eq ${pre} ]; then
            pre=${portList[i]}
        else
            resultStr="${resultStr}${start}-${pre},"
            pre=${portList[i]}
            start=${portList[i]}
        fi
        let local lastIndex=${#portList[@]}-1
        if [ ${i} -eq ${lastIndex} ]; then
            resultStr="${resultStr}${start}-${pre},"
        fi
    done

    if [ ${#portList[@]} -eq 1 ]; then
        echo "${start}-${pre}"
        return 0
    fi

    echo ${resultStr%,*}
    return 0
}

function InitLogDirPermission()
{
    if [ ! -d ${ROOT_LOG_DIR} ]; then 
        mkdir -p ${ROOT_LOG_DIR}
        chmod 755 /var
        chmod 755 /var/log
        chmod 755 /var/log/oam
        chmod 750 /var/log/oam/fsa
    fi
    #add set dir user
    return 0
}

function InitLog()
{
    SHELL_LOG_DIR=$1
    SHELL_LOG_NAME=$2

    if [ ! -d "${ROOT_LOG_DIR}" ]; then
        InitLogDirPermission
    fi
    
    mkdir -p ${SHELL_LOG_DIR}
    SHELL_LOG_FULL_PATH="${SHELL_LOG_DIR}/${SHELL_LOG_NAME}"

    if [ ! -f "${SHELL_LOG_FULL_PATH}" ]; then
        touch "${SHELL_LOG_FULL_PATH}"
        chmod 640 ${SHELL_LOG_FULL_PATH}
    fi
}

function RotateLog()
{
    local logAFile=""
    local logBFile=""
    local logIndex=""
    for ((logIndex=${MAX_LOG_NUM}; logIndex>1; logIndex--));
    do
        logAFile="${SHELL_LOG_FULL_PATH}.$(expr ${logIndex} - 1).gz"
        logBFile="${SHELL_LOG_FULL_PATH}.${logIndex}.gz"
        if [ -f "${logAFile}" ]; then
            mv "${logAFile}" "${logBFile}" >>/dev/null 2>&1
            if [ $? -ne 0 ]; then
                echo "mv ${logAFile} ${logBFile} failed."
                return 1
            fi
        fi
    done

    gzip -f "${SHELL_LOG_FULL_PATH}" >>/dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "Compress ${SHELL_LOG_FULL_PATH} to gzip failed."
        return 1
    fi
    
    if [ ! -f "${SHELL_LOG_FULL_PATH}" ]; then
        touch "${SHELL_LOG_FULL_PATH}"
        chown ${OAME_USER_OMM}:${OAME_GROUP_OMM} ${SHELL_LOG_FULL_PATH}
        chmod 640 ${SHELL_LOG_FULL_PATH}
    fi
    
    chmod 440 ${SHELL_LOG_FULL_PATH}.gz
    chown ${OAME_USER_OMM}:${OAME_GROUP_OMM} ${SHELL_LOG_FULL_PATH}
    mv ${SHELL_LOG_FULL_PATH}.gz ${SHELL_LOG_FULL_PATH}.1.gz
    return 0
}

#===  FUNCTION  ================================================================
#         NAME: LOG
#      PURPOSE: print log
#   PARAMETERS: NA
#      RETURNS: NA
#===============================================================================
function ScriptExeLog()
{
    local param1=$1
    local param2=$2
    local param3=$3

    echo "[""$(date +'%F %T')""]""[""${param1}""]""[""${param2}""]""[""${param3}""]" >> "${SHELL_LOG_FULL_PATH}" 2>/dev/null

    local logFileSize=$(du -s "${SHELL_LOG_FULL_PATH}" | awk '{print $1}')
    if [ "${logFileSize}" -gt 1024 ]; then
        RotateLog
    fi
}

function ScriptPrintLog()
{
    local param1=$1
    local param2=$2
    local param3=$3

    echo "[""$(date +'%F %T')""]""[""${param1}""]""[""${param2}""]""[""${param3}""]"
    ScriptExeLog "${param1}" "${param2}" "${param3}"
}

function ScriptColorPrintLog()
{
    local param1=$1
    local param2=$2
    local param3=$3

    echo -e "\033[31m[""$(date +'%F %T')""]""[""${param1}""]""[""${param2}""]""[""${param3}""]\033[0m"
    ScriptExeLog "${param1}" "${param2}" "${param3}"
}

function CheckIsStorageNode()
{
    local nodeManageIp=$1
    local role=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ROLE from TBL_SERVER_INFO where MANAGEIP='${nodeManageIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [[ "${role}" =~ "${STORAGE_ROLE}" ]]; then
        return 0
    fi

    return 1
}

function CheckIsComputeNode()
{
    local nodeManageIp=$1
    local role=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ROLE from TBL_SERVER_INFO where MANAGEIP='${nodeManageIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [[ "${role}" =~ "${COMPUTE_ROLE}" ]]; then
        return 0
    fi

    return 1
}

#############################################################################
##  功能: 判断是否是合法ip
##  入参: 
##        参数1: ip字符串
##  返回：0表示是，1表示否
#############################################################################
function IsIpIpv6()
{
    local ip="$1"
    if [ -z "$(echo "${ip}" | grep -E "${IP_EXPR_IPV6}")" ]; then
        return 1
    fi
    return 0
}

function Scp2Remote()
{
    local filename=$1
    local destIp=$2
    local user=$3
    local pass=$4

    local remotePath="/home/$user"
    if [ "${user}" == "root" ]; then
        remotePath="/$user"
    fi

    expect -c "
    set timeout ${SCP_TIMEOUT};
    spawn scp -o StrictHostKeyChecking=no $filename $user@\[$destIp\]:${remotePath}
    expect {
        *yes/no {
            send yes\r;
            exp_continue
        }
        *assword:* {
            send $pass\r;
        }
    }
    expect *#* {}
    "

    ret=$?
    return $ret
}
function GetCmdInfo()
{
    local tmpFile=$1
    local tmpResultFile=$2
    cat ${tmpFile} > ${tmpResultFile}
}

function SudoExecuteRemoteCmd()
{
    local cmd=$1
    local destIp=$2
    local user=$3
    local pass=$4
    local rootPass=$5
    local tmpFile=$6
    local tmpResultFile=$7

    if [ "${user}" == "root" ]; then
        expect -c "
        set timeout ${EXECUTE_TIMEOUT};
        spawn ssh -o StrictHostKeyChecking=no ${user}@${destIp};
        expect {
            *yes/no {
                send yes\r;
                exp_continue
            }
            *assword:* {
                send $pass\r;
            }
        }

        expect {
            *#* {
                send ${cmd}\r;
            }
        }
        expect *#* { send exit\r; }
        expect *\$* { send exit\r; }
        " > ${tmpFile}
    else
        expect -c "
        set timeout ${EXECUTE_TIMEOUT};
        spawn ssh -o StrictHostKeyChecking=no ${user}@${destIp};
        expect {
            *yes/no {
                send yes\r;
                exp_continue
            }
            *assword:* {
                send $pass\r;
            }
        }
        expect {
            *\$* {
                send su\ root\r;
                expect {
                    *assword:* {
                        send $rootPass\r;
                    }
                }
            }
        }
        expect {
            *#* {
                send ${cmd}\r;
            }
        }
        expect *#* { send exit\r; }
        expect *\$* { send exit\r; }
        " > ${tmpFile}
    fi
    GetCmdInfo ${tmpFile} ${tmpResultFile}
}

function SingleNodeScp2RemoteAndExcute()
{
    local type=$1
    local cfgFile=$2
    local script=$3
    local params=$4
    local ip=$5
    local log_file="fix_${type}.log"

    if [ -a "${log_file}" ];then
        rm ${log_file}
    fi

    local scpFileStr="${script}"
    if [ -n "${cfgFile}" ]; then
        scpFileStr="${scpFileStr} ${cfgFile}"
    fi
    local paramStr=""
    for param in ${params[*]}
    do
        if [ -n "${paramStr}" ]; then
            paramStr="${paramStr}\ ${param}"
            continue
        fi
        paramStr="${param}"
    done

    echo "${ip}:" | tee -a ${log_file}
    local remoteUser=${COMPUTE_REMOTE_USER}
    local remotePasswd=${COMPUTE_REMOTE_PASSWD}
    local rootPasswd=${COMPUTE_ROOT_PASSWD}
    CheckIsStorageNode ${ip}
    if [ $? -eq 0 ]; then
        remoteUser=${REMOTE_USER}
        remotePasswd=${REMOTE_PASSWD}
        rootPasswd=${ROOT_PASSWD}
    fi

    if [ -f "${CUR_PATH}/${PASSWD_FILE}" ]; then
        local ipPasswdInfo=$(cat ${CUR_PATH}/${PASSWD_FILE}|grep -wF "${ip}")
        if [ -n "${ipPasswdInfo}" ]; then
            local colNum=$(echo "${ipPasswdInfo}" |awk '{print NF}')
            if [ "${colNum}" -eq 4 ]; then
                remoteUser=$(echo "${ipPasswdInfo}" |awk '{print $2}')
                remotePasswd=$(echo "${ipPasswdInfo}" |awk '{print $3}')
                rootPasswd=$(echo "${ipPasswdInfo}" |awk '{print $4}')
            fi
        fi
    fi

    # cp script to remote
    if [ -n "${scpFileStr}" ];then
        Scp2Remote "${scpFileStr}" $ip $remoteUser $remotePasswd
        if [ $? -ne 0 ];then
            echo "" | tee -a ${log_file}
            return 1
        fi
    fi

    if [ -z "${script}" ];then
        script="operateComponetInAgent.sh"
    fi

    local remotePath="/home/${remoteUser}"
    if [ "${remoteUser}" == "root" ]; then
        remotePath="/${remoteUser}"
    fi

    # remote excute
    SudoExecuteRemoteCmd "bash\ ${remotePath}/${script}\ ${paramStr}" $ip $remoteUser $remotePasswd $rootPasswd ${TMP_FILE} ${TMP_RESULT_FILE}
    cat ${TMP_RESULT_FILE} | tee -a ${log_file}
    echo "" | tee -a ${log_file}
    cat ${TMP_RESULT_FILE} |grep "${RESULT_SUCC_FALG}"
    return $?
}

function ParallelScp2RemoteAndExcute()
{
    local scpFileStr="$1"
    local IP=$2
    local log_file=$3
    local paramStr=$4
    local script=$5
    local succNodeListFile="$6"
    local failedNodeListFile="$7"
    local tmpFile=$8
    local tmpResultFile=$9

    local remoteUser=${COMPUTE_REMOTE_USER}
    local remotePasswd=${COMPUTE_REMOTE_PASSWD}
    local rootPasswd=${COMPUTE_ROOT_PASSWD}
    CheckIsStorageNode ${IP}
    if [ $? -eq 0 ]; then
        remoteUser=${REMOTE_USER}
        remotePasswd=${REMOTE_PASSWD}
        rootPasswd=${ROOT_PASSWD}
    fi

    if [ -f "${CUR_PATH}/${PASSWD_FILE}" ]; then
        local ipPasswdInfo=$(cat ${CUR_PATH}/${PASSWD_FILE}|grep -wF "${IP}")
        if [ -n "${ipPasswdInfo}" ]; then
            local colNum=$(echo "${ipPasswdInfo}" |awk '{print NF}')
            if [ "${colNum}" -eq 4 ]; then
                remoteUser=$(echo "${ipPasswdInfo}" |awk '{print $2}')
                remotePasswd=$(echo "${ipPasswdInfo}" |awk '{print $3}')
                rootPasswd=$(echo "${ipPasswdInfo}" |awk '{print $4}')
            fi
        fi
    fi

    # cp cfg and script to remote
    if [ -n "${scpFileStr}" ];then
        Scp2Remote "${scpFileStr}" $IP ${remoteUser} ${remotePasswd}
        if [ $? -ne 0 ];then
            echo "" | tee -a ${log_file}
            echo "${IP}" | tee -a ${failedNodeListFile}
            ScriptPrintLog "node(${IP}) ${type} failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            ReleaseFifo
            return
        fi
    fi

    if [ -z "${script}" ];then
        script="operateComponetInAgent.sh"
    fi

    local remotePath="/home/${remoteUser}"
    if [ "${remoteUser}" == "root" ]; then
        remotePath="/${remoteUser}"
    fi

    # remote excute
    SudoExecuteRemoteCmd "bash\ ${remotePath}/${script}\ ${paramStr}" $IP ${remoteUser} ${remotePasswd} ${rootPasswd} ${tmpFile} ${tmpResultFile}
    cat ${tmpResultFile} | tee -a ${log_file}
    echo "" | tee -a ${log_file}
    cat ${tmpResultFile} |grep "${RESULT_SUCC_FALG}"
    if [ $? -ne 0 ]; then
        echo "${IP}" | tee -a ${failedNodeListFile}
        ScriptPrintLog "node(${IP}) ${type} failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    else
        echo "${IP}" | tee -a ${succNodeListFile}
        ScriptPrintLog "node(${IP}) ${type} successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    fi
    ReleaseFifo
}

function ParallelBatchScp2RemoteAndExcute()
{
    local type=$1
    local cfgFile=$2
    local script=$3
    local params=$4
    local IPs=$5
    local filterIps=$6
    local succNodeListFile="fix_${type}_${SUCC_NODE_LIST_SUFFIX}.log"
    local failedNodeListFile="fix_${type}_${FAIL_NODE_LIST_SUFFIX}.log"
    local log_file="fix_${type}.log"

    if [ -a "${log_file}" ];then
        rm -f ${log_file}
    fi

    if [ -a "${succNodeListFile}" ];then
        rm -f ${succNodeListFile}
    fi

    if [ -a "${failedNodeListFile}" ];then
        rm -f ${failedNodeListFile}
    fi

    local scpFileStr="${script}"
    if [ -n "${cfgFile}" ]; then
        scpFileStr="${scpFileStr} ${cfgFile}"
    fi

    local paramStr=""
    for param in ${params[*]}
    do
        if [ -n "${paramStr}" ]; then
            paramStr="${paramStr}\ ${param}"
            continue
        fi
        paramStr="${param}"
    done

    local i=0
    InitFiFo
    for IP in ${IPs[@]}
    do
        if [[ -n "${filterIps[*]}" && ${filterIps[@]/${IP}/} != ${filterIps[@]} ]]; then
            echo "${IP}" | tee -a ${succNodeListFile}
            ScriptPrintLog "filter node(${IP}) ${type}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        echo "${IP}:" | tee -a ${log_file}
        if [ -a "${succNodeListFile}.${i}" ];then
            rm -f ${succNodeListFile}.${i}
        fi

        if [ -a "${failedNodeListFile}.${i}" ];then
            rm -f ${failedNodeListFile}.${i}
        fi
        AcquireFifo
        ParallelScp2RemoteAndExcute "${scpFileStr}" ${IP} ${log_file} "${paramStr}" "${script}" "${succNodeListFile}.${i}" "${failedNodeListFile}.${i}" "${TMP_FILE}.${i}" "${TMP_RESULT_FILE}.${i}" &
        let i=${i}+1
    done
    wait
    FreeFifo

    for ((j=0; j<i; j++))
    do
       if [ -s "${succNodeListFile}.${j}" ]; then
            cat "${succNodeListFile}.${j}" >> ${succNodeListFile}
       fi
       if [ -s "${failedNodeListFile}.${j}" ]; then
            cat "${failedNodeListFile}.${j}" >> ${failedNodeListFile}
       fi
    done
    return 0
}

function BatchScp2RemoteAndExcute()
{
    local type=$1
    local cfgFile=$2
    local script=$3
    local params=$4
    local IPs=$5
    local filterIps=$6
    local succNodeListFile="fix_${type}_${SUCC_NODE_LIST_SUFFIX}.log"
    local failedNodeListFile="fix_${type}_${FAIL_NODE_LIST_SUFFIX}.log"
    local log_file="fix_${type}.log"

    if [ -a "${log_file}" ];then
        rm -f ${log_file}
    fi

    if [ -a "${succNodeListFile}" ];then
        rm -f ${succNodeListFile}
    fi

    if [ -a "${failedNodeListFile}" ];then
        rm -f ${failedNodeListFile}
    fi

    local scpFileStr="${script}"
    if [ -n "${cfgFile}" ]; then
        scpFileStr="${scpFileStr} ${cfgFile}"
    fi

    local paramStr=""
    for param in ${params[*]}
    do
        if [ -n "${paramStr}" ]; then
            paramStr="${paramStr}\ ${param}"
            continue
        fi
        paramStr="${param}"
    done

    for IP in ${IPs[@]}
    do
        if [[ -n "${filterIps[*]}" && ${filterIps[@]/${IP}/} != ${filterIps[@]} ]]; then
            echo "${IP}" | tee -a ${succNodeListFile}
            ScriptPrintLog "filter node(${IP}) ${type}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        echo "${IP}:" | tee -a ${log_file}
        local remoteUser=${COMPUTE_REMOTE_USER}
        local remotePasswd=${COMPUTE_REMOTE_PASSWD}
        local rootPasswd=${COMPUTE_ROOT_PASSWD}
        CheckIsStorageNode ${IP}
        if [ $? -eq 0 ]; then
            remoteUser=${REMOTE_USER}
            remotePasswd=${REMOTE_PASSWD}
            rootPasswd=${ROOT_PASSWD}
        fi

        if [ -f "${CUR_PATH}/${PASSWD_FILE}" ]; then
            local ipPasswdInfo=$(cat ${CUR_PATH}/${PASSWD_FILE}|grep -wF "${IP}")
            if [ -n "${ipPasswdInfo}" ]; then
                local colNum=$(echo "${ipPasswdInfo}" |awk '{print NF}')
                if [ "${colNum}" -eq 4 ]; then
                    remoteUser=$(echo "${ipPasswdInfo}" |awk '{print $2}')
                    remotePasswd=$(echo "${ipPasswdInfo}" |awk '{print $3}')
                    rootPasswd=$(echo "${ipPasswdInfo}" |awk '{print $4}')
                fi
            fi
        fi

        # cp cfg and script to remote
        if [ -n "${scpFileStr}" ];then
            Scp2Remote "${scpFileStr}" $IP ${remoteUser} ${remotePasswd}
            if [ $? -ne 0 ];then
                echo "" | tee -a ${log_file}
                echo "${IP}" | tee -a ${failedNodeListFile}
                ScriptPrintLog "node(${IP}) ${type} failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
                continue
            fi
        fi

        if [ -z "${script}" ];then
            script="operateComponetInAgent.sh"
        fi

        local remotePath="/home/${remoteUser}"
        if [ "${remoteUser}" == "root" ]; then
            remotePath="/${remoteUser}"
        fi

        # remote excute
        SudoExecuteRemoteCmd "bash\ ${remotePath}/${script}\ ${paramStr}" $IP ${remoteUser} ${remotePasswd} ${rootPasswd} ${TMP_FILE} ${TMP_RESULT_FILE}
        cat ${TMP_RESULT_FILE} | tee -a ${log_file}
        echo "" | tee -a ${log_file}
        cat ${TMP_RESULT_FILE} |grep "${RESULT_SUCC_FALG}"
        if [ $? -ne 0 ]; then
            echo "${IP}" | tee -a ${failedNodeListFile}
            ScriptPrintLog "node(${IP}) ${type} failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        else
            echo "${IP}" | tee -a ${succNodeListFile}
            ScriptPrintLog "node(${IP}) ${type} successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        fi
    done
    return 0
}

function GetIpList()
{
    if [ -f "${vbs_NODE_OUTFILE}" ]; then
        rm -rf "${vbs_NODE_OUTFILE}"
    fi

    if [ -f "${nodesentry_NODE_OUTFILE}" ]; then
        rm -rf "${nodesentry_NODE_OUTFILE}"
    fi

    if [ -f "${EBSCtrl_NODE_OUTFILE}" ]; then
        rm -rf "${EBSCtrl_NODE_OUTFILE}"
    fi
    if [ -f "${cm_NODE_OUTFILE}" ]; then
        rm -rf "${cm_NODE_OUTFILE}"
    fi
    if [ -f "${ccdb_monitor_NODE_OUTFILE}" ]; then
        rm -rf "${ccdb_monitor_NODE_OUTFILE}"
    fi
    if [ -f "${ccdb_server_NODE_OUTFILE}" ]; then
        rm -rf "${ccdb_server_NODE_OUTFILE}"
    fi

    if [ -f "${djob_NODE_OUTFILE}" ]; then
        rm -rf "${djob_NODE_OUTFILE}"
    fi    
    if [ -f "${dlm_vm_NODE_OUTFILE}" ]; then
        rm -rf "${dlm_vm_NODE_OUTFILE}"
    fi
    if [ -f "${dlm_mm_NODE_OUTFILE}" ]; then
        rm -rf "${dlm_mm_NODE_OUTFILE}"
    fi
    if [ -f "${kmm_server_NODE_OUTFILE}" ]; then
        rm -rf "${kmm_server_NODE_OUTFILE}"
    fi
    if [ -f "${mdc_NODE_OUTFILE}" ]; then
        rm -rf "${mdc_NODE_OUTFILE}"
    fi

    if [ -f "${osd_NODE_OUTFILE}" ]; then
        rm -rf "${osd_NODE_OUTFILE}"
    fi

    if [ -f "${zk_NODE_OUTFILE}" ]; then
        rm -rf "${zk_NODE_OUTFILE}"
    fi

    su - omm -c "gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c 'set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO,TBL_VBS_INFO where TBL_SERVER_INFO.ID=TBL_VBS_INFO.SERVERID;'"|sed -n '3,$p'|grep -v row > ${vbs_NODE_OUTFILE}
    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and TBL_SERVICE_PROCESS_INFO.PROCESSTYPE='EBSCtrl' ORDER BY SERVERID DESC;"|sed -n '3,$p'|grep -v row > ${EBSCtrl_NODE_OUTFILE}
    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and TBL_SERVICE_PROCESS_INFO.PROCESSTYPE='nodesentry';"|sed -n '3,$p'|grep -v row > ${nodesentry_NODE_OUTFILE}   
    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and TBL_SERVICE_PROCESS_INFO.PROCESSTYPE='cm';"|sed -n '3,$p'|grep -v row > ${cm_NODE_OUTFILE}
    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and TBL_SERVICE_PROCESS_INFO.PROCESSTYPE='ccdb_monitor';"|sed -n '3,$p'|grep -v row > ${ccdb_monitor_NODE_OUTFILE}
    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and TBL_SERVICE_PROCESS_INFO.PROCESSTYPE='ccdb_server';"|sed -n '3,$p'|grep -v row > ${ccdb_server_NODE_OUTFILE}
    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and TBL_SERVICE_PROCESS_INFO.PROCESSTYPE='djob';"|sed -n '3,$p'|grep -v row > ${djob_NODE_OUTFILE}
    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and TBL_SERVICE_PROCESS_INFO.PROCESSTYPE='dlm_vm';"|sed -n '3,$p'|grep -v row > ${dlm_vm_NODE_OUTFILE}
    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and TBL_SERVICE_PROCESS_INFO.PROCESSTYPE='dlm_mm';"|sed -n '3,$p'|grep -v row > ${dlm_mm_NODE_OUTFILE}
    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and TBL_SERVICE_PROCESS_INFO.PROCESSTYPE='kmm_server';"|sed -n '3,$p'|grep -v row > ${kmm_server_NODE_OUTFILE}
    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_MDC_SERVER_INFO,TBL_SERVER_INFO where TBL_SERVER_INFO.ID=TBL_MDC_SERVER_INFO.SERVERID;"|sed -n '3,$p'|grep -v row > ${mdc_NODE_OUTFILE}
    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO,TBL_POOL_SERVER_INFO where TBL_SERVER_INFO.ID=TBL_POOL_SERVER_INFO.SERVERID;"|sed -n '3,$p'|grep -v row > ${osd_NODE_OUTFILE}
    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_ZK_SERVER_INFO,TBL_SERVER_INFO where TBL_SERVER_INFO.ID=TBL_ZK_SERVER_INFO.SERVERID;"|sed -n '3,$p'|grep -v row > ${zk_NODE_OUTFILE}
    if [ $? -ne 0 ]
    then
        ScriptPrintLog " get all node failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        sed -i "/^[ ]*${expandNodeIp}/d" ${cm_NODE_OUTFILE}
        sed -i "/^[ ]*${expandNodeIp}/d" ${ccdb_monitor_NODE_OUTFILE}
        sed -i "/^[ ]*${expandNodeIp}/d" ${ccdb_server_NODE_OUTFILE}
        sed -i "/^[ ]*${expandNodeIp}/d" ${djob_NODE_OUTFILE}
        sed -i "/^[ ]*${expandNodeIp}/d" ${dlm_vm_NODE_OUTFILE}
        sed -i "/^[ ]*${expandNodeIp}/d" ${dlm_mm_NODE_OUTFILE}
        sed -i "/^[ ]*${expandNodeIp}/d" ${kmm_server_NODE_OUTFILE}
        sed -i "/^[ ]*${expandNodeIp}/d" ${zk_NODE_OUTFILE}
    done
    ScriptPrintLog "Get all node succeed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function GetIpWithBracketOrNot()
{
    local ip="$1"
    if IsIpIpv6 ${ip}
    then
        echo "[${ip}]"
        return 0
    fi
    echo ${ip}
    return 0
}
#############################
function GetIpListFromDb()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    local colName=$4
    local portType=$5
    local outputStr=""
    local processIdArray=($(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select PROCESSID from TBL_SERVICE_PROCESS_INFO where  SERVICETYPE='${serviceType}' and CLUSTERID=${controlClusterId} and PROCESSTYPE='${processType}';"|sed -n '3,$p'|grep -v row))
    local portRangeArray=($(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select PORTRANGE from TBL_SERVICE_PROCESS_INFO where SERVICETYPE='${serviceType}' and CLUSTERID=${controlClusterId} and PROCESSTYPE='${processType}';"|sed -n '3,$p'|grep -v row))
    for i in "${!processIdArray[@]}";   
    do 
        local processId=${processIdArray[$i]}
        local localIp=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ${colName} from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and SERVICETYPE='${serviceType}' and CLUSTERID=${controlClusterId} and PROCESSID=${processId} and PROCESSTYPE='${processType}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        local localIpStr=$(GetIpWithBracketOrNot ${localIp})
        local portRangeString=${portRangeArray[$i]}
        local siglePortRangeString=$(echo ${portRangeString%%-*})
        if [ ${portType} -eq 1 ]; then
            local secondPortString=$(echo ${portRangeString}|awk -F',' '{print $2}')
            siglePortRangeString=$(echo ${secondPortString%%-*})
        fi
        if [ -n "${outputStr}" ]; then
            outputStr="${outputStr},"
        fi
        outputStr="${outputStr}${processId}"":""${localIpStr}"":""${siglePortRangeString}"
    done 
    echo "${outputStr}"
    return 0
}
function GET_IP_LIST_FROM_DB()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3

    GetIpListFromDb ${controlClusterId} ${processType} ${serviceType} "CLUSTERIP" 0
    return 0
}

function GET_DATA_IP_LIST_FROM_DB()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    GetIpListFromDb ${controlClusterId} ${processType} ${serviceType} "CLUSTERIP" 1
    return 0
}

function GET_BE_IP_LIST_FROM_DB()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3

    GetIpListFromDb ${controlClusterId} ${processType} ${serviceType} "STORAGEIP" 0
    return 0
}

function GET_NS_LIST_FROM_DB()
{
    local controlClusterId=$1
    local processType="$2"
    local serviceType=$3

    if [ ${processType} = "osd" -o ${processType} = "plogClient" -o ${processType} = "plogClient" ]; then
        GetIpListFromDb ${controlClusterId} "cm" "eds" "STORAGEIP" 0
    else
        GetIpListFromDb ${controlClusterId} "cm" "eds" "CLUSTERIP" 0
    fi
    return 0
}

function GetClusterListStr()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    local colName=$4
    local outputStr=""
    local ipArray=($(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ${colName} from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and TBL_SERVICE_PROCESS_INFO.PROCESSTYPE='${processType}';"|sed -n '3,$p'|grep -v row))
    for i in "${!ipArray[@]}";   
    do 
        local ip=${ipArray[$i]}
        local ipStr=$(GetIpWithBracketOrNot ${ip})
        if [ -n "${outputStr}" ]; then
            outputStr="${outputStr},"
        fi
        outputStr="${outputStr}${ipStr}"
    done 
    echo "${outputStr}"
    return 0
}

function GET_CLUSTER_IP_LIST_FROM_DB()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3

    GetClusterListStr ${controlClusterId} ${processType} ${serviceType} "CLUSTERIP"
    return 0
}

function GetLocalIp()
{
    local controlClusterId=$1
    local processType=$2
    local serverId=$3
    local serviceType=$4
    local colName=$5
    local portType=$6

    local processId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select PROCESSID from TBL_SERVICE_PROCESS_INFO where  SERVICETYPE='${serviceType}' and CLUSTERID=${controlClusterId} and SERVERID=${serverId} and PROCESSTYPE='${processType}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    local localIp=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ${colName} from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and SERVICETYPE='${serviceType}' and CLUSTERID=${controlClusterId} and SERVERID=${serverId} and PROCESSTYPE='${processType}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    local localIpStr=$(GetIpWithBracketOrNot ${localIp})
    local portRangeString=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select PORTRANGE from TBL_SERVICE_PROCESS_INFO where SERVICETYPE='${serviceType}' and CLUSTERID=${controlClusterId} and SERVERID=${serverId} and PROCESSTYPE='${processType}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    local siglePortRangeString=$(echo ${portRangeString%%-*})
    if [ ${portType} -eq 1 ]; then
        local secondPortString=$(echo ${portRangeString}|awk -F',' '{print $2}')
        siglePortRangeString=$(echo ${secondPortString%%-*})
    fi

    echo "${processId}"":""${localIpStr}"":""${siglePortRangeString}"
    return 0
}

function GET_LOCAL_IP()
{
    local controlClusterId=$1
    local processType=$2
    local serverId=$3
    local serviceType=$4
    GetLocalIp ${controlClusterId} ${processType} ${serverId} ${serviceType} "CLUSTERIP" 0
    return 0
}
function GET_DATA_LOCAL_IP()
{
    local controlClusterId=$1
    local processType=$2
    local serverId=$3
    local serviceType=$4
    GetLocalIp ${controlClusterId} ${processType} ${serverId} ${serviceType} "CLUSTERIP" 1
    return 0
}

function GET_LOCAL_BE_IP()
{
    local controlClusterId=$1
    local processType=$2
    local serverId=$3
    local serviceType=$4
    GetLocalIp ${controlClusterId} ${processType} ${serverId} ${serviceType} "STORAGEIP" 0
    return 0
}

function GENERATE_PROCESS_ID()
{
    local processNumber=$1
    local usedProcessIdListInSetp=$2

    local usedProcessIdArray
    usedProcessIdArray=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select PROCESSID from TBL_SERVICE_PROCESS_INFO;"|sed -n '3,$p'|grep -v row)
    local usedProcessIdList=(${usedProcessIdArray[*]})
    usedProcessIdList+=(${usedProcessIdListInSetp[*]})
    usedProcessIdList=($(echo ${usedProcessIdList[*]}|sed 's/ /\n/g'|sort -n|uniq))

    local globalStart=${GLOBAL_PROCESS_RANGE%%-*}
    local globalEnd=${GLOBAL_PROCESS_RANGE#*-}
    local generateNum=0
    local generatedPocessIdList=()
    for ((i=${usedProcessIdList[${#usedProcessIdList[@]}-1]};i<=${globalEnd};i++))
    do
        if [[ ${usedProcessIdList[@]/${i}/} == ${usedProcessIdList[@]} ]]; then
            generatedPocessIdList+=("${i}")
            let generateNum=generateNum+1
            if [ ${generateNum} -eq ${processNumber} ]; then
                break
            fi
        fi
    done

    if [ ${generateNum} -lt ${processNumber} ]; then
        for ((i=${globalStart};i<=${usedProcessIdList[${#usedProcessIdList[@]}-1]};i++))
        do
            if [[ ${usedProcessIdList[@]/${i}/} == ${usedProcessIdList[@]} ]]; then
                generatedPocessIdList+=(${i})
                let generateNum=generateNum+1
                if [ ${generateNum} -eq ${processNumber} ]; then
                    break
                fi
            fi
        done
    fi

    echo ${generatedPocessIdList[*]}
}

function UpdateLastGenLsId()
{
    local maxProcessId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select max(PROCESSID) from TBL_SERVICE_PROCESS_INFO;"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [ -z "${maxProcessId}" ];then
        ScriptPrintLog "maxProcessId is null. [Line:${LINENO}]" ${FUNCNAME[0]} ${SCRIPTNAME}
        return 1
    fi
    local currentLsId=$(GetXmlKeyValueByEntry "${SYS_CONF_XML}" "${DSW_SYS}" "${LAST_GEN_EDS_LSID}")
    if [ -z "${currentLsId}" ]; then
        ScriptPrintLog "get item_key ${LAST_GEN_EDS_LSID} value from ${SYS_CONF_XML} ${DSW_SYS} is null. [Line:${LINENO}]" ${FUNCNAME[0]} ${SCRIPTNAME}
        return 1
    fi
    #local currentLsId=$(GetXmlKeyValue "${SYS_CONF_XML}" "${LAST_GEN_EDS_LSID}")
    #if [ -z "${currentLsId}" ];then
    #    ScriptPrintLog "currentLsId is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    #    return 1
    #fi
    if [ "${currentLsId}" == "${maxProcessId}" ]; then
        ScriptPrintLog "${SYS_CONF_XML} ${LAST_GEN_EDS_LSID} already is ${maxProcessId}. [Line:${LINENO}]" ${FUNCNAME[0]} ${SCRIPTNAME}
        return 0
    fi
    SetXmlKeyValueByEntry "${SYS_CONF_XML}" "${DSW_SYS}" "${LAST_GEN_EDS_LSID}" "${maxProcessId}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "update ${SYS_CONF_XML} ${DSW_SYS} ${LAST_GEN_EDS_LSID} to ${maxProcessId} failed. [Line:${LINENO}]" ${FUNCNAME[0]} ${SCRIPTNAME}
        return 1
    fi

    #SetXmlKeyValue "${SYS_CONF_XML}" "${LAST_GEN_EDS_LSID}" "${maxProcessId}"
    #if [ $? -ne 0 ]; then
    #    ScriptPrintLog "update ${SYS_CONF_XML} ${LAST_GEN_EDS_LSID} to ${maxProcessId} failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    #    return 1
    #fi
    ScriptPrintLog "update ${SYS_CONF_XML} ${DSW_SYS} ${LAST_GEN_EDS_LSID} to ${maxProcessId} successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

############################################
function insertProcessInfo2Db()
{
    local serviceType=$1
    local clusterId=$2
    local processType=$3
    local serverId=$4

    # server id 
    local processInfoCount=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select count(1) from TBL_SERVICE_PROCESS_INFO where PROCESSTYPE='${processType}' and SERVERID=${serverId};"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [ ${processInfoCount} -ne 0 ]; then
        ScriptPrintLog "Node (${serverIp}) exist component(${processType}), count(${processInfoCount}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    local currentLsId=$(GetXmlKeyValueByEntry "${SYS_CONF_XML}" "${DSW_SYS}" "${LAST_GEN_EDS_LSID}")
    if [ -z "${currentLsId}" ]; then
        ScriptPrintLog "get item_key ${LAST_GEN_EDS_LSID} value from ${SYS_CONF_XML} ${DSW_SYS} is null. [Line:${LINENO}]" ${FUNCNAME[0]} ${SCRIPTNAME}
        return 1
    fi

    local processIdNumber=1
    local usedProcessIdInSetp=("${currentLsId}")
    local processIdArray=("$(GENERATE_PROCESS_ID ${processIdNumber} ${usedProcessIdInSetp[*]})")
    if [ ${#processIdArray[*]} -ne ${processIdNumber} ] ; then
        ScriptPrintLog "generate process id failed. [Line:${LINENO}]" ${FUNCNAME[0]} ${SCRIPTNAME}
        return 1
    fi

    local processId=${processIdArray[0]}
    local portNumber=1
    local usedPortListInSetp=()
    local portList=$(GENERATE_PORT_LIST ${portNumber} ${serverId} ${serviceType} ${usedPortListInSetp})
    usedPortListInSetp+=(${portList[*]})
    local dataPortList=$(GENERATE_PORT_LIST ${portNumber} ${serverId} ${serviceType} ${usedPortListInSetp})
    local portListStr=$(PortList2PortRangeStr "${portList[*]}")
    local dataPortListStr=$(PortList2PortRangeStr "${dataPortList[*]}")
    local portRange="${portListStr},${dataPortListStr}"
    # local portRange=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select PORTRANGE from TBL_SERVICE_PROCESS_INFO where processtype='${processType}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    # if [ -z "${portRange}" ];then
    #     ScriptPrintLog "portRange type is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    #     return 1
    # fi
    local createTime=$(date "+%Y-%m-%d %H:%M:%S")

    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;INSERT INTO TBL_SERVICE_PROCESS_INFO (SERVICETYPE, CLUSTERID, PROCESSTYPE, PROCESSID, SERVERID, PORTRANGE, CREATETIME) VALUES ('${serviceType}', ${clusterId}, '${processType}', ${processId}, ${serverId}, '${portRange}', '${createTime}');"
    if [ $? -ne 0 ];then
        ScriptPrintLog "Insert process info failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    return 0
}

function GenerateConfigItem()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    local outputFile=$4

    local var=$(eval declare -p "${processType}_ITEM_FUNC_MAP")
    eval "declare -A local componentItemFuncMap"=${var#*=}
    for key in ${!componentItemFuncMap[@]}
    do
        local itemVale=$(eval ${componentItemFuncMap[${key}]} ${controlClusterId} ${processType} ${serviceType})
        ScriptPrintLog "itemKey=${key} itemVale=${itemVale}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        echo "${key}=${itemVale}">>${outputFile}
        if [ $? -ne 0 ]; then
            return 1
        fi
    done
    return 0
}

function CheckResultFile()
{
    local componentName=$1
    local resultFailFile=$2
    if [[ -s "${resultFailFile}" ]]; then
        while read line
        do
            ScriptColorPrintLog "Node(${line}) process component(${componentName}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        done < ${resultFailFile}
        return 1
    fi
    return 0
}

# VBS非主节点可以批量重启，主节点放在最后重启即可
function VBS_BATCH_RESTART_NODE()
{
    local compName=$1
    local processType=$2
    local action=$3
    local logType=$4
    local processTypeRole=$5
    local params=$6
    local componentIps=$7
    local lastSuccIps=$8
    local masterVbsManageIp
    masterVbsManageIp=$(GetComponentMasterManageIpFromMdc "vbs")
    if [ -z "${masterVbsManageIp}" ]; then
        ScriptPrintLog "Component(${compName}) master manager ip is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    for ((i=0;i<${#componentIps[@]};i++))
    do
        [ x"${componentIps[i]}" == x"${masterVbsManageIp}" ] && { unset componentIps[i]; break; }
    done
    if [ ${#componentIps[*]} -ne 0 ]; then
        ScriptPrintLog "Begin parallel restart component(vbs) node ips(${componentIps[*]}) for component(${processTypeRole}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        ParallelBatchScp2RemoteAndExcute "${logType}" "" "" "${params[*]}" "${componentIps[*]}" "${lastSuccIps[*]}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "End restart component(${compName}) node ips(${componentIps[*]}) params(${params[*]}) for component(${processTypeRole}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "End parallel restart old node(${componentIps[*]}) component(${compName}) for component(${processTypeRole}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    fi
    ScriptPrintLog "Begin restart component(${compName}) master node(${masterVbsManageIp}) for component(${processTypeRole}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    RestartSingleNodeComponet "${processType}" "${compName}" "${masterVbsManageIp}" "${lastSuccIps[*]}" "${action}" "${logType}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End restart component(${compName}) master node(${masterVbsManageIp}) params(${params[*]}) for component(${processTypeRole}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End restart master node(${masterVbsManageIp}) component(${compName}) params(${params[*]}) for component(${processTypeRole}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    CheckResultFile "${compName}" "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log"
    if [ $? -ne 0 ]; then
        ScriptColorPrintLog "restart old node(${componentIps[*]} ${masterVbsManageIp}) component(${compName}) for component(${processTypeRole}) part failed, you can see failed node in file(fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    return 0
}

function GetUpgradeZone()
{
    local destIp=$1
    local component=$2
    ScriptExeLog "Begin get component(${component}) upgrade zone from node(${destIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local getCfgParams=("getUpgradeZone" "${component}")
    SingleNodeScp2RemoteAndExcute "${FUNCNAME}_${component}" "" "" "${getCfgParams[*]}" "${destIp}" >> "${SHELL_LOG_FULL_PATH}" 2>/dev/null
    local upgradeZoneJsonStr
    if [ $? -eq 0 ]; then
        upgradeZoneJsonStr=$(cat ${TMP_RESULT_FILE} |grep "@@PARAM=" |awk -F '@@' '{print$4}'|awk -F '=' '{print $2}')
        if [ -z "${upgradeZoneJsonStr}" ]; then
            ScriptExeLog "[ERROR]End get component(${component}) master from node(${destIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
    fi
    ScriptExeLog "End get component(${component}) upgrade zone from node(${destIp}) successfully,upgradeZone=${upgradeZoneJsonStr} [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    echo ${upgradeZoneJsonStr}
    return 0
}

# EbsCtrl节点按照eds升级域进行重启, 需要从主节点查询升级域
# /opt/dsware/eds/eds/script/nms_upgrade_zone.sh GetUpgradeZone 查询升级域
function EBS_BATCH_RESTART_NODE()
{
    # Step1 查询主Eds节点
    local compName=$1
    local processType=$2
    local action=$3
    local logType=$4
    local processTypeRole=$5
    local params=$6
    local componentIps=$7
    local lastSuccIps=$8
    local masterEdsManageIp
    # kmm_server刷新后不需要重启EBSCtrl
    if [ "${processType}" == "kmm_server" -a "${compName}" == "EBSCtrl" ];then
        ScriptPrintLog "End restart old node(${componentIps[*]}) component(${compName}) for component(${processTypeRole}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    masterEdsManageIp=$(GetComponentMasterManageIpFromMdc "EBSCtrl")
    if [ -z "${masterEdsManageIp}" ]; then
        ScriptPrintLog "Component(${compName}) master manager ip is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local upgradeZoneStr=$(GetUpgradeZone "${masterEdsManageIp}" "EBSCtrl")
    if [ -z "${upgradeZoneStr}" ];then
        ScriptPrintLog "Component(${compName}) upgrade zone is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    upgradeZoneStr=$(echo "${upgradeZoneStr}"|sed 's/:\[/=/g' |sed 's/\]/ /g'|sed 's/{\|}//g'|sed 's/ ,/ /g')
    local ipArray=$(awk -v string="${upgradeZoneStr}" 'BEGIN{n=split(string,array," ");for(i=1;i<=n;i++){split(array[i],line,"=");print line[2]}}')
    for ipZone in ${ipArray[@]}
    do
        ipZone=${ipZone//\"/\'}
        local zoneMgrIps=($(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -U omm -d omm -p 21600 -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO,TBL_SERVICE_PROCESS_INFO where TBL_SERVER_INFO.ID=TBL_SERVICE_PROCESS_INFO.SERVERID and TBL_SERVICE_PROCESS_INFO.PROCESSTYPE='EBSCtrl' and CLUSTERIP in (${ipZone}) ORDER BY SERVERID DESC;"|sed -n '3,$p'|grep -v row))
        ScriptPrintLog "Component(${compName}) batch zone ips is ${zoneMgrIps[*]}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        ParallelBatchScp2RemoteAndExcute "${logType}" "" "" "${params[*]}" "${zoneMgrIps[*]}" "${lastSuccIps[*]}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "End restart component(${compName}) node ips(${zoneMgrIps[*]}) params(${params[*]}) for component(${processTypeRole}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "End parallel restart old node(${zoneMgrIps[*]}) component(${compName}) for component(${processTypeRole}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        CheckResultFile "${compName}" "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log"
        if [ $? -ne 0 ]; then
            ScriptColorPrintLog "restart old node(${zoneMgrIps[*]} component(${compName}) for component(${processTypeRole}) part failed, you can see failed node in file(fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
    done
    return 0
}

# nodesentry/cmsworker可以批量全部重启
function GENERAL_BATCH_RESTART_NODE()
{
    local compName=$1
    local processType=$2
    local action=$3
    local logType=$4
    local processTypeRole=$5
    local params=$6
    local componentIps=$7
    local lastSuccIps=$8

    if [ ${#componentIps[*]} -ne 0 ]; then
        ScriptPrintLog "Begin parallel restart component($compName) node ips(${componentIps[*]}) for component(${processTypeRole}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        ParallelBatchScp2RemoteAndExcute "${logType}" "" "" "${params[*]}" "${componentIps[*]}" "${lastSuccIps[*]}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "End restart component(${compName}) node ips(${componentIps[*]}) params(${params[*]}) for component(${processTypeRole}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "End parallel restart old node(${componentIps[*]}) component(${compName}) for component(${processTypeRole}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        CheckResultFile "${compName}" "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log"
        if [ $? -ne 0 ]; then
            ScriptColorPrintLog "restart old node(${componentIps[*]}) component(${compName}) for component(${processTypeRole}) part failed, you can see failed node in file(fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
    fi
    return 0
}

function GENERAL_SERIAL_RESTART_NODE()
{
    local compName=$1
    local processType=$2
    local action=$3
    local logType=$4
    local processTypeRole=$5
    local params=$6
    local componentIps=$7
    local lastSuccIps=$8
    ScriptPrintLog "Begin restart component(${compName}) node ips(${componentIps[*]}) for component(${processTypeRole}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    BatchScp2RemoteAndExcute "${logType}" "" "" "${params[*]}" "${componentIps[*]}" "${lastSuccIps[*]}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End restart component(${compName}) node ips(${componentIps[*]}) params(${params[*]}) for component(${processTypeRole}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    CheckResultFile "${compName}" "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log"
    if [ $? -ne 0 ]; then
        ScriptColorPrintLog "restart old node(${componentIps[*]}) component(${compName}) for component(${processTypeRole}) part failed, you can see failed node in file(fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End restart old node(${componentIps[*]}) component(${compName}) for component(${processTypeRole}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}


function RefreshOldNodeComponentCfg()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    local action=$4

    local var=$(eval declare -p "${processType}_CFG_COMPONENTS")
    eval "declare -a local componentArray"=${var#*=}
    if [ ${#componentArray[*]} -eq 0 ]; then
        ScriptPrintLog "No need refresh old component(${processType}) configration. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    local fileName="${processType}""_""${serviceType}""_""${controlClusterId}_${action}.cfg"
    local outFile="${CUR_PATH}/${fileName}"
    if [ -f ${outFile} ];then
        rm -rf ${outFile}
    fi
    ScriptPrintLog "Begin generate component(${processType}) configration item to file(${outFile}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    GenerateConfigItem ${controlClusterId} ${processType} ${serviceType} "${outFile}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End generate component(${processType}) configration item to file(${outFile}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End generate component(${processType}) configration item to file(${outFile}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    for compName in ${componentArray[@]}
    do
        local componentIps=($(eval cat \$${compName}_NODE_OUTFILE))
        if [ ${#componentIps[*]} -eq 0 ];then
            ScriptPrintLog "Component(${compName}) no node to refresh configration. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        ScriptPrintLog "Begin refresh source component(${processType}) to component(${compName}) node ips(${componentIps[*]}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        local params=("refreshCfg" "${compName}" "${fileName}")
        local logType="${FUNCNAME}_${compName}_for_${processType}_${action}"
        local lastSuccIps=()
        if [ -s "fix_${logType}_${SUCC_NODE_LIST_SUFFIX}.log" ]; then
            lastSuccIps=$(cat fix_${logType}_${SUCC_NODE_LIST_SUFFIX}.log)
        fi
        ParallelBatchScp2RemoteAndExcute "${logType}" "${fileName}" "" "${params[*]}" "${componentIps[*]}" "${lastSuccIps[*]}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "End refresh source component(${processType}) to component(${compName}) node ips(${componentIps[*]}) params(${params[*]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        CheckResultFile "${compName}" "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log"
        if [ $? -ne 0 ]; then
            ScriptColorPrintLog "Refresh old node(${componentIps[*]}) component(${compName}) cfg for component(${processType}) part failed, you can see failed node in file(fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "End refresh old node(${componentIps[*]}) component(${compName}) cfg for component(${processType}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    done

    return 0
}

function GetComponentMasterManageIpFromMdc()
{
    local isGetCfgSucc=0
    local component=$1

    local componentIps
    if [ "${component}" == "vbs" ];then
        componentIps=($(cat ${mdc_NODE_OUTFILE}))
    elif [ "${component}" == "EBSCtrl" ]; then
        componentIps=($(cat ${EBSCtrl_NODE_OUTFILE}))
    elif [ "${component}" == "zk" ]; then
        componentIps=($(cat ${zk_NODE_OUTFILE}))
    fi
    if [ ${#componentIps[*]} -eq 0 ];then
        ScriptExeLog "mdc file(${mdc_NODE_OUTFILE}) no node to get master. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptExeLog "Begin get component(${component}) master from node(${componentIps[*]}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local getCfgParams=("getMasterFromMdc" "${component}")
    for compIp in ${componentIps[@]}
    do
        local compServerId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${compIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${compServerId}" ];then
            ScriptExeLog "ServerId is null for mdc node(${compIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        SingleNodeScp2RemoteAndExcute "${FUNCNAME}_${component}_${compServerId}" "" "operateComponetInAgent.sh" "${getCfgParams[*]}" "${compIp}" >> "${SHELL_LOG_FULL_PATH}" 2>/dev/null
        if [ $? -eq 0 ]; then
            local masterClusterIp=$(cat ${TMP_RESULT_FILE} |grep "@@PARAM=" |awk -F '@@' '{print$4}'|awk -F '=' '{print $2}')
            if [ -n "${masterClusterIp}" ]; then
                isGetCfgSucc=1
                ScriptExeLog "Get component(${component}) master from mdc node(${compIp}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
                break
            fi
        fi
        ScriptExeLog "Get component(${component}) master from mdc node(${compIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    done

    if [ "${isGetCfgSucc}" -ne 1 ]; then
        ScriptExeLog "Get component(${component}) master from nodes(${componentIps[@]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local manageIp=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select MANAGEIP from TBL_SERVER_INFO where CLUSTERIP='${masterClusterIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [ -z "${manageIp}" ];then
        ScriptExeLog "manageIp is null for node(${masterClusterIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    echo "${manageIp}"
    ScriptExeLog "End get component(${component}) master manage ip(${manageIp}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function RestartSingleNodeComponet()
{
    local processType=$1
    local compName=$2
    local nodeIp=$3
    local lastSuccIps=$4
    local action=$5
    local mergeLogType=$6

    local compServerId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${nodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [ -z "${compServerId}" ];then
        ScriptPrintLog "serverId is null for node ip(${nodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local logType="${FUNCNAME}_${compName}_for_${processType}_${action}_${compServerId}"
    local params=("restart" "${compName}" "${processType}")
    local componentIps=("${nodeIp}")
    ScriptPrintLog "Begin restart component(${compName}) master node ip(${componentIps[*]}) for component(${processType}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    BatchScp2RemoteAndExcute "${logType}" "" "" "${params[*]}" "${componentIps[*]}" "${lastSuccIps[*]}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End restart component(${compName}) node ips(${componentIps[*]}) params(${params[*]}) for component(${processType}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    if [ -s "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log" ]; then
        cat "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log" >> "fix_${mergeLogType}_${FAIL_NODE_LIST_SUFFIX}.log"
    fi

    if [ -s "fix_${logType}_${SUCC_NODE_LIST_SUFFIX}.log" ]; then
        cat "fix_${logType}_${SUCC_NODE_LIST_SUFFIX}.log" >> "fix_${mergeLogType}_${SUCC_NODE_LIST_SUFFIX}.log"
    fi
    ScriptPrintLog "End restart old node(${componentIps[*]}) component(${compName}) params(${params[*]}) for component(${processType}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function RestartOldNodeComponent()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    local action=$4
    local processTypeRole="${processType}"
    local var=$(eval declare -p "${processType}_CFG_COMPONENTS")
    eval "declare -a local componentArray"=${var#*=}
    if [ ${#componentArray[*]} -eq 0 ]; then
        ScriptPrintLog "No need restart old component(${processType}) configration. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    for compName in ${componentArray[@]}
    do
        local componentIps=($(eval cat \$${compName}_NODE_OUTFILE))
        if [ ${#componentIps[*]} -eq 0 ];then
            ScriptPrintLog "Component(${compName}) no node to refresh configration. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi

        ScriptPrintLog "Begin restart component(${compName}) node ips(${componentIps[*]}) for component(${processType}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        local params=("restart" "${compName}" "${processType}")
        local logType="${FUNCNAME}_${compName}_for_${processType}_${action}"
        local lastSuccIps=()
        if [ -s "fix_${logType}_${SUCC_NODE_LIST_SUFFIX}.log" ]; then
            lastSuccIps=$(cat fix_${logType}_${SUCC_NODE_LIST_SUFFIX}.log)
        fi
        for key in "${!COMPONENT_RESTART_FUNC_MAP[@]}"
        do
            if [ "${compName}" == "${key}" ];then
                ${COMPONENT_RESTART_FUNC_MAP[${key}]} "${compName}" "${processType}" "${action}" "${logType}" "${processTypeRole}" "${params[*]}" "${componentIps[*]}" "${lastSuccIps[*]}"
                if [ $? -ne 0 ];then
                    ScriptPrintLog "[ERROR]excute ${compName} restart func=${COMPONENT_RESTART_FUNC_MAP[${key}]} failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
                    return 1
                fi
            fi
        done
    done

    return 0
}

function CheckOldNodeComponentStatus()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    local action=$4

    local var=$(eval declare -p "${processType}_CFG_COMPONENTS")
    eval "declare -a local componentArray"=${var#*=}
    if [ ${#componentArray[*]} -eq 0 ]; then
        ScriptPrintLog "No need check old component(${processType}) status. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    local need_check_process_array=("ccdb_server" "dlm_mm" "cm" "osd")
    for compName in ${componentArray[@]}
    do
        local componentIps=($(eval cat \$${compName}_NODE_OUTFILE))
        if [ ${#componentIps[*]} -eq 0 ];then
            ScriptPrintLog "Component(${compName}) no node to refresh configration. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        ScriptPrintLog "Begin check status component(${compName}) node ips(${componentIps[*]}) for component(${processType}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        local params=("checkStatus" "${compName}")
        local logType="${FUNCNAME}_${compName}_${action}"
        local lastSuccIps=()
        for process in "${need_check_process_array[@]}"
        do
            if [ "${process}" == "${compName}" ];then
                ParallelBatchScp2RemoteAndExcute "${logType}" "" "" "${params[*]}" "${componentIps[*]}" "${lastSuccIps[*]}"
                if [ $? -ne 0 ]; then
                    ScriptPrintLog "End check status component(${compName}) node ips(${componentIps[*]}) params(${params[*]}) for component(${processTypeRole}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
                    return 1
                fi
                CheckResultFile "${compName}" "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log"
                if [ $? -ne 0 ]; then
                    ScriptColorPrintLog "check old node(${componentIps[*]}) component(${compName}) status for component(${processTypeRole}) part failed , you can see failed node in file(fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
                    return 1
                fi
            fi
        done
        ScriptPrintLog "End check old node(${componentIps[*]}) component(${compName}) status for component(${processType}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    done

    return 0
}

function GenerateLocalConfigItem()
{
    local controlClusterId=$1
    local processType=$2
    local serverId=$3
    local serviceType=$4
    local outputFile=$5

    # common item
    for key in ${!LOCAL_COMMON_ITEM_FUNC_MAP[@]}
    do
        local itemVale=$(eval ${LOCAL_COMMON_ITEM_FUNC_MAP[${key}]} ${controlClusterId} ${processType} ${serverId} ${serviceType})
        ScriptPrintLog "local itemKey=${key} itemVale=${itemVale}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        echo "${key}=${itemVale}">>${outputFile}
    done

    # process special item
    local var=$(eval declare -p "${processType}_LOCAL_ITEM_FUNC_MAP")
    eval "declare -A local compLocalItemFuncMap"=${var#*=}
    for localKey in ${!compLocalItemFuncMap[@]}
    do
        local localItemVale=$(eval ${compLocalItemFuncMap[${localKey}]} ${controlClusterId} ${processType} ${serverId} ${serviceType})
        ScriptPrintLog "itemKey=${localKey} itemVale=${localItemVale}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        echo "${localKey}=${localItemVale}">>${outputFile}
    done
}

function GenerateCfgFile2Node()
{
    local controlClusterId=$1
    local processType=$2
    local serverId=$3
    local serviceType=$4
    local nodeIp=$5
 
    local fileName="${processType}""_""${serviceType}""_""${controlClusterId}""_""${serverId}"".cfg"
    local outFile="${CUR_PATH}/${fileName}"

    if [ -f ${outFile} ];then
        rm -rf ${outFile}
    fi

    ScriptPrintLog "Begin generate component(${processType}) local config item to file(${outFile}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    GenerateLocalConfigItem ${controlClusterId} ${processType} ${serverId} ${serviceType} "${outFile}"
    ScriptPrintLog "End generate component(${processType}) local config item to file(${outFile}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}

    local cfgFileStr="${fileName}"
    local var=$(eval declare -p "${processType}_COMPONENT_CONFIGRATION")
    eval "declare -a local componentCfgArray"=${var#*=}
    if [ ${#componentCfgArray[*]} -ne 0 ]; then
        for compCfgFile in ${componentCfgArray[@]}
        do
            local compCfgName="${compCfgFile##*/}"
            local remoteCfgFile="${CUR_PATH}/${compCfgName}"
            if [ ! -f "${remoteCfgFile}" ]; then
                ScriptPrintLog "${compCfgFile} is not exist." ${FUNCNAME} ${SCRIPTNAME}
                continue
            fi
            if [ -n "${cfgFileStr}" ]; then
                cfgFileStr="${cfgFileStr} ${compCfgName}"
                continue
            fi
            cfgFileStr="${compCfgName}"
        done
    else
        ScriptPrintLog "no cfg file for component(${processType}) configration." ${FUNCNAME} ${SCRIPTNAME}
    fi

    ScriptPrintLog "Begin generate component(${processType}) cfg to node(${nodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local generateCfgParams=("generateComponetCfg" "${processType}" "${fileName}")
    SingleNodeScp2RemoteAndExcute "${FUNCNAME}_${processType}_${serverId}" "${cfgFileStr}" "" "${generateCfgParams[*]}" "${nodeIp}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End generate component(${processType}) cfg to node(${nodeIp}) file(${cfgFileStr}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End generate component(${processType}) cfg to node(${nodeIp}) file(${cfgFileStr}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function GetComponetCfgFromOldNode()
{
    local isGetCfgSucc=0
    local component=$1

    local componentIps=($(eval cat \$${component}_NODE_OUTFILE))
    if [ ${#componentIps[*]} -eq 0 ];then
        ScriptPrintLog "Component(${component}) file(${component}_NODE_OUTFILE) no node to refresh configration. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "Begin get component(${component}) cfg from node. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local getCfgParams=("getCfg" "${component}" "${CUR_PATH}")
    for compIp in ${componentIps[@]}
    do
        local compServerId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${compIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${compServerId}" ];then
            ScriptPrintLog "ServerId is null for node(${compIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        SingleNodeScp2RemoteAndExcute "${FUNCNAME}_${component}_${compServerId}" "" "" "${getCfgParams[*]}" "${compIp}"
        if [ $? -eq 0 ]; then
            ScriptPrintLog "Get component(${component}) cfg from node(${compIp}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            isGetCfgSucc=1
            break
        fi
        ScriptPrintLog "Get component(${component}) cfg from node(${compIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    done

    if [ "${isGetCfgSucc}" -ne 1 ]; then
        ScriptPrintLog "Get component(${component}) cfg from nodes(${componentIps[@]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End get component(${component}) cfg from node successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function BatchGenerateComponetCfg4NewNode()
{
    local isGetCfgSucc=0
    local clusterId=$1
    local component=$2
    local serviceType=$3

    GetComponetCfgFromOldNode ${component}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Get component(${component}) cfg from olde node failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        ScriptPrintLog "Begin generate component(${component}) cfg to node(${expandNodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        local serverId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${expandNodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${serverId}" ];then
            ScriptPrintLog "ServerId is null for node(${expandNodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi

        GenerateCfgFile2Node ${clusterId} ${component} ${serverId} ${serviceType} ${expandNodeIp} 
        if [ $? -ne 0 ]; then
            ScriptPrintLog "End generate component(${component}) cfg to node(${expandNodeIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "End generate component(${component}) cfg to node(${expandNodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    done
    return 0
}

function GET_POSITION_BY_MANAGE_IP()
{
    local manageIp=$1
    local rackNo=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select RACKNO from TBL_SERVER_INFO where MANAGEIP='${manageIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    local subRackNo=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select SUBRACKNO from TBL_SERVER_INFO where MANAGEIP='${manageIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    local slotId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select SLOTID from TBL_SERVER_INFO where MANAGEIP='${manageIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [ -z "${slotId}" ]; then
        slotId="0"
    fi
    echo "${rackNo}:${subRackNo}:${slotId}"
}

function AddProcess()
{
    local controlClusterId=$1
    local processType=$2
    local serverId=$3
    local serviceType=$4
    local nodeIp=$5

    ScriptPrintLog "Begin add component(${processType}) process to node(${nodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local params=("addProcess" "${processType}")
    SingleNodeScp2RemoteAndExcute "${FUNCNAME}_${processType}_${serverId}" "" "" "${params[*]}" "${nodeIp}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End add component(${processType}) process to node(${nodeIp}) params(${params[*]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End add component(${processType}) process to node(${nodeIp}) params(${params[*]}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function BatchAddProcess()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        local serverId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${expandNodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${serverId}" ];then
            ScriptPrintLog "ServerId is null for node(${expandNodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        AddProcess ${clusterId} ${processType} ${serverId} ${serviceType} ${expandNodeIp} 
        if [ $? -ne 0 ]; then
            ScriptPrintLog "Add component(${processType}) to node ip(${ip}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    done
    return 0
}

function CheckNewNodeComponentStatus()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        ScriptPrintLog "Begin check status component(${processType}) node(${expandNodeIp}) status. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        local params=("checkStatus" "${processType}")
        local logType="${FUNCNAME}_${processType}"
        SingleNodeScp2RemoteAndExcute "${logType}" "" "" "${params[*]}" "${expandNodeIp}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "End check status component(${processType}) node(${expandNodeIp}) params(${params[*]}) status failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        CheckResultFile "${processType}" "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log"
        if [ $? -ne 0 ]; then
            ScriptColorPrintLog "check new node(${expandNodeIp}) component(${processType}) status failed, you can see failed node in file(fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "End check new node(${expandNodeIp}) component(${processType}) status successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    done
    return 0
}


function NotifyCmExpandComponet()
{
    local controlClusterId=$1
    local processType=$2
    local serverId=$3
    local serviceType=$4
    local nodeIp=$5

    if [ "${processType}" = "cm" ]; then
        ScriptPrintLog "The ${processType} process no need to notify cm expand. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    local positon=$(GET_POSITION_BY_MANAGE_IP ${nodeIp})
    ScriptPrintLog "Begin notify cm expand component(${processType}) process to node(${nodeIp}) positon(${positon}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local params=("expandLs" "${processType}" "${positon}")
    SingleNodeScp2RemoteAndExcute "${FUNCNAME}_${processType}_${serverId}" "" "" "${params[*]}" "${nodeIp}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End notify cm expand component(${processType}) process to node(${nodeIp}) positon(${positon}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End notify cm expand component(${processType}) process to node(${nodeIp}) positon(${positon}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function BatchNotifyCmExpandComponet()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        local serverId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${expandNodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${serverId}" ];then
            ScriptPrintLog "ServerId is null for node(${expandNodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        NotifyCmExpandComponet ${clusterId} ${processType} ${serverId} ${serviceType} ${expandNodeIp} 
        if [ $? -ne 0 ]; then
            ScriptPrintLog "Notify cm expand component(${processType}) to node ip(${expandNodeIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    done
    return 0
}

function BatchCreateSingleComponentDb()
{
    local componentName=$1
    local clusterId=$2
    local serviceType=$3
    local isInsertProcessInfo=0
    ScriptPrintLog "Begin to create component(${componentName}) ips(${EXPAND_NODE_MANAGE_IP_LIST[*]}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        local ip=${expandNodeIp}
        local serverId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${ip}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${serverId}" ];then
            ScriptPrintLog "ServerId is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi

        insertProcessInfo2Db ${serviceType} ${clusterId} ${componentName} ${serverId}
        local insertResult=$?
        if [ ${insertResult} -eq 1 ]; then
            ScriptPrintLog "Insert component(${componentName}) to node ip(${ip}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        if [ ${insertResult} -eq 0 ]; then
            ScriptPrintLog "Insert component(${componentName}) to node ip(${ip}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            isInsertProcessInfo=1
        fi
    done

    if [ ${isInsertProcessInfo} -eq 1 ]; then
        UpdateLastGenLsId
        if [ $? -ne 0 ]; then
            ScriptPrintLog "Update last generate ls id failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
    fi
    ScriptPrintLog "End to create component(${componentName}) ips(${EXPAND_NODE_MANAGE_IP_LIST[*]}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function AddAcl()
{
    local processType=$1
    local clusterIp=$2
    local clusterId=$3
    local clusterType=$4
    local serverId=$5
    local componentIps=($(eval cat \$${processType}_NODE_OUTFILE))
    if [ ${#componentIps[*]} -eq 0 ];then
        ScriptPrintLog "Component(${processType}) no old node. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    local params=("addAcl" ${clusterIp} ${clusterId} ${clusterType})
    for compIp in ${componentIps[@]}
    do
        SingleNodeScp2RemoteAndExcute "${FUNCNAME}_${processType}_${serverId}" "" "operateComponetInAgent.sh" "${params[*]}" "${compIp}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "Add component(${processType} ${compIp}) acl from node ip(clusterip ${clusterIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "Add component(${processType}) acl from node ip(clusterip ${clusterIp}) sucessfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    done
    ScriptPrintLog "Add component(${processType}) acl from node ip(clusterip ${clusterIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function BatchAddAcl()
{
    local processType=$1
    if [ "${processType}" != "cm" ]; then
        return 0
    fi
    local clusterId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select CLUSTERID from TBL_SERVICE_CLUSTER_INFO where SERVICETYPE='eds';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [ -z "${clusterId}" ];then
        ScriptPrintLog "clusterId is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local clusterType="EDS"

    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        local clusterIp=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select CLUSTERIP from TBL_SERVER_INFO where MANAGEIP='${expandNodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${clusterIp}" ];then
            ScriptPrintLog "clusterIp is null for node(${expandNodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        local serverId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${expandNodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${serverId}" ];then
            ScriptPrintLog "ServerId is null for node(${expandNodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        AddAcl ${processType} ${clusterIp} ${clusterId} ${clusterType} ${serverId}
        if [ $? -ne 0 ]; then
            ScriptPrintLog "Add comp(${processType}) for node(cluster ip ${clusterIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
    done
    return 0
}

function BatchExpandSingleComponent()
{
    local componentName=$1
    local serviceType=$2

    ScriptPrintLog "Begin to expand component(${componentName}) to node ips(${EXPAND_NODE_MANAGE_IP_LIST[*]}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local clusterId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select CLUSTERID from TBL_SERVICE_CLUSTER_INFO where SERVICETYPE='${serviceType}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [ -z "${clusterId}" ];then
        ScriptPrintLog "ClusterId is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    BatchCreateSingleComponentDb ${componentName} ${clusterId} ${serviceType}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Insert component(${componentName}) to node ips(${EXPAND_NODE_MANAGE_IP_LIST[*]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    RefreshOldNodeComponentCfg ${clusterId} ${componentName} ${serviceType} "expand"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Refresh component(${componentName}) old node info failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    BatchGenerateComponetCfg4NewNode ${clusterId} ${componentName} ${serviceType}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "batch sync component(${componentName}) old node info failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    BatchNotifyCmExpandComponet ${clusterId} ${componentName} ${serviceType}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Batch nority cm expand componet failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    RestartOldNodeComponent ${clusterId} ${componentName} ${serviceType} "expand"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Reboot component(${componentName}) relation old node info failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    CheckOldNodeComponentStatus ${clusterId} ${componentName} ${serviceType} "expand"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "check component(${componentName}) old node status failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    BatchAddProcess ${clusterId} ${componentName} ${serviceType}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Add component(${componentName}) to node ips(${EXPAND_NODE_MANAGE_IP_LIST[*]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    CheckNewNodeComponentStatus ${clusterId} ${componentName} ${serviceType}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "check component(${componentName}) old node status failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    BatchAddAcl ${componentName}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Add component(${componentName}) acl failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    ScriptPrintLog "End to expand component(${componentName}) to node ips(${EXPAND_NODE_MANAGE_IP_LIST[*]}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function ExpandEdsContorolCluster()
{
    GetIpList

    for component in ${EXPANDENT_COMPONENTS[*]}
    do
        ScriptPrintLog "Begin to expand eds control cluster to component(${component}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        BatchExpandSingleComponent ${component} "eds"
        if [ $? -ne 0 ];then
            ScriptPrintLog "Expand component(${component}) to node(${EXPAND_NODE_MANAGE_IP_LIST[*]})) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi

        ScriptPrintLog "End to expand eds control cluster to component(${component}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    done
    return 0
}

function ZK_SERIAL_RESTART_NODE() {
    local compName=$1
    local processType=$2
    local action=$3
    local logType=$4
    local processTypeRole=$5
    local params=$6
    local componentIps=$7
    local lastSuccIps=$8
    # 查主zk
    local masterZkManageIp=$(GetComponentMasterManageIpFromMdc "${compName}")
    if [ -z "${masterZkManageIp}" ]; then
        ScriptPrintLog "Component(${compName}) master manager ip is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    # GetIpList流程里就已经踢掉了新扩容的节点，ZkNode.List里只会有老节点
    # 如果节点里有主zk，拿出来放到最后重启
    local masterIp=""
    local restartNonMasterNodes=(${componentIps[*]})
    for compIp in ${componentIps[*]}
    do
        ScriptPrintLog "CompIp is (${compIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        if [[ x"${compIp}" == x"${masterZkManageIp}" ]]; then
            ScriptPrintLog "MasterIp need final restart . [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            masterIp=${masterZkManageIp}
            restartNonMasterNodes=(${restartNonMasterNodes[@]/${compIp}/})
            break
        fi
    done

    ScriptPrintLog "Begin restart component(${compName}) node ips(${restartNonMasterNodes[*]}) for component(${processTypeRole}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    BatchScp2RemoteAndExcute "${logType}" "" "" "${params[*]}" "${restartNonMasterNodes[*]}" "${lastSuccIps[*]}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End restart component(${compName}) node ips(${restartNonMasterNodes[*]}) params(${params[*]}) for component(${processTypeRole}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    CheckResultFile "${compName}" "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log"
    if [ $? -ne 0 ]; then
        ScriptColorPrintLog "restart old node(${restartNonMasterNodes[*]}) component(${compName}) for component(${processTypeRole}) part failed, you can see failed node in file(fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End restart old node(${restartNonMasterNodes[*]}) component(${compName}) for component(${processTypeRole}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}

    if [ -z "${masterIp}" ]; then
        ScriptPrintLog "Master component(${compName}) node(${masterZkManageIp}) no need restart. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    ScriptPrintLog "Begin restart master component(${compName}) node(${masterIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    RestartSingleNodeComponet "${processType}" "${compName}" "${masterIp}" "${lastSuccIps[*]}" "${action}" "${logType}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End restart component(${compName}) master node(${masterIp}) params(${params[*]}) for component(${processTypeRole}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    return 0
}

function RefreshMediaDisk() {
    # 刷新老zk节点的配置
    local refreshNodes=("$@")
    if [ ${#refreshNodes[*]} -eq 0 ]; then
        ScriptPrintLog "No Component(${component}) need refresh. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    local refreshParams=("refreshMediaDiskInfo" "${component}")
    for compIp in ${refreshNodes[@]}
    do
        ScriptPrintLog "Begin refresh component(${component}) mediaDiskInfo to node(${compIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        local compServerId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${compIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${compServerId}" ];then
            ScriptPrintLog "ServerId is null for node(${compIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        SingleNodeScp2RemoteAndExcute "${FUNCNAME}_${component}_${compServerId}" "" "" "${refreshParams[*]}" "${compIp}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "End refresh component(${component}) mediaDiskInfo to node(${compIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "End refresh component(${component}) mediaDiskInfo to node(${compIp}) success. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    done

    ScriptPrintLog "End refresh component(${component}) mediaDiskInfo to nodes(${refreshNodes[*]}) success. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

# 获取节点的mediaDiskInfo
# 获取失败返回1，中断流程；返回0说明该字段存在，不需要刷新；返回2需要刷新
function GetMediaDiskInfo() {
    local component=$1
    local nodeIp=$2
    local getParams=$3
    ScriptPrintLog "Begin get component(${component}) mediaDiskInfo from node(${nodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local serverId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${nodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [ -z "${serverId}" ];then
        ScriptPrintLog "ServerId is null for node(${expandNodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        continue
    fi
    SingleNodeScp2RemoteAndExcute "${FUNCNAME}_${component}_${serverId}" "" "" "${getParams[*]}" "${nodeIp}"
    if [ $? -ne 0 ]; then
        ScriptExeLog "End get component(${component}) mediaDiskInfo from node(${nodeIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local mediaDiskInfo=$(cat ${TMP_RESULT_FILE} |grep "@@PARAM=" |awk -F '@@' '{print$4}'|awk -F '=' '{print $2}')
    if [ -n "${mediaDiskInfo}" ]; then
        ScriptExeLog "End get component(${component}) node(${nodeIp}) exist mediaDiskInfo(${mediaDiskInfo}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    ScriptExeLog "End get component(${component}) node(${nodeIp}) not exist mediaDiskInfo(${mediaDiskInfo}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 2
}

# 刷新老zk节点的配置文件，如果是系统盘分区部署，需要重启zk进程（先从后主）
# 就目前场景来说，只是老节点会一起丢失mediaDiskInfo配置项
# 考虑混合部署场景，各个节点的盘类型不一样
# GetIpList流程里会踢掉扩容节点，ZkNode.List里不会有新扩节点
function RefreshOldNodeMediaDiskForZk() {
    local component=$1
    local getParams=("getMediaDiskInfo" "${component}")
    local componentIps=($(eval cat \$${component}_NODE_OUTFILE))
    # 1、获取zk配置文件里没有mediaDiskInfo的节点
    local refreshNodes=()
    for nodeIp in ${componentIps[*]}
    do
        # 获取失败返回1，中断流程；返回0说明该字段存在，不需要刷新；返回2需要刷新
        GetMediaDiskInfo "${component}" "${nodeIp}" "${getParams[*]}"
        local result=$?
        if [ "${result}" -eq 1 ]; then
            ScriptPrintLog "Get component(${component}) mediaDiskInfo from node(${nodeIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        elif [ "${result}" -eq 2 ]; then
            ScriptPrintLog "Component(${component}) node(${nodeIp}) need refresh mediaDiskInfo. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            refreshNodes+=("${nodeIp}")
        fi
    done
    # 2、刷新配置
    RefreshMediaDisk "${refreshNodes[@]}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End refresh component(${component}) mediaDiskInfo to nodes(${refreshNodes[*]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    # 重启zk，先从后主
    RestartOldNodeComponent "" ${component} "" "expand"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End restart component(${component}) old node failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End restart component(${component})  success. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function ExpandEdsCmCluster()
{
    # 扩zk的时候，老节点的mediaDiskInfo字段丢失，在扩cm前先刷回去，如果是系统盘分区还要重启zk(先从后主)
    # 为了工具不用适配，放在扩cm步骤里优先执行
    RefreshOldNodeMediaDiskForZk "zk"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End refresh and restart zk failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End refresh and restart zk success. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}

    BatchExpandSingleComponent "cm" "eds"
}

function ExpandEdsCcdbMonitorCluster()
{
    BatchExpandSingleComponent "ccdb_monitor" "eds"
}

function ExpandEdsCcdbServerCluster()
{
    BatchExpandSingleComponent "ccdb_server" "eds"
}
function ExpandEdsDjobCluster()
{
    BatchExpandSingleComponent "djob" "eds"
}
function ExpandEdsDlmVmCluster()
{
    BatchExpandSingleComponent "dlm_vm" "eds"
}
function ExpandEdsDlmMmCluster()
{
    BatchExpandSingleComponent "dlm_mm" "eds"
}
function ExpandEdsKmmServerCluster()
{
    BatchExpandSingleComponent "kmm_server" "eds"
    ClearNodeOperateScript
}

################################################################################################################################
function ClearAlComponentAgentScriptLog()
{
    local allIps=()
    for compName in ${CHECK_LINK_COMPONENTS[@]}
    do
        local componentIps=($(eval cat \$${compName}_NODE_OUTFILE))
        if [ ${#componentIps[*]} -eq 0 ];then
            ScriptPrintLog "Component(${compName}) no node to check node link. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        allIps+=(${componentIps[*]})
    done
    allIps=($(echo ${allIps[*]}|sed 's/ /\n/g'|sort|uniq))
    compName="ALL"
    ScriptPrintLog "Begin ClearAlComponentAgentScriptLog component(${compName}) node ips(${allIps[*]}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local params=("clearAgentLog" "${compName}")
    local logType="${FUNCNAME}_${compName}"
    local lastSuccIps=()
    BatchScp2RemoteAndExcute "${logType}" "" "operateComponetInAgent.sh" "${params[*]}" "${allIps[*]}" "${lastSuccIps[*]}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End ClearAlComponentAgentScriptLog component(${compName}) node ips(${allIps[*]}) params(${params[*]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    CheckResultFile "${compName}" "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log"
    if [ $? -ne 0 ]; then
        ScriptColorPrintLog "ClearAlComponentAgentScriptLog node(${allIps[*]}) component(${compName}) part failed, you can see failed node in file(fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End ClearAlComponentAgentScriptLog node(${allIps[*]}) component(${compName}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function ClearAgentScriptLog()
{   
    local oldScpTimeOut=${SCP_TIMEOUT}
    local oldExecuteTimeOut=${EXECUTE_TIMEOUT}
    SCP_TIMEOUT="300"
    EXECUTE_TIMEOUT="60"
    ClearAlComponentAgentScriptLog
    local clearResult=$?
    oldScpTimeOut=${SCP_TIMEOUT}
    oldExecuteTimeOut=${EXECUTE_TIMEOUT}
    if [ ${clearResult} -ne 0 ]; then
        ScriptPrintLog "clear agent script log failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return ${clearResult}
    fi

    ScriptPrintLog "clear agent script log successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}
###################################################################################################################################################################################

HA_SCRIPT_FILE="/opt/dfv/oam/oam-u/ha/ha/module/hacom/script/get_harole.sh"
function IsStandbyNode()
{
    local role=$(bash ${HA_SCRIPT_FILE} 2>/dev/null)
    local i=1
    ScriptPrintLog "role = $role. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    while [ $i -le 100 ]
    do
        if [[ "${role}" == "active" ]] || [[ "${role}" == "standby" ]];
        then
            break
        else
            ScriptPrintLog "role is ${role}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            sleep 5
            role=$(bash ${HA_SCRIPT_FILE} 2>/dev/null)
            let i++
        fi
    done

    if [[ "${role}" == "active" ]];
    then
        return 0
    else
        return 1
    fi
}

function CheckExpandNodeRole()
{
    if [ ${#EXPAND_NODE_MANAGE_IP_LIST[*]} -eq 0 ]; then
        ScriptColorPrintLog "The expanded node list is null, please input expand node manage ip list. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        local role=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ROLE from TBL_SERVER_INFO where MANAGEIP='${expandNodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [[ ! "${role}" =~ "${STORAGE_ROLE}" ]]; then
            ScriptPrintLog "The expanded node(${expandNodeIp}) role must include ${STORAGE_ROLE}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
    done
    ScriptPrintLog "Check expand node role is ok. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function CheckZkIsExist()
{
    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do
       local serverId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_ZK_SERVER_INFO,TBL_SERVER_INFO where TBL_SERVER_INFO.ID=TBL_ZK_SERVER_INFO.SERVERID and MANAGEIP='${expandNodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
       if [ -z "${serverId}" ]; then
            ScriptPrintLog "The expand node(${expandNodeIp}) is not zk node. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
       fi
    done
    ScriptPrintLog "Check expand node zk is ok. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}
######################################################################
#   FUNCTION   : Cautious
#   DESCRIPTION: 提示高危操作，要求用户输入操作以继续
#   CALLS      : NULL
#   CALLED BY  : NULL
#   INPUT      : NULL
#   OUTPUT     : NULL
#   RETURN     : NULL
######################################################################
Cautious()
{
    read -p "This operation is high risk,please input y to continue:" operation
    if [ "${operation}" != "y" ];then
        ScriptPrintLog "Operation stop."
        exit 1
    fi
}

function usage()
{
    echo "Usage: ${0##*/} {ExpandEdsCmCluster|ExpandEdsCcdbMonitorCluster|ExpandEdsCcdbServerCluster|ExpandEdsDjobCluster|ExpandEdsDlmVmCluster|ExpandEdsDlmMmCluster|ExpandEdsKmmServerCluster}"
    exit 1
}

#################################################################################################################################
function DeleteProcess()
{
    local controlClusterId=$1
    local processType=$2
    local serverId=$3
    local serviceType=$4
    local nodeIp=$5

    ScriptPrintLog "Begin delete component(${processType}) process to node(${nodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local params=("deleteProcess" "${processType}")
    SingleNodeScp2RemoteAndExcute "${FUNCNAME}_${processType}_${serverId}" "" "operateComponetInAgent.sh" "${params[*]}" "${nodeIp}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End delete component(${processType}) process to node(${nodeIp}) params(${params[*]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End delete component(${processType}) process to node(${nodeIp}) params(${params[*]}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function BatchDeleteProcess()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        local serverId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${expandNodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${serverId}" ];then
            ScriptPrintLog "ServerId is null for node(${expandNodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        DeleteProcess ${clusterId} ${processType} ${serverId} ${serviceType} ${expandNodeIp} 
        if [ $? -ne 0 ]; then
            ScriptPrintLog "delete component(${processType}) to node ip(${ip}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    done
    return 0
}

function deleteProcessInfo2Db()
{
    local serviceType=$1
    local clusterId=$2
    local processType=$3
    local serverId=$4

    # server id 
    local processInfoCount=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select count(1) from TBL_SERVICE_PROCESS_INFO where PROCESSTYPE='${processType}' and SERVERID=${serverId} and SERVICETYPE='${serviceType}' and CLUSTERID=${clusterId};"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [ ${processInfoCount} -eq 0 ]; then
        ScriptPrintLog "Node (${serverIp}) not exist component(${processType}), count(${processInfoCount}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    /opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;DELETE TBL_SERVICE_PROCESS_INFO where PROCESSTYPE='${processType}' and SERVERID=${serverId} and SERVICETYPE='${serviceType}' and CLUSTERID=${clusterId};"
    if [ $? -ne 0 ];then
        ScriptPrintLog "delete process info failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    return 0
}

function BatchDeleteSingleComponentDb()
{
    local componentName=$1
    local clusterId=$2
    local serviceType=$3

    ScriptPrintLog "Begin to detete component(${componentName}) ips(${EXPAND_NODE_MANAGE_IP_LIST[*]}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        local ip=${expandNodeIp}
        local serverId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${ip}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${serverId}" ];then
            ScriptPrintLog "ServerId is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi

        deleteProcessInfo2Db ${serviceType} ${clusterId} ${componentName} ${serverId}
        if [ $? -ne 0 ]; then
            ScriptPrintLog "delete component(${componentName}) to node ip(${ip}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
    done
    ScriptPrintLog "End to detete component(${componentName}) ips(${EXPAND_NODE_MANAGE_IP_LIST[*]}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function NotifyCmReduceComponet()
{
    local controlClusterId=$1
    local processType=$2
    local serverId=$3
    local serviceType=$4
    local nodeIp=$5

    if [ "${processType}" = "cm" ]; then
        ScriptPrintLog "The ${processType} process no need to notify cm reduce. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    ScriptPrintLog "Begin notify cm reduce component(${processType}) process to node(${nodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local params=("reduceLs" "${processType}")
    SingleNodeScp2RemoteAndExcute "${FUNCNAME}_${processType}_${serverId}" "" "operateComponetInAgent.sh" "${params[*]}" "${nodeIp}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End notify cm reduce component(${processType}) process to node(${nodeIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End notify cm reduce component(${processType}) process to node(${nodeIp}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function BatchNotifyCmReduceComponent()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        local serverId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${expandNodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${serverId}" ];then
            ScriptPrintLog "ServerId is null for node(${expandNodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        NotifyCmReduceComponet ${clusterId} ${processType} ${serverId} ${serviceType} ${expandNodeIp} 
        if [ $? -ne 0 ]; then
            ScriptPrintLog "Notify cm reduce component(${processType}) to node ip(${expandNodeIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    done
    return 0
}

function RemoveAcl()
{
    local processType=$1
    local clusterIp=$2
    local clusterId=$3
    local clusterType=$4
    local serverId=$5
    local componentIps=($(eval cat \$${processType}_NODE_OUTFILE))
    if [ ${#componentIps[*]} -eq 0 ];then
        ScriptPrintLog "Component(${processType}) no old node. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    local params=("removeAcl" ${clusterIp} ${clusterId} ${clusterType})
    for compIp in ${componentIps[@]}
    do
        SingleNodeScp2RemoteAndExcute "${FUNCNAME}_${processType}_${serverId}" "" "operateComponetInAgent.sh" "${params[*]}" "${compIp}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "Remove component(${processType} ${compIp}) acl from node ip(clusterip ${clusterIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        return 0
    done
    ScriptPrintLog "Remove component(${processType}) acl from node ip(clusterip ${clusterIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function BatchRemoveAcl()
{
    local processType=$1
    if [ "${processType}" != "cm" ]; then
        return 0
    fi
    local clusterId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select CLUSTERID from TBL_SERVICE_CLUSTER_INFO where SERVICETYPE='eds';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [ -z "${clusterId}" ];then
        ScriptPrintLog "clusterId is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local clusterType="EDS"

    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        local clusterIp=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select CLUSTERIP from TBL_SERVER_INFO where MANAGEIP='${expandNodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${clusterIp}" ];then
            ScriptPrintLog "clusterIp is null for node(${expandNodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        local serverId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select ID from TBL_SERVER_INFO where MANAGEIP='${expandNodeIp}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
        if [ -z "${serverId}" ];then
            ScriptPrintLog "ServerId is null for node(${expandNodeIp}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        RemoveAcl ${processType} ${clusterIp} ${clusterId} ${clusterType} ${serverId}
        if [ $? -ne 0 ]; then
            ScriptPrintLog "Remove comp(${processType}) for node(cluster ip ${clusterIp}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
    done
    return 0
}

function ClearProcessConfigFile()
{
    local controlClusterId=$1
    local processType=$2
    local serviceType=$3
    for expandNodeIp in ${EXPAND_NODE_MANAGE_IP_LIST[*]}
    do 
        ScriptPrintLog "Begin clear new component(${processType}) node(${expandNodeIp}) cfg. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        local params=("clearProcessConfigFile" "${processType}")
        local logType="${FUNCNAME}_${processType}"
        SingleNodeScp2RemoteAndExcute "${logType}" "" "operateComponetInAgent.sh" "${params[*]}" "${expandNodeIp}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "End clear component(${processType}) new node(${expandNodeIp}) params(${params[*]}) cfg failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        CheckResultFile "${processType}" "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log"
        if [ $? -ne 0 ]; then
            ScriptColorPrintLog "clear new node(${expandNodeIp}) component(${processType}) cfg failed, you can see failed node in file(fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "clear new node(${expandNodeIp}) component(${processType}) cfg successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    done
    return 0
}

function BatchRollbackSingleComponent()
{
    local componentName=$1
    local serviceType=$2

    ScriptPrintLog "Begin to reduce component(${componentName}) to node ips(${EXPAND_NODE_MANAGE_IP_LIST[*]}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local clusterId=$(/opt/dfv/oam/oam-u/oam-gaussdb/app/bin/gsql -h 127.0.0.1 -p 21600 -U omm -W ${DecryptPasswd} -c "set search_path=dsware_1;select CLUSTERID from TBL_SERVICE_CLUSTER_INFO where SERVICETYPE='${serviceType}';"|sed -n '3p'|grep -v row| awk '{gsub(/^\s+|\s+$/, "");print}')
    if [ -z "${clusterId}" ];then
        ScriptPrintLog "ClusterId is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    ##########################new node#####################################
    # remove
    BatchRemoveAcl ${componentName}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "remove component(${componentName}) acl failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    BatchDeleteProcess ${clusterId} ${componentName} ${serviceType}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "delete component(${componentName}) to node ips(${EXPAND_NODE_MANAGE_IP_LIST[*]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    # reduce use the cfg
    BatchNotifyCmReduceComponent ${clusterId} ${componentName} ${serviceType}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Batch nority cm reduce componet failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    # clear cfg
    ClearProcessConfigFile ${clusterId} ${componentName} ${serviceType}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Batch clear process(${componentName}) configuration failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    # delete DB
    BatchDeleteSingleComponentDb ${componentName} ${clusterId} ${serviceType}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Insert component(${componentName}) to node ips(${EXPAND_NODE_MANAGE_IP_LIST[*]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ##########################new node#####################################
    ##################old node ################
    RefreshOldNodeComponentCfg ${clusterId} ${componentName} ${serviceType} "rollback"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Refresh component(${componentName}) old node info failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    RestartOldNodeComponent ${clusterId} ${componentName} ${serviceType} "rollback"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Reboot component(${componentName}) relation old node info failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    CheckOldNodeComponentStatus ${clusterId} ${componentName} ${serviceType} "rollback"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "check component(${componentName}) old node status failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ##################old node ################

    ScriptPrintLog "End to rollback component(${componentName}) to node ips(${EXPAND_NODE_MANAGE_IP_LIST[*]}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function RollbackEdsCmCluster()
{
    BatchRollbackSingleComponent "cm" "eds"
}

function RollbackEdsCcdbMonitorCluster()
{
    BatchRollbackSingleComponent "ccdb_monitor" "eds"
}

function RollbackEdsCcdbServerCluster()
{
    BatchRollbackSingleComponent "ccdb_server" "eds"
}
function RollbackEdsDjobCluster()
{
    BatchRollbackSingleComponent "djob" "eds"
}
function RollbackEdsDlmVmCluster()
{
    BatchRollbackSingleComponent "dlm_vm" "eds"
}
function RollbackEdsDlmMmCluster()
{
    BatchRollbackSingleComponent "dlm_mm" "eds"
}
function RollbackEdsKmmServerCluster()
{
    BatchRollbackSingleComponent "kmm_server" "eds"
}
function RollbackEdsContorolCluster()
{
    for component in ${ROLLBACK_COMPONENTS[*]}
    do
        ScriptPrintLog "Begin to rollback eds control cluster to component(${component}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        BatchRollbackSingleComponent ${component} "eds"
        if [ $? -ne 0 ];then
            ScriptPrintLog "Rollback component(${component}) to node(${EXPAND_NODE_MANAGE_IP_LIST[*]})) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi

        ScriptPrintLog "End to rollback eds control cluster to component(${component}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    done
    return 0
}

##################################################################################################################################
function CheckAllComponentNodeLink()
{
    local allIps=()
    for compName in ${CHECK_LINK_COMPONENTS[@]}
    do
        local componentIps=($(eval cat \$${compName}_NODE_OUTFILE))
        if [ ${#componentIps[*]} -eq 0 ];then
            ScriptPrintLog "Component(${compName}) no node to check node link. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        allIps+=(${componentIps[*]})
    done
    allIps+=(${EXPAND_NODE_MANAGE_IP_LIST[*]})
    allIps=($(echo ${allIps[*]}|sed 's/ /\n/g'|sort|uniq))
    compName="ALL"
    ScriptPrintLog "Begin CheckAlComponentNodeLink component(${compName}) node ips(${allIps[*]}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local params=("checkLink" "${compName}")
    local logType="${FUNCNAME}_${compName}"
    local lastSuccIps=()
    if [ -s "fix_${logType}_${SUCC_NODE_LIST_SUFFIX}.log" ]; then
        lastSuccIps=$(cat fix_${logType}_${SUCC_NODE_LIST_SUFFIX}.log)
    fi
    ParallelBatchScp2RemoteAndExcute "${logType}" "" "operateComponetInAgent.sh" "${params[*]}" "${allIps[*]}" "${lastSuccIps[*]}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End CheckAlComponentNodeLink component(${compName}) node ips(${allIps[*]}) params(${params[*]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    CheckResultFile "${compName}" "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log"
    if [ $? -ne 0 ]; then
        ScriptColorPrintLog "CheckAlComponentNodeLink node(${allIps[*]}) component(${compName}) part failed, you can see failed node in file(fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "End CheckAlComponentNodeLink node(${allIps[*]}) component(${compName}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function CheckNodeLink()
{   
    local oldScpTimeOut=${SCP_TIMEOUT}
    local oldExecuteTimeOut=${EXECUTE_TIMEOUT}
    SCP_TIMEOUT="300"
    EXECUTE_TIMEOUT="60"
    CheckAllComponentNodeLink
    local checkResult=$?
    SCP_TIMEOUT=${oldScpTimeOut}
    EXECUTE_TIMEOUT=${oldExecuteTimeOut}
    if [ ${checkResult} -ne 0 ]; then
        ScriptPrintLog "check node Link failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return ${checkResult}
    fi

    ScriptPrintLog "check node Link successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function ParallelClearNodeScript()
{
    local scpFileStr="$1"
    local IP=$2
    local log_file=$3
    local paramStr=$4
    local script=$5
    local succNodeListFile="$6"
    local failedNodeListFile="$7"
    local tmpFile=$8
    local tmpResultFile=$9

    local remoteUser=${COMPUTE_REMOTE_USER}
    local remotePasswd=${COMPUTE_REMOTE_PASSWD}
    local rootPasswd=${COMPUTE_ROOT_PASSWD}
    CheckIsStorageNode ${IP}
    if [ $? -eq 0 ]; then
        remoteUser=${REMOTE_USER}
        remotePasswd=${REMOTE_PASSWD}
        rootPasswd=${ROOT_PASSWD}
    fi

    if [ -f "${CUR_PATH}/${PASSWD_FILE}" ]; then
        local ipPasswdInfo=$(cat ${CUR_PATH}/${PASSWD_FILE}|grep -wF "${IP}")
        if [ -n "${ipPasswdInfo}" ]; then
            local colNum=$(echo "${ipPasswdInfo}" |awk '{print NF}')
            if [ "${colNum}" -eq 4 ]; then
                remoteUser=$(echo "${ipPasswdInfo}" |awk '{print $2}')
                remotePasswd=$(echo "${ipPasswdInfo}" |awk '{print $3}')
                rootPasswd=$(echo "${ipPasswdInfo}" |awk '{print $4}')
            fi
        fi
    fi

    local remotePath="/home/${remoteUser}"
    if [ "${remoteUser}" == "root" ]; then
        remotePath="/${remoteUser}"
    fi

    # remote excute
    SudoExecuteRemoteCmd "rm\ -f\ ${remotePath}/${script}" $IP ${remoteUser} ${remotePasswd} ${rootPasswd} ${tmpFile} ${tmpResultFile}
    cat ${tmpResultFile} | tee -a ${log_file}
    echo "" | tee -a ${log_file}
    echo "${IP}" | tee -a ${succNodeListFile}
    ScriptPrintLog "node(${IP}) ${type} successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    ReleaseFifo
}

function ParallelClearAllNodeScript()
{
    local type=$1
    local cfgFile=$2
    local script=$3
    local params=$4
    local IPs=$5
    local filterIps=$6
    local succNodeListFile="fix_${type}_${SUCC_NODE_LIST_SUFFIX}.log"
    local failedNodeListFile="fix_${type}_${FAIL_NODE_LIST_SUFFIX}.log"
    local log_file="fix_${type}.log"

    if [ -a "${log_file}" ];then
        rm -f ${log_file}
    fi

    if [ -a "${succNodeListFile}" ];then
        rm -f ${succNodeListFile}
    fi

    if [ -a "${failedNodeListFile}" ];then
        rm -f ${failedNodeListFile}
    fi

    local scpFileStr="${script}"
    if [ -n "${cfgFile}" ]; then
        scpFileStr="${scpFileStr} ${cfgFile}"
    fi

    local i=0
    InitFiFo
    for IP in ${IPs[@]}
    do
        if [[ -n "${filterIps[*]}" && ${filterIps[@]/${IP}/} != ${filterIps[@]} ]]; then
            echo "${IP}" | tee -a ${succNodeListFile}
            ScriptPrintLog "filter node(${IP}) ${type}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        echo "${IP}:" | tee -a ${log_file}
        if [ -a "${succNodeListFile}.${i}" ];then
            rm -f ${succNodeListFile}.${i}
        fi

        if [ -a "${failedNodeListFile}.${i}" ];then
            rm -f ${failedNodeListFile}.${i}
        fi
        AcquireFifo
        ParallelClearNodeScript "${scpFileStr}" ${IP} ${log_file} "" "${script}" "${succNodeListFile}.${i}" "${failedNodeListFile}.${i}" "${TMP_FILE}.${i}" "${TMP_RESULT_FILE}.${i}" &
        let i=${i}+1
    done
    wait
    FreeFifo

    for ((j=0; j<i; j++))
    do
       if [ -s "${succNodeListFile}.${j}" ]; then
            cat "${succNodeListFile}.${j}" >> ${succNodeListFile}
       fi
       if [ -s "${failedNodeListFile}.${j}" ]; then
            cat "${failedNodeListFile}.${j}" >> ${failedNodeListFile}
       fi
    done
    return 0
}

function ClearAllComponentNodeOperateScript()
{
    local allIps=()
    for compName in ${CHECK_LINK_COMPONENTS[@]}
    do
        local componentIps=($(eval cat \$${compName}_NODE_OUTFILE))
        if [ ${#componentIps[*]} -eq 0 ];then
            ScriptPrintLog "Component(${compName}) no node to check node link. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        allIps+=(${componentIps[*]})
    done
    allIps+=(${EXPAND_NODE_MANAGE_IP_LIST[*]})
    allIps=($(echo ${allIps[*]}|sed 's/ /\n/g'|sort -n|uniq))
    compName="ALL"
    ScriptPrintLog "Begin ClearAllComponentNodeScript component(${compName}) node ips(${allIps[*]}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    local logType="${FUNCNAME}_${compName}"
    local lastSuccIps=()
    if [ -s "fix_${logType}_${SUCC_NODE_LIST_SUFFIX}.log" ]; then
        lastSuccIps=$(cat fix_${logType}_${SUCC_NODE_LIST_SUFFIX}.log)
    fi
    ParallelClearAllNodeScript "${logType}" "" "operateComponetInAgent.sh" "" "${allIps[*]}" "${lastSuccIps[*]}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "End ClearAllComponentNodeScript component(${compName}) node ips(${allIps[*]}) params(${params[*]}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    CheckResultFile "${compName}" "fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log"
    if [ $? -ne 0 ]; then
        ScriptColorPrintLog "ClearAllComponentNodeScript node(${allIps[*]}) component(${compName}) part failed, you can see failed node in file(fix_${logType}_${FAIL_NODE_LIST_SUFFIX}.log). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    ScriptPrintLog "End ClearAllComponentNodeScript node(${allIps[*]}) component(${compName}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}


function ClearNodeOperateScript()
{
    local oldScpTimeOut=${SCP_TIMEOUT}
    local oldExecuteTimeOut=${EXECUTE_TIMEOUT}
    SCP_TIMEOUT="300"
    EXECUTE_TIMEOUT="60"
    ClearAllComponentNodeOperateScript
    local checkResult=$?
    SCP_TIMEOUT=${oldScpTimeOut}
    EXECUTE_TIMEOUT=${oldExecuteTimeOut}
    return 0

}

##################################################################################################################################

InitLog "${CUR_PATH}" "deploy.log"
function main()
{
    IsStandbyNode
    if [ $? -eq 1 ]; then
        ScriptPrintLog "Node role is standby, can not excute. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    #GetCurPath
    if [[ "$1" =~ ^ExpandEds ]];then
        CheckExpandNodeRole
        if [ $? -ne 0 ]; then
            ScriptPrintLog "Check expand node role failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        CheckZkIsExist
        if [ $? -ne 0 ]; then
            ScriptPrintLog "Check expand node zk is exist failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
    fi
    ScriptColorPrintLog "Begin to excute $@. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    $@
    local expandResult=$?
    ScriptColorPrintLog "End to excute $@ result(${expandResult}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    #ExpandEdsContorolCluster
}
if [ $# -ne "1" ]
then
    ScriptPrintLog "The argument is lacking, please refer to the help."
    usage
    exit 1
fi
Cautious
lockFile="/tmp/deploy_lock_file"
#如果已经有一个在监控，不要重复再起--
FlockCheck()
{
    {
        flock -no 100
        if [ $? -eq 1 ]; then
            ScriptPrintLog "Get flock file fail,meybey $0 is exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        main $@
        
        rm -f $lockFile
    } 100<>$lockFile
}

FlockCheck $@
