#!/bin/bash

# 命令失败时的重试次数和间隔 
REPEAT=3
REPEAT_TIME=1 

# 命令执行函数  参数为：命令 正确返回值
# 注意中间执行结果不能打印到屏显
function ipmitool_clearflag()
{
    for((i=0;i<$REPEAT;i++))
    do
        ipmitool raw 0x32 0xbc 0x00 0x02 0x00 0x00 0x60 0x55 > /dev/null 2>&1
        if [ $? -ne 0 ] ; then
            OS_echo "ipmitool clearflag failed, $i times"
            sleep $REPEAT_TIME
            continue
        fi
        ret=$(ipmitool raw 0x32 0xbb 0x00 0x02 0x00 0x00 0x75)
        if [ $ret == "55" ] ; then
            OS_echo "ipmitool readflag=$ret success, $i times"
            return 0
        fi
        OS_echo "ipmitool readflag=$ret failed, $i times"
        sleep $REPEAT_TIME
    done
    return 1
}

# 滚动升级、组件升级、离线升级到615及以上版本都需要清除限制1822v120和1880接口卡接入的标记
# flag标记下发0x55置标记,下发0清标记. BMC会判断,如果是0x00,则限制接入,0x55不做限制
# 设置标记: ipmitool raw 0x32 0xbc 0x00 0x02 0x00 0x00 0x60 $flag
# 查询标记: ipmitool raw 0x32 0xbb 0x00 0x02 0x00 0x00 0x75
ipmitool_clearflag
if [ $? -ne 0 ]; then
	echo "False"
	exit 0
fi

echo "True"
exit 0
