#!/bin/bash

# Error code defination
AD_JOINED="1"
STATUS_SUCCESS="0"
STATUS_FAILED="1"
ERROR_CODE_SUCCESS="True"
ERROR_CODE_FAILED="False"
DEFAULT_TENANT_ID="0"
function DEBUG()
{
	OS_echo "NAS_PROTOCOL_PRE_CHECK; $1" > /dev/null
}

function checkAdJoinStatus()
{
	xmlStr=$1
	joinStatus=`echo "${xmlStr}" | awk '/<\/*join_state\/*>/{gsub(/[[:space:]]*<\/*join_state\/*>/,"");print $0}'`
	if [ "${joinStatus}" != "${AD_JOINED}" ]; then
		return ${STATUS_FAILED}
	fi
	return ${STATUS_SUCCESS}
}


function checkStatus()
{
	xmlStr=$1
	status=`echo "${xmlStr}" | awk '/<\/*status\/*>/{gsub(/[[:space:]]*<\/*status\/*>/,"");print $0}'`
	if [ "${status}" != "${STATUS_SUCCESS}" ]; then
		return ${STATUS_FAILED}
	fi
	return ${STATUS_SUCCESS}
}

function isJoinedAdDomin()
{
	tenantId=$1
	joinStatusStr=`nas_proto_auth -c show-join -z ${tenantId}`
	if [ "${joinStatusStr}" = "" ];then
		echo "${ERROR_CODE_FAILED}"
		DEBUG "check tenant ${tenantId} join ad domain failed."
		exit ${STATUS_SUCCESS}
	fi
	checkStatus "${joinStatusStr}"
	ret=$?
	if [ "${ret}" != "${STATUS_SUCCESS}" ];then
		# If commander run failed, exit and ret error.
		echo "${ERROR_CODE_FAILED}"
		DEBUG "check tenant ${tenantId} join ad domain failed."
		exit ${STATUS_SUCCESS}
	fi
	checkAdJoinStatus "${joinStatusStr}"
	ret=$?
	if [ "${ret}" != "${STATUS_SUCCESS}" ];then
		return ${STATUS_FAILED}
	fi
	return ${STATUS_SUCCESS}
}

function isDnsConnect()
{
	tenantId=$1
	DEBUG "check dns connect for tenant ${tenantId}"
	dnsStatusStr=`nas_proto_auth -c test-dns-connectivity -z ${tenantId}`
	if [ "${dnsStatusStr}" = "" ]; then
		echo "${ERROR_CODE_FAILED}"
		DEBUG "check tenant ${tenantId} dns connect failed."
		exit ${STATUS_SUCCESS}
	fi
	checkStatus "${dnsStatusStr}"
	ret=$?
	if [ "${ret}" != "${STATUS_SUCCESS}" ];then
		echo "${ERROR_CODE_FAILED}"
		DEBUG "check tenant ${tenantId} dns connect failed."
		exit ${STATUS_SUCCESS}
	fi
	return ${STATUS_SUCCESS}
}

function isAdConnect()
{
	tenantId=$1
	DEBUG "check ad domin connect for tenant ${tenantId}"
	adStatusStr=`nas_proto_auth -c test-ad-connectivity -z ${tenantId}`
	if [ "${adStatusStr}" = "" ]; then
		echo "${ERROR_CODE_FAILED}"
		DEBUG "check tenant ${tenantId} ad connect failed."
		exit ${STATUS_SUCCESS}
	fi
	checkStatus "${adStatusStr}"
	ret=$?
	if [ "${ret}" != "${STATUS_SUCCESS}" ];then
		echo "${ERROR_CODE_FAILED}"
		DEBUG "check tenant ${tenantId} ad connect failed."
		exit ${STATUS_SUCCESS}
	fi
	return ${STATUS_SUCCESS}
}

function upgradePreCheck()
{
	# Get all tenant
	tenant_list=`nas_proto_cfg -c get_all_tenant_id`
	rst=$?
	if [ $rst != "${STATUS_SUCCESS}" ];then
		echo "${ERROR_CODE_FAILED}"
		DEBUG "get all tenant list failed."
		exit ${STATUS_SUCCESS}
	fi
	tenant_array=($tenant_list)
	# Check the status for loop
	for tenant_id in ${tenant_array[@]}
	do
		isJoinedAdDomin ${tenant_id}
		curRet=$?
		if [ "${curRet}" != "${STATUS_SUCCESS}" ]; then
			continue
		fi
		if [ "${tenant_id}" != "${DEFAULT_TENANT_ID}" ];then
			isDnsConnect ${tenant_id}
		fi
		isAdConnect ${tenant_id}
	done
}

upgradePreCheck
echo "${ERROR_CODE_SUCCESS}"
exit ${STATUS_SUCCESS}
