#!/bin/bash

needCheckHotpatch=0
hotpatchActived=0
diskNumExceed=0

##检查是否需要安装热补丁
checkNeedHotpatch()
{
	if $(id -u admin > /dev/null 2>&1)
	then
		adminName="admin"
	else
		adminName=$(cat /etc/passwd | grep '/ISM/cli/ismcli' | grep ':0:root:')
		adminName=${adminName%%:*}
	fi

	if [ -z $adminName ]
	then
		return
	fi
	
	##查询系统的软件版本号##
	touch checkDiskNumInDiskDomainFile
	echo -e "show system general\n" | /ISM/cli/ismcli -u $adminName  > "checkDiskNumInDiskDomainFile"

	##6.0.1版本有热补丁##
	str1=$(sed -n '10p' checkDiskNumInDiskDomainFile | grep -a -i "6.0.1")
	if [ "$str1" ]; then
		needCheckHotpatch=1
	fi
	
	rm -f checkDiskNumInDiskDomainFile
}

##检查热补丁是否已安装6.0.1.HP0181##
checkHotpatch()
{
	touch checkDiskNumInDiskDomainFile
	diagsh --attach=*_12 --cmd="dopra showpatchinfo 0181" > "checkDiskNumInDiskDomainFile"
	str=$(sed -n '6p' checkDiskNumInDiskDomainFile | grep -a -i "HP0181")
	str1=$(sed -n '8p' checkDiskNumInDiskDomainFile | grep -a "Active")
	
	if [ "$str" -a "$str1" ]; then
		hotpatchActived=1
	fi
	
	rm -f checkDiskNumInDiskDomainFile
}

checkDiskNumExcced()
{
	##获取所有dpid##
	AllDiskPoolId=`(diagsh --attach="app_data_12" --cmd="pmgr showdp") | grep 0x|awk '{print substr($0,0,12)}'`

	###获取每个dp的成员盘数目####
	for dpid in $AllDiskPoolId
	do
	{
		declare -i diskNumInDiskDomain=0
		#检查每个dp成员盘是否超过400盘
		diskNumInDiskDomain=`(diagsh --attach="app_data_12" --cmd="bm show bmobj -p $dpid") | grep diskNum |awk -F ":" '{print $2}'`
		if [ $diskNumInDiskDomain -ge 400 ]; then
			diskNumExceed=1
			break
		fi
	}
	done
}

checkDiskNumExcced
if [ $diskNumExceed -eq 1 ];then
    #盘数超过400盘
	checkNeedHotpatch
	if [ $needCheckHotpatch -eq 1 ]; then
		#有热补丁版本
		checkHotpatch
		if [ $hotpatchActived -eq 1 ]; then
		    #热补丁已安装，检查通过
			echo "TRUE"
		else
			#热补丁未安装，检查不通过
			echo "FALSE"
		fi
	else
		#无热补丁版本，检查不通过
		echo "FALSE"
	fi
else
    #盘数未超过400盘，检查通过
    echo "TRUE"
fi
