#!/bin/bash
#脚本兼容热补丁评估和升级工勘场景；SR20240703450384；热补丁评估中有NDMP检查项识别安装补丁中存在NDMP备份失败风险，但升级工勘中无该检查项
result="False"
ndmp_service=`ps -ef|grep ndmpd|grep -v 'grep'`
#判断manifest.yml是否存在，从不同路径取目标版本号。存在则已传包，为升级前检查项；不存在则是升级评估
if [ -f /startup_disk/image/pkg_upd/manifest.yml ]; then
    versionDst=$(head /startup_disk/image/pkg_upd/manifest.yml | grep SpcVersion)
    versionDst=${versionDst##* }
else
    versionDst=$(cat /tmp/check_extend_param)
    versionDst=$(echo "$versionDst" | grep -o '"targetVersion":"[^"]*' | sed 's/"targetVersion":"//')
fi
#获取当前存储的产品型号，OceanStor 5220、OceanStor 5210这两个产品V6版本不支持NDMP，V7支持
productName=$(cat /OSM/conf/product.ini | grep "ProductName")
productName=$(echo "$productName" | grep -oP 'ProductName=\K.*')
#如果是敏感产品号，判断目标版本是否是V6，是则检测NDMP进程；否则通过检测
if echo "$productName" | grep -q -E "OceanStor 5220|OceanStor 5210"; then
    if echo $versionDst | grep -q "6.1."; then
		if [ ! -z "$ndmp_service" ];then #若目标版本不支持NDMP服务，当前版本需要关闭NDMP服务才能通过
			result="False"
		else
			result="True"
		fi
	else
		result="True"
	fi
else #不是三个敏感产品，检测是否为6.1.2以前的版本，是则进行NDMP进程判断；否则通过检测
	if echo $versionDst | grep -q -E "6.0.0|6.0.1|6.1.0"; then
	    if [ ! -z "$ndmp_service" ];then
		    result="False"
	    else
		    result="True"  
	    fi
	else
	    result="True"
	fi
fi
if [ ! -f /tmp/check_extend_param ]; then
  result='False'
fi
if [ ! -f /OSM/conf/product.ini ]; then
  result='False'
fi
echo $result
