#!/bin/bash
if [ -f /usr/bin/root_proxy ]; then
    ROOT_PROXY="/usr/bin/root_proxy --proxy-ignore-insecure 1 --proxy-shname $0 --proxy-lineno $LINENO"
fi
result="FALSE"
#获取双活域集群规格
diagsh --attach=*_12 --cmd="rephc showspec" > "rephcfile"
maxDomainNum=`${ROOT_PROXY} cat rephcfile |grep maxDomainNum|awk -F ':' '{print $2}'`

if [ ! $maxDomainNum ]; then
    result="TRUE"
else
    for i in `seq 0 $[$maxDomainNum-1]`
    do   
        diagsh --attach=*_12 --cmd="msc show_mgr_info_by_localid $i" > "msctmpfile"

        state=`${ROOT_PROXY} cat msctmpfile |grep runingState|awk -F ':' '{print $2}'`
        dataConsist=`${ROOT_PROXY} cat msctmpfile |grep isRemoteDataConsist|awk -F ':' '{print $2}'`
        clusterId=`${ROOT_PROXY} cat msctmpfile |grep clusterId|awk -F 'x' '{print $2}'`
        workMode=`${ROOT_PROXY} cat msctmpfile |grep workMode|awk -F ':' '{print $2}'`

        if [ -z "$state" ]; then
            #not rep master
            result="TRUE"
        elif [ $state -eq 1 ];  then
            #connecting 1
            result="FALSE"
            break
        # echo "workMode:$workMode"
        elif [ $workMode = "InterMigrate" ];then
            # echo "InterMigrate"
            continue
        elif [ $workMode = "Migrate" ];then
            # echo "Migrate"
            continue            
        elif [ $state -eq 0 ] && [ $dataConsist -eq 0 ]; then
            #State normal 0, remote data inconsistent 0
            result="FALSE"
            break
        else
            diagsh --attach=*_12 --cmd="msc show_dsm_data_state $clusterId" > "msctmpfile1"
            dsmState=`${ROOT_PROXY} cat msctmpfile1 |grep "Msc dsm data state"|awk -F ':' '{print $2}'`
            if [ -z "$dsmState" ]; then
                result="TRUE"
            elif [ $dsmState -eq 0 ]; then
                #Dsm data state is inconsistent 0
                result="FALSE"
                break
            else
                result="TRUE"
            fi
        fi
    done  
    # 检查双活pair是否在创建或删除中
    diagsh --attach=*_12 --cmd="rephc queryPairCreatingAndDeletingStatusCnt" > "rephcfile"
    pairCount=`${ROOT_PROXY} cat rephcfile |grep pairCount|awk -F '=' '{print $2}'`
    if [ -n "$pairCount" ] && [ $pairCount -ne 0 ]; then
        result="FALSE"
    fi
fi
echo $result
${ROOT_PROXY} rm -f msctmpfile
${ROOT_PROXY} rm -f msctmpfile1
${ROOT_PROXY} rm -f rephcfile