#!/bin/bash
# 该脚本中任何操作系统的操作命令，都不可以将命令执行结果输出，需使用“>/dev/null 2>&1”重定向
# 否则升级框架检查项会失败
G_SCRIPT_NAME=$(basename "$0")

declare -A G_DEFAULT_GROUP_ID_MAP=(
    ["UTOPUSERS"]="1105"
    ["OceanStorCommonGroup"]="62900"
    ["OceanStorApp_dataGroup"]="64000"
    ["OceanStorDevmGroup"]="64700"
    ["OceanStorSysGroup"]="63800"
    ["OceanStorOAMGroup"]="64200"
    ["OceanStorInfraGroup"]="64600"
    ["OceanStorPangeaGroup"]="62700"
    ["OceanStorHswGroup"]="62600"
    ["OceanStorFdsaGroup"]="64800"
    ["OceanStorDhaGroup"]="64100"
    ["OceanStorPcieGroup"]="62200"
    ["OceanStorNdmpGroup"]="62100"
    ["OceanStorProtocolGroup"]="63000"
)

function CheckUserGroupChange() {
    group_check_ret=0
    for key in "${!G_DEFAULT_GROUP_ID_MAP[@]}"; do
        # 匹配group:,例如 OceanStorCommonGroup:
        tempGid=$(awk -F':' '/^'"${key}:"'/{print $3}' /etc/group)
        if [ -z "${tempGid}" ]; then
            # 如果获取不到组ID，则等待1s后重试
            sleep 1
            tempGid=$(awk -F':' '/^'"${key}:"'/{print $3}' /etc/group)
            # 重试后获取不到，则当前组检查通过
            if [ -z "${tempGid}" ]; then
                OS_echo "[$G_SCRIPT_NAME] Group(${key}) is not find."
                continue
            fi
        fi

        if [ "x${tempGid}" != "x${G_DEFAULT_GROUP_ID_MAP[${key}]}" ]; then
            OS_echo "[$G_SCRIPT_NAME] Group(${key}) gid(${tempGid}) is not match the default(${G_DEFAULT_GROUP_ID_MAP[${key}]})."
            group_check_ret=1
        fi
    done

    # 检查不通过
    if [ ${group_check_ret} -eq 1 ]; then
        return 1
    fi

    return 0

}

# 该脚本中任何操作系统的操作命令，都不可以将命令执行结果输出，需使用“>/dev/null 2>&1”重定向,否则升级框架检查项会失败
if CheckUserGroupChange >/dev/null 2>&1; then
    echo "True"
else
    echo "False"
fi

exit 0
