#!/bin/bash
#升级前检查1823mpu日志是否有线程异常，如果无异常则可进行升级;若有异常,上报异常卡号

card_list_1823=()
keywords="0x12460901"

#1823标卡判断

#判断是否有hinicadm3工具
hinicadm3 info > /dev/null 2>&1
if [ $? -eq 0 ]; then
	#获取有多少张1823网卡，28张卡实测正常情况下耗时31s
	card_nums=$(hinicadm3 info | grep "Card num" | awk -F ':' '{print $2}')
	if [[ -z ${card_nums} ]];then
		card_nums=0
	fi

	#每张网卡分别获取mpu ram和mpu flash日志进行关键词检索
	for ((i=0;i<${card_nums};i++))
	do
		mpu_ram_log_path=$(hinicadm3 log -i hinic${i} -t 0 | awk -F ' ' '{print $1}')
		if [[ -f ${mpu_ram_log_path} ]];then
			separate1=$(cat ${mpu_ram_log_path} | grep $keywords)
		fi
	 
		mpu_flash_log_path=$(hinicadm3 log -i hinic${i} -t 1 | awk -F ' ' '{print $1}')
		if [[ -f ${mpu_ram_log_path} ]];then
			separate2=$(cat ${mpu_flash_log_path} | grep $keywords)
		fi
	 
		if [[ -n ${separate1} ]] || [[ -n ${separate2} ]];then
			card_list_1823+=(hinic${i})
		fi

		rm -f ${mpu_flash_log_path}
		rm -f ${mpu_ram_log_path}
	done
fi

#FC卡判断

#先判断是否存在FC卡，如果不存在直接退出，实测4张FC卡耗时20s
diagsh --attach="devm_12" --cmd="drvunf showversion" | grep '00 ||HW version :ioc_v3r1' > /dev/null
if [ $? -eq 0 ]; then
	#先删除历史日志，防止判断受影响
	rm -rf /OSM/log/cur_debug/pangea/fwlog/*.log 
	rm -rf /OSM/log/cur_debug/pangea/fwlog/*.txt

	diagsh --attach="devm_12" --cmd="drvunf showversion" | grep '00 ||HW version :ioc_v3r1' | while read line;
	do 
		port_num=$(echo $line | awk -F 'port ' '{print $2}' | awk -F ' ||HW' '{print $1}')
		if [ "${port_num}" == "" ];then
			continue
		fi

		diagsh --attach=devm_12 --cmd="drvunf getfwlog $port_num" > /dev/null
	done

	#判断ram日志
	ram_log_search=/OSM/log/cur_debug/pangea/fwlog/up_ram_hifc*
	ram_log_path=/OSM/log/cur_debug/pangea/fwlog/up_ram_log.log
	ls $ram_log_search > $ram_log_path

	array_str=""
	while read line
	do
		array_str="$array_str $line"
	done < $ram_log_path
	array=($array_str)

	for (( i = 0; i < ${#array[@]}; i++ )); do
		separate1=$(cat ${array[i]} | grep $keywords)
		if [[ -n ${separate1} ]];then
			num=$(echo ${array[i]} | awk -F 'hifc' '{print $2}' | awk -F '_' '{print $1}')
			card_list_1823+=(hifc${num})
		fi
	done

	#判断flash日志
	flash_log_search=/OSM/log/cur_debug/pangea/fwlog/up_flash_hifc*
	flash_log_path=/OSM/log/cur_debug/pangea/fwlog/up_flash_log.log
	ls $flash_log_search > $flash_log_path

	array_str=""
	while read line
	do
		array_str="$array_str $line"
	done < $flash_log_path
	array=($array_str)

	for (( i = 0; i < ${#array[@]}; i++ )); do
		separate2=$(cat ${array[i]} | grep $keywords)
		if [[ -n ${separate2} ]];then
			num=$(echo ${array[i]} | awk -F 'hifc' '{print $2}' | awk -F '_' '{print $1}')
			card_list_1823+=(hifc${num})
		fi
	done

	#最后再删除生成的日志
	rm -rf /OSM/log/cur_debug/pangea/fwlog/*.log
	rm -rf /OSM/log/cur_debug/pangea/fwlog/*.txt
fi

if [[ ${#card_list_1823[@]} -ne 0 ]];then
	echo "False"
    OS_echo "${card_list_1823[*]} is abnormal"
else
	echo "True"
fi
