#!/bin/bash
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# 2023/12/25 16:56
# 616-616 OceanProtect 1.3.0 控制器重删内存越界的检查

result="True"

function is_need_check_version()
{
    local current_version=$(head /OSM/conf/manifest.yml | grep -w Version | awk '{print $2}')
    local spc_version=$(head /OSM/conf/manifest.yml | grep -w SpcVersion | awk '{print $2}')
    local base_version="7600513292"
    local base_spc_version="1.3.0"
    local low_patch_ver="3"
    if [ "$spc_version" != "$base_spc_version" ]; then
        OS_echo "$current_version $spc_version not need check controller memory overwrite."
        return 0
    fi
    if [ "$current_version" != "$base_version" ]; then
        OS_echo "$current_version not need check controller memory overwrite."
        return 0
    fi
    # 补丁版本
    local currentHotVer="0"
    if [ -f /startup_disk/image/$current_version/hotpatch/patch_cur/patch.yml ]; then
        currentHotVer=$(cat /startup_disk/image/$current_version/hotpatch/patch_cur/patch.yml | grep -w "patch_version" | awk '{print $2}' | tr -cd "[0-9]")
    fi
    if [ "$current_version" == "$base_version" ] && [ $currentHotVer -ge $low_patch_ver ]; then
        OS_echo "$current_version $currentHotVer not need check controller memory overwrite."
        return 0
    fi
    return 1
}

function check_is_controller_dedup_flag()
{
    local disk_domains=$(diagsh --attach="app_data_12" --cmd="pmgr showdp" | grep -w "online")
    if [ "$disk_domains" == "" ]; then
        OS_echo "no has disk_domain_id, no need upgrade sph3."
        return 0
    fi
    echo "${disk_domains}" | while read disk_domain; do
        disk_domain_id=$(echo $disk_domain | grep -w "online" | awk '{print $2}')
        isControllerDedup=$(diagsh --attach="app_data_12" --cmd="pmgr showdp -d ${disk_domain_id}" | grep -w "ctrlDedupStrategy" | awk '{print $3}')
        if [ "$isControllerDedup" == "1" ]; then
            OS_echo "disk_domain_id($disk_domain_id) controller dedup switch is $isControllerDedup, need upgrade sph3."
            return 1
        else
            OS_echo "disk_domain_id($disk_domain_id) controller dedup switch is $isControllerDedup, not need upgrade sph3."
        fi
    done
    # 这里判断的原因是因为 echo "${disk_domains}" | while read 是类似lambda表达式的东西，不会直接return到函数外层
    if [ "$?" == "1" ]; then
        OS_echo "has disk_domain_id's controller_dedup_flag is true, need upgrade sph3."
        return 1
    fi
    return 0
}

function check_is_need_upgrade_616sph3()
{
    is_need_check_version
    if [ "$?" == "0" ];then
        OS_echo "current vesion not need upgrade sph3."
        return 0
    fi

    check_is_controller_dedup_flag
    if [ "$?" == "1" ]; then
        OS_echo "controller_dedup_flag is true, need upgrade sph3."
        return 1
    fi

    local cross_dedup_count=$(diagsh --attach="app_data_12" --cmd="ddpx show io" | grep -w "WRITE_CROSS_QUERY" | awk '{print $2}')
    if [[ "$cross_dedup_count" == "0" || "$cross_dedup_count" == "" ]]; then
        OS_echo "controller dedup cross_dedup_count is $cross_dedup_count, not need upgrade sph3."
        return 0
    fi
    OS_echo "controller dedup cross_dedup_count is $cross_dedup_count, need upgrade sph3."
    return 1
}

check_is_need_upgrade_616sph3
if [ "$?" == "1" ];then
    OS_echo "memory overwriting may occur, need upgrade sph3."
    result="False"
fi
echo $result
exit 0
