#!/usr/bin/python
# -*- coding:utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import argparse
import sys
import subprocess
import shlex
import logging

# 定义返回值
RETURN_OK = 0
RETURN_ERROR = 1
TIMEOUT = 5 * 60

OSM_CONF_YAML = '/startup_disk/image/pkg_upd/manifest.yml'
OSM_PATCH_CONF_YAML = '/startup_disk/image/pkg_cur/manifest.yml'
# 初始化系统日志
logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')


def diagnose(command):
    cmd = 'diagsh --attach=*_12 --cmd="%s"' % command
    process = subprocess.Popen(shlex.split(cmd), stdout=subprocess.PIPE)
    out = process.communicate()
    return out[0].decode("utf-8")


def check_nic_mpdk_partition():
    cmd = "mpdk showpartinfo -s 0"
    cmd_result = diagnose(cmd)
    if not cmd_result:
        return RETURN_OK
    infos = cmd_result.splitlines(False)
    for line in infos:
        if not (("ISCSI" in line) and ("NIC" in line) and ("NIC_USR" not in line)):
            continue
        cpu_map = line.split()
        if (cpu_map[5] == "0x0") and (cpu_map[6] == "0x0") and (cpu_map[7] == "0x0"):
            return RETURN_ERROR
    return RETURN_OK


def main(mode):
    ret = RETURN_OK
    try:
        if mode == "postcheck":
            logging.info("[check_nic_mpdk_partition] post check")
            ret = check_nic_mpdk_partition()  # 升级后检查
        else:
            logging.info("[check_nic_mpdk_partition] input mode err (%s)", mode)
            ret = RETURN_ERROR

    except Exception as err:
        logging.info("[check_nic_mpdk_partition] err %s", err)

    if ret == RETURN_OK:
        print("True")
    else:
        print("False")

    return RETURN_OK


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='manual to this script')
    parser.add_argument('mode', type=str)
    check_mode = parser.parse_args().mode
    sys.exit(main(check_mode))
