#!/bin/bash

pmsLogFile=/OSM/coffer_log/log/pms/logs/systemReporter-info.log

function checkCollect() {
    local servicePid
    servicePid=$(ps -efww | grep -w "Dprocess.name=pmsd" | grep -v grep | awk '{print $2}')
    if [ -z "${servicePid}" ];then
       return 0
    fi
    if [ ! -f ${pmsLogFile} ]; then
        return 0
    fi
    local failedNum
    failedNum=$(grep -n 'Module collect loaded failed' ${pmsLogFile} | tail -n 1 | cut -d ":" -f 1)
    if [ -z "${failedNum}" ]; then
        return 0
    fi
    local succeedNum
    succeedNum=$(grep -n 'new module loaded: collect ' ${pmsLogFile} | tail -n 1 | cut -d ":" -f 1)
    if [ -z "${succeedNum}" ]; then
        return 1
    fi
    if [ "${failedNum}" -gt "${succeedNum}" ]; then
        return 1
    fi

    return 0
}

function main() {
    local result="False"
    if checkCollect; then
        result="True"
    fi
    echo $result
}

main

