#!/bin/bash

localPath="/OSM/log/cur_debug/pangea/BMC/tmp/BMCLOG/local/"
cpldreg="/OSM/log/cur_debug/pangea/BMC/tmp/BMCLOG/local/cpldreg"
secureLogTar="/OSM/log/cur_debug/pangea/BMC/tmp/BMCLOG/local/secure_curlog.tar.gz"

# 判断文件是否为链接文件 #
function PANGEA_CheckLinkFile()
{
    INPUT_FILE=$1
    if [ -L "${INPUT_FILE}" ]; then
        OS_echo "${INPUT_FILE} is a link file."
        echo "False"
        exit 0
    fi
}

PANGEA_CheckLinkFile "${localPath}"
PANGEA_CheckLinkFile "${cpldreg}"
PANGEA_CheckLinkFile "${secureLogTar}"

# 如果文件夹不存在，则检查不通过
if [ ! -d "${localPath}" ];
then
   OS_echo "${localPath} is not exist."
   echo "False"
   exit 0
fi

# cpldreg以及secure_curlog.tar.gz文件均不存在，则检查不通过
if [ ! -f "${cpldreg}" ] && [ ! -f "${secureLogTar}" ];
then
   echo "False"
   OS_echo "${cpldreg} and ${secureLogTar} are not exist."
   exit 0
fi

# 判断cpldreg以及secure_curlog.tar.gz文件最近一次的更新时间，如果两者其中之一文件的最近更新时间与当前系统时间相差1小时以上，则检查不通过
function PANGEA_CompileTimestamp()
{
    INPUT_FILE=$1
    if [ -f "$INPUT_FILE" ];then
        LAST_MODIFY_TIMESTAMP=`stat -c %Y $INPUT_FILE`
        current=`date "+%Y-%m-%d %H:%M:%S"`
        SYSTEM_CURRENT_TIMESTAMP=`date -d "$current" +%s`
        time=`expr $SYSTEM_CURRENT_TIMESTAMP - $LAST_MODIFY_TIMESTAMP`
        if [ $time -gt 3600 ];then
            echo "False"
            exit 0
        fi
    fi
}

PANGEA_CompileTimestamp "${cpldreg}"
PANGEA_CompileTimestamp "${secureLogTar}"

echo "True"
exit 0
