#!/bin/bash
G_RET_SUCC=0
G_RET_FAIL=1

function PANGEA_CHECK_CONTROLLER_SN(){
    local L_RET=0
    local L_TempFile="bmcflashchecksn"
    local SN=""
    local CMD="mpa bmc getelable 200 0"
    local CMD_ATT="attach 21"
(
diagnose_usr --auto <<EOF
${CMD_ATT}
${CMD}
exit
EOF
) > ${L_TempFile}
    SN=`grep BarCode "${L_TempFile}" | head -1 | awk -F "=" '{print $2}'`
    rm ${L_TempFile}

    cur_folder=$(readlink -f "$(dirname "$0")")
    list=`cat ${cur_folder}/checkbmcflashrisk_sn_high.txt`
    for val in $list
    do
        if [[ ${list[@]} =~ $SN ]]; then
            OS_echo "[HIGH]bmc flash SN check return ${G_RET_FAIL}."
            return ${G_RET_FAIL}
        fi
    done
    OS_echo "[HIGH]bmc flash SN check return ${G_RET_SUCC}."
    return ${G_RET_SUCC}
}

function PANGEA_CHECK_PATCH_601()
{
    local CMD="ver show 3"
    local L_TempFile="bmcflashcheckpatch601"
    local VER=""
(
swm_diagnose <<EOF
${CMD}
exit
EOF
) > ${L_TempFile}
    VER=`grep Controller "${L_TempFile}" | head -1 | awk '{NF-=2; print $NF}'`
    rm ${L_TempFile}

    local finalVer=`echo $VER | awk -F "H" '{print $2}'`
    if [[ 10#$finalVer -lt 15 ]] || [[ "$VER" == "--" ]]; then
        OS_echo "[HIGH]bmc flash version 601 check return ${G_RET_FAIL}."
        return ${G_RET_FAIL}
    fi
    OS_echo "[HIGH]bmc flash version 601 check return ${G_RET_SUCC}."
    return ${G_RET_SUCC}
}

function PANGEA_CHECK_PATCH_610()
{
    local CMD="ver show 3"
    local L_TempFile="bmcflashcheckpatch610"
    local VER=""
(
swm_diagnose <<EOF
${CMD}
exit
EOF
) > ${L_TempFile}
    VER=`grep Controller "${L_TempFile}" | head -1 | awk '{NF-=2; print $NF}'`
    rm ${L_TempFile}

    local finalVer=`echo $VER | awk -F "H" '{print $2}'`
    if [[ 10#$finalVer -lt 7 ]] || [[ "$VER" == "--" ]]; then
        OS_echo "[HIGH]bmc flash version 610 check return ${G_RET_FAIL}."
        return ${G_RET_FAIL}
    fi
    OS_echo "[HIGH]bmc flash version 610 check return ${G_RET_SUCC}."
    return ${G_RET_SUCC}
}

function PANGEA_CHECK_PATCH_C60()
{
    local CMD="ver show 3"
    local L_TempFile="bmcflashcheckpatchC60"
    local VER=""
(
swm_diagnose <<EOF
${CMD}
exit
EOF
) > ${L_TempFile}
    VER=`grep Controller "${L_TempFile}" | head -1 | awk '{NF-=2; print $NF}'`
    rm ${L_TempFile}

    local finalVer=`echo $VER | awk -F "H" '{print $2}'`
    if [[ 10#$finalVer -lt 312 ]] || [[ "$VER" == "--" ]]; then
        OS_echo "[HIGH]bmc flash version C60 check return ${G_RET_FAIL}."
        return ${G_RET_FAIL}
    fi
    OS_echo "[HIGH]bmc flash version C60 check return ${G_RET_SUCC}."
    return ${G_RET_SUCC}
}

function PANGEA_CHECK_PATCH_C71()
{
    local CMD="ver show 3"
    local L_TempFile="bmcflashcheckpatchC71"
    local VER=""
(
swm_diagnose <<EOF
${CMD}
exit
EOF
) > ${L_TempFile}
    VER=`grep Controller "${L_TempFile}" | head -1 | awk '{NF-=2; print $NF}'`
    rm ${L_TempFile}

    local finalVer=`echo $VER | awk -F "H" '{print $2}'`
    if [[ 10#$finalVer -lt 102 ]] || [[ "$VER" == "--" ]]; then
        OS_echo "[HIGH]bmc flash version C71 check return ${G_RET_FAIL}."
        return ${G_RET_FAIL}
    fi
    OS_echo "[HIGH]bmc flash version C71 check return ${G_RET_SUCC}."
    return ${G_RET_SUCC}
}

#获取阵列版本
function PANGEA_CHECK_PRODUCT_VER()
{
    local CMD="ver show 1"
    local L_RET=0
    local L_TempFile="bmcflashcheckver"
    local VER=""
(
swm_diagnose <<EOF
${CMD}
exit
EOF
) > ${L_TempFile}
    VER=`grep Controller "${L_TempFile}" | head -1 | awk '{NF-=2; print $NF}'`
    rm ${L_TempFile}

    if [[ "$VER" == "6.0.1" ]] ;then
        PANGEA_CHECK_PATCH_601
        L_RET=$?
        if [ "${L_RET}" == "${G_RET_SUCC}" ] ;then
            return ${G_RET_SUCC}
        else
            return ${G_RET_FAIL}
        fi
    fi

    if [[ "$VER" == "6.1.0" ]] ;then
        PANGEA_CHECK_PATCH_610
        L_RET=$?
        if [ "${L_RET}" == "${G_RET_SUCC}" ] ;then
            return ${G_RET_SUCC}
        else
            return ${G_RET_FAIL}
        fi
    fi

    if [[ "$VER" == "V500R007C60SPC300" ]] ;then
        PANGEA_CHECK_PATCH_C60
        L_RET=$?
        if [ "${L_RET}" == "${G_RET_SUCC}" ] ;then
            return ${G_RET_SUCC}
        else
            return ${G_RET_FAIL}
        fi
    fi

    if [[ "$VER" == "V500R007C71SPC100" ]] ;then
        PANGEA_CHECK_PATCH_C71
        L_RET=$?
        if [ "${L_RET}" == "${G_RET_SUCC}" ] ;then
            return ${G_RET_SUCC}
        else
            return ${G_RET_FAIL}
        fi
    fi
    OS_echo "[HIGH]bmc flash version check no match, return ${G_RET_FAIL}."
    return ${G_RET_FAIL}
}

function PANGEA_CHECK_GET_BMC_LOG(){
    local L_TempFile="bmcflashgetlog"
    local CMD="mpa bmc getlog 200 0"
    local CMD_ATT="attach 21"
(
diagnose_usr --auto <<EOF
${CMD_ATT}
${CMD}
exit
EOF
) > ${L_TempFile}

    rm ${L_TempFile}
    #保证日志收集处理完成
    sleep 10s
}

function PANGEA_CHECK_KILL_BMC_BOARD_AND_GET_LOG()
{
    local localPath="/OSM/log/cur_debug/pangea/BMC/tmp/BMCLOG/local/app_curlog.tar.gz"
    local tmpPath="/OSM/log/pangea/app_curlog.tar.gz"
    local CUR_MODIFY_TIMESTAMP=
    local LAST_MODIFY_TIMESTAMP=
    local permitDir="/OSM/log/pangea/bmctmp"
    local tatgetFile="/OSM/log/pangea/bmctmp/var/log/pme/app_debug_log"

    #重启board模块
    echo -e "killall board\n" | ip vrf exec vrf-inner ssh -q -o ServerAliveInterval=60 -o StrictHostKeyChecking=no root@192.168.0.2 > /dev/null 2>&1
    OS_echo "[HIGH]bmc flash kill bmc board exec."

    #等待1分钟开始收集日志，避免日志未更新；不采用例测的方式，是避免日志突然变化导致误以为收集完成，可能这次变化收集的日志，并不包含期望的内容
    rm -rf $tmpPath > /dev/null 2>&1
    cp $localPath $tmpPath > /dev/null 2>&1
    LAST_MODIFY_TIMESTAMP=`stat -c %Y $tmpPath`
    if [[ $LAST_MODIFY_TIMESTAMP == "" ]]; then
        # 日志解压异常，或者日志不存在，则不比较，直接报失败
        return ${G_RET_FAIL}
    fi
    sleep 1m
    PANGEA_CHECK_GET_BMC_LOG
    rm -rf $tmpPath > /dev/null 2>&1
    cp $localPath $tmpPath > /dev/null 2>&1
    CUR_MODIFY_TIMESTAMP=`stat -c %Y $tmpPath`
    rm -rf $tmpPath > /dev/null 2>&1
    if [[ $CUR_MODIFY_TIMESTAMP == "" ]]; then
        # 日志解压异常，或者日志不存在，则不比较，直接报失败
        return ${G_RET_FAIL}
    fi
    if [[ $LAST_MODIFY_TIMESTAMP == $CUR_MODIFY_TIMESTAMP ]]; then
        #日志未刷新，这里可能killboard动作未能执行OK，返回失败
        return ${G_RET_FAIL}
    fi
    OS_echo "[HIGH]bmc flash product log check changed."
    #解压日志并解析日志关键词
    rm -rf $permitDir > /dev/null 2>&1
    mkdir $permitDir > /dev/null 2>&1
    tar xzvf $localPath -C $permitDir > /dev/null 2>&1
    target=`cat $tatgetFile | grep -a "bad-block" | tail -1`
    pattern='Nandflash healthreport infomation: avg-earsed-count=([0-9]+), resvd-block=([0-9]+), bad-block=([0-9]+).'
    rm -rf $permitDir
    if [[ $target =~ $pattern ]]; then
        resblock=${BASH_REMATCH[2]}
        badblock=${BASH_REMATCH[3]}
        totalblock=$((10#$resblock+10#$badblock))
        allowbad=$((10#$totalblock*7))
        badtotal=$((10#$badblock*10))
        OS_echo "[HIGH]bmc flash product log check badblock:$badtotal and allowed:$allowbad."
        #允许的坏块为总坏块的0.7，这里总数扩大7倍，坏块扩大10倍进行比较
        if [[ $allowbad -ge $badtotal ]]; then
            OS_echo "[HIGH]bmc flash product log check match OK, return ${G_RET_SUCC}."
            return ${G_RET_SUCC}
        else
            OS_echo "[HIGH]bmc flash product log check match fail, return ${G_RET_FAIL}."
            return ${G_RET_FAIL}
        fi
    fi
    OS_echo "[HIGH]bmc flash product log check no match, return ${G_RET_FAIL}."
    return ${G_RET_FAIL}
}

PANGEA_CHECK_CONTROLLER_SN
ret=$?
if [ "${ret}" == "${G_RET_SUCC}" ] ;then
    echo "True"
    exit 0
fi

PANGEA_CHECK_PRODUCT_VER
ret=$?
if [ "${ret}" == "${G_RET_SUCC}" ] ;then
    echo "True"
else
    #检查不通过，重启BMC的board模块并解析日志
    PANGEA_CHECK_KILL_BMC_BOARD_AND_GET_LOG
    ret=$?
    if [ "${ret}" == "${G_RET_SUCC}" ] ;then
        echo "True"
        exit 0
    fi
    echo "False"
fi
exit 0
