#!/bin/bash

PYTHON_3_7_PATH="/usr/local/lib64/python3.7"
PYTHON_3_9_PATH="/usr/local/lib64/python3.9"

if [ ! -d "${PYTHON_3_7_PATH}" ]
then
    OS_echo "${PYTHON_3_7_PATH} is not exist, no need clean"
    echo "True"
    exit 0
fi

if [ -d "${PYTHON_3_9_PATH}" ]
then
    rm -rf "${PYTHON_3_7_PATH}"
    if [ -d "${PYTHON_3_7_PATH}" ]
    then
        OS_echo "remove ${PYTHON_3_7_PATH} failed"
    else
        OS_echo "remove ${PYTHON_3_7_PATH} success"
    fi
    echo "True"
    exit 0
fi

file_list=$(ls "${PYTHON_3_7_PATH}/site-packages")
for file in ${file_list[@]}
do
    result=$(echo "${file}" | grep -E "jieba|numpy|pandas|scikit|scipy")
    if [ -z "${result}" ]
    then
        continue
    fi
    rm -rf "${PYTHON_3_7_PATH}/site-packages/${file}"
    if [ -d "${PYTHON_3_7_PATH}/site-packages/${file}" ]
    then
        OS_echo "remove ${PYTHON_3_7_PATH}/site-packages/${file} failed"
    else
        OS_echo "remove ${PYTHON_3_7_PATH}/site-packages/${file} success"
    fi
done
echo "True"
exit 0