#!/bin/bash
DDP_META_CHANGE_FOR_BIG_CAP_FIRST_VERSION=7600710136 #支持升降级需求的第一个B版本包B136
G_PKG_YML_FILE=/startup_disk/image/pkg_upd/manifest.yml
L_PKG_VERSION_STR=$(cat ${G_PKG_YML_FILE} |grep -m 1 Version |awk -F":" '{print $2}')
declare -i L_PKG_VERSION=0
L_PKG_VERSION=$(echo "${L_PKG_VERSION_STR}" | sed 's/[.T]//g' | sed 's/[[:space:]]//g')

isNeedClear=0
checkHotpatch()
{
    #目标版本若大于等于支持透写的首个版本，不做拦截
    if [ ${L_PKG_VERSION} -ge ${DDP_META_CHANGE_FOR_BIG_CAP_FIRST_VERSION} ];then
        return
    fi
    touch poolCheckMetaChange
    diagsh --attach=*_12 --cmd="postdr show downgradeNeedClearDb" > "poolCheckMetaChange"
    str=$(sed -n '/Need clear status/'p poolCheckMetaChange | grep -a -i "True")

    if [ "$str" ]; then
        isNeedClear=1
    fi
    rm -f poolCheckMetaChange
}

checkHotpatch
if [ $isNeedClear -eq 0 ]; then
    # check pass
    echo "True"
else
    # check fail
    echo "False"
fi
exit 0