#!/usr/bin/python
# -*- coding: utf-8 -*-
import os
import random
import sys
import logging

# 直接执行CLI命令的字符串格式：
# {0}表示需要执行的CLI命令，
# {1}表示命令执行回显重定向文件，用于命令执行后的结果解析
CLI_CHECK_CMD = "echo -e '{0}' | /ISM/cli/ismcli -u admin  > '{1}'"

# 直接执行diagnose命令的字符串格式：
# {0}表示attach的进程id,比如app_data为12，
# {1}表示需要执行的diagnose命令，
# {2}表示命令执行回显重定向文件，用于命令执行后的结果解析
DIAGNOSE_CHECK_CMD = "diagsh --attach=*_{0} --cmd='{1}' > '{2}'"


def downgrade_check(src_ver, target_ver):
    """
    通过调用diagnose或者CLI命令方式，实现降级检查逻辑，如果需要通过执行shell命令
    检查，建议直接按本脚本逻辑通过shell脚本实现。
    此脚本根据实际检查情况，打印检查结果、错误码和错误信息，
    升级模块解析打印回显，将检查结果、错误码和错误信息上报到升级工具
    检查结果说明：
    True或False
    错误码规则说明：
    十六进制，前四位为模块id，后四位为模块错误码，模块ID参考模块PID，
    错误码由模块自行分配管理，如：0x01B50001表示SWM模块（PID十进制为437）的001
    号错误码。
    错误信息说明：
    表示检查不通过的详细信息，用于匹配升级工具资源文件中的关键字，
    比如资源文件描述“硬盘利用率检查不通过，当前最大利用率为%s（检查阈值50%），
    检查不通过的硬盘为(%s)。”，说明资源文件需要匹配两个关键字，
    这种情况错误信息打印格式为：当前最大利用率;硬盘id列表，如90;DAE000.0,DAE000.1,
    关键字之间使用英文分号“;”分隔，参数内部如果需要返回列表使用英文逗号“,”分隔
    :param src_ver: 当前版本，如7600501032
    :param target_ver:降级的目标版本，如7600500099
    :return:
    """
    # 目标版本非6.0.x或6.1.0.RC1 或 6.1.0.RC2 或 6.1.RC3 或 6.1.0或6.1.3时，检查结果为通过
    if ((not str(target_ver).startswith("7600500")) and
       (not str(target_ver).startswith("7600501")) and
       (not str(target_ver).startswith("7600502")) and
       (not str(target_ver).startswith("7600503")) and
       (not str(target_ver).startswith("76003")) and
       (not str(target_ver).startswith("760050"))):
        print("True")
        return
    diag_cmd_str = "pmgr issoftencryptcanupgradeback"
    
    # 执行回显输出的临时文件，为了尽量避免与其他检查项冲突，
    # 文件名建议通过随机字符串格式化
    cmd_exec_dis_output_file_path = "/tmp/checksoftencrypt_{0}" .\
        format(''.join(random.sample('zyxwvutsrqponmlkjihg', 5)
                       ))
    # 使用实际diagnose命令和回显输出文件替换diagnose执行命令字符串中的关键字
    # 如果需要执行cli命令，先格式化CLI_CHECK_CMD，
    # 如果需要直接执行shell命令，也可以直接执行，
    # 多个shell命令可以通过";"分隔后一起执行
    diag_cmd_str = DIAGNOSE_CHECK_CMD.format(12, diag_cmd_str,
                                             cmd_exec_dis_output_file_path)
    ret = os.system(diag_cmd_str)
    if ret:
        log.error("DOWNGRADE_CHECK: Cmd(%s) exec failed.", diag_cmd_str)
        print("False")
        return

    with open(cmd_exec_dis_output_file_path) as lines:
        lines_array = lines.readlines()
        for line in lines_array:
            # 解析每行字符串，获取需要的信息进行判断，
            # 如果需要解析某行某列更详细的信息或者需要进行更详细的计算，
            # 请根据检查逻辑实现，这里只列举解析行信息的方法
            if "False" in line:
                log.error("DOWNGRADE_CHECK: The sys flow have failed step.", line)
                print("False")
                return
    print("True")
    return

def get_cur_version():
    cur_version_manifest_yml = "/startup_disk/image/pkg_cur/manifest.yml"

    with open(cur_version_manifest_yml) as lines:
        lines_array = lines.readlines()
        for line in lines_array:
            if "Version:" in line:
                return line.split()[1]


def get_upg_version():
    upg_version_manifest_yml = "/startup_disk/image/pkg_upd/manifest.yml"

    with open(upg_version_manifest_yml) as lines:
        lines_array = lines.readlines()
        for line in lines_array:
            if "Version:" in line:
                return line.split()[1]

def main():
    """
    检查主函数，一般不需要修改
    :return:
    """
    try:
        # 当前版本，如果采用shell脚本实现，需要自行解析
        # /startup_disk/image/pkg_cur/manifest.yml中SYS下的version字段值
        src_ver = get_cur_version()
        # 降级/升级目标版本，如果采用shell脚本实现，需要自行解析
        # /startup_disk/image/pkg_upd/manifest.yml中SYS下的version字段值，
        # 此配置文件只有升级开始并完成软件包上传后才有
        target_ver = get_upg_version()
        log.info("DOWNGRADE_CHECK: System Version: %s target version: %s.",
                 src_ver, target_ver)
        if not src_ver or not target_ver:
            log.error("DOWNGRADE_CHECK: The src or target version is empty.")
            print("False")
            return 1
        downgrade_check(src_ver, target_ver)
        return 0
    except Exception as e:
        print("False")
        log.exception(e)
        return 1


if __name__ == '__main__':
    log = logging.getLogger("aa_checksecsaltusage")
    formatter = logging.Formatter(fmt="[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]",
                                  datefmt="%b %d %Y %H:%M:%S")
    file_handler = logging.FileHandler(filename="/OSM/log/cur_debug/message_euler")
    file_handler.setFormatter(formatter)
    log.addHandler(file_handler)
    log.setLevel(logging.INFO)
    sys.exit(main())
