#!/usr/bin/python
# -*- coding: utf-8 -*-
import logging
import os
import sys
import re


logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')
CURRENT_DIR = os.path.dirname(os.path.realpath(__file__))
OSP_BSP_DIR = "/proc/osp/bsp"
BAY_CONFIG_DIR = "/OSM/conf/bay_config.ini"

def is_enabled_container_feature():
    """
    容器使能是否开启0：开启，1：未开启
    "/proc/osp/bsp" 文件里含有conta为1,2启动容器特性
    Product config info:conta:1;smu:0
    """
    with open(OSP_BSP_DIR, "r") as f:
        lines = f.readlines()
        for line in lines:
            pos = line.find("conta")
            if pos == -1:
                continue
            info = line[pos: len(line)]
            tmp = re.split(":|;", info)
            if tmp[1] == "1" or tmp[1] == "2":
                return 1
    logging.info("Container not enabled.")
    return 0

def get_engine_id():
    with open(BAY_CONFIG_DIR, "r") as f:
        lines = f.readlines()
        for line in lines:
            pos = line.find("BayId")
            if pos == -1:
                continue
            record = line.lstrip().split("=", 1)
            engid = record[1]
            break
    engid_value = int(engid, 10)
    return engid_value

def get_high_card_num(record):
    port_name = record[0]
    port_name_s = port_name.lstrip().split(".", 3)
    card_num_str = port_name_s[2][1:len(port_name_s[2])]
    #获取高端卡的槽位号
    card_num = -1
    if card_num_str.isdigit():
        card_num = int(card_num_str, 10)
    else:
        logging.warning("Card num %s is invalid.", card_num_str)
    
    return card_num

def check_no_high_container_port(engine, record, find):
    dstA = "CTE" + str(engine) + ".A"
    dstB = "CTE" + str(engine) + ".B"
    
    port_name = record[0]
    port_name_s = port_name.lstrip().split(".", 3)
    str_port = port_name_s[0]+"."+port_name_s[1]
    #判断中低端对应控是否有容器端口
    if str_port == dstA:
        find[0] = 1
        return
    if str_port == dstB:
        find[1] = 1
    return

def check_high_container_port(engine, record, find):
    dstH = "CTE" + str(engine) + ".IOM.H"
    dstL = "CTE" + str(engine) + ".IOM.L"
    
    port_name = record[0]
    port_name_s = port_name.lstrip().split(".", 3)
    str_port = port_name_s[0]+"."+port_name_s[1]+"."+port_name_s[2][0]
    #判断高端对应象限是否有容器端口
    if str_port == dstH:
        card_num = get_high_card_num(record)
        if card_num >= 0 and card_num <= 6:
            find[2] = 1
        elif card_num >= 7 and card_num <= 13:
            find[4] = 1
        else:
            logging.warning("Card num %d is invalid.", card_num)
        return
    
    if str_port == dstL:
        card_num = get_high_card_num(record)
        if card_num >= 0 and card_num <= 6:
            find[3] = 1
        elif card_num >= 7 and card_num <= 13:
            find[5] = 1
        else:
            logging.warning("Card num %d is invalid.", card_num)
    return

def check_result_value(return_value):
    ret = 0
    logging.info("return value(%d,%d,%d,%d,%d,%d).", return_value[0], return_value[1], return_value[2], return_value[3], return_value[4], return_value[5])
    if return_value[0] and return_value[1]:
        ret = 0
    elif (return_value[0] ^ return_value[1]):
        ret = -1
    elif ((~return_value[2])^(~return_value[3])) or ((~return_value[4])^(~return_value[5])):
        ret = -1
    else:
        ret = 0
    
    return ret

def check_net_conatiner_port_type(engine):
    cmd_exec_dis_output_file_path = "/tmp/netgetnetplanemember"
    
    #find[0]表示中低端A控是否有容器端口,find[1]表示低端B控是否有容器端口
    #find[2]表示高端H0-H6是否有容器端口,find[3]表示高端L0-L6是否有容器端口
    #find[4]表示高端H7-H13是否有容器端口,find[5]表示高端L7-L13是否有容器端口
    find = [0, 0, 0, 0, 0, 0]
    with open(cmd_exec_dis_output_file_path) as lines:
        lines_array = lines.readlines()
        # 跳过前两行表头打印或是无记录时的回显
        lines_array = lines_array[5:]
        for line in lines_array:
            record = line.lstrip().split()
            check_no_high_container_port(engine, record, find)
            check_high_container_port(engine, record, find)
            
    ret = check_result_value(find)
    return ret

def check_net_conatiner_port_type_cmd(port_type, engine):
    logging.info("Port type is %d, engine is %d.", port_type, engine)
    cmd_exec_dis_output_file_path = "/tmp/netgetnetplanemember"
    # 构造cli命令
    if port_type == 1:
        cli_cmd_str = "echo -e 'show port general logic_type=Container_Front_End_Port physical_type=ETH running_status=link_up' | /ISM/cli/ismcli -u admin  > " + cmd_exec_dis_output_file_path
    elif port_type == 2:
        cli_cmd_str = "echo -e 'show port general logic_type=Container_Back_End_Port physical_type=ETH running_status=link_up' | /ISM/cli/ismcli -u admin  > " + cmd_exec_dis_output_file_path
    else:
        logging.warning("Type is invalid %d.", port_type)
        return -1
        
    ret = os.system(cli_cmd_str)
    if ret:
        logging.warning("Cmd(%s) exec failed, ret %d.", cli_cmd_str, ret)
        # 删除临时文件
        shell_cmd_str = "rm -f " + cmd_exec_dis_output_file_path
        os.system(shell_cmd_str)
        return -1
    
    return_value = check_net_conatiner_port_type(engine)
    
    shell_cmd_str = "rm -f " + cmd_exec_dis_output_file_path
    os.system(shell_cmd_str)
    return return_value

def check_conatiner_port():
    engineId = get_engine_id()
    if engineId == -1:
        logging.warning("Engine id is invalid.")
        return 
    #1表示eth类型容器前端卡，2表示eth类型的容器后端卡
    check_type_list = [1, 2]
    result = True
    for intfboard_type in check_type_list:
        ret = check_net_conatiner_port_type_cmd(intfboard_type, engineId)
        if ret != 0:
            result = False
            break
    if result:
        logging.info("Check conatiner card ok.")
        print("True")
    else:
        logging.info("Check conatiner card not ok.")
        print("False")
    return
    
def main():
    try:
        ret =  is_enabled_container_feature()
        if ret:
            check_conatiner_port()
        else :
            print("True")
        logging.info("Check conatiner card success.")
        return 0

    except Exception as e:
        logging.exception("Check conatiner card failed: %s", e)
        print("False")
        return 1

if __name__ == '__main__':
    sys.exit(main())
