#!/bin/bash

# 该脚本只用于检查影响快速升级的补丁
# any patch not found flag
hotpatchNotFound=1

# 6.0.0 patches need check befor upgrade
patches_6_0_0="HP0220 HP0222 HP0227 HP0228"
# 6.0.1 patches need check befor upgrade
patches_6_0_1="HP0432 HP0434 HP0436 HP0439 HP0440"

# all version need check
patches_other_version=""

function checkHotpatches()
{
    # output patch informations to temp file
    touch poolCheckPatchTempFile
    diagsh --attach=*_12 --cmd="dopra showareapatch" > "poolCheckPatchTempFile"
    
    # get the patches to check
    patches=""
    case $1 in 
        '6.0.0')
            patches=$patches_6_0_0
            ;;
        '6.0.1')
            patches=$patches_6_0_1
            ;;
        *)
            patches=$patches_other_version
            ;;
    esac
    
    for patch_item in $patches
    do
        str=$(cat poolCheckPatchTempFile | grep -a -i $patch_item | grep "Active")
        if [ -z "$str" ]; then
            rm -f poolCheckPatchTempFile
            return 1
        fi
    done
    
    hotpatchNotFound=0
    
    # delete temp file
    rm -f poolCheckPatchTempFile
    return 0
}

###################################### check begin ######################################

# Get version info
Version=`cat /OSM/conf/manifest.yml | grep -m 1 "Version" | awk '{print substr($0,15,10)}'`

case ${Version} in
    '7600301133')
        checkHotpatches '6.0.0'
        ;;
    '7600302133')
        checkHotpatches '6.0.1'
        ;;
    *)
        checkHotpatches
        ;;
esac

# check result
if [ $hotpatchNotFound -eq 0 ]; then
    # check pass
    echo "TRUE"
else
    # check fail
    echo "FALSE"
fi

exit 0
