#!/bin/bash
G_RET_SUCC=0
G_RET_FAIL=1
G_powerNum=0
MPA_Output="PSU_Output"
RESULT_STR=""
RESULT_POWER=""
RESULT_PSOK=""


function MPA_GET_POWER_OUTPUT()
{
    local CMD_EXEC=$1
(
diagnose_usr --auto <<EOF
attach 21
${CMD_EXEC}
exit
EOF
) >${MPA_Output}
}

function PSU_echo()
{
    local loop=0
    while ((${loop}<10)); do
        if [ -S "/dev/log" ]; then
            OS_echo "$1"
            break
        fi
        sleep 1
        let loop+=1
    done
}

function CHECK_POWER_OUTPUT()
{
    RESULT_POWER=""
    local frameType=""
    local powerOutput=(0 0 0 0)
    local percent=(0 0 0 0)
    local retCode=${G_RET_SUCC}

    G_powerNum=2 # 默认低端环境PSU数量 2
    frameType=$(grep -i "4U4C" /proc/osp/bsp)
    if [ "${frameType}" != "" ]; then
        G_powerNum=4 # 高端环境PSU数量 4
    fi
    PSU_echo "[Power Check] powerNum is ${G_powerNum}."

    MPA_GET_POWER_OUTPUT "mpa bmc getpoweroutput 1000 0"
    powerOutput[0]=$(grep "Power Output" "${MPA_Output}" |awk -F ":" '{print $2}')
    MPA_GET_POWER_OUTPUT "mpa bmc getpoweroutput 1001 0"
    powerOutput[1]=$(grep "Power Output" "${MPA_Output}" |awk -F ":" '{print $2}')

    percent[0]=$((powerOutput[0]*100/(powerOutput[0]+powerOutput[1]+1)))
    percent[1]=$((powerOutput[1]*100/(powerOutput[0]+powerOutput[1]+1)))
    if [[ ${percent[0]} -lt 10 ]] || [[ ${percent[1]} -lt 10 ]]; then
        RESULT_POWER="${RESULT_POWER}PSU0:${powerOutput[0]}, PSU1:${powerOutput[1]}"
        retCode=${G_RET_FAIL}
    fi

    if [ ${G_powerNum} -eq 4 ]; then
        MPA_GET_POWER_OUTPUT "mpa bmc getpoweroutput 1002 0"
        powerOutput[2]=$(grep "Power Output" "${MPA_Output}" |awk -F ":" '{print $2}')
        MPA_GET_POWER_OUTPUT "mpa bmc getpoweroutput 1003 0"
        powerOutput[3]=$(grep "Power Output" "${MPA_Output}" |awk -F ":" '{print $2}')

        percent[2]=$((powerOutput[2]*100/(powerOutput[2]+powerOutput[3]+1)))
        percent[3]=$((powerOutput[3]*100/(powerOutput[2]+powerOutput[3]+1)))
        if [[ ${percent[2]} -lt 10 ]] || [[ ${percent[3]} -lt 10 ]]; then
            retCode=${G_RET_FAIL}
            if [ "x${RESULT_POWER}" != "x" ]; then
                RESULT_POWER="${RESULT_POWER}, "
            fi
            RESULT_POWER="${RESULT_POWER}PSU2:${powerOutput[2]}, PSU3:${powerOutput[3]}"
        fi
    fi
    PSU_echo "[Power Check] Check result: ${retCode}, power output is ${powerOutput[0]} ${powerOutput[1]} ${powerOutput[2]} ${powerOutput[3]}, percent is ${percent[0]} ${percent[1]} ${percent[2]} ${percent[3]}."

    rm -f ${MPA_Output}
    return ${retCode}
}

function PANGEA_CHECK_POWER_OUTPUT()
{
    local loop=0
    local retCode=${G_RET_FAIL}
    while ((${loop}<3)); do
        CHECK_POWER_OUTPUT
        retCode=$?
        if [[ ${retCode} -eq ${G_RET_SUCC} ]]; then # 相等
            break
        fi
        sleep 3
        let loop+=1
    done
    RESULT_STR="${RESULT_POWER}"
    return ${retCode}
}

function CHECK_POWER_PSOK_LOG_NUM()
{
    local logPath="/OSM/log/cur_debug/pangea/BMC/tmp/BMCLOG/local"
    local LogFileName="app*.tar.gz"
    local powerName="Power$1"
    local curr_path=$(dirname $0)
    local powerLogTar="${curr_path}/power_log_tar"
    local powerLogFru="${curr_path}/power_log_fru"
    local powerLogPsOk="${curr_path}/power_log_psok"
    local tmpLogTime=""
    local powerLogCount=0
    local retCode=${G_RET_SUCC}
    local curLogTime=$(date +%Y-%m-%d)
    local staLogTime=$(date -d "${curLogTime} -180 day" +%Y-%m-%d)   # power检查时间为180天
    local PowerPsokStr=""

    # 筛选powerfru模块日志
    zcat ${logPath}/${LogFileName} >${powerLogTar} 2>&1
    grep -iaE "powerfru" ${powerLogTar} |grep -ia ${powerName} >${powerLogFru}
    # 获取power模块在位状态变化的最新时间, 确定power风险检查时间范围
    tmpLogTime=$(grep -iaE 'present state change from 0 to 1|present change from 0 to 1' ${powerLogFru} |grep -ia "^20" |sort |uniq |tail -n 1 | awk '{print $1}')
    if [ "${tmpLogTime}" != "" ]; then
        if [ ${tmpLogTime} \> ${staLogTime} ]; then
            staLogTime=$(date -d "${tmpLogTime} -1 day" +%Y-%m-%d)
        fi
    fi
    
    # 筛选powerfru模块的ps ok变化日志，去除1970打头的日志(BMC启动时打印的非有效变化)和重复日志
    grep -iaE 'ok state change from 1 to 0|ps ok change from 1 to 0' ${powerLogFru} |grep -ia "^20" |sort |uniq >${powerLogPsOk}
    # 统计power检查时间范围内风险日志
    for logTime in $(cat ${powerLogPsOk} |awk -F " " '{print $1$2}'); do
        if [ ${logTime} \> ${staLogTime} ]; then
            let powerLogCount+=1
            if [ ${powerLogCount} -le 15 ]; then
                if [ "x${PowerPsokStr}" != "x" ]; then
                    PowerPsokStr="${PowerPsokStr}, "
                fi
                PowerPsokStr="${PowerPsokStr}${logTime:0:10} ${logTime:10:8}"
            fi
        fi
    done
    # 检查时间内, ps ok由1变为0的次数边界12次
    local result="less"
    if [ ${powerLogCount} -gt 12 ]; then
        result="more"
        retCode=${G_RET_FAIL}
        if [ "x${RESULT_PSOK}" != "x" ]; then
            RESULT_PSOK="${RESULT_PSOK}, "
        fi
        RESULT_PSOK="${RESULT_PSOK}[${powerName}: ${PowerPsokStr}]"
    fi
    PSU_echo "[Power Check] Check result: ${retCode}, Time:[${staLogTime} -- ${curLogTime}], ${powerName} Risk Log(ok state change from 1 to 0) count is ${powerLogCount}, ${result} than 12."

    rm -f ${powerLogTar}
    rm -f ${powerLogFru}
    rm -f ${powerLogPsOk}
    return ${retCode}
}

function PANGEA_CHECK_POWER_PSOK_LOG()
{
    RESULT_PSOK=""
    local retCode=${G_RET_SUCC}
    
    CHECK_POWER_PSOK_LOG_NUM 0
    let retCode+=$?
    CHECK_POWER_PSOK_LOG_NUM 1
    let retCode+=$?
    if [ ${G_powerNum} -eq 4 ]; then
        CHECK_POWER_PSOK_LOG_NUM 2
        let retCode+=$?
        CHECK_POWER_PSOK_LOG_NUM 3
        let retCode+=$?
    fi
    if [ "${RESULT_PSOK}" != "" ]; then
        RESULT_STR="${RESULT_STR} ## Risk Log(ok state change from 1 to 0): ${RESULT_PSOK}."
    fi
    return ${retCode}
}

PANGEA_CHECK_POWER_OUTPUT
ret1=$?
PANGEA_CHECK_POWER_PSOK_LOG
ret2=$?
if [[ ${ret1} -ne ${G_RET_SUCC} ]] || [[ ${ret2} -ne ${G_RET_SUCC} ]]; then # 不相等
    echo "False"
    echo "11001"
    echo "${RESULT_STR}"
    exit 0
fi

echo "True"
exit 0

