#!/bin/bash
G_RET_SUCC=0
G_RET_FAIL=1

CMD_Output="mpabmc_output"
RESULT_STR=""


# MPA命令执行 用户态及attach 21
function MPA_BMC_CMD_OUTPUT()
{
    local CMD_EXEC=$1
(
diagnose_usr --auto <<EOF
attach 21
${CMD_EXEC}
exit
EOF
) > ${CMD_Output}
}

function PSU_echo()
{
    local loop=0
    while ((${loop}<10)); do
        if [ -S "/dev/log" ]; then
            OS_echo "$1"
            # echo "$1"
            break
        fi
        sleep 1
        let loop+=1
    done
}

UPD_KPG_VER_EVAL=""
function GET_UPD_KPG_VERSION()
{
(
swm_diagnose --auto <<EOF
host show
exit
EOF
) > ${CMD_Output}
    UPD_KPG_VER_EVAL=""
    local get_upd_pkg_ver="/home/permitdir/"
    local upd_pkg_ver_file="/tmp/check_extend_param"
    local loop=0
    local retCode=1
    
    if [[ -f "${upd_pkg_ver_file}" ]]; then
        while read line; do
            if [[ "${line}" =~ "(True)" ]]; then
                ip_array=($(echo ${line} |tr ',' ' '))
                for ip in ${ip_array[@]}; do
                    if [[ "${ip}" =~ "(True)" ]]; then
                        if [[ "${ip}" =~ "ip:" ]]; then
                            node_ip=$(echo ${ip} |awk -F ":" '{print $2}' |awk -F "(" '{print $1}')
                        else
                            node_ip=$(echo ${ip} |awk -F "(" '{print $1}')
                        fi
                        loop=0
                        retCode=1
                        while ((${loop}<5)); do
                            sudo sh os_put_file.sh "${node_ip}" "${upd_pkg_ver_file}" "${get_upd_pkg_ver}"
                            retCode=$?
                            PSU_echo "[PangeaCheckPsuUpgradeRisk]${node_ip} os_put_file retCode: ${retCode}"
                            if [[ ${retCode} -eq "0" ]]; then # 相等
                                break
                            fi
                            sleep 1
                            let loop+=1
                        done
                        break
                    fi
                done
            fi
        done < ${CMD_Output}
    fi
    loop=0
    while ((${loop}<5)); do
        if [[ -f "${get_upd_pkg_ver}check_extend_param" ]]; then
            upd_pkg_param=$(grep -iaE 'targetVersion' ${get_upd_pkg_ver}check_extend_param |awk -F ": " '{print $2}')
            if [[ "s${upd_pkg_param}" == "s" ]]; then
                upd_pkg_param=$(grep -iaE 'targetVersion' ${get_upd_pkg_ver}check_extend_param |awk -F ":" '{print $2}')
            fi
            UPD_KPG_VER_EVAL=${upd_pkg_param:1:5} # 截取评估版本
            break
        fi
        sleep 1
        let loop+=1
    done
    rm -f ${get_upd_pkg_ver}check_extend_param
    rm -f ${CMD_Output}
    return
}

function CHECK_UPGRADE_PKG_VERSION()
{
    local cur_pkg_ver=""
    local upd_pkg_ver=""
    
    # 获取当前版本
    if [ -f "/startup_disk/image/pkg_cur/manifest.yml" ]; then
        cur_pkg_ver=$(grep -iaE 'SpcVersion' /startup_disk/image/pkg_cur/manifest.yml |awk -F ": " '{print $2}')
    fi
    
    # 获取升级版本
    GET_UPD_KPG_VERSION
    upd_pkg_ver="${UPD_KPG_VER_EVAL}"
    
    PSU_echo "[PangeaCheckPsuUpgradeRisk]cur_pkg_ver:${cur_pkg_ver}"
    PSU_echo "[PangeaCheckPsuUpgradeRisk]upd_pkg_ver:${upd_pkg_ver}"
    if [ "${upd_pkg_ver}" \< "6.1.6" ]; then
        PSU_echo "[PangeaCheckPsuUpgradeRisk]upd_pkg_ver:ok"
        return 0 # 不检查
    fi
    
    if [[ "${cur_pkg_ver}" = "6.0.0" ]] || [ "${cur_pkg_ver}" \> "6.0.0" ]; then
        if [ "${cur_pkg_ver}" \< "6.1.6" ]; then
            PSU_echo "[PangeaCheckPsuUpgradeRisk]cur_pkg_ver:ok"
            return 1
        fi
    fi
    
    return 0 # 不检查
}

function CHECK_POWER_DCDC_VERSION()
{
    RESULT_STR=""
    local PSU_PAC2000S12_BG="50 41 43 32 30 30 30 53 31 32 2d 42 47" # 电源型号
    local retCheck=0
    frameType=$(grep -i "Product Name" /proc/osp/bsp |awk -F "is" '{print $2}')
    if [[ "${frameType}" =~ "HI1620_4U4C" ]]; then
        PSU_echo "[PangeaCheckPsuUpgradeRisk]Device is HI1620_4U4C"
        return 0 # 不检查
    fi
    
    for fruID in {0,1}; do
        psu_model=$(sudo ipmitool raw 0x32 0x2c ${fruID} 0x20 0 0 0 2>&1)
        psu_model=${psu_model:1:38} # 截取电源型号
        PSU_echo "[PangeaCheckPsuUpgradeRisk]psu_model PSU${fruID}: ${psu_model}"
        if [[ "${psu_model}" != "${PSU_PAC2000S12_BG}" ]]; then
            continue
        fi
        MPA_BMC_CMD_OUTPUT "mpa bmc getpowerversion 100${fruID} 1"
        psu_version=$(grep "Power Software Version" "${CMD_Output}" |awk -F ":" '{print $2}')
        PSU_echo "[PangeaCheckPsuUpgradeRisk]psu_version PSU${fruID}:${psu_version}"
        if [[ "x${psu_version}" == "x111" ]] || [[ "x${psu_version}" == "x113" ]] || \
           [[ "x${psu_version}" == "x115" ]] || [[ "x${psu_version}" == "x119" ]]; then
            retCheck=1
        fi
        if [ "x${retCheck}" == "x1" ]; then
            if [ "x${RESULT_STR}" != "x" ]; then
                RESULT_STR="${RESULT_STR}, "
            fi
            RESULT_STR="${RESULT_STR}PSU${fruID}:${psu_version}"
        fi
    done
    rm -f ${CMD_Output}
    
    return ${retCheck}
}

function main()
{
    local retCode=0
    CHECK_UPGRADE_PKG_VERSION
    retCode=$?
    if [ ${retCode} -eq 0 ]; then
        return 0
    fi
    CHECK_POWER_DCDC_VERSION
    retCode=$?
    if [ ${retCode} -eq 0 ]; then
        return 0
    fi
    return 1
}
main
ret=$?
if [[ ${ret} -eq ${G_RET_SUCC} ]]; then # 相等
    echo "True"
    exit 0 
fi

echo "False"
echo "11001"
echo "${RESULT_STR}"
exit 0

