#!/bin/bash

IMAGE_DISK="/startup_disk/image"
COFFER_DATA="/OSM/coffer_data"
LOG_TAG=$(basename "$0")

if [ -f /usr/bin/root_proxy ]; then
  ROOT_PROXY="/usr/bin/root_proxy --proxy-ignore-insecure 1 --proxy-shname $0 --proxy-lineno $LINENO"
fi

# **************************************************************************** #
# Function Name: mount_with_retry
# Description: remount /startup_disk/image分区，3次重试
# Parameter:
# Return: 0表示成功，1表示失败
# **************************************************************************** #
mount_with_retry()
{
    #修改启动分区读写权限
    local disk_property=$1
    for((i=0;i<3;i++))
    do
        ${ROOT_PROXY} mount -o ${disk_property},remount ${IMAGE_DISK} 1>/dev/null 2>/dev/kmsg
        mount_ret=$?
        if [ ${mount_ret} -eq 0 ];then
            break
        fi
        OS_echo "[${LOG_TAG}]:mount ${IMAGE_DISK} for ${disk_property} fail times=${i}."
        sleep 1
    done
    if [ ${mount_ret} -ne 0 ];then
        OS_echo "[${LOG_TAG}]:mount ${IMAGE_DISK} for ${disk_property} fail."
        return 1
    fi
    return 0
}

# **************************************************************************** #
# Function Name: sys_disk_read_check
# Description: 系统盘读检查
# Parameter:
# Return: 0表示成功，1表示失败
# **************************************************************************** #
function sys_disk_read_check()
{
    local read_ret=0
    local swm_data_dir="${COFFER_DATA}"/swm
    local image_boot_dir="${IMAGE_DISK}"/boot
    ls -l "${swm_data_dir}" > /dev/null
    if [ $? -ne 0 ]; then
      OS_echo "[${LOG_TAG}]:dir ${swm_data_dir} not exists."
      return 1
    fi

    for file in $(find "${swm_data_dir}" -type f)
    do
        cat ${file} > /dev/null
        ret=$?
        if [ ${ret} -ne 0 ]; then
            read_ret=${ret}
            OS_echo "[${LOG_TAG}]:read file: ${file} failed, ret: ${ret}."
        fi
    done

    ls -l "${image_boot_dir}" > /dev/null
    if [ $? -ne 0 ]; then
      OS_echo "[${LOG_TAG}]:dir ${image_boot_dir} not exists."
      return 1
    fi
    for file in $(find "${image_boot_dir}" -type f)
    do
        cat ${file} > /dev/null
        ret=$?
        if [ ${ret} -ne 0 ]; then
            read_ret=${ret}
            OS_echo "[${LOG_TAG}]:read file：${file} failed, ret: ${ret}."
        fi
    done
    if [ ${read_ret} -ne 0 ]; then
        return 1
    fi
    OS_echo "[${LOG_TAG}]:sys disk read success."
    return 0
}

# **************************************************************************** #
# Function Name: sys_disk_write_test
# Description: 系统盘写检查
# Parameter:
# Return: 0表示成功，1表示失败
# **************************************************************************** #
function sys_disk_write_check()
{
    local write_ret=0
    touch ${COFFER_DATA}/swm/test && fsync ${COFFER_DATA}/swm/test && ${ROOT_PROXY} rm ${COFFER_DATA}/swm/test > /dev/null
    if [ $? -ne 0 ]; then
        write_ret=1
        OS_echo "[${LOG_TAG}]:${COFFER_DATA/swm} write failed."
    fi
    mount_with_retry rw
    if [ $? -ne 0 ]; then
        return 1
    fi
    touch ${IMAGE_DISK}/boot/test && fsync ${IMAGE_DISK}/boot/test && ${ROOT_PROXY} rm ${IMAGE_DISK}/boot/test > /dev/null
    if [ $? -ne 0 ]; then
        write_ret=1
        OS_echo "[${LOG_TAG}]:${COFFER_DATA/swm} write failed."
    fi
    mount_with_retry ro
    if [ ${write_ret} -ne 0 ]; then
        return 1
    fi
    OS_echo "[${LOG_TAG}]:sys disk write success."
    return 0
}

sys_disk_read_check
result_read=$?
sys_disk_write_check
result_write=$?
if [ ${result_read} -eq 0 ] && [ ${result_write} -eq 0 ]; then
    exit 0
else
    exit 1
fi
