#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2018-2022. All rights reserved.
import os
import re
import sys

from check_item.check_util.extend_param_mgr import ExtendParamMgr
from check_item.check_util.sql_executor import SqlExecutor
from infra.debug.log import swm_logger as log

PYTHON_2 = '2.7' in sys.version
BSP_FILE_PATH = "/proc/osp/bsp"


def is_need_check_ultrapath_version():
    res, dst_version = ExtendParamMgr.get_extend_param("targetVersion")
    if not res:
        return False
    if len(dst_version) < 5:
        return False
    # 筛选6.1.3以前版本
    match_obj = re.match(r'[6-9][.][1-9][.][3-9]', dst_version)
    if not match_obj:
        return False
    if "6.1.3RC1" in dst_version:
        return False
    return True


def check_dev_is_ocean_protect():
    if not os.path.exists(BSP_FILE_PATH):
        log.error("{} not exists.".format(BSP_FILE_PATH))
        return False
    try:
        with open(BSP_FILE_PATH, "rb") as file:
            contents = file.read()
        if PYTHON_2:
            ret = re.search(r"Model of products is:(\w+)", contents)
        else:
            ret = re.search(b"Model of products is:(\w+)", contents)
        if ret:
            product_info = ret.groups()[0].decode()
            # 二级存储X系列
            if "_X" in product_info:
                return True
            # 二级存储A系列
            if "_S" in product_info:
                return True
    except Exception:
        log.exception("Failed to get bsp file info.")
    return False


def main(argv=None):
    if not is_need_check_ultrapath_version():
        log.info("No need to check ultrapath version.")
        print("True")
        return 0

    if check_dev_is_ocean_protect():
        print("True")
        return 0

    try:
        res, invalid_ini_key_list = SqlExecutor.get_windows_invalid_ini_key()
        if not res:
            print("False")
            print("Get ultrapath version error.")
            return 0
        if len(invalid_ini_key_list) == 0:
            print("True")
            return 0
        print("False")
        print("UltraPath need upgrade.")
        print("Initiator(IQN/WWN): {}".format(", ".join(invalid_ini_key_list)))
    except Exception as e:
        log.exception(e)
        print("False")
        print("Get ultrapath version error:")
        print("Exception")
    return 0


if __name__ == '__main__':
    sys.exit(main())
