#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
import logging
import time
import shlex
import subprocess
import sys


# 功能：检查fullcopy资源是否使用正常，当检查异常时则升级检查不通过，因为有可能导致业务中断
# 实现：阵列上，通过diagnose获取fullcopy的引用计数，若计数20s内持续不归零则检查不通过。
logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')

# 直接执行CLI命令的字符串格式：
# {0}表示需要执行的CLI命令，
# {1}表示执行的CLI命令的用户名，
# {2}表示命令执行回显重定向文件，用于命令执行后的结果解析
TIMEOUT = 30


def diagnose_fullcopy():
    cmd = 'diagsh --attach=*_12 --cmd="vol showallcount all on"'
    process = subprocess.Popen(shlex.split(cmd), stdout=subprocess.PIPE)
    timeout_para = {} if '2.7' in sys.version else {"timeout": TIMEOUT}
    out = process.communicate(**timeout_para)
    return out[0].decode("utf-8")


def update_check_map(line, key, need_check_map, check_count, is_normal):
    strs = line.split()
    if len(strs) > 5 and strs[4] == "0":
        need_check_map[key] = False
        check_count -= 1
        return is_normal, check_count
    return False, check_count


def is_fullcopy_resource_normal(lines, need_check_map, check_count):
    is_normal = True
    for line in lines:
        if check_count == 0:
            return True, check_count
        for key, val in need_check_map.items():
            if val and key in line:
                is_normal, check_count = update_check_map(line, key, need_check_map, check_count, is_normal)
    return is_normal, check_count


def vol_check_fullcopy_resources():
    need_check_map = {
        "VOLS_FCOPY_READ_GET_HASHREC": True,
        "VOLS_FCOPY_PREWRITE_COPY_GET_HASHREC": True,
        "VOLS_VAAI_ADD_TO_BGR ": True,
        "VOLS_SENDTODST_GET_HASH_RECORD": True,
        "VOLS_COUNTER_GET_HASH_RECORD": True
    }
    check_count = len(need_check_map)
    retry_count = 5
    start_time = time.time()
    while time.time() - start_time <= 20:
        cmd_result = diagnose_fullcopy()
        if not cmd_result:
            if retry_count > 0:
                logging.warning("diag failed, retry. remaining: %d", retry_count)
                retry_count -= 1
                time.sleep(1)
                continue
            else:
                print("False")
                return False
        for key in need_check_map.keys():
            if need_check_map[key] and key not in cmd_result:
                need_check_map[key] = False
                check_count -= 1
        lines = cmd_result.splitlines(False)
        is_normal, check_count = is_fullcopy_resource_normal(lines, need_check_map, check_count)
        if is_normal:
            print("True")
            return True
        time.sleep(1)
    print("False")
    return False


def main():
    try:
        # 框架已经确认版本都是问题版本：612-618
        vol_check_fullcopy_resources()
        return 0
    except Exception as exp:
        logging.exception("vol_check_fullcopy_resources: %s", exp)
        print("False")
        return 0


if __name__ == '__main__':
    sys.exit(main())
