#!/bin/bash

#checkitems add inspect new id
allneedCheckSofeWareEx="139 157 270 273 274 275 294 311 312 313 314 315 316 317 328 350 351 352 353 354 355 356 357 358"
#Զ̽ڵȡϢѲ
normal_remote_taskids="139 157 311 312 313 314 315 317 328"
quality_remote_taskids="350 351 352 354 357 358"
#ֻڱؽڵͿԻȡѲ
normal_local_taskids="270 273 274 275 294 316"
quality_local_taskids="353 355 356"
needcheck_quality_taskids="350 351 352 353 354 355 356 357 358"
needcheck_normal_taskids="139 270 273 274 275 294 311 312 313 314 315 316 317 328"

MapHealthStatus()
{
    case $1 in
        0)
            echo "UNKNOWN"
            ;;
        1)
            echo "NORMAL"
            ;;
        2)
            echo "FAULT"
            ;;
        3)
            echo "PRE_FAIL"
            ;;
        4)
            echo "PART_BROKEN"
            ;;
        5)
            echo "DEGRADE"
            ;;
        6)
            echo "HAS_BAD_BLOCK"
            ;;
        7)
            echo "HAS_ERROR_CODE"
            ;;
        8)
            echo "CONSISTENT"
            ;;
        9)
            echo "INCONSISTENT"
            ;;
        10)
            echo "BUSY"
            ;;
        11)
            echo "POWER_NO_INPUT"
            ;;
        12)
            echo "POWER_NOT_ENOUGH"
            ;;
        13)
            echo "SINGLE_LINK_FAULT"
            ;;
         *)
            echo "No this type"
            ;;
    esac
}

MapNodeServiceType()
{
    case $1 in
    1)
        echo "DFS"
        ;;
    2)
        echo "S3"
        ;;
    3)
        echo "SWIFT"
        ;;
    *)
        echo "UNKNOWN"
        ;;
    esac  
}

MapRunningStatus()
{
    case $1 in
        0)
            echo "UNKNOWN"
            ;;
        1)
            echo "NORMAL"
            ;;
        2)
            echo "RUNNING"
            ;;
        3)
            echo "NOT_RUNNING"
            ;;
        4)
            echo "NOT_EXIST"
            ;;
        5)
            echo "HIGH_TEMPERATURE_SLEEP"
            ;;
        6)
            echo "STARTING"
            ;;
        7)
            echo "POWER_FAILURE_PROTECTING"
            ;;
        8)
            echo "SLEEPING"
            ;;
        9)
            echo "SPINGUP"
            ;;
        10)
            echo "LINK_UP"
            ;;
        11)
            echo "LINK_DOWN"
            ;;
        12)
            echo "POWER_ON"
            ;;
        13)
            echo "POWER_OFF"
            ;;
        14)
            echo "PRE_COPY"
            ;;
        15)
            echo "COPYBACK"
            ;;
        16)
            echo "RECONSTRUCTION"
            ;;
        17)
            echo "EXPANSION"
            ;;
        18)
            echo "NOT_FORMAT"
            ;;
        19)
            echo "FORMATTING"
            ;;
        20)
            echo "UNMAPPING"
            ;;
        21)
            echo "INITIAL_SYNCHRONIZING"
            ;;
        22)
            echo "CONSISTENT"
            ;;
        23)
            echo "SYNCHRONIZING"
            ;;
        24)
            echo "SYNCHRONIZED"
            ;;
        25)
            echo "NOT_SYNCHRONIZED"
            ;;
        26)
            echo "SPLIT"
            ;;
        27)
            echo "ONLINE"
            ;;
        28)
            echo "OFFLINE"
            ;;
        29)
            echo "LOCKED"
            ;;
        30)
            echo "ENABLE"
            ;;
        31)
            echo "DISABLED"
            ;;
        32)
            echo "LEVELING"
            ;;
        33)
            echo "TO_BE_RECOVERD"
            ;;
        34)
            echo "INTERRUPTED"
            ;;
        35)
            echo "INVALID"
            ;;
        36)
            echo "NOSTART"
            ;;
        37)
            echo "QUEUING"
            ;;
        38)
            echo "STOP"
            ;;
        39)
            echo "COPYING"
            ;;
        40)
            echo "COMPLETED"
            ;;
        41)
            echo "PAUSE"
            ;;
        42)
            echo "REVSYNCHRONIZING"
            ;;
        43)
            echo "ACTIVATED"
            ;;
        44)
            echo "ROLLBACK"
            ;;
        45)
            echo "INACTIVATED"
            ;;
        46)
            echo "IDLE"
            ;;
        47)
            echo "POWERING_OFF"
            ;;
        48)
            echo "CHARGING"
            ;;
        49)
            echo "CHARGED"
            ;;
        50)
            echo "DISCHARGING"
            ;;
        51)
            echo "UPGRADING"
            ;;
        55)
            echo "ONLINE_DISABLED"
            ;;
        56)
            echo "OFFLINE_DISABLED"
            ;;
        57)
            echo "ONLINE_FROZEN"
            ;;
        58)
            echo "OFFLINE_FROZEN"
            ;;
        59)
            echo "SHUTDOWN"
            ;;
        98)
            echo "LOADING"
            ;;
        99)
            echo "INSTALLING"
            ;;
        *)
            echo "No this type"
            ;;
    esac
}

MapDeviceType()
{
    case $1 in
        33)
            echo "P25 Node"
            ;;
        34)
            echo "P36|C36 Node"
            ;;
        65)
            echo "P12 Node"
            ;;
        74)
            echo "C72 Node"
            ;;

        *)
            echo "No this node type"
            ;;
    esac
}

MapNodeType()
{
    case $1 in
        0)
            echo "P Node"
            ;;
        1)
            echo "C Node"
            ;;
        2)
            echo "B Node"
            ;;
        3)
            echo "M Node"
            ;;
        4)
            echo "C72 Node"
            ;;
        5)
            echo "P25 Node"
            ;;
        6)
            echo "P36 Node"
            ;;
        7)
            echo "C36 Node"
            ;;
        8)
            echo "P12 Node"
            ;;
        12)
            echo "P12E Node"
            ;;
        13)
            echo "P25E Node"
            ;;
        14)
            echo "P36E Node"
            ;;
        15)
            echo "C36E Node"
            ;;
        *)
            echo "No this node type"
            ;;
    esac
}

MapDiskType()
{
    case $1 in
        0)
            echo "FC"
            ;;
        1)
            echo "SAS"
            ;;
        2)
            echo "SATA"
            ;;
        3)
            echo "SSD"
            ;;
        4)
            echo "NL_SAS"
            ;;
        5)
            echo "SLC_SSD"
            ;;
        6)
            echo "MLC_SSD"
            ;;
        *)
            echo "No this type"
            ;;
    esac
}

MapPowerType()
{
    case $1 in
        0)
            echo "DC"
            ;;
        1)
            echo "AC"
            ;;
        *)
            echo "No this type"
            ;;
    esac
}
BusModeStatus()
{
    case $1 in
    0)
        echo  "IDE"
        ;;
    1)
        echo  "VIRTIO"
        ;;
    *)
        echo "No this type"
        ;;
    esac
}
StatModeStatus()
{
    case $1 in
    0)
        echo "HD"
        ;;

    1)
        echo "CD"
        ;;
    *)
        echo "No this type"
        ;;
    esac

}

###addѲӳ
GetInspectType()
{
    case $1 in 
    139)
        # rmbg񲢷
        echo "checkRMGB"
        ;;
    157)
        #ڵӱǩ
        echo "CheckElecLabel"
        ;;
    270)
        echo "CheckNodeState"
        ;;
    273) 
        echo "CheckBalanceStatus"
        ;;
    274) 
        echo "CheckCertificate"
        ;;
    275) 
        echo "CheckDataMoveEnd"
        ;;
    294)
        echo "checkDiskNokickStatus"
        ;;
    311)
        echo "CheckBirthTime"
        ;;
    312) 
        echo "checkKernelHotPatch"
	;;
    313) 
        echo "CheckDepXML"
	;;
    314)
        echo "CheckAllCertificate"
        ;;
    315)
        echo "nas_check_quota_scan"
	;;
    316)
        echo "CheckMasterSpecialConfig"
	;;
    317)
        echo "CheckALLNodeSpecialConf"
	;;
    328)
        echo "checkDiskModePage"
        ;;        
    350)
        echo "CheckStorageVersion"
        ;;
    351)
        echo "CheckHardWareVersion"
        ;;
    352)
        echo "CheckFrontAndBackPort"
        ;;
    353)
        echo "CheckFrontIPNumber"
        ;;
    354)
        echo "CheckBackNetworkIPaddr"
        ;;
    355)
        echo "CheckClusterRedundancyRatio"
        ;;
    356)
        echo "CheckClusterNodeNumber"
        ;;    
    357)
        echo "CheckNodePoolDiskConsistency"
        ;;
    358)
        echo "CheckManagerNet"
        ;;   
    *)
        echo ""
        ;;
    esac
}

NID_ROLE_FILE="/tmp/tmp_nid_role"

IP_ROLE_FILE="/tmp/tmp_ip_role"
#??3?2??DD???ip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#нڵĺIP
function GetIPAndRoleFromDB()
{
    local lineinfo=""
    local numCnt=1
    local tempnumCnt=1
    local lastNID=""
    local localNID=""
    local templocalNID=""
    local totalline=0
    local count=1

    > $IP_ROLE_FILE
    > $NID_ROLE_FILE
    #ݿȡнڵĺIP
    LOG "[$FUNCNAME]start get all nid from cm_conf.db"
    JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
    while [[ "${JavaId}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get all nid from db ,count=$count"
        JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
        count=$((count + 1))
        if [ $count -gt 5 ];then
            break
        fi
    done
    totalline=`echo "$JavaId" | wc -l`

    while [ $numCnt -le $totalline ]; do

        lineinfo=`echo $JavaId | awk '{print $'$numCnt'}'`

        ItemIp=`echo $lineinfo | awk -F'|' '{print $2}'`
        localNID=`echo $lineinfo | awk -F'|' '{print $1}'`

        if [ "$localNID" == "$lastNID" ];then
            #ͬһڵ㣬һѭ
            numCnt=$((numCnt+1))

            continue
        fi

        #pingһ¼Ƿͨ
        for time in ${RepeatTimes[*]};do
            tempStr_ping=`ping -q -c 1 $ItemIp  | grep received | awk '{print $4}'`
            local iRet=$?
            if [ $iRet -ne 0 ]; then
                sleep 10
            else
                break
            fi
        done

        #
        numCnt=$((numCnt+1))
        lastNID=$localNID

        if [ "$tempStr_ping" -le 0 ];then

            LOG "[$FUNCNAME] try another ip: numCnt:$numCnt,$localNID,$ItemIp,tempStr_ping:$tempStr_ping"

            #Եڶip
            templocalNID=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $1}'`

            #жǷͬһڵ
            if [ "$localNID" == "$templocalNID" ];then
                ItemIp=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $2}'`
                for time in ${RepeatTimes[*]};do
                    tempStr_ping=`ping -q -c 2 $ItemIp  | grep received | awk '{print $4}'`
                    local iRet=$?
                    if [ $iRet -ne 0 ]; then
                        sleep 10
                    else
                        break
                    fi
                done

                LOG "[$FUNCNAME]numCnt:$numCnt,$templocalNID,$ItemIp ,tempStr_ping:$tempStr_ping"

                #
                numCnt=$((numCnt+1))
                lastNID=$localNID

                if [ "$tempStr_ping" -le 0 ];then
                    #ڶҲͨһѭ
                    LOG "[$FUNCNAME]Node:$localNID,$ItemIp ping fail"
                    continue
                fi
            else
               #ͬһڵ㣬һѭ
               continue
            fi
        fi

        #жϽڵǷúͶ
        Status_info=`remote_exec $ItemIp 30 "cat /opt/huawei/snas/etc/snas.ini | grep "status=""`
        iRet=$?
        LOG "[$FUNCNAME]node:$ItemIp,Status_info:$Status_info,iRet:$iRet."
        if [ "$iRet" -eq "0" ] && [ "$Status_info" != "" ];then
            Status_values=`echo $Status_info | awk -F= '{print $2}'`
            Status_value=`echo $Status_values | awk '{print $1}'`
            if [ "$Status_value" == "0" ];then
                echo -n "$ItemIp " >> $IP_ROLE_FILE
                echo -n "$localNID " >> $NID_ROLE_FILE
                LOG "[$FUNCNAME]add $ItemIp,$localNID"
            fi
        fi

    done
}
