#!/bin/bash

. /opt/node_type_recognize.sh
CONFIG_FILE="/var/log/Config.txt"
LOG_FILE="/var/log/inspect.log"
function log
{
    echo [`date`][$!]$@ >> $LOG_FILE
}

#判断是节点类型。
function IsRHNode()
{
    local name=''
    name=$(dmidecode -t 1 | grep "Product Name:" | awk '{print $3}')
    if [ "$name" = "RH2288" -o "$name" = "5288" -o "$name" = "RH2288H" ]; then
        return 0
    else
        return 1
    fi
}
function IsT3000Node()
{
    local name=''
    name=$(dmidecode -t 1 | grep "Product Name:" | awk '{print $3}')
    if [ "$name" = "T3200" -o "$name" = "T3500" -o "$name" = "T3000" ]; then
        return 0
    else
        return 1
    fi
}

MapNodeType()
{
	case $1 in
		0)
			echo "P Node"
			;;
		1)
			echo "C Node"
			;;
		2)
			echo "B Node"
			;;
		3)
			echo "M Node"
			;;
		4)
			echo "C72 Node"
			;;
		5)
			echo "P25 Node"
			;;
		6)
			echo "P36 Node"
			;;
		7)
			echo "C36 Node"
			;;
		8)
			echo "P12 Node"
			;;
		12)
		    echo "P12E Node"
		    	;;
		13)
		    echo "P25E Node"
		  	;;
		14)
		    echo "P36E Node"
            		;;
        	15)
		    echo "C36E Node"
           		 ;;
		*)
		echo "No this node type"
			;;
	esac
}

function IsC72Node()
{
    dmidecode -t 4 | grep -q "Family: Atom"
    return $?
}

function collectPrintFirmWare()
{
    local NodeID=$1
    local FirmWareType=$2
    local FirmWareVer=$3
    echo "" >> $CONFIG_FILE 2>&1
    echo "        NodeId      :${NodeID}" >> $CONFIG_FILE 2>&1
    echo "        FirmwireName:${FirmWareType}" >> $CONFIG_FILE 2>&1
    echo "        FirmwireVer :${FirmWareVer}" >> $CONFIG_FILE 2>&1
}

#获取固件版本信息
#注：V3R6C00没有inspect_collect_nodeinfo.sh文件，本文件为后面适配扩容评估加的
#该版本没有获取固件信息的条件，且扩容工具不需要固件信息，故不检查固件信息，保留格式
function collectFirmWareInfo()
{
    echo "Firmware--------------------------------" >> $CONFIG_FILE 2>&1
    echo "    Number of Firmware:0" >> $CONFIG_FILE 2>&1
    echo "    Firmware Info--------------------------------" >> $CONFIG_FILE 2>&1
}
#搜集PCICard
function collectPCICardInfo()
{
    local netWorkFile="/tmp/net_isnpect_work_fiel"
    local PCICardNum=""
    local NodeID=$(cat /opt/huawei/snas/etc/cm.ini | grep "^NID=" | awk -F'=' '{print $2}')
    local NetIDList=$(lspci |egrep "Ethernet|Mellanox" |awk '{print $1}')
    local NetIDArray=(${NetIDList})
    local PortName=""
    local PortNum=""
    local PortInfo=""
    local TypeNum=""
    local PCINum=""
    local PortType=""
    local Speed=""

    /usr/sbin/hwinfo --network >${netWorkFile}
    PCICardNum=$(grep "Device File" ${netWorkFile} | grep -v "Device File: lo" | wc -l)

    echo "PCICard--------------------------------" >> $CONFIG_FILE 2>&1
    echo "    Number of PCICard:${PCICardNum}" >> $CONFIG_FILE 2>&1
    echo "    PCICard Info--------------------------------" >> $CONFIG_FILE 2>&1
    for NetID in ${NetIDArray[*]}
    do
        PortName=$(grep -B2 -A10 "${NetID}" ${netWorkFile} | grep "Device File:" | awk -F':' '{print $2}' | tr -d ' ' | tr "\n" " ")
        if [ -z "${PortName}" ];then
            continue
        fi
        for OnePortName in ${PortName[*]}
        do
            PortType=""
            PortInfo=$(lspci | grep "${NetID}" | awk -F":" '{print $3}')
            PortNum=$(cat /opt/huawei/snas/etc/snas.ini | grep ${OnePortName} | awk -F= '{print $1}'|awk -F_ '{print $3}')
            TypeNum=$(cat /opt/huawei/snas/etc/snas.ini | grep subnetwork_id_${PortNum} | awk -F= '{print $2}')
            Speed=$(ethtool $OnePortName|grep Speed|awk -F ' ' '{print $2}')
            if [ ! -z "${PortNum}" ] && [ ! -z "${TypeNum}" ];then
                if [ "1" == "${TypeNum}" ];then
                    PortType="BackPort"
                fi
                if [ "2" == "${TypeNum}" ];then
                    PortType="FrontPort"
                fi
            fi
            echo "" >> $CONFIG_FILE 2>&1
            echo "        NodeId  :${NodeID}" >> $CONFIG_FILE 2>&1
            echo "        PortName:${OnePortName}" >> $CONFIG_FILE 2>&1
            echo "        PortInfo:${PortInfo}" >> $CONFIG_FILE 2>&1
            echo "        PortType:${PortType}" >> $CONFIG_FILE 2>&1
            echo "        PCINum  :${NetID}" >> $CONFIG_FILE 2>&1
            echo "        Speed   :${Speed}" >> $CONFIG_FILE 2>&1
        done
    done
    rm -rf ${netWorkFile}
}


function Nodegenralinfo
{
    #node info
    echo "Node--------------------------------" >> $CONFIG_FILE 2>&1
    echo "    Node Info--------------------------------" >> $CONFIG_FILE 2>&1
    NodeID=$(cat /opt/huawei/snas/etc/cm.ini | grep "^NID=" | awk -F'=' '{print $2}')
    NodeName=$(cat /opt/huawei/snas/etc/snas.ini | grep "^Hostname=" | awk -F'=' '{print $2}')
    NodeServiceType=$(cat /opt/huawei/snas/etc/snas.ini | grep "^node_service_type=" | awk -F'=' '{print $2}')
    NodePool=$(cat /opt/huawei/snas/etc/snas.ini | grep "^nodepool=" | awk -F'=' '{print $2}')
    devicetypenumber=$(cat /opt/huawei/deploy/etc/deploy.ini |grep "^devicetype" |awk -F= '{print $2}')
    DeviceType=$(MapNodeType  $devicetypenumber)
    echo "        NodeId         :${NodeID}" >> $CONFIG_FILE 2>&1
    echo "        NodeName       :${NodeName}" >> $CONFIG_FILE 2>&1
    echo "        NodeServiceType:${NodeServiceType}" >> $CONFIG_FILE 2>&1
    echo "        NodePool       :${NodePool}" >> $CONFIG_FILE 2>&1
    echo "        DeviceType     :${DeviceType}" >> $CONFIG_FILE 2>&1

    #SN,ipmitool
    ipmitool fru > /tmp/ipmi_info.txt
    result=`cat /tmp/ipmi_info.txt|sed 's/^ *//g'|sed "/^$/d"| grep -w "Product Name"|awk -F':' '{print $2}'`
    echo "        Product Name   :${result}" >> $CONFIG_FILE 2>&1
    result=`cat /tmp/ipmi_info.txt|sed 's/^ *//g'|sed "/^$/d"| grep -w "Product Serial"|awk -F':' '{print $2}'`
    echo "        Product Serial :${result}" >> $CONFIG_FILE 2>&1

    #memory
    echo "Memory--------------------------------" >> $CONFIG_FILE 2>&1
    echo "    Memory Info--------------------------------" >> $CONFIG_FILE 2>&1
    #MemTotal
    result=`cat /proc/meminfo | grep "MemTotal"`
    echo "        ${result}" >> $CONFIG_FILE 2>&1
    #MemFree
    result=`cat /proc/meminfo | grep "MemFree"`
    echo "        ${result}" >> $CONFIG_FILE 2>&1

    #Version
    echo "Version--------------------------------" >> $CONFIG_FILE 2>&1
    echo "    Version Info--------------------------------" >> $CONFIG_FILE 2>&1
    result=$(ls /var/huawei/patch/cur/sph 2>/dev/null|grep -e "OceanStor*" -e "FusionStorage*" | awk -F'_' '{print $3}')
    echo "        Sph Version:${result}" >> $CONFIG_FILE 2>&1

    rm -rf /tmp/ipmi_info.txt
}

function collectMemInfo()
{
    local isC72=''
    local memResult=''
    local totalMemSize=0
    local bak=$IFS
    local loop='0'
    local tmpSize=''
    local tmpSlot=''
    local tmpSpeed=''
    
    #mem info
    echo "PhysicalMemory--------------------------------" >> $CONFIG_FILE 2>&1

    IsC72Node
    isC72=$?
    
    IFS=$'\n'
    memResult=$(dmidecode -t memory | grep -P "^\s+(Locator:|Size:|Speed:)")
    #三个一组进行分析，排除掉Nvdimm和无效的回显
    for line in `echo "$memResult"`; do
        if [ $loop == '0' ]; then
            tmpSize=$(echo $line |grep "Size:" |awk '{print $2}')
            loop='1'
            continue;
        fi
        
        if [ $loop == '1' ]; then
            tmpSlot=$(echo $line |grep "Locator:" | awk -F":" '{print $2}' | sed 's/Slot//g' | awk '{print $1}')
            loop='2'
            continue;
        fi
        
        if [ $loop == '2' ]; then
            tmpSpeed=$(echo $line |grep "Speed:" |awk '{print $2}')
            loop='0'
        fi
        
        if [ "${tmpSpeed}X" != "X" ]; then
            if [ "${tmpSize}" == "No" ] || [ "${tmpSlot}" == "" ]; then
                continue
            fi
            if [ "$tmpSlot" == "F0" ] || [ "$tmpSlot" == "DIMM000" -a $isC72 != 1 ]; then
                continue
            fi
            totalMemSize=$(expr $tmpSize + $totalMemSize)
        fi
    done
    IFS=$bak
    echo "    PhysicalMemoryTotalSize:${totalMemSize}MB" >> $CONFIG_FILE 2>&1
}

function collect_local_main
{
    #开始搜集,不管文件是否存在，都先删除一把
    rm -rf $CONFIG_FILE >/dev/null 2>&1
    touch $CONFIG_FILE #创建一个Config.txt文件
    #node info
    Nodegenralinfo
    #PCIcard 网卡
    collectPCICardInfo
    #收集FirmWare
    collectFirmWareInfo
    #收集内存信息
    collectMemInfo
}

collect_local_main
IsT3000Node
if [ $? -eq 0 ] && [ -f "/opt/hardware_firmware/t3000/nvdimm/get_nvdimm_fw_ver_file" ];then
    echo "" > "/opt/hardware_firmware/t3000/nvdimm/get_nvdimm_fw_ver_file"
fi
