#!/bin/bash

CONFIG_SYS_FILE="/var/log/Config_system.txt"
G_MML_PATH="/opt/huawei/snas/script/inspect_mml"
G_TMP_FILE="/tmp/sys_info"
LOG_FILE="/var/log/inspect.log"
collllect_tmp="/tmp/Config_"
CM_DB="/opt/huawei/snas/etc/cm_conf.db"

RepeatTimes=(1 2 3)

IP_ROLE_FILE="/tmp/tmp_ip_role"
NID_ROLE_FILE="/tmp/tmp_nid_role"

function log
{
    echo [`date`][$!]$@ >> $LOG_FILE
}
#分割符，MML命令返回的是以回车符为分隔符
function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}
#map 信息
MapHealthStatus()
{
    case $1 in
    0)
        echo "UNKNOWN"
        ;;
    1)
        echo "NORMAL"
        ;;
    2)
        echo "FAULT"
        ;;
    3)
        echo "PRE_FAIL"
        ;;
    4)
        echo "PART_BROKEN"
        ;;
    5)
        echo "DEGRADE"
        ;;
    6)
        echo "HAS_BAD_BLOCK"
        ;;
    7)
        echo "HAS_ERROR_CODE"
        ;;
    8)
        echo "CONSISTENT"
        ;;
    9)
        echo "INCONSISTENT"
        ;;
    10)
        echo "BUSY"
        ;;
    11)
        echo "POWER_NO_INPUT"
        ;;
    12)
        echo "POWER_NOT_ENOUGH"
        ;;
    13)
        echo "SINGLE_LINK_FAULT"
        ;;
         *)
        echo "No this type"
        ;;
    esac
}

MapRunningStatus()
{
    case $1 in
    0)
        echo "UNKNOWN"
        ;;
    1)
        echo "NORMAL"
        ;;
    2)
        echo "RUNNING"
        ;;
    3)
        echo "NOT_RUNNING"
        ;;
    4)
        echo "NOT_EXIST"
        ;;
    5)
        echo "HIGH_TEMPERATURE_SLEEP"
        ;;
    6)
        echo "STARTING"
        ;;
    7)
        echo "POWER_FAILURE_PROTECTING"
        ;;
    8)
        echo "SLEEPING"
        ;;
    9)
        echo "SPINGUP"
        ;;
    10)
        echo "LINK_UP"
        ;;
    11)
        echo "LINK_DOWN"
        ;;
    12)
        echo "POWER_ON"
        ;;
    13)
        echo "POWER_OFF"
        ;;
    14)
        echo "PRE_COPY"
        ;;
    15)
        echo "COPYBACK"
        ;;
    16)
        echo "RECONSTRUCTION"
        ;;
    17)
        echo "EXPANSION"
        ;;
    18)
        echo "NOT_FORMAT"
        ;;
    19)
        echo "FORMATTING"
        ;;
    20)
        echo "UNMAPPING"
        ;;
    21)
        echo "INITIAL_SYNCHRONIZING"
        ;;
    22)
        echo "CONSISTENT"
        ;;
    23)
        echo "SYNCHRONIZING"
        ;;
    24)
        echo "SYNCHRONIZED"
        ;;
    25)
        echo "NOT_SYNCHRONIZED"
        ;;
    26)
        echo "SPLIT"
        ;;
    27)
        echo "ONLINE"
        ;;
    28)
        echo "OFFLINE"
        ;;
    29)
        echo "LOCKED"
        ;;
    30)
        echo "ENABLE"
        ;;
    31)
        echo "DISABLED"
        ;;
    32)
        echo "LEVELING"
        ;;
    33)
        echo "TO_BE_RECOVERD"
        ;;
    34)
        echo "INTERRUPTED"
        ;;
    35)
        echo "INVALID"
        ;;
    36)
        echo "NOSTART"
        ;;
    37)
        echo "QUEUING"
        ;;
    38)
        echo "STOP"
        ;;
    39)
        echo "COPYING"
        ;;
    40)
        echo "COMPLETED"
        ;;
    41)
        echo "PAUSE"
        ;;
    42)
        echo "REVSYNCHRONIZING"
        ;;
    43)
        echo "ACTIVATED"
        ;;
    44)
        echo "ROLLBACK"
        ;;
    45)
        echo "INACTIVATED"
        ;;
    46)
        echo "IDLE"
        ;;
    47)
        echo "POWERING_OFF"
        ;;
    48)
        echo "CHARGING"
        ;;
    49)
        echo "CHARGED"
        ;;
    50)
        echo "DISCHARGING"
        ;;
    51)
        echo "UPGRADING"
        ;;
    *)
        echo "No this type"
        ;;
    esac
}

#远程异步执行，输入ip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid="$2"
    local time_out=$3
    local cmd=$4
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
        local iRet=$?
        log "[$FUNCNAME]:IP:$remote_ip,thread:$!,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#检查远程命令执行是否结束
function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid="$2"
    local err_info=$3
    for time in ${RepeatTimes[*]}; do
        local proresult=`/opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid`
        local iRet=$?
        if [ $iRet -eq 101 -o $iRet -eq 107 ]; then
        log "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time,le_pid:$le_pid"
            sleep 10
        else
            break
        fi
    done

    local process=`echo $proresult | awk '{print $1}'`
    local errno=`echo $proresult | awk '{print $4}'`

    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #查询命令执行成功，但远程命令还没有完成
    elif [ $iRet -ne 0 ];then
        log "[$FUNCNAME]IP:$remote_ip, thread:$!,exec(get progress) failed.iRet($iRet)"
        return 1    #查询命令执行失败
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        log "[$FUNCNAME] IP:$remote_ip,thread:$!, exec(get progress) success.iRet($iRet),errno($errno),process($process)"
        return 2    #命令成功完成，此处要求命令以0作为成功返回
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        log "[$FUNCNAME]IP:$remote_ip, thread:$!, exec(get progress) failed.iRet($iRet) errno($errno)"
        return 3    #命令在远端执行失败
    elif [ "$process" = "" ] && [ "$errno" = "" ];then
        log "[$FUNCNAME]IP:$remote_ip, thread:$!, exec(get progress) failed.process(null), ip not accessed"
        return 5    #解决重启超时问题
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        log "[$FUNCNAME]IP:$remote_ip, thread:$!, exec(get progress) failed.process(null)"
        return 0    #容错
    else
        log "[$FUNCNAME]IP:$remote_ip, thread:$!, exec(get progress) failed. Undefined error info"
        return 4    #未定义错误
    fi
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
        iRet=$?
        log "[$FUNCNAME] download ($remote_file) from ($remote_ip) to ($local_file) iRet:($iRet) time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
}

#获取本节点第一个后端网络IP
function get_backnet_ip
{
    local subnet_id=`grep 'subnetwork_id_.=1' /opt/huawei/snas/etc/snas.ini |awk -F= '{print $1}'|awk -F_ '{print $3}'|sort -k1|head -n1`
    if [ "$subnet_id" = "" ]; then
        log "[$FUNCNAME]Failed to get back subnet"
    fi

    local IPAddress=`grep ipaddr_${subnet_id} /opt/huawei/snas/etc/snas.ini | awk -F= '{print $2}'`
    if [ "$IPAddress" = "" ]; then
        log "[$FUNCNAME]Failed to get back subnet IP"
    fi

    echo $IPAddress
    return 0
}



function GetDiskInfo_MML()
{
    local DiskNodeID=""
    echo "Disk--------------------------------" >> $CONFIG_SYS_FILE
    BackIP=$MasterCM_BACK_IP
    local tmp=""
    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm diskinfo" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result" >> $CONFIG_SYS_FILE
    else
        dos2unix $G_TMP_FILE >/dev/null 2>&1
        tmp=$(cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" | grep -Po "/tmp/snas_debug[0-9]*")
        if [ "X${tmp}" != "X" ];then
            cat $tmp > $G_TMP_FILE
        fi
        DiskNumber=`cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" |grep Disk_ID|grep -v "Running_Status: 4"| wc -l`
        echo "    Number of disks:$DiskNumber" >> $CONFIG_SYS_FILE
        echo "    DISK Physical Info--------------------------------" >> $CONFIG_SYS_FILE
        cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" |grep Disk_ID|grep -v "Running_Status: 4" |sed 's/^/        /g'>> $CONFIG_SYS_FILE
    fi
}


function GetLicenseInfo_MML()
{
    echo "License information--------------------------------" >> $CONFIG_SYS_FILE
    LicenseSerialNo=`cat /opt/huawei/snas/license/license_active.dat | grep "LicenseSerialNo"`
    echo "    $LicenseSerialNo" >> $CONFIG_SYS_FILE
    BackIP=$MasterCM_BACK_IP

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm licensecfg" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result" >> $CONFIG_SYS_FILE
    else
        set_ifs
        dos2unix $G_TMP_FILE >/dev/null 2>&1
        javaID=`cat $G_TMP_FILE |grep "acFeatureName"|sed 's/^ *//g'|sed "/^$/d"`

        for line in $javaID
        do
            if [ "${line}" = "" ];then
                continue;
            fi

            FeatureID=`echo $line |awk '{print $3}'`
            echo "    FeatureID:$FeatureID" >> $CONFIG_SYS_FILE
            TrialDays=60
            echo "    Trial Days:$TrialDays" >> $CONFIG_SYS_FILE
            Deadline=`echo $line |awk '{print $7}'`
            date1=`expr $Deadline \/ 1000`
            Deadline=`date --date "1970-01-01 UTC $date1 seconds" +"%Y-%m-%d %T %z"`
            echo "    Running Deadline:$Deadline" >> $CONFIG_SYS_FILE
            Number=`echo $line |awk '{print $11}'|sed 's/\./ /g'`
            echo "    Maximal Resource Number:$Number" >> $CONFIG_SYS_FILE
        done
        restore_ifs
    fi
}

function GetSystemGeneral_MML()
{
    BackIP=$MasterCM_BACK_IP

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm system" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result" >> $CONFIG_SYS_FILE 2>&1
    else
        dos2unix $G_TMP_FILE >/dev/null 2>&1
        Version=`cat $G_TMP_FILE|grep "Cluster_Version"|awk -F: '{print $2}'`
        echo "    Cluster_Version:$Version" >> $CONFIG_SYS_FILE
        Health=`cat $G_TMP_FILE|grep "Cluster_Health_Status"|awk -F: '{print $2}'`
        Health=`MapHealthStatus $Health`
        echo "    Cluster_Health_Status:$Health" >> $CONFIG_SYS_FILE
        Running=`cat $G_TMP_FILE|grep "Cluster_Running_Status"|awk -F: '{print $2}'`
        Running=`MapRunningStatus $Running`
        echo "    Cluster_Running_Status:$Running" >> $CONFIG_SYS_FILE
        Capacity=`cat $G_TMP_FILE|grep "Cluster_Capacity"|awk -F: '{print $2}'`
        echo "    Cluster_Capacity(MB):$Capacity" >> $CONFIG_SYS_FILE
        Used=`cat $G_TMP_FILE|grep "Cluster_Used_Capacity"|awk -F: '{print $2}'`
        echo "    Cluster_Used_Capacity(MB):$Used" >> $CONFIG_SYS_FILE
    fi
}

function GetNodeInfo_MML()
{
    local ID=""
    echo "Node--------------------------------" >> $CONFIG_SYS_FILE
    BackIP=$MasterCM_BACK_IP

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm node" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result"
    else
        set_ifs
        dos2unix $G_TMP_FILE >/dev/null 2>&1

        Node=`cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" | grep Node_ID|wc -l`
        echo "    Number of Node:$Node" >> $CONFIG_SYS_FILE
        echo "    Node info--------------------------------" >> $CONFIG_SYS_FILE

        javaID=`cat $G_TMP_FILE |grep "Node_ID"|sed 's/^ *//g'|sed "/^$/d"`
        for line in $javaID
        do
            if [ "${line}" = "" ];then
                continue;
            fi

            Name=`echo $line |awk '{print $5}'`
            echo "        Name:$Name" >> $CONFIG_SYS_FILE
            ID=`echo $line |awk '{print $2}'`
            echo "        ID:${ID}" >> $CONFIG_SYS_FILE
            Fram=`echo $line |awk '{print $14}'`
            echo "        Fram Number:$Fram" >> $CONFIG_SYS_FILE
            Slot=`echo $line |awk '{print $17}'`
            echo "        Slot Number:$Slot" >> $CONFIG_SYS_FILE
            SN=`echo $line |awk '{print $20}'`
            echo "        Device SN :$SN" >> $CONFIG_SYS_FILE
            echo "" >> $CONFIG_SYS_FILE
        done
        restore_ifs
    fi
}

function GetSummaryInfo()
{
    local node_name=""
    echo "SUMMARY--------------------------------" >> $CONFIG_SYS_FILE
    #Name:
    result=`cat /opt/huawei/snas/etc/snas.ini| grep  "cluster_name"`
    echo "    $result" >> $CONFIG_SYS_FILE
    result=`cat /opt/huawei/snas/etc/snas.ini| grep  "cluster_id"`
    echo "    $result" >> $CONFIG_SYS_FILE

    #系统信息
    GetSystemGeneral_MML

    #获取默认冗余配比
    result=`cat /opt/huawei/snas/etc/mons.ini | grep "^DefaultProtection"`
    result=$(echo $result | sed 's/=/:/g')
    echo "    $result" >> $CONFIG_SYS_FILE
    #获取最大冗余配比
    result=`cat /opt/huawei/snas/etc/mons.ini | grep "^MaxProtection"`
    result=$(echo $result | sed 's/=/:/g')
    echo "    $result" >> $CONFIG_SYS_FILE
    result=`cat /opt/huawei/snas/etc/snas.ini| grep -w "^serviceType"`
    echo "    $result" >> $CONFIG_SYS_FILE

}


#===================================================
# 函数名称：获取cm_conf.db中节点对应的节点名
# 函数功能：通过节点的后端IP，从数据库中取出节点名称
# 描述：
#===================================================
function get_node_hostname_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do
        sleep 1
        log "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 3 ];then
            temp=1
            break
        fi
    done
    temp=1
    local hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${hostname}" == "" ]]
    do
        sleep 1
        log "[$FUNCNAME]Failed to get node hostname from db ,temp=$temp"
        hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 3 ];then
            temp=1
            break
        fi
    done

    echo ${hostname}
}

#===================================================
# 函数名称：collect_node_infomation
# 函数功能：搜集集群中各个节点的设备档案信息
# 描述：
#===================================================
function collect_node_infomation()
{
    #集群信息搜集完以后，下发给各个节点开始搜集,tmp_ip_role中含有集群节点的后端IP（在执行巡检开始的时候inspect_entry就会去检验集群中的IP，这里没必要再去获取和检验一次）
    local TASK_ID="inspectcollect"
    VALID_IP_FILE="/tmp/tmp_valid_ip_collect"
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    log "start get node information IP_ROLE_FILE=$REMOTE_IP_S "
    >${VALID_IP_FILE}

    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $TASK_ID 120 "/opt/huawei/snas/script/inspect_mml/CheckItems inspect_collect_nodeinfo"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            log "node information collect fail iRet=$iRet"
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    sleep 1
    ValidIP=`cat ${VALID_IP_FILE}`
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        local hava_sata=""
        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get config information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                log "checkini failed"
                continue
            fi

            #主节点下载至本地
            remote_download $Item $collllect_tmp$Item /var/log/Config.txt
            iRet=$?
            if [ $iRet -ne 0 ];then
                log "download collect fail Item=$Item"
                continue
            fi

            nodeName=$(get_node_hostname_from_db "${Item}")
            mv $collllect_tmp$Item $tmpcollectdir/"Config_""$nodeName".txt > /dev/null 2>&1
        done
        ValidIP=$(cat $VALID_IP_FILE)
    done
    [ -f "${VALID_IP_FILE}" ] && rm -f "${VALID_IP_FILE}"
}

function collect_main()
{
    log "start get config info###############"
    touch $CONFIG_SYS_FILE #创建一个Config_system.txt文件,存放集群信息

    #配置文件说明
    nowtime=`date "+%Y-%m-%d %H:%M:%S"`
    echo "PROFILE FOR MASSIVE STORAGE($nowtime)" > $CONFIG_SYS_FILE

    #集群总体信息
    GetSummaryInfo

    #集群节点信息
    GetNodeInfo_MML

    #License信息
    GetLicenseInfo_MML

    #硬盘信息
    GetDiskInfo_MML

    mv $CONFIG_SYS_FILE  $tmpcollectdir > /dev/null 2>&1
    [ -f "/var/log/CCDB_DB_version.log" ] && cp /var/log/CCDB_DB_version.log $tmpcollectdir > /dev/null 2>&1

    #远程收集各个节点的信息
    collect_node_infomation

}

log "start collect config infomation"
#创建目录
tmpcollectdir="/var/log/inspect_collect/"
rm -rf $tmpcollectdir > /dev/null 2>&1
mkdir -p "$tmpcollectdir"

#搜集入口脚本,先拿一个本地后端IP（CM主），后面MML命令会使用到
MasterCM_BACK_IP=`get_backnet_ip`
if [ "${MasterCM_BACK_IP}X" == "X" ];then
    log "MasterCM_BACK_IP is null ,get it again"
    MasterCM_BACK_IP=`get_backnet_ip`
fi
collect_main

#压缩
cd $tmpcollectdir
zip -qr "Config.zip" ./* >/dev/null 2>&1
chown omuser:group9000 -R $tmpcollectdir >/dev/null 2>&1

#删除临时文件
rm *.txt >/dev/null 2>&1
rm -f $G_TMP_FILE >/dev/null 2>&1
[ -f "${IP_ROLE_FILE}" ] && rm -f "${IP_ROLE_FILE}"
[ -f "${NID_ROLE_FILE}" ] && rm -f "${NID_ROLE_FILE}"

log "end get config info"
exit 0



