#!/bin/bash

# ********************************************** ***************************** #
# File Name: inspect.sh
# Description: Ѳ칤.
# Input:
# Output:
# Author:
# Created:
# Function:
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #

LOG_FILE="/var/log/inspect.log"

function LOG
{
    echo [`date`][$$][$!]$@ >> $LOG_FILE
}

G_SCRIPT_PATH=""
L_TMP=$0
TMP_G_SCRIPT_PATH=$1
CHECK_ID=$3
G_SCRIPT_PATH=$(dirname "$0")


function execWithTimeout()
{
    #timeout error code
    local err_timeout=125
    #command to be executed
    local command=$1
    #timeout for executing
    local timeout=$2
    #checking interval
    local interval=$3
    #delay for kill -SIGKILL
    local delay=$4
    #execute command
    eval "${command} &"
    sub_pid=$!
    #check sub-process
    local t=$timeout
    while ((t > 0)); do
        kill -0 $sub_pid 2>/dev/null
        if [ $? -ne 0 ]; then
            #get exit code of sub-process
            wait $sub_pid
            return $?
        fi
        ((t -= interval))
        sleep $interval
    done
    #kill sub-process
    kill -15 $sub_pid 2>/dev/null && kill -0 $sub_pid 2>/dev/null || return $err_timeout
    sleep $delay
    kill -0 $sub_pid 2>/dev/null && kill -9 $sub_pid 2>/dev/null
    return $err_timeout
}


function tryagain()
{
    checkfunc=$1
    checkid=$2
    command="$checkfunc $checkid"

    echo "[`date`][$command]:again" >> /tmp/inspect_tmp_bak
    WRITE_XML_HEADER >/dev/null
    execWithTimeout "$command" 600 2 2 2>/dev/null
    rc=$?
    WRITE_XML_TAIL $checkid >/dev/null
    if [ "$rc" -eq 125 ];then
        WRITE_XML_HEADER >/dev/null
        WRITE_XML_CMD_HEADER $checkid >/dev/null
        WRITE_XML_SUBCMD_HEADER 0
        WRITE_XML_ERROR 0 "The item is over time and The result might not complete,Please check again!" >/dev/null
        WRITE_XML_JUDGE 1 >/dev/null
        WRITE_XML_SUBCMD_TAIL >/dev/null
        WRITE_XML_CMD_TAIL >/dev/null
        WRITE_XML_TAIL $checkid >/dev/null
    fi

}


function execOneCheck()
{
    . $G_SCRIPT_PATH/inspect_lib.sh

    checkfunc=$1
    checkid=$2
    command="$checkfunc $checkid"
    if [ "$command" != "" ];then
        InspectBeginTime=$(date +%s)
        WRITE_XML_HEADER >/dev/null
        execWithTimeout "$command" 1000 2 2 2>/dev/null
        rc1=$?
        grep -q "<judge>1<\/judge>" "$G_CHECK_RESULT_FILE"
        rc2=$?
        WRITE_XML_TAIL $checkid >/dev/null
        InspectEndTime=$(date +%s)
        difftime=$(($InspectEndTime - $InspectBeginTime))
        if [ "$rc1" -eq 125 ];then
            WRITE_XML_HEADER >/dev/null
            WRITE_XML_CMD_HEADER $checkid >/dev/null
            WRITE_XML_SUBCMD_HEADER 0
            WRITE_XML_ERROR 0 "The item is over time and The result might not complete,Please check again!" >/dev/null
            WRITE_XML_JUDGE 1 >/dev/null
            WRITE_XML_SUBCMD_TAIL >/dev/null
            WRITE_XML_CMD_TAIL >/dev/null
            WRITE_XML_TAIL $checkid >/dev/null
        elif [ "$rc2" -eq 0 ] && [ $difftime -lt 250 ];then
            tryagain $checkfunc $checkid
        fi
    fi
}

function GetIDparts()
{
    hardtaskids=`cat inspect_hardware.sh |grep "1[0-9][0-9])"|awk -F\) '{print $1}'|tr -d " "`
    softtaskids=`cat inspect_software.sh |grep "2[0-9][0-9])"|awk -F\) '{print $1}'|tr -d " "`
    alltasks=($hardtaskids $softtaskids)
    allcounts=${#alltasks[*]}

    #Ѳз顣25Ϊһ
    loop=`expr $allcounts % 25`
    parts=`expr $allcounts / 25`

    if [ $loop -eq 0 ];then
        Maxparts=$parts
    else
        Maxparts=$((parts+1))
    fi

    for((count=0;count<$Maxparts;count++))
    do
        step=$((count*25))
        part=${alltasks[@]:$step:25}
        for item in $part
        do
            if [ $1 -eq $item ];then
                alltaskids=$part
                return 0
            fi
        done
    done
    alltaskids=$1
    return 0
}

function entry_main()
{
    #ɾʱļ
    rm -f /tmp/tmpfile* > /dev/null 2>&1
    rm -f $G_SCRIPT_PATH/check_thread_file* > /dev/null 2>&1
    cp -f $TMP_G_SCRIPT_PATH/inspect.sh $G_SCRIPT_PATH/
    cp -f $TMP_G_SCRIPT_PATH/inspect_expand.sh $G_SCRIPT_PATH/
    cp -f $TMP_G_SCRIPT_PATH/expand_config.conf $G_SCRIPT_PATH/

    chmod 550 $G_SCRIPT_PATH/inspect.sh
    chmod 550 $G_SCRIPT_PATH/inspect_expand.sh
    chmod 640 $G_SCRIPT_PATH/expand_config.conf

    dos2unix $G_SCRIPT_PATH/inspect_lib.sh > /dev/null 2>&1
    dos2unix $G_SCRIPT_PATH/inspect_hardware.sh > /dev/null 2>&1
    dos2unix $G_SCRIPT_PATH/inspect_software.sh > /dev/null 2>&1
    dos2unix $G_SCRIPT_PATH/inspect_map.sh > /dev/null 2>&1

    . $G_SCRIPT_PATH/inspect_lib.sh

    cd $G_SCRIPT_PATH 1>/dev/null

    echo "[`date`][$CHECK_ID]" >> /tmp/inspect_tmp_bak

    rm -rf "$G_CHECK_RESULT_FILE"

    if [ "$CHECK_ID" != "" ]; then
        IsExist=$(ls $G_SCRIPT_PATH/inspect_expand.sh)
        if [ "${IsExist}""X" = "X" ]; then
            WRITE_XML_HEADER >/dev/null
            WRITE_XML_CMD_HEADER $checkid >/dev/null
            WRITE_XML_SUBCMD_HEADER 0
            WRITE_XML_ERROR 0 "Can not find the expand script!"
            WRITE_XML_JUDGE 1
            WRITE_XML_SUBCMD_TAIL
            WRITE_XML_CMD_TAIL
            WRITE_XML_TAIL $CHECK_ID >/dev/null
        else
            dos2unix $G_SCRIPT_PATH/inspect_expand.sh > /dev/null 2>&1
            . $G_SCRIPT_PATH/inspect_expand.sh
            isExpandSupported $CHECK_ID
            if [ $? -eq 0 ]; then
                execOneCheck "checkExpandItemStatus" $CHECK_ID
            else
                taskpart=`expr $CHECK_ID / 10`
                if [ $CHECK_ID -eq 119 ]; then
                    alltaskids="119 199 205 206 207 215 218 225 226 231 238 257 258 262 263 287 "
                elif [ $CHECK_ID -eq 103 ]; then
                    alltaskids="103 100 114 115 118 119 127 199 204 206 213 215 218 222 225 226 228 230 231 237 240 252 286 "
                else
                    GetIDparts $CHECK_ID
                fi

                . $G_SCRIPT_PATH/inspect_software.sh
                entrynodecnt=0
                entrynodes=`cat /tmp/tmp_ip_role`
                for Item in $entrynodes; do
                    entrynodecnt=$((entrynodecnt+1))
                done

                if [ $entrynodecnt -le 12 ]; then
                    maxthreadcount=12
                elif [ $entrynodecnt -le 24 ];then
                    maxthreadcount=10
                elif [ $entrynodecnt -le 36 ]; then
                    maxthreadcount=8
                else
                    maxthreadcount=5
                fi
                taskinterval=3
                taskcount=0
                alltaskids="157 270 $alltaskids"
		allneedCheckSofeWareEx="157 270 273 274 275 293 294 295 296 297 298 299"
                IsCheckSoftWareEx=0
                threadcount=0
                for taskid in $alltaskids
                do
                    local IsCheckSoftWareItemEx=0
                    threadcount=$(ls /opt/inspect |grep "check_thread_file"|wc -l)
                    LOG "[$FUNCNAME] the counts of task is taskid=$taskid ,threadcount=$threadcount"
                    while [ $threadcount -gt $maxthreadcount ]
                    do
                        threadcount=$(ls /opt/inspect |grep "check_thread_file"|wc -l)
                        LOG "[$FUNCNAME]wait: threadcount=$threadcount,taskid=$taskid,"
                        sleep 3
                    done

		    echo "${allneedCheckSofeWareEx}" |grep "${taskid}"
                    if [ $? -eq 0 ];then
                        IsCheckSoftWareItemEx=1
                    fi
                    if [ $taskid -eq 270 ] && [ $IsCheckSoftWareEx -eq 0 ];then
                       checkSoftwareStatusEx
                       IsCheckSoftWareEx=1
                       continue
                    fi
		    #¿ܵIDҪ checkSoftwareStatusExѾ
                    if [ ${IsCheckSoftWareItemEx} -eq 1 -a ${IsCheckSoftWareEx} -eq 1 ];then
                        LOG "[$FUNCNAME] taskid=$taskid already check."
                        continue
                    fi
                    {
                        case $taskid in
                        1*)
                        . $G_SCRIPT_PATH/inspect_hardware.sh
                        execOneCheck "checkHardwareStatus" $taskid
                        ;;
                        2*|3*|4*|5*)
                        . $G_SCRIPT_PATH/inspect_software.sh
                        execOneCheck "checkSoftwareStatus" $taskid
                        ;;
                        *)
                        ;;
                        esac
                    }&
                sleep $taskinterval
                done
                wait
            fi
        fi
    fi
    #ɾһЩʱļЩļѲԽԽ
    rm -f /opt/inspect/tmpfile* > /dev/null 2>&1
    rm -f /tmp/tmp_valid_ip* > /dev/null 2>&1
    LOG "********delete inspect tmpfiles iRet=$?  ********"


    cd - 1>/dev/null
}

checkfile="/opt/inspect/check_id_file$CHECK_ID"
needcheck=1

if [ -f "$checkfile" ];then
    curttime="`date +%s`"
    filedate="`stat $checkfile | grep -i Modify |grep -i Modify | awk -F. '{print $1}' | awk '{print $2" "$3}'`"
    filetime="`date -d "$filedate" +%s`"
    passtime=`expr $curttime - $filetime`
    if [ $passtime -le 2000 ];then
        needcheck=0
    fi
fi

if [ -f "$G_SCRIPT_PATH/inspect_expand.sh" ];then
    . $G_SCRIPT_PATH/inspect_expand.sh
    isExpandSupported $CHECK_ID
    if [ $? -eq 0 ]; then
        needcheck=1
    fi
fi
if [ $needcheck -eq 1 ];then
    entry_main
fi

cat $checkfile
rm -rf $checkfile

exit 0

