#!/bin/bash

MapHealthStatus()
{
    case $1 in
        0)
            echo "UNKNOWN"
            ;;
        1)
            echo "NORMAL"
            ;;
        2)
            echo "FAULT"
            ;;
        3)
            echo "PRE_FAIL"
            ;;
        4)
            echo "PART_BROKEN"
            ;;
        5)
            echo "DEGRADE"
            ;;
        6)
            echo "HAS_BAD_BLOCK"
            ;;
        7)
            echo "HAS_ERROR_CODE"
            ;;
        8)
            echo "CONSISTENT"
            ;;
        9)
            echo "INCONSISTENT"
            ;;
        10)
            echo "BUSY"
            ;;
        11)
            echo "POWER_NO_INPUT"
            ;;
        12)
            echo "POWER_NOT_ENOUGH"
            ;;
        13)
            echo "SINGLE_LINK_FAULT"
            ;;
         *)
            echo "No this type"
            ;;
    esac
}

MapRunningStatus()
{
    case $1 in
        0)
            echo "UNKNOWN"
            ;;
        1)
            echo "NORMAL"
            ;;
        2)
            echo "RUNNING"
            ;;
        3)
            echo "NOT_RUNNING"
            ;;
        4)
            echo "NOT_EXIST"
            ;;
        5)
            echo "HIGH_TEMPERATURE_SLEEP"
            ;;
        6)
            echo "STARTING"
            ;;
        7)
            echo "POWER_FAILURE_PROTECTING"
            ;;
        8)
            echo "SLEEPING"
            ;;
        9)
            echo "SPINGUP"
            ;;
        10)
            echo "LINK_UP"
            ;;
        11)
            echo "LINK_DOWN"
            ;;
        12)
            echo "POWER_ON"
            ;;
        13)
            echo "POWER_OFF"
            ;;
        14)
            echo "PRE_COPY"
            ;;
        15)
            echo "COPYBACK"
            ;;
        16)
            echo "RECONSTRUCTION"
            ;;
        17)
            echo "EXPANSION"
            ;;
        18)
            echo "NOT_FORMAT"
            ;;
        19)
            echo "FORMATTING"
            ;;
        20)
            echo "UNMAPPING"
            ;;
        21)
            echo "INITIAL_SYNCHRONIZING"
            ;;
        22)
            echo "CONSISTENT"
            ;;
        23)
            echo "SYNCHRONIZING"
            ;;
        24)
            echo "SYNCHRONIZED"
            ;;
        25)
            echo "NOT_SYNCHRONIZED"
            ;;
        26)
            echo "SPLIT"
            ;;
        27)
            echo "ONLINE"
            ;;
        28)
            echo "OFFLINE"
            ;;
        29)
            echo "LOCKED"
            ;;
        30)
            echo "ENABLE"
            ;;
        31)
            echo "DISABLED"
            ;;
        32)
            echo "LEVELING"
            ;;
        33)
            echo "TO_BE_RECOVERD"
            ;;
        34)
            echo "INTERRUPTED"
            ;;
        35)
            echo "INVALID"
            ;;
        36)
            echo "NOSTART"
            ;;
        37)
            echo "QUEUING"
            ;;
        38)
            echo "STOP"
            ;;
        39)
            echo "COPYING"
            ;;
        40)
            echo "COMPLETED"
            ;;
        41)
            echo "PAUSE"
            ;;
        42)
            echo "REVSYNCHRONIZING"
            ;;
        43)
            echo "ACTIVATED"
            ;;
        44)
            echo "ROLLBACK"
            ;;
        45)
            echo "INACTIVATED"
            ;;
        46)
            echo "IDLE"
            ;;
        47)
            echo "POWERING_OFF"
            ;;
        48)
            echo "CHARGING"
            ;;
        49)
            echo "CHARGED"
            ;;
        50)
            echo "DISCHARGING"
            ;;
        51)
            echo "UPGRADING"
            ;;
        55)
            echo "ONLINE_DISABLED"
            ;;
        56)
            echo "OFFLINE_DISABLED"
            ;;
        57)
            echo "ONLINE_FROZEN"
            ;;
        58)
            echo "OFFLINE_FROZEN"
            ;;
        59)
            echo "SHUTDOWN"
            ;;
        98)
            echo "LOADING"
            ;;
        99)
            echo "INSTALLING"
            ;;
        *)
            echo "No this type"
            ;;
    esac
}

MapDeviceType()
{
    case $1 in
        33)
            echo "P25 Node"
            ;;
        34)
            echo "P36|C36 Node"
            ;;
        65)
            echo "P12 Node"
            ;;
        74)
            echo "C72 Node"
            ;;

        *)
            echo "No this node type"
            ;;
    esac
}

MapNodeType()
{
	case $1 in
		0)
			echo "P Node"
			;;
		1)
			echo "C Node"
			;;
		2)
			echo "B Node"
			;;
		3)
			echo "M Node"
			;;
		4)
			echo "C72 Node"
			;;
		5)
			echo "P25 Node"
			;;
		6)
			echo "P36 Node"
			;;
		7)
			echo "C36 Node"
			;;
		8)
			echo "P12 Node"
			;;
		12)
		    echo "P12E Node"
		    	;;
		13)
		    echo "P25E Node"
		  	;;
		14)
		    echo "P36E Node"
            		;;
        	15)
		    echo "C36E Node"
           		 ;;
		*)
		echo "No this node type"
			;;
	esac
}

MapDiskType()
{
    case $1 in
        0)
            echo "FC"
            ;;
        1)
            echo "SAS"
            ;;
        2)
            echo "SATA"
            ;;
        3)
            echo "SSD"
            ;;
        4)
            echo "NL_SAS"
            ;;
        5)
            echo "SLC_SSD"
            ;;
        6)
            echo "MLC_SSD"
            ;;
        *)
            echo "No this type"
            ;;
    esac
}

MapPowerType()
{
    case $1 in
        0)
            echo "DC"
            ;;
        1)
            echo "AC"
            ;;
        *)
            echo "No this type"
            ;;
    esac
}
BusModeStatus()
{
    case $1 in
	0)
	    echo  "IDE"
		;;
	1)
	    echo  "VIRTIO"
		;;
	*)
        echo "No this type"
       ;;
	esac
}
StatModeStatus()
{
	case $1 in
	0)
            echo "HD"
		;;

	1)
	    echo "CD"
		 ;;
	*)
        echo "No this type"
         ;;
	esac

}

###addѲӳ
GetInspectType()
{
    case $1 in 
    157)
        #ڵӱǩ
        echo "CheckElecLabel"
        ;;
    270)
        echo "CheckNodeState"
        ;;
    273) 
        echo "CheckBalanceStatus"
        ;;
    274) 
        echo "CheckCertificate"
        ;;
    275) 
        echo "CheckDataMoveEnd"
        ;;
    293)
        echo "checkDiskNokickStatus"
        ;;
    294)
        echo "CheckCronProcessCount"
        ;;
    295)
        echo "checklldpad"
        ;;
    296)
        echo "checkKernelHotPatch"   
        ;;
    297)
        echo "CheckBirthTime"
        ;;
    298)
        echo "CheckFluidControl"
        ;;
    299)
        echo "CheckDlmStatus"
        ;;
    *)
        echo ""
        ;;
	esac
}
