#!/bin/bash

# ********************************************** ***************************** #
# File Name: inspect_software.sh
# Description: ѲĿе״̬.
# Input:
# Output:
# Author:
# Created: 2013-01-16
# Function List
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #

dos2unix $G_SCRIPT_PATH/inspect_lib.sh > /dev/null 2>&1
dos2unix $G_SCRIPT_PATH/inspect_map.sh > /dev/null 2>&1

. $G_SCRIPT_PATH/inspect_lib.sh
. $G_SCRIPT_PATH/inspect_map.sh

G_TMP_FILE="$G_SCRIPT_PATH/tmpfile$!"
G_REMOTE_TMP_FILE="/tmp/tmpfile$!"
G_TMP_FILE2="$G_SCRIPT_PATH/tmpfilex$!"
G_REMOTE_TMP_FILE2="/tmp/tmpfilex$!"


IP_ROLE_FILE="/tmp/tmp_ip_role"


G_LINE_FILE="/tmp/lines.txt"
G_TOTALCAP_FILE="/tmp/totalcap.txt"
G_FREECAP_FILE="/tmp/freecap.txt"
G_INFO_FILE="/tmp/dsinfo.txt"
G_NODEPOOL_FILE="/tmp/dsnodepoolinfo.txt"
G_NODEPOOLTMP_FILE="/tmp/dsnodepoolinfoTMP.txt"

G_UNKNOWN_PROTO="Unknown protocol type"
G_CMD_FAILED="Execute command failed!"
LOG_FILE="/var/log/inspect.log"
LOG_FILE_BAK="/var/log/inspect_1.log"

VALID_IP_FILE="/tmp/tmp_valid_ip$!"
VALID_IP_FILE2="/tmp/tmp_valid_ip2"
VALID_IP_FILE3="/tmp/tmp_valid_ip3"

G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"
CM_DB="/opt/huawei/snas/etc/cm_conf.db"
RepeatTimes=(1 2 3)

FIFO_OPERATE_ID=759
FIFO_THREAD_NUM_MAX=60

G_SEPARATOR="-----------------------------------------------------------------------------"

RPC_REFER_PROC_FILE="/proc/sys/internalrpc/rpc_req_leak"
RPC_REFER_CNT_KEY="The leaked requests are found"

G_GET_REPLICATION_INFO="/opt/huawei/snas/script/inspect_mml/GetReplicationInfo"

###add 2016-09-12 Ѳ¿ܣѲ270-275#################
G_REMOTE_EXEX_RESULT="/tmp/tmpfileRemoteResult"
G_LOCAL_EXEX_RESULT="/tmp/tmpfileLocalResult"
G_DOWNLOAD_FILE="/tmp/inspect_downloadfile"
G_MML_INSPECT_HEAD=$G_MMLEX_FILE_PATH"/inspect_head"
G_MML_INSPECT=$G_MMLEX_FILE_PATH"/inspect"
###end add#

function LOG_Check
{
    if [ ! -f $LOG_FILE ]; then
        touch $LOG_FILE
        if [ $? -ne 0 ]; then
            echo "Create log file $LOG_FILE failed."
            return
        fi
    fi

    # delete log file bigger than 10M
    FILE_SIZE=`ls -l $LOG_FILE | cut -d' ' -f 5`
    if [ ! -z "$FILE_SIZE" ]; then
        # delete file when file bigger than 10M
        if [ $FILE_SIZE -gt 10485760 ]; then
            mv $LOG_FILE $LOG_FILE_BAK 2>&1
        fi
    fi
}

function LOG
{
   time=$(date)
   echo [${time}][$!]$@ >> $LOG_FILE
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

#ʹfifoܵ, ʵֶ̲, Ҫ׼ VALID_IP_FILE
function fifo_start
{
    trap "exec $FIFO_OPERATE_ID>&-;exec $FIFO_OPERATE_ID<&-;exit 0" 2

    mkfifo remoteFifo
    eval "exec $FIFO_OPERATE_ID<>remoteFifo"
    rm -rf remoteFifo

    local num=0
    for Item in $VALID_IP_FILE; do
        num=$((num+1))
    done

    local threadNum=$FIFO_THREAD_NUM_MAX
    if [ $threadNum -gt $num ]; then
        threadNum=$num
    fi

    for ((i=0;i<$threadNum;i++))
    do
        eval "echo >& $FIFO_OPERATE_ID"
    done
}

function fifo_finish
{
    eval "exec $FIFO_OPERATE_ID>&-"
    eval "exec $FIFO_OPERATE_ID<&-"
}

function get_nlunmap()
{
    local result_log=/var/log/nluninfo.log
    #ȡIP
    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        errResult="INFO: Can't get local ip"
        LOG "[$FUNCNAME]:$errResult"
        WRITE_XML_ERROR 0 "INFO:Failed to get local ip."
        return 1
    fi

    nlunready=0
    #ڵǷ񶼼뵽nlunmapУ15sһΣ4ΣҲ1ӡѲ칤ÿȴ5
    waitcount=0
    while [ $waitcount -lt 4 ]
    do
        #Ƚ/var/log/nluninfo.log
        >${result_log}

         $G_MML_FILE_PATH/ShowInspectMml $back_ip 988 "monc nluninfo 0"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
         iRet=$?
         if [ $iRet -ne 0 ]; then
             Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
             LOG "[$FUNCNAME]mml_result:$Info"
             WRITE_XML_COMMON 0 "INFO:Failed to execute command(monc nluninfo 0)."
             nlunready=0
             break
         fi

        #ȡеnodepoolǷÿnodepoolеĽڵ㶼nlun(ֻҪһnodepoolеĽڵnlunУnodepoolеĽڵ㶼nlun)
        allNodePool=`cat /proc/monc_tiermap | grep "nodepool id" | awk -F: '{print $2}'`
        for tmpNodePool in $allNodePool
        do
            nlunready=0
            frontIpInPool=`cat /proc/monc_tiermap | grep -A16 "nodepool id :$tmpNodePool" | grep "node :" | sed 's/node : *//'`
        if [ "$frontIpInPool" = "" ];then
            LOG "[$FUNCNAME]:nodepool:$tmpNodePool no node."
        nlunready=1
        fi
            allBackIp=""
            allDsId=""
            #nodepoolǰipdsmapǺipҪǰipҶӦĺipٸݺipdsid
            for tmpfront in $frontIpInPool
            do
                tmpBackIp=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=(select NID from CM_NODE_IP_T where IP_ADDR=\"$tmpfront\") and SUBNET_ID=1"`
                allBackIp=${allBackIp}" "${tmpBackIp}
                for tmpip in $tmpBackIp
                do
                    dsIdQuery=`cat /proc/monc_dsmap | grep "$tmpip" | awk '{print $2}'`
                    allDsId=${allDsId}" $dsIdQuery"
                done
            done

            for dsid in $allDsId
            do
                grep "($dsid" ${result_log} > /dev/null
                if [ $? -eq 0 ];then
                    LOG "[$FUNCNAME]:ds $allDsId is in nlunmap"
                    nlunready=1
                    break
                fi
            done
            #ǰnodepoolеĽڵ㶼mapУΪmapҪ
            if [ $nlunready -ne 1 ];then
                LOG "[$FUNCNAME]:ds $allDsId is not in nlunmap"
                break
            fi
        done

        #nodepoolдpoolнڵ㶼ûnlunУ˵nlunûãȴһʱ
        if [ $nlunready -ne 1 ];then
            sleep 15
            let "waitcount=$waitcount+1"
        else
            break;
        fi
    done

    #nlun״̬ǲǳɹ˵βѯʧˣ󷵻ʧܼ
    if [ $nlunready -ne 1 ];then
        WRITE_XML_ERROR 0 "nodes $allBackIp have no nlunmap."
        return 0
    else
        return 1
    fi
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
    /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#ԶִǷ
function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid="$!$2"
    local err_info=$3

    for time in ${RepeatTimes[*]}; do
    local proresult=`/opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid`
    local iRet=$?
        if [ $iRet -eq 101 ]; then
        LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time,thread:$!"
            sleep 10
        else
            break
        fi
    done
    local process=`echo $proresult | awk '{print $1}'`
    local errno=`echo $proresult | awk '{print $4}'`

    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #ѯִгɹԶû
    elif [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME] IP:$remote_ip, thread:$!,exec(get progress) failed.iRet($iRet)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to get command result."
        return 1    #ѯִʧ
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        LOG "[$FUNCNAME] IP:$remote_ip,thread:$!, exec(get progress) success.iRet($iRet),errno($errno),process($process)"
        return 2    #ɹɣ˴Ҫ0Ϊɹ
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        LOG "[$FUNCNAME] IP:$remote_ip, thread:$!,exec(get progress) failed.iRet($iRet) errno($errno)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 3    #Զִʧ
    elif [ "$process" = "" ] && [ "$errno" = "" ];then
        LOG "[$FUNCNAME]IP:$remote_ip, thread:$!, exec(get progress) failed.process(null), ip not accessed"
        return 5    #ʱ
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        LOG "[$FUNCNAME] IP:$remote_ip, thread:$!,exec(get progress) failed.process(null)"
        return 0    #ݴ
    else
        LOG "[$FUNCNAME]IP:$remote_ip, thread:$!, exec(get progress) failed. Undefined error info"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 4    #δ
    fi
}

#Զ첽ִУip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid="$!$2"
    local time_out=$3
    local cmd=$4
    for time in ${RepeatTimes[*]}; do
    /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
    local iRet=$?
        LOG "[$FUNCNAME]:IP:$remote_ip,thread:$!,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
    fi
    done
    return $iRet
}

#һѽڵ첽ִУҪ׼ REMOTE_IP_S
function remote_exec_async_batch
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}

    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$3"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command."
            ret=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}
#Զ̵MML
function remote_exec_async_batch_mml
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}
    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$G_MML_FILE_PATH/$3 $Item > $G_REMOTE_TMP_FILE$4 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command."
            ret=1
        else
            cat $G_REMOTE_TMP_FILE$FUNCNAME | sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}

function remote_download_sync
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
        iRet=$?
        LOG "[$FUNCNAME] download ($remote_file) from ($remote_ip) to ($local_file) iRet:($iRet) time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done

    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get execute result."
    fi

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi
    return $iRet
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    eval "read -u $FIFO_OPERATE_ID"
    {
        for time in ${RepeatTimes[*]}; do
            /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
            iRet=$?
            LOG "[$FUNCNAME] download ($remote_file) from ($remote_ip) to ($local_file) iRet:($iRet) time:$time"
            if [ $iRet -eq 101 ]; then
                sleep 10
            else
                break
            fi
        done

        eval "echo >& $FIFO_OPERATE_ID"
    }

    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get execute result."
    fi

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi
    return $iRet
}

#ȡڵһIP
function get_backnet_ip
{
    local subnet_id=`grep 'subnetwork_id_.=1' /opt/huawei/snas/etc/snas.ini |awk -F= '{print $1}'|awk -F_ '{print $3}'|sort -k1|head -n1`
    if [ "$subnet_id" = "" ]; then
        LOG "[$FUNCNAME]Failed to get back subnet"
        return 1
    fi

    local IPAddress=`grep ipaddr_${subnet_id} /opt/huawei/snas/etc/snas.ini | awk -F= '{print $2}'`
    if [ "$IPAddress" = "" ]; then
        LOG "[$FUNCNAME]Failed to get back subnet IP"
        return 1
    fi

    echo $IPAddress
    return 0
}

#ȡȺDFSڵһIP
function get_dfs_backnet_ip
{
    local dfs_nid=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select NID from CM_NODE_T where (Reserved2 = 0 OR Reserved2 = 1)")
    local dfs_ip=$(get_node_backnet_ip "${dfs_nid}")

    echo $dfs_ip
    return 0
}

#Զ˷أ[ERR]ʶ
handle_remote_result()
{
    local line=$1
    echo "$line" |grep "\[ERR\]" > /dev/null
    if [ $? -eq 0 ]; then
        echo "$line" | awk -F] '{print $2}'
        return 1
    fi

    echo "$line"
    return 0
}

#ȡָڵһIP
function get_node_backnet_ip
{
    local nid=$1
    local temp=1
    local iRet=0
    sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID limit 1"
    iRet=$?
    while [[ ${iRet} -ne 0 ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get back subnet IP of $nid from db"
        temp=$((temp + 1))
        if [ $temp -gt 5 ];then
            break
        fi
        sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID limit 1"
        iRet=$?
    done
    return $iRet
}

#############################################################################################

#276. û뼴
accountcheck()
{
    WRITE_XML_SUBCMD_HEADER $1
    local errResult=""

    #Զ첽ִУҪУipVALID_IP_FILE
    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch_mml $TASK_ID 30 accountcheck.sh $FUNCNAME
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            LOG "[$FUNCNAME]:IP:$Item"
            dfsFlag=1

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get Node IO information"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="IP: $Item||Error: exec (ShowNodeIO) failed.iRet($iRet),errno($errno)!||${errResult}"
                LOG "[$FUNCNAME]$Item exec(get Node ioperform progress) failed.iRet($iRet),errno($errno)!"
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            set_ifs
            local nodePass=`grep "Result:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
            while read line;do
				info=`handle_remote_result "$line"`
				if [ "X${nodePass}" != "XPass" ];then
					Result="Node:$Item||Check result:failed||INFO:$info"
					WRITE_XML_COMMON 0 "$Result"
					isPass=1
				else
					Result="Node:$Item||Check result:pass||INFO:pass"
					WRITE_XML_COMMON 0 "$Result"
				fi
	    done < $G_TMP_FILE$Item
            restore_ifs

            WRITE_XML_COMMON 0 "${ret}"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#277. balance
checkbalance()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local TASK_ID="getinfo"
    local isPass=0

    # Ϊ˷ֹbalancemapcatʧܣbalancemapдļУٽмǷݻָ

    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        errResult="INFO: Can't get local ip"
        LOG "[$FUNCNAME]:$errResult"
        isPass=1
        break
    fi

    $G_MML_FILE_PATH/ShowInspectMml $back_ip 4004 "mon balancemap 0"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
    iRet=$?
    if [ $iRet -ne 0 ]; then
       Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
       LOG "[$FUNCNAME]mml_result:mon balancemap 0 exec fail"
       WRITE_XML_COMMON 0 "Failed to execute command(mon balancemap 0)."
       isPass=1
    else
        #mapǷݻָ
        balance_task_num=`cat /var/log/balancemap.log  | egrep "TaskCnt|epoch" | wc -l`
	    if [ "$balance_task_num" -eq 0 ]; then
	           LOG "[$FUNCNAME]the number of balance task in the cluster environment: $balance_task_num"
	           isPass=1
	           Result="faild to get recovermap"
	           WRITE_XML_COMMON 0 "${Result}"
        elif [ "$balance_task_num" -ne 1 ]; then
	           LOG "[$FUNCNAME]the number of balance task in the cluster environment: $balance_task_num"
	           let balance_task_num=$balance_task_num-1
	           isPass=1
	           Result="the number of balance task in the cluster environment: $balance_task_num"
	           WRITE_XML_COMMON 0 ":${Result}"
	else
		let balance_task_num=$balance_task_num-1
		Result="the number of balance task in the cluster environment: $balance_task_num"
		WRITE_XML_COMMON 0 ":${Result}"
        fi
    fi
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#278. ͨԼ
check_gateway()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local TASK_ID="getinfo"
    local isPass=0

    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        errResult="INFO: Can't get local ip"
        LOG "[$FUNCNAME]:$errResult"
        isPass=1
        break
    fi
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch_mml $TASK_ID 120 check_gateway.sh $FUNCNAME
    isPass=$?
    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
        do
            >${VALID_IP_FILE}

            for Item in $ValidIP
            do
                Result=""

                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "Can not get gateway information"
                iRet=$?

                if [ $iRet -eq 0 ];then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                    isPass=1
                    continue
                fi

                remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    isPass=1
                    continue
                fi
            done
            ValidIP=`cat ${VALID_IP_FILE}`
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
                fifoContext=`cat $G_TMP_FILE$Item`
                if [ "$fifoContext" = "" ];then
                    LOG "[$FUNCNAME]:IP:$Item,file is empty!"
                    continue
                fi

                set_ifs
                local nodePass=`grep "Result:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
                while read line; do
                    info=`handle_remote_result "$line"`
                    if [ "X${nodePass}" != "XPass" ];then
                        Result="Node:$Item||Check result:failed||INFO:$info"
                        WRITE_XML_COMMON 0 "$Result"
                        isPass=1
                    else
                        Result="Node:$Item||Check result:pass||INFO:$info"
                        WRITE_XML_COMMON 0 "$Result"
                    fi
                done < $G_TMP_FILE$Item
                restore_ifs
        done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#279. ͰϢڴм״̬
checkbuckinfo()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local TASK_ID="getinfo"
    local isPass=0

    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        errResult="INFO: Can't get local ip"
        LOG "[$FUNCNAME]:$errResult"
        isPass=1
        break
    fi
		HAMIP=`sudo cat /proc/monc_hamap |grep "role(1)"|awk -F "(" '{print $2}'|awk -F ")" '{print $1}'`
		if [ "$HAMIP" != "" ];then
			Item=$HAMIP
			remote_exec_async $Item $TASK_ID 120 "$G_MML_FILE_PATH/checkbuckinfo.sh $Item > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
			iRet=$?
			if [ $iRet -ne 0 ]; then
				LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
				WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command."
				isPass=1
			else
				cat $G_REMOTE_TMP_FILE$FUNCNAME | sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
			fi
			LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$Item"
			Result=""

			#Ϊ100%֮ļأн
			remote_exec_checkfini $Item $TASK_ID "Can not get buckinfo information"
			iRet=$?
			if [ $iRet -ne 0 ] && [ $iRet -ne 2 ] && [ $iRet -ne 5 ];then
				isPass=1
			fi
			remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
			iRet=$?
			if [ $iRet -ne 0 ]; then
				isPass=1
			fi
			wait
			fifoContext=`cat $G_TMP_FILE$Item`
			if [ "$fifoContext" = "" ];then
				LOG "[$FUNCNAME]:IP:$Item,file is empty!"
			fi

			set_ifs
			local nodePass=`grep "Result:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
			while read line; do
				info=`handle_remote_result "$line"`
				if [ "X${nodePass}" != "XPass" ];then
					Result="Node:$Item||Check result:failed||INFO:$info"
					WRITE_XML_COMMON 0 "$Result"
					isPass=1
				else
					Result="Node:$Item||Check result:pass||INFO:$info"
					WRITE_XML_COMMON 0 "$Result"
				fi
			done < $G_TMP_FILE$Item
			restore_ifs
		else
			Result="Check result:pass||INFO:none-HA and standby-HA nodes do not need to inspect"
			WRITE_XML_COMMON 0 "$Result"
		fi
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#280. DNSregion
checkdomainname()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local TASK_ID="getinfo"
    local isPass=0

    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        errResult="INFO: Can't get local ip"
        LOG "[$FUNCNAME]:$errResult"
        isPass=1
        break
    fi
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch_mml $TASK_ID 120 checkdomainname.sh $FUNCNAME
    isPass=$?
    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
        do
            >${VALID_IP_FILE}

            for Item in $ValidIP
            do
                Result=""

                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "Can not get domainname information"
                iRet=$?

                if [ $iRet -eq 0 ];then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                    isPass=1
                    continue
                fi

                remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    isPass=1
                    continue
                fi
            done
            ValidIP=`cat ${VALID_IP_FILE}`
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
                fifoContext=`cat $G_TMP_FILE$Item`
                if [ "$fifoContext" = "" ];then
                    LOG "[$FUNCNAME]:IP:$Item,file is empty!"
                    continue
                fi

                set_ifs
                local nodePass=`grep "Result:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
                while read line; do
                    info=`handle_remote_result "$line"`
                    if [ "X${nodePass}" != "XPass" ];then
                        Result="Node:$Item||Check result:failed||INFO:$info"
                        WRITE_XML_COMMON 0 "$Result"
                        isPass=1
                    else
                        Result="Node:$Item||Check result:pass||INFO:$info"
                        WRITE_XML_COMMON 0 "$Result"
                    fi
                done < $G_TMP_FILE$Item
                restore_ifs
        done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

function get_valid_back_ip_by_dsid()
{
    local ds_id=$1
    local back_ip=""
    local back_ips=""
    local i=1
    local cnt=0

    back_ip=`grep "DS $ds_id " /proc/monc_dsmap|awk '{print $14}'`
    back_ips=`sqlite3 ${CM_DB} "select IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 and NID=(select NID from CM_NODE_IP_T where SUBNET_ID=1 and IP_ADDR=\"$back_ip\" limit 1)"`
    cnt=`echo "$back_ips" | wc -l`
    #echo "default:$back_ip all:$back_ips cnt:$cnt"
    while [ "$i" -le "$cnt" ]
    do
        back_ip=`echo "$back_ips" | awk NR==$i'{print $1}'`
        #echo  "cur: $back_ip"
        #try ping
        for time in ${RepeatTimes[*]};do
            ping_result=`ping -q -c 1 $back_ip  | grep received | awk '{print $4}'`
            local iRet=$?
            #echo "iRet:$iRet"
            if [ $iRet -ne 0 ];then
                sleep 10
            else
                break
            fi
        done

        if [ "$ping_result" != 0 ];then
            #echo "ping_result:$ping_result valide_ip:$back_ip"
            echo "$back_ip"
            return
        fi

        i=$((i + 1))
    done
}


#200.ļϵͳ򿪾CA45000
checkOpenFileCount_Async()
{
    WRITE_XML_SUBCMD_HEADER $1

    local count=0
    local Result=""
    local isPass=0
    local dfsFlag=0
    local TASK_ID=0

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "REMOTE_IP_S:$REMOTE_IP_S"

    #Զ첽ִ
    remote_exec_async_batch_mml $TASK_ID 30 ShowOpenFileCount $FUNCNAME
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1

            #Ƿִгɹ
            remote_exec_checkfini $Item $TASK_ID "Can not get OpenFileCount information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get information."
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            #
            dos2unix $G_TMP_FILE$Item
            count=`cat $G_TMP_FILE$Item|grep "Open File Count"|awk '{print $5}'`

            if [ "$count" == "" ];then
                LOG "[$FUNCNAME]$Item count($count)"

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

                count="Can not get open file count."
                Result="Node:$Item||OpenFileCount:$count"
                WRITE_XML_COMMON 0 "$Result"
                isPass=1
                continue
            fi

            Result="Node:$Item||OpenFileCount:$count"
            WRITE_XML_COMMON 0 "$Result"

            if [ $count -lt 45000 ];then
                LOG "[$FUNCNAME]$Item count($count)"
            else
                LOG "[$FUNCNAME]$Item count($count) >= 45000"

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

                isPass=1
            fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#201. ڵ
checkNodeThroughput()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local isPass=0
    local CmdPort=4016
    local numCnt=1

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="INFO: Can't get local ip"
            LOG "[$FUNCNAME]:$errResult"
            isPass=1
            break
        fi

        $G_MML_FILE_PATH/ShowInspectMml $back_ip $CmdPort "cm nodeopsinfo"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]mml_result:($Info)"
            errResult="INFO: Failed to execute command."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME

        #
        set_ifs
        nodeCount=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "nodeopsinfo:" | wc -l`
        if [ $nodeCount -le 0 ]; then
            errResult="INFO: No Node OPS INFO."
            LOG "[$FUNCNAME]:$errResult"

            isPass=1
            restore_ifs
            break
        fi

        while [ $numCnt -le $nodeCount ]; do

            NID=`cat $G_REMOTE_TMP_FILE$FUNCNAME| grep "nodeopsinfo:" | awk NR==$numCnt |awk '{print $3}'`
            CifsOps=`cat $G_REMOTE_TMP_FILE$FUNCNAME| grep "nodeopsinfo:" | awk NR==$numCnt |awk '{print $6}'`
            NfsOps=`cat $G_REMOTE_TMP_FILE$FUNCNAME| grep "nodeopsinfo:" | awk NR==$numCnt |awk '{print $9}'`

            numCnt=$((numCnt+1))
            Nodeip=`get_node_backnet_ip $NID`

            if [ "$NID" == "" ] || [ "$CifsOps" == "" ] || [ "$NfsOps" == "" ];then
                errResult="Node:$Nodeip||INFO: OPS INFO have errors."
                LOG "[$FUNCNAME]:$errResult"
                isPass=1
                continue
            fi

            if [ "$CifsOps" -gt 25000 ] || [ "$NfsOps" -gt 20000 ]; then
               isPass=1
            fi

            service_type=$(get_service_type_from_db "${Nodeip}")
            if [ "${service_type}" != "1" ]; then
                LOG "service_type = ${service_type}.skip ${Nodeip}."
                WRITE_XML_ERROR 0 "Node:$Nodeip||INFO:Does not involve"
                isPass=0
                continue
            fi

            LOG "[$FUNCNAME]:Node:$Nodeip||NID:$NID||Cifs_Ops:$CifsOps||Nfs_Ops:$NfsOps"
            WRITE_XML_COMMON 0 "Node:$Nodeip||NID:$NID||Cifs_Ops:$CifsOps||Nfs_Ops:$NfsOps"

        done

        restore_ifs
        break
    done

    if [ "$isPass" != "0" ];then

        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1

        WRITE_XML_ERROR 0 "${errResult}"
        WRITE_XML_JUDGE 1
    else
        WRITE_XML_JUDGE 0
    fi

    WRITE_XML_SUBCMD_TAIL
}

checkIOPerform()
{
    rcount=`cat $G_TMP_FILE$Item |grep '<read count>' |sed "s/[^0-9]//g"`
    wcount=`cat $G_TMP_FILE$Item |grep '<write count>' |sed "s/[^0-9]//g"`
    ccount=`cat $G_TMP_FILE$Item |grep '<cmd count>' |sed "s/[^0-9]//g"`
    rbytes=`cat $G_TMP_FILE$Item |grep '<read bytes>' |sed "s/[^0-9]//g"`
    wbytes=`cat $G_TMP_FILE$Item |grep '<write bytes>' |sed "s/[^0-9]//g"`
    maxcalldelay=`cat $G_TMP_FILE$Item |grep '<max call delay(ms)>' |sed "s/[^0-9]//g"`
    maxreaddelay=`cat $G_TMP_FILE$Item |grep '<max read delay(ms)>' |sed "s/[^0-9]//g"`
    maxwritedelay=`cat $G_TMP_FILE$Item |grep '<max write delay(ms)>' |sed "s/[^0-9]//g"`
    totalcmddelay=`cat $G_TMP_FILE$Item |grep '<total cmd delay(ms)>' |sed "s/[^0-9]//g"`
    totalreaddelay=`cat $G_TMP_FILE$Item |grep '<total read delay(ms)>' |sed "s/[^0-9]//g"`
    totalwritedelay=`cat $G_TMP_FILE$Item |grep '<total write delay(ms)>' |sed "s/[^0-9]//g"`

    result="IP:$2||Protocol:$1||CheckType:IO perform||Read count:${rcount}||Write count:${wcount}||Cmd count:${ccount}"
    result=${result}"||Read bytes:${rbytes}||Write bytes:${wbytes}"
    result=${result}"||max call delay(ms):${maxcalldelay}||max read delay(ms):${maxreaddelay}||max write delay(ms):${maxwritedelay}"
    result=${result}"||total cmd delay(ms):${totalcmddelay}||total read delay(ms):${totalreaddelay}||total write delay(ms):${totalwritedelay}"
    echo $result

    if [[ ${maxreaddelay} -gt 50000 ||  ${maxwritedelay} -gt 50000 || ${maxcalldelay} -gt 50000 ]];then
        LOG "[$FUNCNAME]$1 $2 maxreaddelay($maxreaddelay) or maxwritedelay($maxwritedelay) or maxcalldelay(${maxcalldelay}) over 50 !"
        return 1
    fi

    return 0
}

#202. ڵIOͳϢ
checkNodeIOPerform()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""

    #Զ첽ִвѯCIFSЭIOܣҪУipVALID_IP_FILE
    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowNodeIO > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            LOG "[$FUNCNAME]:IP:$Item"
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_COMMON 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get Node IO information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="Node: $Item||INFO: exec (ShowNodeIO) failed.return($iRet),errno($errno)!"
                LOG "[$FUNCNAME]$Item exec(get Node ioperform progress) failed.return($iRet),errno($errno)!"
                isPass=1
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"
                else
                    WRITE_XML_COMMON 0 "Node:$Item||INFO:$info"
                fi

            done < $G_TMP_FILE$Item
            restore_ifs

    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#203. 鿴Ź״̬
checkWatchdogStatus_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    InstallPath="/opt/huawei/deploy/bin/daemon"
    Result=""
    isPass=0

    ALLIp=`cat $IP_ROLE_FILE`

    >${VALID_IP_FILE}

    if [ -z "$ALLIp" ]; then
        isPass=1
        errResult="Get all back IP failed"
    fi
    for Item in $ALLIp
    do
        #ԶΪ첽ִ
        remote_exec_async $Item 0 30 "ls /opt/huawei/deploy/bin/daemon > $G_REMOTE_TMP_FILE$Item 2>&1"
        iRet=$?

        remote_exec_async $Item 1 30 "ps -ef |grep /opt/huawei/deploy/bin/daemon|grep -v 'grep'| grep -v 'localexec' > $G_REMOTE_TMP_FILE2$Item 2>&1"
        iRet2=$?
        if [ $iRet -ne 0 ] || [ $iRet2 -ne 0 ]; then
            remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$Item
            Info=`cat $G_TMP_FILE$Item`
            errResult="Node: $Item||Error: ${Info}||$errResult"
            isPass=1

            remote_download_sync $Item $G_TMP_FILE2$Item $G_REMOTE_TMP_FILE2$Item
            Info=`cat $G_TMP_FILE2$Item`
            errResult="Node: $Item||Error: ${Info}||$errResult"
            WRITE_XML_ERROR 0 "Node:$Item||Error:Failed to execute command."
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #Ϊ100%֮ļأн ӷظ ÿεȴ10
            for time in ${RepeatTimes[*]}; do
            proresult=`/opt/huawei/deploy/script/localexec.py progress $Item $!0`
            iRet=$?
                if [ $iRet -eq 101 ]; then
                    sleep 10
                else
                    break
                fi
            done
            LOG "[$FUNCNAME]:IP:$Item,proresult0:$proresult"
            process=`echo $proresult | awk '{print $1}'`
            errno=`echo $proresult | awk '{print $4}'`

            if [[ $iRet -eq 0 && "$process" != "" && "$process" != "100" ]];then
                echo  -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 0 ] || [ "$process" == "" ];then
                errResult="IP: $Item||Error: exec (get progress) failed.errno($errno)!||$errResult"
                LOG "[$FUNCNAME] exec(get progress0) INFO.iRet($iRet),$Item, process($process), errno($errno)"
                WRITE_XML_ERROR 0 "Node:$Item||Error:Can not get daemon information.\r\n"
                isPass=1;
                continue
            fi

            Result=""

            #errnoΪ0˵ļ
            if [ "$errno" == "0" ] ;then
                Result="INFO:${InstallPath} is exist."
            else
                Result="INFO:${InstallPath} is not exist or is not a regular file."
                LOG "[$FUNCNAME]$Item $Result"
                isPass=1
            fi

            #Ϊ100%֮ļأн ӷظ ÿεȴ10
            for time in ${RepeatTimes[*]}; do
            proresult=`/opt/huawei/deploy/script/localexec.py progress $Item $!1`
            iRet=$?
                if [ $iRet -eq 101 ]; then
                    sleep 10
                else
                    break
                fi
            done
            LOG "[$FUNCNAME]:IP:$Item,proresult1:$proresult"
            process=`echo $proresult | awk '{print $1}'`
            errno=`echo $proresult | awk '{print $4}'`

            if [[ $iRet -eq 0 && "$process" != "" && "$process" != "100" ]];then
                echo "$Item" >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 0 ] || [ "$process" == "" ];then
                errResult="IP: $Item||Error: exec (get progress) failed.errno($errno)! ||$errResult"
                LOG "[$FUNCNAME] exec(get progress1) INFO.iRet($iRet),$Item, process($process), errno($errno)"
                isPass=1
                continue
            fi

            remote_download_sync $Item $G_TMP_FILE2$Item $G_REMOTE_TMP_FILE2$Item
            ExecInfo=`cat $G_TMP_FILE2$Item`
            if [ "${ExecInfo}" == "" ]; then
                Result="${Result}||INFO:${InstallPath} is not running.\n"
                LOG "[$FUNCNAME]$Item ${InstallPath} is not running."
                isPass=1
            else
                Result="${Result}||INFO:${InstallPath} is running.\n"
            fi

            LOG "INFO:$Itemr\n$Result\r\n"
            WRITE_XML_COMMON 0 "INFO:${G_SEPARATOR}||INFO:$Item||$Result"

        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    if [ "${isPass}" == "0" ];then
        WRITE_XML_JUDGE 0
    else
        WRITE_XML_JUDGE 1
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_SUBCMD_TAIL
}

#204. MONϵͳ״̬: Ƿ״̬ͨMAPṩMMLӡmap
#uds֧
checkMonitorHeartbeat_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isOK=0
    local Info=""

    strNormal="Normal"
    len=${#strNormal}
    errResult=""
    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')
    #Զ첽ִҪУipVALID_IP_FILE
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/GetMapInfo 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            remote_exec_checkfini $Item $TASK_ID "Can not get GetMapInfo information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ] || [ $ProductType -eq 80 ];then
                LOG "service_type = ${service_type}.skip ${Item},ProductType=$ProductType"

                #Ϊ100%֮ļأн
                file_DsMap="DsMap"
                remote_download_sync $Item $G_TMP_FILE$file_DsMap /tmp/tmpfile$file_DsMap
                iRet0=$?

                if [ "$iRet0" != "0" ];then
                    errResult="Node: $Item||Error: (get mapinfo) get progress failed.iRet0($iRet0)||${errResult}"
                    LOG "[$FUNCNAME] (get mapinfo) get progress failed.iRet0($iRet0)||${errResult}"

                    isPass=1
                    continue
                fi

                #DS mapϢ #Ƿҵ 'ucState' ʶ #############################################
                isOK=0
                isFound=0
                set_ifs

                head_info="******************** DS Map *********************"
                WRITE_XML_COMMON 0 "Node:$Item||INFO:$head_info"

                while read line
                do
                    tmp=`echo ${line} | grep 'ucState' `
                    if [ "${tmp}" == "" ]; then
                        continue
                    fi
                    ucstate=`echo ${line}  | grep 'ucState' | awk '{print $12}'`
                    if [ "${ucstate:0:$len}" != "Normal" ];then
                        LOG "[$FUNCNAME]$Item monc_dsmap ucstate($ucstate) is not Normal"
                        WRITE_XML_COMMON 0 "Node: ||INFO:${line}"
                        isOK=1
                        isPass=1
                    fi
                    isFound=1
                done < $G_TMP_FILE$file_DsMap

                if [ "${isFound}" == "0" ]; then
                    LOG "[$FUNCNAME]$Item cat /proc/monc_dsmap isFound(${isFound})"
                    errResult="Node: $Item||Error: cat /proc/monc_dsmap ucState flag is not found or not Normal!||${errResult}"
                    isPass=1
                elif [ "$isOK" == "0" ]; then
                    WRITE_XML_COMMON 0 "Node: ||INFO:All DS Map Normal"
                fi
                continue
            fi

            #Ϊ100%֮ļأн
            file_DsMap="DsMap"
            remote_download_sync $Item $G_TMP_FILE$file_DsMap /tmp/tmpfile$file_DsMap
            iRet0=$?

            file_MdsMap="MdsMap"
            remote_download_sync $Item $G_TMP_FILE$file_MdsMap /tmp/tmpfile$file_MdsMap
            iRet1=$?

            file_CaMap="CaMap"
            remote_download_sync $Item $G_TMP_FILE$file_CaMap /tmp/tmpfile$file_CaMap
            iRet2=$?

            file_PipMap="PipMap"
            remote_download_sync $Item $G_TMP_FILE$file_PipMap /tmp/tmpfile$file_PipMap
            iRet3=$?

	    file_MonMap="Monc_MonMap"
            remote_download_sync $Item $G_TMP_FILE$file_MonMap /tmp/tmpfile$file_MonMap
            iRet4=$?

            if [ "$iRet0" != "0" ] || [ "$iRet1" != "0" ] || [ "$iRet2" != "0" ] || [ "$iRet3" != "0" ] || [ "$iRet4" != "0" ];then
                errResult="Node: $Item||Error: (get mapinfo) get progress failed.iRet0($iRet0),iRet1($iRet1),iRet2($iRet2),iRet3($iRet3), iRet4($iRet4)||${errResult}"
                LOG "[$FUNCNAME] (get mapinfo) iRet1($iRet1),iRet2($iRet2),iRet3($iRet3),iRet4($iRet4)"

                isPass=1
                continue
            fi

            #DS mapϢ #Ƿҵ 'ucState' ʶ #############################################
            isOK=0
            isFound=0
            set_ifs

            head_info="******************** DS Map *********************"
            WRITE_XML_COMMON 0 "Node:$Item||INFO:$head_info"

            while read line
            do
                tmp=`echo ${line} | grep 'ucState' `
                if [ "${tmp}" == "" ]; then
                    continue
                fi
                ucstate=`echo ${line}  | grep 'ucState' | awk '{print $12}'`
                if [ "${ucstate:0:$len}" != "Normal" ];then
                    LOG "[$FUNCNAME]$Item monc_dsmap ucstate($ucstate) is not Normal"
                    WRITE_XML_COMMON 0 "Node: ||INFO:${line}"
                    isOK=1
                    isPass=1
                fi
                isFound=1
            done < $G_TMP_FILE$file_DsMap

            if [ "${isFound}" == "0" ]; then
                LOG "[$FUNCNAME]$Item cat /proc/monc_dsmap isFound(${isFound})"
                errResult="Node: $Item||Error: cat /proc/monc_dsmap ucState flag is not found or not Normal!||${errResult}"
                isPass=1
            elif [ "$isOK" == "0" ]; then
                WRITE_XML_COMMON 0 "Node: ||INFO:All DS Map Normal"
            fi

            #mds mapϢ###################################################################
            isFound=0
            isOK=0
            head_info="**************** Active MDS Map *****************"
            WRITE_XML_COMMON 0 "Node: ||INFO:$head_info"

            while read line
            do
                tmp=`echo ${line} | grep 'State' `
                if [ "${tmp}" == "" ]; then
                    continue
                fi
                state=`echo ${line}  | grep 'State' | awk '{print $6}'`
                if [ "${state:0:$len}" != "Normal" ];then
                    LOG "[$FUNCNAME]$Item monc_mdsmap state($state) is not Normal"

                    WRITE_XML_COMMON 0 "Node: ||INFO:${line}"

                    isPass=1
                    isOK=1
                fi
                isFound=1
            done < $G_TMP_FILE$file_MdsMap

            if [ "${isFound}" == "0" ]; then
                LOG "[$FUNCNAME]$Item cat /proc/monc_mdsmap isFound(${isFound}))"
                errResult="Node: $Item||Error: cat /proc/monc_mdsmap ucState flag is not found or not Normal!||${errResult}"
                isPass=1
            elif [ "$isOK" == "0" ]; then
                WRITE_XML_COMMON 0 "Node: ||INFO:All MDS Map Normal"
            fi

            #ca map״̬###################################################################
            isFound=0
            isOK=0
            head_info="******************** CA Map *********************"
            WRITE_XML_COMMON 0 "Node: ||INFO:$head_info"

            while read line
            do
                tmp=`echo ${line} | grep 'State' `
                if [ "${tmp}" == "" ]; then
                    continue
                fi
                state=`echo ${line}  | grep 'State' | awk '{print $6}'`
                if [ "${state:0:$len}" != "Normal" ];then
                    LOG "[$FUNCNAME]$Item monc_mdsmap state($state) is not Normal"
                    WRITE_XML_COMMON 0 "Node: ||INFO:${line}"

                    isOK=1
                    isPass=1
                fi
                isFound=1
            done < $G_TMP_FILE$file_CaMap

            if [ "${isFound}" == "0" ]; then
                LOG "[$FUNCNAME]$Item cat /proc/monc_mdsmap isFound(${isFound}))"
                errResult="Node: $Item||Error: cat /proc/monc_mdsmap ucState flag is not found or not Normal!||${errResult}"
                isPass=1
            elif [ "$isOK" == "0" ]; then
                WRITE_XML_COMMON 0 "Node: ||INFO:All CA Map Normal"
            fi

            #pip map״̬###################################################################
            isFound=0
            isOK=0
            head_info="******************** PIP Map *********************"
            WRITE_XML_COMMON 0 "Node: ||INFO:$head_info"

            while read line
            do
                tmp=`echo ${line} | grep 'State' `
                if [ "${tmp}" == "" ]; then
                    continue
                fi

                nodeIp=$(echo ${line} | awk '{print $3}')
                local node_service_type=$(get_service_type_from_db "${nodeIp}")
                if [ "${node_service_type}" != "1" ]; then
                    continue
                fi

                state=`echo ${line}  | grep 'State' | awk '{print $5}'`
                if [ "${state:0:$len}" != "Normal" ];then
                    LOG "[$FUNCNAME]$Item monc_pipmap state($state) is not Normal"
                    WRITE_XML_COMMON 0 "Node: ||INFO:${line}"

                    isOK=1
                    isPass=1
                fi
                isFound=1
            done < $G_TMP_FILE$file_PipMap

            if [ "${isFound}" == "0" ]; then
                LOG "[$FUNCNAME]$Item cat /proc/monc_pipmap isFound(${isFound}))"
                errResult="Node: $Item||Error: cat /proc/monc_pipmap ucState flag is not found or not Normal!||${errResult}"
                isPass=1
            elif [ "$isOK" == "0" ]; then
                WRITE_XML_COMMON 0 "Node: ||INFO:All PIP Map Normal"
            fi

		#mon map״̬###################################################################
		isFound=0
		isOK=0
		head_info="******************** Mon Map *********************"
		WRITE_XML_COMMON 0 "Node: ||INFO:$head_info"

		MonMapNum=`cat $G_TMP_FILE$file_MonMap | grep iRank | wc -l`
		DsMapNum=`cat $G_TMP_FILE$file_DsMap | grep IpAddr | wc -l`

		if [ $MonMapNum -ne $DsMapNum ]; then
			errResult="Node: $Item||Error: MonMapNum:$MonMapNum, NeedMonMapNum($DsMapNum)! || ${errResult}"
			isPass=1
		else
			WRITE_XML_COMMON 0 "Node: ||INFO:All Mon Map Normal"
		fi

            restore_ifs

        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    LOG "[$FUNCNAME]isPass($isPass)!"
    if [ "${isPass}" == "0" ];then
        WRITE_XML_JUDGE 0
    else
        WRITE_XML_ERROR 0 "${errResult}"
        WRITE_XML_JUDGE 1
    fi

    WRITE_XML_SUBCMD_TAIL
}

#205. NTP״̬/server
checkNTPService_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local isConnected
    local ntpServer=""

    ALLIp=`cat $IP_ROLE_FILE`

    >${VALID_IP_FILE}

    for Item in $ALLIp
    do
        #ԶΪ첽ִ
        remote_exec_async $Item 0 120 "service ntp status > $G_REMOTE_TMP_FILE$FUNCNAME"
        iRet=$?
        remote_exec_async $Item 1 30 "cat /etc/ntp.conf > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
        iRet2=$?
        if [ $iRet -ne 0 ] || [ $iRet2 -ne 0 ] ; then
            errResult="Node: $Item||Error: ${iRet}||$errResult"

            errResult="Node: $Item||Error: ${iRet2}||$errResult"
            WRITE_XML_ERROR 0 "Info:${G_SEPARATOR}\r\n$Item\r\nFailed to execute command."
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #Ϊ100%֮ļأн
            TASK_ID=0
            remote_exec_checkfini $Item $TASK_ID "Can not get service ntp status information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            state=`cat $G_TMP_FILE$Item |grep 'NTPD' | awk -F : '{ print $2}' | sed "s/[^a-z]//g"`
            if [ $? -ne 0 ]; then
                isPass=1
                Status="Can not get NTP status."
                LOG "[$FUNCNAME]$Item $Status"
            elif [ "${state}" != "running" ];then
                isPass=1
                Status="NTP service is NOT running."
                LOG "[$FUNCNAME]$Item $Status"
            else
                Status="NTP service is running."
            fi

            #Ϊ100%֮ļأн #########################################
            TASK_ID=1
            remote_exec_checkfini $Item $TASK_ID "Can not get /etc/ntp.conf information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download_sync $Item $G_TMP_FILE2$Item $G_REMOTE_TMP_FILE2$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi

            #
            cat $G_TMP_FILE2$Item >> $LOG_FILE 2>&1

            server=`cat $G_TMP_FILE2$Item |grep server | sed '/#/d'|awk '{print $2}'`
            if [ $? -ne 0 ] || [ "$server" == "" ]; then
                isPass=1
                server="Can not get NTP server."
                connectState="--"
                LOG "[$FUNCNAME]$Item $server"
            else
                LOG "[$FUNCNAME]$Item $server"
                isConnected=0
                for ip in ${server[*]}
                do
                    for time in ${RepeatTimes[*]}; do
                        tempStr_ping=`ping -q -c 1 $ip |grep "1 received" |wc -l`
                        if [ "1" != "$tempStr_ping" ];then
                            tempStr_ping=`ping6 -q -c 1 $ip |grep "1 received" |wc -l`
                        fi
                        local iRet=$?
                        LOG "[$FUNCNAME] tempStr_ping=$tempStr_ping,iRet=$iRet"
                        if [ $iRet -ne 0 ]; then
                            sleep 10
                        else
                            break
                        fi
                    done
                    if [ "1" == "$tempStr_ping" ];then
                        connectState="OK"
                        isConnected=1
                        ntpServer="$ip"
                        break
                    fi
                done
                if [ $isConnected -eq 0 ]; then
                    connectState="Can not access."
                    ntpServer=`echo ${server} | tr '\n' ' '`
                    isPass=1
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:Server $ntpServer Can not access.ERRCODE(7)"
                fi
            fi

            Result="RunningStatus:$Status||Server:$ntpServer||ConnectingStatus:$connectState"
            WRITE_XML_COMMON 0 "Node:$Item||$Result"
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#206. CMڵ
checkCMMaster()
{
    WRITE_XML_SUBCMD_HEADER $1
    local CMMasterNID=0
    local isPass=0
    local NID_before=""
    local TASK_ID=0
    local masterIP=""

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch_mml $TASK_ID 30 ShowCMMaster $FUNCNAME
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
    >${VALID_IP_FILE}

        for Item in $ValidIP; do

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get cmmaster information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    LOG "[$FUNCNAME] Error: $info"
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"
                    continue
                fi

                #ȡ
                masterNID=`cat $G_TMP_FILE$Item | grep CMMasterNID | awk '{print $2}'`
                LOG "[$FUNCNAME]:masterNID:$masterNID,NID_before:$NID_before"

                if [ "$masterNID" == "" ]; then
                    isPass=1
                    LOG "[$FUNCNAME] Error: No CM MasterNID info"

                    WRITE_XML_ERROR 0 "Node:$Item||INFO:No masterNID info"
                    continue
                fi

                masterIP=`get_node_backnet_ip $masterNID`
                Result="Node:$Item||CMMasterNID:$masterNID||CMMasterIP:$masterIP"

                if [ "$NID_before" != "" ];then
                    if [ "$NID_before" != $masterNID ];then
                        isPass=1
                    fi
                fi

                NID_before=$masterNID
                WRITE_XML_COMMON 0 "${Result}"

            done < $G_TMP_FILE$Item
            restore_ifs
    done

    local tmpIP=`grep "^ip=" /opt/huawei/snas/etc/cm.ini | sed 's/ip=//'`
    #Ѿ鵽ڵˣѲ½ľǸIPһжڵǲԼ
    local myNid=`grep "NID=" /opt/huawei/snas/etc/cm.ini | sed 's/NID=//'`
    if [ "$myNid" != "$NID_before" ];then
        isPass=1
        WRITE_XML_ERROR 0 "Node:${tmpIP}||INFO:The master ip is not on master node!"
    fi
    #CM/monǲ
    local cm_master_ip=$(/opt/huawei/snas/script/getCmMaster.sh)
    local mon_leader=$(cat /proc/monc_leader | grep -Po '(?<=Mon leader: )[0-9.]*')
    if [ -z "${cm_master_ip}" ] || [ -z "${mon_leader}" ];then
        LOG "[$FUNCNAME][$LINENO]ERROR:Failed to get leader IP of cm or mon!"
        WRITE_XML_ERROR 0 "Node:${tmpIP}||INFO:Failed to get leader IP of cm or mon!"
        isPass=1
    else
        echo ${cm_master_ip} | grep -wFq ${mon_leader}
        if [ $? -eq 0 ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:${tmpIP}||INFO:Cm and mon's leader are on the same node!"
            LOG "[$FUNCNAME][$LINENO]ERROR:Cm and mon's leader are on the same node!"
        else
            LOG "[$FUNCNAME][$LINENO]OK:Cm and mon's leader are on the different node!"
        fi
    fi
    LOG "[$FUNCNAME][$LINENO]:myNid:$myNid,NID_before:$NID_before"

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#207. ISM״̬ISM/CM״̬
checkISMStatus_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Status=""
    local hbStatus=""
    local Result=""
    local process=""
    local isPass=0
    local iRet=0
    local iRet_ISM=0
    local iRet_ibase=0
    local subDomain=""

    ALLIp=`cat $IP_ROLE_FILE`

    >${VALID_IP_FILE}
    #˷0ip
    for item in $ALLIp
    do
        remote_exec $item 30 "cat /opt/huawei/snas/etc/cm.ini | grep "SubDomain=0" >> /dev/null 2>&1"
        if [ $? -eq 0 ];then
            echo -n "$item " >> ${VALID_IP_FILE}
            continue
        fi
        LOG "item is not SubDomain=0"
    done

    ALLSubDomain0Ip=`cat ${VALID_IP_FILE}`
    >${VALID_IP_FILE}
    for Item in $ALLSubDomain0Ip
    do
        #ԶΪ첽ִ
        remote_exec_async $Item 0 30 "/opt/huawei/snas/script/inspect_mml/ShowISMInfo > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet1=$?
        sleep 1
        remote_exec_async $Item 1 30 "lsof -i :8080|grep ESTABLISHED|grep ibase > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
        iRet2=$?

        if [ $iRet1 -ne 0 ] || [ $iRet2 -ne 0 ] ; then

            isPass=1
            LOG "execute ShowISMInfo return $iRet1; execute lsof return $iRet2"
            echo $FUNCNAME >>  /var/log/inspect.log
            cat $G_REMOTE_TMP_FILE$FUNCNAME  >> /var/log/inspect.log
            cat $G_REMOTE_TMP_FILE2$FUNCNAME  >> /var/log/inspect.log
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #Ϊ100%֮ļأн ӷظ ÿεȴ10
            remote_exec_checkfini $Item 0 "Can not get ISMInfo"
            iRet_ISM=$?
            remote_exec_checkfini $Item 1 "Can not get HTBTinfo "
            iRet_ibase=$?
            if [ $iRet_ISM -eq 0 -o $iRet_ibase -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet_ISM -ne 2 -a $iRet_ISM -ne 5 ] || [ $iRet_ibase -ne 2 -a $iRet_ibase -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi

            #ism״̬
            process=$(cat $G_TMP_FILE$Item |grep -v "SubDomain")
            SubDomain=$(cat $G_TMP_FILE$Item |grep "SubDomain" |awk -F "=" '{print $2}')
            if [ "${SubDomain}" != "0" ]; then
                continue
            fi

            if [ "$process" != "" ];then
                Status="DeviceManager is running."
            else
                Status="DeviceManager is not running."
                LOG "[$FUNCNAME]$Item $Status, process($process)"
                isPass=1
            fi

            remote_download_sync $Item $G_TMP_FILE2$Item $G_REMOTE_TMP_FILE2$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
            #ismcm״̬
            hbStatus=`cat $G_TMP_FILE2$Item`

            if [ "$hbStatus" != "" ];then
                htbtStatus="Normal"
            else
                htbtStatus="Abnormal"
                LOG "[$FUNCNAME]$Item htbtStatus($htbtStatus) not Normal"
                isPass=1
            fi

            Result="IP:$Item||DeviceManagerStatus:$Status||HTBTStatus:$htbtStatus"
            WRITE_XML_COMMON 0 "$Result"
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#208. license״̬
checkLicenseStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local iRet=0

    while true; do

        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            LOG "[$FUNCNAME]:INFO: Can't get local ip"
            isPass=1
            WRITE_XML_COMMON 0 "INFO:Can't get local ip"
            break
        fi

        #ִmml cm licensecfg
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm licensecfg"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]mml_result:$Info"
            WRITE_XML_COMMON 0 "INFO:Failed to execute command(cm licensecfg)."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1

        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "get license res cfg fail"`
        if [ "$Info" != "" ];then
            #һжǷмlicenseļ
            WRITE_XML_ERROR 0 "INFO:License is not activated."
            break
        fi

        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "acFeatureName"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "$javaID" = "" ];then
            LOG "[$FUNCNAME]:$line,javaID is null"
            WRITE_XML_ERROR 0 "INFO:No license resource active."
            break
        fi

        set_ifs
        for line in $javaID
        do
            if [ $line = "" ];then
                continue
            fi
            #ʽacFeatureName : WiseQuota || acLicRunTime : 1375113600000 || uiResLKVal : 10.
            #ʽacFeatureName : WiseLink || acLicRunTime : 1375113600000 || uiResLKVal : 10.
            #ʽacFeatureName : WiseTier || acLicRunTime : 1375113600000 || uiResLKVal : 10.

            Feature=`echo $line |awk '{print $3}'`
            MaxNumber=`echo $line |awk '{print $11}'|sed 's/\./ /g'`
            Deadline=`echo $line |awk '{print $7}'`
            LOG "Deadline:$Deadline"
            if [ "${Deadline}" == "9999-12-31" ];then
                date1=$(date --date "${Deadline}" +%s)
                Deadline="PERMANENT"
            else
                date1=`expr $Deadline \/ 1000`
                Deadline=`date --date "1970-01-01 UTC $date1 seconds" +"%Y-%m-%d %T %z"`
            fi
            LOG "Deadline:$Deadline"
            date2=`date`

            t1=$date1
            t2=`date --date "$date2" +%s`
            LOG "Deadline:$t1,CurrentTime:$t2"

            LOG "[$FUNCNAME]:$line"

            if [ $t1 -gt $t2 ]; then
                LOG "$Deadline > $date2"
                Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline"
                LOG "[$FUNCNAME_gt]:Result($Result)"
                WRITE_XML_COMMON 0 "$Result"
            elif [ $t1 -eq $t2 ]; then
                LOG "$Deadline == $date2"
                Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline"
                LOG "[$FUNCNAME_eq]:Result($Result)"
                WRITE_XML_COMMON 0 "$Result"
            else
                LOG "$Deadline < $date2"
                isPass=1
                LOG "isPass:$isPass"

                Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline"
                LOG "[$FUNCNAME_expired]:Result($Result)"
                WRITE_XML_COMMON 0 "$Result"
            fi
        done
        restore_ifs

        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#һΧڵ
function ProduceRandom()
{
    min=$1
    max=$2-$1
    num=$(date +%s+%N)
    ((retnum=num%max+min))
    echo $retnum
}

#209. ļϵͳ    ֳ֧ļв    ضĿ¼ִдĿ¼/ļ//ӲӵȲ
checkFileOperation_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local Info=""

    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/ShowFileOperation > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    sleep 10

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do

             #checkڵ
             service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_COMMON 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get FileOperation information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                fi

                WRITE_XML_COMMON 0 "Node:$Item||INFO:$info"

            done < $G_TMP_FILE$Item
            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#NASЭ    ӵĿͻ    ͻIP/Э            NASЭ
#NASȺ״̬                            CM
#wiselink    ״̬                    NASЭ
#    OPS                            NASЭ

checkNASClient()
{
    local Item=$1
    local res=$(cat $G_TMP_FILE$Item)
    if [ "${res}" == "Does not involve" ];then
        LOG "res:${res}"
        result="$res"
        return 0
    fi

    client_ip=`cat $G_TMP_FILE$Item |grep "ip_clnt"|awk -F">" '{print $2}'| awk -F"<" '{print $1}'`
    client_num=`cat $G_TMP_FILE$Item |grep "ip_clnt"|awk -F">" '{print $2}'| awk -F"<" '{print $1}'|wc -l`
    client_protocal=`cat $G_TMP_FILE$Item |grep "proto_type"| sed 's/[^A-Z]//g'`
    result="LocalIp:$1||client_num:${client_num}||client_type:$2"

    info=`cat $G_TMP_FILE$Item`
    LOG "[$FUNCNAME] $1 ,info:$info"
    LOG "client_num:$client_num"

    if [ ${client_num} -gt 400 ];then
        LOG "[$FUNCNAME]$1 ${client_protocal} client num(${client_num}) over 400!"
        echo $result
        return 1
    else
        echo "LocalIp:$1||client_num:$client_num||client_type:$2"
    fi
}

#===================================================
# ƣȡcm_conf.dbнڵӦķ
# ܣ
# 
#===================================================
function get_service_type_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    local service_type=$(/usr/bin/sqlite3 ${CM_DB} "select Reserved2 from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${service_type}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get service_type from db ,temp=$temp"
        service_type=$(/usr/bin/sqlite3 ${CM_DB} "select Reserved2 from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done

    echo ${service_type}
}
#===================================================
# ƣȡcm_conf.dbнڵӦIP
# ܣͨڵĺIPݿжϵǰڵIPV4 or IPV6
# 
#===================================================
function get_frontip_type()
{
    local temp=1
    local ip=$1
    local FrontIP=""
    local iret=0
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    #ȡڵһǰIP
    local FrontIP=$(/usr/bin/sqlite3 ${CM_DB} "select IP_ADDR from CM_NODE_IP_T where NID='${nid}' and SUBNET_ID=2 limit 1" | tr -d ' ')
    while [[ "${FrontIP}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get FrontIP from db ,temp=$temp"
        FrontIP=$(/usr/bin/sqlite3 ${CM_DB} "select IP_ADDR from CM_NODE_IP_T where NID='${nid}' and SUBNET_ID=2 limit 1" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    #IPûðűʾIPV4
    echo $FrontIP|grep -q "\:" > /dev/null
    iret=$?
    echo ${iret}
}

#===================================================
# ƣȡcm_conf.dbнڵӦĽڵ
# ܣͨڵĺIPݿȡڵ
# 
#===================================================
function get_node_hostname_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    local hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${hostname}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get node hostname from db ,temp=$temp"
        hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done

    echo ${hostname}
}


#210. NASӵĿͻ
checkALLClient()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""

    local TASK_CIFS_ID=0
    local isPass=0
    local dfsFlag=0

    local isGotClientCIFS=1
    local isGotClientNFS=1

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    > /tmp/checkALLClient[CIFS]
    > /tmp/checkALLClient[NFS]

    remote_exec_async_batch $TASK_CIFS_ID 30 "/usr/local/bin/nas_proto_status_cifs -t clntinfo > $G_REMOTE_TMP_FILE$FUNCNAME[CIFS] 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_COMMON 0 "LocalIp:$Item||DFS:No||client_num:--||client_type:--"
                continue
            fi

            dfsFlag=1

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_CIFS_ID "Can not get nas_proto_status_cifs information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            #ݽ
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[CIFS]
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            #
            ret=`checkNASClient $Item "CIFS"`
            if [ $? -ne 0 ];then
                LOG "[$FUNCNAME]check $Item cifs client failed!"
                isPass=1
            fi

            isGotClientCIFS=1
            pingCIFSAdd=""
            server_ip=`cat $G_TMP_FILE$Item |grep "ip_svc"|head -1|awk -F">" '{print $2}'| awk -F"<" '{print $1}'`
            client_ip=`cat $G_TMP_FILE$Item |grep "ip_clnt"|awk -F">" '{print $2}'| awk -F"<" '{print $1}'`
            if [ $isGotClientCIFS -ne 0 ] && [ "$client_ip" != "" ] ;then
                pingCIFSAdd=`echo $client_ip|head -1|awk '{print $1}'`
                isGotClientCIFS=0
            fi
            echo "IP $Item;Flag $isGotClientCIFS;clientIP $pingCIFSAdd;serverIP $server_ip" >>/tmp/checkALLClient[CIFS]
            Client_Num=$(echo ${ret}|awk -F '\\|\\|' '{print $2}')
            Client_Type=$(echo ${ret}|awk -F '\\|\\|' '{print $3}')
            WRITE_XML_COMMON 0 "LocalIp:$Item||DFS:Yes||${Client_Num}||${Client_Type}"
    done



    #ȡnfsͻ
    TASK_NFS_ID=1
    remote_exec_async_batch $TASK_NFS_ID 30 "/usr/local/bin/nas_proto_status_nfs -t clntinfo  > $G_REMOTE_TMP_FILE$FUNCNAME[NFS] 2>&1"
    if [ "${isPass}" -eq "0" ];then
        isPass=$?
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do

            #checkڵ
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                continue
            fi

            dfsFlag=1

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_NFS_ID "Can not get nas_proto_status_nfs information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            #ݽ
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[NFS]
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            ret=`checkNASClient $Item "NFS"`
            if [ $? -ne 0 ] ;then
                LOG "[$FUNCNAME]check $Item nfs client failed!"
                isPass=1
            fi

            isGotClientNFS=1
            pingNFSAdd=""
            server_ip=`cat $G_TMP_FILE$Item |grep "ip_svc"|head -1|awk -F">" '{print $2}'| awk -F"<" '{print $1}'`
            client_ip=`cat $G_TMP_FILE$Item |grep "ip_clnt"|awk -F">" '{print $2}'| awk -F"<" '{print $1}'`
            if [ $isGotClientNFS -ne 0 ] && [ "$client_ip" != "" ] ;then
                pingNFSAdd=`echo $client_ip|head -1|awk '{print $1}'`
                isGotClientNFS=0
            fi
            echo "IP $Item;Flag $isGotClientNFS;clientIP $pingNFSAdd;serverIP $server_ip" >>/tmp/checkALLClient[NFS]
            Client_Num=$(echo ${ret}|awk -F'\\|\\|' '{print $2}')
            Client_Type=$(echo ${ret}|awk -F'\\|\\|' '{print $3}')
            WRITE_XML_COMMON 0 "LocalIp:$Item||DFS:Yes||${Client_Num}||${Client_Type}"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#211. NASȺ״̬InfoEqualizer״̬
checkNASClusterStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local dfsFlag=0
    local NASStatus=""
    local AbnormalInfo=""
    local unusedInfo=""

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #ȡnascifsϢ
    local TASK_ID="getNASStatus"
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowNasState > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get nascifs status information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ]; then
                continue
            fi

            dos2unix $G_TMP_FILE$Item

            set_ifs
            Result=""
            NASStatus=`cat $G_TMP_FILE$Item`
            if [ "$NASStatus" == "" ];then
                isPass=1
                echo "faile0:$isPass no 0"
                Result="Node:$Item||InfoEqualizer_Status:Unknown||CIFS_Status:Unknown||NFS_Status:Unknown"
            else
                AbnormalInfo=`echo $NASStatus | grep "Abnormal"`
                unusedInfo=`echo $NASStatus | grep "unused"`
                Result="$NASStatus"
                if [ "$AbnormalInfo" != "" ] || [ "$unusedInfo" != "" ];then
                    isPass=1
                    echo "faile1:$isPass no 0"
                fi
            fi

            restore_ifs
            WRITE_XML_COMMON 0 "Node:$Item||$Result"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#212. ̿ռʹ    DSṩ̿ռʹ
checkDSUsage()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local isPass=0
    >${G_NODEPOOL_FILE}

    cat /proc/monc_dsmap > $G_TMP_FILE 2>&1
    iRet=$?
    if [ $iRet -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="INFO:exec(cat /proc/monc_dsmap) failed!errno($iRet)||Error:$Info"
        LOG "[$FUNCNAME]$Item exec(cat /proc/monc_dsmap) failed!errno($iRet),${Info}"
        isOK=1
        WRITE_XML_ERROR 0 "$Result"
    else
        #ȡк
        set_ifs
        awk '/IpAddr/{print NR}' $G_TMP_FILE > $G_LINE_FILE

        count=1
        nodesNum=`cat $G_LINE_FILE|wc -l`
        while [ $count -le $nodesNum ]
        do
            line1=`cat $G_LINE_FILE|sed -n $count'p'`
            count=`expr $count \+ 1`
            if [ $count -le $nodesNum ];then
                line2=`cat $G_LINE_FILE|sed -n $count'p'`
            else
                line2=`cat $G_TMP_FILE|wc -l`
            fi
            line2=`expr $line2 \- 1`

            sed -n $line1,$line2'p' $G_TMP_FILE > $G_INFO_FILE

            IPAddress="$( cat $G_INFO_FILE|grep "IpAddr"|awk '{print $14}' )"
            NodePool="$( cat $G_INFO_FILE |grep NodePool |awk '{print $4}' )"
            #ȡһڵTotalCap

            cat $G_INFO_FILE | grep "TotalCap" > $G_TOTALCAP_FILE
            javaID=`cat $G_TOTALCAP_FILE|sed 's/^ *//g'|sed "/^$/d"`
            sumTotal=0
            sumFree=0
            for line in $javaID
            do
                totalCap=`echo $line|awk '{print $10}'`
                freeCap=`echo $line|awk '{print $12}'`

                #λֽתGB
                totalCap=`expr $totalCap / 1073741824`
                freeCap=`expr $freeCap / 1073741824`

                sumTotal=`expr $sumTotal \+ $totalCap`
                sumFree=`expr $sumFree \+ $freeCap`
            done

            #ʹ
            LOG "[$FUNCNAME]total(GB):$sumTotal free(GB):$sumFree"
            sumUsed=`expr $sumTotal \- $sumFree`
            LOG "[$FUNCNAME]total(GB):$sumTotal free(GB):$sumFree used(GB):$sumUsed"
            if [ $sumTotal -eq 0 ];then
                percentage=0
            else
                sumUsedtemp=`expr $sumUsed \* 100`
                percentage=`expr $sumUsedtemp \/ $sumTotal`
            fi

            if [ $percentage -lt 75 ];then
                LOG "[$FUNCNAME]percentage:$percentage"
            else
                isPass=1
            fi
            echo "nodepool $NodePool totalsize $sumTotal" >>${G_NODEPOOL_FILE} 2>&1
            Result="IP:$IPAddress||NodePool:$NodePool||TotalCap(GB):$sumTotal||FreeCap(GB):$sumFree||UsedCap(GB):$sumUsed||Percentage(%):$percentage"
            WRITE_XML_COMMON 0 "$Result"
        done
        sort -n -k 2 ${G_NODEPOOL_FILE} | uniq > ${G_NODEPOOLTMP_FILE} 2>&1
	local nodepool_check="$( cat ${G_NODEPOOLTMP_FILE} )"
        local nodepool_check_num="$( cat ${G_NODEPOOLTMP_FILE} | wc -l )"

        if [ "X1" != "X${nodepool_check_num}" ];then
            for line in ${nodepool_check};do
                nodepool_id="$(echo ${line} |awk '{print $2}')"
                num="$( grep "nodepool ${nodepool_id}" ${G_NODEPOOLTMP_FILE} |wc -l )"
                if [ $num -gt 1 ];then
                    isPass=1
                    LOG "[$FUNCNAME]the nodes of data disks of different capacities are in the same nodepool ${nodepool_id}. "
                    break
                fi
            done
        fi

        restore_ifs
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#213. ڵϵͨѶ·
checkCommuLink()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local TASK_ID=0
    local isPass=0
    local isFind=0
    local JavaId=""

    #ݿȡнڵĺIP
    JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1;' | sort|uniq`
    if [ $? -ne 0 ] || [ "$JavaId" = "" ];then
        LOG "[$FUNCNAME]JavaId($JavaId), ret($?)"
        errResult="INFO: Failed to get the back ip of all node."
        WRITE_XML_ERROR 0 "${errResult}"
        WRITE_XML_JUDGE 1
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch $TASK_ID 30 "cat /proc/sys/lnet/peers > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get /proc/sys/lnet/peers information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                WRITE_XML_ERROR 0 "Node: $Item||INFO: remote download file failed."
                LOG "[$FUNCNAME] IP:$Item ,remote download failed! iRet($iRet)"
                isPass=1
                continue
            fi

        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item
            set_ifs

            Result=""
            while read row
            do
                rowinfo=`echo $row | awk '{print $2}' | grep '4004\|4020\|4016\|988\|peernid'`
                if [ "${rowinfo}" != "" ];then
                    status=`echo $row | awk '{print $4}'|sed 's/^ *//g'|sed "/^$/d"`
                    status_info=`echo $status | grep down`

                    if [ "$status" == "NA" ]; then
                        continue
                    fi
                    isFind=1

                    if [ "$status" == "down" ] || [ "${status_info}" != "" ];then
                       LOG "[$FUNCNAME]status:$status,status_info:$status_info"
                       isFind=0
                       ip_info=`echo $row | awk '{print $2}' | sed 's/@.*$//g' |sed 's/^ *//g' |sed "/^$/d"`

                       for line in $JavaId; do
                            if [ "${line}" == "${ip_info}" ];then
                                isPass=1
                                isFind=1
                                break
                            fi
                       done
                    fi

                    if [ $isFind -eq 1 ];then
                           if [ "" != "${Result}" ];then
                                Result="${Result}||INFO:${row}"
                           else
                                Result="INFO:${row}"
                           fi
                    fi
                fi
            done   <  $G_TMP_FILE$Item

            if [ "" != ${Result} ];then
                WRITE_XML_COMMON 0 "INFO:${G_SEPARATOR}||INFO:$Item||${Result}"
            fi

            restore_ifs
    done

    if [ "${isPass}" == "0" ];then
        WRITE_XML_JUDGE 0
    else
        WRITE_XML_JUDGE 1
    fi

    WRITE_XML_SUBCMD_TAIL
}

#214. ڴʹ
#uds֧
checkMemPoolUsage_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local Remote_filename="MemPoolUsage"
    local TASK_ID=0
    local isPass=0
    local isflag=""
    local Total_Count=0
    local numCnt=1
    local numCnt_new=0
    local yellowmemline=0
    local Info=""
    local Info_one=""
    local PoolName=""
    local MainNodeIP=`get_backnet_ip`
    local DM_ibaseused=$(ps -e -o "pid,comm,rsz" | grep ibase|awk '{print $3}')
    local DM_httpdused=$(ps -e -o "pid,comm,rsz" | grep httpd|awk '{print $3}')

    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch_mml $TASK_ID 180 GetMemPoolUsageInfo $FUNCNAME
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult,ProductType=$ProductType"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            Result=""

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get GetMemPoolUsageInfo information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi


                remote_download $Item $G_TMP_FILE$Item /tmp/tmpfile$Remote_filename
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    LOG "[$FUNCNAME]:Node:$Item||INFO:download pool info fail,iRet($iRet)"
                    errResult="Node:$Item||INFO:download pool info fail"
                    WRITE_XML_ERROR 0 "$Result"
                    isPass=1
                    continue
                fi


        #end for Item in $ValidIP
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        fifoContext=`cat $G_TMP_FILE$Item`
        if [ "$fifoContext" = "" ];then
                continue
        fi
        dos2unix $G_TMP_FILE$Item
        if [ "$Item" == "$MainNodeIP" ]; then
            #ȡDMģڴϢ,ֻڵִм
	    sed -i '$d' $G_TMP_FILE$Item
            if [ "X""${DM_ibaseused}" == "X" ];then
                echo "[DM_ibase]" >>$G_TMP_FILE$Item 2>&1
                echo "DM[ERR]module DM ibase process not exit!" >>$G_TMP_FILE$Item 2>&1
            else
                echo "$DM_ibaseused" |while read line;do
                    echo "[DM_ibase]" >>$G_TMP_FILE$Item 2>&1
                    echo "ibase_Used=${line}" >>$G_TMP_FILE$Item 2>&1
                done
            fi
            if [ "X""{DM_httpdused}" == "X" ];then
                echo "[DM_ibase]" >>$G_TMP_FILE$Item 2>&1
                echo "DM[ERR]module DM httpd process not exit!" >>$G_TMP_FILE$Item 2>&1
            else
                echo "${DM_httpdused}" |while read line;do
                    echo "[DM_httpd]" >>$G_TMP_FILE$Item 2>&1
                    echo "httpd_Used=${line}" >>$G_TMP_FILE$Item 2>&1
                done
             fi
            echo "[END]" >>$G_TMP_FILE$Item 2>&1
        fi
        local count=0
        while read line;do
            echo $line|grep -q "^\[" >/dev/null 2>&1
            iRet=$?
            if [ 0 -eq $iRet ];then
                if [ 0 -eq $count ];then
                    let count++
                else
                    let count++
                    LOG "[${FUNCNAME}]Node:${Item}||$module:$pool||memSuccessiveArise:$memSuccessiveArise||totalsize:$totalsize(MB)||freesize(MB):$freesize||Percentage(%):$percentage||Process_Used(MB):${processused_TMP}||RPCmemused/RPCpageusd(MB):${RPCmemused_TMP}/${RPCpageused_TMP}"
                    Result="Node:${Item}||Module:$module||Pool:$pool||memSuccessiveArise:$memSuccessiveArise||totalsize(MB):$totalsize||freesize(MB):$freesize||Percentage(%):$percentage||Process_Used(MB):${processused_TMP}||RPCmemused/RPCpageusd(MB):${RPCmemused_TMP}/${RPCpageused_TMP}||MDS_LeftMemSize/MDS_ResvMemSize(MB):${MDS_LeftMemSize}/${MDS_ResvMemSize}"
                    WRITE_XML_COMMON 0 "$Result"

                fi
                module=$(echo $line |awk -F"[" '{print $2}'|awk -F"]" '{print $1}')
                pool="-"
                totalsize="--"
                freesize="--"
                percentage="--"
                processused_TMP="--"
                RPCmemused_TMP="--"
                RPCpageused_TMP="--"
		MDS_LeftMemSize="--"
                MDS_ResvMemSize="--"
                memSuccessiveArise="--"
            else
                Info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node:$Item||INFO:$Info"
                    LOG "[$FUNCNAME] Error: $Info"
                    WRITE_XML_ERROR 0 "${errResult}"
                else
                    echo $Info|grep -q "total size" >/dev/null 2>&1
                    TOTAL=$?
                    if [ 0 -eq $TOTAL ];then
                        if [ "NAS" == "$module" ];then
                            pool=$(echo $Info  | awk -F: '{print $1}')
                            poolid=$(echo "$pool" |sed 's/ //g'|awk -F] '{print $1}'|awk -F[ '{print $2}')
                            totalsize_tmp=$(expr $(echo $Info|awk -F":|," '{print $3}') \* ${poolid})
                            totalsize=$(echo "scale=4; ${totalsize_tmp}/10485760"|bc -l)
                            freesize_tmp=$(expr $(echo $Info |awk -F":|," '{print $5}') \* ${poolid})
                            freesize=$(echo "scale=4; ${freesize_tmp}/10485760"|bc -l)
                            usedSize=$(expr $(echo $Info |awk -F":|," '{print $7}') \* ${poolid})
                            usedSize_temp=$(expr $usedSize \* 100)
                            percentage=$(expr $usedSize_temp \/ ${totalsize_tmp})
                        else
                            pool=$(echo $Info | awk -F: '{print $1}')
                            totalsize=$(echo $Info|awk '{print $4}')
                            freesize=$(echo $Info |awk '{print $11}')
                            usedSize=$(expr $totalsize \- $freesize)
                            usedSize_temp=$(expr $usedSize \* 100)
                            percentage=$(expr $usedSize_temp \/ $totalsize)
                        fi
                        Threpercentage=""
                        #ģԼӦģڴʹֵ
                        MODULEMEM=("MON" "BJM_Server" "BJM_Worker" "CA" "DAB" "DS" "OBS" "CM_Kernel" "CM_User" "NV" "TRNS" "TRNS_LOG" "MONC" "NOFS" "DLM" "NAS")
                        moduleper=(85 85 85 85 80 80 80 90 90 85 90 90 85 95 80 70)
                        for i in $(seq 0 `expr ${#MODULEMEM[@]} - 1`);do
                            if [ "$module" == "${MODULEMEM[$i]}" ];then
                               Threpercentage=${moduleper[$i]}
                               break;
                            fi
                        done
                        if [ $percentage -ge $Threpercentage ];then
                            isPass=1
                            LOG "[${FUNCNAME}]Node ${Item} $module percentage ${percentage} over the threshould percentage ${Threpercentage}"
                            errResult="Node: ${Item}||INFO:$module percentage ${percentage} over the threshould percentage ${Threpercentage}!"
                            WRITE_XML_ERROR 0 "${errResult}"
                            continue
                        fi
                    fi
                    #MON,BJM_Server,BJM_Worker,BJM_ManagerģҪУ鵱ǰڴʹ
                    echo $Info |grep "_Used" >/dev/null 2>&1
                    TOTALUSED=$?
                    if [ 0 -eq $TOTALUSED ];then
                        #ģԼӦģڴʹֵ,MONģΪ1.5G,BJM_ServerģΪ2G,BJM_ServerģΪ1G,BJM_ManagerģΪ500M
                        TOTALModule=("MON" "BJM_Server" "BJM_Worker" "BJM_Manager" "DM_ibase" "DM_httpd" "Replication")
                        TOTALTHRmem=("1610612736" "2147483648" "1073741824" "536870912" "335544320" "83886080" "1073741824")
                        processused=$(echo $Info|awk -F= '{print $2}')
                        processused_TMP=$(echo "scale=4; ${processused}/10485760"|bc -l)
                        if [ "X""$processused" == "X" ];then
                            isPass=1
                            LOG "[${FUNCNAME}] Node: ${Item}||INFO:get information of $module processused used FAILED"
                            errResult="Node: ${Item}||INFO:get information of $module processused used FAILED!"
                            WRITE_XML_ERROR 0 "${errResult}"
                            continue
                        else
                            for i in $(seq 0 `expr ${#TOTALModule[@]} - 1`);do
                                if [ "$module" == "${TOTALModule[$i]}" ];then
                                    ThreshouldMem=${TOTALTHRmem[$i]}
                                    break;
                                fi
                            done
                            if [ $processused -ge $ThreshouldMem ];then
                                isPass=1
                                LOG "[${FUNCNAME}]Node: ${Item}||INFO:$module processused $processused (B) over the ThreshouldMem  $ThreshouldMem (B)!"
                                errResult="Node: ${Item}||INFO:$module processused $processused (B) over the ThreshouldMem  $ThreshouldMem (B)!"
                                WRITE_XML_ERROR 0 "${errResult}"
                                continue
                            fi
                        fi
                    fi
                    #鶯̬ڴ־
                    echo "$Info" |grep "memSuccessiveArise" >/dev/null 2>1
                    if [ $? -eq 0 ];then
                        memSuccessiveArise=$(echo $Info|awk -F"," '{print $1}'|awk -F= '{print $2}')
                        if [ 1 -eq $memSuccessiveArise ];then
                            isPass=1
                            details=$(echo $Info|awk -F"," '{print $2}')
                            LOG "[${FUNCNAME}]Node: ${Item}||INFO:the details of ten days memory ($details)"
                            errResult="Node: ${Item}||INFO:the module $module memory of ten days ($details)"
                            WRITE_XML_ERROR 0 "${errResult}"
                            continue
                        fi
                    fi
                    #RPCģֻRPCmemusedRPCpageused
                    echo $Info |grep "RPC_" >/dev/null 2>&1
                    RPC=$?
                    if [ 0 -eq $RPC ];then
                        RPCmemused=$(echo $Info|awk -F"," '{print $1}'|awk -F= '{print $2}')
                        RPCpageused=$(echo $Info|awk -F"," '{print $2}'|awk -F= '{print $2}')
                        RPCmemused_TMP=$(echo "scale=4; ${RPCmemused}/10485760"|bc -l)
                        RPCpageused_TMP=$(echo "scale=4; ${RPCpageused}/10485760"|bc -l)
                        #RPCģֵΪ1G
                        ThreshouldRPCMem="1073741824"
                        if [ $RPCmemused -gt $ThreshouldRPCMem -a $RPCpageused -gt $ThreshouldRPCMem ];then
                            isPass=1
                            LOG "[${FUNCNAME}]RPCmemused:$RPCmemused, RPCpageused:$RPCpageused"
                            errResult="Node: ${Item}||INFO:$module $RPCpageused (B) AND $RPCmemused (B) ALL OVER THE $ThreshouldRPCMem (B)!"
                            WRITE_XML_ERROR 0 "${errResult}"
                        fi
                    fi

		    #MDSģLeftMemSizeǷСڵResvMemSize
		    echo $Info |grep "MDS_" >/dev/null 2>&1
                    MDS=$?
                    if [ 0 -eq ${MDS} ];then
		        MDS_LeftMemSize=$(echo $Info|awk -F"," '{print $1}'|awk -F= '{print $2}')
                        MDS_ResvMemSize=$(echo $Info|awk -F"," '{print $2}'|awk -F= '{print $2}')
			if [ "X" == "X${MDS_LeftMemSize}" -o "X" == "X${MDS_ResvMemSize}" ];then
                    	    isPass=1
                            LOG "[${FUNCNAME}]MDS_LeftMemSize:${MDS_LeftMemSize}, MDS_ResvMemSize:${MDS_ResvMemSize}"
                            errResult="Node: ${Item}||INFO:get $module MDS_LeftMemSize ${MDS_LeftMemSize} (MB)  or MDS_ResvMemSize ${MDS_ResvMemSize} (MB) failed!"
                            WRITE_XML_ERROR 0 "${errResult}"
			elif [ ${MDS_LeftMemSize} -le ${MDS_ResvMemSize} ];then
                            isPass=1
                            LOG "[${FUNCNAME}]MDS_LeftMemSize:${MDS_LeftMemSize}, MDS_ResvMemSize:${MDS_ResvMemSize}"
                            errResult="Node: ${Item}||INFO:$module MDS_LeftMemSize ${MDS_LeftMemSize} (MB)  is less than or equal to  MDS_ResvMemSize ${MDS_ResvMemSize} (MB)!"
                            WRITE_XML_ERROR 0 "${errResult}"
                        fi

		    fi
                fi
            fi
        done <$G_TMP_FILE$Item


    #end for Item in $ValidIPResult
    done


    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#215. ؼһУ
checkDataConsistent_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local result_log=/var/log/nluninfo.log
    local TASK_ID_MDS=0
    local TASK_ID_MONC=1
    local isPass=0
    local dfsFlag=0
    local MDS="mds"
    local MONC="monc"
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "REMOTE_IP_S:$REMOTE_IP_S"

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        #checkڵͣDFSִ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            continue
        fi

        #ǣ˵ȺкDFSڵ
        dfsFlag=1
        remote_exec_async $Item $TASK_ID_MDS 60 "$G_MML_FILE_PATH/ShowInspectMml $Item 988 'mds objid show' > $G_REMOTE_TMP_FILE$FUNCNAME$MDS 2>&1"
        iRet_mds=$?
        sleep 15
        remote_exec_async $Item $TASK_ID_MONC 60 "$G_MML_FILE_PATH/ShowInspectMml $Item 988 'monc nluninfo 0'  >  $G_REMOTE_TMP_FILE$FUNCNAME$MONC 2>&1"
        iRet_monc=$?
        if [ $iRet_mds -ne 0 -o $iRet_monc -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet_mds}, ${iRet_monc}"
            WRITE_XML_ERROR 0 "Node:$Item||Error:Failed to execute command."
            isPass=1
            break
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
        break
    done

    if [ $dfsFlag -eq 0 ]; then
        isPass=0
        WRITE_XML_ERROR 0 "Does not involve"
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
     while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID_MDS "Can not check data consistent "
            iRet_mds=$?
            remote_exec_checkfini $Item $TASK_ID_MONC "Can not check data consistent "
            iRet_monc=$?
            if [ $iRet_mds -eq 0 -o $iRet_monc -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet_mds -ne 2 -a $iRet_mds -ne 5 ] || [ $iRet_monc -ne 2 -a $iRet_monc -ne 5 ];then
                isPass=1
                continue
            fi
            remote_download_sync $Item $G_TMP_FILE$Item$MDS $G_REMOTE_TMP_FILE$FUNCNAME$MDS
            iRet=$?
            if [ $iRet -ne 0 ];then

                WRITE_XML_COMMON 0 "Failed to execute remote_download command."
                isPass=1
                break
            fi

            set_ifs
            dos2unix $G_TMP_FILE$Item$MDS
            cat  $G_TMP_FILE$Item$MDS >> $LOG_FILE 2>&1
            #ȡ
            root_dir1=`grep "ROOT_DIR" $G_TMP_FILE$Item$MDS|awk -F: '{print $2}' | awk -F, '{print $1}' |sed 's/^ *//g'|sed "/^$/d"|awk -F/ '{print $1}'`
            root_dir2=`grep "ROOT_DIR" $G_TMP_FILE$Item$MDS|awk -F: '{print $2}' | awk -F, '{print $1}' |sed 's/^ *//g'|sed "/^$/d"| awk -F/ '{print $2}'`
            LOG "[$FUNCNAME]root_dir1:$root_dir1 ,root_dir2:$root_dir2"

            fs_sblock1=`grep "FS_SBLOCK" $G_TMP_FILE$Item$MDS|awk -F: '{print $2}' | awk -F, '{print $1}' |sed 's/^ *//g'|sed "/^$/d"|awk -F/ '{print $1}'`
            fs_sblock2=`grep "FS_SBLOCK" $G_TMP_FILE$Item$MDS|awk -F: '{print $2}' | awk -F, '{print $1}' |sed 's/^ *//g'|sed "/^$/d"|awk -F/ '{print $2}'`
            LOG "[$FUNCNAME]fs_sblock1:$fs_sblock1,fs_sblock2: $fs_sblock2"

            #nlun map
            if [ "$root_dir1" == "" ] || [ "$root_dir1" == "" ] || [ "$fs_sblock1" == "" ] || [ "$fs_sblock2" == "" ]; then
                errResult="INFO:Failed to get objid (root_dir1:$root_dir1 ,root_dir2:$root_dir2, fs_sblock1:$fs_sblock1, fs_sblock2: $fs_sblock2)."

                WRITE_XML_COMMON 0 "$errResult"
                isPass=1
                restore_ifs
                break
            fi

            LOG "[$FUNCNAME]get objid (root_dir1:$root_dir1 ,root_dir2:$root_dir2,fs_sblock1:$fs_sblock1,fs_sblock2: $fs_sblock2)ok"

            remote_download_sync $Item $G_TMP_FILE$Item$MONC $result_log
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                restore_ifs
                break
            fi

            checknlun_Reault=`grep ${root_dir1} $G_TMP_FILE$Item$MONC`
            if [ "${checknlun_Reault}" == "" ]; then
                LOG "[$FUNCNAME]checknlun_Reault is Null"
                errResult="INFO:Failed to get nluninfo by $root_dir1."

                WRITE_XML_COMMON 0 "$errResult"
                isPass=1
                restore_ifs
                break
            fi

            Primary_id=`echo "$checknlun_Reault" | sed 's/[[:space:]]/\n/g'|grep Primary|awk -F'(' '{print $2}'`
            LOG "[$FUNCNAME]Primary_id:$Primary_id"
            if [ "${Primary_id}" == "" ]; then
                LOG "[$FUNCNAME]Primary_id is Null"
                errResult="INFO:Failed to get Primary_id by $checknlun_Reault."

                WRITE_XML_COMMON 0 "$errResult"
                isPass=1
                restore_ifs
                break
            fi


            #ȡDS_IDӦIPַ
            DS_ID_Address=`get_valid_back_ip_by_dsid "$Primary_id"`
            LOG "[$FUNCNAME]DS_ID_Address:${DS_ID_Address}"
            if [ "${DS_ID_Address}" == "" ]; then
                LOG "DS_ID_Address is Null"
                errResult="INFO:Failed to get DS Address fail."

                WRITE_XML_COMMON 0 "$errResult"
                isPass=1
                restore_ifs
                break
            fi

            #Ƚroot_dirһ
            rootdir_result=`remote_exec ${DS_ID_Address} 30 "$G_MML_FILE_PATH/ShowDataConsistent $DS_ID_Address 'check consfile $root_dir1 $root_dir2' ROOT_DIR 2>&1"`
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="INFO:Failed to execute(${DS_ID_Address},check consfile $root_dir1 $root_dir2),iRet($iRet),errinfo($rootdir_result)"
                LOG "[$FUNCNAME]Failed to execute(${DS_ID_Address},check consfile $root_dir1 $root_dir2),iRet($iRet),errinfo($rootdir_result)"

                WRITE_XML_COMMON 0 "$errResult"
                isPass=1
            else
                WRITE_XML_COMMON 0 "$rootdir_result"
            fi

            #ȽFS_SBLOCKһ
            fssblock_result=`remote_exec ${DS_ID_Address} 30 "$G_MML_FILE_PATH/ShowDataConsistent ${DS_ID_Address} 'check consfile $fs_sblock1 $fs_sblock2' FS_SBLOCK 2>&1"`
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="INFO:Failed to execute(${DS_ID_Address},check consfile $fs_sblock1 $fs_sblock2),iRet($iRet),errinfo($fssblock_result)"
                LOG "[$FUNCNAME] Failed to execute(${DS_ID_Address},check consfile $fs_sblock1 $fs_sblock2),iRet($iRet),errinfo($fssblock_result)"

                WRITE_XML_COMMON 0 "$errResult"
                isPass=1
            else
                WRITE_XML_COMMON 0 "$fssblock_result"
            fi

            restore_ifs
            break
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
    chmod 640 ${result_log}

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

hextoip() {
    hex=$1
    local length=`echo $hex |wc -c`
    if [ $length -lt 9 ] || [ $length -gt 10 ]; then
        printf "0"
        return
    fi
    if [ $length -eq 10 ]; then
        printf "%d." 0x${hex:0:2}
        printf "%d." 0x${hex:2:2}
        printf "%d." 0x${hex:4:2}
        printf "%d"  0x${hex:6:2}
    else
        printf "%d." 0x${hex:0:1}
        printf "%d." 0x${hex:1:2}
        printf "%d." 0x${hex:3:2}
        printf "%d"  0x${hex:5:2}
    fi
}

mdsMasterIP1=""
mdsMasterIP2=""
#ȡLeaderкIP
function getMdsMasterIps()
{

    mdsMasterIP1=""
    mdsMasterIP2=""
    local isPass=0
    local TASK_ID=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch_mml $TASK_ID 30 GetMdsSubtreeInfo $FUNCNAME
    isPass=$?

    sleep 5
    ValidIP=`cat ${VALID_IP_FILE}`
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            #checkڵ
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "[$FUNCNAME]: $Item is not DFS node."
                continue
            fi
            isDfs=1
            remote_exec_checkfini $Item $TASK_ID "Can not get mds info show information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                continue
            fi

            #Ϊ100%֮ļأн
            remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                isPass=1
                continue
            fi

            MDSMaster1=`cat $G_TMP_FILE$Item | grep "root mds ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
            if [ "$MDSMaster1" == "" ];then
                isPass=1
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                Result="INFO:Failed to get MDS master1."
                break
            fi

            #16ƵַʽתΪipv4͵ַ
            mdsMastertmp1=$MDSMaster1
            mdsMasterIP1=`hextoip "${mdsMastertmp1}"`
            LOG "[$FUNCNAME]mdsMasterIP1:$mdsMasterIP1"
            if [ "$mdsMasterIP1" == "" ];then
                LOG "[$FUNCNAME]:Failed to execute command(mds info show),get masterIp($mdsMastertmp1) err."
                Result="Failed to execute command(mds info show),get masterIp(${mdsMastertmp1}) err."
                isPass=1
                break
            fi

            MDSMaster2=`cat $G_TMP_FILE$Item | grep "root mds 2nd ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
            if [ "$MDSMaster2" == "" ];then
                isPass=1
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                Result="INFO:Failed to get MDS master2."
                break
            fi

            #16ƵַʽתΪipv4͵ַ
            mdsMastertmp2=$MDSMaster2
            mdsMasterIP2=`hextoip "${mdsMastertmp2}"`
            LOG "[$FUNCNAME]mdsMasterIP2:$mdsMasterIP2"
            if [ "mdsMasterIP2" == "" ];then
                LOG "[$FUNCNAME]:Failed to execute command(mds info show),get masterIp($mdsMastertmp2) err."
                Result="Failed to execute command(mds info show),get masterIp(${mdsMastertmp2}) err."
                isPass=1
                break
            fi
            >${VALID_IP_FILE}
            break
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
}
#216. ϵͳinodeBirth--
checkFileInodeAndBirthCount()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local faildInfo=""
    local MDSMaster=""
    local errResult=""
    local usedCapRate=0
    local exe_result1=""
    local exe_result2=""
    local exe_result3=""
    local exe_result4=""
    local exe_result5=""
    local tmpResult=""
    local CurInodeCount=0
    local MaxInodeCount=0
    local FileInodeCount=0
    local SysBirthCount=""
    local inodeRate=0
    local MDSMemory=0
    local ratio=0
    local maxBirthMem=0
    local maxBirthCount=0
    local safeBirthCount=0
    local isArchive=0
    local value1=0
    local value2=0
    local calBirthCount=0
    local isDfs=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    for Item in $REMOTE_IP_S
    do
        #1.checkڵ
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" == "1" ];then
            isDfs=1
            break
        else
            LOG "[$FUNCNAME]: $Item is not DFS node."
            continue
        fi
    done
    if [ ${isDfs} -eq 0 ];then
        isPass=3
        WRITE_XML_COMMON 0 "There is no DFS node."
        LOG "[$FUNCNAME]:There is no DFS node."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    while true; do
        back_ip=$( get_backnet_ip )
        if [ "$back_ip" = "" ];then
            isPass=1
            LOG "[FUNCNAME] Can't to get the backIP."
            WRITE_XML_ERROR 0 "Node:-(master)||INFO:Failed to get the backIP.ERRCODE(11)"
            break
        fi
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm system" >$G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ];then
            Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            LOG "[FUNCNAME] mml_result : $Info"
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to excute MML command(cm system),port(4016).return(${iRet}).ERRCODE(12)"
            break
        else
            dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
            content=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            if [ "$content" == "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to get the infomation form mml commmand(cm system).ERRCODE(13)"
            else
                #usedCapRate = Cluster_Used_Capacity / Cluster_Capacity * 100
                Cluster_Capacity=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Capacity"|awk -F: '{print $2}' )
                Cluster_Used_Capacity=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Used_Capacity"|awk -F: '{print $2}' )
                usedCapRate=$(echo ""|awk -v x=${Cluster_Used_Capacity} -v y=${Cluster_Capacity} '{printf("%0.2f",x*100/y)}')
                cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            fi
        fi
        mdsMasterIP=$( cat /proc/monc_leader | grep Mds | awk '{print $3}' )
        if [ "no" = "${mdsMasterIP}" ]; then
            LOG "[$FUNCNAME]:There is no mdsMasterIP in the S3 nodes"
            WRITE_XML_ERROR 0 "Does not involve in S3 nodes"
            break;
        fi
        #DFS ȡLeaderMdsĺIps
        getMdsMasterIps
        #MDS leader
        mdsMasterIP=$mdsMasterIP1
        LOG "[$FUNCNAME]mdsMasterIP:$mdsMasterIP"
        if [ "$mdsMasterIP" = "" ];then
            LOG "[$FUNCNAME]:Failed to execute function getMdsMasterIps,get masterIp err."
            WRITE_XML_ERROR 0 "Node:-(mdsMasterIP)||INFO:Failed to execute function getMdsMasterIps,get masterIp err.ERRCODE(4)"
            isPass=1
            break;
        fi

        #MDSִMMLinode, ִmml "mds info show" 'mds show lru'
        remote_exec $mdsMasterIP 60 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds show lru' > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
        iRet0=$?
        remote_exec $mdsMasterIP 30 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds info show' >> $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
        iRet1=$?
        if [ $iRet0 -ne 0 -o $iRet1 -ne 0 ];then
            #ڵ2Ipִmml
            if [ "$mdsMasterIP2" = "" ]; then
                LOG "[$FUNCNAME]:return($iRet0)($iRet1)"
                errResult="Node:$mdsMasterIP||INFO:Failed to execute mml command(mds info show & mds show lru),port(988).return($iRet0)($iRet1).ERRCODE(1)"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                break
            fi
            mdsMasterIP=$mdsMasterIP2
            remote_exec $mdsMasterIP 60 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds show lru' > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
            iRet0=$?
            remote_exec $mdsMasterIP 30 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds info show' >> $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
            iRet1=$?
        fi

        if [ $iRet0 -ne 0 -o $iRet1 -ne 0 ]; then
            LOG "[$FUNCNAME]:return($iRet0)($iRet1) "
            errResult="Node:$mdsMasterIP||INFO:Failed to execute mml command(mds info show & mds show lru),port(988).return($iRet0)($iRet1).ERRCODE(1)"
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
        fi

        #
        remote_download_sync $mdsMasterIP $G_TMP_FILE $G_REMOTE_TMP_FILE2$FUNCNAME
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]download inode infp from $mdsMasterIP fail"
            WRITE_XML_ERROR 0 "Node:$mdsMasterIP||INFO:download inode infp from $mdsMasterIP fail.ERRCODE(3)"
            break
        fi

        exe_result1=$( cat $G_TMP_FILE | grep '\(Cur Inode Count in Cluster\)\|\(Sys Inode Count\)' | dos2unix )
        exe_result2=$( cat $G_TMP_FILE | grep '\(Max Inode Count Support by Cluster\)' | dos2unix )
        exe_result3=$( cat $G_TMP_FILE | grep '\(Sys File Inode Count\)' | dos2unix )
        exe_result4=$( cat $G_TMP_FILE | grep '\(Sys Birth Count\)' | dos2unix )
        exe_result5=$( cat $G_TMP_FILE | grep "pstMemStat->stInitSpaceStat.ullPoolCanUseMaxSize"| dos2unix )
        LOG "[$FUNCNAME]exe_result1:$exe_result1"
        LOG "[$FUNCNAME]exe_result2:$exe_result2"
        LOG "[$FUNCNAME]exe_result3:$exe_result3"
        LOG "[$FUNCNAME]exe_result4:$exe_result4"
        LOG "[$FUNCNAME]exe_result5:$exe_result5"
        if [ "$exe_result1" == "" -o "$exe_result2" == "" -o "$exe_result3" == "" -o "$exe_result4" == "" -o "$exe_result5" == "" ];then
           errResult="Node:$mdsMasterIP||INFO:Failed to get Inode Count.ERRCODE(8)"
           WRITE_XML_ERROR 0 "${errResult}"
           isPass=1

           #
           cat $G_TMP_FILE >> $LOG_FILE 2>&1
        else
            CurInodeCount=$( echo $exe_result1 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            MaxInodeCount=$( echo $exe_result2 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            FileInodeCount=$( echo $exe_result3 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            SysBirthCount=$( echo $exe_result4 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            #inodeRate = Sys Inode Count / Max Inode Count Support by Cluster * 100
            inodeRate=$(echo ""|awk -v x=${CurInodeCount} -v y=${MaxInodeCount} '{printf("%0.2f",x*100/y)}')
            LOG "[$FUNCNAME],CurInodeCount:$CurInodeCount||MaxInodeCount:$MaxInodeCount||usedCapRate(%):$usedCapRate||inodeRate(%):$inodeRate||SysBirthCount:$SysBirthCount"

            if [ $(echo "$inodeRate > 90" | bc) -eq 1 ] && [ $(echo "$inodeRate > $usedCapRate" | bc) -eq 1 ];then
                isPass=1
                errResult="Node:$mdsMasterIP||INFO:InodePercentage(${inodeRate}) exceeds the threshold(90) and exceeds the CapacityPercentage($usedCapRate).ERRCODE(9)"
                WRITE_XML_ERROR 0 "${errResult}"
                #
                cat $G_TMP_FILE >> $LOG_FILE 2>&1
            fi

            #ȡǰMDSڴСMDSMemory,ִmml"mds show lru"
            MDSmemory=$( echo $exe_result5 | awk -F"=" '{print $2}'|sed 's/^ *//g'|sed "/^$/d")
            #ȡȺڵ
            nodeCount=$( cat /tmp/tmp_ip_role | awk '{print NF}' )
            #ȡȺĲ,ΪСļratio=0.58,Ϊ0.4 serviceType=archive
            tmpResult=$( cat /opt/huawei/snas/etc/snas.ini |grep "serviceType=")
            isArchive=$( cat /opt/huawei/snas/etc/snas.ini |grep "serviceType=archive" | wc -l)
            ratio=$(echo ""|awk -v x=${isArchive} -v y=0.58 -v z=0.4 '{printf("%0.2f", (x > 0 ? y : z))}')
            LOG "INFO: ${tmpResult} so ratio is ${ratio}"

            #㼯ȺBirthЧڴmaxBirthMem=MIN(MDSmemory*ratio+MDSmemory*ratio/(nodeCount-1),MDSmemory*0.5)
            value1=$(echo ""|awk -v x=${MDSmemory} -v y=${ratio} -v z=${nodeCount} '{printf("%0.0f",x*y+x*y/(z-1))}')
            value2=$(echo ""|awk -v x=${MDSmemory}  '{printf("%0.0f",x/2)}')
            maxBirthMem=$(echo ""|awk -v x=${value1} -v y=${value2} '{printf("%0.0f",(x > y ? y : x))}')

            #ЧmaxBirthCount = maxBirthMem/32*nodeCount
            maxBirthCount=$(echo ""|awk -v x=${maxBirthMem} -v y=${nodeCount} '{printf("%0.0f",x/32*y)}')

            #ԤƼȺBirthCount=(Sys Birth Count)*(0.9/ratio)
            calBirthCount=$(echo ""|awk -v x=${SysBirthCount} -v y=${ratio} '{printf("%0.0f",x*0.9/y)}')
            Result="CurInodeCount:$CurInodeCount||MaxInodeCount:$MaxInodeCount||usedCapRate(%):$usedCapRate||inodeRate(%):$inodeRate||SysBirthCount:$SysBirthCount || maxBirthCount:${maxBirthCount} ||calBirthCount:${calBirthCount}"
            LOG "[$FUNCNAME],isArchive:${isArchive} || nodCount:${nodeCount} || ratio:${ratio}|| MDSmemory:${MDSmemory} || maxBirthMem:${maxBirthMem}||maxBirthCount:${maxBirthCount}||calBirthCount:${calBirthCount}"

            if [ `expr $calBirthCount \* 2` -gt $maxBirthCount ];then
                isPass=1
                errResult="Node:$mdsMasterIP||INFO:calBirthCount($calBirthCount) > maxBirthCount($maxBirthCount/2).ERRCODE(9)"
                WRITE_XML_ERROR 0 "${errResult}"
            fi
            if [ $calBirthCount -ge 10000000000 ];then
                isPass=1
                errResult="Node:$mdsMasterIP||INFO:calBirthCount($calBirthCount) >= 10000000000.ERRCODE(9)"
                WRITE_XML_ERROR 0 "${errResult}"
            fi

        fi
        break
    done

    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#218. linuxϵͳ򿪵ļ
checkSystemFileOpened()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "cat /proc/sys/fs/file-nr > $G_REMOTE_TMP_FILE$FUNCNAME"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #ؽ/proc/sys/fs/file-nr
            remote_exec_checkfini $Item $TASK_ID "Can not get /proc/sys/fs/file-nr information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            usedunm=`cat $G_TMP_FILE$Item|awk '{print $1}'`
            unusedunm=`cat $G_TMP_FILE$Item|awk '{print $2}'`
            maxCount=`cat $G_TMP_FILE$Item|awk '{print $3}'`
            fileCount=`expr $usedunm + $unusedunm`

            LOG "[$FUNCNAME]:usedunm:$usedunm,unusedunm:$unusedunm,fileCount:$fileCount,maxCount:$maxCount"

            percentage=$(echo "scale=4; $fileCount*100/$maxCount"|bc -l| awk '{printf "%.4f", $0}')

            Result="Node:$Item||FileCount:$fileCount||MaxFileCount:$maxCount||Percentage(%):$percentage"
            percentage=`echo $fileCount*100/$maxCount|bc -l`
            if [ `echo "$percentage > 80" | bc` -eq 1  ];then
                isPass=1

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            fi

            WRITE_XML_COMMON 0 "$Result"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#219. NIS
checkNIS()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local TASK_ID=0
    local NisInfo=0
    local isExistFlag=0;
    local ypwhichinfo=""
    local errinfo=""
    local nisIp=""
    local pingResult=""
    local pingTag="ping"
    local pingCompare=0
    local masterFlag=0 #ǵһϷNIS server ipִpingΪ1Ϊ1ʾýڵipִйping
    local pline="p"

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "REMOTE_IP_S:$REMOTE_IP_S"

    for Item in $REMOTE_IP_S; do
        #checkڵͣDFSִ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            continue
        fi

        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowNisServer > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    iRet=$?

    remote_download_sync $Item $G_REMOTE_TMP_FILE$FUNCNAME$Item $G_REMOTE_TMP_FILE$FUNCNAME
    downCon=$(cat $G_REMOTE_TMP_FILE$FUNCNAME$Item)
    LOG "[$FUNCNAME]node:$Item, remote_exec NisServer iRet: $iRet, downCon: ${downCon}"

    if [ $iRet -ne 0 ] || [ "x${downCon}" == "x" ]; then
        continue
    fi

        set_ifs
        while read line; do
            info=`handle_remote_result "$line"`
            if [ $? -ne 0 ]; then
                isPass=1
            fi

            #жǷnis server
            NisInfo=`echo $info | grep "no nis_server"`
            if [ "$NisInfo" != "" ];then
                isExistFlag=1
            fi

            nisIpArr=$(echo $info|awk -F'(' '{print $2}'|awk -F')' '{print $1}')

        done < $G_REMOTE_TMP_FILE$FUNCNAME$Item
        restore_ifs

    break
    done

    #
    LOG "[$FUNCNAME]:isPass:$isPass,isExistFlag:$isExistFlag"
    cat $G_REMOTE_TMP_FILE$FUNCNAME$Item >> $LOG_FILE 2>&1

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
    #checkڵͣDFSִ
    local service_type=$(get_service_type_from_db "${Item}")
    if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            WRITE_XML_COMMON 0 "Node:$Item||NisIp:--||DFS:No||nis_server status:--"
            continue
    fi

    if [ "$isExistFlag" -eq 1 -a "${service_type}" == "1" ];then
            Result="Node:$Item||NisIp:--||DFS:Yes||nis_server status:no nis_server"
            WRITE_XML_COMMON 0 "$Result"
    fi

    echo -n "$Item " >> ${VALID_IP_FILE}
    done

    if [ "$isPass" -eq 0 ] && [ "$isExistFlag" -eq 0 ];then

        #Զִypwhich鿴
        ValidIP=$(cat "${VALID_IP_FILE}")

        for Item in $ValidIP
        do

            #鿴ÿڵ
            ypwhichinfo=$(remote_exec $Item 10 "ypwhich")
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME] $Item Failed to execute(free) command.iRet($iRet)"
                isPass=1

                Result="Node:$Item||NisIp:$nisIp||DFS:Yes||nis_server status:Can't communicate with ypbind.iRet($iRet)"
                WRITE_XML_COMMON 0 "$Result"
                continue
            fi

            errinfo=""
            errinfo=$(echo $ypwhichinfo | grep "Can't communicate with ypbind")
            if [ "$errinfo" != "" ]; then

                LOG "[$FUNCNAME]errinfo:$errinfo"
                Result="Node:$Item||NisIp:$nisIp||DFS:Yes||nis_server status:Can't communicate with ypbind"
                WRITE_XML_COMMON 0 "$Result"
                isPass=1
            else
                Result="Node:$Item||NisIp:$ypwhichinfo||DFS:Yes||nis_server status:ok"
                WRITE_XML_COMMON 0 "$Result"
            fi

        done
    fi

    if [ "$isPass" -eq 0 ] && [ "$isExistFlag" -eq 0 ];then

        #Զִping
        for Item in $ValidIP
        do
        remote_exec $Item 30 "> $G_REMOTE_TMP_FILE$FUNCNAME$pingTag  2>&1"
            for nisItem in $nisIpArr; do
                remote_exec $Item 30 "$G_MML_FILE_PATH/ShowPingResult $nisItem >> $G_REMOTE_TMP_FILE$FUNCNAME$pingTag  2>&1; exit 0"
            done
        done

        #Զping
        ValidIPResult=$ValidIP
        LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
        fifo_start
        for Item in $ValidIP
        do
            remote_download $Item $G_TMP_FILE$pingTag$Item $G_REMOTE_TMP_FILE$FUNCNAME$pingTag
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                errResult="Node: $Item||NisIp:$nisIp||ping status: remote download file($G_REMOTE_TMP_FILE$FUNCNAME$pingTag) failed."
                WRITE_XML_ERROR 0 "$errResult"
                continue
            fi
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$pingTag$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

        nisCnt=0
        masterFlag=0
            for nisIp in $nisIpArr
            do
                nisCnt=$((nisCnt+1))

                pingResult=$(sed -n $nisCnt$pline $G_TMP_FILE$pingTag$Item)
                if [ "$pingResult" == "" ];then
                    if [ $masterFlag -eq 0 ]; then
                        isPass=1
                    elif [ $masterFlag -eq 1 -a $isPass -eq 0 ]; then
                        isPass=4
                    fi
                    errResult="Node: $Item||NisIp:$nisIp||ping status:Failed to execute PING command||Ping:$pingResult"
                    WRITE_XML_ERROR 0 "$errResult"
                else
                    pingCompare=$(echo "$pingResult >= 200" | bc)
                    if [ $pingCompare -eq 1 ];then
                        if [ $isPass -eq 0 ]; then
                isPass=4
                        fi
                        errResult="Node: $Item||NisIp:$nisIp||ping status:Ping too large||Ping:$pingResult"
                        WRITE_XML_ERROR 0 "$errResult"
                    else
                        Result="Node: $Item||NisIp:$nisIp||ping status:ok||Ping:$pingResult"
                        WRITE_XML_ERROR 0 "$Result"
                    fi
                fi

                if [ $masterFlag -eq 0 ]; then
                    masterFlag=1
                fi
            done
        done

    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#255 keystone
checkKeyStone()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local TASK_ID=0
    local Result=""
    local isSwift=0
    #ȡڵ
    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        LOG "[$FUNCNAME]:INFO: Can't get local ip"
        WRITE_XML_ERROR 0 "INFO:Failed to get local ip."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 1
    fi
    local local_service_type=$(get_service_type_from_db "$back_ip")
    #ڵΪswiftڵ
    if [ "${local_service_type}" == "3" ]; then
        #ȡauth_host,auth_port, admin_tenant_name, admin_user, admin_passwordֵ
        swift_host_info=$( cat /opt/obs/obsconf/swift/proxy-server.ini |grep auth_host |awk -F'auth_host=' '{print $2}' )
        swift_port_info=$( cat /opt/obs/obsconf/swift/proxy-server.ini |grep auth_port |awk -F'auth_port=' '{print $2}' )
        admin_tenant_name_info=$( cat /opt/obs/obsconf/swift/proxy-server.ini |grep admin_tenant_name |awk -F'admin_tenant_name=' '{print $2}' )
        admin_user_info=$( cat /opt/obs/obsconf/swift/proxy-server.ini |grep admin_user |awk -F'admin_user=' '{print $2}' )
        LOG "[$FUNCNAME]:swift_host:$swift_host_info||swift_port:$swift_port_info||admin_tenant_name:$admin_tenant_name_info||admin_user:$admin_user_info"
        if [ "$swift_host_info" == "" ] || [ "$swift_port_info" == "" ] || [ "$admin_tenant_name_info" == "" ] || [ "$admin_user_info" == "" ]; then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$back_ip||INFO:Failed to get keystone info"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 1
        fi
    fi
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "cat /opt/obs/obsconf/swift/proxy-server.ini > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #checkڵ
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "3" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi
            isSwift=1
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not keystone information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                echo "FlagDownfail" >> $G_TMP_FILE$Item 2>&1
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    if [ $isSwift -eq 1 ];then

        for Item in $ValidIPResult; do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "3" ]; then
                continue
            fi

            FlagDownfail=`cat $G_TMP_FILE$Item |grep FlagDownfail`
            if [ "$FlagDownfail" != "" ];then
                LOG "[$FUNCNAME]:IP:$Item,Down file fail"
                continue
            fi

            node_swift_host=$( cat $G_TMP_FILE$Item | grep auth_host |awk -F'auth_host=' '{print $2}' )
            node_swift_port=$( cat $G_TMP_FILE$Item | grep auth_port |awk -F'auth_port=' '{print $2}' )
            node_admin_tenant_name=$( cat $G_TMP_FILE$Item | grep admin_tenant_name |awk -F'admin_tenant_name=' '{print $2}' )
            node_admin_user=$( cat $G_TMP_FILE$Item | grep admin_user |awk -F'admin_user=' '{print $2}' )
            Result="Node:$Item||node_swift_host:$node_swift_host||node_swift_port:$node_swift_port||admin_tenant_name:$node_admin_tenant_name||admin_user:$node_admin_user"
            LOG "[$FUNCNAME]:Result:$Result"
            WRITE_XML_COMMON 0 "$Result"
            #Ϊ
            if [ "$node_swift_host" == "" ] || [ "$node_swift_port" == "" ] || [ "$node_admin_tenant_name" == "" ] || [ "$node_admin_user" == "" ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:node_swift_host($node_swift_host) is empty or node_swift_port($node_swift_port) is empty or admin_tenant_name($node_admin_tenant_name) is empty or admin_user($node_admin_user) is empty.ERRCODE(5)"
                break
            fi
        done
    fi
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#220 ⲿDNSǷͨ
checkExtDnsConn()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    local AllDnsService=""
    local DnsNum=0
    local errResult=""
    local Result=""
    local Item=""
    local ValidIP=""
    local extDnsServe=""
    local serverConn=""
    local pingResult=""
    local numCnt=1
    local pingTag="ping"
    local pingCompare=0
    local DnsCnt=0
    local service_type=0
    local ipflag=0
    local frontiptype=0
    local FLAG=1
    local isOMnetflag=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="INFO: Can't get local ip"
            LOG "[$FUNCNAME]:$errResult"
            isPass=1
            break
        fi
        AllDnsService=`cat /etc/resolv.conf | grep ^nameserver | awk '{print $2}' | grep -E '^[0-9a-fA-F:.]+$'`
        #ȡⲿDNSûΪͨ
        DnsNum=`echo "$AllDnsService" | wc -l`
        #ڵS3ڵ漰

        LOG "[$FUNCNAME]:AllDnsService:$AllDnsService,DnsNum:$DnsNum"
        if [ "$DnsNum" -le "0" ] || [ "$AllDnsService" == "" ] ;then
            FLAG=0

            Result="DNS_server: -- ||INFO: DNS server does not exist"

            WRITE_XML_COMMON 0 "$Result"
            cat /etc/resolv.conf >>  $LOG_FILE

            break
        fi
        local netflag=0 #ǰIPֻIPV4IPV6ַΪ0ͬʱΪ1
        local oldnodeiptype=-1
        for Item in $REMOTE_IP_S; do
            frontiptype=$(get_frontip_type "${Item}")
            if [ "$oldnodeiptype" == -1 ];then
                oldnodeiptype=$frontiptype
            fi
            if [ "$oldnodeiptype" -eq "$frontiptype" ];then
                continue
            else
                LOG "[$FUNCNAME]:the network is IPV4 and IPV6"
                netflag=1
                break
            fi
            LOG "[$FUNCNAME]:the network is only IPV4 or IPV6"
        done

        extDnsServe=""
        serverConn=""
        numCnt=1
        while [ $numCnt -le $DnsNum ]; do

            extDnsServe=` echo $AllDnsService | awk '{print $ '$numCnt'}'`

            #״̬
            if [ "$extDnsServe" == "" ];then
                LOG "[$FUNCNAME]:failed numCnt:$numCnt,NS server is NULL"

                numCnt=$((numCnt+1))
                continue
            fi

            #ڵжdns############################################################################
            >${VALID_IP_FILE}
            #жIPͣV4ͺС::ffff:͡.ַ::ffff:100.1.1.1;ipflag=1ʾIPV40ʾIPV6
            echo $extDnsServe|grep "::ffff:"|grep "\." > /dev/null
            if [ $? -eq 0 ];then
                extDnsServe=$(echo $extDnsServe|sed 's/::ffff://g')
                ipflag=1
            else
                #ipv6
                ipflag=0
            fi
            #жDNS IPǷڹ,isOMnetflag=1˵DNSǰ
            isOMnet=$(cat /opt/huawei/deploy/script/deploy_source_route.sh |grep -w $extDnsServe |grep om1)
            if [ "$isOMnet" == "" ];then
                isOMnetflag=1
            fi
            TASK_ID=$numCnt

            remote_exec_async_batch $TASK_ID 30 "/usr/bin/host test $extDnsServe > $G_REMOTE_TMP_FILE$FUNCNAME$numCnt  2>&1; exit 0"

            ValidIP=`cat ${VALID_IP_FILE}`
            ValidIPResult=$ValidIP

            LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

            fifo_start
            while [ "${ValidIP}" != "" ]; do
                >${VALID_IP_FILE}

                for Item in $ValidIP; do
                    service_type=$(get_service_type_from_db "${Item}")
                    if [ "${service_type}" != "1" ];then
                       LOG "service_type = ${service_type}.skip ${Item}."
                       errResult="Does not involve"
                       WRITE_XML_COMMON 0 "Node:$Item||DNS_server:--||INFO:$errResult"
                       continue
                    fi

                    dfsFlag=1

                    #ѯ
                    remote_exec_checkfini $Item $TASK_ID "Can not DNS($extDnsServe) link status"
                    iRet=$?

                    if [ $iRet -eq 0 ];then
                        echo -n "$Item " >> ${VALID_IP_FILE}
                        continue
                    elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                        LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd(/usr/bin/host test $extDnsServe) failed."
                        isPass=1
                        continue
                    fi

                    remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME$numCnt
                    iRet=$?
                    if [ $iRet -ne 0 ];then
                        isPass=1
                        errResult="Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME$numCnt) failed."
                        WRITE_XML_ERROR 0 "$errResult"
                        continue
                    fi
                done
                ValidIP=`cat ${VALID_IP_FILE}`
            done

            wait
            fifo_finish



            for Item in $ValidIPResult; do
                    if [ $dfsFlag = 0 ]; then
                        continue
                    fi
                    #DNSΪڵʱ򣬹˷ڵļ
                    if [ $isOMnetflag = 0 ];then
                        if [ "$Item" != "$back_ip" ];then
                            continue
                        fi
                    fi

                    service_type=$(get_service_type_from_db "${Item}")
                    if [ "${service_type}" != "1" ]; then
                        continue
                    fi

                    fifoContext=`cat $G_TMP_FILE$Item`
                    if [ "$fifoContext" = "" ];then
                        continue
                    fi
                    frontiptype=$(get_frontip_type "${Item}")
                    if [ $netflag -eq 1 ];then
                        if [ $ipflag -ne $frontiptype ];then
                            continue
                        fi
                    fi
                    #жǷͨ

                    serverConn=`cat $G_TMP_FILE$Item|grep "Using domain server"|wc -l`
                    if [ $serverConn -eq 0 ]
                    then
                        isPass=1
                        Result="DNS_server: $extDnsServe||INFO: DNS server is not connectable."
                        WRITE_XML_COMMON 0 "Node:$Item||$Result"

                        #
                        LOG "[$FUNCNAME]:/usr/bin/host test $extDnsServe result:"
                        cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

                    else
                        Result="DNS_server: $extDnsServe||INFO: DNS server is connectable."
                        WRITE_XML_COMMON 0 "Node:$Item||$Result"
                    fi
            done
            DnsCnt=`echo "$AllDnsService" | grep -v "^$" | wc -l`
            if [ "$isPass" -eq 0 ] && [ "$DnsCnt" -gt 0 ];then
            #Զִping
            ValidIP=`cat $IP_ROLE_FILE`

        while [[ ${ValidIP} != "" ]]
        do
            for Item in $ValidIP
            do
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi
            if [ $ipflag -eq 1 ];then
                remote_exec_async $Item $TASK_ID 30 "ping $extDnsServe -c 2|grep avg|awk -F= '{print \$2}'|awk -F/ '{print \$2}' > $G_REMOTE_TMP_FILE$FUNCNAME$pingTag$numCnt  2>&1; exit 0"
            else
                remote_exec_async $Item $TASK_ID 30 "ping6 $extDnsServe -c 2|grep avg|awk -F= '{print \$2}'|awk -F/ '{print \$2}' > $G_REMOTE_TMP_FILE$FUNCNAME$pingTag$numCnt  2>&1; exit 0"
            fi
            done
            ValidIP=`cat ${VALID_IP_FILE}`
        done

        #ȴping
        sleep 10

        #Զping
        ValidIP=`cat $IP_ROLE_FILE`
        ValidIPResult=$ValidIP
        LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
        fifo_start
        while [[ ${ValidIP} != "" ]]
        do
            for Item in $ValidIP
            do
                #S3ڵ㲻漰
                service_type=$(get_service_type_from_db "${Item}")
                if [ "${service_type}" != "1" ];then
                    LOG "service_type = ${service_type}.skip ${Item}."
                    continue
                fi

                dfsFlag=1

                remote_download $Item $G_TMP_FILE$pingTag$Item $G_REMOTE_TMP_FILE$FUNCNAME$pingTag$numCnt
                iRet=$?
                if [ $iRet -ne 0 ];then
                    isPass=1
                    errResult="Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME$pingTag$numCnt) failed."
                    WRITE_XML_ERROR 0 "$errResult"
                    continue
                fi
            done
            ValidIP=`cat ${VALID_IP_FILE}`
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
                if [ $dfsFlag = 0 ]; then
                    continue
                fi
                #DNSΪڵʱ򣬹˷ڵļ
                if [ $isOMnetflag = 0 ];then
                    if [ "$Item" != "$back_ip" ];then
                        continue
                    fi
                fi

                service_type=$(get_service_type_from_db "${Item}")
                if [ "${service_type}" != "1" ]; then
                    continue
                fi

                pingResult=`cat $G_TMP_FILE$pingTag$Item`
                if [ "$pingResult" = "" ];then
                    continue
                fi
                frontiptype=$(get_frontip_type "${Item}")
                if [ $netflag -eq 1 ];then
                if [ $ipflag -ne $frontiptype ];then
                    continue
                    fi
                fi
                if [ "$pingResult" == "" ];then
                    isPass=1
                    errResult="Node: $Item||DNS_server: $extDnsServe||Ping:$pingResult||INFO:Failed to execute PING command."
                    WRITE_XML_ERROR 0 "$errResult"
                else
                    pingCompare=`echo "$pingResult >= 200" | bc`
                    if [ $pingCompare -eq 1 ];then
                        isPass=4
                        errResult="Node: $Item||DNS_server: $extDnsServe||Ping:$pingResult||INFO:Ping too large."
                        WRITE_XML_ERROR 0 "$errResult"
                    fi
                fi
            done

        fi

        ######################################################################################

        numCnt=$((numCnt+1))
        done

        #˳while
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#221. LDAP
checkLDAP()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local dfsFlag=0
    local ldapIp=""
    local pingResult=""
    local errResult=""
    local pingCompare=0
    local TASK_ID=2
    local basedn=""  #Ըڵ㣬ļһʱֵ
    local portnum="" #Ըڵ㣬ļһʱֵ
    local masterFlag=0 #ǵһϷLDAP server ipִpingΪ1Ϊ1ʾýڵipִйping
    local frontiptype=0
    local ipflag=0
    local FLAG=1

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/ShowLdapServer > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ 0 -ne $? ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            #s3 judge
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_COMMON 0 "Node:${Item}||DFS:No||ldap_server_ip:--||ldap_server_basedn:--||ldap_server_portnum:--||ldap_server_status:--"
                continue
            fi

            dfsFlag=1

            LOG "[$FUNCNAME]:IP:$Item"
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get ldap information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="IP: $Item||Error: exec (checkLDAP) failed.iRet($iRet),errno($errno)!||${errResult}"
                LOG "[$FUNCNAME]$Item exec(check LDAP failed.iRet($iRet),errno($errno)!"
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    local netflag=0 #ǰIPֻIPV4IPV6ַΪ0ͬʱΪ1
    local oldnodeiptype=-1
    for Item in $ValidIPResult; do
        frontiptype=$(get_frontip_type "${Item}")
        if [ "$oldnodeiptype" == -1 ];then
            oldnodeiptype=$frontiptype
        fi
        if [ "$oldnodeiptype" -eq "$frontiptype" ];then
            continue
        else
            LOG "[$FUNCNAME]:the network is IPV4 and IPV6"
            netflag=1
            break
        fi
        LOG "[$FUNCNAME]:the network is only IPV4 or IPV6"
    done

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item
            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            frontiptype=$(get_frontip_type "${Item}")


        #ÿڵ㴦ļǰֵʼ
            masterFlag=-1
            basedn=""
            portnum=""
            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"
                else
                    #жϵǰǷldap server
                    ldap_server=$(echo $info|grep -w "no ldap_server")
                    if [ "$ldap_server" != "" ];then
                        WRITE_XML_COMMON 0 "Node:${Item}||DFS:Yes||ldap_server_ip:no ldap_server||ldap_server_basedn:no ldap_server||ldap_server_portnum:no ldap_server||ldap_server_status:no ldap_server"
                        FLAG=0
                        break
                    fi

                    #ǰضldap server
                    ldap_server_ip=$(echo $info|grep -w "ldap_server_ip"|awk -F '\\|\\|' '{print $1}'|awk '{print $2}')
                    ldap_server_basedn=$(echo $info|grep -w "ldap_server_basedn"|awk -F '\\|\\|' '{print $2}'|awk -F ':' '{print $3}')
                    ldap_server_portnum=$(echo $info|grep -w "ldap_server_portnum"|awk -F '\\|\\|' '{print $3}'|awk -F ':' '{print $3}')

                    ldap_server_status=$(echo $info|grep -w "status")
                    ldapIp=`echo $info|grep -w "status"|awk -F"status" '{print $1}'`
                    ldapIp_vaild=$(echo $info|grep -w "status ok")

                    #жǷΪϢĵһУbasednportnumcontinueһ
                    if [ "${ldap_server_ip}" != "" ];then
                        basedn=$ldap_server_basedn
                        portnum=$ldap_server_portnum
                        continue
                    fi
                    #ldapIpΪյУV4pingV6 ײֶ
                    if [ "${ldapIp}" == "" ];then
                       continue
                    fi
                    #masterFlagΪ0
                    masterFlag=$((masterFlag+1))
                    #Ź˲ͬ͵صַ
                    if [ $netflag -eq 1 ];then
                        #ǰLDAPIPͲһֱӹ
                        echo $ldapIp |grep -q "\:" >/dev/dull
                        ipflag=$?
                        if [ $ipflag -ne $frontiptype ];then
                            LOG "ipflag=$ipflag;frontiptype=$frontiptype"
                            continue
                        fi
                    fi
                    if [ "${ldapIp}" != "" ];then
                        #ÿһldap server ip ֱӡϢ
                        WRITE_XML_COMMON 0 "Node:${Item}||DFS:Yes||ldap_server_ip:${ldapIp}||ldap_server_basedn:${basedn}||ldap_server_portnum:${portnum}||ldap_server_status:$ldap_server_status"
                    fi
                    FLAG=0

                    #ǰip״̬:status err. һip
                    if [ "x$ldapIp_vaild" == "x" ];then
                        if [ $masterFlag -eq 0 ];then
                            isPass=1
                            LOG "masterFlag=$masterFlag  isPass=$isPass"
                        elif [ $masterFlag -ne 0 -a $isPass -eq 0 ]; then
                            isPass=4
                        fi

                        continue
                    fi

                    remote_exec $Item 30 "$G_MML_FILE_PATH/ShowPingResult $ldapIp > $G_REMOTE_TMP_FILE$FUNCNAME$Item 2>&1"
            if [ $? -ne 0 ]; then
                        if [ $masterFlag -eq 0 ];then
                            isPass=1
                        elif [ $masterFlag -ne 0 -a $isPass -eq 0 ]; then
                            isPass=4
                        fi

                        WRITE_XML_ERROR 0 "Node:${Item}||LDAP:$ldapIp||INFO:Failed to execute ShowPingResult||Ping:"
                        continue
            fi

                    remote_download_sync $Item $G_REMOTE_TMP_FILE$FUNCNAME$Item$Item $G_REMOTE_TMP_FILE$FUNCNAME$Item
                    if [ $? -ne 0 ]; then
                        if [ $masterFlag -eq 0 ];then
                            isPass=1
                        elif [ $masterFlag -ne 0 -a $isPass -eq 0 ]; then
                            isPass=4
                        fi
                        WRITE_XML_ERROR 0 "Node:${Item}||LDAP:$ldapIp||INFO:Failed to execute remote_download||Ping:"
                        continue
                    fi
                    pingResult=$(sed -n 1p $G_REMOTE_TMP_FILE$FUNCNAME$Item$Item)
                    if [ "$pingResult" == "" ];then
                        if [ $masterFlag -eq 0 ];then
                            isPass=1
                        elif [ $masterFlag -ne 0 -a $isPass -eq 0 ]; then
                            isPass=4
                        fi
                        WRITE_XML_ERROR 0 "Node:${Item}||LDAP:$ldapIp||INFO:Failed to execute PING command||Ping:$pingResult"
                    else
                        pingCompare=`echo "$pingResult >= 200" | bc`
                        if [ $pingCompare -eq 1 ];then
                            if [ $isPass -eq 0 ];then
                                isPass=4
                            fi
                            WRITE_XML_ERROR 0 "Node:${Item}||LDAP:$ldapIp||INFO:Ping too large||Ping:$pingResult"
                        else
                            WRITE_XML_ERROR 0 "Node:${Item}||LDAP:$ldapIp||INFO:Ping normal||Ping:$pingResult"
                        fi
                    fi

                fi
            done < $G_TMP_FILE$Item
            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

checkOMIPandIPMIinOneNet()
{
	local omip_v4_gw=""
    local ipmi_v4_gw=""
    local omip_mask_v4=""
    local ipmi_mask_v4=""
	local omip_v6_gw=""
    local ipmi_v6_gw=""
    local omip_mask_v6=""
    local ipmi_mask_v6=""
	local ipmi_ip_v6_prefix_tmp=""
	local ret=0

	$G_MML_FILE_PATH/GetIPMIAddress >/etc/null 2>&1

	omip_v4_gw=`cat /opt/huawei/snas/etc/cm.ini|grep -w omGateway|awk -F= '{print $2}' |tr -d ' '`
    ipmi_v4_gw=`cat /tmp/tmpfilecheckIPMI|grep -w "Default Gateway IP"|awk -F: '{print $2}' | tr -d ' '`
    omip_mask_v4=`cat /opt/huawei/snas/etc/cm.ini |grep -w omNetMask|awk -F= '{print $2}' | tr -d ' '`
    ipmi_mask_v4=`cat /tmp/tmpfilecheckIPMI|grep -w "Subnet Mask"|awk -F: '{print $2}' |tr -d ' '`
	LOG "[$FUNCNAME]omip_v4_gw: $omip_v4_gw,ipmi_v4_gw: $ipmi_v4_gw,omip_mask_v4: $omip_mask_v4,ipmi_mask_v4: $ipmi_mask_v4"
	omip_v6_gw=`cat /opt/huawei/snas/etc/cm.ini|grep -w omGateway_v6|awk -F= '{print $2}' |tr -d ' '`
    ipmi_v6_gw=`cat /tmp/tmpfilecheckIPMI | grep -w "ipmi_ipv6_gateway" | awk -F: '{print $2}'| tr -d ' '`
    omip_mask_v6=`cat /opt/huawei/snas/etc/cm.ini |grep -w omNetMask_v6|awk -F= '{print $2}' | tr -d ' '`
    ipmi_ip_v6_prefix_tmp=`cat /tmp/tmpfilecheckIPMI | grep -w "ipmi_ipv6_prefix" | awk -F: '{print $2} ' `
	ipmi_mask_v6="`printf %d 0x0$ipmi_ip_v6_prefix_tmp`"
	LOG "[$FUNCNAME]omip_v6_gw: $omip_v6_gw,ipmi_v6_gw: $ipmi_v6_gw,omip_mask_v6: $omip_mask_v6,ipmi_mask_v6: $ipmi_mask_v6"
	if [ "$omip_v4_gw" == "$ipmi_v4_gw" -a "$omip_mask_v4" == "$ipmi_mask_v4" ];then
	    ret=1;
	fi
	if [ "$omip_v6_gw" == "$ipmi_v6_gw" -a "$omip_mask_v6" == "$ipmi_mask_v6" -a "$ipmi_mask_v6" != "0" ];then
	    ret=1;
	fi

	return $ret
}
#222. ڵIPMIַ
checkIPMI()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isFlag=1
    local filename="checkIPMI"
    local TASK_ID=0
    local isPass=0
    local isSameNet=1
    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')

    #жOMIPIPMIǷΪһ
    checkOMIPandIPMIinOneNet
    isSameNet=$?
    if [ $isSameNet -eq 0 ];then
        errResult="BMC network and Manage network is not in the same network segment!"
        WRITE_XML_ERROR 0 "$errResult"
        WRITE_XML_JUDGE 0
    else
        set_ifs
        #ȡصomip
        OMIPV4Address=`cat /opt/huawei/snas/etc/cm.ini|grep -w omip|awk -F= '{print $2}'`
        OMIPV6Address=`cat /opt/huawei/snas/etc/cm.ini|grep -w omip_v6|awk -F= '{print $2}'`
        LOG "[$FUNCNAME]OMIPV4Address: $OMIPV4Address,OMIPV6Address: $OMIPV6Address"
        restore_ifs

        REMOTE_IP_S=$(cat "${IP_ROLE_FILE}")

        >${VALID_IP_FILE}
        for Item in $REMOTE_IP_S; do
            remote_exec ${Item} 30 "cat /opt/huawei/deploy/etc/deploy.ini | grep devicename | grep \"9000 C72 Node\" >> /dev/null 2>&1"
            if [ $? -ne 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            fi
            WRITE_XML_ERROR 0 "Node:$Item(C72 node)||IPMI:--||ConnectingStatus:--"
        done

        REMOTE_IP_S=$(cat "${VALID_IP_FILE}")

        remote_exec_async_batch $TASK_ID 300 "$G_MML_FILE_PATH/GetIPMIAddress  2>&1"
        isPass=$?

        ValidIP=`cat ${VALID_IP_FILE}`
        ValidIPResult=$ValidIP

        LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

        fifo_start
        while [[ ${ValidIP} != "" ]]
        do
            >${VALID_IP_FILE}

            for Item in $ValidIP
            do
                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "Can not get GetIPMIAddress information"
                iRet=$?

                if [ $iRet -eq 0 ];then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                    isPass=1
                    continue
                fi

                #ű̶ѽд$G_REMOTE_TMP_FILE$Item
                remote_download $Item $G_TMP_FILE$Item /tmp/tmpfile$filename
                iRet=$?
                if [ $iRet -ne 0 ];then
                    isPass=1
                    continue
                fi
            done
            ValidIP=`cat ${VALID_IP_FILE}`
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            #IPMIַ
            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            connectState_v4=""
            ipmi_ip_v4=`cat $G_TMP_FILE$Item |grep "IP Address"|grep -v Source|awk '{print $4}'`
            connectState_v6=""
            ipmi_ip_v6=`cat $G_TMP_FILE$Item | grep "ipmi_ipv6_address:" | awk -F'ipmi_ipv6_address:' '{print $2}'`
            if [ "$ipmi_ip_v4" == "" -o "$ipmi_ip_v4" == "0.0.0.0" ];then
			    ipmi_ip_v4="--"
                connectState_v4="no IPMI"
			fi
			if [ "$ipmi_ip_v6" == "" -o "$ipmi_ip_v6" == "null" -o "$ipmi_ip_v6" == "::" ];then
			    ipmi_ip_v6="--"
                connectState_v6="no IPMI"
			fi
			if [ "$ipmi_ip_v4" == "--" ] && [ "$ipmi_ip_v6" == "--" ];then
                errResult="Node: $Item||Error: can not get IPMI address!||$errResult"
                LOG "[$FUNCNAME] $Item:can not get IPMI address!"
                isPass=1
            fi
            if [ "$ipmi_ip_v4" != "--" ] ;then
                #ͨomip ping ipmi 
                for time in ${RepeatTimes[*]}; do
                    tempStr_ping_v4=`ping -q -c 1 $ipmi_ip_v4 |grep "1 received" |wc -l`
                    local iRet=$?
                    if [ $iRet -ne 0 ];then
                        sleep 10
                    else
                        break
                    fi
                done
                LOG "Node:$Item, ipmi:$ipmi_ip_v4,omipv4:$OMIPV4Address,tempStr_ping_v4:$tempStr_ping_v4"
                if [ "0" != "$tempStr_ping_v4" ];then
                    connectState_v4="OK"
                    else
                    connectState_v4="Can not access."
                    isPass=1
                    fi
            fi
            if [ "$ipmi_ip_v6" != "--" ];then
                #ͨomip ping ipmi 
                for time in ${RepeatTimes[*]}; do
                    tempStr_ping_v6=`ping6 -q -c 1 $ipmi_ip_v6 |grep "1 received" |wc -l`
                local iRet=$?
                if [ $iRet -ne 0 ]; then
                    sleep 10
                else
                    break
                fi
                done
                LOG "Node:$Item, ipmi:$ipmi_ip_v6,omipv6:$OMIPV6Address,tempStr_ping_v6:$tempStr_ping_v6"
                if [ "0" != "$tempStr_ping_v6" ];then
                    connectState_v6="OK"
                else
                    connectState_v6="Can not access."
                    isPass=1
                fi
            fi

            Result="Node:$Item||IPMI_IPV4:$ipmi_ip_v4||IPMI_IPV6:$ipmi_ip_v6||ConnectingStatus_IPV4:$connectState_v4||ConnectingStatus_IPV6:$connectState_v6"
            LOG "[$FUNCNAME]Node:$Item(Not C72 node)||$Result"

            WRITE_XML_COMMON 0 "$Result"
        done

        if [ "${isPass}" == "0" ];then
            WRITE_XML_JUDGE 0
        else
            WRITE_XML_ERROR 0 "$errResult"
            WRITE_XML_JUDGE 1
        fi
	fi
    WRITE_XML_SUBCMD_TAIL
}

#DiskPoolֵ
Checkdiskpoolcap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local PoolType=""
    local PoolTypeindex=0
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local isok=0

    dos2unix $G_TMP_FILE$Item

    TierInfoCount=`cat $G_TMP_FILE$Item | grep "DiskPool"|wc -l`
    LOG "[$FUNCNAME]TierInfoCount:$TierInfoCount"

    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=`cat $G_TMP_FILE$Item | grep DiskPool | sed -n "$index"p`
        PoolTypeindex=`cat $G_TMP_FILE$Item | grep -A12 -E "${HeadInfo}"$ | grep PoolType | awk -F: '{print $2}'`
        PoolType="SSD"
        if [ "$PoolTypeindex" == "1" ]; then
            PoolType="HDD"
        fi

        TotalCap=`cat $G_TMP_FILE$Item | grep -A12 -E "${HeadInfo}"$ | grep TotalCap | awk -F: '{print $2}'`
        LeftCap=`cat $G_TMP_FILE$Item | grep -A12 -E "${HeadInfo}"$ | grep LeftCap | awk -F: '{print $2}'`

        UsedCap=`echo $TotalCap-$LeftCap|bc -l`
        if [ "$TotalCap" == "0" ]; then
            Percentage=0
        else
            Percentage=$(echo "scale=4; $UsedCap/$TotalCap*100"|bc -l| awk '{printf "%.4f", $0}')
        fi
        LOG "[$FUNCNAME]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:"$PoolType" "$HeadInfo"||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "$Result"
        if [ "$TotalCap" != "0" ]; then
            Percentage=`echo $UsedCap/$TotalCap*100|bc -l`
        fi
        if [ `echo "$Percentage > 75.0" | bc` -eq 1 ]; then
            LOG "[$FUNCNAME]:$isok"
            isok=1
        fi

        index=$((index + 1 ))
    done

    return $isok
}

#NodePoolֵ
CheckNodePoolCap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local isok=0

    dos2unix $G_TMP_FILE$Item

    TierInfoCount=`cat $G_TMP_FILE$Item | grep "NodePool"|wc -l`
    LOG "[$FUNCNAME]TierInfoCount:$TierInfoCount"

    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=`cat $G_TMP_FILE$Item | grep NodePool | awk NR==$index`

        TotalCap=`cat $G_TMP_FILE$Item | grep -A4 -E "$HeadInfo"$ | grep TotalCap | awk -F: '{print $2}'`
        LeftCap=`cat $G_TMP_FILE$Item | grep -A4 -E "$HeadInfo"$ | grep LeftCap | awk -F: '{print $2}'`

        UsedCap=`echo $TotalCap-$LeftCap|bc -l`
        if [ "$TotalCap" == "0" ]; then
            Percentage=0
        else
            Percentage=$(echo "scale=4; $UsedCap/$TotalCap*100"|bc -l| awk '{printf "%.4f", $0}')
        fi

        LOG "[$FUNCNAME]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:$HeadInfo||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "$Result"
        if [ "$TotalCap" != "0" ]; then
            Percentage=`echo $UsedCap/$TotalCap*100|bc -l`
        fi
        if [ `echo "$Percentage > 75.0" | bc` -eq 1 ];then
            LOG "[$FUNCNAME]:$isok"
            isok=1
        fi

        index=$((index + 1 ))
    done

    return $isok
}

#Tiercapֵ
CheckTierCap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local isok=0

    dos2unix $G_TMP_FILE$Item

    TierInfoCount=`cat $G_TMP_FILE$Item | grep "Tier"|wc -l`
    LOG "[$FUNCNAME]TierInfoCount:$TierInfoCount"
    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=`cat $G_TMP_FILE$Item | grep Tier | awk NR==$index`

        TotalCap=`cat $G_TMP_FILE$Item | grep -A4 -E "$HeadInfo"$ | grep TotalCap | awk -F: '{print $2}'`
        LeftCap=`cat $G_TMP_FILE$Item | grep -A4 -E "$HeadInfo"$ | grep LeftCap | awk -F: '{print $2}'`

        UsedCap=`echo $TotalCap-$LeftCap|bc -l`
        if [ "$TotalCap" == "0" ]; then
            Percentage=0
        else
            Percentage=$(echo "scale=4; $UsedCap/$TotalCap*100"|bc -l| awk '{printf "%.4f", $0}')
        fi

        LOG "[$FUNCNAME]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:$HeadInfo||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "$Result"
        if [ "$TotalCap" != "0" ]; then
            Percentage=`echo $UsedCap/$TotalCap*100|bc -l`
        fi
        if [ `echo "$Percentage > 75.0" | bc` -eq 1 ];then
            LOG "[$FUNCNAME]:$isok"
            isok=1
        fi

        index=$((index + 1 ))
    done

    return $isok
}

#223.ּ
checkTier()
{
    WRITE_XML_SUBCMD_HEADER $1
    local count=0
    local Result=""
    local isPass=0
    local Item=""

    while true; do
        #ȡmonĵַ
        set_ifs

        AllItem=`cat /proc/monc_monmap | grep ipaddr_ | awk -F "=" '{print $2}'`
        for Item in $AllItem
        do
            remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon' > $G_REMOTE_TMP_FILE$FUNCNAME[Tier] 2>&1"
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]can't get mon info"
            else
                LOG "[$FUNCNAME]:MonIP:$Item"
                break
            fi
        done

        #ִmon tiercap 0
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon tiercap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[Tier] 2>&1"
        remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[Tier]
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]can't get TierCap info"
            WRITE_XML_COMMON 0 "MonMaster:$Item||INFO: can't get TierCap info"
        else
            #
            CheckTierCap
            if [ $? -ne 0 ]; then
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi

        #ִmon nodepoolcap 0
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon nodepoolcap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[NODE] 2>&1"
        remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[NODE]
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]can't get nodepoolcap info"
            WRITE_XML_COMMON 0 "MonMaster:$Item||INFO: can't get nodepoolcap info"
        else
            #
            CheckNodePoolCap
            if [ $? -ne 0 ]; then

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi

        #ִmon diskpoolcap 0
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon diskpoolcap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[DISK] 2>&1"
        remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[DISK]
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]can't get diskpoolcap info"
            WRITE_XML_COMMON 0 "MonMaster:$Item||INFO: can't get diskpoolcap info"
        else
            #
            Checkdiskpoolcap
            if [ $? -ne 0 ]; then

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi

        restore_ifs
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#224Ƿδĸ澯
checkLeftAlarm_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local value
    local iRet=0

    set_ifs
    #ѯδĸ澯δδָδѻָ2״̬
    for((i=0;i<3;++i));do
        sqlite3 /opt/huawei/snas/etc/cm_alarm_record.db 'select ALMID from CM_ALARM_RECORD_T where ALMTYPE=0 and (ALMSTATUS=1 or ALMSTATUS=3);' >$G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -eq 0 ]; then
            LOG "[$FUNCNAME]times=$i,iRet=$iRet:get alarm information success!"
            break;
        else
            LOG "[$FUNCNAME]times=$i,iRet=$iRet:can't get alarm information!"
            sleep 5
        fi
    done
    if [ $iRet -ne 0 ]; then
        WRITE_XML_COMMON 0 "Error: can't get alarm information!"
        LOG "[$FUNCNAME]$IPAddress:can't get alarm information!"
        isPass=1
    else
        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        alarmInfo=$(cat $G_REMOTE_TMP_FILE$FUNCNAME)
        if [ ! -z "${alarmInfo}" ]; then
            while read line
            do
                value=$(echo "obase=16;$line"|bc)
                WRITE_XML_COMMON 0 "Uncleared alarm ID:0x$value"
                LOG "[$FUNCNAME]:Uncleared alarm ID:0x$value"
            done < $G_REMOTE_TMP_FILE$FUNCNAME
            isPass=1
        else
            WRITE_XML_COMMON 0 "There are no uncleared alarms in the system."
            LOG "[$FUNCNAME]:There are no uncleared alarms in the system."
        fi
    fi
    restore_ifs

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#225 ҵڵ
#uds֧
checkMasterStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""
    local Result=""
    local TASK_ID=0
    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')

    set_ifs
    #ȡcmϢΪ׼
    mon_base=`cat /proc/monc_leader | grep Mon | awk '{print $3}'`
    mds_base=`cat /proc/monc_leader | grep Mds | awk '{print $3}'`
    pip_base=`cat /proc/monc_leader | grep Pip | awk '{print $3}'`
    restore_ifs

    LOG "[$FUNCNAME]:mon_base:$mon_base||mds_base:$mds_base||pip_leader:$pip_base||ProductType:$ProductType"

        REMOTE_IP_S=`cat $IP_ROLE_FILE`

        remote_exec_async_batch $TASK_ID 30 "cat /proc/monc_leader > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        isPass=$?

        ValidIP=`cat ${VALID_IP_FILE}`
        ValidIPResult=$ValidIP
        LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
        fifo_start
        while [ "${ValidIP}" != "" ]; do
            >${VALID_IP_FILE}

            for Item in $ValidIP; do
                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "Can not monc_leader information"
                iRet=$?

                if [ $iRet -eq 0 ];then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                    isPass=1
                    continue
                fi

                remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
                iRet=$?
                if [ $iRet -ne 0 ]; then
                if [ $ProductType -eq 80 ];then
                    errResult="Node:$Item||mon_leader:Failed to get monc_leader info"
                else
                    errResult="Node:$Item||mon_leader:Failed to get monc_leader info||mds_leader:--||pip_leader:--"
                fi
                    isPass=1
                    continue
                fi
            done

            ValidIP=`cat ${VALID_IP_FILE}`
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
                fifoContext=`cat $G_TMP_FILE$Item`
                if [ "$fifoContext" = "" ];then
                    continue
                fi

                mon_leader=`cat $G_TMP_FILE$Item | grep Mon | awk '{print $3}'`
                mds_leader=`cat $G_TMP_FILE$Item | grep Mds | awk '{print $3}'`
                pip_leader=`cat $G_TMP_FILE$Item | grep Pip | awk '{print $3}'`
                #checkڵ
        if [ $ProductType -eq 80 ];then
            Result="Node:$Item||mon_leader:$mon_leader"
        else
                local service_type=$(get_service_type_from_db "${Item}")
                if [ "${service_type}" == "1" ];then
                    Result="Node:$Item||mon_leader:$mon_leader||mds_leader:$mds_leader||pip_leader:$pip_leader"
                else
                    Result="Node:$Item||mon_leader:$mon_leader||mds_leader:--||pip_leader:--"
                fi
        fi
                restore_ifs
                LOG "[$FUNCNAME]:Result:$Result"
                WRITE_XML_ERROR 0 "$Result"
                #ݲһ
        if [ $ProductType -eq 80 ];then
            if [ "$mon_leader" == "" ] || [ "$mon_leader" != "$mon_base" ]; then
                isPass=1
            fi
        else
                if [ "${service_type}" == "1" ];then
                    if [ "$mon_leader" == "" ] || [ "$mds_leader" == "" ] || [ "$pip_leader" == "" ] || [ "$mon_leader" != "$mon_base" ] || [ "$mds_leader" != "$mds_base" ] || [ "$pip_leader" != "$pip_base" ]; then
                        isPass=1
                    fi
                else
                    if [ "$mon_leader" == "" ] || [ "$mon_leader" != "$mon_base" ]; then
                        isPass=1
                    fi
                fi
        fi

                >$G_TMP_FILE$Item
        done


    if [ "" != "${errResult}" ];then
        WRITE_XML_ERROR 0 "$errResult"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
 }

#226 mon server
checkMonServer()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0

    LOG "[$FUNCNAME]start!"

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowMonServer > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not mon Server information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node:$Item||INFO:$info||${errResult}"
                else
                    echo "$info"|grep "Server_num"
                    if [ $? -eq 0 ]; then
                        MonServer_NUM=$(echo "$info" | grep "Server_num" | awk -F= '{print $2}')
                    fi
                    echo "$info"|grep "Server_IP"
                    if [ $? -eq 0 ]; then
                        MonServer_IP=$(echo "$info" | grep "Server_IP" | awk -F= '{print $2}')
                    fi
                fi
            done < $G_TMP_FILE$Item
            WRITE_XML_COMMON 0 "Node:$Item||MonServer_NUM:$MonServer_NUM||MonServer_IP:$MonServer_IP"
            restore_ifs
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#λȡpoolname
NvdimmPool_GetPollName()
{
    case $1 in
        5)
            echo "Pool[nvcache.0]"
            ;;
        6)
            echo "Pool[trns.0]"
            ;;
        7)
            echo "Pool[ds.0]"
            ;;
        8)
            echo "Pool[quota.0]"
            ;;
        *)
            echo "Pool[UNKNOWN]"
            ;;
    esac
}

#227 Nvdimmڴصʹ
checkNvdimmPool()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local fimename="NvdimmPool"
    local TASK_ID="getinfo"
    local isPass=0
    local isflag=""
    local Info=""
    local Info_one=""
    local Total_Count=0
    local numCnt=1
    local numCnt_new=0
    local PoolName=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch_mml $TASK_ID 120 GetNvdimmPoolUsage $FUNCNAME
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            Result=""

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get NvdimmPool information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            for i in {5..7};
            do
                Info=""
                remote_download $Item $G_TMP_FILE$Item$i /tmp/tmpfile$fimename$i
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    LOG "[$FUNCNAME]:Node:$Item||INFO:download pool($i) info fail,iRet($iRet)"
                    Result="Node:$Item||INFO:download pool info fail ||Pool:-||TotalSize(MB):-||FreeSize(MB):-||UsedSize(MB):-||Percentage(%):-"
                    WRITE_XML_COMMON 0 "$Result"
                    isPass=1
                    continue
                fi
            done
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            Result=""

            for i in {5..7};
            do
                fifoContext=`cat $G_TMP_FILE$Item$i`
                if [ "$fifoContext" = "" ];then
                    continue
                fi

                #жǷΪûnvdimmµ
                isNvdimm=`cat $G_TMP_FILE$Item$i | grep "no nvdimm, no need to get"`
                if [ "$isNvdimm" != "" ] ;then
                    Result="Node:$Item||INFO: no nvdimm, no need to get ||Pool:-||TotalSize(MB):-||FreeSize(MB):-||UsedSize(MB):-||Percentage(%):-"
                    WRITE_XML_COMMON 0 "$Result"
                    continue
                fi

                Info=`cat $G_TMP_FILE$Item$i | grep "total size"`
                if [ "$Info" == "" ];then
                    Info=`cat $G_TMP_FILE$Item$i`
                    LOG "[$FUNCNAME]:Node:$Item||INFO:get pool($i) info fail,Info($Info)"

                    Result="Node:$Item||INFO:get Nvdimm pool info fail ||Pool:-||TotalSize(MB):-||FreeSize(MB):-||UsedSize(MB):-||Percentage(%):-"
                    WRITE_XML_COMMON 0 "$Result"

                    isPass=1
                    continue
                fi

                set_ifs

                #ȡ
                Total_Count=`cat $G_TMP_FILE$Item$i | grep "total size" | wc -l`
                numCnt=1
                while [ $numCnt -le $Total_Count ]; do
                    #ȡݣ
                    Info_one=`cat $G_TMP_FILE$Item$i | grep "total size" | awk NR==$numCnt`

                    isflag=`echo $Info_one |grep ">>>"`
                    if [ "$isflag" == "" ];then
                        PoolName=`cat $G_TMP_FILE$Item$i | grep "total size" | awk NR==$numCnt | awk -F'Pool' '{print $2}' | awk -F'[' '{print $2}' | awk -F']' '{print $1}'`
                        if [ "$PoolName" == "" ];then
                            Pool=`NvdimmPool_GetPollName $i`
                        else
                            Pool="Pool[$PoolName]"
                        fi
                    else
                        Pool=`NvdimmPool_GetPollName $i`
                    fi

                    totalsize=`echo $Info_one|awk '{print $4}'`
                    freesize=`echo $Info_one|awk '{print $11}'`

                    usedSize=`expr $totalsize \- $freesize`

                    usedSize_temp=`expr $usedSize \* 100`
                    percentage=`expr $usedSize_temp \/ $totalsize`
                    Result="Node:$Item||INFO: get pool info ok||Pool:$Pool||TotalSize(MB):$totalsize||FreeSize(MB):$freesize||UsedSize(MB):$usedSize||Percentage(%):$percentage"
                    LOG "[$FUNCNAME]:$Result"

                    WRITE_XML_COMMON 0 "$Result"
                    #ģڴռҲģڴռ85%
                    if [ $percentage -ge 90 ];then
                        isPass=1
                    fi

                    #¼
                    numCnt=$((numCnt+1))
                done
                restore_ifs
            done
    done

    if [ "${isPass}" == "0" ];then
        WRITE_XML_JUDGE 0
    else
        WRITE_XML_ERROR 0 "${errResult}"
        WRITE_XML_JUDGE 1
    fi

    WRITE_XML_SUBCMD_TAIL
}

#228ָ̨״̬
checkDataRestore()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local TASK_ID="getinfo"
    local isPass=0

	AllItem=`cat /proc/monc_monmap | grep ipaddr_ | awk -F "=" '{print $2}'`
	for Item in $AllItem
	do
		remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon' > $G_REMOTE_TMP_FILE$FUNCNAME[Tier] 2>&1"
		iRet=$?
		if [ $iRet -ne 0 ];then
			LOG "[$FUNCNAME]can't get mon info"
		else
			LOG "[$FUNCNAME]:MonIP:$Item"
			break
		fi
	done

	# Ϊ˷ֹrecoverymapcatʧܣrecoverymapдļУٽмǷݻָ
    #ִmon recovmap 0
    remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon recovmap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[DataRestore] 2>&1"
    remote_download $Item $G_TMP_FILE$Item /var/log/recoverymap.log
    iRet=$?
    if [ $iRet -ne 0 ]; then
       Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
       LOG "[$FUNCNAME]mml_result:mon recovmap 0 exec fail"
       WRITE_XML_COMMON 0 "Failed to execute command(mon recovmap 0)."
       isPass=1
    else
        #mapǷݻָ
        recover_task_num=`cat $G_TMP_FILE$Item | egrep "RTask|epoch" | wc -l`
    if [ "$recover_task_num" -ne 1 ]; then
       LOG "[$FUNCNAME]the number of recover task:$recover_task_num"
       let recover_task_num=$recover_task_num-1
       isPass=1
       Result="the number of recover task:$recover_task_num"
       WRITE_XML_COMMON 0 "${Result}"

    else
     #ûݻָ£鿴ÿڵҪָnlunĸ
        REMOTE_IP_S=`cat $IP_ROLE_FILE`
        remote_exec_async_batch_mml $TASK_ID 120 ShowDataRestore $FUNCNAME
        isPass=$?

        ValidIP=`cat ${VALID_IP_FILE}`
            ValidIPResult=$ValidIP
            LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
            fifo_start
            while [[ ${ValidIP} != "" ]]
            do
                >${VALID_IP_FILE}

                for Item in $ValidIP
                do
                    Result=""

                    #Ϊ100%֮ļأн
                    remote_exec_checkfini $Item $TASK_ID "Can not get Data Recover information"
                    iRet=$?

                    if [ $iRet -eq 0 ];then
                        echo -n "$Item " >> ${VALID_IP_FILE}
                        continue
                    elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                        isPass=1
                        continue
                    fi

                    remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
                    iRet=$?
                    if [ $iRet -ne 0 ]; then
                        isPass=1
                        continue
                    fi
                done
                ValidIP=`cat ${VALID_IP_FILE}`
            done

            wait
            fifo_finish

            for Item in $ValidIPResult; do
                    fifoContext=`cat $G_TMP_FILE$Item`
                    if [ "$fifoContext" = "" ];then
                        LOG "[$FUNCNAME]:IP:$Item,file is empty!"
                        continue
                    fi

                    set_ifs
                    while read line; do
                        info=`handle_remote_result "$line"`
                        if [ $? -ne 0 ]; then
                            isPass=1
                        fi

                        WRITE_XML_COMMON 0 "Node:$Item||INFO:$info"

                    done < $G_TMP_FILE$Item
                    restore_ifs
            done

        fi
    fi
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#229 Ⱥֻˮλ
checkReadOnlyThreshold()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local info=""
    local back_ip=""
    local errResult=""
    local nodepool_name=""
    local thresholdValue=""
    local allNodePool=""
    local productVersion=$(cat /opt/huawei/deploy/package/version | grep -w "ProductVersion" | awk -F= '{print $2}')
    if [[ "$productVersion" =~ "V100R006C30SPC" ]] || [[ "$productVersion" =~ "V100R006C10SPC" ]];then
        isPass=3
        WRITE_XML_COMMON 0 "ReadOnlyThreshold:No need checking $productVersion."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    info=$(cat /proc/monc_tiermap)
    if [ "X$info" = "X" ];then
        isPass=1
        errResult="INFO:The file /proc/monc_tiermap is empty in node $(hostname)."
        WRITE_XML_ERROR 0 "${errResult}"
    else
        allNodePool=$(echo "$info" | grep -w "nodepool id " | awk -F: '{print $2}')
        for tmpNodePool in $allNodePool
        do
            local highValue=95
            local lowValue=90
            tmpNodeIp=$(echo "$info" | grep -wA15 "nodepool id :$tmpNodePool" | grep -w "node :" | awk '{print $NF}')
            productName=$(/opt/huawei/deploy/script/localexec.py cmd ${tmpNodeIp} 30 false "ipmitool fru" |grep "Product Name" | awk -F: '{print $2}')
            if [[ "${productName}" =~ "P12" ]] || [[ "${productName}" =~ "S12" ]] || [[ "${productName}" =~ " M " ]];then
                highValue=90
                lowValue=85
            fi
            nodepool_name=$(echo "$info" | grep -wA15 "nodepool id :$tmpNodePool" | grep -w "nodepool name " | awk -F: '{print $2}')
            thresholdValue=$(echo "$info" | grep -wA15 "nodepool id :$tmpNodePool" | grep -w "ReadOnlyThreshold " | awk -F: '{print $2}')
            if [ $? -eq 0 ]; then
                if [ "${thresholdValue}" -gt ${highValue} ];then
                    isPass=$(check_pass $isPass 1)
                elif [ "${thresholdValue}" -gt ${lowValue} ];then
                    isPass=$(check_pass $isPass 4)
                fi
                WRITE_XML_COMMON 0 "NodePool:${tmpNodePool}||NodePoolName:${nodepool_name}||ProductName:${productName}||ReadOnlyThreshold:${thresholdValue}"
            else
                isPass=$(check_pass $isPass 1)
                errResult="INFO:The file /proc/monc_tiermap is error.(NO ReadOnlyThreshold value in ${tmpNodePool})"
                WRITE_XML_ERROR 0 "${errResult}"
            fi
        done
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#ds mapȡ״̬쳣pool
getAbnormalPool()
{
    dsid=0
    poolid=0
    cat /proc/monc_dsmap > /var/dsmap
    > /var/abnormalpool;
    while read line
    do
        echo "$line" |grep "^Pools" &> /dev/null
        if [ $? -eq 0 ]; then
            dsid=`echo $line |awk -F" " '{print $4}' |awk -F":" '{print $1}'`
            continue;
        fi
        echo "$line" |grep "^Id" &> /dev/null
        if [ $? -eq 0 ]; then
            echo "$line" |grep "Abnormal" &> /dev/null
            if [ $? -ne 0 ]; then
                continue;
            fi
            #abnormal pool
            poolid=`echo $line |awk -F" " '{print $2}'`
            echo "($dsid $poolid)" >> /var/abnormalpool
        fi
    done < /var/dsmap
}

getDiskStatInNlun()
{
    bitmap=`printf %d 0x$1`
    cnt=$2
    index=$3
    cnt=$(($cnt-$index))
    cnt=$(($cnt-1))
    cnt=$((3*$cnt))
    bitmap=$(($bitmap>>$cnt))
    bitmap=$(($bitmap&7))
    return $bitmap;
}

addPoolInBadList()
{
    echo "$1" >> /var/nlun_pool_result
}

#nlun mapds mapеpool statǷһ
checkDiskStat()
{
    nlundiskstat=$1
    poolcnt=$2
    idx=$3
    pname=$4
    #ȡnlun disk statӦbitλ
    getDiskStatInNlun $nlundiskstat $poolcnt $idx
    if [ $? -eq 0 ]; then
        return
    fi
    #쳣poolǷѾ¼/var/nlun_pool_result
    grep "$pname" /var/nlun_pool_result &> /dev/null
    if [ $? -eq 0 ]; then
        return
    fi
    #ӹpool
    addPoolInBadList "($pname)"
}

#nlunгԱpool״̬״̬쳣DS map״̬һ¶ӡ$G_TMP_FILE2$Item
checkNlunPoolStatus()
{
    local result_log=/var/log/nluninfo.log

    > /var/nlun_pool_result
    #$result_logÿһ
    neednext=0
    while read line
    do
        if [[ "$line" == NLUN*NewPt* ]]; then
            diskstat=`echo $line |awk -F" " '{print $23}'`
            neednext=1
            continue;
        fi
        if [ $neednext -eq 1 ]; then
            neednext=0
            #ȡnlunԱ
            if [ $diskstat -ne 0 ]; then
                pools=`echo $line |awk 'BEGIN{FS="[()]"}{for(i=2;i<NF;i++) if($i!=" ")print $i}'`
                poolcnt=0
                for pool in $pools
                do
                    poolcnt=$(($poolcnt+1))
                done
                index=0
                for pool in $pools
                do
                    checkDiskStat $diskstat $poolcnt $index $pool
                    index=$(($index+1))
                done
            fi
        fi
    done < $result_log
    #/var/abnormalpoolе쳣̼/var/nlun_pool_result
    while read line
    do
        #쳣poolǷѾ¼/var/nlun_pool_result
        grep "$line" /var/nlun_pool_result &> /dev/null
        if [ $? -eq 0 ]; then
            continue;
        fi
        addPoolInBadList "$line"
    done < /var/abnormalpool
}

#230 nlun״̬
getNlunStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local TASK_ID=0
    local result_log=/var/log/nluninfo.log

    while true;do
        get_nlunmap
        iRet=$?
        if [ $iRet -eq 0 ];then
            isPass=1
            break
        fi

        set_ifs

        cat $result_log | grep State  | grep -wv 'State 0' > $G_TMP_FILE2$FUNCNAME
        lineNum=`cat $G_TMP_FILE2$FUNCNAME|wc -l`
        if [ $lineNum -eq 0 ];then
            Result="Nlun State:--------------------------------------------------||Nlun State:The number of State is 0"
            WRITE_XML_COMMON 0 "$Result"
            LOG "$Result"
        else
            isPass=1
            Result="Nlun State:--------------------------------------------------||Nlun State:The number of State is $lineNum"
            WRITE_XML_COMMON 0 "$Result"

            top_20=`cat $G_TMP_FILE2$FUNCNAME | head -20| sed 's/</(lt)/g'`
            Result=""
            for line in "$top_20"; do
                if [ "" != "${Result}" ];then
                    Result="$Result||Nlun State:$line"
                else
                    Result="Nlun State:$line"
                fi
            done

            Result="Nlun State:--------------detail--------------||${Result}"
            WRITE_XML_COMMON 0 "$Result"
        fi
        restore_ifs
        break;
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#231 MONǷƵѡ
 checkMonHealth()
 {
     WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0

    LOG "[$FUNCNAME]start!"

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch_mml $TASK_ID 30 ShowMonitorHealth $FUNCNAME
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Cann't get MonHealth "
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item

            Ret=`cat $G_TMP_FILE$Item | grep bootstrap | tr -d " "| awk -F: '{printf $2}'`
            Ret1=`cat $G_TMP_FILE$Item | grep elec | tr -d " " | awk -F: '{printf $2}'`
            if [ "$Ret" != "OK" ] || [ $Ret1 != "OK" ];then
                cat $G_TMP_FILE$Item >> $LOG_FILE
                isPass=1
            fi

            Result="NodeIp:$Item||Bootstrap:$Ret||Elec:$Ret1"
            WRITE_XML_COMMON 0 "$Result"
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
 }

#232 MDSһ
checkMdsSubTreeStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local dfsFlag=0

    #Զ첽ִҪУipVALID_IP_FILE
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch_mml $TASK_ID 120 CheckMdsSubTree $FUNCNAME
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                errResult="Does not involve"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:$errResult"
                continue
            fi

            dfsFlag=1

            remote_exec_checkfini $Item $TASK_ID "Can not get mds SubTree information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                continue
            fi

            #Ϊ100%֮ļأн
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ]; then
                continue
            fi

            #ǷokSubtree checkup OK.Subtree checkup failed
            checkRst=`cat $G_TMP_FILE$Item|grep "checkup OK"`
            if [ "$checkRst" == "" ]
            then
                errResult="Node: $Item||INFO: mds subtree is not accordant."
                WRITE_XML_ERROR 0 "$errResult"

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

                isPass=1
            else
                errResult="Node: $Item||INFO: mds subtree is accordant."
                WRITE_XML_COMMON 0 "$errResult"
            fi

            filenum=`cat $G_TMP_FILE$Item | grep "\[DENTRY_FILE" |cut -d '=' -f 2|cut -d ',' -f 1 |sed 's/ //g'`
            dirnum=`cat $G_TMP_FILE$Item  | grep "\[DENTRY_DIR"  |cut -d '=' -f 2|cut -d ',' -f 1 |sed 's/ //g'`

            LOG "[$FUNCNAME]:Lru filenum:$filenum, dirnum:$dirnum"

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            WRITE_XML_COMMON 0 "Node:$Item||INFO:Lru in mem file:$filenum, dir:$dirnum"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

# 233 ǷCOREļ
checkCoreFile()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #ֱ/corefile/crash/corefileĿ¼вǷн30ļ
    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/CheckItems checkCoreFile $G_REMOTE_TMP_FILE$FUNCNAME"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get core information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            #ǷcoreļȣļмУоcoreļблļٻһ
            crashPass=no
            corePass=no
            crashfile=$(cat $G_TMP_FILE$Item | grep "/corefile/crash/" |grep -v "find: \`/corefile/crash'" | awk 'END {print NR}')
            LOG "[$FUNCNAME]:Node: $Item||INFO: crash file is exit,crashfile:$crashfile"

            if [ $crashfile -ge 1 ]
            then
                isPass=1
                crashPass=yes
            fi

            corefile=$(cat $G_TMP_FILE$Item | grep "/corefile/core-" |grep -v "find: \`/corefile"| awk 'END {print NR}')
            LOG "[$FUNCNAME]:Node: $Item||INFO: core file is exit,corefile:$corefile"

            if [ $corefile -ge 1 ]
            then
                isPass=1
                corePass=yes
            fi

            errResult="Node: $Item||corefile: $corePass||crashfile: $crashPass"
            WRITE_XML_COMMON 0 "$errResult"

    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#234 NTP״̬
checkNtpConn()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0
    local ntpserverIP=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #DNSڣжǷͨ
    remote_exec_async_batch $TASK_ID 120 "ntpq -p > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1; exit 0"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get verify information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish
    #ȡڵ
    local back_ip=`get_backnet_ip`
    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            bflag1=1   #NTPǷΪ1Ϊ0
            bflag2=1   #ڵNTPserver*Ϊ0Ϊ1.
            #״̬
            serverConn=`cat $G_TMP_FILE$Item|grep "^*"|wc -l`
            if [ $serverConn -eq 0 ];then
                bflag1=0
                if [ $back_ip == $Item ];then
                    ntpserverIP=$(cat /etc/ntp.conf |grep "^server"|awk '{print $2}')
                    for serverip in ${ntpserverIP[*]};
                    do
                        ntpinfo=$(sntp -t 3 $serverip |grep "no-leap"|wc -l)
                        if [ $ntpinfo -eq 1 ];then
                            bflag1=1
                            bflag2=0
                            LOG "[$FUNCNAME]bflag1=$bflag1;bflag2=$bflag2"
                            break
                        fi
                    done
                fi
                if [ $bflag1 == 0 ];then
                    isPass=1
                    errResult="Node: $Item||INFO: ntp is unreachable."
                    WRITE_XML_ERROR 0 "$errResult"
                fi
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            fi

            if [ $bflag1 == 1 ];then
                #offsetƫ
                if [ bflag2 == 1 ];then
                    offset=`tac $G_TMP_FILE$Item|grep "^*"|awk '{print $9}'|sed -n '1p'`
                else
                    offset=`cat $G_TMP_FILE$Item|awk '{print $9}'|sed -n '3p'`
                fi

                LOG "[$FUNCNAME]:offset:$offset"
                if [ `echo "$offset < 7200000"|bc` -eq 1 ] && [ `echo "$offset > -7200000"|bc` -eq 1 ] ;then
                    offset=${offset#-}
                    errResult="Node: $Item||INFO: ntp is normal.||Offset: ${offset}"
                    WRITE_XML_COMMON 0 "$errResult"
                else
                    isPass=1
                    errResult="Node: $Item||INFO: ntp offset is more than 7200000.||Offset: $offset"
                    WRITE_XML_ERROR 0 "$errResult"

                    #
                    cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                fi
            fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#235 RPCǷüй©
checkNodeRPC_ReferCnt()
{
     WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local Result=""
    local errResult=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    for Item in $REMOTE_IP_S; do

        set_ifs
        remoteResult=`remote_exec $Item 30 "cat $RPC_REFER_PROC_FILE"`
        LOG "[$FUNCNAME] [$(date)] $Item result :: ${remoteResult}"

        echo "${remoteResult}" | grep -q "$RPC_REFER_CNT_KEY"
        iRet=$?
        if [ $iRet -eq 0 ]; then
            LOG "[$FUNCNAME] $Item Failed to execute(checkRPC_ReferCnt) command.iRet($iRet)"
            isPass=1
            Result="Node:$Item||INFO:The reference count of RPC is not zero"
        else
            Result="Node:$Item||INFO:The reference count of RPC is zero"
        fi

        restore_ifs
        WRITE_XML_COMMON 0 "$Result"

    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#236дNOFSǷгʱ
checkWrtNofsTimeout()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #Զ첽ִҪУipVALID_IP_FILE
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/CheckWrtNofsTimeout > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1; exit 0"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            LOG "[$FUNCNAME]:IP:$Item"
            #Զִн
            remote_exec_checkfini $Item $TASK_ID "Can not get node RPC reference count"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            #Զ100%Ժִнļ
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="[$FUNCNAME]$Item exec(Check if write nofs timeout) failed.iRet($iRet),errno($errno)!"
                LOG "[$FUNCNAME]$Item exec(Check if write nofs timeout) failed.iRet($iRet),errno($errno)!"
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            set_ifs
            while read line; do
                echo "$line" |grep "WriteNOFSfail"
                if [ $? -eq 0 ]; then
                   isPass=1
                fi
                info=`handle_remote_result "$line"`
                WRITE_XML_COMMON 0 "Node:$Item||INFO:$info"

            done < $G_TMP_FILE$Item
            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#нڵĵĺIP
function GetBackIPAndRoleFromDB()
{
    local lineinfo=""
    local numCnt=1
    local tempnumCnt=1
    local lastNID=""
    local localNID=""
    local templocalNID=""
    local totalline=0
    local count=1

    > $IP_ROLE_FILE
    #ݿȡнڵĺIP
    LOG "[$FUNCNAME]start get all nid from cm_conf.db"
    JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
    while [[ "${JavaId}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get all nid from db ,count=$count"
        JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
        count=$((count + 1))
        if [ $count -gt 5 ];then
            break
        fi
    done
    totalline=`echo "$JavaId" | wc -l`

    while [ $numCnt -le $totalline ]; do

        lineinfo=`echo $JavaId | awk '{print $'$numCnt'}'`

        ItemIp=`echo $lineinfo | awk -F'|' '{print $2}'`
        localNID=`echo $lineinfo | awk -F'|' '{print $1}'`

        if [ "$localNID" == "$lastNID" ];then
            #ͬһڵ㣬һѭ
            numCnt=$((numCnt+1))

            continue
        fi

        #pingһ¼Ƿͨ
        for time in ${RepeatTimes[*]};do
        tempStr_ping=`ping -q -c 1 $ItemIp  | grep received | awk '{print $4}'`
            local iRet=$?
            if [ $iRet -ne 0 ]; then
                sleep 10
            else
                break
            fi
        done

        #
        numCnt=$((numCnt+1))
        lastNID=$localNID

        if [ "$tempStr_ping" -le 0 ];then
            LOG "[$FUNCNAME] try another ip: numCnt:$numCnt,$localNID,$ItemIp,tempStr_ping:$tempStr_ping"
            #Եڶip
            templocalNID=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $1}'`

            #жǷͬһڵ
            if [ "$localNID" == "$templocalNID" ];then
                ItemIp=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $2}'`
                for time in ${RepeatTimes[*]}; do
                tempStr_ping=`ping -q -c 2 $ItemIp  | grep received | awk '{print $4}'`
                    local iRet=$?
                    if [ $iRet -ne 0 ]; then
                        sleep 10
                    else
                        break
                    fi
                done
                LOG "[$FUNCNAME]numCnt:$numCnt,$templocalNID,$ItemIp ,tempStr_ping:$tempStr_ping"

                #
                numCnt=$((numCnt+1))
                lastNID=$localNID

                if [ "$tempStr_ping" -le 0 ];then
                    #ڶҲͨһѭ
                    LOG "[$FUNCNAME]Node:$localNID,$ItemIp ping fail"
                    continue
                fi
            else
               #ͬһڵ㣬һѭ
               continue
            fi
        fi

        #жϽڵǷúͶ
        Status_info=`remote_exec $ItemIp 30 "cat /opt/huawei/snas/etc/snas.ini | grep "status=""|head -1`
        iRet=$?
        LOG "[$FUNCNAME]node:$ItemIp,Status_info:$Status_info,iRet:$iRet."
        if [ "$iRet" -eq "0" ] && [ "$Status_info" != "" ];then
            Status_value=`echo $Status_info | awk -F= '{print $2}'`
            if [ "$Status_value" == "0" ];then
                echo -n "$ItemIp " >> $IP_ROLE_FILE
            fi
        fi

    done

}

#237 ڵIPǷڽڵ
checkNodeIPLegality()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local Result=""
    local errResult=""

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    for Item in $REMOTE_IP_S; do

        set_ifs
        port_result=`remote_exec $Item 30 "cat /opt/huawei/snas/etc/frontPortStatus"`
        iRet=$?
        LOG "[$FUNCNAME]node:$Item, port_result:$port_result,iRet:$iRet."
        if [ "$port_result" == "" ] ;then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||INFO:get frontPortStatus faild"
            restore_ifs
            continue
        fi
        for line in $port_result; do
            netport=$(echo $line|awk -F ":" '{print $1}'|tr -d ' ')
            status=$(echo $line|awk -F ":" '{print $2}'|tr -d ' ')
            if [ "$status" == "DOWN" ];then
               isPass=1
               LOG "[$FUNCNAME]isPass:$isPass,node:$Item,line:$line"
            fi
            WRITE_XML_COMMON 0 "Node:$Item||Netport:$netport||Status:$status"
        done
        restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL

}

#238 BJM̼
checkBJM()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local iRet=0
    local IPNotOk=""
    local workCheck=0

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            LOG "[$FUNCNAME]:INFO: Can't get local ip"
            isPass=1
            WRITE_XML_COMMON 0 "INFO:Can't get local ip"
            break
        fi

        #ִmml bjm map 0
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4104 "bjm map 0"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]mml_result:$Info"
            WRITE_XML_COMMON 0 "INFO:Failed to execute command(bjm map 0)."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1

        #ȼ̸
        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Manager" |wc -l`
        if [ "$Info" -ne 1 ];then
            Result="INFO:active Manager number is not ok||Number:$info"
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        fi

        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Server" |wc -l`
        if [ "$Info" -ne 1 ];then
            Result="INFO:active Server number is not ok||Number:$info"
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        fi

        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Worker" |wc -l`
        if [ "$Info" -lt 1 ];then
            Result="INFO:active Worker number is not ok||Number:$info"
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        fi

        if [ $isPass -eq 1 ];then
            break
        fi

        #ip
        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Manager" | cut -d '(' -f 3 | cut -d ')' -f 1`
        if [ "$Info" == "" ] || [ "$Info" == "0.0.0.0" ];then
            Result="INFO:active Manager status is not ok||node:null"
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        else
            Result="INFO:active Manager status is ok||node:$Info"
            WRITE_XML_COMMON 0 "$Result"
        fi


        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Server" | cut -d '(' -f 3 | cut -d ')' -f 1`
        if [ "$Info" == "" ] || [ "$Info" == "0.0.0.0" ];then
            Result="INFO:active Server status is not ok||node:null"
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        else
            Result="INFO:active Server status is ok||node:$Info"
            WRITE_XML_COMMON 0 "$Result"
        fi

        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Worker" | cut -d '(' -f 3 | cut -d ')' -f 1`
        for i in $Info; do
            if [ "$i" == "" ] || [ "$i" == "0.0.0.0" ];then
                IPNotOk=$IPNotOk" $i"
                isPass=1
                workCheck=1
            else
                Result="INFO:active Worker status is ok||node:$i"
                WRITE_XML_COMMON 0 "$Result"
            fi
        done

        if [ "$workCheck" -eq 1 ]; then
            Result="INFO:active Worker status is not ok||node:$IPNotOk"
            WRITE_XML_ERROR 0 "$Result"
        fi
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}
#239. 鼯Ⱥ״̬
checkSystemInfo_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local servertype=$(cat /opt/huawei/snas/etc/snas.ini |grep ^serviceType |awk -F= '{print $2}')

    while true; do

        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="INFO: Can't get local ip"
            LOG "[$FUNCNAME]:$errResult"
            isPass=1
            break
        fi

        #ע
        set_ifs

        #ִmml cm system
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm system"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1

        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]:mml_result:${Info}"
            WRITE_XML_ERROR 0 "INFO:Failed to execute command(cm system)."
            isPass=1
        else
            dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
            content=`cat $G_REMOTE_TMP_FILE$FUNCNAME`

            if [ "$content" == "" ];then
                WRITE_XML_ERROR 0 "Can not get information."
                isPass=1
            else
                ID=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_ID"|awk -F: '{print $2}'`
                Name=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Name"|awk -F: '{print $2}'`
                Health_Status=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Health_Status"|awk -F: '{print $2}'|awk 'gsub(/^ *| *$/,"")'`
                Running_Status=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Running_Status"|awk -F: '{print $2}'|awk 'gsub(/^ *| *$/,"")'`
                version=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Version"|awk -F: '{print $2}'`

                totalCap=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Capacity"|awk -F: '{print $2}'`
                usedCap=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Used_Capacity"|awk -F: '{print $2}'`
                idleCap=`expr $totalCap \- $usedCap`
                Percentage=`expr 100 \* $usedCap`
                Percentage=`expr $Percentage / $totalCap`

                echo $Health_Status
                echo $Running_Status
                Health_Status=`MapHealthStatus $Health_Status`
                Running_Status=`MapRunningStatus $Running_Status`
                Result="ID:$ID||Name:$Name||Health_Status:$Health_Status||Running_Status:$Running_Status||Version:$version||TotalCapacity(MB):$totalCap||UsedCapacity(MB):$usedCap||Percentage(%):$Percentage||Server_Type:$servertype"

                Running_Status=$(echo ${Running_Status})

                if [ "$Running_Status" == "RUNNING" ] && [ "$Health_Status" == "NORMAL" ];then
                    LOG "[$FUNCNAME]Running_Status($Running_Status);Health_Status($Health_Status) check ok"
                else
                    isPass=1

                    #
                    cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
                    LOG "[$FUNCNAME]Running_Status($Running_Status);Health_Status($Health_Status) check failed"
                    WRITE_XML_COMMON 0 "$Result"
                    break
                fi
                #Ƶسֵȡ95,ֵ75
                if [ "$servertype" == "surveillance" ];then
                    if [ $Percentage -ge 95 ];then
                       isPass=1
                       LOG "[$FUNCNAME]servertype=$servertype Percentage=$Percentage"
                    fi
                else
                    if [ $Percentage -ge 75 ];then
                       isPass=1
                       LOG "[$FUNCNAME]servertype=$servertype Percentage=$Percentage"
                    fi
                fi
                WRITE_XML_COMMON 0 "$Result"
            fi
        fi

        restore_ifs
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#240 poor״̬
checkNodePoolStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local iRet=0
    local isPass=0
    local iFail=0
    local iOptimize=0
    local iOpCnt=0
    cat /proc/monc_dsmap > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
    iRet=$?
    if [ $iRet -ne 0 ]; then
        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
        Result="INFO:exec(cat /proc/monc_dsmap) failed!"
        LOG "[$FUNCNAME]$Item exec(cat /proc/monc_dsmap) failed!errno($iRet),${Info}"
        isPass=1
        WRITE_XML_ERROR 0 "$Result"
    else
        set_ifs
        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        ips=($(grep -w "IpAddr"  $G_REMOTE_TMP_FILE$FUNCNAME| awk -F " " '{print $14}'))
        #IP
        grep -w "IpAddr"  $G_REMOTE_TMP_FILE$FUNCNAME| awk -F " " '{print $14}'|awk -F "." '{print $1 $2 $3 $4}' > /tmp/tmpipinfo 2>&1
        ipnumber=($(cat -n /tmp/tmpipinfo|sort -nk 2|awk '{print $1}'))
        NumArr1=($(grep -n -w "IpAddr"  $G_REMOTE_TMP_FILE$FUNCNAME|awk -F ":" '{print $1}'))
        NumArr2=($(grep -n "\-\-\-\-\-\-\-\-\-\-" $G_REMOTE_TMP_FILE$FUNCNAME|awk -F ":" '{print $1}'))
        for i in ${ipnumber[*]}
        do
            i=$((i-1))
            iOpCnt=0
            distance=$((${NumArr2[i]}-${NumArr1[i]}-1))
            grep -A${distance} -w ${ips[i]} $G_REMOTE_TMP_FILE$FUNCNAME|grep -v ${ips[i]}|grep -v "Pools in Ds" > $G_TMP_FILE$FUNCNAME
            cat $G_TMP_FILE$FUNCNAME |grep "State" |sort -nk 2 > $G_TMP_FILE2$FUNCNAME
            while read line
            do
                ID=$(echo $line |awk -F " " '{print $2}')
                states=$(echo $line |awk -F " " '{print $4}')
                Result="Node:${ips[i]}||ID:$ID||States:${states}"
                    WRITE_XML_COMMON 0 "$Result"
                if [ ${states} = "Abnormal(5)" ]; then
                    iOpCnt=$(($iOpCnt + 1))
                elif [ ${states} != "Normal" ]; then
                    iFail=1
                fi
            done < $G_TMP_FILE2$FUNCNAME
            if [ $iOpCnt -ne 0 ] && [ $iOpCnt -le 2 ]; then
                iOptimize=1
            elif [ $iOpCnt -gt 2 ]; then
                iFail=1
            fi
        done
        if [ $iFail -eq 1 ]; then
            isPass=1
        elif [ $iOptimize -eq 1 ]; then
            isPass=4
        else
            isPass=0
        fi
        restore_ifs
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}
CheckReplicationMasterNodeChannel()
{
    local item="$1"
    local nodeip="$2"

    NodeNum=`echo "${item}" | awk '{print $5}'`
    ChannelNum=`echo "${item}" | awk '{print $6}'`
    WRITE_XML_COMMON 0 "Node:${nodeip}||NodeNum:$NodeNum||ChannelNum:$ChannelNum"
    if [ "X$NodeNum" == "X0" ] && [ "X$ChannelNum" == "X0" ]; then
        return 0
    elif [ "X$NodeNum" == "X0" ] && [ "X$ChannelNum" != "X0" ]; then
        return 1
    else
        WRITE_XML_ERROR 0 "inter error"
        return 2
    fi
}

CheckReplicationMasterNodePair()
{
    local item="$1"
    local nodeip="$2"

    NodeNum=`echo "${item}" | awk '{print $5}'`
    PairCount=`echo "${item}" | awk '{print $6}'`
    WRITE_XML_COMMON 0 "Node: ${nodeip}|| NodeNum:$NodeNum||PairCount:$PairCount"
    if [ "X$NodeNum" == "X0" ] && [ "X$PairCount" == "X0" ]; then
        return 0
    elif [ "X$NodeNum" == "X0" ] && [ "X$PairCount" != "X0" ]; then
        return 1
    else
        WRITE_XML_ERROR 0 "inter error"
        return 2
    fi
}

function JudgeLicense()
{
    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        LOG "[$FUNCNAME]:INFO: Can't get local ip"
        WRITE_XML_COMMON 0 "INFO:Can't get local ip"
        return 2
    fi

    $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm licensecfg"  >  $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1
    iRet=$?
    if [ $iRet -ne 0 ]; then
        Info=`cat $G_REMOTE_TMP_FILE2$FUNCNAME`
        LOG "[$FUNCNAME]mml_result:$Info"
        WRITE_XML_COMMON 0 "INFO:Failed to execute command(cm licensecfg)."
        return 2
    fi

    dos2unix $G_REMOTE_TMP_FILE2$FUNCNAME
    cat $G_REMOTE_TMP_FILE2$FUNCNAME >> $LOG_FILE 2>&1

    javaId=$(cat $G_REMOTE_TMP_FILE2$FUNCNAME|grep InfoReplicator)
    if [ "$javaId" = "" ]; then
        LOG "[$FUNCNAME]:javaId is null"
        WRITE_XML_ERROR 0 "No license resource exists."
        return 0
    fi

    acRunTime=`echo $javaId |awk '{print $7}'`
    LOG "acRunTime:$acRunTime"
    if [ "${acRunTime}" == "9999-12-31" ];then
        date1=$(date --date "${acRunTime}" +%s)
        return 1
    else
        date1=`expr $acRunTime \/ 1000`
    fi
    LOG "date1:$date1"
    date2=`date`

    t1=$date1
    t2=`date --date "$date2" +%s`
    LOG "acRunTime:$t1,CurrentTime:$t2"
    if [ $t1 -lt $t2 ]; then
        LOG "$acRunTime < $date2"
        WRITE_XML_COMMON 0 "license resource currently disabled"
        return 0
    elif [ $t1 -eq $t2 ]; then
        LOG "$acRunTime = $date2"
        return 1
    else
        LOG "$acRunTime > $date2"
        return 1
    fi
}


#return:0 pass, 1 fail, 2 error
#set
interCheckReplicationLink()
{
    local NodeIP="$1"
    local tmpFile="$2"
    local ret=0

    sed -i /^shell-init:*/d "${tmpFile}"
    #add filed:NodeStatus NodeResult isMasterNode isCtrlNode
    #original filed:LogicId     ArrayID     LinkCnt     LiveLink     Status    Ref    Compatible
    #original filed:$NodeNum $ChannelNum
    while read item
    do
        nodeStatus=`echo "${item}" | awk '{print $1}'`
        if [ "X$nodeStatus" != "X0" ]; then
            LOG "[$FUNCNAME] Node: $NodeIP nodeStatus: $nodeStatus."
            ret=0
            break
        fi

        isGetSuccess=`echo "${item}" | awk '{print $2}'`
        isMasterNode=`echo "${item}" | awk '{print $3}'`
        isCtrlNode=`echo "${item}" | awk '{print $4}'`

        #cmd exec fail
        if [ "X$isGetSuccess" = "XFail" ]; then
            WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:excute diagnose cmd failed"
            ret=2
            break
        fi

        #MasterNode and isCtrlNode=-, display:$NodeNum $ChannelNum
        if  [ "$isMasterNode" == "MasterNode" ]; then
            isFindMasterNode=1
            if [ "$isCtrlNode" == "-" ]; then
                #MasterNode and isCtrlNode=-, display:$NodeNum $ChannelNum
                CheckReplicationMasterNodeChannel "${item}" "${NodeIP}"
                ret=$?
                return $ret
            fi
        fi
        if  [ "X$isCtrlNode" != "XCtrlNode" ]; then
            ret=0
            break
        fi

        isFindCtrlNode=1
        #ctrl link info
        if [ "X$isGetSuccess" = "XEmpty" ]; then
            WRITE_XML_COMMON 0 "INFO:replication link not configure"
            ret=0
            break
        fi

        LogicId=`echo "${item}" | awk '{print $5}'`
        ArrayID=`echo "${item}" | awk '{print $6}'`
        LinkCnt=`echo "${item}" | awk '{print $7}'`
        LiveLink=`echo "${item}" | awk '{print $8}'`
        Status=`echo "${item}" | awk '{print $9}'`
        Ref=`echo "${item}" | awk '{print $10}'`
        Compatible=`echo "${item}" | awk '{print $11}'`
        if [ "X$LiveLink" = "X0" ]; then
                LOG "[$FUNCNAME] Node: $NodeIP item: $item."
                WRITE_XML_COMMON 0 "LogicId:$LogicId||ArrayID:$ArrayID||LinkCnt:$LinkCnt||LiveLink:$LiveLink||Status:$Status||Ref:$Ref||Compatible:$Compatible"
                ret=1
        else
                WRITE_XML_COMMON 0 "LogicId:$LogicId||ArrayID:$ArrayID||LinkCnt:$LinkCnt||LiveLink:$LiveLink||Status:$Status||Ref:$Ref||Compatible:$Compatible"
        fi

    done <$tmpFile

    return $ret
}

#245.Check Replication Link
checkReplicationLink()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local tmpFile="/tmp/tmpfile$FUNCNAME"
    local dfsFlag=0
    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    else
        LOG "license resource exists."
    fi

    isFindMasterNode=0
    isFindCtrlNode=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch $TASK_ID 60 "${G_GET_REPLICATION_INFO} Link > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1
            remote_exec_checkfini $Item $TASK_ID "Can not get information about replication link"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:excute check cmd failed"
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME) failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:remote download file failed"
                isPass=1
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            interCheckReplicationLink "$Item" "$G_TMP_FILE$Item"
            ret=$?
            if [ $ret -ne 0 ]; then
                isPass=1
            fi
    done

    if [ $dfsFlag = 1 ]; then
        if [ $isPass -eq 0 ]; then
            #cluster no rep master node
            if [ $isFindMasterNode -eq 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Error:Not find master node"
            #cluster no rep ctrl node
            elif [ $isFindCtrlNode -eq 0 ]; then
                WRITE_XML_COMMON 0 "INFO:replication link not configure"
            fi
        fi
    fi
    LOG "[$FUNCNAME] pass:$isPass."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}



interCheckReplicationProcess()
{
    local NodeIP="$1"
    local tmpFile="$2"
    local ret=0

    sed -i /^shell-init:*/d "${tmpFile}"
    #isGetSuccess isRepZoneNode status repPid
    if [  `cat $tmpFile | wc -l` -ne 1 ]; then
        WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:get replication process information error"
        tmpinfo=$(cat $tmpFile)
        LOG "[$FUNCNAME] $tmpFile unexpect.NodeIP=$NodeIP,tmpinfo=$tmpinfo"
        return 1
    fi
        item=`cat $tmpFile`
        status=`echo "${item}" | awk '{print $1}'`
        repPid=`echo "${item}" | awk '{print $2}'`
        if [ $status -eq 0 ]; then
            if [ "X$repPid" == "X-" ]; then
                LOG "[$FUNCNAME] Failed to get Replication Process when device status is $status."
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Normal||RepProcess:Not Running"
                return 1
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Normal||RepProcess:Running"
                return 0
            fi
        elif [ $status -eq 1 ]; then
            if [ "$repPid" != "-" ]; then
                LOG "[$FUNCNAME] Get Replication Process when device status is $status."
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Disabled||RepProcess:Running"
                return 1
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Disabled||RepProcess:Not Running"
                return 0
            fi
        elif [ $status -eq 2 ]; then
            if [ "$repPid" != "-" ]; then
                LOG "[$FUNCNAME] Get Replication Process when device status is $status."
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Frozen||RepProcess:Running"
                return 1
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Frozen||RepProcess:Not Running"
                return 0
            fi
        elif [ $status -eq 3 ]; then
            if [ "$repPid" != "-" ]; then
                LOG "[$FUNCNAME] Get Replication Process when device status is $status."
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Shutdown||RepProcess:Running"
                return 1
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Shutdown||RepProcess:Not Running"
                return 0
            fi
        elif [ $status -eq 4 ]; then
            if [ "$repPid" != "-" ]; then
                LOG "[$FUNCNAME] Get Replication Process when device status is $status."
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Deleted||RepProcess:Running"
                return 1
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Deleted||RepProcess:Not Running"
                return 0
            fi
        elif [ $status -eq 5 ]; then
            if [ "$repPid" != "-" ]; then
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Restart||RepProcess:Running"
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Restart||RepProcess:Not Running"
            fi
            return 0
        else
            LOG "[$FUNCNAME] Get Replication Process when device status is $status."
            if [ "$repPid" != "-" ]; then
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Unknown||RepProcess:Running"
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Unknown||RepProcess:Not Running"
            fi
            return 1
        fi

    return 0
}

#246 Check Replication Process
checkReplicationProcess()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    local tmpFile="/tmp/tmpfile$FUNCNAME"

    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    else
        LOG "license resource exists."
    fi

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch $TASK_ID 60 "${G_GET_REPLICATION_INFO} Process > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1

            remote_exec_checkfini $Item $TASK_ID "Can not get information about replication process"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:excute check cmd failed"
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME) failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:remote download file failed"
                isPass=1
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            interCheckReplicationProcess "$Item" "$G_TMP_FILE$Item"
            ret=$?
            if [ $ret -ne 0 ]; then
                isPass=1
            fi
    done

    LOG "[$FUNCNAME] pass:$isPass."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

interCheckReplicationZoneStatus()
{
    local NodeIP="$1"
    local tmpFile="$2"
    local ret=0

    sed -i /^shell-init:*/d "${tmpFile}"
    #add filed:NodeStatus NodeResult isMasterNode isCtrlNode
    #original filed:NodeNum ChannelNum
    while read item
    do
        nodeStatus=`echo "${item}" | awk '{print $1}'`
        if [ "X$nodeStatus" != "X0" ]; then
            LOG "[$FUNCNAME] Node: $NodeIP nodeStatus: $nodeStatus."
            ret=0
            break
        fi

        isGetSuccess=`echo "${item}" | awk '{print $2}'`
        isMasterNode=`echo "${item}" | awk '{print $3}'`
        isCtrlNode=`echo "${item}" | awk '{print $4}'`

        #cmd exec fail
        if [ "X$isGetSuccess" = "XFail" ]; then
            WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:excute diagnose cmd failed"
            ret=2
            break
        fi

        #MasterNode and isCtrlNode=-, display:$NodeNum $ChannelNum
        if  [ "$isMasterNode" == "MasterNode" ]; then
            isFindMasterNode=1
            if [ "$isCtrlNode" == "-" ]; then
                #MasterNode and isCtrlNode=-, display:$NodeNum $ChannelNum
                CheckReplicationMasterNodeChannel "${item}" "${NodeIP}"
                ret=$?
                return $ret
            fi
        fi
        if  [ "X$isCtrlNode" != "XCtrlNode" ]; then
            ret=0
            break
        fi

        isFindCtrlNode=1
        #ctrl link info
        if [ "X$isGetSuccess" = "XEmpty" ]; then
            WRITE_XML_COMMON 0 "INFO:replication not configure"
            ret=0
            break
        fi

        NodeNum=`echo "${item}" | awk '{print $5}'`
        ChannelNum=`echo "${item}" | awk '{print $6}'`
        if [ "X$NodeNum" = "X0" ] && [ "X$ChannelNum" != "X0" ]; then
            LOG "[$FUNCNAME], NodeNum($NodeNum), ChannelNum($ChannelNum)"
            ret=1
        fi
        WRITE_XML_COMMON 0 "NodeNum:$NodeNum||ChannelNum:$ChannelNum"

    done <$tmpFile

    return $ret
}

#247.Check ReplicationZone Status
checkReplicationZoneStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local tmpFile="/tmp/tmpfile$FUNCNAME"
    local dfsFlag=0
    local sFlag=0

    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    else
        LOG "license resource exists."
    fi

    isFindMasterNode=0
    isFindCtrlNode=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch $TASK_ID 60 "${G_GET_REPLICATION_INFO} ZoneStatus > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                sFlag=1
                continue
            fi

            dfsFlag=1
            remote_exec_checkfini $Item $TASK_ID "Can not get information about replication zone status"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:excute check cmd failed"
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME) failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:remote download file failed"
                isPass=1
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            interCheckReplicationZoneStatus "$Item" "$G_TMP_FILE$Item"
            ret=$?
            if [ $ret -ne 0 ]; then
                isPass=1
            fi
    done

    if [ $dfsFlag = 1 ];then
        if [ $isPass -eq 0 ]; then
            #cluster no rep master node
            if [ $isFindMasterNode -eq 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Error:Not find master node"
            #cluster no rep ctrl node
            elif [ $isFindCtrlNode -eq 0 ]; then
                WRITE_XML_COMMON 0 "INFO:replication not configure"
            fi
        fi
    fi
    LOG "[$FUNCNAME] pass:$isPass."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

interCheckReplicationPairStatus()
{
    local NodeIP="$1"
    local tmpFile="$2"
    local ret=0

    sed -i /^shell-init:*/d "${tmpFile}"
    while read item
    do
        nodeStatus=`echo "${item}" | awk '{print $1}'`
        if [ "X$nodeStatus" != "X0" ]; then
            LOG "[$FUNCNAME] Node: $NodeIP nodeStatus: $nodeStatus."
            ret=0
            break
        fi

        isGetSuccess=`echo "${item}" | awk '{print $2}'`
        isMasterNode=`echo "${item}" | awk '{print $3}'`
        isCtrlNode=`echo "${item}" | awk '{print $4}'`

        #cmd exec fail
        if [ "X$isGetSuccess" = "XFail" ]; then
            WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:excute diagnose cmd failed"
            ret=2
            break
        fi

        if  [ "$isMasterNode" == "MasterNode" ]; then
            isFindMasterNode=1
            if [ "$isCtrlNode" == "-" ]; then
                #MasterNode and isCtrlNode=-, display:$NodeNum $PairCount
                CheckReplicationMasterNodePair "${item}" "${NodeIP}"
                ret=$?
                return $ret
            fi
        fi
        if  [ "X$isCtrlNode" != "XCtrlNode" ]; then
            ret=0
            break
        fi

        isFindCtrlNode=1
        #ctrl link info
        if [ "X$isGetSuccess" = "XEmpty" ]; then
            WRITE_XML_COMMON 0 "INFO:replication pair not configure"
            ret=0
            break
        fi

        PairId=`echo "${item}" | awk '{print $5}'`
        RunningStatus=`echo "${item}" | awk '{print $6}'`
        HealthStatus=`echo "${item}" | awk '{print $7}'`
        if [ "$RunningStatus" == "Interrupted" ] || [ "$RunningStatus" == "ToBeRecoverd" ] || [ "$RunningStatus" == "Invalid" ]; then
            LOG "[$FUNCNAME] NodeIP($NodeIP), PairId($PairId), RunningStatus($RunningStatus), HealthStatus($HealthStatus)."
            ret=1
        fi
        WRITE_XML_COMMON 0 "PairId:$PairId||RunningStatus:$RunningStatus||HealthStatus:$HealthStatus"
    done <$tmpFile

    return $ret
}

#248 Check Replication Pair Status
checkReplicationPairStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local tmpFile="/tmp/tmpfile$FUNCNAME"
    local dfsFlag=0


    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    else
        LOG "license resource exists."
    fi

    isFindMasterNode=0
    isFindCtrlNode=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch $TASK_ID 60 "${G_GET_REPLICATION_INFO} PairStatus > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do

        #checkڵ
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
            continue
        fi

        dfsFlag=1
            remote_exec_checkfini $Item $TASK_ID "Can not get information about replication pair status"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:excute check cmd failed"
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME) failed."
                isPass=1
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            interCheckReplicationPairStatus "$Item" "$G_TMP_FILE$Item"
            ret=$?
            if [ $ret -ne 0 ]; then
                isPass=1
            fi
    done

    if [ $dfsFlag = 1 ];then
        if [ $isPass -eq 0 ]; then
            #cluster no rep master node
            if [ $isFindMasterNode -eq 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Error:Not find master node"
            fi
        fi
    fi
    LOG "[$FUNCNAME] pass:$isPass."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#249.Check Replication Version
checkReplicationVersion()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    local tmpFile="/tmp/tmpfile$FUNCNAME"

    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    else
        LOG "license resource exists."
    fi

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
       remote_exec_async_batch $TASK_ID 60 "${G_GET_REPLICATION_INFO} Version > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1

            remote_exec_checkfini $Item $TASK_ID "Can not get information about replication version"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:excute check cmd failed"
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]:Node:$Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME) failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:remote download file failed"
                isPass=1
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            sed -i /^shell-init:*/d "${G_TMP_FILE}""${Item}"
            nodeStatus=`cat $G_TMP_FILE$Item | awk '{printf $1}'`
            if [ "X$nodeStatus" != "X0" ]; then
                LOG "[$FUNCNAME] Node: $NodeIP nodeStatus: $nodeStatus."
                continue
            fi

            isGetSuccess=`cat $G_TMP_FILE$Item | awk '{printf $2}'`
            if [ "X$isGetSuccess" = "XFail" ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:excute diagnose cmd failed"
                continue
            fi
            repVersion=`cat $G_TMP_FILE$Item | awk '{printf $4}'`
            WRITE_XML_COMMON 0 "Node:$Item||RepVersion:$repVersion"
            if [ -z "$firstVersionInfo" ]; then
                firstVersionInfo="$repVersion"
            else
                if [ "X$firstVersionInfo" != "X$repVersion" ]; then
                    isPass=1
                fi
            fi
    done

    LOG "[$FUNCNAME] pass:$isPass."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#251.Check TLV black list
checkTLVBlacklist()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    local service_type=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        #checkڵͣDFSִ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            errResult="Does not involve"
            WRITE_XML_COMMON 0 "Node:$Item||INFO:$errResult"
            continue
        fi
        remote_exec_async $Item $TASK_ID 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 988 'nvshow black' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||Error:Failed to execute command."
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            dfsFlag=1

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get metadata black list"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            dos2unix $G_TMP_FILE$Item
            cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            info1=$(cat $G_TMP_FILE$Item |grep -A1 g_astNv_MetaBlack)
            if [ -z "${info1}" ]; then
                LOG "[$FUNCNAME] Node: $Item||Error: can not get key word g_astNv_MetaBlack"
                WRITE_XML_ERROR 0 "Node:$Item||Error:can not get key word g_astNv_MetaBlack."
                isPass=1
            fi
            info2=$(echo "${info1}" |grep -v g_astNv_MetaBlack)
            if [ -z "${info2}" ]; then #Ѳͨ
                WRITE_XML_COMMON 0 "Node:$Item||INFO:There are no metadata black lists in the node."
            else                       #Ѳ첻ͨ
                LOG "[$FUNCNAME] Node: $Item||Error: There are some metadata black lists in the node."
                WRITE_XML_ERROR 0 "Node:$Item||Error:There are some metadata black lists in the node."
                isPass=1
            fi

            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#252.Check data migration task
checkDataMigrationTask()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local connectCount=0
    REMOTE_IP_S=$(cat /proc/monc_jmmap | grep 'active manager ip' | awk -F'(' '{print $2}' | awk -F')' '{print $1}')

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        for time in ${RepeatTimes[*]}; do
        pingResult=$(ping -q -c 1 $Item |grep "1 received" |wc -l)
            local iRet=$?
            if [ $iRet -ne 0 ]; then
                sleep 10
            else
                break
            fi
        done
        if [ "1" == "$pingResult" ];then
            connectCount=1
            #manager get job 100 1100ʾǨ1ʾǰе
            #manager get job 109 1109ʾһǨ1ʾǰе
            remote_exec_async $Item $TASK_ID 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4100 'manager get job 100 1' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1;sleep 3;$G_MML_FILE_PATH/ShowInspectMml $Item 4100 'manager get job 109 1' >> $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command."
                isPass=1
            else
                echo -n "$Item " >> ${VALID_IP_FILE}
            fi

            break
        fi
    done

    ValidIP=`cat ${VALID_IP_FILE}`

    if [ "${connectCount}" == "0" ];then
        LOG "[$FUNCNAME] Node: $Item||Error:Failed to connect bjm master."
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to connect bjm master."
        isPass=1
    fi

    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get bjm job information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
        echo "FlagDownfail" >> $G_TMP_FILE$Item 2>&1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        FlagDownfail=`cat $G_TMP_FILE$Item |grep FlagDownfail`
        if [ "$FlagDownfail" != "" ];then
            LOG "[$FUNCNAME]:IP:$Item,Down file fail"
            continue
        fi

            set_ifs
            dos2unix $G_TMP_FILE$Item

            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            cat $G_TMP_FILE$Item |grep "data_migration"
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]: There are no data-migration tasks which are running in system."
                WRITE_XML_COMMON 0 "There are no data-migration tasks which are running in system."
                restore_ifs

                WRITE_XML_JUDGE $isPass
                WRITE_XML_SUBCMD_TAIL
                return
            fi

            while read line; do
                echo "$line" |grep "data_migration"
                if [ $? -ne 0 ]; then
                    continue
                fi
                task_id=$(echo "$line"|awk -F " " '{print $1}' | awk -F "(" '{print $2}' |awk -F ")" '{print $1}')
                task_name=$(echo "$line"|awk -F " " '{print $2}' | awk -F "(" '{print $2}' |awk -F ")" '{print $1}')
                startTime=$(echo "$line"|awk -F " " '{print $6}' | awk -F "(" '{print $2}' |awk -F ")" '{print $1}')
                tmpstartTime=`date -d @${startTime} "+%Y-%m-%d %H:%M:%S"`
                endTime=$(echo "$line"|awk -F " " '{print $7}' | awk -F "(" '{print $2}' |awk -F ")" '{print $1}')
                if [ "$endTime" = "0" ];then
                    tmpendTime="--"
                else
                    tmpendTime=`date -d @${endTime} "+%Y-%m-%d %H:%M:%S"`
                fi
                usedTime=$(echo "$line"|awk -F " " '{print $8}')
                usedTime2=$(echo "$usedTime"|awk -F "(" '{print $2}'|awk -F ")" '{print $1}')
                if [ $usedTime2 -ge 2592000 ]; then
                    isPass=1
                fi
                WRITE_XML_COMMON 0 "TaskID:$task_id||Task_Name:$task_name||Start_Time:${tmpstartTime}||Finish_Time:${tmpendTime}||Used_Time:$usedTime2"
            done < $G_TMP_FILE$Item

            restore_ifs
    done
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#253.check default log print level
checkLogPrintLvl()
{
    WRITE_XML_SUBCMD_HEADER $1

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    local isPass=0

    for Item in $REMOTE_IP_S;
    do
        set_ifs
        log_result=`remote_exec $Item 30 "$G_MML_FILE_PATH/CheckLogPrintLvl"`
        iRet=$?
        LOG "[$FUNCNAME]node:$Item, log_result:$log_result,iRet:$iRet."

        is_warn=`echo $log_result |grep WARN`

        if [ -n "$is_warn" -a "$iRet" -eq "0" ]
        then
            Result="Node:$Item||INFO: $log_result"
        else
            isPass=1
            Result="Node:$Item||INFO: $log_result"
        fi

        restore_ifs
        WRITE_XML_COMMON 0 "$Result"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#254 󴢴״̬
function checkObjsServiceStat()
{
    WRITE_XML_SUBCMD_HEADER $1

    local Result=""
    local errResult=""
    local isPass=0
    local TASK_ID=0
    local hostname=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowObjsProcess > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ 0 -ne $? ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            LOG "[$FUNCNAME]:IP:$Item"
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get Process information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="IP: $Item||Error: exec (ShowObjsProcess) failed.iRet($iRet),errno($errno)!||${errResult}"
                LOG "[$FUNCNAME]$Item exec(get Object Storage progress) failed.iRet($iRet),errno($errno)!"
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi
            hostname=$(get_node_hostname_from_db "${Item}")
            dos2unix $G_TMP_FILE$Item

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                   isPass=1
                fi
                if [ "$(echo $info|grep -w "Does not involve")" = "" ];then
                WRITE_XML_COMMON 0 "nodeName:$hostname||backIP:$Item||$info"
                else
                    WRITE_XML_ERROR 0  "Node:$Item||INFO:$info"
                fi

            done < $G_TMP_FILE$Item
            restore_ifs

            WRITE_XML_COMMON 0 "${ret}"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#256.״̬
checkAvServerStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local totalline=0
    local numCnt=1
    local switch=0
    local avstatus=""
    local avtmpstatus=""
    local isDfs=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    for Item in $REMOTE_IP_S
    do
        #1.checkڵ
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "[$FUNCNAME]: $Item is not DFS node."
            continue
        fi
        isDfs=1
        break
    done

    if [ $isDfs -ne 0 ];then
        set_ifs
        while true; do
            local back_ip=`get_backnet_ip`
            if [ "$back_ip" = "" ]; then
                LOG "[$FUNCNAME]:INFO: Can't get local ip"
                isPass=1
                WRITE_XML_COMMON 0 "INFO:Can't get local ip"
                break
            fi
            #1.ѯ״̬
            $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm avconfig show"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "[$FUNCNAME] get antivirus config info failed."
                WRITE_XML_COMMON 0 "Get antivirus configuration info failed."
                break
            else
                #2.жϷ״̬رգѲɹ
                switch=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep 'enableScan' | awk -F ':' '{print $2}' | awk 'gsub(/\r/,"")1' | awk 'gsub(/ /,"")1'`
                if [ $switch == 1 ]; then
                    #3.ش򿪣ȡ״̬
                    $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm avserver show" >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
                    iRet=$?
                    if [ $iRet -ne 0 ];then
                        isPass=1
                        LOG "[$FUNCNAME] get antivirus server info failed."
                        WRITE_XML_COMMON 0 "Get antivirus server info failed."
                        break
                    else
                        cat /var/log/antivirus_servers  | grep -E 'runningStatus|serverIPAddr' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
                        #4.û÷Ѳʧ
                        iRet=$?
                        if [ $iRet -ne 0 ]; then
                            isPass=1
                            LOG "[$FUNCNAME] antivirus server is not configed."
                            WRITE_XML_COMMON 0 "Antivirus server is not configed."
                            break
                        else
                            totalline=`cat $G_REMOTE_TMP_FILE$FUNCNAME | wc -l`
                        fi
                    fi
                    #5.״̬йϣѲʧ
                    #6.״̬Ѳɹ
                    while [ $numCnt -le $totalline ]; do
                        avtmpstatus=`sed -n "${numCnt}p" $G_REMOTE_TMP_FILE$FUNCNAME | awk -F ':' '{print $2}' | awk 'gsub(/\r/,"")1' | awk 'gsub(/ /,"")1'`
                        if [ $avtmpstatus == "35" ]; then
                            isPass=1
                            LOG "[$FUNCNAME]antivirus server fault."
                        fi
                        avstatus=`sed -n "${numCnt}p" $G_REMOTE_TMP_FILE$FUNCNAME | awk -F ':' '{print $2}' | awk 'gsub(/\r/,"")1' | awk 'gsub(/ /,"")1'`
                        if [ $avstatus == "35" ]; then
                            avstatus="AV_SERVER_STATUS_FAULT"
                        elif  [ $avstatus == "1" ]; then
                            avstatus="AV_SERVER_STATUS_NORMAL"
                        else [ $avstatus == "89" ]
                            avstatus="AV_SERVER_STATUS_BUSY"
                        fi
                        serverIp=`sed -n "$((numCnt+1))p" $G_REMOTE_TMP_FILE$FUNCNAME | awk '{print $2}' | awk 'gsub(/\r/,"")1' | awk 'gsub(/ /,"")1'`
                        LOG "AntivirusServer:${serverIp}||Status:${avstatus}"
                        WRITE_XML_COMMON 0 "Server:${serverIp}||Status:${avstatus}"
                        numCnt=$((numCnt+2))
                    done
                    break
                else

                    WRITE_XML_COMMON 0 "The antivirus service is closed."
                    break
                fi
            fi
        done
        restore_ifs
    else
        WRITE_XML_COMMON 0 "Does not involve."
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#257.鼯ȺǷ
function checkMdsSubTreeNum()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local SumNum=0
    local SubtreeNum=0
    local TASK_ID=0
    local isDfs=0
    local MaxSubtreeNum=80000

    local MDSMaster=""
    local Result=""
    MDSFILE="/var/log/snas.mds.cache.log"
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch_mml $TASK_ID 30 GetMdsSubtreeInfo $FUNCNAME
    isPass=$?

    sleep 5
    ValidIP=`cat ${VALID_IP_FILE}`
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            #checkڵ
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "[$FUNCNAME]: $Item is not DFS node."
                continue
            fi
            isDfs=1
            remote_exec_checkfini $Item $TASK_ID "Can not get mds info show information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                continue
            fi

            #Ϊ100%֮ļأн
            remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                isPass=1
                continue
            fi

            MDSMaster=`cat $G_TMP_FILE$Item | grep "root mds ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
            if [ "$MDSMaster" == "" ];then
                isPass=1
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                Result="INFO:Failed to get MDS master."
                break
            fi

            #16ƵַʽתΪipv4͵ַ
            mdsMastertmp=$MDSMaster
            mdsMasterIP=`hextoip "${mdsMastertmp}"`
            LOG "[$FUNCNAME]mdsMasterIP:$mdsMasterIP"
            if [ "mdsMasterIP" == "" ];then
                LOG "[$FUNCNAME]:Failed to execute command(mds info show),get masterIp($mdsMastertmp) err."
                Result="Failed to execute command(mds info show),get masterIp(${mdsMastertmp}) err."
                isPass=1
                break
            fi

            #MDSִнű, ִнűGetMdsSubtreeNum
            remote_exec $mdsMasterIP 60 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds gst showtree 0x400 0' > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
            iRet=$?
            if [ $iRet -ne 0 ];then
                #Իȡ2ip
                MDSMaster=`cat $G_TMP_FILE$Item | grep "root mds 2nd ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
                if [ "$MDSMaster" == "" ];then
                    isPass=1
                    cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                    Result="INFO:Failed to get MDS master."
                    break
                fi

                #16ƵַʽתΪipv4͵ַ
                mdsMastertmp=$MDSMaster
                mdsMasterIP=`hextoip "${mdsMastertmp}"`
                LOG "[$FUNCNAME]mdsMasterIP:$mdsMasterIP"
                if [ "mdsMasterIP" = "0" ];then
                    LOG "[$FUNCNAME]:Failed to execute command(mds info show),get masterIp($mdsMastertmp) err."
                    Result="Failed to execute command(mds info show),get masterIp(${mdsMastertmp}) err."
                    isPass=1
                    break;
                fi

                #MDSִнű, ִнűGetMdsSubtreeNum
                remote_exec $mdsMasterIP 60 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds gst showtree 0x400 0' > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
                iRet=$?
            fi

            if [ $iRet -ne 0 ];then
                Result="ERR:Failed to execute mml(mds gst showtree 0x400 0) on $mdsMasterIP.iRet($iRet)"
                LOG "[$FUNCNAME]:Failed to execute mml(mds gst showtree 0x400 0) on $mdsMasterIP.iRet($iRet)"
                isPass=1
                break
            fi

            #
            remote_download_sync $mdsMasterIP $G_TMP_FILE $MDSFILE
            iRet=$?
            if [ $iRet -ne 0 ];then
                Result="ERR:download $MDSFILE from $mdsMasterIP fail"
                LOG "[$FUNCNAME]download $MDSFILE from $mdsMasterIP fail"
                isPass=1
                break
            fi
            #ͳƼȺ
            MdsInfo=`cat /proc/monc_mdsmap |grep -w "Rank"`
            set_ifs
            for line in $MdsInfo;do
                Mdsidx=`echo $line |awk '{print $4}'`
                IpAddr=`echo $line |awk '{print $8}'`
                if [ "$mdsMasterIP" == "$IpAddr" ];then
                    Role=Leader
                else
                    Role=Member
                fi
                #ͳƼȺ
                SubtreeNum=`cat $G_TMP_FILE | grep "InoPop" | grep -v "I(400)" | grep "A($Mdsidx)" | wc -l`
                SumNum=$((SumNum+SubtreeNum))

                WRITE_XML_COMMON 0 "Node:$IpAddr||Mdsidx:$Mdsidx||Role:$Role||Subtree_num:$SubtreeNum"
                LOG "[$FUNCNAME]Node:$IpAddr,Mdsidx:$Mdsidx,Role:$Role,Subtree_num:$SubtreeNum,SumNum=$SumNum"
            done
            restore_ifs
            if [ $SumNum -ge $MaxSubtreeNum ];then
                isPass=1
                WRITE_XML_ERROR 0 "There are $SubtreeNum subtrees in cluster, exceed $MaxSubtreeNum"
                LOG "[$FUNCNAME]:There are $SubtreeNum subtrees in cluster, exceed $MaxSubtreeNum."
            fi

            >${VALID_IP_FILE}
            break
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    if [ "$MDSMaster" == "" ];then
        if [ $isDfs -eq 0 ];then
            isPass=0
            Result="There are not DFS nodes in the cluster environment."
        fi
    fi

    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass

    WRITE_XML_SUBCMD_TAIL
}

#258.rpcǷȷ
checkRpcBindCore()
{
    WRITE_XML_SUBCMD_HEADER $1
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    isPass=0

    for Item in $REMOTE_IP_S; do

        set_ifs
        log_result=`remote_exec $Item 30 "$G_MML_FILE_PATH/CheckRpcBindCore"`
        iRet=$?
        LOG "[$FUNCNAME]node:$Item, log_result:$log_result,iRet:$iRet."

        is_correct=`echo $log_result |grep 'pass!'`

        if [ -z "$is_correct" ]
        then
            isPass=1
            Result="Node:$Item||RESULT: $log_result"
        else
            Result="Node:$Item||RESULT: $log_result"
        fi
        restore_ifs
        WRITE_XML_COMMON 0 "$Result"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#259.ִָйNLUN
checkNlunExecTooLong()
{
    WRITE_XML_SUBCMD_HEADER $1
    local errResult=""
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #Զ첽ִҪУipVALID_IP_FILE
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/CheckNlunExecTooLong > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIp=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIp

    fifo_start
    while [[ ${ValidIp} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIp
        do
            LOG "[$FUNCNAME]:IP:$Item"
            #Զִн
            remote_exec_checkfini $Item $TASK_ID "Can not get recovery nlun exec time"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            #Զ100%Ժִнļ
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="[$FUNCNAME]$Item exec(Check exec too long nlun) failed.iRet($iRet),errno($errno)!"
                LOG "[$FUNCNAME]$Item exec(Check exec too long nlun) failed.iRet($iRet),errno($errno)!"
                isPass=1
                echo "FlagDownfail" >> $G_TMP_FILE$Item 2>&1
                continue;
            fi
        done
        ValidIp=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        dos2unix $G_TMP_FILE$Item
        #
        cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
        FlagDownfail=`cat $G_TMP_FILE$Item |grep FlagDownfail`
        if [ "$FlagDownfail" != "" ];then
            LOG "[$FUNCNAME]:IP:$Item,Down file fail"
            continue
        fi

        set_ifs
        is_correct=`cat $G_TMP_FILE$Item |grep "no nlun executed"`
        if [ -n "$is_correct" -a "$iRet" -eq "0" ]
        then
            Result="Node:$Item||INFO: There is no recovery task executed too long"
        else
            isPass=1
            Result="Node:$Item||INFO: Some recovery tasks are executed too long"
        fi
        restore_ifs
        WRITE_XML_COMMON 0 "$Result"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#260.check ad connection
checkADdomainControllerStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0
    local dcUnAvlCnt=0
    local nodecnt=0

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/nas_checkADdomainControllerStatus > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    fifo_start
    while [ ! -z "${ValidIP}" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get Node NAS Connnect information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="IP: $Item||Error: exec (ShowNasConnInfo) failed.iRet($iRet),errno($errno)!||${errResult}"
                LOG "[$FUNCNAME]$Item exec(ShowNasConnInfo progress) failed.iRet($iRet),errno($errno)!"
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish
    for Item in $ValidIPResult; do
            dos2unix $G_TMP_FILE$Item
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" == "" ];then
                continue
            fi

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            nodecnt=$[ $nodecnt+1 ]
            set_ifs

            while read line; do
                info=`handle_remote_result "${line}"`
                if [ $? -ne 0 ]; then
                    isPass=1
                fi
                check_result=`echo ${line} | grep "DOMAIN AVAILABLE:no" | wc -l`
                if [ ${check_result} -eq 1 ]; then
                    dcUnAvlCnt=$[ $dcUnAvlCnt+1 ]
                fi
                WRITE_XML_COMMON 0 "Node:$Item||$info"
            done < $G_TMP_FILE$Item
            restore_ifs
    done

    if [ $dcUnAvlCnt -ne 0 ]; then
        isPass=1
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#261. ʱ
function checkDelayReimportDisk()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0
    local ret=0

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    #Զ첽ִ
    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $TASK_ID 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 988 'pma delay-reimport' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||Error:Failed to execute command."
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            LOG "[$FUNCNAME]:IP:$Item"
            #Զִн
            remote_exec_checkfini $Item $TASK_ID "Can not get delay re-import disk"
            iRet=$?
            if [ $iRet -eq 0 ]; then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ]; then
                isPass=1
                continue
            fi

            #Զ100%Ժִнļ
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="[$FUNCNAME]$Item exec(get delay re-import disk) failed.iRet($iRet),errno($errno)!"
                LOG "[$FUNCNAME]$Item exec(get delay re-import disk) failed.iRet($iRet),errno($errno)!"
                isPass=2
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item
            sed -i 's/\x1B\[0;[3-4][0-9]m//g' $G_TMP_FILE$Item
            while read line
            do
                tmp=`echo ${line} | grep 'pool name' `
                if [ "${tmp}" != "" ]; then
                    isPass=1
                    Result="NodeIp:$Item||Info:$line"
                else
                    tmp=`echo ${line} | grep 'no delay' `
                    if [ "${tmp}" == "" ]; then
                        continue
                    else
                        Result="NodeIp:$Item||Info:None"
                    fi
                fi
                WRITE_XML_COMMON 0 "$Result"
            done < $G_TMP_FILE$Item
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#262. license
checkExpandLicense()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local iRet=0

    while true; do

        sysNodeNum=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select count(*) from CM_NODE_T"`
        iRet=$?
        if [ $iRet -ne 0 ]; then
            sleep 1
            sysNodeNum=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select count(*) from CM_NODE_T"`
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME][$LINENO]Can't get sysNodeNum by sqlite3,iRet=$iRet"
                WRITE_XML_COMMON 0 "INFO:Can't get the number of nodes in system."
                isPass=1
                break
            fi
        fi

        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            LOG "[$FUNCNAME][$LINENO]Can't get local ip"
            isPass=1
            WRITE_XML_COMMON 0 "INFO:Can't get local ip"
            break
        fi

        #ִmml cm licensecfg
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm licensecfg"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME][$LINENO]mml_result:$Info"
            WRITE_XML_COMMON 0 "INFO:Failed to execute command(cm licensecfg)."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1

        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "get license res cfg fail"`
        if [ "$Info" != "" ];then
            #һжǷмlicenseļ
            WRITE_XML_ERROR 0 "INFO:License is not activated."
            break
        fi

        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "acFeatureName"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "$javaID" = "" ];then
            LOG "[$FUNCNAME][$LINENO]$line,javaID is null"
            WRITE_XML_ERROR 0 "INFO:No license resource active."
            break
        fi

        set_ifs
        for line in $javaID
        do
            if [ $line = "" ];then
                continue
            fi

            Feature=`echo $line |awk '{print $3}'`
            MaxNumber=`echo $line |awk '{print $11}'|sed 's/\./ /g'`
            Deadline=`echo $line |awk '{print $7}'`
            LOG "[$FUNCNAME][$LINENO]Deadline:$Deadline"
            if [ "${Deadline}" == "9999-12-31" ];then
                date1=$(date --date "${Deadline}" +%s)
                Deadline="PERMANENT"
            else
                date1=`expr $Deadline \/ 1000`
                Deadline=`date --date "1970-01-01 UTC $date1 seconds" +"%Y-%m-%d %T %z"`
            fi
            LOG "[$FUNCNAME][$LINENO]Deadline:$Deadline"
            date2=`date`

            t1=$date1
            t2=`date --date "$date2" +%s`
            LOG "[$FUNCNAME][$LINENO]Deadline:$t1,CurrentTime:$t2"
            if [ $t1 -lt $t2 ]; then
                isPass=1
            elif [ $MaxNumber -le $sysNodeNum ]; then
                isPass=1
            fi

            Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline||NodeNum:$sysNodeNum"
            LOG "[$FUNCNAME][$LINENO]Result($Result),isPass=$isPass"
            WRITE_XML_COMMON 0 "$Result"
        done
        restore_ifs

        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#263. CMڵdeploy̼
checkCMMasterDeploy()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local deployFile="/opt/huawei/deploy/bin/snas_deploy"
    local deployProduct="/opt/product/deploy/bin/snas_deploy"

    LOG "[$FUNCNAME][$LINENO]start!"

    while true; do
        deployProcess=`ps -ef|grep "$deployFile"|grep -v grep|awk '{print $8}'`
        if [ "$deployProcess" != "$deployFile" ]; then
            WRITE_XML_COMMON 0 "$deployProduct is not running"
            isPass=1
        else
            WRITE_XML_COMMON 0 "$deployProduct is running"
        fi

        break
    done

    LOG "[$FUNCNAME][$LINENO]finish! errResult=$errResult"

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#264. S3 S3FSǷ
checkS3FSService()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local G_TMP_FILE_Item=()
    local count=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/checkS3FSService > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            #check node type
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" == "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            remote_exec_checkfini $Item $TASK_ID "Can not get s3fs service status information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME] $Item exec(checkS3FSService) failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO: Failed to execute command(${G_MML_FILE_PATH}/checkS3FSService)"
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[${FUNCNAME}] ${Item} download ${G_REMOTE_TMP_FILE}${FUNCNAME} failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO:Cannot get s3fs service status information!"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                continue
            fi

            G_TMP_FILE_Item[count]=$Item
            count=$((count+1))

        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in ${G_TMP_FILE_Item[*]}; do
        nodePass=`grep "isPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        sMount=`grep "s3fs:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        lsS3FS=`grep "s3fs:" $G_TMP_FILE$Item |awk -F ":" '{print $3}'`
        bMount=`grep "bill:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        lsBILL=`grep "bill:" $G_TMP_FILE$Item |awk -F ":" '{print $3}'`
	sPath=`grep "sPath:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
	bPath=`grep "bPath:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`

        #ıʶͬӰ칤߽ʾ
        Result="Node:$Item||Path:${sPath}||Is Mounted:${sMount}||Can LS:${lsS3FS}"
        Result="Node:$Item||Path:${bPath}||Is Mounted:${bMount}||Can LS:${lsBILL}||${Result}"
        WRITE_XML_COMMON 0 "$Result"

        if [ "${nodePass}""X" != "0X" ];then
            isPass=1
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#265. UPFݿⱸ.

checkUPFDBBackup()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local G_TMP_FILE_Item=()
    local count=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/checkUPFDBBackup > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            #check node type
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" == "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            remote_exec_checkfini $Item $TASK_ID "Can not get upf database backup information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME] $Item exec(checkUPFDBBackup) failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO: Failed to execute command(${G_MML_FILE_PATH}/checkUPFDBBackup)"
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[${FUNCNAME}] ${Item} download ${G_REMOTE_TMP_FILE}${FUNCNAME} failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO:Cannot get upf database backup information!"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                continue
            fi

            G_TMP_FILE_Item[count]=$Item
            count=$((count+1))

        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in ${G_TMP_FILE_Item[*]}; do
        local isCheck=`grep "isCheck:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        if [ "X$isCheck" == "X0" ];then
            LOG "This node not need to check, isCheck:[$isCheck] ${Item}."
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
            continue
        fi

        local nodePass=`grep "isPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        grep "NotExist" $G_TMP_FILE$Item|awk -F":" '{print $2}'|while read line
        do
            Result="Backup Failed Date:$line"
            WRITE_XML_COMMON 0 "$Result"
        done

        if [ "${nodePass}""X" != "0X" ];then
            isPass=1
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#266. S3ؼ.

checkS3KeySerStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local G_TMP_FILE_Item=()
    local count=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/checkS3KeySerStatus > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            #check node type
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" == "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            remote_exec_checkfini $Item $TASK_ID "Can not get s3 key service information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME] $Item exec(checkS3KeySerStatus) failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO: Failed to execute command(${G_MML_FILE_PATH}/checkS3KeySerStatus)"
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[${FUNCNAME}] ${Item} download ${G_REMOTE_TMP_FILE}${FUNCNAME} failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO:Cannot get s3 key service information!"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                continue
            fi

            G_TMP_FILE_Item[count]=$Item
            count=$((count+1))

        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in ${G_TMP_FILE_Item[*]}; do
        local isCheck=`grep "isCheck:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        if [ "X$isCheck" == "X0" ];then
            LOG "This node not need to check, isCheck:[$isCheck] ${Item}."
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
            continue
        fi

        local nodePass=`grep "isPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        local nodeType=`grep "nodeType:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        local errPro=`grep "errPro:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        Result="Node:$Item||NodeType:${nodeType}||Error Service:${errPro}"
        WRITE_XML_COMMON 0 "$Result"

        if [ "${nodePass}""X" != "0X" ];then
            isPass=1
        fi
    done
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#268. DNSҵ״̬Ѳ.

checkS3DNSservice()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local G_TMP_FILE_Item=()
    local count=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/checkS3DNSservice > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            #check node type
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" == "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            remote_exec_checkfini $Item $TASK_ID "Can not get s3 DNS service information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME] $Item exec(checkS3DNSservice) failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO: Failed to execute command(${G_MML_FILE_PATH}/checkS3DNSservice)"
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[${FUNCNAME}] ${Item} download ${G_REMOTE_TMP_FILE}${FUNCNAME} failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO:Cannot get s3 DNS service information!"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                continue
            fi

            G_TMP_FILE_Item[count]=$Item
            count=$((count+1))

        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in ${G_TMP_FILE_Item[*]}; do
        local isCheck=`grep "isCheck:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        if [ "X$isCheck" == "X0" ];then
            LOG "This node not need to check, isCheck:[$isCheck] ${Item}."
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
            continue
        fi

        local nodePass=`grep "isPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        if [ "${nodePass}""X" != "0X" ];then
            Result="Node:$Item||Check result:failed"
            WRITE_XML_COMMON 0 "$Result"
            isPass=1
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#269. Ѳ.

checkBillService()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local G_TMP_FILE_Item=()
    local count=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/checkBillService > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            #check node type
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" == "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            remote_exec_checkfini $Item $TASK_ID "Can not get bill information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME] $Item exec(checkBillService) failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO: Failed to execute command(${G_MML_FILE_PATH}/checkBillService)"
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[${FUNCNAME}] ${Item} download ${G_REMOTE_TMP_FILE}${FUNCNAME} failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO:Cannot get bill information!"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                continue
            fi

            G_TMP_FILE_Item[count]=$Item
            count=$((count+1))

        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in ${G_TMP_FILE_Item[*]}; do
        local isCheck=`grep "isCheck:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        if [ "X$isCheck" == "X0" ];then
            LOG "This node not need to check, isCheck:[$isCheck] ${Item}."
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
            continue
        fi

        local nodePass=`grep "isPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        local origPass=`grep "origPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        local storPass=`grep "storPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        if [ "${origPass}""X" == "0X" ];then
            Result="Node:$Item||INFO:Check Operation-Specific CDR path failed"
            WRITE_XML_COMMON 0 "$Result"
        else
            Result="Node:$Item||INFO:Check Operation-Specific CDR path success"
            WRITE_XML_COMMON 0 "$Result"
        fi
        if [ "${storPass}""X" == "0X" ];then
            Result="Node:$Item||INFO:Check Storage-Specific CDR path failed"
            WRITE_XML_COMMON 0 "$Result"
        else
            Result="Node:$Item||INFO:Check Storage-Specific CDR path success"
            WRITE_XML_COMMON 0 "$Result"
        fi

        if [ "${nodePass}""X" != "0X" ];then
            isPass=1
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#288.ȲƼ汾
checkHpatchOperation()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0

    #ƻ漰Ѳ
    local IsOem=$(ls /opt/huawei/deploy/package/oem)
    if [ ! -z "$IsOem" ];then
        WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
        WRITE_XML_JUDGE 3
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    local ProductName=$(grep ProductName /opt/huawei/deploy/package/version |awk -F= '{print $2}')
    local ProductVersion=$(grep ProductVersion /opt/huawei/deploy/package/version |awk -F= '{print $2}')
    local patchVersion=$(grep -A4 -w "$ProductVersion" /tmp/productHotPatch.xml |grep -A2 -w "$ProductName" |grep "patchVersion" |awk -F '>' '{print $2}' |awk -F '<' '{print $1}')
    LOG "[$FUNCNAME]:ProductName=$ProductName ProductVersion=$ProductVersion patchVersion=$patchVersion"

    if [ ! -f /tmp/productHotPatch.xml ];then
        isPass=1

        WRITE_XML_ERROR 0 "INFO:Please update or download new tools."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    #Ƽûеǰ汾ȲҪװ
    if [ "X${patchVersion}" == "X" ];then

        WRITE_XML_COMMON 0 "INFO:$ProductVersion have not hot patch in productHotPatch.xml"
    else
        local back_ip=`get_backnet_ip`
        if [ "X${back_ip}" == "X" ];then

            LOG "[$FUNCNAME]:Failed to get back ip"
            isPass=1

            WRITE_XML_ERROR 0 "Node:$back_ip||ERROR:Failed to get back_ip."
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return
        fi
        patchinfo=$(/opt/huawei/snas/upd/patch_script/cluster_patch.sh "$back_ip" show)
        Version=$(echo $patchinfo |grep Version |awk -F "," '{print $3}' |awk -F ":" '{print $2}')
        LOG "[$FUNCNAME]:patchinfo=$patchinfo Version=$Version"

       #δװȲߵƼĲ汾
        if [ "$Version" == "null" ] || [ "$patchVersion" \> "$Version" ];then
            isPass=4
        fi

        WRITE_XML_COMMON 0 "recommend_patchVersion:$patchVersion||local_patchVersion:$Version"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#ûдѲΪ
noInspectItem()
{
    WRITE_XML_SUBCMD_HEADER $1
    WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
    WRITE_XML_JUDGE 3
    WRITE_XML_SUBCMD_TAIL
    LOG "The current system does not support the appointed inspect item!"
}

# **************************************************************************** #
# Function Name: checkSoftwareStatus
# Description: Software м.
# Parameter: $1 cmditemID
# Return:
# **************************************************************************** #
checkSoftwareStatus()
{
    WRITE_XML_CMD_HEADER $1

    #GetBackIPAndRoleFromDB
    LOG_Check

    rm -rf /opt/inspect/tmpfile$!*
    rm -rf /opt/inspect/tmpfilex$!*
    rm -rf /tmp/tmpfile$!*

    LOG "[$FUNCNAME] param = ($1)"
    case $1 in
        200)
            #2.Check Open File Count
            checkOpenFileCount_Async "0"
            ;;
        201)
            #3.Check Node Throughput (ڵ)
            checkNodeThroughput  "0"
            ;;
        202)
            #4.Check Node IO Perform
            checkNodeIOPerform  "0"
            ;;
        203)
            #4.Check Watchdog Status
            checkWatchdogStatus_Async "0"
            ;;
        204)
            #5.Check Monitor's Map status(monϵͳ״̬ mds ds ca pip mapϢ)
            checkMonitorHeartbeat_Async "0"
            ;;
        205)
            #6.Check NTP Service
            checkNTPService_Async "0"
            ;;
        206)
            #7.Check CM master
            checkCMMaster "0"
            ;;
        207)
            #8.Check ISM status
            checkISMStatus_Async "0"
            ;;
        208)
            #9.Check License status
            checkLicenseStatus_MML "0"
            ;;
        209)
            #10.Check File operationļ
            checkFileOperation_Async "0"
            ;;
        210)
            #11.Check NAS client
            checkALLClient "0"
            ;;
        211)
            #12.Check NAS Cluster Status
            checkNASClusterStatus "0"
            ;;
        212)
            #13.Check DS Usage
            checkDSUsage "0"
            ;;
        213)
            #14.Check Communication Link (ڵϵͨѶ·)
            checkCommuLink "0"
            ;;
        214)
            #14.Check memory pool usage (ڴصʹ)
            checkMemPoolUsage_Async "0"
            ;;
        215)
            #Check data consistentһ
            checkDataConsistent_Async "0"
            ;;
        216)
            #Check System inode(ϵͳinodeBirth)
            checkFileInodeAndBirthCount "0"
            ;;
        218)
            #Check system file opened (linuxϵͳ򿪵ļ)
            checkSystemFileOpened "0"
            ;;
        219)
            #Check NIS ط״̬
            checkNIS "0"
            ;;
        220)
            #Check external DNS
            checkExtDnsConn "0"
            ;;
        221)
            #Check LDAP ط״̬
            checkLDAP "0"
            ;;
        222)
            #Check IPMIַǷ
            checkIPMI "0"
            ;;
        223)
            #Check Tierּ
            checkTier "0"
            ;;
        224)
            #Ƿδĸ澯
            checkLeftAlarm_MML "0"
            ;;
        225)
            #ҵڵ״̬  mon mds pip
            checkMasterStatus "0"
            ;;
        226)
            #MON Serverڵ
            checkMonServer "0"
            ;;
        227)
            #Nvdimmڴصʹ
            checkNvdimmPool "0"
            ;;
        228)
            #ָ̨״̬
            checkDataRestore "0"
            ;;
        229)
            #Ⱥֻˮλ
            checkReadOnlyThreshold "0"
            ;;
        230)
            #nlun״̬
            getNlunStatus "0"
            ;;
        231)
            #MONǷƵѡ
            checkMonHealth "0"
            ;;
        232)
            #mdsһ
            checkMdsSubTreeStatus "0"
            ;;
        233)
            #Ƿcoreļ
            checkCoreFile "0"
            ;;
        234)
            #ntp״̬
            checkNtpConn "0"
            ;;
        235)
            #check if there is a RPC leak in node by check reference count of RPC
            #ǷRPCüй©,
            checkNodeRPC_ReferCnt "0"
            ;;
        236)
            #дNOFSǷгʱ
            checkWrtNofsTimeout "0"
            ;;
        237)
            #IPϷ
            checkNodeIPLegality "0"
            ;;
        238)
            #bjm̼
            checkBJM "0"
            ;;
        239)
            #1.Check System Information
            checkSystemInfo_MML "0"
            ;;
        240)
            #1.Check pool status
            checkNodePoolStatus "0"
            ;;
        245)
            #1.Check Replication Link
            checkReplicationLink "0"
            ;;
        246)
            #1.Check Replication Process
            checkReplicationProcess "0"
            ;;
        247)
            #1.Check ReplicationZone Status
            checkReplicationZoneStatus "0"
            ;;
        248)
            #1.Check Replication Pair Status
            checkReplicationPairStatus "0"
            ;;
        249)
            #1.Check ReplicationZone Version
            checkReplicationVersion "0"
            ;;
        251)
            #4.check TLV black list
            checkTLVBlacklist "0"
            ;;
        252)
            #4.check TLV black list
            checkDataMigrationTask "0"
            ;;
        253)
            #check default log print level
            checkLogPrintLvl "0"
            ;;
        254)
            #洢״̬
            checkObjsServiceStat "0"
            ;;
        255)
            #keystone
            checkKeyStone "0"
            ;;
        256)
            #AV Server״̬
            checkAvServerStatus "0"
            ;;
        257)
            #MDS
            checkMdsSubTreeNum "0"
            ;;
        258)
            #rpcǷȷ
            checkRpcBindCore "0"
            ;;
        259)
            #ִָйNLUN
            checkNlunExecTooLong "0"
            ;;
        260)
            #check ad connection
            checkADdomainControllerStatus "0"
            ;;
        261)
            #ʱ
            checkDelayReimportDisk "0"
            ;;
        262)
            #license
            checkExpandLicense "0"
            ;;
        263)
            #CMڵdeploy̼
            checkCMMasterDeploy "0"
            ;;
        264)
            #check s3 s3fs service
            checkS3FSService "0"
            ;;
        265)
            #check ufp database backup service
            checkUPFDBBackup "0"
            ;;
        266)
            #check s3 key service
            checkS3KeySerStatus "0"
            ;;
        268)
            #check s3 dns service
            checkS3DNSservice "0"
            ;;
        269)
            #check bill service
            checkBillService "0"
            ;;
        276)
            #accountcheck
            accountcheck "0"
            ;;
        277)
            #checkbalance
            checkbalance "0"
            ;;
        278)
            #check_gateway
            check_gateway "0"
            ;;
        279)
            #checkbuckinfo
            checkbuckinfo "0"
            ;;
        280)
            #checkdomainname
            checkdomainname "0"
            ;;
        288)
            #ȲƼ汾
            checkHpatchOperation "0"
            ;;
        *)
            noInspectItem "0"
            ;;
        esac
    chmod 640 $LOG_FILE
    WRITE_XML_CMD_TAIL
    rm -rf /opt/inspect/tmpfile$!*
    rm -rf /opt/inspect/tmpfilex$!*
    rm -rf /tmp/tmpfile$!*
    rm -rf /tmp/tmp_valid_ip$!
}

###add Ѳ¿ܣѲ270-275#################

local_exec_cmd()
{
    taskids=$1
    params=$2
    ${G_MML_FILE_PATH}/CheckItems "$taskids" "$params"> $G_DOWNLOAD_FILE$3 2>&1
    iRet=$?
    if [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME]||INFO:cmd failed taskids:($taskids)"
    fi
}

CheckLocalMsgParse()
{
    CheckMsgFile=$1
    PassCode=$2
    dos2unix $CheckMsgFile > /dev/null 2>&1
    while read var
    do
        if [ "$var" != "" ]; then
            if [ "$PassCode" = "1" ];then
                WRITE_XML_ERROR 0 "$var" >/dev/null
                LOG "[$FUNCNAME]||$var"
            else
                WRITE_XML_COMMON 0 "${var}" >/dev/null
            fi
        fi
    done < "$CheckMsgFile"
}

#Ѳ
CheckLocalPassStatus()
{
    PassCode=1
    fun=$1
    RemoteIp=$2
    fun_end=${fun}_End
    strGrep=${fun}_Pass
    CheckMsgFile="/tmp/CheckMsgFile$!"
    PassStatus=$(cat $G_DOWNLOAD_FILE$RemoteIp |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${strGrep}' |awk '{print $2}')
    if [ "$PassStatus" =  "0" ]; then
        PassCode=0
    elif [ "$PassStatus" =  "" ];then
        LOG "[$FUNCNAME]||$fun get Passcode failed from $RemoteIp"
        PassCode=1
    else
        PassCode=$PassStatus
    fi
    #ӽڵѲϢ
    cat $G_DOWNLOAD_FILE$RemoteIp |eval sed '0,/$fun/d' |eval sed '/$strGrep/,\$\d' >$CheckMsgFile
    #дѲXML
    CheckMsg=$(cat $CheckMsgFile)
    if [ "$CheckMsg" = "" ]; then
        WRITE_XML_ERROR 0 "$fun Get CheckMsg failed from $RemoteIp"
    else
        CheckLocalMsgParse "$CheckMsgFile" "$PassCode"
    fi
    rm -rf $CheckMsgFile

    WRITE_XML_JUDGE $PassCode >/dev/null
}

analyse_local_result()
{
    #Զؽһ£xmlд뷽ʽֻܴС
    MainNodeIp=$2
    for taskid in $1
    do
    {
        InspectFun=`GetInspectType $taskid`

        G_CHECK_RESULT_FILE="/opt/inspect/check_result_file"$taskid
        > $G_CHECK_RESULT_FILE
        WRITE_XML_HEADER >/dev/null
        WRITE_XML_CMD_HEADER $taskid >/dev/null
        WRITE_XML_SUBCMD_HEADER "0" >/dev/null
        if [ $InspectFun != "" ];then
            CheckLocalPassStatus "$InspectFun" "$MainNodeIp"
        else
            LOG "[$FUNCNAME]||INFO:The current system does not support the appointed inspect item($taskid)!"
            WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
        fi
        WRITE_XML_SUBCMD_TAIL >/dev/null
        WRITE_XML_CMD_TAIL >/dev/null
        WRITE_XML_TAIL $taskid >/dev/null
    }&
    done
    wait
}

#ִ
exec_cmd()
{
    remoteIp=$1
    taskids=$2
    params=$3
    exec_taskid="CheckItems"
    command="${G_MML_FILE_PATH}/CheckItems '$taskids' '$params'> $G_REMOTE_EXEX_RESULT 2>&1"
    remote_exec_async $remoteIp $exec_taskid 200 "$command"
    iRet=$?
    if [ $iRet -ne 0 ]; then
        LOG "Node:$remoteIp||INFO:Failed to exec_cmd command.taskids($taskids)"
    fi
}


function download_result()
{
    remoteIp=$1
    TASK_ID="CheckItems"
    local iRet=0
    #ѭֱسɹʧܺ˳ѭ
    while [[ ${remoteIp} != "" ]]
    do
    {
        remote_exec_checkfini $remoteIp $TASK_ID "download ($remoteIp) exec result failed"
        iFunRet=$?
        if [ $iFunRet -eq 0 ];then
            continue
        elif [ $iFunRet -eq 2 -o $iFunRet -eq 5 ];then
            iRet=0
        else
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO: remote_exec_checkfini return ($iFunRet)download_result checkfini failed."
            iRet=1
        fi

        #Ϊ100%֮ļأн
        remote_download_sync $remoteIp $G_DOWNLOAD_FILE$remoteIp $G_REMOTE_EXEX_RESULT
        iFunRet=$?
        if [ $iFunRet -ne 0 ];then
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO:remote_download_sync return ($iFunRet) download_result download file failed."
            iRet=1
        fi
        break
    }
    done
    return $iRet
}

CheckMsgParse()
{
    Remote_ip=$1
    CheckMsgFile=$2
    PassCode=$3
    dos2unix $CheckMsgFile > /dev/null 2>&1
    index=0
    while read var
    do
        if [ "$var" != "" ]; then
            if [ "$PassCode" = "1" ];then
                WRITE_XML_ERROR 0 "Node: $Remote_ip||${var}" >/dev/null
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:inspect error ${var}"
            else
                WRITE_XML_COMMON 0 "Node: $Remote_ip||${var}" >/dev/null
            fi
        fi
    done < "$CheckMsgFile"
}

CheckPassStatus()
{
    isPass=0
    fun=$1
    fun_end=${fun}_End
    strGrep=${fun}_Pass
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    CheckMsgFile="/tmp/CheckMsgFile$!"

    for Remote_ip in $REMOTE_IP_S
    do
    {
        PassStatus=$(cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${strGrep}' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:($fun) get PassStatus failed"
            WRITE_XML_ERROR 0 "Node:$Remote_ip||INFO:($fun) get PassStatus failed!"
            isPass=1
        else
            #ӽڵѲϢ
            cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$fun/d' |eval sed '/$strGrep/,\$\d' >$CheckMsgFile
            #дѲXML
            CheckMsg=$(cat $CheckMsgFile)
            if [ "$CheckMsg" = "" ];then
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:$(fun) get CheckMsg failed"
                WRITE_XML_ERROR 0 "Node:$Remote_ip||INFO:$(fun) get CheckMsg failed!"
            else
                CheckMsgParse "$Remote_ip" "$CheckMsgFile" "$PassStatus"
                rm -rf $CheckMsgFile
            fi
            if [ "$PassStatus" !=  "0" ]; then
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO: ${fun} check result:$PassStatus."
                isPass=$PassStatus
            fi
        fi
    }
    done
    WRITE_XML_JUDGE $isPass >/dev/null
}

analyse_result()
{
    #xmlдļG_CHECK_RESULT_FILE У̴ᵼд󣬹ʴС
    #ڿɸıдxmlʽŻΪС
    taskids=$1
    for taskid in $taskids
    do
    {
        InspectFun=`GetInspectType $taskid`

        G_CHECK_RESULT_FILE="/opt/inspect/check_result_file"$taskid
        > $G_CHECK_RESULT_FILE
        WRITE_XML_HEADER >/dev/null
        WRITE_XML_CMD_HEADER $taskid >/dev/null
        WRITE_XML_SUBCMD_HEADER "0" >/dev/null
        if [ "$InspectFun" != "" ];then
            CheckPassStatus $InspectFun
        else
            LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:The current system does not support the appointed inspect item(taskid:$taskid)!"
            WRITE_XML_COMMON 0 "INFO:The current system does not support the appointed inspect item(taskid:$taskid)!"
        fi
        WRITE_XML_SUBCMD_TAIL >/dev/null
        WRITE_XML_CMD_TAIL >/dev/null
        WRITE_XML_TAIL $taskid >/dev/null
    }&
    done
    wait
}

# **************************************************************************** #
# Function Name: checkSoftwareStatusEx
# Description: Software мչ.
# Parameter: $1 cmditemID
# Return:
# **************************************************************************** #
checkSoftwareStatusEx()
{
    #ȡеĺIPִ
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #ȡǰڵipַ
    local MainNodeIP=`get_backnet_ip`
    #Զ̽ڵȡϢѲ
    remote_taskids="157 275 293 294 295 296 297 298 299"
    #ֻڱؽڵͿԻȡѲ
    local_taskids="270 273 274"

    #齨checkitemsִвʽ壨InspectFun1-param1-param2-param3 inspectFun2-param1-param2-param3 ...)

    Params=""

    for REMOTE_IP in $REMOTE_IP_S
    do
    {
        if [ "$REMOTE_IP" = "$MainNodeIP" ]; then
            local_exec_cmd "$local_taskids $remote_taskids" "$Params" "$MainNodeIP"
        else
            alltask="${remote_taskids}"
            if [ "$MainNodeIP" = "" ]; then
                alltask="$local_taskids ${remote_taskids}"
            fi
            exec_cmd "${REMOTE_IP}" "${alltask}" "$Params"
            sleep 2
            download_result "${REMOTE_IP}"
            if [ $? -ne 0 ]; then    #ʧܣһ
                LOG "Download Result first time failed try again!"
                exec_cmd "${REMOTE_IP}" "${alltask}" "$Params"
                sleep 2
                download_result "${REMOTE_IP}"
                if [ $? -ne 0 ];then
                    LOG "Download Result second time failed return!"
                    echo "download result second time failed"
                fi
            fi
        fi
    }&
    done
    wait
    analyse_local_result "${local_taskids}" "$MainNodeIP"
    analyse_result "${remote_taskids}"
}
##end add

