#!/bin/sh
set +x

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh

TMP_OM_BASE_PATH="${CMLogDir}../tmp_OM"

OM_CONF_PATH="${CMLogDir}Config"
OM_EVENT_PATH="${CMLogDir}Event"
OM_OTHER_PATH="${CMLogDir}Other"
OM_MSG_PATH="${CMLogDir}Messages"
OM_FAULTDISK_PATH="${OM_MSG_PATH}/fault_disklog"

TMP_OM_MSG_PATH="${TMP_OM_BASE_PATH}/Messages"
TMP_OM_SCRIPTLOG_PATH="${TMP_OM_MSG_PATH}/scriptLog"
TMP_OM_MSGOM_PATH="${TMP_OM_MSG_PATH}/OM"
TMP_OM_VMMSUVP_PATH="${TMP_OM_MSGOM_PATH}/VmmsUVP"
TMP_OM_SNMP_PATH="${TMP_OM_MSGOM_PATH}/snmpagent"
TMP_OM_CLI_PATH="${TMP_OM_MSGOM_PATH}/CLI"
TMP_OM_DATASYNC_PATH="${TMP_OM_MSGOM_PATH}/datasync"

OM_SNMP_DES_PATH="$CMLogDir""Messages/OM/snmpagent"
OM_CLI_DES_PATH="$CMLogDir""Messages/OM/CLI"
OM_DATASYNC_DES_PATH="$CMLogDir""Messages/OM/datasync"

g_OM_collect_bysize=1
SUBNAME="OM"
function usage()
{
    echo "$ScriptOMFname <product_name> <version> <output_file> <begin_time> <end_time> [log_size]"
    echo "product_name          collect product name"
    echo "version               collect product version"
    echo "output_file           collect file to save the log, eg: *.tar.gz"
    echo "begin_time            collect start time, the default value is null"
    echo "end_time              collect end time, the default value is null"
    echo "log_size              collect size of file"
    return 0
}

#ռ
function collectOMInfo()
{
    local rc=0
    local tmp_conf_path="${OM_CONF_PATH}"    
    local tmp_event_path="${OM_EVENT_PATH}"
    local tmp_msg_path="${OM_MSG_PATH}"
    local tmp_other_path="${OM_OTHER_PATH}"
    local collectConfigFile="${CMLogDir}Config/OM_Config.txt"

    log [$SUBNAME]"start get config\(ini,db\) info"
    
    #1. collect infomation
    if [ ! -d ${tmp_conf_path} ];then
        mkdir -p ${tmp_conf_path} || log [$SUBNAME][$FUNCNAME][$LINENO]"Waring, make dir ${tmp_conf_path} fail."
    fi
    if [ ! -d ${tmp_event_path} ];then
        mkdir -p ${tmp_event_path} || log [$SUBNAME][$FUNCNAME][$LINENO]"Waring, make dir ${tmp_event_path} fail."
    fi
    
    isCMMainNode
    if [ $? -ne 0 ]; then
        $G_MML_PATH/CollectDataMml $LOCAL_IP 4016 "cm system show" > ${collectConfigFile} 2>&1
        log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP 4016 "cm system show" >  ${collectConfigFile}"
        
        ipmitool fru >> ${collectConfigFile} 2>&1        
    fi

    echo "Memory--------------------------------" >> ${collectConfigFile} 2>&1
    echo "    Memory Info--------------------------------" >> ${collectConfigFile} 2>&1
    #MemTotal
    result=`cat /proc/meminfo | grep "MemTotal"`
    echo "        ${result}" >> ${collectConfigFile} 2>&1
    #MemFree
    result=`cat /proc/meminfo | grep "MemFree"`
    echo "        ${result}" >> ${collectConfigFile} 2>&1
    echo "Version--------------------------------" >> ${collectConfigFile} 2>&1
    echo "    Version Info--------------------------------" >> ${collectConfigFile} 2>&1
    result=$( ls /var/huawei/patch/cur/sph 2>/dev/null|grep -e "OceanStor*" -e "FusionStorage*" | awk -F'_' '{print $NF}' )
    echo "        Sph Version:${result}" >> ${collectConfigFile} 2>&1

    cp -f "$CONFIG_DEPLOY"nofs.ini  "${tmp_conf_path}/"
    cp -f "$CONFIG_DEPLOY"snas.ini  "${tmp_conf_path}/"
    cp -f "$CONFIG_DEPLOY"cm.ini  "${tmp_conf_path}/"
    cp -f "$CONFIG_DEPLOY"cm_aum_securitypolicy.ini  "${tmp_conf_path}/"
    cp -f "$CONFIG_DEPLOY"cm_aum_man_user.ini "${tmp_conf_path}/"

    cp -f "$CONFIG_DEPLOY"clusterver.ini "${tmp_conf_path}/"
    cp -f "$CONFIG_DEPLOY"updpkg.ini "${tmp_conf_path}/"
    cp -f "$CONFIG_DEPLOY"updresult.ini "${tmp_conf_path}/"   
    
    #ȡǰϵͳʱʱϢ
    local curTime=$(date "+%Y-%m-%d %H:%M:%S")
    local curTimeZone=$(date -R |awk -F " " '{print $6}')
    
    echo "Node name:          $(hostname)"    >"${tmp_conf_path}/"curTime.txt
    echo "Current system time:${curTime}"     >>"${tmp_conf_path}/"curTime.txt
    echo "Current time zone:  ${curTimeZone}" >>"${tmp_conf_path}/"curTime.txt

    #ռǽϢ
    iptables-save >"${tmp_other_path}/iptables_info.txt"

    #ռ·Ϣ
    echo "CMD: route -n" >"${tmp_other_path}/route_info.txt"
    route -n >>"${tmp_other_path}/route_info.txt"
    echo "" >>"${tmp_other_path}/route_info.txt"
    echo "============================================================================" >>"${tmp_other_path}/route_info.txt"
    echo "CMD: rule list" >>"${tmp_other_path}/route_info.txt"
    cat /etc/iproute2/rt_tables >>"${tmp_other_path}/route_info.txt"
    echo "" >>"${tmp_other_path}/route_info.txt"
    echo "============================================================================" >>"${tmp_other_path}/route_info.txt"
    cat /etc/iproute2/rt_tables | while read line
    do
        echo ${line} | grep "^#" >/dev/null 2>&1
        if [ $? -eq 0 ];then
            continue
        fi
        tableName=$(echo ${line} | awk '{print $2}')
        echo "CMD: ip route show table ${tableName}"  >>"${tmp_other_path}/route_info.txt"
        ip route show table ${tableName} >>"${tmp_other_path}/route_info.txt"
        echo "" >>"${tmp_other_path}/route_info.txt"
        echo "============================================================================" >>"${tmp_other_path}/route_info.txt"
    done
    
    
    #ռ/var/log/alarm/event.txt
    $G_MML_PATH/CollectAlmInfo > "${tmp_event_path}/event.txt"
    log [$SUBNAME]"$G_MML_PATH/CollectAlmInfo ret($?)"
    # ռ /opt/huawei/snas/etc/cm_alarm_record.db
    tar -cvzf ${tmp_event_path}/cm_alarm_record.tar.gz -C ${CONFIG_DEPLOY} cm_alarm_record.db
    log [$SUBNAME]"tar -cvzf ${tmp_event_path}/cm_alarm_record.tar.gz -C ${CONFIG_DEPLOY} cm_alarm_record.db ret($?)"

    local CmdPort=4016
    #ӡcm system
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm system" >> "${tmp_msg_path}"/mml_cm_system 2>&1
    sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' "${tmp_msg_path}"/mml_cm_system >/dev/null 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm system" >> "${tmp_msg_path}"/mml_cm_system"

    #ӡcm power
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm power" >> "${tmp_msg_path}"/mml_cm_power 2>&1
    sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' "${tmp_msg_path}"/mml_cm_power >/dev/null 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm power" >> "${tmp_msg_path}"/mml_cm_power"

    #ӡcm node
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm node" >> "${tmp_msg_path}"/mml_cm_node 2>&1
    sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' "${tmp_msg_path}"/mml_cm_node >/dev/null 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm node" >> "${tmp_msg_path}"/mml_cm_node"

    #ӡcm fsservice
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm fsservice" >> "${tmp_msg_path}"/mml_cm_fsservice 2>&1
    sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' "${tmp_msg_path}"/mml_cm_fsservice >/dev/null 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm fsservice" >> "${tmp_msg_path}"/mml_cm_fsservice"

    #ӡcm diskinfo
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm diskinfo" >> "${tmp_msg_path}"/mml_cm_diskinfo 2>&1
    sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' "${tmp_msg_path}"/mml_cm_diskinfo >/dev/null 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm diskinfo" >> "${tmp_msg_path}"/mml_cm_diskinfo"

    #ӡcm licensecfg
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm licensecfg" >> "${tmp_msg_path}"/mml_cm_licensecfg 2>&1
    sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' "${tmp_msg_path}"/mml_cm_licensecfg >/dev/null 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm licensecfg" >> "${tmp_msg_path}"/mml_cm_licensecfg"

    #Ѽ/var/log/stack.log
    if [ -f /var/log/stack.log ];then
        cp -f /var/log/stack.log   "${tmp_msg_path}"  >/dev/null 2>&1  
    fi

    #Ѽ/var/log/statisµļ
    if [ -d /var/log/statis/ ]; then
        local currenttime=$(date +%Y-%m-%d-%T)
        cp -f /var/log/statis/statis_acc_statis  "${tmp_msg_path}"/statis_acc_statis_"${currenttime}" >/dev/null 2>&1  
        cp -f /var/log/statis/statis_obs "${tmp_msg_path}"/statis_obs_"${currenttime}" >/dev/null 2>&1  
        cp -f /var/log/statis/statis_rpc_statis "${tmp_msg_path}"/statis_rpc_statis_"${currenttime}" >/dev/null 2>&1     
    fi

    log "[$SUBNAME]end get config(ini,db) info"
}

#ռbase-cmϢ 
function collectBaseCmInfo()
{
    local tmp_other_path="${OM_OTHER_PATH}"
    
    #1. get info input to tmp path
    if [ ! -d ${tmp_other_path} ];then
        mkdir -p ${tmp_other_path} || log [$SUBNAME][$FUNCNAME][$LINENO]"Waring, make dir ${tmp_other_path} fail."
    fi
    ipmitool sensor > ${tmp_other_path}/ipmitool_sensor_info 2>&1
    log [$SUBNAME]"ipmitool sensor > ${tmp_other_path}/ipmitool_sensor_info"

    free -m > ${tmp_other_path}/free_m_info 2>&1
    log [$SUBNAME]"free -m > ${tmp_other_path}/free_m_info"

    cp -f /proc/slabinfo  ${tmp_other_path}/slabinfo_info 2>&1
    log [$SUBNAME]"free -m > ${tmp_other_path}/slabinfo_info"

    free -m > ${tmp_other_path}/free_m_info 2>&1
    log [$SUBNAME]"free -m > ${tmp_other_path}/free_m_info"

    #Ϣ    
    ifconfig > ${tmp_other_path}/ifconfig_info 2>&1
    log [$SUBNAME]"ifconfig > ${tmp_other_path}/ifconfig_info,ret($?)"

    arp -n > ${tmp_other_path}/arp_n_info 2>&1
    log [$SUBNAME]"arp -n > ${tmp_other_path}/arp_n_info,ret($?)"

    netstat -anpt > ${tmp_other_path}/netstat_anpt_info 2>&1
    log [$SUBNAME]"netstat -anpt > ${tmp_other_path}/netstat_anpt_info,ret($?)"

    #/proc/sys/lnet/peers
    cat /proc/sys/lnet/peers > ${tmp_other_path}/lnet_peers_info 2>&1
    log [$SUBNAME]"cat /proc/sys/lnet/peers > ${tmp_other_path}/lnet_peers_info,ret($?)"

    #/proc/sys/lnet/stats
    cat /proc/sys/lnet/stats > ${tmp_other_path}/lnet_stats_info 2>&1
    log [$SUBNAME]"cat /proc/sys/lnet/stats > ${tmp_other_path}/lnet_stats_info,ret($?)"

    #cpu
    ps H -eo user,pid,ppid,tid,time,%cpu,%mem,cmd --sort=%cpu > ${tmp_other_path}/cpu_info 2>&1
    log [$SUBNAME]"ps H -eo user,pid,ppid,tid,time,%cpu,%mem,cmd --sort=%cpu > ${tmp_other_path}/cpu_info,ret($?)" 


    ##################ȡRPC ERRORϢ#########################
    #ksock lnd err statistic:
    echo 1 > /sys/module/libcfs/parameters/g_iLndErrStatOn 2>&1
    sleep 1
    cat /proc/sys/lnet/stats > ${tmp_other_path}/ksock_lnd_err_statistic 2>&1
    echo 0 > /sys/module/libcfs/parameters/g_iLndErrStatOn 2>&1
    
    cp -f /proc/monc_balancemap   ${tmp_other_path}  2>&1
    
    log [$SUBNAME]"cat /proc/sys/lnet/stats > ${tmp_other_path}/ksock_lnd_err_statistic ,ret($?)"
    return 0
}

#Ѽű־
function collectScriptLog()
{
    local tmp_script_path="${MessageDir}scriptLog"
    
    #1. collect infomation
    if [ ! -d ${tmp_script_path} ];then
        mkdir -p ${tmp_script_path} || log [$SUBNAME][$FUNCNAME][$LINENO]"Waring, make dir ${tmp_script_path} fail."
    fi
    cp -f /var/log/inspect.log     ${tmp_script_path}  >/dev/null 2>&1
    cp -f /var/log/logrotate/logbackup.log   ${tmp_script_path}  >/dev/null 2>&1
    cp -f /var/log/logrotate/logclean.log    ${tmp_script_path}  >/dev/null 2>&1
    cp -f /var/log/logrotate/logcontrol.log  ${tmp_script_path}  >/dev/null 2>&1
    cp -f /var/log/scriptlog/clientauditLog.log   ${tmp_script_path}  >/dev/null 2>&1
    cp -f /var/log/scriptlog/clientmessageLog.log  ${tmp_script_path}  >/dev/null 2>&1
    cp -f /var/log/scriptlog/clientsnasLog.log     ${tmp_script_path}  >/dev/null 2>&1
    cp -f /var/log/scriptlog/dealLog.log           ${tmp_script_path}  >/dev/null 2>&1
    cp -f /var/log/upd_cfg.log                     ${tmp_script_path}  >/dev/null 2>&1
    cp -f /var/log/check_port.log*  ${tmp_script_path}  >/dev/null 2>&1
    log "[$SUBNAME]end get config(scriptLog) info"
    return 0
}

#ռBDMϢ
function collectBDMInfo()
{
    local tmp_disklog_path="${OM_FAULTDISK_PATH}"
    
    #1, collect information.
    if [ ! -d ${tmp_disklog_path} ];then
        mkdir -p ${tmp_disklog_path} || log [$SUBNAME][$FUNCNAME][$LINENO]"Waring, make dir ${tmp_disklog_path} fail."
    fi
    if [ -d ${BDM_LOG_DIR} ];then
        mkdir -p ${BDM_COLLECT_DIR}
        if [ -d ${BDM_LOG_DIR}/hdd ];then
            cp -fpr ${BDM_LOG_DIR}/hdd ${BDM_COLLECT_DIR}
        fi
        if [ -d ${BDM_LOG_DIR}/hssd ];then
            cp -fpr ${BDM_LOG_DIR}/hssd ${BDM_COLLECT_DIR}
        fi
    fi
    cp -f "$CONFIG_DEPLOY"bdm.ini "$CMLogDir""Config/"

    
    
    
    adjustSize
    log [$SUBNAME]"end collect bdm log"    
    return 0
}

#ռPCICardϢ
function collectPCICardInfo()
{
    local netWorkFile="/tmp/net_work_fiel.$$"
    local PCICardNum=""
    local collectConfigFile="${CMLogDir}Config/OM_Config.txt"
    local NodeID=$(cat /opt/huawei/snas/etc/cm.ini | grep "^NID=" | awk -F'=' '{print $2}')
    local NetIDList=$(lspci |egrep "Ethernet|Mellanox" |awk '{print $1}')
    local NetIDArray=(${NetIDList})
    local PortName=""
    local PortNum=""
    local PortInfo=""
    local TypeNum=""
    local PCINum=""
    local PortType=""

    /usr/sbin/hwinfo --network >${netWorkFile}
    PCICardNum=$(grep "Device File" ${netWorkFile} | grep -v "Device File: lo" | wc -l)

    echo "PCICard--------------------------------" >> ${collectConfigFile} 2>&1
    echo "    Number of PCICard:${PCICardNum}" >> ${collectConfigFile} 2>&1
    echo "    PCICard Info--------------------------------" >> ${collectConfigFile} 2>&1
    for NetID in ${NetIDArray[*]}
    do
        PortName=$(grep -B2 -A10 "${NetID}" ${netWorkFile} | grep "Device File:" | awk -F':' '{print $2}' | tr -d ' ' | tr "\n" " ")
        if [ -z "${PortName}" ];then
            continue
        fi
        for OnePortName in ${PortName[*]}
        do
            PortType=""
            PortInfo=$(lspci | grep "${NetID}" | awk -F":" '{print $3}')
            PortNum=$(cat /opt/huawei/snas/etc/snas.ini | grep ${OnePortName} | awk -F= '{print $1}'|awk -F_ '{print $3}')
            TypeNum=$(cat /opt/huawei/snas/etc/snas.ini | grep subnetwork_id_${PortNum} | awk -F= '{print $2}')
            if [ ! -z "${PortNum}" ] && [ ! -z "${TypeNum}" ];then
                if [ "1" == "${TypeNum}" ];then
                    PortType="BackPort"
                fi
                if [ "2" == "${TypeNum}" ];then
                    PortType="FrontPort"
                fi
            fi
            echo "" >> ${collectConfigFile} 2>&1
            echo "        NodeId  :${NodeID}" >> ${collectConfigFile} 2>&1
            echo "        PortName:${OnePortName}" >> ${collectConfigFile} 2>&1
            echo "        PortInfo:${PortInfo}" >> ${collectConfigFile} 2>&1
            echo "        PortType:${PortType}" >> ${collectConfigFile} 2>&1
            echo "        PCINum  :${NetID}" >> ${collectConfigFile} 2>&1
        done
    done
    rm -rf ${netWorkFile}
    log "[$SUBNAME]end get config(PCICard) info"
}

function redirectContent()
{
    local realConfig="${CMLogDir}Config/Config.txt"
    local collectConfigFile="${CMLogDir}Config/OM_Config.txt"
    echo "" >> ${realConfig}
    log "[$FUNCNAME][$LINENO]start get lock"
    flock -e ${realConfig} -c "cat ${collectConfigFile} >> ${realConfig}"
    log "[$FUNCNAME][$LINENO]end get lock"
    rm -f ${collectConfigFile}
}

#parameter: out_file [in_rec_file]
#search COLLECT_RECORD_FORMAT in this file, to see detail.
#עҪּ¼ʽ¶Ҫ֤
#paras: out_file=/var/log/cm/LocalDataCollect/../tmp/tmp.OM.dfs.and.local.info
function OMGetLoglist()
{
    local out_file=${1}
    local in_rec_file=""
    local des_om_path="${MessageDir}OM"    
    local loc_om_logs="${Collect_OM_Log} ${Collect_OM_Other_Log}"
    local loc_file=""
    local cliDir="${MessageDir}OM/CLI"
    local out_basedir=$(dirname ${out_file})
    local snmpagentLog="$Collect_OM_Snmpagent"

    if [ $# -gt 1 ];then
        #get my log files from input record file. rec_fileеĸʽls -lĽ
        in_rec_file=${2}
        if [ ! -f ${in_rec_file} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"ERROR, ${in_rec_file} is not exist!"
            return 1
        fi        
        grep "snas.log" ${in_rec_file} | awk -v dpath=${des_om_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get snas.log from ${rec_file} and redirect to ${out_file} fail"
        grep "snas_CM.log" ${in_rec_file} |  grep -v ".tar.gz" | grep -vw "/var/log/snas_CM.log" | awk -v dpath=${des_om_path} '{print $NF" file "$1" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get snas_CM.log uncompressed fail and redirect to ${out_file} fail"
        grep "snas_CM.log" ${in_rec_file} |  grep ".tar.gz" | awk -v dpath=${des_om_path} '{print $NF" file "$1" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get snas_CM.log compressed fail and redirect to ${out_file} fail"
        grep "start" ${in_rec_file} | grep -vw "/var/log/start.log" | awk -v dpath=${des_om_path} '{print $NF" file "$1" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get start uncompressed fail and redirect to ${out_file} fail"
        # snmpagent
        grep "snmpagent.log" ${in_rec_file} |  grep ".tar.gz" | awk -v dpath=${des_om_path} '{print $NF" file "$1" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get snmpagent.log compressed fail and redirect to ${out_file} fail"
        return 0
    else
        #get my log files from local fs.
        #1.ռUVP,ǰѾռ
        echo "/var/log dir -1 ${des_om_path}/VmmsUVP 1 1" >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, echo ${TMP_OM_VMMSUVP_PATH} dir -1 ${MessageDir}OM/VmmsUVP 1 0 >> ${out_file}fail"
        #2.ռOM log
        for loc_file in ${loc_om_logs}
        do
            ls -l /var/log/${loc_file}* 2> /dev/null | awk -v dpath=${des_om_path} '{print $NF" file -1 "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect /var/log/${loc_file}* to ${out_file} fail."            
        done
        #4. ѼCLI־
        #ʱռCLI־,˴˴Ŀ¼,ȷ/var/log/CLI
        echo "/var/log/CLI/xxx dir -1 ${cliDir} 1 0"  >> ${out_file} || log [$FUNCNAME][$LINENO]"Warning, record: /var/log/CLI/* dir -1 ${cliDir} 1 0 >> ${out_file} fail"
        #4. һϢѼڵѼ. had copy in collectOMInfo
        #5.ռʱĿ¼е־.collectOMInfo,collectKbox,collectBaseCmInfo,collectBDMInfo
        
        #6.ռOMϵͳµ־
        ls -l /var/log/snas/snas.log* 2> /dev/null | egrep ".tar.gz$" | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snas.log* > ${out_file} fail."
        ls -l /var/log/backup/OM/snas.log* 2> /dev/null | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snas.log* > ${out_file} fail."
        ls -l /var/log/snmpagent/snmpagent.log* 2> /dev/null | egrep ".tar.gz$" | awk -v dpath=${des_om_path}/snmpagent '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snmpagent.log* > ${out_file} fail."
        ls -l /var/log/backup/OM/snmpagent.log* 2> /dev/null | awk -v dpath=${des_om_path}/snmpagent '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snmpagent.log* > ${out_file} fail."
        #need to be compressed. snas_CM.log or /var/log/snas_CM.log_2018-10-23-15:00:00.429925
        ls -l /var/log/snas_CM.log* 2> /dev/null | grep -v ".tar.gz" | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snas_CM* >> ${out_file} fail."
        ls -l /var/log/snas/snas_CM.log* 2> /dev/null | grep -v ".tar.gz" | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snas_CM* >> ${out_file} fail."
        ls -l /var/log/snas_CM.log*.tar.gz 2> /dev/null | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snas_CM* >> ${out_file} fail."
        ls -l /var/log/backup/OM/snas_CM.log*.tar.gz 2> /dev/null | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snas_CM* >> ${out_file} fail."
        #start.log had already collected.
        ls -l /var/log/*start* 2> /dev/null | grep -vw "/var/log/start.log" | grep -v "cli_start_omuser.log" | grep -v "cli_start_root.log" | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/*start* >> ${out_file} fail."
        
        # uncompressed snmpagent logs
        for file in ${snmpagentLog}
        do
            ls -l /var/log/snmpagent/${file}* 2> /dev/null | grep -Ev ".tar.gz$" | awk -v dpath=${des_om_path}/snmpagent '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/snmpagent/${file} >> ${out_file} fail"
        done

        return 0
    fi
}
#Ҫռ־ȷЩ־ļռ
function get_cfglog_seconds()
{
    local rc=0
    local cur_sec=0
    
    if [ 1 -eq ${g_OM_collect_bysize} ];then
        cur_sec=$(date +%s)
        rc=$?
        ret_seconds ${cur_sec}
        return ${rc}
    else
        endtime_s=$( getSeconds "${end_time}" )
        let "cur_sec=endtime_s - 1"
        ret_seconds ${cur_sec}
        return $?
    fi
}
#
#ļϵͳеȫ·
#snas_CM.log_2018-10-15-23.00.00.234996.tar.gz
#/var/log/snas_CM.log
#/var/log/snas_CM.log_2018-10-23-15:00:00.429925
#/var/log/backup/OM/snas.log.2018-10-22_11.tar.gz
#/var/log/startnas.log
#parameters: fname
function getUtcSecondsFromOMFileName()
{
    local fname=$1
    local sname=$(basename ${fname})
    local tmp=""
    local cuttail=""
    local sec=0
    local cur_sec=$(get_cfglog_seconds)
    local rc=0
    
    echo ${sname} | grep snas.log > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #sname: snas.log.2018-10-22_11.tar.gz
        tmp=${sname##*snas.log.}
        cuttail=${tmp%.tar.gz*}
        #cuttail: 2018-10-22_11
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    echo ${sname} | grep snas_CM.log > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas_CM.log_2018-10-15-23.00.00.234996.tar.gz or snas_CM.log or snas_CM.log_2018-10-23-15:00:00.429925
        tmp=${sname##*snas_CM.log}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            #/var/log/snas_CM.log
            sec=${cur_sec}
        elif [ "${tmp}" == "${cuttail}" ];then
            #snas_CM.log_2018-10-23-15:00:00.429925 
            #tmp: _2018-10-23-15:00:00.429925
            sec=$(GetSecondForC01 ${tmp#*_})
        else
            #snas_CM.log_2018-10-15-23.00.00.234996.tar.gz
            #cuttail: _2018-10-15-23.00.00.234996
            sec=$(GetSecondForC01 ${cuttail#*_})
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
        
    echo ${sname} | grep "snmpagent.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snmpagent.log.2019-01-10_23.tar.gz  
        tmp=${sname##*snmpagent.log}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            sec=${cur_sec}
        else
            #cuttail:.2019-01-10_23
            sec=$(getSeconds "$(echo ${cuttail##*.} | sed 's/_/ /g')" )
        fi
        # snmpagent log backup one day once
        if [ $sec -gt $cur_sec ]; then
            log [$SUBNAME][$FUNCNAME][$LINENO]"${fname} time: sec=${sec},cur_sec=${cur_sec}" 
            local diff_sec=0
            let "diff_sec=sec - cur_sec"
            # 86400 is 24*3600s
            if [ $diff_sec -lt "86400" ]; then
                sec=$cur_sec
            fi
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    echo ${sname} | grep "snmpagent.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snmpagent.log.2019-01-08_04_1.tar.gz 
        tmp=${sname##*snmpagent.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        if [ $sec -gt $cur_sec ]; then
            log [$SUBNAME][$FUNCNAME][$LINENO]"${fname} time: sec=${sec},cur_sec=${cur_sec}" 
            local diff_sec=0
            let "diff_sec=sec - cur_sec"
            # 86400 is 24*3600s
            if [ $diff_sec -lt "86400" ]; then
                sec=$cur_sec
            fi
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    #/var/log/startnas.log
    ret_seconds ${cur_sec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
    fi
    return ${rc}
}
function OM_collect()
{
    log "[$SUBNAME]collect OM , size:${log_size} ,begin_time:${begin_time} ,end_time:${end_time}"
    local collect_sub=$1
    local begin_time=$2
    local end_time=$3
    local size=$4
    local need_size="${size}"
    local rc=0
    local sub_path="${MessageDir}OM"
    local otherDir="${MessageDir}../Other"
    local snmpagentDir="${MessageDir}OM/snmpagent"
    local cliDir="${MessageDir}OM/CLI"
    local vmmsUvpDir="${MessageDir}OM/VmmsUVP"
    local datasyncDir="${MessageDir}OM/datasync"
    available_size=$(getAvailableSize)
    log "available size is:${available_size}"
    
    if [ $(echo "${MIN_VALUE} > ${available_size}" | bc) -eq 1  ];then
        echo "collect size will over 90%, exit collect"
        log [$SUBNAME]"collect size will over 90%, exit collect."
        clean
        exit 1
    fi
    
    #1. UVP: compressed the log to uvp_tar
    clloectVmmsUVPLog 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Waring, clloectVmmsUVPLog fail with ${rc} "
    fi
    
    collect_compressed_logs "${collect_sub}" ${size} "${begin_time}" "${end_time}" OMGetLoglist getUtcSecondsFromOMFileName dfs_s3_cp
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect_compressed_logs ${collect_sub} ${collect_size} ${begin_time} ${end_time} OMGetLoglist getUtcSecondsFromOMFileName dfs_s3_cp fail with ${rc}"
    fi
    
    #delete tempory path.
    if [ -d ${TMP_OM_BASE_PATH} ] ;then
        rm -rf ${TMP_OM_BASE_PATH} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm ${TMP_OM_BASE_PATH} fail"
    fi
    #ʹÿռ
    adjustSize
    real_size=$(du "${sub_path}" | tail -n1 | cut -f1)
    
    #OMģ
    IsDelSensitiveInfo
    if [ $? -eq 1 ];then
        DelSensitiveInfoForEmailAndPhone "${sub_path}" "${FilePreLists}" "${zipfiletype}" "OM"
    fi
    
    #
    cd ${sub_path}
    
    tar cvf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, tar cvf ${output_file} -C ${sub_path}/../ OM >/dev/null 2>&1  fail with ${rc}"
    fi
    if [ -d ${sub_path} ] ; then
        if [ -L ${sub_path} ]; then
            rm -f ${sub_path}
        fi
        rm -rf ${sub_path}/* || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm -rf ${sub_path}/* fail"
    fi 
    log [$SUBNAME]"end collect ${collect_sub},real size is ${real_size},"
    return 0
}

ElcLable=$(dmidecode -t 1 | grep "Product Name:" | awk -F: '{print $2}' | sed 's/^\s*//;s/\s*$//')
ARC_TYPE_X86=1
ARC_TYPE_ARM=2
INTEL_X86=0
HI1616=1
HISI1620=2
KUNPENG920=3
CPUMODEL_BUT=4
#жǷͨ÷RH2288 5288
function IsRHV3Node()
{
    if [ "$ElcLable"X = "RH2288 V3"X -o "$ElcLable"X = "5288 V3"X -o "$ElcLable"X = "RH2288H V3"X ]; then
        return 0
    else
        return 1
    fi
}

function IsRHV5Node()
{
    if [ "$ElcLable"X = "2288H V5"X -o "$ElcLable"X = "2288 V5"X -o "$ElcLable"X = "5288 V5"X -o "$ElcLable"X = "R521G10"X -o "$ElcLable"X = "RS221G1"X -o "$ElcLable"X = "2288X V5"X -o "$ElcLable"X = "5288X V5"X -o "$ElcLable"X = "DP4200"X -o "$ElcLable"X = "DP2200"X ] || [[ "$ElcLable"X =~ "NW8220X" ]]; then
        return 0
    else
        return 1
    fi
}

function IsRHNode()
{
    IsRHV3Node
    local isV3=$?
    IsRHV5Node
    local isV5=$?
    if [ $isV3 -eq 0 -o $isV5 -eq 0 ];then
        return 0
    else
        return 1
    fi
}

function IsTSNode()
{
    if [[ "${ElcLable}" =~ "TaiShan 5280" ]] ||
       [[ "${ElcLable}" =~ "TaiShan 2280" ]] ||
       [[ "${ElcLable}" =~ "TaiShan 5290" ]] ||
       [[ "${ElcLable}" =~ "TaiShan 200 (Model 5280)" ]] ||
       [[ "${ElcLable}" =~ "TaiShan 200 (Model 2280)" ]] ||
       [[ "${ElcLable}" =~ "TaiShan 200 (Model 5290)" ]]; then
        return 0
    else
        return 1
    fi
}

function is3416SasCard()
{
    lspci |grep SAS3416 >/dev/null 2>&1
    return $?
}

function GetArcType()
{
    local CPU_TYPE
    CPU_TYPE=`arch`
    if [ "$CPU_TYPE"X = "x86_64"X ];then
        return $ARC_TYPE_X86
    else
        return $ARC_TYPE_ARM
    fi
}

function GetCpuModel()
{
    GetArcType
    local ret=$?
    if [ $ARC_TYPE_X86 -eq $ret ];then
        return $INTEL_X86
    else
        local cpu_model=`dmidecode -t processor|egrep -A52 'CPU 1|CPU01'|grep 'Version:'|uniq|awk -F ":" '{print $2}'|sed -e 's/^[ \t]*//g'`
        if [[ "$cpu_model" =~ "Hi1616" ]];then
            return $HI1616
        elif [[ "$cpu_model" =~ "Hisilicon 1620" ]];then
            return $HISI1620
        elif [[ "$cpu_model" =~ "Kunpeng 920" ]];then
            return $KUNPENG920
        else
            return $CPUMODEL_BUT
        fi
    fi
}

function collectSysDiskSmartInfo()
{
    local isTS=0
    local isRH=0
    local systemDiskSmartDir="${MessageDir}OM/sysDiskSmartInfo"

    IsRHNode
    isRH=$?
    IsTSNode
    isTS=$?
    if [ ${isRH} -ne 0 -a ${isTS} -ne 0 ]; then
        log "[$FUNCNAME][$LINENO]not rh or ts node.no need to collect system disk smartctl info."
        return
    fi

    local is3416Card=""
    local CpuMode=""
    local sysdisklist=""

    is3416SasCard
    is3416Card=$?

    GetCpuModel
    CpuMode=$?
    if [ ${CpuMode} -eq $HISI1620 -o ${CpuMode} -eq $KUNPENG920 -o ${is3416Card} -eq 0 ];then
        sysdisklist=$(lsscsi -g |grep -we $(mdadm -D /dev/md1 |grep "/dev/sd*" |sed -n '1p' |awk '{print $NF}') -we $(mdadm -D /dev/md1 |grep "/dev/sd*" |sed -n '2p' |awk '{print $NF}') | awk '{print $1}' |sed 's/[][]//g')
    else
        #smr "[10:0:3:0]   (0x14)  ATA      HGST HSH721414AL TT03  /dev/sde   /dev/sg4"
        #HGST HSH721414AL мڿո,$6ȡ̷
        sysdisklist=$(lsscsi -g | awk '{if ($1!="[0:0:0:0]" && ($2=="disk" || $2=="(0x14)" || $2=="zbc") && $(NF-1)=="-") print $1}' |tr -d '[] ' |sed 's/^ *//g'|sed "/^$/d")
    fi

     mkdir -p ${systemDiskSmartDir}

    for businfo in ${sysdisklist}
    do
        innername=$(lsscsi -g | grep -w "$businfo"|awk '{print $NF}')
        smartInfoF=$( echo "${innername}" | awk -F/ '{print $2"_"$3}' )
        smartctl -a ${innername} >${systemDiskSmartDir}/${smartInfoF}_smartctl_info
    done

}

function main()
{
    if [ "X${type}" == "Xconfig" ];then
        log "[$FUNCNAME][$LINENO]start collect OM config"
        collectOMInfo
        collectBaseCmInfo
        collectBDMInfo
        collectPCICardInfo
        redirectContent
        log "[$FUNCNAME][$LINENO]end collect OM config"
    elif [ "X${type}" == "Xlog" ];then
        local sub_path="${MessageDir}OM"
        local otherDir="${MessageDir}/../Other"
        local snmpagentDir="${MessageDir}OM/snmpagent"
        local cliDir="${MessageDir}OM/CLI"
        local vmmsUvpDir="${MessageDir}OM/VmmsUVP"
        local datasyncDir="${MessageDir}OM/datasync"
            
        rm -rf "${sub_path}"
        mkdir -p "${sub_path}" 
        mkdir -p ${otherDir}
        mkdir -p ${snmpagentDir}
        mkdir -p ${cliDir}
        mkdir -p ${vmmsUvpDir}
        mkdir -p ${datasyncDir}

        # ռϵͳ̵SmartkitϢ
        collectSysDiskSmartInfo
    
        collectScriptLog   
        
        if [ "X$begin_time" != "Xnull" -o "X$end_time" != "Xnull" ];then
            g_OM_collect_bysize=0
            log_size="0" 
        fi
        OM_collect "OM" "${begin_time}" "${end_time}" "${log_size}"
        return $?
        
        
        
    else
        usage
        return 1
    fi
    return 0
}

type=$1
product_name=$2
version=$3
output_file=$4
begin_time=$5
end_time=$6
log_size=$7

#жϲƷ
judge_product_type
#product_type
prepare

main
exit $?