#!/bin/bash

# *************************************************************************** #
# File Name: inspect_hardware.sh
# Description: ѲĿеӲ.
# Input:
# Output:
# Author:
# Created:
# Function List
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #

dos2unix $G_SCRIPT_PATH/inspect_lib.sh > /dev/null 2>&1
dos2unix $G_SCRIPT_PATH/inspect_map.sh > /dev/null 2>&1

. $G_SCRIPT_PATH/inspect_lib.sh
. $G_SCRIPT_PATH/inspect_map.sh

G_TMP_FILE="$G_SCRIPT_PATH/tmpfile$$"
G_REMOTE_TMP_FILE="/tmp/tmpfile$$"

VALID_IP_FILE="/tmp/tmp_valid_ip$$"

NID_ROLE_FILE="/tmp/tmp_nid_role"

IP_ROLE_FILE="/tmp/tmp_ip_role"

G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"

LOG_FILE="/var/log/inspect.log"

LOG_FILE_BAK="/var/log/inspect_1.log"

SWITCH_TOPO_FILE="/opt/huawei/snas/etc/switchTopo.ini"

RepeatTimes=(1 2 3)

FIFO_OPERATE_ID=758
FIFO_THREAD_NUM_MAX=60

G_SEPARATOR="-----------------------------------------------------------------------------"

function LOG_Check
{
    #create or change log file
    touch $LOG_FILE
    if [ $? -ne 0 ]; then
        echo "Create log file $LOG_FILE failed." 1>&2
        return
    fi

    # delete log file bigger than 10M
    FILE_SIZE=`ls -l $LOG_FILE | cut -d' ' -f 5`
    if [ ! -z "$FILE_SIZE" ]; then
        # delete file when file bigger than 10M
        if [ $FILE_SIZE -gt 10485760 ]; then
            mv $LOG_FILE $LOG_FILE_BAK 2>&1
        fi
    fi

}

function LOG
{
    echo [`date`][$$]$@ >> $LOG_FILE
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

function check_pass()
{
    local list=(["2"]=0 ["1"]=1 ["4"]=2 ["0"]=3 ["3"]=4) #δ(2)>ͨ(1)>Ż(4)>ͨ(0)>漰(3)
    local isPass=$1   #Ⱥ
    local tmpIsPass=$2 #ǰ

    if [ ${list[$tmpIsPass]} -lt ${list[$isPass]} ];then
        isPass=$tmpIsPass
    fi
    echo $isPass
}

#ʹfifoܵ, ʵֶ̲, Ҫ׼ VALID_IP_FILE
function fifo_start
{
    trap "exec $FIFO_OPERATE_ID>&-;exec $FIFO_OPERATE_ID<&-;exit 0" 2

    mkfifo remoteFifo
    eval "exec $FIFO_OPERATE_ID<>remoteFifo"
    rm -rf remoteFifo

    local num=0
    for Item in $VALID_IP_FILE; do
        num=$((num+1))
    done

    local threadNum=$FIFO_THREAD_NUM_MAX
    if [ $threadNum -gt $num ]; then
        threadNum=$num
    fi

    for ((i=0;i<$threadNum;i++))
    do
        eval "echo >& $FIFO_OPERATE_ID"
    done
}

function fifo_finish
{
    eval "exec $FIFO_OPERATE_ID>&-"
    eval "exec $FIFO_OPERATE_ID<&-"
}

###жǷC72 1-->C72   0-->T3000
function IsT3000Node()
{
    local name=""
    name=$(dmidecode -t 1 | grep "Product Name:" | awk '{print $3}')
    if [ "$name" = "T3200" -o "$name" = "T3500" -o "$name" = "T3000" ]; then
        return 0
    else
        return 1
    fi
}

function IsC72Node()
{
    dmidecode -t 4 | grep -q "Family: Atom"
    return $?
}

#ȡڵһIP
function get_backnet_ip
{
    local subnet_id=`grep 'subnetwork_id_.=1' /opt/huawei/snas/etc/snas.ini |awk -F= '{print $1}'|awk -F_ '{print $3}'|sort -k1|head -n1`
    if [ "$subnet_id" = "" ]; then
        LOG "[$FUNCNAME]Failed to get back subnet"
        return 1
    fi

    local IPAddress=`grep ipaddr_${subnet_id} /opt/huawei/snas/etc/snas.ini | awk -F= '{print $2}'`
    if [ "$IPAddress" = "" ]; then
        LOG "[$FUNCNAME]Failed to get back subnet IP"
        return 1
    fi

    echo $IPAddress
    return 0
}

#ȡָڵһIP
function get_node_backnet_ip
{
    local nid=$1
    local temp=1
    local iRet=0
    sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID limit 1"
    iRet=$?
    while [[ ${iRet} -ne 0 ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get back subnet IP of $nid from db"
        temp=$((temp + 1))
        if [ $temp -gt 5 ];then
            break
        fi
        sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID limit 1"
        iRet=$?
    done
    return $iRet
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#Զ첽ִУip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid="$$$2"
    local time_out=$3
    local cmd=$4
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
        local iRet=$?
        LOG "[$FUNCNAME]:IP:$remote_ip,le_pid:${le_pid},return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#ӡڵ汾
function print_NodeVersion
{
    local FILE=$1
    local IP=$2
    local exp_u=""
    local clusterversion=0
    netcard=`cat $FILE|grep netcard|awk -F: '{print $2}'`
    nvdimm=`cat $FILE|grep nvdimm|awk -F: '{print $2}'`
    ibcard=`cat $FILE|grep ibcard|awk -F: '{print $2}'`
    sascard=`cat $FILE|grep sascard|awk -F: '{print $2}'`
    bmc=`cat $FILE|grep BMC|awk -F: '{print $2}'`
    bios=`cat $FILE|grep BIOS|awk -F: '{print $2}'`
    mb_cpld=`cat $FILE|grep MB_CPLD|awk -F: '{print $2}'`
    bootrom=`cat $FILE|grep BOOTROM|awk -F: '{print $2}'`
    exp=`cat $FILE|grep EXP|grep "CPLD:"|awk -F: '{print $2}'`
    exp_u=`cat $FILE|grep EXP|grep 4U|awk -F: '{print $2}'`
    pangeaver=`cat $FILE|grep PANGEA_Version|awk -F: '{print $2}'`
    productver=`cat $FILE|grep ProductVersion|awk -F: '{print $2}'`
    masternodetype=`cat $FILE|grep NodeType|awk -F: '{print $2}'`
    compver=`cat $FILE|grep ComponentVersion|awk -F: '{print $2}'`
    sphver=`cat $FILE|grep SphVersion|awk -F: '{print $2}'`
    funcversion=`cat $FILE|grep FuncVersion|awk -F: '{print $2}'`
    clusterversion=`cat $FILE|grep ClusterVersion|awk -F: '{print $2}'`
    if [ $ProductType -eq 80 ] || [ $ProductType -eq 91 ];then
        #UDSSFSʹõͨ÷ BOOTROM EXP_CPLD PANGEA_Version汾
        Result="Node:$IP||NodeVersion:$funcversion ||ClusterVersion:$clusterversion || Netcard:$netcard|| Nvdimm:$nvdimm||Ibcard:$ibcard|| Sascard:$sascard|| BMC:$bmc|| BIOS:$bios|| MB_CPLD:$mb_cpld||ProductVersion:$productver||SphVersion:$sphver|| EXP_CPLD(4U):$exp_u||ComponentVersion:$compver"
    else
        Result="Node:$IP||NodeVersion:$funcversion ||ClusterVersion:$clusterversion || Netcard:$netcard|| Nvdimm:$nvdimm||Ibcard:$ibcard|| Sascard:$sascard|| BMC:$bmc|| BIOS:$bios|| MB_CPLD:$mb_cpld|| BOOTROM:$bootrom|| EXP_CPLD:$exp||ProductVersion:$productver||EXP_CPLD(4U):$exp_u||SphVersion:$sphver||PANGEA_Version:$pangeaver||ComponentVersion:$compver"
    fi
    WRITE_XML_COMMON 0 "$Result"
    LOG "$Result"
    if [ $funcversion != $clusterversion ];then
        LOG "[$FUNCNAME][$LINENO]IP:$IP NodeVersion:$funcversion is not equal ClusterVersion:$clusterversion."
        return 1
    fi
    return 0
}
#ԶִǷ
function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid="$$$2"
    local err_info=$3
    for time in ${RepeatTimes[*]}; do
        local proresult=`/opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid`
        local iRet=$?
        if [ $iRet -eq 101 ]; then
            LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time,le_pid:{$le_pid}"
            sleep 10
        else
            break
        fi
    done

    local process=`echo $proresult | awk '{print $1}'`
    local errno=`echo $proresult | awk '{print $4}'`

    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #ѯִгɹԶû
    elif [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid},exec(get progress) failed.iRet($iRet)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to get command result."
        return 1    #ѯִʧ
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        LOG "[$FUNCNAME] IP:$remote_ip,le_pid:${le_pid}, exec(get progress) success.iRet($iRet),errno($errno),process($process)"
        return 2    #ɹɣ˴Ҫ0Ϊɹ
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid}, exec(get progress) failed.iRet($iRet) errno($errno)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 3    #Զִʧ
    elif [ "$process" = "" ] && [ "$errno" = "" ];then
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid}, exec(get progress) failed.process(null), ip not accessed"
        return 5    #ʱ
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid}, exec(get progress) failed.process(null)"
        return 0    #ݴ
    else
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid}, exec(get progress) failed. Undefined error info"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 4    #δ
    fi
}

#һѽڵ첽ִУҪ׼ REMOTE_IP_S
function remote_exec_async_batch
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}

    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$3"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command."
            ret=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}

#Զ̵MML
function remote_exec_async_batch_mml
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}
    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$G_MML_FILE_PATH/$3 $Item > $G_REMOTE_TMP_FILE$4 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command."
            ret=1
        else
            cat $G_REMOTE_TMP_FILE$FUNCNAME | sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}

function remote_download_sync
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
        iRet=$?
        LOG "[$FUNCNAME] download ($remote_file) from ($remote_ip) to ($local_file) iRet:($iRet) time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done

    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get execute result."
    fi

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi
    return $iRet
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    eval "read -u $FIFO_OPERATE_ID"
    {
        for time in ${RepeatTimes[*]}; do
            /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
            iRet=$?
            LOG "[$FUNCNAME] download $remote_file from $remote_ip return:$iRet time:$time"
            if [ $iRet -eq 101 ]; then
                sleep 10
            else
                break
            fi
        done

        eval "echo >& $FIFO_OPERATE_ID"
    }

    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get execute result."
    fi

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi

    return $iRet
}

#Զ˷أ[ERR]ʶ
handle_remote_result()
{
    local line=$1
    echo "$line" |grep "\[ERR\]" > /dev/null
    if [ $? -eq 0 ]; then
        echo "$line" | awk -F] '{print $2}'
        return 1
    fi

    echo "$line"
    return 0
}

#default=0:NODEУdefault=1NODE
CheckMsgParse()
{
    Remote_ip=$1
    CheckMsgFile=$2
    local default=$3
    local info=""
    local Result=""
    dos2unix $CheckMsgFile > /dev/null 2>&1
    index=0
    while read var
    do
        if [ "$var" != "" ]; then
            info=`handle_remote_result "$var"`
            if [ $? -ne 0 ]; then
                if [ $default -eq 0 ];then
                    WRITE_XML_ERROR 0 "Node: $Remote_ip||${info}" >/dev/null
                elif [ $default -eq 1 ];then
                    WRITE_XML_ERROR 0 "${info}" >/dev/null
                fi
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:inspect error ${info}"
            else
                if [ $default -eq 0 ];then
                    WRITE_XML_COMMON 0 "Node: $Remote_ip||${info}" >/dev/null
                elif [ $default -eq 1 ];then
                    WRITE_XML_COMMON 0 "${info}" >/dev/null
                fi
            fi
        fi
    done < "$CheckMsgFile"
}

##############################################################################

#100. 
checkDiskUsage()
{
    #df -h
    #ʽFilesystem            Size  Used Avail Use% Mounted on
    #ʽ/dev/sda2             145G   39G  100G  28% /
    #ʽdevtmpfs              936M  100K  936M   1% /dev
    #ʽtmpfs                 936M     0  936M   0% /dev/shm
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local C72node=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    for Item in $REMOTE_IP_S; do
        remote_exec ${Item} 30 "cat /opt/huawei/deploy/etc/deploy.ini | grep devicename | grep \"9000 C72 Node\" >> /dev/null 2>&1"
        if [ $? -ne 0 ];then
            continue
        fi
        C72node="$C72node $Item"
    done

    # Ӽ/var/log/btmpļĴС
    remote_exec_async_batch $TASK_ID 120 "df -hl -x cafs > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get disk information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            javaId=`grep -v Filesystem $G_TMP_FILE$Item | sed 's/^ *//g'|sed "/^$/d"`

            set_ifs
            for line in $javaId; do
                if [ "$line" = "" ];then
                    continue
                fi

                FileSystem=`echo $line |awk '{print $1}'`
                Size=`echo $line |awk '{print $2}'`
                Used=`echo $line |awk '{print $3}'`
                Avail=`echo $line |awk '{print $4}'`
                Percentage=`echo $line |awk '{print $5}'|sed 's/.$//'`
                Mounted=`echo $line |awk '{print $6}'`

                Result="Node:$Item||FileSystem:$FileSystem||Size:$Size||Used:$Used||Avail:$Avail||Percentage(%):$Percentage||Mounted:$Mounted"
                WRITE_XML_COMMON 0 "$Result"

                echo "$C72node" | grep -wF "$Item" >/dev/null
                if [ $? -eq 0 -a "$Mounted" = "/" ] ;then
                    if [ $Percentage -ge 79 ]; then
                        isPass=1
                        LOG "[$FUNCNAME][$LINENO]isPass:$isPass||item:$Item||Percentage:$Percentage C72node"
                    fi
                else
                    if [ $Percentage -ge 78 ]; then
                        isPass=1
                        LOG "[$FUNCNAME][$LINENO]isPass:$isPass||item:$Item||Percentage:$Percentage"
                    fi
                fi
            done
            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#101. CPU
checkCPUUsage()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/ShowCpu > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get CPU information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME] $Item exec(ShowCpu) failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO: Failed to execute command(${G_MML_FILE_PATH}/ShowCpu)"
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[${FUNCNAME}] ${Item} download ${G_REMOTE_TMP_FILE}${FUNCNAME} failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO:Cannot get information of CPU!"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            userUsage=`grep "CPU_Usage:" $G_TMP_FILE$Item |awk '{print $2}'`
            sysUsage=`grep "CPU_Usage:" $G_TMP_FILE$Item |awk '{print $3}'`
            Percentage=`grep "CPU_Usage:" $G_TMP_FILE$Item |awk '{print $4}'`
            crazyTask=`grep "CPU_CrazyTask:" $G_TMP_FILE$Item |awk -F: '{print $2}'`
            #ռcpu5̵Ϣ
            info=`cat $G_TMP_FILE$Item |head -3|tail -1`
            i=0
            Result=""
            while read line; do
                i=$[ $i + 1 ]
                #ǰ
                if [ $i -le 3 ]; then
                    continue
                fi
                if [ "" != "${Result}" ]; then
                    Result="$Result||CPU Usage:$line"
                else
                    Result="CPU Usage:$line"
                fi
            done < $G_TMP_FILE$Item

            #ıʶͬӰ칤߽ʾ
            Result="CPU Usage:${G_SEPARATOR}||CPU Usage:$Item||CPU Usage:user(%):$userUsage
                    ||CPU Usage:system(%):$sysUsage||CPU Usage:Percentage(%):$Percentage
                    ||CPU Usage:--------------detail--------------||CPU Usage:$info||${Result}"
            #ڵǷ߳ռCPU 100% 1
            if [ "${crazyTask}""X" != "0X" ];then
                isPass=4
                Result="$Result||CPU Usage:--------------warning--------------||CPU Usage:Task (PID:$crazyTask) hold CPU over 100% up to 1 min"
            fi
            WRITE_XML_COMMON 0 "<![CDATA[$Result]]>"

            if [ $(echo "$Percentage < 80"|bc) -ne 1 ];then
                isPass=4
            fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#102. ڴ
checkMemUsage()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local Result=""
    local errResult=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    for Item in $REMOTE_IP_S; do

        set_ifs
        free_result=`remote_exec $Item 30 "free"`
        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="Node:$Item||INFO:Failed to execute(free) command.iRet($iRet).||${errResult}"
            LOG "[$FUNCNAME] $Item Failed to execute(free) command.iRet($iRet)"
            isPass=1
            restore_ifs
            continue
        fi

        MemTotal=`echo "$free_result" |grep "Mem:"|awk '{print $2}'`
        MemUsed=`echo "$free_result" |grep "-"|awk '{print $3}'`
        Percentage=`expr 100 \* $MemUsed`
        Percentage=`expr $Percentage / $MemTotal`

        #ռڴ5̵Ϣ
        info=`remote_exec $Item 30 "ps auxww|head -1"`
        top_5=`remote_exec $Item 30 "ps auxww | sort -k 4nr | head -5|sed 's/</(lt)/g'"`

        Result=""

        for line in $top_5; do
            if [ "" != "${Result}" ];then
                Result="$Result||Memory Usage:$line"
            else
                Result="Memory Usage:$line"
            fi
        done
        restore_ifs

        Result="Memory Usage:${G_SEPARATOR}||Memory Usage:$Item||Memory Usage:TotalMem:$MemTotal
                ||Memory Usage:UsedMem:$MemUsed||Memory Usage:Percentage(%):$Percentage
                ||Memory Usage:--------------detail--------------||Memory Usage:$info||${Result}"
        WRITE_XML_COMMON 0 "<![CDATA[$Result]]>"

        if [ $Percentage -gt 97 ];then
            isPass=1
        fi
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#103. ״̬
checkDiskStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #todo: Ĵܵ¼鲻
    remote_exec_async_batch_mml $TASK_ID 120 ShowDiskOnposition $FUNCNAME
    isPass=$?

    sleep 5
    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start

    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get disk information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item /tmp/tmpfilelocaldiskinfo
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                echo "FlagDownfail" >> $G_TMP_FILE$Item 2>&1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        if [ ! -f $G_TMP_FILE$Item ]; then
            LOG "[$FUNCNAME]:IP:$Item remote_exec fail."
            continue
        fi

        dos2unix $G_TMP_FILE$Item
        FlagDownfail=`cat $G_TMP_FILE$Item |grep FlagDownfail`
        if [ "$FlagDownfail" != "" ];then
            errResult="Node:$Item||INFO:Download file failed."
            WRITE_XML_ERROR 0 "${errResult}"
            LOG "[$FUNCNAME]:IP:$Item,Down file fail"
            continue
        fi

        javaID=`cat $G_TMP_FILE$Item |grep "Disk_ID"|sed 's/^ *//g'|sed "/^$/d"`
        if [ "$javaID" == "" ];then
            errResult="Node:$Item||INFO:Can not get disk information."
            WRITE_XML_ERROR 0 "${errResult}"
            LOG "[$FUNCNAME]:IP:$Item,Can not get disk information."
            isPass=1
            continue;
        fi

            set_ifs
            for line in $javaID; do
                if [ "$line" = "" ];then
                    continue;
                fi
                #ʽDisk_ID: 123606 || parent_ID: 2575 || location: 06 || Health_Status: 1 || Running_Status: 27 || Disk_type: 2 || BandWidth: 0 || Speed: 7200 || Tempreature: 31 || Model: WDC WD1003FBYX-01Y7B0 || Version: 01.01V01 || Manufacture: Western Digital || SN: WD-WCAW30712454 || Size: 1000204886016 || RunTime: 3 || DiskNeedUpg: -- || DiskUpgStrategy: --

                ID=$(echo "${line}" | awk -F'\\|\\|' '{print $1}' | awk -F':' '{print $2}' | tr -d ' ')

                parentID=$(echo "${line}" | awk -F'\\|\\|' '{print $2}' | awk -F':' '{print $2}' | tr -d ' ')
                #parentIDIP
                parentIP=$(get_node_backnet_ip $parentID)

                slot=$(echo "${line}" | awk -F'\\|\\|' '{print $3}' | awk -F':' '{print $2}' | tr -d ' ')
                healthStatus=$(echo "${line}" | awk -F'\\|\\|' '{print $4}' | awk -F':' '{print $2}' | tr -d ' ')
                healthStatus=$(MapHealthStatus $healthStatus)

                runningStatus=$(echo "${line}" | awk -F'\\|\\|' '{print $5}' | awk -F':' '{print $2}' | tr -d ' ')
                runningStatus=$(MapRunningStatus $runningStatus)

                diskType=$(echo "${line}" | awk -F'\\|\\|' '{print $6}' | awk -F':' '{print $2}' | tr -d ' ')
                diskType=$(MapDiskType $diskType)

                bandwidth=$(echo "${line}" | awk -F'\\|\\|' '{print $7}' | awk -F':' '{print $2}' | tr -d ' ')
                speed=$(echo "${line}" | awk -F'\\|\\|' '{print $8}' | awk -F':' '{print $2}' | tr -d ' ')
                Temperature=$(echo "${line}" | awk -F'\\|\\|' '{print $9}' | awk -F':' '{print $2}' | tr -d ' ')
                model=$(echo "${line}" | awk -F'\\|\\|' '{print $10}' | awk -F':' '{print $2}' | tr -d ' ')
                version=$(echo "${line}" | awk -F'\\|\\|' '{print $11}' | awk -F':' '{print $2}' | tr -d ' ')
                manu=$(echo "${line}" | awk -F'\\|\\|' '{print $12}' | awk -F':' '{print $2}' | tr -d ' ')
                SN=$(echo "${line}" | awk -F'\\|\\|' '{print $13}' | awk -F':' '{print $2}' | tr -d ' ')
                size=$(echo "${line}" | awk -F'\\|\\|' '{print $14}' | awk -F':' '{print $2}' | tr -d ' ')
                runTime=$(echo "${line}" | awk -F'\\|\\|' '{print $15}' | awk -F':' '{print $2}' | tr -d ' ')
                diskNeedUpg=$(echo ${line} | awk -F'\\|\\|' '{print $16}' | awk -F':' '{print $2}' | tr -d ' ')
                diskUpgStrategy=$(echo ${line} | awk -F'\\|\\|' '{print $17}' | awk -F':' '{print $2}' | tr -d ' ')

            if [ "${runningStatus}" != "NOT_EXIST" ];then
                    Result="ID:$ID||NodeID:$parentID||Node:$parentIP||slot:$slot||healthStatus:$healthStatus||runningStatus:$runningStatus||diskType:$diskType||bandwidth:$bandwidth||speed:$speed||Temperature(degrees):$Temperature||model:$model||version:$version||manu:$manu||SN:$SN||size(bytes):$size||runTime(days):$runTime||diskNeedUpg:${diskNeedUpg}||diskUpgStrategy:${diskUpgStrategy}"
                    WRITE_XML_COMMON 0 "${Result}"

                    if [ "${runningStatus}" != "ONLINE" ] || [ "${healthStatus}" != "NORMAL" ];then
                        LOG "[$FUNCNAME]:Error, ${Result}"
                        isPass=1
                    fi
            fi
        done
        restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#104. Դ״̬
checkPowerStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local iRet=0

    #ʽPower_ID: %s || parent_ID: %s || Health_Status: %d || Running_Status: %d || Power_type: %d || Vendor: %s || Model: %s || Version: %s || ProduceDate: %s || SN: %s
    #ʽPower_Count:2

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:-||INFO: can't get local ip"
            isPass=1
            break
        fi

        #ִmml cm power
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm power"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]$Info"
            errResult="Node:-||INFO:Failed to execute cm power."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Power_ID"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "$javaID" = "" ];then
            errResult="Node:-||INFO:Can not get information,Please try again."
            isPass=1

            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi

        set_ifs
        for line in $javaID; do
            if [ "$line" = "" ];then
                continue
            fi

            ID=`echo $line |awk '{print $2}'`
            parentID=`echo $line |awk '{print $5}'`

            cat $NID_ROLE_FILE | grep -wq $parentID >>/dev/null
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]iRet=$iRet,parentID=$parentID is not OK"
                continue
            fi
            parentIP=`get_node_backnet_ip $parentID`

            healthStatus=`echo $line |awk '{print $8}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`

            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            powerType=`echo $line |awk '{print $14}'`
            powerType=`MapPowerType $powerType`

            if [ "$runningStatus" = "NOT_EXIST" ];then
                powerType="--"
            fi

            vendor=`echo $line | awk -F: '{print $7}'|sed 's/|| Model//'`
            echo "$vendor"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                vendor="--"
            fi
            model=`echo $line |awk -F: '{print $8}'|sed 's/|| Version//'`
            echo "$model"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                model="--"
            fi
            version=`echo $line |awk -F: '{print $9}'|sed 's/|| ProduceDate//'`
            echo "$version"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                version="--"
            fi
            produceDate=`echo $line |awk -F\| '{print $17}'|awk '{print $2,$3,$4,$5,$6,$7 }'`
            echo "$produceDate"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                produceDate="--"
            fi
            SN=`echo $line |awk -F\| '{print $19}' |awk '{print $2}'`
            echo "$SN"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                SN="--"
            fi

            Result="ID:$ID||parentID:$parentID||nodeIP:$parentIP||healthStatus:$healthStatus||runningStatus:$runningStatus||powerType:$powerType||vendor:$vendor||model:$model||version:$version||produceDate:$produceDate||SN:$SN"

            WRITE_XML_COMMON 0 "$Result"

            if [ "$runningStatus" != "ONLINE" -a "$runningStatus" != "NORMAL" ] || [ "$healthStatus" != "NORMAL" ];then
                isPass=1
            fi
        done

        #жϱ׼нڵ붼˫Դ
        #жÿڵĵԴǷ2
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Power_Count"|sed 's/^ *//g'|sed "/^$/d"`
        for line in $javaID; do
            if [ $line = "" ];then
                continue
            fi

            count=`echo $line |awk -F: '{print $2}'`
            if [ "$count" != "2" ];then
                isPass=1
            fi
        done

        restore_ifs
        break
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#105. ״̬
checkFanStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""
    local FirstString=""
    local line=""
    local new_line=""
    local iRet=0
    local allnid=""

    #ʽFan_ID: 15496.1 || Fan_Name: FAN1 || parent_ID: 15496 || Health_Status: 1 || Running_Status: 1 || Running_Level: 1 || Elabel: 02G098Z0C2000101 || Speed: 5029
    #ʽFan_ID: 15496.2 || Fan_Name: FAN2 || parent_ID: 15496 || Health_Status: 1 || Running_Status: 1 || Running_Level: 1 || Elabel: 02G098Z0C2000101 || Speed: 5076
    #ʽFan_Count:2
    allnid=$(cat $NID_ROLE_FILE)
    LOG "[$FUNCNAME][$LINENO]allnid=$allnid"
    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:-||INFO: can't get local ip"
            isPass=1
            break
        fi

        #ִmmlcm fan
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm fan"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]$Info"
            errResult="Node:-||INFO:Failed to execute cm fan."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Fan_ID"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "$javaID" = "" ];then
            errResult="Node:-||INFO:Can not get information."
            isPass=1

            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi

        set_ifs
        for line in $javaID; do
            if [ $line = "" ];then
                continue
            fi

            #жϵһַǲǡFan_IDstart/time:08:13:35.277086 | clock:58435.277136Fan_ID: 14087.1 || Fan_Name:
            FirstString=`echo $line | awk '{print $1}'`
            if [ "$FirstString" != "Fan_ID:" ]; then
               new_line=`echo $line | awk -F"Fan_ID" '{print $2}'`
               LOG "[$FUNCNAME]:old_line:($line), new_line:($new_line)"
               line=$new_line
            fi
            ID=`echo $line |awk '{print $2}'`


            NAME=$(echo "${line}" | awk -F'\\|\\|' '{print $2}' | awk -F':' '{print $2}' | tr -d ' ')
            parentID=$(echo "${line}" | awk -F'\\|\\|' '{print $3}' | awk -F':' '{print $2}' | tr -d ' ')
            cat $NID_ROLE_FILE | grep -wq $parentID >>/dev/null
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]iRet=$iRet,parentID=$parentID is not OK"
                continue
            fi
            #parentIDIP
            parentIP=`get_node_backnet_ip $parentID`

            healthStatus=$(echo "${line}" | awk -F'\\|\\|' '{print $4}' | awk -F':' '{print $2}' | tr -d ' ')
            runningStatus=$(echo "${line}" | awk -F'\\|\\|' '{print $5}' | awk -F':' '{print $2}' | tr -d ' ')

            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            level=$(echo "${line}" | awk -F'\\|\\|' '{print $6}' | awk -F':' '{print $2}' | tr -d ' ')
            elabel=$(echo "${line}" | awk -F'\\|\\|' '{print $7}' | awk -F':' '{print $2}' | tr -d ' ')
            speed=$(echo "${line}" | awk -F'\\|\\|' '{print $8}' | awk -F':' '{print $2}' | tr -d ' ')
            Result="ID:$ID||name:$NAME||parentID:$parentID||nodeIP:$parentIP||healthStatus:$healthStatus||runningStatus:$runningStatus||level:$level||elabel:$elabel||speed(RPM):$speed"

            if [ "$runningStatus" != "NORMAL" ] || [ "$healthStatus" != "NORMAL" ];then
                WRITE_XML_COMMON 0 "$Result"
                LOG "[$FUNCNAME] ${parentIP}-$ID runningStatus(${runningStatus}) or healthStatus{$healthStatus} not NORMAL!"
                isPass=1
            else
                WRITE_XML_COMMON 0 "$Result"
            fi

        done
        restore_ifs
        #жÿڵķǷ2511
        for nid in $allnid ; do
            if [ $nid = "" ];then
                continue
            fi
            count=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Fan_ID"|sed 's/^ *//g'|sed "/^$/d" | grep -w "parent_ID: $nid"|wc -l)

            if [ "$count" != "2" ] && [ "$count" != "5" ] && [ "$count" != "11" ] && [ "$count" != "8" ]; then
                errResult="ParentID:$nid||INFO: FAN number($count) is not 2, 5, 8 or 11!||${errResult}"
                LOG "[$FUNCNAME] $nid Error: FAN number($count) is not 2, 5, 8 or 11!"
                isPass=1
            fi
        done

        break
    done

    #жϱ׼ȫȣ2511λ
    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#106. ڵ״̬״̬
checkNetportStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local InspectFun="ShowNIC"
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    LOG "[$FUNCNAME]start!"

    REMOTE_IP_S=$( cat $IP_ROLE_FILE)

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/ShowNIC > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE})
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get Netport information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE})
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        #ȡÿڵѲϢ
        PassStatus=$(cat $G_TMP_FILE$Item |eval grep '${InspectFun}_Pass' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Item||INFO:($InspectFun) get PassStatus failed"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:($InspectFun) get PassStatus failed!"
            isPass=$(check_pass $isPass 1)
            continue
        fi

        cat $G_TMP_FILE$Item |eval sed '/${InspectFun}_Pass/,\$\d' > ${CheckMsgFile}
        tmpinfo=$(cat ${CheckMsgFile})
        if [ "${tmpinfo}" == "" ];then
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Can not get physical memory information"
            continue
        fi

        isPass=$(check_pass $isPass $PassStatus )

        CheckMsgParse "$Item" "$CheckMsgFile" 0
        rm -rf ${CheckMsgFile}

    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#107. CPU״̬
checkCPUStatus()
{
    #ipmitool sdr|grep CPU
    #ʽCPU0_Core_temp   | -55 degrees C     | ok
    #ʽCPU1_Core_temp   | -50 degrees C     | ok
    #ʽCPU0_Status      | 0x80              | ok
    #ʽCPU1_Status      | 0x80              | ok
    #ʽVTT_CPU0         | 1.05 Volts        | ok
    #ʽVTT_CPU1         | 1.06 Volts        | ok
    #ʽVDDQ_DDR_CPU0    | 1.51 Volts        | ok
    #ʽVDDQ_DDR_CPU1    | 1.51 Volts        | ok
    #ʽVCCP_CPU0        | 0.85 Volts        | ok
    #ʽVCCP_CPU1        | 0.94 Volts        | ok

    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local errResult=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 300 "$G_MML_FILE_PATH/ShowCpuState > $G_REMOTE_TMP_FILE$FUNCNAME"
    if [ 0 -ne $? ];then
        isPass=1
    fi
    #cpuҪ60S˴ȴֹ첽
    sleep 60

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get ipmi cpu information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node: $Item||INFO: $info||${errResult}"
                    LOG "[$FUNCNAME] Error: $info"
                else
                    WRITE_XML_COMMON 0 "Node:$Item||$info"
                fi
            done < $G_TMP_FILE$Item
            restore_ifs
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#108. ڵ״̬
checkNodeStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local isPass=0

    #ʽNode_ID: 15425 || Node_Name: node65 || Health_Status: 1 || Running_Status: 2 || Frame: a1 || Slot: 1 || SN: 210235G78PZ0C8000011 || Device_Type: 33 || Manufacture: Huawei Technologies Co., Ltd. || Firmware_Version: V100R001C00 || Bussiness_IP: ["xx.xx.xx.xx","xx.xx.xx.xx"] || Manage_IP: xx.xx.xx.xx || Function_Type: 0 || Time: 0 || Time_zone:  || DevMgrIP: xx.xx.xx.xx || Tier_ID: 1

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:-||INFO: can't get local ip"
            isPass=1
            break
        fi

        #ִmmlcm node
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm node"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            errResult="Node:-||INFO:Can not get information.exec(cm node) failed!"
            LOG "[$FUNCNAME] $back_ip:Can not get information.exec(cm node) failed!Info($Info)"

            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Node_ID"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "$javaID" = "" ];then
            errResult="Node:-||INFO: Can not get information!||${errResult}"
            LOG "[$FUNCNAME] $back_ip get javaID(javaID) failed!"
            isPass=1

            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi

        set_ifs
        for line in $javaID; do
            if [ $line = "" ];then
                continue
            fi

            ID=`echo $line |awk '{print $2}'`
            if [[ ! "${ID}" =~ ^[0-9]+$ ]]; then
                continue
            fi
            NAME=`echo $line |awk '{print $5}'`
            healthStatus=`echo $line |awk '{print $8}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
            parentIP=$(get_node_backnet_ip $ID)
            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            frame=`echo $line |awk '{print $14}'`
            slot=`echo $line |awk '{print $17}'`
            SN=`echo $line |awk '{print $20}'`
            typeid=`echo $line |awk '{print $23}'`
            nodeTypeid=`echo $line |grep -Po '(?<=Function_Type: )[0-9]*' |tr -d ' '`
            type=$(MapNodeType  $nodeTypeid)
            Result="ID:$ID||name:$NAME||parentIP:$parentIP||healthStatus:$healthStatus||runningStatus:$runningStatus||Frame:$frame||Slot:$slot||SN:$SN||Type:$type"
            LOG "[$FUNCNAME] $Result||typeid:$typeid"

            WRITE_XML_COMMON 0 "$Result"
            if [ "$runningStatus" != "ONLINE" ] || [ "$healthStatus" != "NORMAL" ];then
                isPass=1
                errResult="Item:$ID||INFO:HealthStatus($healthStatus) is not NORMAL or runningStatus($runningStatus) is not ONLINE.||${errResult}"
                LOG "[$FUNCNAME] $ID healthStatus($healthStatus) is not NORMAL or runningStatus($runningStatus) is not ONLINE."
            fi
        done

        restore_ifs
        break
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#109.Verify
checkDiskVerify()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local tmpips=""
    local tmpFile1="/tmp/tmpfilesnlist"
    local tmpFile2="/tmp/tmpfilesnlist2"
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #todo: Ĵܵ¼鲻
    remote_exec_async_batch $TASK_ID 300 "/usr/local/bin/disktool -f A  > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1; exit 0"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get verify information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                echo "FlagDownfail" >> $G_TMP_FILE$Item 2>&1
                continue
            fi

            tmpips="$tmpips $Item"
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    /usr/local/bin/MmlBatch 4016 "cm diskinfo show" > $tmpFile1 2>&1
    for Item in $tmpips; do
        local fifoContext=$(cat $G_TMP_FILE$Item | grep "Total uncorrected errors" )
        if [ "$fifoContext" = "" ];then
            LOG "item=$Item, file($G_TMP_FILE$Item) is empty!"
            WRITE_XML_COMMON 0 "Node:$Item||location:No SAS disk||ReadError:--||WriteErr:--||VerifyErrorNumber:--"
            continue
        fi
        FlagDownfail=$( cat $G_TMP_FILE$Item |grep FlagDownfail)
        if [ "$FlagDownfail" != "" ];then
            LOG "[$FUNCNAME]:Node:$Item,Down file fail"
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Down disktool result file fail."
            continue
        fi
        #SNȡϢ
        cat $G_TMP_FILE$Item | grep -n "Serial Number:" > $tmpFile2

        local readErr=0
        local writeErr=0
        local verifyErr=0
        local tmpIndex=0
        local unCorrectedErrors=""

        local fistsn=""
        local snlist=$(cat $tmpFile2 | wc -l)  
        for((i=1; i<= $snlist + 1; i++)) ; do
            local snline=$(sed -n ${i}p $tmpFile2 | awk -F':' '{print $3}'| tr -d ' ')
            local snstart=$(sed -n ${i}p $tmpFile2 | awk -F':' '{print $1}' | tr -d ' ')
            local nexline=$(expr $i + 1)
            local snsend=$(sed -n ${nexline}p $tmpFile2 | awk -F':' '{print $1}' | tr -d ' ')

            if [[ "X$snstart" == "X" ]] ;then
                #ͬSNʱ,˳,ʱΪ/usr/local/bin/disktool -f A ظӡ
                break
            fi

            echo "${fistsn}" | grep -w "${snline}" >/dev/null
            if [ $? -eq 0 ];then
                #˵disktool ѯظ
                continue
            else
                fistsn="$fistsn $snline"
            fi

            if [[ "X$snsend" != "X" ]];then
                unCorrectedErrors=$(sed -n ${snstart},${snsend}p $G_TMP_FILE$Item | grep "Total uncorrected errors" | awk -F'=' '{print $2}'|tr -d ' ')
            else
                unCorrectedErrors=$(tail -n +${snstart} $G_TMP_FILE$Item | grep "Total uncorrected errors" | awk -F'=' '{print $2}'|tr -d ' ')
            fi

            if [ "X${unCorrectedErrors}" == "X" ];then
                #ûTotal uncorrected errors,ʾ
                continue
            fi

            set_ifs
            for errline in $unCorrectedErrors; do
                if [ $tmpIndex -eq 0 ];then
                    readErr=$errline
                    tmpIndex=$(expr $tmpIndex + 1)
                elif [ $tmpIndex -eq 1 ]; then
                    writeErr=$errline
                    tmpIndex=$(expr $tmpIndex + 1)
                else
                    verifyErr=$errline
                    tmpIndex=0
                fi
            done
            restore_ifs

            location=$(cat ${tmpFile1} | grep "${snline}" | grep -Po '(?<=location: )[A-Z0-9]+')
            if [ $readErr -gt 600 ] ; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:The value of readErr ($readErr) in slot ${location} exceeds the threshold (600)."
            elif [ $writeErr -gt 30 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:The value of writeErr ($writeErr) in slot ${location} exceeds the threshold (30)." 
            elif [ $verifyErr -gt 600 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:The value of verifyErr ($verifyErr) in slot ${location} exceeds the threshold (600)." 
            fi
            
            WRITE_XML_COMMON 0 "Node:$Item||location:$location||ReadError:$readErr||WriteErr:$writeErr||VerifyErrorNumber:$verifyErr"
        done
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#110. ڵ¶
checkCardTemp()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 300 "ipmitool sensor > $G_REMOTE_TMP_FILE$FUNCNAME; cat /opt/huawei/deploy/etc/deploy.ini | grep devicetype >> $G_REMOTE_TMP_FILE$FUNCNAME"
    isPass=$?

    sleep 30

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get ipmitool sensor information"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        fifoContext=`cat $G_TMP_FILE$Item`
        if [ "$fifoContext" = "" ];then
            LOG "[$FUNCNAME]:IP:$Item,file is empty!"
            continue
        fi

        devtype=$(cat $G_TMP_FILE$Item |grep devicetype |awk -F= '{print $2}')
        LOG "[$FUNCNAME]:devtype:$devtype"
        if [ $devtype -eq 12 ] || [ $devtype -eq 13 ] || [ $devtype -eq 14 ] || [ $devtype -eq 15 ] || [ $devtype -eq 17 ];then
            TempIN=`cat $G_TMP_FILE$Item |grep "Inlet Temp"|awk '{print $4}'`
            TempIN_Alarm=`cat $G_TMP_FILE$Item |grep "Inlet Temp"|awk '{print $17}'`
            TempEAR="--"
            TempEAR_Alarm="--"
            TempOUT="--"
            TempOUT_Alarm="--"
        else
            if [ "${devtype}" -ne 4 ];then
                #豸¶
                TempEAR=`cat $G_TMP_FILE$Item |grep TEMP_EAR|awk '{print $3}'`
                #豸¶ֵ
                TempEAR_Alarm=`cat $G_TMP_FILE$Item |grep TEMP_EAR|awk '{print $16}'`
            fi
            #¶
            TempIN=`cat $G_TMP_FILE$Item |grep TEMP_CARDIN|awk '{print $3}'`
            #ڸ澯ֵ
            TempIN_Alarm=`cat $G_TMP_FILE$Item |grep TEMP_CARDIN|awk '{print $20}'`
            #¶
            TempOUT=`cat $G_TMP_FILE$Item |grep TEMP_CARDOUT|awk '{print $3}'`
            #ڸ澯ֵ
            TempOUT_Alarm=`cat $G_TMP_FILE$Item |grep TEMP_CARDOUT|awk '{print $20}'`
        fi
        if [ "$TempIN" = "na" -o "$TempOUT" = "na" -o "$TempEAR" = "na" ];then
            errResult="Node: $Item||Error:The temperature is Abnormal!||$errResult"
            isPass=1
        fi
        if [ $devtype -eq 12 ] || [ $devtype -eq 13 ] || [ $devtype -eq 14 ] || [ $devtype -eq 15 ] || [ $devtype -eq 17 ];then
            if [ `echo "$TempIN > $TempIN_Alarm" | bc` -eq 1 ];then
                errResult="Node: $Item||Error:The Temperature exceeds the threshold!||$errResult"
                LOG "[$FUNCNAME] The Temperature exceeds the threshold!"
                isPass=1
            fi
            Result="Node:$Item||TempEAR(degrees):$TempEAR||TempEAR_Alarm(degrees):$TempEAR_Alarm||TempIN(degrees):$TempIN||TempIN_Alarm(degrees):$TempIN_Alarm||TempOUT(degrees):$TempOUT||TempOUT_Alarm(degrees):$TempOUT_Alarm"
        elif [ "${devtype}" -eq 4 ]; then
                if [ `echo "$TempIN > $TempIN_Alarm" | bc` -eq 1 ] || [ `echo "$TempOUT > $TempOUT_Alarm" | bc` -eq 1 ];then
                    errResult="Node: $Item||Error:The Temperature exceeds the threshold!||$errResult"
                    LOG "[$FUNCNAME] The Temperature exceeds the threshold!"
                    isPass=1
                fi
                Result="Node:$Item||TempIN(degrees):$TempIN||TempIN_Alarm(degrees):$TempIN_Alarm||TempOUT(degrees):$TempOUT||TempOUT_Alarm(degrees):$TempOUT_Alarm"
        else
            if [ `echo "$TempEAR > $TempEAR_Alarm" | bc` -eq 1 ] || [ `echo "$TempIN > $TempIN_Alarm" | bc` -eq 1 ] || [ `echo "$TempOUT > $TempOUT_Alarm" | bc` -eq 1 ];then
                errResult="Node: $Item||Error:The Temperature exceeds the threshold!||$errResult"
                LOG "[$FUNCNAME] The Temperature exceeds the threshold!"
                isPass=1
            fi
            Result="Node:$Item||TempEAR(degrees):$TempEAR||TempEAR_Alarm(degrees):$TempEAR_Alarm||TempIN(degrees):$TempIN||TempIN_Alarm(degrees):$TempIN_Alarm||TempOUT(degrees):$TempOUT||TempOUT_Alarm(degrees):$TempOUT_Alarm"
        fi
        LOG "[$FUNCNAME]:$Result"

        WRITE_XML_COMMON 0 "$Result"
    done

    if [ "${isPass}" == "0" ];then
        WRITE_XML_JUDGE 0
    else
        WRITE_XML_ERROR 0 "$errResult"
        WRITE_XML_JUDGE 1
    fi

    WRITE_XML_SUBCMD_TAIL
}

#112. ģ״̬⹦쳣㲻ͨʵֲμ澯
checkFiber_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local errResult=""
    local isPass=0
    local fiberInfo=""
    local iRet=0

    #ʽFiber_ID: %s || parent_ID: %s || location: %s || Health_Status: %d || Running_Status: %d || ModeType: %d || WaveLen: %d || RX_Power: %d || TX_Power: %d || Speed: %d || Temperature: %d || Voltage: %d || Vendor: %s || Model: %s || SN: %s || Node_Type: %s || NetCard_Manufacturer: %s
    #ʽFiber_Count: %d || Node_ID: %s || Node_Type: %s || NetCard_Manufacturer: %s

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:-||INFO: can't get local ip"
            isPass=1
            break
        fi

        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm fiberinfo show" >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            errResult="Node:-||INFO: Can't get information,exec(cm fiberinfo show) failed!||${errResult}"
            LOG "[$FUNCNAME]$back_ip:can't get information,exec(cm fiberinfo show) failed!Info($Info)."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #Fiber_Count: 0 || Node_ID: 124 || Node_Type: C36 || NetCard_Manufacturer: Intel
        fiberInfo=`grep "Fiber_Count" $G_REMOTE_TMP_FILE$FUNCNAME |sed 's/^ *//g'|sed "/^$/d"`

        if [ "$fiberInfo" = "" ];then
            errResult="Node:-||INFO: Get Fiber_Count failed!||${errResult}"
            LOG "[$FUNCNAME]$back_ip:get Fiber_Count failed!"
            isPass=1

            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1

            break
        fi

        set_ifs
        for line in $fiberInfo; do
            if [ "$line" = "" ];then
                continue
            fi
            count=`echo "$line" |awk '{print $2}'`
            nodeID=`echo "$line" |awk '{print $5}'`
            cat $NID_ROLE_FILE | grep -wq $nodeID >>/dev/null
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]iRet=$iRet,nodeID=$nodeID is not OK"
                continue
            fi
            nodeType=`echo "$line" |awk '{print $8}'`
            netCardManufacturer=`echo "$line" |awk '{print $11}'`
            nodeIP=`get_node_backnet_ip $nodeID`
            if [ "$count" = "0" ];then
                Result="Node:$nodeIP(Node type: $nodeType node, network card: $netCardManufacturer)||ID:No optical module ||parentID:--||location:--||healthStatus:--||runningStatus:--||modeType:--||waveLen:--||RX_Power:--||TX_Power:--||Speed:--||Temperature:--||Voltage:--||Vendor:--||Model:--||SN:--"
                WRITE_XML_COMMON 0 "$Result"
                LOG "[$FUNCNAME]-:no Fiber exists!count($count)."
            fi
        done

        fiberInfo=`grep "Fiber_ID" $G_REMOTE_TMP_FILE$FUNCNAME |sed 's/^ *//g'|sed "/^$/d"`

        for line in $fiberInfo; do
            if [ "$line" = "" ];then
                continue
            fi

            ID=`echo "$line" |awk '{print $2}'`
            parentID=`echo "$line" |awk '{print $5}'`
            cat $NID_ROLE_FILE | grep -wq $parentID >>/dev/null
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]iRet=$iRet,parentIP=$parentIP is not OK"
                continue
            fi
            #parentIDIP
            parentIP=`get_node_backnet_ip $parentID`
            location=`echo "$line" |awk '{print $8}'`
            healthStatus=`echo "$line" |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo "$line" |awk '{print $14}'|sed 's/^ *//g'|sed "/^$/d"`

            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            modeType=`echo "$line" |awk '{print $17}'`

            waveLen=`echo "$line" |awk '{print $20}'`
            Vendor=`echo "$line" |awk '{print $38}'`
            Speed=`echo "$line" |awk '{print $29}'`

            Voltage=`echo "$line" |awk '{print $35}'`
            Temperature=`echo "$line" |awk '{print $32}'`
            RX_Power=`echo "$line" |awk '{print $23}'`
            TX_Power=`echo "$line" |awk '{print $26}'`
            if [ $Voltage = "0" -a $Temperature = "0" -a $RX_Power = "0" -a $TX_Power = "0" ];then
                Voltage="--"
                Temperature="--"
                RX_Power="--"
                TX_Power="--"
            fi

            Model=`echo "$line" | awk -F'Model:' '{print $2}'|awk '{print $1}'`
            SN=`echo "$line" | awk -F'SN:' '{print $2}'|awk '{print $1}'`
            nodeType=`echo "$line" | awk -F'Node_Type:' '{print $2}'|awk '{print $1}'`
            netCardManufacturer=`echo "$line" | awk -F'NetCard_Manufacturer:' '{print $2}'|awk '{print $1}'`

            Result="Node:$parentIP(Node type: $nodeType node, network card: $netCardManufacturer)||ID:$ID||parentID:$parentID||location:$location||healthStatus:$healthStatus||runningStatus:$runningStatus||modeType:$modeType||waveLen:$waveLen||RX_Power:$RX_Power||TX_Power:$TX_Power||Speed:$Speed||Temperature:$Temperature||Voltage:$Voltage||Vendor:$Vendor||Model:$Model||SN:$SN"

            WRITE_XML_COMMON 0 "$Result"
            if [ "$runningStatus" != "NORMAL" ] ||[ "$healthStatus" != "NORMAL" ];then
                isPass=1
            fi
        done

        restore_ifs
        break
    done

    if [ "" != "${errResult}" ];then
        WRITE_XML_ERROR 0 "$errResult"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#113. SSDһλSSD,ΪNOFS
checkSSD()
{
    WRITE_XML_SUBCMD_HEADER $1
    local errResult=""
    local isPass=0
    local isSlotOk=1
    local allNidDisk=""
    local allNid=""
    local Item=""
    local AllDiskFile=$G_TMP_FILE"DiskSSD"

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:-(Master)||INFO: Can't get local ip"
            LOG "[$FUNCNAME]:$errResult"
            isPass=1
            break
        fi

        #ִmml cm diskinfo
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm diskinfo"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]$Info"
            errResult="Node:$back_ip(Master)||INFO: Failed to execute command.(cm diskinfo),port(4016)."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME

        allNidDisk=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Disk_ID"|sed 's/^ *//g'|sed "/^$/d"`
        local filenamebase=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep '/tmp/snas_debug*' |xargs basename|sed 's/^ *//g'|sed "/^$/d"`
        local filename="/tmp/$filenamebase"

        if [ "$allNidDisk" = "" ];then
            if [ "$filenamebase" = "" ];then
                errResult="Node:$back_ip(Master)||INFO:Can not get disk information."
                isPass=1
                LOG "[$FUNCNAME]:$errResult"
                cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
                break
            else
                cat $filename|grep "Disk_ID"|sed 's/^ *//g'|sed "/^$/d" > $AllDiskFile  2>&1
                LOG "[$FUNCNAME]:filename:$filename,filenamebase:$filenamebase"
            fi
        else
            cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Disk_ID"|sed 's/^ *//g'|sed "/^$/d" > $AllDiskFile  2>&1
        fi

        #ȡڵnid
        allNid=`cat $NID_ROLE_FILE`

        #ÿڵSSD̵״̬

        for Item in $allNid; do
            LOG "[$FUNCNAME]NID($Item)"
            set_ifs
            NodeIP=`get_node_backnet_ip $Item`
            oneNidinfo=`cat $AllDiskFile | grep -w $Item | grep "Disk_type: 3"`
            if [ "$oneNidinfo" = "" ]; then
                errResult="Node: $NodeIP||INFO: No SSD information."
                WRITE_XML_ERROR 0 "${errResult}"
                errResult=""
                continue
            fi
            #жssd̵״̬
            isSlotOk=1
            for line in $oneNidinfo; do
                LOG "[$FUNCNAME]line($line)"

                ID=`echo $line |awk '{print $2}'`

                parentID=`echo $line |awk '{print $5}'`
                #parentIDIP
                parentIP=`get_node_backnet_ip $parentID`

                location=`echo $line|awk '{print $8}'`

                healthStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
                runningStatus=`echo $line |awk '{print $14}'|sed 's/^ *//g'|sed "/^$/d"`

                healthStatus=`MapHealthStatus $healthStatus`
                runningStatus=`MapRunningStatus $runningStatus`

                bandwidth=`echo $line |awk '{print $20}'`
                Temperature=`echo $line |awk '{print $26}'`

                model=`echo $line |awk -F: '{print $11}'|sed 's/|| Version//'`

                version=`echo $line |awk -F: '{print $12}'|sed 's/|| Manufacture//'`
                manu=`echo $line |awk -F: '{print $13}'|sed 's/|| SN//'`
                SN=`echo $line |awk -F: '{print $14}'|sed 's/|| Size//'`
                size=`echo $line |awk -F: '{print $15}'|sed 's/|| RunTime//'`
                runTime=`echo $line |awk -F: '{print $16}'|sed 's/|| DiskNeedUpg//'`
                DiskNeedUpg=`echo $line|awk -F: '{print $17}'|sed 's/|| DiskUpgStrategy//'`

                if [ "$location" = "0" ] || [ "$location" = "00" ]; then
                    isSlotOk=0
                fi

                if [ "$runningStatus" != "NOT_EXIST" ];then
                    Result="Node:$parentIP||location:$location||healthStatus:$healthStatus||runningStatus:$runningStatus||bandwidth:$bandwidth||Temperature(degrees):$Temperature||model:$model||version:$version||manu:$manu||SN:$SN||size(bytes):$size||runTime(days):$runTime||DiskNeedUpg:$DiskNeedUpg"
                    WRITE_XML_COMMON 0 "$Result"

                    if [ "$runningStatus" != "ONLINE" ] || [ "$healthStatus" != "NORMAL" ];then
                        LOG "[$FUNCNAME]:Error, $Result"
                        isPass=1
                        errResult="Node:$parentIP||INFO:The location(${location}) current running status (${runningStatus}) is not consistent with the standard running status (ONLINE) or the current health status (${healthStatus}) is not consistent with the standard health status (NORMAL).ERRCODE(4)"
                        WRITE_XML_ERROR 0 "${errResult}"
                        errResult=""
                    fi
                else
                    errResult="Node: $parentIP||INFO: No SSD information."
                    WRITE_XML_ERROR 0 "${errResult}"
                    errResult=""
                    continue
                fi
            #end for oneNidinfo
            done

            if [ "$isSlotOk" -ne 0 ];then
                LOG "[$FUNCNAME]:Error,$parentIP SSD location not in 0 "
                isPass=1
                errResult="Node:${parentIP}||INFO: The SSD location(${location}) is not consistent with the standard location (0 or 00)."
                WRITE_XML_ERROR 0 "${errResult}"
                errResult=""
            fi
            restore_ifs
        #end for allNid
        done

        break
    #end for while
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#114. ϵͳRAID״̬˫ϵͳ̣ϵͳжͨ
checkSysRAID()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local iRet=0
    local errResult=""
    local TASK_ID=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 300 "$G_MML_FILE_PATH/Checksysdisk.sh > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ 0 -ne $? ];then
        isPass=1
    fi
    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get sysdisk info"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node: $Item||INFO: $info||${errResult}"
                    LOG "[$FUNCNAME] Error: $info"
                else
                    WRITE_XML_COMMON 0 "Node:$Item||$info"
                fi
            done < $G_TMP_FILE$Item
            restore_ifs
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#115nvdimm״̬
checkNvdimmStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    >${VALID_IP_FILE}
    for Item in ${REMOTE_IP_S}; do
        remote_exec ${Item} 30 "cat /opt/huawei/deploy/etc/deploy.ini | grep devicename | grep \"9000 C72 Node\" >> /dev/null 2>&1"
        if [ $? -ne 0 ];then
            echo -n "$Item " >> ${VALID_IP_FILE}
            continue
        fi
	#ܿڵ
        WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:No need to check."
    done

    REMOTE_IP_S=$(cat "${VALID_IP_FILE}")

    #ļжǷܿϢ
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/nvdimm_status_record > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1 >> $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=$(cat "${VALID_IP_FILE}")
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get nvdimm information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            NoNvdimmInfo=`cat $G_TMP_FILE$Item | grep "NO NVDIMM FOUND"`
            if [ "$NoNvdimmInfo" != "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:There is no Nvdimm."
                continue
            fi

            ErrInfo=`cat $G_TMP_FILE$Item | grep "some wrong during Recording NVDIMM Status"`
            if [ "$ErrInfo" != "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Get Nvdimm Info Fail"

                #
                cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                continue
            fi

            #ȡnvdimmĸ
            set_ifs
            Nvdimm_NUM=`cat $G_TMP_FILE$Item | grep "There are" | grep "found under system" |  awk '{print $3}'`
            if [ "$Nvdimm_NUM" -le 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:the NUM of Nvdimm is $Nvdimm_NUM"

                restore_ifs
                #
                cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                continue
            fi

            #ѭʾnvdimmϢ
            index=1
            while [[ "$index" -le "$Nvdimm_NUM" ]]
            do
                echo "$index"

                #ȡNAME
                NVDIMM_NAME=`cat $G_TMP_FILE$Item | grep "NVDIMM NAME" | awk NR==$index | awk '{print $3}'`

                #ȡģʽ
                SAVE_MODE=`cat $G_TMP_FILE$Item | grep "SAVE MODE" | awk NR==$index | awk '{print $3}'`

                #ȡ¶
                TEMPERATUER=`cat $G_TMP_FILE$Item | grep "CAP TEMPERATUER" | awk NR==$index | awk '{print $3}'`

                #ȡǷλ
                PRESENCE=`cat $G_TMP_FILE$Item | grep "CAP PRESENCE" | awk NR==$index | awk '{print $3}'`

                #FLASH״̬
                FLASH_STATUS=`cat $G_TMP_FILE$Item | grep "FLASH STATUS OK" | awk NR==$index | awk '{print $3}'| awk -F: '{print $2}'`

                #Ƿ
                FULL_CHARGE=`cat $G_TMP_FILE$Item | grep "CAP FULL CHARGE" | awk NR==$index | awk '{print $4}'`

                #Ƿﵽʹ
                LIFE_END=`cat $G_TMP_FILE$Item | grep "CAP LIFE END" | awk NR==$index | awk '{print $3}' | awk -F: '{print $2}'`

                if [ "$SAVE_MODE" != "CKE_MODE" ] || [ "$TEMPERATUER" -gt "60" ] || [ "$PRESENCE" != "TRUE" ] || [ "$FLASH_STATUS" != "TRUE" ] || [ "$FULL_CHARGE" != "TRUE" ] || [ "$LIFE_END" != "FALSE" ]; then
                    NVDIMM_STAT="FAULT"
                    isPass=1
                else
                    NVDIMM_STAT="NORMAL"
                fi

                Result="Node:$Item||NVDIMM NAME:$NVDIMM_NAME||NVDIMM_STATUS:$NVDIMM_STAT||SAVE MODE:$SAVE_MODE||CAP TEMPERATUER(centigrade):$TEMPERATUER||CAP PRESENCE:$PRESENCE||FLASH_STATUS:$FLASH_STATUS||CAP FULL CHARGE:$FULL_CHARGE||CAP LIFE END:$LIFE_END"

                LOG "[$FUNCNAME]:Result:$Result"

                WRITE_XML_COMMON 0 "$Result"

                #һѭ
                index=$((index + 1 ))
            done

            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#ÿڵECCϢ
function checkEcc_result()
{
    local isOK=0
    local ip=$1
    local info=$2

    LOG "ecc IP:$ip||$info"

    if [ "$info" = "" ];then
        #ʾ
        Result="Info:No Ecc errors"
        #Itemֱⲿֵ
        WRITE_XML_COMMON 0 "Node:$ip||${Result}"
        return 0
    fi

    # get DIMM countȡDIMMĸ
    uiDiMMCnt=`echo "$info" | grep "DIMM" | wc -l`
    LOG "bit ecc Dimm num:$uiDiMMCnt"

    #parse 
    uiLine=0
    uiErrCount=0
    uiLoop=0
    Result="Info:bit ecc ok"
    while [ $uiLoop -lt $uiDiMMCnt ]; do
        uiLine=`echo "5+$uiLoop*8"|bc`
        LOG "bit ecc: $uiLoop,line: $uiLine"

        uiErrCount=`echo "$info" | awk NR==$uiLine| awk '{print $1}'`
        LOG "bit ecc:out $uiErrCount"

        #threshold ֵΪ 25K
        if [ $uiErrCount -gt 25000 ];then
            isOK=1
            Result="Info:bit ecc too much"
        fi

        #uiLoop++ ȡһ
        uiLoop=$((uiLoop+1))
    done
    WRITE_XML_COMMON 0 "Node:$ip||${Result}"

    #ݽϸϢӡ
    Result=""
    set_ifs
    WRITE_XML_COMMON 0 "Node: ||Info:--------------detail-------------- "
    for line in $info; do
        Result="Info:${line}"
        WRITE_XML_COMMON 0 "Node: ||${Result}"
    done
    restore_ifs

    return $isOK
}

#116 Bit ECCĴ mcelog --client
function checkBitEcc()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""
    ALLIp=`cat $IP_ROLE_FILE`

    for Item in $ALLIp; do
        info=`remote_exec $Item 120 "mcelog --client"`

        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="Node: $Item||INFO: Failed to execute mcelog||$errResult"
            isPass=1
            continue
        fi

        checkEcc_result $Item "$info"
        if [ $? -ne 0 ]; then
            isPass=1
        fi
    done

    if [ "" != "${errResult}" ];then
        WRITE_XML_ERROR 0 "$errResult"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#117. ARP
checkArpErr_MML()
{
   WRITE_XML_SUBCMD_HEADER $1
    local arpinfo=""
    local Result=""

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    LOG "[checkArpErr_MML] start"
    remote_exec_async_batch_mml $TASK_ID 30 ShowArpErr $FUNCNAME
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get ShowArpErr information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            dos2unix $G_TMP_FILE$Item

            #
            arpinfo=""
            arpinfo=`cat $G_TMP_FILE$Item|grep 'ArpErrPort'|sed 's/^ *//g'|sed "/^$/d"`
            LOG "[$FUNCNAME]Node:$Item||$arpinfo"

            arperrport=""
            arperrname=""

            #ûݴ
            if [ "$arpinfo" == "" ];then

                #ʾ
                Result="Node:$Item||Arp error port:no data"
                LOG "[$FUNCNAME]:$Result"
                WRITE_XML_COMMON 0 "$Result"

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

                isPass=1
            else
               #ûڽ
               arperrport=`echo $arpinfo | grep no`
               if [ "$arperrport" != "" ];then

                    #ʾ
                    Result="Node:$Item||Arp error port:none"
                    LOG "[$FUNCNAME]no port err:$Result"
                    WRITE_XML_COMMON 0 "$Result"
               else
               #дĶ˿ڽ˿ʾ
                    arperrname=`echo $arpinfo | awk '{print $2}'`

                    #ʾ
                    Result="Node:$Item||Arp error port:$arperrname"
                    LOG "[$FUNCNAME] have err port:$Result"
                    WRITE_XML_COMMON 0 "$Result"
                    isPass=1

                    #
                    cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
               fi
            fi

            restore_ifs
    done

    LOG "[$FUNCNAME] over"

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

 #119 汾һ
 checkNodeVersion()
 {
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""
    local Result=""
    local TASK_ID=0
	local T3000_C72=0
    local SLAVE_IP_FILE="/tmp/tmp_slave_ip"
    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')
    local cmpFlag=0
    local funcversion=0
    local clusterversion=0
    local iRet=0
    local othernodeversion=0
    local upgradeFlag=0
    #T3000C72֮ĽڵҪӷ֧
    ALLIp=`cat $IP_ROLE_FILE`

    #ȡڵİ汾
    master_version_file=/tmp/tmpcmmaster_version
    master_version_filetmp=/tmp/tmpcmmaster_versiontmp
    typelistfile=/tmp/tmptypelistfiletmp
    [ -f ${master_version_file} ] && rm -f ${master_version_file}
    $G_MML_FILE_PATH/GetNodeVersion > $master_version_file
    netcard=`cat $master_version_file|grep netcard|awk -F: '{print $2}'`
    nvdimm=`cat $master_version_file|grep nvdimm|awk -F: '{print $2}'`
    ibcard=`cat $master_version_file|grep ibcard|awk -F: '{print $2}'`
    sascard=`cat $master_version_file|grep sascard|awk -F: '{print $2}'`
    bmc=`cat $master_version_file|grep BMC|awk -F: '{print $2}'`
    bios=`cat $master_version_file|grep BIOS|awk -F: '{print $2}'`
    mb_cpld=`cat $master_version_file|grep MB_CPLD|awk -F: '{print $2}'`
    bootrom=`cat $master_version_file|grep BOOTROM|awk -F: '{print $2}'`
    exp=`cat $master_version_file|grep EXP|grep "CPLD:"|awk -F: '{print $2}'`
    exp_u=`cat $master_version_file|grep EXP|grep 4U|awk -F: '{print $2}'`
    pangeaver=`cat $master_version_file|grep PANGEA_Version|awk -F: '{print $2}'`
    productver=`cat $master_version_file|grep ProductVersion|awk -F: '{print $2}'`
    masternodetype=`cat $master_version_file|grep NodeType|awk -F: '{print $2}'`
    compver=`cat $master_version_file|grep ComponentVersion|awk -F: '{print $2}'`
    sphver=`cat $master_version_file|grep SphVersion|awk -F: '{print $2}'`
    funcversion=`cat $master_version_file|grep FuncVersion|awk -F: '{print $2}'`
    clusterversion=`cat $master_version_file|grep ClusterVersion|awk -F: '{print $2}'`

    local tmpUpgradeFlag=$(cat $master_version_file | grep UpgradeFlag | awk -F: '{print $2}')
    if [ "X$tmpUpgradeFlag" != "X" ] && [ $tmpUpgradeFlag -gt $upgradeFlag ];then
        upgradeFlag=$tmpUpgradeFlag
    fi
    #ʱ
    sed -i '/UpgradeFlag/d' $master_version_file

    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        isPass=1
        LOG "[$FUNCNAME]:INFO: Can't get local ip"
    fi
    if [ $ProductType -eq 80 ] || [ $ProductType -eq 91 ];then
        #UDSSFSʹõͨ÷ BOOTROM EXP_CPLD PANGEA_Version汾
        Result="Node:$back_ip||NodeVersion:$funcversion ||ClusterVersion:$clusterversion || Netcard:$netcard|| Nvdimm:$nvdimm||Ibcard:$ibcard|| Sascard:$sascard|| BMC:$bmc|| BIOS:$bios|| MB_CPLD:$mb_cpld||ProductVersion:$productver|| EXP_CPLD(4U):$exp_u||SphVersion:$sphver||ComponentVersion:$compver"
    else
        Result="Node:$back_ip||NodeVersion:$funcversion ||ClusterVersion:$clusterversion || Netcard:$netcard|| Nvdimm:$nvdimm||Ibcard:$ibcard|| Sascard:$sascard|| BMC:$bmc|| BIOS:$bios|| MB_CPLD:$mb_cpld|| BOOTROM:$bootrom|| EXP_CPLD:$exp||ProductVersion:$productver||EXP_CPLD(4U):$exp_u||SphVersion:$sphver||PANGEA_Version:$pangeaver||ComponentVersion:$compver"
    fi
    WRITE_XML_COMMON 0 "$Result"
    LOG "$Result"
    if [ $funcversion != $clusterversion ];then
        isPass=$(check_pass $isPass 4)
        LOG "master funcversion:$funcversion not equal clusterversion:$clusterversion."
    fi
	#޳4uı
    cat $master_version_file |grep -v "EXP & CPLD(4U)" | grep -v "devicetype:" > $master_version_filetmp
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/GetNodeVersion > $G_REMOTE_TMP_FILE$FUNCNAME"
    if [ 0 -ne $? ];then
        isPass=$(check_pass $isPass 1)
    fi
    ValidIP=`cat ${VALID_IP_FILE}`
	>${SLAVE_IP_FILE}
    ValidIPResult=$ValidIP

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get node version"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=$(check_pass $isPass 1)
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=$(check_pass $isPass 1)
                LOG "Node: $Item||INFO: remote download file failed."
                echo "FlagDownfail" >> $G_TMP_FILE$Item 2>&1
                continue;
            fi

            tmpUpgradeFlag=$(cat $G_TMP_FILE$Item | grep UpgradeFlag | awk -F: '{print $2}')
            if [ "X$tmpUpgradeFlag" != "X" ] && [ $tmpUpgradeFlag -gt $upgradeFlag ];then
                upgradeFlag=$tmpUpgradeFlag
            fi
            ClusterUpdStatus=$(cat $G_TMP_FILE$Item | grep ClusterUpdStatus | awk -F: '{print $2}')
            if [ "X$ClusterUpdStatus" != "X0" ];then
                isPass=$(check_pass $isPass 1)
                LOG "[$FUNCNAME][$LINENO]IP:$Item ClusterUpdStatus:$ClusterUpdStatus is not equal 0."
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:ClusterUpdStatus $ClusterUpdStatus is not equal 0."
            fi
            #ʱ
            sed -i '/UpgradeFlag/d' $G_TMP_FILE$Item
            sed -i '/ClusterUpdStatus/d' $G_TMP_FILE$Item
			#޳4uı
            cat $G_TMP_FILE$Item |grep -v "EXP & CPLD(4U)" | grep -v "devicetype:" > $G_TMP_FILE$Item"tmp"
            if [ "$back_ip" != "$Item" ];then
                print_NodeVersion $G_TMP_FILE$Item $Item
                iRet=$?
                if [ 0 -eq $iRet ];then
                    othernodeversion=$(cat $G_TMP_FILE$Item|grep ClusterVersion|awk -F: '{print $2}')
                    if [ $othernodeversion != $clusterversion ];then
                        isPass=$(check_pass $isPass 4)
                        LOG "[$FUNCNAME][$LINENO]IP:$Item ClusterVersion:$othernodeversion is not equal $clusterversion."
                    fi
                else
                    isPass=4
                fi
            fi

            #߳devicetypeΪ 12 13 14 15 Ľڵ㣬Ƚ
            devicetype=`cat $G_TMP_FILE$Item | grep devicetype | awk -F: '{sub("^[ \t]*","",$2);print $2}'`
            LOG "devicetype=[$devicetype]"
            if [ "$devicetype" = "12" ] || [ "$devicetype" = "13" ] || [ "$devicetype" = "14" ] || [ "$devicetype" = "15" ];then
                echo "devicetype=$devicetype;IP=$Item"  >> $typelistfile
                LOG "devicetype=$devicetype;IP=$Item"
                cmpFlag=1
                continue
            fi

            slavenodetype=`cat $G_TMP_FILE$Item|grep NodeType|awk -F: '{print $2}'`
            if [ "$masternodetype" != "$slavenodetype" ];then
                if [ "$T3000_C72" == "0" ];then
                    T3000_C72=1
                    slave_version_file=$G_TMP_FILE$Item
                    slave_ip=$Item
                fi
                echo -n "$Item " >> ${SLAVE_IP_FILE}
                continue
            fi

			diff $master_version_filetmp $G_TMP_FILE$Item"tmp" > /dev/null
	    	if [ 0 -ne $? ];then
                isPass=$(check_pass $isPass 4)
                LOG "[$FUNCNAME] $master_version_filetmp, $G_TMP_FILE$Item,."
	    	else
                exp_u_tmp=$(cat $G_TMP_FILE$Item|grep EXP|grep 4U|awk -F: '{print $2}')
                if [ "$exp_u" == "" ] && [ "$exp_u_tmp" != "" ];then
                	exp_u=$exp_u_tmp
                    LOG "[$FUNCNAME] exp_u:$exp_u, exp_u_tmp:$exp_u_tmp"
				fi

				if [ "$exp_u" != "" -a "$exp_u_tmp" != "" -a "$exp_u" != "$exp_u_tmp" ];then
                    isPass=$(check_pass $isPass 4)
                    LOG "[$FUNCNAME] Get EXP_CPLD(4U) of nodes are not the same."
                fi
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish
    if [ $upgradeFlag -eq 1 ];then
        isPass=$(check_pass $isPass 1)
        WRITE_XML_ERROR 0 "Node:master||INFO:The cluster version in the memory is not updated."
    fi

	ValidIP=`cat ${SLAVE_IP_FILE}`

    for Item in $ValidIP; do
        diff $slave_version_file $G_TMP_FILE$Item > /dev/null
        if [ 0 -ne $? ];then
            isPass=$(check_pass $isPass 4)
        fi
    done

    if [ $cmpFlag -eq 1 ];then
        for Tmptype in {12..15};do
            filter="devicetype=$Tmptype"
            mastFlag=0
            mastIP=""
            mastefile=""
            for line in `cat $typelistfile | grep $filter` ;do
                LOG "[$FUNCNAME] rh compare line info[line=$line]."
                tmpIP=`echo $line | awk -F ";" '{print $2}' | awk -F "=" '{print $2}'`
                if [ $mastFlag -eq 0 ];then
                    mastefile=$G_TMP_FILE$tmpIP
                    mastIP=$tmpIP
                    mastFlag=1
                    LOG "master file=$mastefile"
                    continue
                fi
                diff $mastefile $G_TMP_FILE$tmpIP > /dev/null
                if [ 0 -ne $? ];then
                    isPass=$(check_pass $isPass 4)
                    LOG "[$FUNCNAME] Some hardware version is not same between $mastIP and $tmpIP."
                fi
            done
        done
    fi

    rm -rf /tmp/tmpcmmaster_versiontmp
    rm -rf /tmp/tmpcmmaster_version
    rm -rf $typelistfile


    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
 }

#120. Modmem״̬
checkModmemtatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local index=0

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            WRITE_XML_COMMON 0 "Node:--||INFO: can't get local ip"
            isPass=1
            break
        fi

        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm modemstat" |sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            WRITE_XML_COMMON 0 "Node:$back_ip||INFO:Failed to execute 'cm modemstat'."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #mml>>>NodeID:xxx
        NodeIDs=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep NodeID |awk '{print $1}'|sed 's/^.*NodeID://g'|tr -d " "`
        if [ "X${NodeIDs}" = "X" ];then
            index=$((index + 1))
            if [ $index -gt 10 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Get ModemStatus failed."
                break
            fi
            continue
        fi
        for nodeid in $NodeIDs
        do
            parentIP=`get_node_backnet_ip $nodeid`
            Result=$(grep -w $nodeid $G_REMOTE_TMP_FILE$FUNCNAME |grep -Po '(?<=ModemStatus:)[a-zA-Z]*' |tr -d ' ')
            if [ $? -eq 0 ]; then
                if [ "$Result" == "Running" ]; then
                    Status="Running"
                elif [ "$Result" == "NotRunning" ]; then
                    isPass=1
                    Status="NotRunning"
                elif [ "$Result" == "NotExisted" ]; then
                    Status="NotExisted"
                else
                    isPass=1
                    Status="Unknown"
                fi
            else
                isPass=1
                Status="Unknown"
            fi
            Result="Node:$parentIP||NodeID:$nodeid||Status:$Status"
            WRITE_XML_COMMON 0 "$Result"
        done
        break

    done

    if [ "$isPass" != "0" ];then
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#121. ڵʱͬ
checkNodeTime()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local Result=""
    local errResult=""
    local tmpMax=0
    local tmpMin=0
    local tmpdiff=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    index=0;
    for Item in $REMOTE_IP_S; do
    localTime=`date +%s`
        set_ifs
        remoteResult=`remote_exec $Item 30 "date +%s"`


            iRet=$?

        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] $Item Failed to execute(checkNodeTime) command.iRet($iRet)"
                isPass=1
            Result="NodeIp:$Item||INFO:Failed to execute to check node time command"
            WRITE_XML_ERROR 0 "$Result"
        else

            timeDelta=`expr $remoteResult - $localTime`
            if [ ${timeDelta} -gt 10 ];then
                isPass=1
            fi


            if [ ${timeDelta} -lt -10 ];then
                isPass=1
            fi
            #get the biggest diff
            if [ ${timeDelta} -gt ${tmpMax} ];then
                tmpMax=${timeDelta}
            fi
            #get the smallest diff
            if [ ${timeDelta} -lt ${tmpMin} ];then
                tmpMin=${timeDelta}
            fi
            Result="NodeIp:$Item||DiffTime(s):$timeDelta"
            WRITE_XML_COMMON 0 "$Result"
        fi
        restore_ifs

        done

    tmpdiff=`expr ${tmpMax} - ${tmpMin}`
    if [ ${tmpdiff} -gt 10 ];then
            isPass=1
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}
#122 syslog״̬
checkSysLog()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""

    ALLIp=`cat $IP_ROLE_FILE`

    for Item in $ALLIp; do
        info=`remote_exec $Item 30 "service syslog status | grep running | wc -l"`

        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="Node: $Item||INFO: Failed to execute syslog"
            WRITE_XML_ERROR 0 "$errResult"
            isPass=1
            continue
        fi

        if [ $info -ne 1 ]; then
            errResult="Node: $Item||INFO: service syslog is not running"
            WRITE_XML_ERROR 0 "$errResult"
            isPass=1
        else
            errResult="Node: $Item||INFO: service syslog is running"
            WRITE_XML_COMMON 0 "$errResult"
        fi

    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#126.⼶״̬
checkExpBoardStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=$(cat ${IP_ROLE_FILE})

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        remote_exec ${Item} 30 "cat /opt/huawei/deploy/etc/deploy.ini | grep devicename | grep \"9000 C72 Node\" >> /dev/null 2>&1"
        if [ $? -ne 0 ];then
            WRITE_XML_ERROR 0 "Node:$Item(Not C72 node)||INFO:No need to check."
            continue
        fi
        echo -n "$Item " >> ${VALID_IP_FILE}
    done

    REMOTE_IP_S=$(cat "${VALID_IP_FILE}")

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $TASK_ID 300 "$G_MML_FILE_PATH/ShowInspectMml $Item 4016 'cm hardwareinfo show' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1;sleep 3;ipmitool fru >> $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:Failed to execute command."
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get cm hardware information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            dos2unix $G_TMP_FILE$Item

            cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            #޼
            info=`cat $G_TMP_FILE$Item | grep "ExpBoard:no"`
            if [ "$info" != "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:There is no ExpBoard."
                restore_ifs
                continue
            fi

            #ȡưλ
            ControlBoardID=`cat $G_TMP_FILE$Item | grep "Board Slot ID" | awk '{print $5}'`
            #ȡӦϢ
            ExpBoardInfo=`cat $G_TMP_FILE$Item | grep -A2 "ExpBoard:" | grep "Board_ID: $ControlBoardID"`
            if [ "$ExpBoardInfo" == "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:There is no ExpBoard."
            else
                healthStatus=`echo $ExpBoardInfo | awk '{print $5}'`
                runningStatus=`echo $ExpBoardInfo | awk '{print $8}'`
                if [ "$healthStatus" = "1" ] && [ "$runningStatus" = "1" -o "$runningStatus" = "2" ]; then
                    WRITE_XML_COMMON 0 "Node:$Item(C72 node)||$ExpBoardInfo"
                else
                    isPass=1
                    ExpBoardErrorInfo="BoardID:${ControlBoardID}, healthStatus:${healthStatus}, runningStatus:${runningStatus}"
                    WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:${ExpBoardErrorInfo}"
                fi
            fi

            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#127.ⳬ״̬
checkCBUStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        remote_exec ${Item} 30 "cat /opt/huawei/deploy/etc/deploy.ini | grep devicename | grep \"9000 C72 Node\" >> /dev/null 2>&1"
        if [ $? -ne 0 ];then
            WRITE_XML_ERROR 0 "Node:$Item(Not C72 node)||INFO:No need to check."
            continue
        fi
        echo -n "$Item " >> ${VALID_IP_FILE}
    done

    REMOTE_IP_S=$(cat "${VALID_IP_FILE}")

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $TASK_ID 300 "$G_MML_FILE_PATH/ShowInspectMml $Item 4016 'cm hardwareinfo show' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1;sleep 3;ipmitool fru >> $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:Failed to execute command."
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get cm hardware information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            dos2unix $G_TMP_FILE$Item

            cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            #CBU
            info=`cat $G_TMP_FILE$Item | grep "CBU:no"`
            if [ "$info" != "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:There is no CBU."
                restore_ifs
                continue
            fi

            #CBUΪ2
            CBUCount=`cat $G_TMP_FILE$Item | grep "CBU:" | awk -F: '{print $2}'`
            if [ "$CBUCount" != "2" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:CBU number: $CBUCount"
                restore_ifs
                continue
            fi

            #жCBU״̬(뼶岻ͬCBUǹõ)
            info=`cat $G_TMP_FILE$Item | grep -A2 "CBU:" | grep -v "CBU:"`
            if [ "$info" == "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:Failed to get CBU info."
                restore_ifs
                continue
            fi
            for loop in 1 2
            do
                CBUInfo=`cat $G_TMP_FILE$Item | grep -A2 "CBU:" | grep -v "CBU:" | sed -n "${loop}p"`
                if [ "$CBUInfo" == "" ];then
                    isPass=1
                    WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:Failed to get CBU info."
                    break
                fi
                ID=$(echo "${CBUInfo}" | awk -F'\\|\\|' '{print $1}' | awk -F':' '{print $2}' | tr -d ' ')
                healthStatus=$(echo "${CBUInfo}" | awk -F'\\|\\|' '{print $2}' | awk -F':' '{print $2}' | tr -d ' ')
                runningStatus=$(echo "${CBUInfo}" | awk -F'\\|\\|' '{print $3}' | awk -F':' '{print $2}' | tr -d ' ')
                if [ "$healthStatus" = "1" ] \
                && [ "$runningStatus" = "1" -o "$runningStatus" = "2" -o "$runningStatus" = "27" ];then
                    WRITE_XML_COMMON 0 "Node:$Item(C72 node)||Board_id:${ID}||Health_Status:${healthStatus}||Running_Status:${runningStatus}"
                else
                    isPass=1
                    WRITE_XML_COMMON 0 "Node:$Item(C72 node)||Board_id:${ID}||Health_Status:${healthStatus}||Running_Status:${runningStatus}"
                fi
            done

            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#128FW汾
checkFwVersion()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""

    ALLIp=$(cat ${IP_ROLE_FILE})
    for Item in ${ALLIp}; do
        #ֻC72ڵ
        remote_exec ${Item} 30 "cat /opt/huawei/deploy/etc/deploy.ini | grep devicename | grep \"9000 C72 Node\" >> /dev/null 2>&1"
        if [ $? -ne 0 ];then
            WRITE_XML_COMMON 0 "Node:${Item}(Not C72 node)||INFO:No need to check."
            continue
        fi

        remote_exec ${Item} 30 "echo > /var/log/hdfw_precheck.flag"
        if [ $? -ne 0 ]; then
            errResult="Node: ${Item}(C72 node)||INFO: Failed to execute command(echo > /var/log/hdfw_precheck.flag)"
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
            continue
        fi

        remote_exec ${Item} 30 "/opt/huawei/snas/bin/snas_cm_cmd updfw 10303 0"
        if [ $? -ne 0 ]; then
            errResult="Node: ${Item}(C72 node)||INFO: Failed to execute command(/opt/huawei/snas/bin/snas_cm_cmd updfw 10303 0)"
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
            continue
        fi

        info=$(remote_exec ${Item} 30 "cat /var/log/hdfw_precheck.flag")
        if [ $? -ne 0 ]; then
            errResult="Node: ${Item}(C72 node)||INFO: Failed to execute command(cat /var/log/hdfw_precheck.flag)"
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
            continue
        fi

        if [ "${info}" == "matched" ];then
            WRITE_XML_COMMON 0 "Node:${Item}(C72 node)||INFO:${info}"
        elif [ "${info}" == "unmatched" ];then
            if [ "${isPass}" -ne 1 ];then
                isPass=4
            fi
            WRITE_XML_COMMON 0 "Node:${Item}(C72 node)||INFO:${info}"
        else
            isPass=1
            WRITE_XML_ERROR 0 "Node:${Item}(C72 node)||INFO:${info}"
        fi
    done

    WRITE_XML_JUDGE ${isPass}
    WRITE_XML_SUBCMD_TAIL
}

#129ӲFW汾
checkDiskFwVersion()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local errResult=""
    local isPass=0
    local ShowFlag=0
    local location=""
    local diskModel=""
    local diskFW=""
    local numDiskFW=0

    while true;do
        local back_ip=$(get_backnet_ip)
        if [ "${back_ip}" = "" ]; then
            errResult="INFO: Can't get local ip"
            LOG "[$FUNCNAME]:${errResult}"
            isPass=1
            break
        fi

        #ִmml cm diskinfo show
        ${G_MML_FILE_PATH}/ShowInspectMml ${back_ip} 4016 "cm diskinfo"  > ${G_REMOTE_TMP_FILE}${FUNCNAME} 2>&1
        if [ $? -ne 0 ]; then
            Info=$(cat ${G_REMOTE_TMP_FILE}${FUNCNAME})
            LOG "[${FUNCNAME}]${Info}"
            errResult="INFO: Failed to execute command(cm diskinfo)."
            isPass=1
            break
        fi

        lines=$(cat ${G_REMOTE_TMP_FILE}${FUNCNAME} | grep "Disk_ID" | sed 's/^ *//g' | sed "/^$/d" | tr -d "\r")
        if [ "${lines}" == "" ];then
            errResult="INFO:Can not get disk information."
            isPass=1
            LOG "[${FUNCNAME}]:${errResult}"
            cat ${G_REMOTE_TMP_FILE}${FUNCNAME} >> ${LOG_FILE} 2>&1
            break
        fi

        set_ifs
        for line in ${lines}; do
            ShowFlag=0
            if [ "${line}" = "" ];then
                continue
            fi
            ID=$(echo "${line}" | awk -F'\\|\\|' '{print $1}' | awk -F':' '{print $2}' | tr -d ' ')
            location=$(echo "${line}" | awk -F'\\|\\|' '{print $3}' | awk -F':' '{print $2}' | tr -d ' ')
            diskModel=$(echo "${line}" | awk -F'\\|\\|' '{print $10}' | awk -F':' '{print $2}' | tr -d ' ')
            diskFW=$(echo "${line}" | awk -F'\\|\\|' '{print $11}' | awk -F':' '{print $2}' | tr -d ' ')
            diskNeedUpg=$(echo ${line} | awk -F'\\|\\|' '{print $16}' | awk -F':' '{print $2}' | tr -d ' ')
            diskUpgStrategy=$(echo ${line} | awk -F'\\|\\|' '{print $17}' | awk -F':' '{print $2}' | tr -d ' ')

            Running_Status=$(echo ${line} | awk -F'\\|\\|' '{print $5}' | awk -F':' '{print $2}' | tr -d ' ')
            if [ "4" = "${Running_Status}" ]; then
                continue
            fi

            #Disk that Models are ST1200MM0129,ST1800MM0129,ST2400MM0129 and FWversions are C001,C0B1,C003 need upgrade
            if [ "${diskModel}" = "ST1200MM0129" -o "${diskModel}" = "ST1800MM0129" -o "${diskModel}" = "ST2400MM0129" ]; then
                if [ "${diskFW}" = "C001" -o "${diskFW}" = "C0B1" -o "${diskFW}" = "C003" ]; then
                    diskNeedUpg="YES"
                    diskUpgStrategy="BLACK"
                    Result="INFO:ID(${ID}) DiskModel(${diskModel}) FWVersion(${diskFW}) is {C001/C0B1/C003}! It's in BLACK so need to upgrade."
                    isPass=1
                    WRITE_XML_ERROR 0 "${Result}"
                    continue
                fi
            fi
            #Disk that Models are LT1800RO,LT0900RO and FWversions less equal than H506 need replace
            if [ "${diskModel}" = "LT1800RO" -o "${diskModel}" = "LT0900RO" ]; then
                numDiskFW=$(echo "${diskFW}" | sed 's/[^0-9]//g')
                #̵ǰеıH50A\H50B\H507\H506H503  H503H506з
                if [ "${numDiskFW:-0}" = "506" ] || [ "${numDiskFW:-0}" = "503" ]; then 
                    diskNeedUpg="YES"
                    diskUpgStrategy="BLACK"
                    Result="INFO:ID(${ID}) DiskModel(${diskModel}) FWVersion(${diskFW}) is less equal than H506! It's in BLACK so need to replace."
                    isPass=1
                    WRITE_XML_ERROR 0 "${Result}"
                    continue
                fi
            fi
            #Disk that Models start with HSSD-D6,HWE5 and none zero slot and FWversions less than 3246 need replace
            if [[ "${diskModel}" =~ ^HSSD-D6 || "${diskModel}" =~ ^HWE5 ]]; then
                numDiskFW=$(echo "${diskFW}" | sed 's/[^0-9]//g')
                if [[ "${location}" != "00" ]] && [ ${numDiskFW:-0} -lt 3246 ]]; then
                    diskNeedUpg="YES"
                    diskUpgStrategy="BLACK"
                    Result="INFO:ID(${ID}) DiskModel(${diskModel}) FWVersion(${diskFW}) is less than 3246! It's in BLACK so need to replace."
                    isPass=1
                    WRITE_XML_ERROR 0 "${Result}"
                    continue
                fi
            fi
            #Disk that Models start with HSSD-D7,HWE6 and FWversions less than 6222 need replace
            if [[ "${diskModel}" =~ ^HSSD-D7 || "${diskModel}" =~ ^HWE6 ]]; then
                numDiskFW=$(echo "${diskFW}" | sed 's/[^0-9]//g')
                if [ ${numDiskFW:-0} -lt 6222 ]; then
                    diskNeedUpg="YES"
                    diskUpgStrategy="BLACK"
                    Result="INFO:ID(${ID}) DiskModel(${diskModel}) FWVersion(${diskFW}) is less than 6222! It's in BLACK so need to replace."
                    isPass=1
                    WRITE_XML_ERROR 0 "${Result}"
                    continue
                fi
            fi

            if [ "$diskNeedUpg" = "--" ] && [ "$diskUpgStrategy" = "--" ];then
                continue;
            fi

            Result="ID:${ID}||DiskNeedUpg:${diskNeedUpg}||DiskUpgStrategy:${diskUpgStrategy}||DiskModel:${diskModel}||FWVersion:${diskFW}"

            if [ "${diskUpgStrategy}" != "BLACK" -a "${diskUpgStrategy}" != "RED" ];then
                WRITE_XML_COMMON 0 "${Result}"
                continue
            fi

            if [ "${diskUpgStrategy}" == "BLACK" -a "${diskNeedUpg}" == "YES" ];then
                if [ "${isPass}" -ne 1 ];then
                    isPass=4
                fi
                ShowFlag=1
            fi

            if [ "${diskUpgStrategy}" == "RED" -a "${diskNeedUpg}" == "YES" ];then
                if [ "${isPass}" -ne 1 ];then
                    isPass=4
                fi
                ShowFlag=1
            fi

            if [ "${ShowFlag}" == "1" ];then
                WRITE_XML_ERROR 0 "INFO:ID(${ID}) DiskModel(${diskModel}) FWVersion(${diskFW}) is in ${diskUpgStrategy}.Disk need to upgrade!"
            else
                WRITE_XML_COMMON 0 "${Result}"
            fi
        done
        break
        restore_ifs
    done
    if [ "${errResult}" != "" ]; then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE ${isPass}
    WRITE_XML_SUBCMD_TAIL
}

#130PHY
checkDiskPhy()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local nodetype=0
    local hssd=0
    local old=0
    local declare -a arrphy

    REMOTE_IP_S=$(cat $IP_ROLE_FILE)

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
            remote_exec_async $Item $TASK_ID 30 "/opt/huawei/snas/script/inspect_mml/CheckPhyInfo"    #inspect_phy.shִ¼/tmp/checkNodeDiskPhy
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command(/opt/product/snas/script/inspect_mml/CheckPhyInfo). Error(${iRet})."
                isPass=1
            else
                echo "$Item " >> ${VALID_IP_FILE}
            fi
    done

    #ڴsleepΪ˱֤нڵִгɹһֵ⣨Щܿ򻷾ɸýűִжϣѲʧܣ˴sleepɾ
    sleep 30

    ValidIP=$(cat ${VALID_IP_FILE})
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in ${ValidIP}; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get CheckPhyInfo information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item /tmp/tmpfilecheckNodeDiskPhy
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(/tmp/tmpfilecheckNodeDiskPhy). Error(${iRet})."
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE})
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item)
            if [ "$fifoContext" = "" ];then
                LOG "[$FUNCNAME]:IP:$Item,file is empty!"
                continue
            fi

            dos2unix $G_TMP_FILE$Item

            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            nodetype=$(cat $G_TMP_FILE$Item |grep "devicetype" | awk -F= '{print $2}')
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "[$FUNCNAME]: can't get node type."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Can't get node type.(cat /opt/product/deploy/etc/deploy.ini | grep devicetype)"
                continue
            fi

            local type=$(MapNodeType  $nodetype)
            if [ "${nodetype}" -eq 4 ]; then
                LOG "[$FUNCNAME]: this node is C72."
                WRITE_XML_COMMON 0 "Node:$Item||NodeType:C72||HSSD-D322XAM:--||chip_181101:--||phy28_status:--||phy29_status:--||phy30_status:--||phy31_status:--||phy32_status:--||phy33_status:--||phy34_status:--||phy35_status:--"
                continue
            elif [ $nodetype -eq 12 ] || [ $nodetype -eq 13 ] || [ $nodetype -eq 14 ] || [ $nodetype -eq 15 ] || [ $nodetype -eq 17 ];then
                WRITE_XML_COMMON 0 "Node:$Item||NodeType:RH(${type})||HSSD-D322XAM:--||chip_181101:--||phy28_status:--||phy29_status:--||phy30_status:--||phy31_status:--||phy32_status:--||phy33_status:--||phy34_status:--||phy35_status:--"
                continue
            fi
            sgnum=$(cat $G_TMP_FILE$Item |grep "sginfo" |awk -F= '{print $2}')
            if [ "$sgnum" -eq 1 ];then
                isPass=1
                LOG "[$FUNCNAME]: can't get phy info in this node."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Can't get phy information in this node.(lsscsi -g |grep enclosu)"
                continue
            fi

            arrphy[28]=$(cat $G_TMP_FILE$Item |grep phy28 |awk -F= '{print $2}')
            arrphy[29]=$(cat $G_TMP_FILE$Item |grep phy29 |awk -F= '{print $2}')
            arrphy[30]=$(cat $G_TMP_FILE$Item |grep phy30 |awk -F= '{print $2}')
            arrphy[31]=$(cat $G_TMP_FILE$Item |grep phy31 |awk -F= '{print $2}')
            arrphy[32]=$(cat $G_TMP_FILE$Item |grep phy32 |awk -F= '{print $2}')
            arrphy[33]=$(cat $G_TMP_FILE$Item |grep phy33 |awk -F= '{print $2}')
            arrphy[34]=$(cat $G_TMP_FILE$Item |grep phy34 |awk -F= '{print $2}')
            arrphy[35]=$(cat $G_TMP_FILE$Item |grep phy35 |awk -F= '{print $2}')

            local chip_181101=""
            local HSSD_D322XAM=""
            local hssd=$(cat $G_TMP_FILE$Item |grep "havehssd" |awk -F= '{print $2}')
            if [ "$hssd" -eq 1 ];then
                local old=$(cat $G_TMP_FILE$Item |grep "haveold" |awk -F= '{print $2}')
                if [ "$old" -eq 1 ];then
                    chip_181101="No"
                else
                    chip_181101="Yes"
                fi
                HSSD_D322XAM="Yes"
            else
                HSSD_D322XAM="NO"
                chip_181101="--"
            fi

            Result="Node:$Item||NodeType:T3000||HSSD-D322XAM:${HSSD_D322XAM}||chip_181101:${chip_181101}||phy28_status:${arrphy[28]}||phy29_status:${arrphy[29]}||phy30_status:${arrphy[30]}||phy31_status:${arrphy[31]}||phy32_status:${arrphy[32]}||phy33_status:${arrphy[33]}||phy34_status:${arrphy[34]}||phy35_status:${arrphy[35]}"
            WRITE_XML_COMMON 0 "$Result"
            inspectres=$(cat $G_TMP_FILE$Item |grep "inspecttype" |awk -F= '{print $2}')
            if [ "$inspectres" -eq 1 ]; then
                isPass=4
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Node PHY status is abnormal."
            fi
    done
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#131Ӳ
checkDisk()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        errResult="INFO: Can't get local ip"
        LOG "[$FUNCNAME]:$errResult"
        isPass=1

        WRITE_XML_ERROR 0 "Node:$back_ip||ERROR:Failed to get back_ip."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm diskinfo" | sed 's/||/,/g' | awk -F ',' '
    function printDiskType(type)
    {
        diskTypeName[0] = "FC"
        diskTypeName[1] = "SAS"
        diskTypeName[2] = "SATA"
        diskTypeName[3] = "SSD"
        diskTypeName[4] = "NL_SAS"
        diskTypeName[5] = "SLC_SSD"
        diskTypeName[6] = "MLC_SSD"
        diskTypeName[15] = "SMR_SATA"
        diskTypeName[16] = "NVME_SSD"
        diskTypeName[17] = "SATA_SSD"
        if (type>=0&&type<=17)
            printf("diskType=%s ", diskTypeName[type])
        else
            printf("diskType=%d ", type)
    }
    function printOneDiskResult()  #ӡһڵĽ
    {
        if (nodeID == -1 )
            return
        printf("nodeID=%d ",nodeID)
        printf("slotID=%s ",slotid)
        printDiskType(type)
        printf("diskSize=%d ",size)
        printf("diskFactory=%s ",facture)
        printf("\n")
    }
    function printOneNodeResult()  #ӡһڵĽ
    {
        if (nodeID == -1 )
	    return
        printf("BLAG ")
	printf("nodeID=%d ",nodeID)
	printf("diskTypePass=%d ",length(diskType))
	printf("diskSizePass=%d ",length(diskSize))
	printf("diskManuFactoryPass=%d ",length(manuFacture))
	printf("\n")
    }
    function addVal2Array(val, arr)
    {
        for(i in arr)
	{
	    if (arr[i] == val)
	        return
	}
	printf("")
	arr[length(arr)] = val
    }
    BEGIN{nodeID=-1; slotid=""; type=-1; size=-1; facture=""; diskType[0]=-1; diskSize[0]=-1;manuFacture[0]="";}
    {
        do
	{
	    if (!match($1, "Disk_ID:"))
                break;
	    split($2, val, ":")   #parent_ID: xx
	    nid = int(val[2])
	    split($5, val, ":")   #Running_Status: x
	    run = int(val[2])
	    if (nid != nodeID)    #ʼһ½ڵ
	    {
	        if (nodeID!=-1)
		    printOneNodeResult();   #ӡһڵĽ
		nodeID = nid
		delete diskType   #
		delete diskSize
		delete manuFacture
	    }
	    if (run == 4 || run == 0) #״̬Ϊںunknown
	        break;

	    split($6, val, ":")
	    type = int(val[2])
            split($3, val, ":")
            slotid=val[2]
	    split($14, val, ":")
	    size = int(val[2])
            size = int(size/1024/1024/1024)
	    split($12, val, ":")
	    facture=val[2]
	    if (type == 3) #SSD
	        break;
	    #SSDжͺʹСǷڣ
	    addVal2Array(type, diskType)
	    addVal2Array(size, diskSize)
	    addVal2Array(facture, manuFacture)
            printOneDiskResult()
	    } while(0)
    }
    END{
            printOneNodeResult()
        }' >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1


    dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
    set_ifs
    col=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "BLAG" |wc -l)
    if [ $col -eq 0 ]; then
        isPass=1
        WRITE_XML_ERROR 0 "Node:$Item||ERROR:Failed to execute command."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    for ((i=1; i<=${col}; i++ ))
    do
        nid=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "BLAG" | awk "NR==$i" | awk -F= '{print $2}' |awk '{print $1}')
        disktype=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "BLAG" | awk "NR==$i" | awk -F= '{print $3}' |awk '{print $1}')
        disksize=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "BLAG" | awk "NR==$i" | awk -F= '{print $4}' |awk '{print $1}')
        if [ "$disktype" -gt 1 ] || [ "$disksize" -gt 1 ]; then
            isPass=4
        fi
    done

    cat $G_REMOTE_TMP_FILE$FUNCNAME |grep -v "BLAG" |while read line
    do
        nid=$(echo $line |grep "nodeID" | awk -F= '{print $2}' |awk '{print $1}' )
        slotid=$(echo $line |grep "nodeID" | awk -F= '{print $3}' |awk '{print $1}' )
        type=$(echo $line |grep "nodeID"| awk -F= '{print $4}' |awk '{print $1}')
        size=$(echo $line |grep "nodeID" | awk -F= '{print $5}' |awk '{print $1}' )
        factory=$(echo $line |grep "nodeID" | awk -F= '{print $6}' |awk '{print $1}')
        Result="NodeID:$nid||SlotID:$slotid||DiskType:$type||DiskSize:$size(GB)||ManuFactory:$factory"
        WRITE_XML_COMMON 0 "$Result"
    done

    restore_ifs

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#133 check physical memory
function checkPhysicalMemory()
{
    WRITE_XML_SUBCMD_HEADER $1

    local iRet=""
    local TASK_ID=0
    local isPass=0
    local UVPFlag=""
    local Result=""
    local ProductType=""
    local isC72=0
    local lessSpeedList=""
    local nodepoolinfo="/tmp/tmpfilenodepoolinfo"
    local ddr3list="0 1 3 5 6 7 8"             #P(0) C(1) M(3) P25(5) P36(6) C36(7) P12(8)  1333(MHZ)DDR3

    ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep "^productType" |awk -F= '{print $2}' | awk '{print $1}')
    REMOTE_IP_S=$( cat $IP_ROLE_FILE)

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $TASK_ID 120 "/opt/huawei/snas/script/inspect_mml/CheckPhysicalMemoryInfo"     #޸·ļ
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||INFO: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command.return(${iRet}).ERRCODE(1)"
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=$(cat ${VALID_IP_FILE})
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            sleep 1
            remote_exec_checkfini $Item $TASK_ID "Can not get physical memory information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item /tmp/tmpfilecheckPhyMemory
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                echo "FlagDownfail" >> $G_TMP_FILE$Item 2>&1
                continue
            fi
        done
        ValidIP=$(cat ${VALID_IP_FILE})
    done

    wait
    fifo_finish
    > ${nodepoolinfo}
    for Item in $ValidIPResult; do
        local stdSpeed=0
        local stdNvSize=0
        lessSpeedList=""

        FlagDownfail=$(cat $G_TMP_FILE$Item |grep FlagDownfail)
        if [ "$FlagDownfail" != "" ];then
            LOG "[$FUNCNAME]:IP:$Item,Down file fail"
            continue
        fi

        UVPFlag=$(cat $G_TMP_FILE$Item |grep "UVPFlag=1")
        if [ "${UVPFlag}X" != "X" ];then
            WRITE_XML_COMMON 0 "Node:$Item||INFO:Does not involve"
            continue
        fi

        nodetype=$(cat $G_TMP_FILE$Item |grep "^devicetype=" |awk -F= '{print $2}')
        isRH=$(cat $G_TMP_FILE$Item |grep "^isRH=" |awk -F= '{print $2}')
        isC72=$(cat $G_TMP_FILE$Item |grep "^isC72=" |awk -F= '{print $2}')
        SMRFlag=$(cat ${G_TMP_FILE}${Item} |grep "^SMRFlag=" |awk -F= '{print $2}')
        memtpye=$(cat $G_TMP_FILE$Item |grep "^memsizenum=" |awk -F= '{print $2}')
        memsize=$(cat $G_TMP_FILE$Item |grep "^totalmem=" |awk -F= '{print $2}')
        nodepool=$(cat $G_TMP_FILE$Item |grep "^nodepool=" |awk -F= '{print $2}')
        nvsize=$(cat $G_TMP_FILE$Item |grep "^nvmem=" |awk -F= '{print $2}')

        echo "${Item},${nodepool},${memsize}" >> ${nodepoolinfo}

        if [ "${isRH}" = "V3RH" ];then
            stdSpeed=2133
            stdNvSize=8192
        elif [ "${isRH}" = "V5RH" ];then
            stdSpeed=2400
            stdNvSize=16384
        else
            stdNvSize=2048
            stdSpeed=1600
            echo "${ddr3list}" | grep -w "${nodetype}" >/dev/null
            if [ $? -eq 0 ];then
                stdSpeed=1333
            fi
        fi

        #set_ifs
        dos2unix $G_TMP_FILE$Item
        while read line; do
            local size=$(echo $line |grep "Size:" |awk '{print $2}')
            local slot=$(echo $line |grep "Locator:" | awk -F":" '{print $2}' | sed 's/Slot//g' | awk '{print $1}')
            local speed=$(echo $line |grep "Speed:" |awk '{print $2}')
            Result="${Result} $size $slot"
            if [ "${speed}X" != "X" ]; then
                size=$(echo $Result |awk '{print $1}')
                slot=$(echo $Result |awk '{print $2}')
                if [ "$size" == "No" -o "${slot}" == ""  ];then
                    Result=""
                    continue
                fi

                if [ "$slot" = "F0" ] || [ "$slot" = "DIMM000" -a $isC72 != 1 ]; then
                    LOG "[$FUNCNAME]:IP:$Item,nvdimm ${size}(MB)."
                else
                    if [  ${speed} -lt ${stdSpeed}  ]; then
                        lessSpeedList="$lessSpeedList $slot"
                    fi
                fi
                WRITE_XML_COMMON 0 "Node:$Item||Locator:$slot||size:$size(MB)||Speed:$speed(MHZ)"
                Result=""
            fi
        done < $G_TMP_FILE$Item
        #restore_ifs

        if [ "${lessSpeedList}" != "" ];then
            WRITE_XML_ERROR 0 "Node:$Item||INFO:The physical memory frequency of slots(${lessSpeedList}) is lower than ${stdSpeed}(MHZ)."
            isPass=1
        fi

        if [ "$memtpye" -ne 1 ] ; then        #ͨ
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Node physical memory sizes are different."
            isPass=1
        fi

        if [ $isC72 != 1 -a ${nvsize} -lt ${stdNvSize} ]; then
            WRITE_XML_ERROR 0 "Node:$Item||INFO: nvdimm ${nvsize}(MB) less than ${stdNvSize}(MB)"
            isPass=1
        fi

        if [ $ProductType -eq 80 ];then
            declare -a memArr=(["0"]=49152  ["1"]=49152  ["2"]=32768  ["3"]=32768  ["4"]=32768 ["5"]=49152 ["6"]=49152 ["7"]=32768
                   ["8"]=32768 ["12"]=32768 ["13"]=49152 ["14"]=81920 ["15"]=32768)
        elif [ "${SMRFlag}" = "1" ];then
            ##9000 RHSMR
            declare -a memArr=(["0"]=49152   ["1"]=49152   ["2"]=32768   ["3"]=32768   ["4"]=32768   ["5"]=49152   ["6"]=49152   ["7"]=32768   ["8"]=32768
                ["12"]=32768   ["13"]=49152  ["14"]=49152  ["15"]=32768  ["16"]=49152  ["17"]=49152  ["21"]=32768  ["22"]=98304  ["23"]=81920  ["24"]=98304
                ["25"]=81920   ["26"]=81920  ["27"]=65536  ["28"]=98304  ["29"]=81920  ["31"]=114688 ["32"]=49152  ["33"]=114688 ["34"]=98304  ["35"]=98304
                ["36"]=81920   ["37"]=114688 ["38"]=98304  ["39"]=147456 ["40"]=65536  ["41"]=131072 ["42"]=147456 ["43"]=147456 ["44"]=131072 ["46"]=81920
                ["47"]=81920   ["48"]=81920)
        elif [ "${SMRFlag}" = "0" ];then
            ##9000 RHûSMR
            declare -a memArr=(["0"]=49152   ["1"]=49152   ["2"]=32768   ["3"]=32768   ["4"]=32768   ["5"]=49152   ["6"]=49152   ["7"]=32768   ["8"]=32768
                ["12"]=32768   ["13"]=49152  ["14"]=49152  ["15"]=32768  ["16"]=49152  ["17"]=49152  ["21"]=32768  ["22"]=98304  ["23"]=49152  ["24"]=49152
                ["25"]=32768   ["26"]=32768  ["27"]=65536  ["28"]=98304  ["29"]=81920  ["31"]=114688 ["32"]=49152  ["33"]=114688 ["34"]=65536  ["35"]=49152
                ["36"]=81920   ["37"]=114688 ["38"]=98304  ["39"]=147456 ["40"]=65536  ["41"]=131072 ["42"]=147456 ["43"]=147456 ["44"]=98304  ["46"]=49152
                ["47"]=32768   ["48"]=32768)
        else
            declare -a memArr=(["0"]=49152  ["1"]=49152  ["2"]=32768  ["3"]=32768 ["4"]=32768 ["5"]=49152 ["6"]=49152 ["7"]=32768
                   ["8"]=32768 ["12"]=32768 ["13"]=49152 ["14"]=49152 ["15"]=32768)
        fi

        if [ "${memArr[$nodetype]}" != "" ];then
            if [ "$memsize" -lt "${memArr[$nodetype]}" ]; then
                NodeType=$(MapNodeType "$nodetype")
                if [ "${SMRFlag}" == "1" ];then
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:${NodeType} including SMR disks, with a total capacity of ${memsize}(MB) of physical memory less than ${memArr[$nodetype]}(MB)."
                else
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:${NodeType} do not include SMR disks, and the total capacity of physical memory ${memsize}(MB) is less than ${memArr[$nodetype]}(MB)."
                fi
                isPass=1
            fi
        fi

    done

    arAllPool=$(cat $nodepoolinfo | tr -d ' ' | awk -F',' '{print $2}' | sort | uniq)
    for pool in $arAllPool; do
        memnum=$(cat $nodepoolinfo | tr -d ' '| grep "${pool}," | awk -F',' '{print $3}' | sort | uniq | wc -l)
        if [ $memnum -ne 1 ];then
            isPass=$(check_pass $isPass 1)
            memSize=$(cat $nodepoolinfo | tr -d ' '| grep "${pool}," | awk -F',' '{print $3}' | sort | uniq)
            for size in $memSize; do
                iplist=$(cat $nodepoolinfo | tr -d ' ' | grep "${pool},${size}" | awk -F',' '{print $1}' |sed ':jix;N;s/\n/,/g;b jix')
                if [ ${#iplist} -gt 50 ];then
                    iplist="${iplist:0:50}......"
                fi
                WRITE_XML_ERROR 0  "Node:--||INFO:There are $memnum memory sizes in nodepool($pool), and the $size (MB) IP address is ($iplist)."
            done
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#134ڵNCQ
checkNodeNCQ()
{
    local iRet=0
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=$(cat $IP_ROLE_FILE)

    #ڵִмű
    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $TASK_ID 30 "/opt/huawei/snas/script/inspect_mml/CheckNCQStatus"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command.(/opt/product/snas/script/inspect_mml/CheckNCQStatus),Error($iRet)"
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    #ڴsleepΪ˱֤нڵִгɹһֵ⣨ڵ㣬ǰڵûִгɹִгɹforѭһζip⣩Ч
    sleep 30
    ValidIP=$( cat ${VALID_IP_FILE})
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        local hava_sata=""
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            sleep 1
            remote_exec_checkfini $Item $TASK_ID "Can not get NCQ status information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "checkini failed"
                isPass=1
                continue
            fi

            #ڵ
            remote_download $Item $G_TMP_FILE$Item /tmp/tmpfileCheckNCQStatus
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command.(/tmp/tmpfileCheckNCQStatus),Error($iRet)"
                continue
            fi
        done
        ValidIP=$(cat $VALID_IP_FILE)
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=$(cat $G_TMP_FILE$Item)
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            dos2unix $G_TMP_FILE$Item
            cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            #Ƿڵ͡Ƿsata̡ncq״̬
            local nodeType=$(grep -Po '(?<=Node_Type: )[0-9]+' $G_TMP_FILE$Item | tr -d ' ')

            local type=$(MapNodeType  $nodeType)
            #C36E-H(16)ڵ
            if [ $nodeType -eq 12 ] || [ $nodeType -eq 13 ] || [ $nodeType -eq 14 ] || [ $nodeType -eq 15 ] || [ $nodeType -eq 16 ] || [ $nodeType -eq 17 ];then
                WRITE_XML_COMMON 0 "Node:$Item||NodeType:RH(${type})||Have_SATA:--||NCQStatus:--"
                continue
            elif [ $nodeType -eq 4 ];then
                WRITE_XML_COMMON 0 "Node:$Item||NodeType:C72||Have_SATA:--||NCQStatus:--"
                continue
            fi
            hSata=$(grep -Po '(?<=Hava_Sata: )[0-9]+' $G_TMP_FILE$Item | tr -d ' ')
            if [ $hSata -eq 1 ];then
                hava_sata="yes"
            else
                hava_sata="no"
            fi
            NCQStatus=$(grep -Po '(?<=SATA Native Command Queuing:    )[a-zA-Z]+' $G_TMP_FILE$Item | tr -d ' ')
            #p25/pڵ
            if [ $nodeType -eq 5 -o $nodeType -eq 0 ];then
                if [ $hSata -ne 1 ];then
                    WRITE_XML_COMMON 0 "Node:$Item||NodeType:$type||Have_SATA:$hava_sata||NCQStatus:--"
                    continue
                fi
            fi

            if [ "${NCQStatus}" != "Disabled" -a "${NCQStatus}" != "Enabled" ];then
                WRITE_XML_ERROR 0 "Node:$Item||INFO: Can not get NCQ status information.(/opt/driver/lsisas-driver/lsiutil 1 68)"
                isPass=$(check_pass $isPass 1)
                LOG "[$FUNCNAME][$LINENO] get NCQ status information failed."
                continue
            fi

            if [ "${NCQStatus}" == "Disabled" ];then
                NCQStatus="Close"
                isPass=$(check_pass $isPass 4)
                WRITE_XML_ERROR 0 "Node:$Item||INFO: NCQ status is close."
            elif [ "${NCQStatus}" == "Enabled" ];then
                NCQStatus="Open"
            fi

            WRITE_XML_COMMON 0 "Node:$Item||NodeType:$type||Have_SATA:$hava_sata||NCQStatus:${NCQStatus}"
            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#140 VM״̬״̬߷ʽ˳
checkVmstatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local arpinfo=""
    local Result=""
    local NomalIsPass=0
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #ںϳû
    local productVersion=$(grep ProductVersion /opt/huawei/deploy/package/version |awk -F= '{print $2}')
    if [[ "$productVersion" =~ "V100R006C30SPC" ]] || [[ "$productVersion" =~ "V100R006C10SPC" ]];then
        WRITE_XML_COMMON 0 "VM not Exist "
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    remote_exec_async_batch_mml $TASK_ID 30 ShowVmmsInfo $FUNCNAME
    isPass=$?
    sleep 30
    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get ShowVmmsInfo information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue

            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item

            #
            javaId=""

            javaId=`cat $G_TMP_FILE$Item |grep "VmId"|sed 's/^ *//g'|sed "/^$/d"`
            if [ "$javaId" = "" ];then
                errResult="Node:-||INFO:Can not get information."
                isPass=1
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                break
            fi


            set_ifs
            for line in $javaId; do

                if [ $line = "" ];then
                        LOG "this line is empty"
                    continue
                fi

                #жϵһַǲǡVmIdstart/time:08:13:35.277086 | clock:58435.277136Health_Status: 14087.1 || Fan_Name:
                FirstString=`echo $line | awk '{print $1}'`
                if [ "$FirstString" != "VmId:" ]; then
                   new_line=`echo $line | awk -F"VmId" '{print $2}'`
                   line=$new_line
                fi

                VmId=`echo $line |awk '{print $2}'`
                VmName=`echo $line |awk '{print $5}'`
                Health_Status=`echo $line |awk '{print $8}'`
                Running_Status=`echo $line |awk '{print $11}'`
                Bus_Mode=`echo $line |awk '{print $14}'`
                Start_Mode=`echo $line |awk '{print $17}'`
                Exsit_Status=`echo $line |awk '{print $20}'`
                if [ "$Exsit_Status" != "1" ]; then
                  LOG "[$FUNCNAME]:vm not Exsit"
                  isPassSign=3;
                  break
                else

                #ͨĵж״̬״̬
                HealthStatus=`MapHealthStatus $Health_Status`
                RunningStatus=`MapRunningStatus $Running_Status`
                BusMode=`BusModeStatus $Bus_Mode`
                StartMode=`StatModeStatus $Start_Mode`
                Result="IP:$Item||VmID:$VmId||VmName:$VmName||HealthStatus:$HealthStatus||RunningStatus:$RunningStatus||BusMode:$BusMode||StartMode:$StartMode"


                if [ "$RunningStatus" != "RUNNING" ] || [ "$HealthStatus" != "NORMAL" ] || [ "$BusMode" != "VIRTIO" ] || [ "$StartMode" != "HD" ];then
                    if [ "$RunningStatus" != "RUNNING" ]; then
                    LOG "[$FUNCNAME] ${VmId} RunningStatus(${RunningStatus}) not RUNNING!"
                    fi
                    if [ "$HealthStatus" != "NORMAL1" ];then
                    LOG "[$FUNCNAME] ${VmId} HealthStatus{$HealthStatus} not NORMAL!"
                    fi
                    if [ "$BusMode" != "VIRTIO" ];then
                       LOG "[$FUNCNAME] ${VmId} BusMode(${BusMode}) not Virtio!"
                    fi
                    if [ "$StartMode" != "HD" ];then
                    LOG "[$FUNCNAME] ${VmId}StartMode(${StartMode}) not HD!"
                    fi
                 isPasstemp=1
                 WRITE_XML_ERROR 0 "$Result"
                 else
                 NomalIsPass=1
                  WRITE_XML_ERROR 0 "$Result"
                fi

                restore_ifs

                fi
            done
    done

    if [ "$isPasstemp" == "1" ];then
        isPass=1
    elif [ "$isPassSign" == "3" ] && [ "$NomalIsPass" == "1" ];then
        isPass=0
    elif [ "$NomalIsPass" == "1" ];then
        isPass=0
    else
        isPass=0
        WRITE_XML_ERROR 3 "VM not Exist "
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}



#136. 豸ڵǷʱԴ쳣
checkClockSourceRisk()
{
    #201308֮ǰ豸tscʱԴ쳣
    #ipmitool fruѯBoard Serial910λֱΪꡢ

    WRITE_XML_SUBCMD_HEADER $1
    local Result=""

    local TASK_ID=0
    local isPass=0
    local devtype=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE)

    remote_exec_async_batch $TASK_ID 300 "ipmitool fru > $G_REMOTE_TMP_FILE$FUNCNAME;cat /opt/huawei/deploy/etc/deploy.ini | grep devicetype >> $G_REMOTE_TMP_FILE$FUNCNAME;clocksource=\$(cat /sys/devices/system/clocksource/clocksource0/current_clocksource );echo clocksource=\$clocksource >> $G_REMOTE_TMP_FILE$FUNCNAME"
    isPass=$?
    ValidIP=$( cat ${VALID_IP_FILE})
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get ipmitool fru information"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE})
    done

    wait
    fifo_finish

    local stdTmpClk="tsc"

    for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item)
            if [ "$fifoContext" = "" ];then
                continue
            fi
            local tempCurClkSrc=$(cat $G_TMP_FILE$Item |grep clocksource |awk -F= '{print $2}')
            LOG "[$LINENO]CurrentClockSource:$tempCurClkSrc"
            if [ "${tempCurClkSrc}" != "${stdTmpClk}" ];then 
                isPass=$(check_pass $isPass 1)
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Current clock source is not tsc."
            fi
            devtype=$(cat $G_TMP_FILE$Item |grep devicetype |awk -F= '{print $2}')
            LOG "[$FUNCNAME]:devtype:$devtype"
            #ֻT3000ڵͣڵ
            if [ $devtype -eq 12 ] || [ $devtype -eq 13 ] || [ $devtype -eq 14 ] || [ $devtype -eq 15 ] || [ $devtype -eq 17 ];then
                WRITE_XML_COMMON 0 "Node:$Item||CurrentClockSource:$tempCurClkSrc||ProductionDate:--"
                continue
            elif [ $devtype -eq 4 ];then
                WRITE_XML_COMMON 0 "Node:$Item||CurrentClockSource:$tempCurClkSrc||ProductionDate:--"
                continue
            fi
            #豸
            local TempBoardSerial=$( cat $G_TMP_FILE$Item |grep "Board Serial" |awk '{print $4}')
            #豸н
            local TempProductYear=$( echo ${TempBoardSerial:8:1})
            local TempProductMonth=$( echo ${TempBoardSerial:9:1})

            if [ -z "$TempProductYear" ] || [ -z "$TempProductMonth" ] ; then
                WRITE_XML_COMMON 0 "Node:$Item||CurrentClockSource:$tempCurClkSrc||ProductionDate:--" 
                continue
            fi

            #ֻ201308֮ǰ豸ʾѲ챨
            if [ "$TempProductYear" \< "D" ] ; then
                WRITE_XML_ERROR 0 "Node:$Item||INFO:The ProduceDate of board is less than 2013-08!"
                isPass=$(check_pass $isPass 4)
            elif [ "$TempProductYear" = "D" ] && [ "$TempProductMonth" \< "8" ] ; then
                WRITE_XML_ERROR 0 "Node:$Item||INFO:The ProduceDate of board is less than 2013-08!"
                isPass=$(check_pass $isPass 4)
            fi
            WRITE_XML_COMMON 0 "Node:$Item||CurrentClockSource:$tempCurClkSrc||ProductionDate:${TempProductYear}/${TempProductMonth}"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#137 diskpoolʹǷ
checkDiskPoolUsage()
{
    local totalCap=0
    local freeCap=0
    local Result=""
    local MaxOnePercentage=0
    local MinOnePercentage=0
    local diskPoolAll=""
    local iRet=0

    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local diskpool_rc=""

    #ȡеdiskPoolId
    diskPoolAll=`cat /proc/monc_dsmap|grep DiskPool|awk '{print $6}'|sort|uniq`
    iRet=$?
    if [ "$iRet" -ne 0 ] || [ "$diskPoolAll" == "" ];then

        WRITE_XML_COMMON 0 "monc_dsmap is null"

        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL

        LOG "[$FUNCNAME]:err out,iRet($iRet),diskPoolAll($diskPoolAll)."
        return 0
    fi

    set_ifs
    for poolId in $diskPoolAll
    do
        diskSize=`cat /proc/monc_dsmap | grep "DiskPool $poolId"`
        allDiskSize=0
        allFreeSize=0
        AllDiskUsed=0
        AvePercentage=0

        #ƽʹ
        for line in $diskSize
        do
            totalCap=`echo $line|awk '{print $10}'`
            freeCap=`echo $line|awk '{print $12}'`

            #λֽתGB expr $totalCap / 1073741824
            allDiskSize=`expr $allDiskSize \+ $totalCap`
            allFreeSize=`expr $allFreeSize \+ $freeCap`

            LOG "[$FUNCNAME]:allDiskSize:$allDiskSize,allFreeSize:$allFreeSize,totalCap:$totalCap,freeCap:$freeCap"

        done

        #ȡʹʵİٷֱ AvePercentage
        AllDiskUsed=`expr $allDiskSize \- $allFreeSize`

        if [ $allDiskSize -eq 0 ];then
            AvePercentage=0
            continue
        else
            AvePercentage=$(printf "%.2f\n" `echo "scale=2;$AllDiskUsed*100/$allDiskSize"|bc -l`)
        fi

        LOG "$FUNCNAME]allDiskSize(BYTE):$allDiskSize,allFreeSize(BYTE):$allFreeSize,AllDiskUsed(BYTE):$AllDiskUsed,AvePercentage:$AvePercentage"
        Result=

        #Ƚÿһİٷֱ,ȡСʹ
        MaxOnePercentage=0
        MinOnePercentage=100
        ratio=0
        ratio_min=100
        ratio_max=0
        ratio_diff=0

        for line in $diskSize
        do
            OneTotalCap=`echo $line|awk '{print $10}'`
            OneFreeCap=`echo $line|awk '{print $12}'`
            OneUserCap=`expr $OneTotalCap \- $OneFreeCap`

            if [ $OneTotalCap -eq 0 ];then
                OnePercentage=0
                continue
            else
                OnePercentage=$(printf "%.2f\n" `echo "scale=2;$OneUserCap*100/$OneTotalCap"|bc -l`)
                ratio=$(($OneUserCap*100/$OneTotalCap))
            fi

            if [ $(echo "$OnePercentage > $MaxOnePercentage"|bc) -eq 1 ];then
                MaxOnePercentage=$OnePercentage;
            fi

            if [ $(echo "$MinOnePercentage > $OnePercentage"|bc) -eq 1 ];then
                MinOnePercentage=$OnePercentage;
            fi

            if [ $ratio -gt $ratio_max ]; then
                ratio_max=$ratio
            fi

            if [ $ratio -lt $ratio_min ]; then
                ratio_min=$ratio
            fi

            LOG "[$FUNCNAME]:OneTotalCap:$OneTotalCap,OneFreeCap:$OneFreeCap,OneUserCap:$OneUserCap,OnePercentage:$OnePercentage,MaxOnePercentage:$MaxOnePercentage,MinOnePercentage:$MinOnePercentage."
            LOG "[$FUNCNAME]:ratio($ratio), ratio_min($ratio_min), ratio_max($ratio_max)"
        done

        ratio_diff=$(($ratio_max-$ratio_min))
        if [ $ratio_diff -gt 10 ] || [ $ratio_max -ge 80 ]; then
            LOG "DiskPool(ID):$poolId || diskpool($poolId) max ratio is larger than min ratio 10%(ratio_diff: $ratio_diff), or max ratio is more than 80%(ratio_max: $ratio_max)"
            diskpool_rc="fail"
            isPass=4
        else
            diskpool_rc="pass"
        fi

        errResult="DiskPool(ID):$poolId || AvePercentage:$AvePercentage || MaxPercentage:$MaxOnePercentage || MinPercentage:$MinOnePercentage || Result:$diskpool_rc"
        WRITE_XML_COMMON 0 "${errResult}"
    done

    restore_ifs

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


function CompareIp()
{
    local iRet=0
    numa=$1
    numb=$2
    numa=$(echo $numa | sed 's/\.//g')
    numb=$(echo $numb | sed 's/\.//g')
    #ڵĵһIPСڵڶ1
    if [ $numa -lt $numb ];then
        iRet=1
    fi

    return $iRet
}

#142. ߼
checkEthNetLine()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local iRet=0
    local switchArray=()
    local IpArray=()
    local arraySize=0
    local count=0
    local TASK_ID=0
    local switch_big_Array=()
    local port_type_Array=()
    local cm_db="/opt/huawei/snas/etc/cm_swm_conf.db"

    LOG "[$FUNCNAME][$LINENO]start!"
    SWITCH_SMALL_FILE="/tmp/switch_small_file"
    ALL_SWITCH_IFNO="/tmp/tmpfileallswitchinfo"
    if [ -L "${SWITCH_SMALL_FILE}" ];then
        rm -f "${SWITCH_SMALL_FILE}"
    fi
    rm -f /tmp/switch_small_file*
    if [ -L "${ALL_SWITCH_IFNO}" ];then
	    rm -f "${ALL_SWITCH_IFNO}"
    fi
    >$ALL_SWITCH_IFNO
    SWITCH_TOPO_FILE="/opt/huawei/snas/etc/switchTopo.ini"
    dos2unix $SWITCH_TOPO_FILE > /dev/null 2>&1


    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            LOG "[$FUNCNAME][$LINENO]Can't get master ip"
            isPass=1
            WRITE_XML_COMMON 0 "INFO:Can't get master ip"
            break
        fi
        cp $SWITCH_TOPO_FILE /tmp/tmpfileswitchTopo
        if [ $? -ne 0 ];then
           LOG "[$FUNCNAME][$LINENO]Can't get the switch info"
           isPass=2
           WRITE_XML_COMMON 0 "INFO:Can't get switch information"
           break
        fi
        REMOTE_IP_S=`cat $IP_ROLE_FILE`
        remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/CheckNetLine $back_ip 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            isPass=$iRet
        fi
        ValidIP=`cat ${VALID_IP_FILE}`
        ValidIPResult=$ValidIP

        LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
        fifo_start
        while [ "${ValidIP}" != "" ]; do
            >${VALID_IP_FILE}

            for Item in $ValidIP; do
                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "Can not get switchinfo"
                iRet=$?
                if [ $iRet -eq 0 ]; then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 -a $iRet -ne 5 ]; then
                    isPass=1
                fi

                remote_download $Item $G_TMP_FILE$Item /tmp/tmpfilecheckswitchinfo
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    errResult="Node: $Item||INFO:Can not get information of tmpfilecheckswitchinfo($iRet)!||${errResult}"
                    LOG "[$FUNCNAME][$LINENO] $Item exec(tmpfilecheckswitchinfo) failed.iRet($iRet),errno($errno),process(&process)"
                    isPass=1
                    continue
                fi
            done

            ValidIP=`cat ${VALID_IP_FILE}`
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi
            echo "" >> $G_TMP_FILE$Item
            cat $G_TMP_FILE$Item >> $ALL_SWITCH_IFNO 2>&1
        done
        tmp=$(cat $ALL_SWITCH_IFNO | grep "switchName\:NULL")
        if [ "$tmp" != "" ]; then
            local switchIdArray=$(/usr/bin/sqlite3 "${cm_db}" "select szSwId from CM_SWM_T")
            if [ -z "${switchIdArray}" ]; then
                isPass=3
                WRITE_XML_COMMON 0 "INFO:The switch is not configured so No switch info. Do not involve."
                WRITE_XML_JUDGE $isPass
                WRITE_XML_SUBCMD_TAIL
                [ -f "${SWITCH_SMALL_FILE}" ] && rm -f "${SWITCH_SMALL_FILE}"
                [ -f "${ALL_SWITCH_IFNO}" ] && rm -f "${ALL_SWITCH_IFNO}"
                rm -f /tmp/tmpfileswitchTopo*
                return
            fi
        fi
        while read line; do
            arraySize=0
            for oneRec in $line;do
                isNode=$(echo $oneRec | awk -F ':' '{printf $1}')
                if [ "$isNode" = "nodeFunType" ]; then
                    nodeFunType=$(echo $oneRec | awk -F ',' '{printf $1}'| awk -F ':' '{printf $2}')
                    nodeName=$(echo $oneRec | awk -F ',' '{printf $2}'| awk -F ':' '{printf $2}')
                else
                    netPort=$(echo $oneRec | awk -F ',' '{printf $1}'| awk -F ':' '{printf $2}')
                    NodeIP=$(echo $oneRec | awk -F ',' '{printf $2}'| awk -F ':' '{printf $2}')
                    switchName=$(echo $oneRec | awk -F ',' '{printf $3}'| awk -F ':' '{printf $2}')
                    oneline="nodeName: $nodeName||nodeFunType: $nodeFunType||netPort: $netPort||IP: $NodeIP||switchName: $switchName"
                    LOG "$oneline"
                    WRITE_XML_COMMON 0 "$oneline"
                    switchArray[$arraySize]=$switchName
                    IpArray[$arraySize]=$NodeIP
                    arraySize=$((arraySize+1))
                fi
            done
            #ֻһIP.ж
            if [ $arraySize -eq 1 ];then
                continue
            fi
            CompareIp ${IpArray[0]} ${IpArray[1]}
            iRet=$?
            #СIPһʱļIPʱ
            if [ $iRet -eq 1 ]; then
                echo ${switchArray[0]} >>${SWITCH_SMALL_FILE}_${netPort} 2>&1
                switch_big_Array[count]=${switchArray[1]}
            else
                echo ${switchArray[1]} >>${SWITCH_SMALL_FILE}_${netPort} 2>&1
                switch_big_Array[count]=${switchArray[0]}
            fi
            port_type_Array[count]=$netPort
            count=$((count+1))
        done < $ALL_SWITCH_IFNO
        LOG "[$FUNCNAME][$LINENO] isPass=$isPass"
        if [ $isPass -ne 2 ];then
            for ((i=0; i<count; i=i+1))
            do
                #ôIPӦ ȥļƥ䣬ҵ˵нڵСIPӷʽڵ㲻ͬͨ
                grep -q ${switch_big_Array[i]} ${SWITCH_SMALL_FILE}_${port_type_Array[i]} >>/dev/null
                iRet=$?
                if [ $iRet -eq 0 ];then
                    isPass=1
                    LOG "[$FUNCNAME][$LINENO] ${switch_big_Array[i]} the same of switchName"
                fi

            done
        fi
        break
    done


    LOG "[$FUNCNAME][$LINENO]finish!"
    [ -f "${SWITCH_SMALL_FILE}" ] && rm -f "${SWITCH_SMALL_FILE}"
    [ -f "${ALL_SWITCH_IFNO}" ] && rm -f "${ALL_SWITCH_IFNO}"
    rm -f /tmp/tmpfileswitchTopo*
    rm -f /tmp/switch_small_file*
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#143. ݿЧռ
checkDBAvailableSpace()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local G_TMP_FILE_Item=()
    local count=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/checkDBAvailableSpace > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get DB available space information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME] $Item exec(checkDBAvailableSpace) failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO: Failed to execute command(${G_MML_FILE_PATH}/checkDBAvailableSpace)"
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[${FUNCNAME}] ${Item} download ${G_REMOTE_TMP_FILE}${FUNCNAME} failed.iRet($iRet)"
                errResult="Node: ${Item}||INFO:Cannot get available space of DB!"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                continue
            fi

            G_TMP_FILE_Item[count]=$Item
            count=$((count+1))

        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in ${G_TMP_FILE_Item[*]}; do
        local dbNode=`grep "dbNode:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        if [ "X$dbNode" == "X0" ];then
            LOG "This node not use database, dbNode:[$dbNode] ${Item}."
            WRITE_XML_COMMON 0 "Node:$Item||Disk Partition Available Space:Does not involve||DB Need Space:--||DB Used Space:--"
            continue
        fi

        nodePass=`grep "isPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        aSpace=`grep "aSpace:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        nSpace=`grep "nSpace:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        uSpace=`grep "uSpace:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`

        #ıʶͬӰ칤߽ʾ
        WRITE_XML_COMMON 0 "Node:$Item||Disk Partition Available Space:${aSpace}||DB Need Space:${nSpace}||DB Used Space:${uSpace}"

        if [ "${nodePass}""X" != "0X" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||The remaining size of the Var partition (${aSpace}) is less than the space required by the database (${nSpace})."
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#144 PCIEЭ
checkEthPcieStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local errResult=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/CheckPcieSpeed > $G_REMOTE_TMP_FILE$FUNCNAME"
    if [ 0 -ne $? ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get Ethernet PCIE information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "item=$Item, download file fail!"
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                LOG "item=$Item, file($G_TMP_FILE$Item) is empty!"
                continue
            fi

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node: $Item||INFO: $info||${errResult}"
                    LOG "[$FUNCNAME] Error: $info"
                else
                    WRITE_XML_COMMON 0 "Node:$Item||$info"
                fi
            done < $G_TMP_FILE$Item
            restore_ifs
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}
#145SES̼汾
checkSesFwVersion()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local errResult=""

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/GetSesFwVersion.sh > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get SES Version information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "item=$Item, download file fail!"
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                LOG "item=$Item, file($G_TMP_FILE$Item) is empty!"
                continue
            fi

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node: $Item||INFO: $info||${errResult}"
                    LOG "[$FUNCNAME] Error: $info"
                else
                    WRITE_XML_COMMON 0 "Node:$Item||$info"
                fi
            done < $G_TMP_FILE$Item
            restore_ifs
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#146 д״̬
checkDiskWriteCache()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local errResult=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/GetDiskWriteCache > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ 0 -ne $? ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get Disk Write Cache information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "item=$Item, download file fail!"
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        fifoContext=`cat $G_TMP_FILE$Item`
        if [ "$fifoContext" = "" ];then
            LOG "item=$Item, file($G_TMP_FILE$Item) is empty!"
            continue
        fi

        set_ifs
        while read line; do
            info=`handle_remote_result "$line"`
            if [ $? -ne 0 ]; then
                isPass=1
                errResult="Node: $Item||INFO: $info||${errResult}"
                LOG "[$FUNCNAME] Error: $info"
            else
                WRITE_XML_COMMON 0 "Node:$Item||$info"
            fi
        done < $G_TMP_FILE$Item
        restore_ifs
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

function version_lt()
{
    test "$( echo "$@" | tr " " "\n" | sort -rV | head -n 1 )" != "$1";
}

#147 SAS̼汾
checkSASVersion()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local errResult=""
    local SASTypeList="/tmp/tmpfileSASVersionList"
    local SASTypeArray=("SAS2008" "SAS2308" "SAS3008" "PM8070")
    local RHTypeArray=("V3 V5")
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 180 "$G_MML_FILE_PATH/GetSASVersion > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ 0 -ne $? ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not SAS version information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "[$FUNCNAME][$LINENO]item=$Item, download file fail!"
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        fifoContext=`cat $G_TMP_FILE$Item`
        if [ "$fifoContext" = "" ];then
            isPass=1
            errResult="Node:${Item}||INFO:Get SAS version infomation from output(${fun}) failed!||${errResult}"
            LOG "[$FUNCNAME][$LINENO]item=$Item, file($G_TMP_FILE$Item) is empty!"
            continue
        fi

        isNeedcheck=$(cat $G_TMP_FILE$Item | grep "Does not involve")
        LOG "[$FUNCNAME][$LINENO]isNeedcheck=$isNeedcheck"
        if [ "$isNeedcheck" != "" ];then
            WRITE_XML_COMMON 0 "Node:$Item||Node_Version:not invovle||Controller:--||NVDATA:--||Firmware:--||BIOS_Version:--||UEFI_BSD:--"
            continue
        fi

        Controller=$(cat $G_TMP_FILE$Item | grep "Controller" | awk -F'=' '{print $2}')
        if [ "$Controller" = "NULL" ];then
            isPass=1
            info="Get Controller field from output(${fun}) failed."
            errResult="Node: $Item||INFO: $info||${errResult}"
            LOG "[$FUNCNAME][$LINENO]item=$Item, Get SAS Controller Fail!"
            continue
        fi
        local rhVer=$(cat $G_TMP_FILE$Item | grep "^RH=" | awk -F'=' '{print $2}')
        echo "RH=${rhVer};Controller=${Controller};IP=${Item}" >> $SASTypeList
        nvdata=$(cat $G_TMP_FILE$Item | grep "NVDATA" | awk -F'=' '{print $2}')
        Firmware=$(cat $G_TMP_FILE$Item | grep "Firmware" | awk -F'=' '{print $2}')
        BIOS_Version=$(cat $G_TMP_FILE$Item | grep "BIOS_Version" | awk -F'=' '{print $2}')
        uefi_bsd=$(cat $G_TMP_FILE$Item | grep "UEFI_BSD" | awk -F'=' '{print $2}')

        # 1. 3008FW汾15.00.07.00汾в2
        if [ X"${Controller}" == X"SAS3008" ]; then
            if version_lt $Firmware "15.00.07.00"; then
                # 2. message־Ƿ fault_state(0x26b6) ӡѿͻRAIDFW߻
                fault_state_backup=$( zcat /var/log/backup/OS/message.log.*.tar.gz | grep -a "fault_state(0x26b6)" | wc -l )
                fault_state=$( cat /var/log/message/message.log | grep -a "fault_state(0x26b6)" | wc -l )
                if [ ${fault_state_backup} -ne 0 ] || [ ${fault_state} -ne 0 ]; then
                    isPass=$(check_pass $isPass 4)
                    LOG "item=${Item}, SAS3008FwVersion=${Firmware}!"
                    errResult="Node:${Item}||INFO:SAS3008FwVersion is ${Firmware}! Please upgrade RAID card's FW version to 15.00.07.00 or later, or replace the card.||${errResult}"
                fi
            fi
        fi

        WRITE_XML_COMMON 0 "Node:$Item||Node_Version:RH ${rhVer}||Controller:$Controller||NVDATA:$nvdata||Firmware:$Firmware||BIOS_Version:$BIOS_Version||UEFI_BSD:$uefi_bsd"
    done

    for SAStype in ${SASTypeArray[*]};do
        for tmprh in ${RHTypeArray[*]};do
            local filter="RH=${tmprh};Controller=${SAStype}"
            local mastFlag=0
            local firstIP=""
            local firstfile=""
            if [ $isPass -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]SAStype=$SAStype,due to isPass=$isPass,so no need to compare."
                break
            fi

            for line in $(cat $SASTypeList | grep $filter);do
                LOG "[$FUNCNAME][$LINENO]isPass=$isPass,SAStype=${SAStype},compare line info[line=$line]."
                local tmpIP=`echo $line | awk -F ";" '{print $3}' | awk -F "=" '{print $2}'`
                if [ $mastFlag -eq 0 ];then
                    firstfile=$G_TMP_FILE$tmpIP
                    firstIP=$tmpIP
                    mastFlag=1
                    LOG "[$FUNCNAME][$LINENO]master file=$firstfile"
                    continue
                fi
                diff $firstfile $G_TMP_FILE$tmpIP > /dev/null
                if [ 0 -ne $? ];then
                    isPass=4
                    errResult="Node:${tmpIP}||INFO:SAS version is not same between $firstIP and $tmpIP||${errResult}"
                    LOG "[$FUNCNAME][$LINENO] SAS version not the same between $firstIP and $tmpIP."
                    break
                fi
            done
        done
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    rm -rf $SASTypeList
}

# 149 ڵMTUǷһ¡֡
checkNetportBitErrandJumboframe()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local once_bak=0
    local once_tmp=0
    local base_front_mtu=""
    local base_manage_mtu=""
    local is_base_ini_set=""
    local base_ini_front_mtu=""
    local base_ini_manage_mtu=""
    local original_ip=""

    REMOTE_IP_S=$( cat $IP_ROLE_FILE)

    remote_exec_async_batch $TASK_ID 180 "$G_MML_FILE_PATH/GetNetportMTU > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ 0 -ne $? ];then
        isPass=1
    fi

    ValidIP=$( cat ${VALID_IP_FILE})
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get Netport MTU information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "[$FUNCNAME][$LINENO]item=$Item, download file fail!"
                continue
            fi
        done

        ValidIP=$(cat ${VALID_IP_FILE})
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        fifoContext=$( cat $G_TMP_FILE$Item)
        if [ "$fifoContext" = "" ];then
            LOG "[$FUNCNAME][$LINENO]item=$Item, file($G_TMP_FILE$Item) is empty!"
            continue
        fi

        #cm.iniõmtuֵͻ׼ֵǷһ
        local cmini_front_mtu=$(echo "${fifoContext}" |grep "front_mtu_value" |awk -F':' '{print $2}'|tr -d ' ')
        local cmini_manage_mtu=$(echo "${fifoContext}" |grep "manage_mtu_value" |awk -F':' '{print $2}'|tr -d ' ')

        if [[ "${is_base_ini_set}" == "" ]];then
            is_base_ini_set="set"
            base_ini_front_mtu="${cmini_front_mtu}"
            base_ini_manage_mtu="${cmini_manage_mtu}"
            original_ip="${Item}"
        fi

        #жmtu
        local netCard=$(echo "${fifoContext}" |grep "type:" |awk {'print $1'})
        for eth_tmp in $(sort -u <<< "${netCard}" || echo ${netCard});do
            #ȡsysconfigõmtuֵ,            #ȡǰõmtuֵ
            local sysconfig_mtu=$(echo "${fifoContext}" |grep ${eth_tmp} |grep 'MTU=' | head -n1 |awk -F'=' '{print $2}'|sed "s/'//g")
            local port_mtu=$(echo "${fifoContext}" |grep "${eth_tmp} mtu:" | head -n1 |awk -F':' '{print $2}'|tr -d ' ')
            local bussiness_type=$(echo "${fifoContext}" |grep "${eth_tmp} type:" | head -n1 |awk -F':' '{print $2}'|tr -d ' ')
            local BitErr_num=$(echo "${fifoContext}" |grep "${eth_tmp} BitErr:" | head -n1 |awk -F':' '{print $2}'|tr -d ' ')
            local JumboFrameErr_num=$(echo "${fifoContext}" |grep "${eth_tmp}" | grep JumboFrameErr | head -n1 |awk -F':' '{print $2}'|tr -d ' ')
            local base_mtu=""
            local base_ini_mtu=""
            if [ "${bussiness_type}" = "front" ];then
                #ǰmtu
                if [[ "${base_front_mtu}" == "" ]];then
                    base_front_mtu="${port_mtu}"
                    original_front_mtu_ip=$Item
                    LOG "[$FUNCNAME][$LINENO] base:${Item} base_front_mtu:${base_front_mtu}"
                fi
                base_mtu="${base_front_mtu}"
                base_ini_mtu="${base_ini_front_mtu}"
                #original_ip="${original_front_mtu_ip}"
            else
                #mtu
                if [[ "${base_manage_mtu}" == "" ]];then
                    base_manage_mtu="${port_mtu}"
                    original_manage_mtu_ip=$Item
                    LOG "[$FUNCNAME][$LINENO] base:${Item} base_manage_mtu:${base_manage_mtu}"
                fi
                base_mtu="${base_manage_mtu}"
                base_ini_mtu="${base_ini_manage_mtu}"
                #original_ip="${original_manage_mtu_ip}"
            fi

            if [[ "${base_mtu}" != "${port_mtu}" ]];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:${eth_tmp} configureation MTU (${port_mtu}) is different from the reference node (${original_ip}) MTU (${base_mtu})."
            fi

            if [[ "${base_ini_mtu}" != "${sysconfig_mtu}" ]];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:${eth_tmp} MTU (${sysconfig_mtu}) in sysconfig file is different from the reference node (${original_ip}) MTU (${base_ini_mtu}) in configuration file(cm.ini)."
            fi

            if [[ "${base_ini_mtu}" != "" &&  "${base_ini_mtu}" != "${port_mtu}" ]];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:${eth_tmp} MTU (${port_mtu}) in configuration file is different from the reference node (${original_ip}) MTU (${base_ini_mtu}) in configuration file(cm.ini)."
            fi

            if [ $BitErr_num -gt 100000 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:${eth_tmp} BitErr is greater than 100,000."
            fi

            if [ $JumboFrameErr_num -gt 100000 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:${eth_tmp} JumboFrameErr is greater than 100,000."
            fi
        done

        result=$(cat $G_TMP_FILE$Item)
        WRITE_XML_COMMON 0 "MTU Info:---------------$Item---------------||MTU Info:$result"

    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#150. ̿ؼ
checkKicksSwitch()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "cat /opt/huawei/snas/etc/cm.ini > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ 0 -ne $? ];then
        isPass=1
    fi

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get cm.ini information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "item=$Item, download file fail!"
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                LOG "item=$Item, file($G_TMP_FILE$Item) is empty!"
                continue
            fi

            DiskKickForbit=$(grep 'DiskKickForbit=1' $G_TMP_FILE$Item)
            if [ "$DiskKickForbit" == "" ];then
                WRITE_XML_COMMON 0 "Node:$Item||DiskKickForbit:close"
            else
                isPass=1
                WRITE_XML_COMMON 0 "Node:$Item||DiskKickForbit:open"
            fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#ûдѲΪ漰
noInspectItem()
{
    WRITE_XML_SUBCMD_HEADER $1
    WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
    WRITE_XML_JUDGE 3
    WRITE_XML_SUBCMD_TAIL
}

# **************************************************************************** #
# Function Name: checkHardwareStatus
# Description: Ӳ״̬ м.
# Parameter: $1 cmditemID
# Return:
# **************************************************************************** #
checkHardwareStatus()
{
    LOG_Check

    WRITE_XML_CMD_HEADER $1
    #GetIPAndRoleFromDB

    rm -rf /opt/inspect/tmpfile$$*
    rm -rf /tmp/tmpfile$$*

    LOG "[$FUNCNAME] param = ($1)"
    case $1 in
        100)
        #1.Check Disk Usage
        checkDiskUsage "0"
        ;;
        101)
        #2.Check CPU Usage
        checkCPUUsage "0"
        ;;
        102)
        #3.Check Memory Usage
        checkMemUsage "0"
        ;;
        103)
        #4.Check Disk Status
        checkDiskStatus_MML "0"
        ;;
        104)
        #5.Check Power Status
        checkPowerStatus_MML "0"
        ;;
        105)
        #6.Check Fan Status
        checkFanStatus_MML "0"
        ;;
        106)
        #7.Check Netport Status
        checkNetportStatus "0"
        ;;
        107)
        #8.Check CPU Status
        checkCPUStatus "0"
        ;;
        108)
        #9.Check Node Status
        checkNodeStatus_MML "0"
        ;;
        109)
        #10.Check disk verify error
        checkDiskVerify "0"
        ;;
        110)
        #ڵ()¶
        checkCardTemp "0"
        ;;
        112)
        #ģ
        checkFiber_MML "0"
        ;;
        113)
        #check SSD
        checkSSD "0"
        ;;
        114)
        #check RAID
        checkSysRAID "0"
        ;;
        115)
        #check nvdimm
        checkNvdimmStatus "0"
        ;;
        116)
        #bit ECC
        checkBitEcc "0"
        ;;
        117)
        #check ARP
        checkArpErr_MML "0"
        ;;
        119)
        #汾һ¼
        checkNodeVersion "0"
        ;;
        120)
        #è״̬
        checkModmemtatus "0"
        ;;
        121)
        #ѯ豸ʱ
        checkNodeTime "0"
        ;;
        122)
        #syslog״̬
        checkSysLog "0"
        ;;
        126)
        #⼶״̬
        checkExpBoardStatus "0"
        ;;
        127)
        #ⳬ״̬
        checkCBUStatus "0"
        ;;
        128)
        #FW汾
        checkFwVersion "0"
        ;;
        129)
        #ӲFW汾
        checkDiskFwVersion "0"
        ;;
        130)
        #phy
        checkDiskPhy "0"
        ;;
        131)
        #Ӳ
        checkDisk "0"
        ;;
        133)
        #ڴ
        checkPhysicalMemory "0"
        ;;
        134)
        #NCQ
        checkNodeNCQ "0"
        ;;
        136)
        #豸ڵǷʱԴ쳣
        checkClockSourceRisk "0"
        ;;
        137)
        #diskpoolʹǷ
        checkDiskPoolUsage "0"
        ;;
        140)
        #Ϣ
        checkVmstatus "0"
        ;;
        142)
        #߼
        checkEthNetLine "0"
        ;;
        143)
        #S3ݿЧռ
        checkDBAvailableSpace "0"
        ;;
        144)
        #PCIEЭ
        checkEthPcieStatus "0"
        ;;
        145)
        #SES̼汾
        checkSesFwVersion "0"
        ;;
        146)
        #д
        checkDiskWriteCache "0"
        ;;
        147)
        #SAS̼汾
        checkSASVersion "0"
        ;;
        149)
        #ڵMTUǷһ¡֡
        checkNetportBitErrandJumboframe "0"
        ;;
        150)
        #̿ؼ
        checkKicksSwitch "0"
	    ;;
        *)
        noInspectItem "0"
        ;;
    esac
    chmod 640 $LOG_FILE
    WRITE_XML_CMD_TAIL
    rm -rf /opt/inspect/tmpfile$$*
    rm -rf /tmp/tmpfile$$*
    rm -rf /tmp/tmp_valid_ip$$
}

