#!/bin/bash

MYPATH="$(dirname $0)"
if [ "." = "${MYPATH}" ];then
    MYPATH=${PWD}
fi
. ${MYPATH}/exec_utility.sh

cm_ini="/opt/huawei/snas/etc/cm.ini"
cm_confdb="/opt/huawei/snas/etc/cm_conf.db"
MYIP=127.0.0.1
function usage()
{
    echo "Usage: ${0##*/} {Repair [Clusterid]}"
}
function getMyBackIp()
{
    local nid=$(grep "NID=" ${cm_ini} | awk -F '=' '{print $2}')
    if [ "X" != "${nid}" ];then
        local nip=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db  "select IP_ADDR from CM_NODE_IP_T where NID=${nid} and SUBNET_ID=1" | head -n 1)
        if [ "X" != "X${nip}" ];then
            MYIP=$nip
            return 0
        fi
    fi
    return 1
}

function show_execute()
{

    local clusterIdNum=$(sqlite3 ${cm_confdb} "select count(CLUSTER_ID) from CM_CLUSTER_INFO where(CLUSTER_ID LIKE '%@ver=%')")
    if [ $clusterIdNum -ne 0 ];then
        local clusterId=$(sqlite3 ${cm_confdb} "select CLUSTER_ID from CM_CLUSTER_INFO where(CLUSTER_ID LIKE '%@ver=%')")
        echo "$clusterId"
    fi
    return 0
}

#查询业务类型
#Show|Repair func_cb
function do_execute()
{
    local clusterIdinfo=$1
    local result=""
    local isError=0
    local Repeat=(1 2 3)

    echo "${cmd} ClusterID ${MYIP}: "
    local clusterIdNum=$(sqlite3 ${cm_confdb} "select count(CLUSTER_ID) from CM_CLUSTER_INFO ")
    local lowerVerIdNum=$(sqlite3 ${cm_confdb} "select count(CLUSTER_ID) from CM_CLUSTER_INFO where(CLUSTER_ID NOT LIKE '%@ver=%')")
    if [ ${lowerVerIdNum} -eq 0 ] && [ ${clusterIdNum} -ne 0 ];then
        echo "Success: Clusterid check successfully! No need to repair."
        return 0
    elif [ ${lowerVerIdNum} -ne 0 ];then
        #删除低版本clusterid
        sqlite3 ${cm_confdb} "delete from CM_CLUSTER_INFO where(CLUSTER_ID NOT LIKE '%@ver=%')"
        #删除后检查,是否删除,
        lowerVerIdNum=$(sqlite3 ${cm_confdb} "select count(CLUSTER_ID) from CM_CLUSTER_INFO where(CLUSTER_ID NOT LIKE '%@ver=%')") 
        if [ $lowerVerIdNum -eq 0 ];then
             echo "Info: The cluster ID of the earlier version is deleted successfully!"
        fi
    fi

    clusterIdNum=$(sqlite3 ${cm_confdb} "select count(CLUSTER_ID) from CM_CLUSTER_INFO where(CLUSTER_ID LIKE '%@ver=%')")
    if [ ${clusterIdNum} -ge 1 ];then
        echo "Success: Clusterid repair successfully!"
        return 0
    elif [  ${clusterIdNum} -eq 0 ];then
        #从其他节点获取密文,插入到当前节点.
        if [[ "$clusterIdinfo" =~ "@ver=" ]];then
            sqlite3 ${cm_confdb} "insert into CM_CLUSTER_INFO values('${clusterIdinfo}')"
            echo "Success: Clusterid repair successfully!"
        else
            echo "Error:Clusterid(${MYIP}) repair fail!"
            return 1
        fi
        #其他节点都没有可用密文,则失败.
    fi

}

paramNum=$#
if [ ${paramNum} -eq 0 ];then
    usage
    exit 0
fi

ACTION=$1
CLUSTER_ID_TEXT=$2
getMyBackIp
case "$ACTION" in
    "Show")
        show_execute
        exit $?
        ;;
    "Repair")
        if [ $paramNum -eq 1 ];then
            do_execute
        elif [ $paramNum -eq 2 ];then
            do_execute "${CLUSTER_ID_TEXT}"
        else
            usage
        fi

        exit $?
        ;;
    *)
        usage
        ;;
esac

exit 0
