#!/bin/sh
ParserFile="/opt/huawei/snas/script/ConfigParser.sh"
source ${ParserFile}

COLLECT_DIR="/var/log/cm"
ErrorInfoFlag="CollectErrorInfo:"
RepeatTimes=(1 2 3 4 5 6 7 8 9)
G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"
OMGROUP="omgroup"
G_COLL_SCRIPT_PATH="/opt/huawei/snas/bin"
IP_ROLE_FILE="/tmp/tmp_ip_role"
VALID_IP_FILE="/tmp/tmp_datacollect_ip$$"
G_TMP_FILE="/tmp/tempcollect$$"
CM_DB="/opt/huawei/snas/etc/cm_conf.db"
#ڵռ־Ŀ¼
CMLogDir="/var/log/cm/LocalDataCollect/"

#ڵ־ļ
LOG_FILE="/var/log/collect/local.log"

#ڵѹļN9000datacollect.shеDATA_REMOTEһ
DATA_REMOTE_FileName="/var/log/cm/Local_DataCollect.zip"

BACKUP_DIR="/mnt/fs/system/log/$(hostname)"
BACKUP_DIR_ForGrep="\/mnt\/fs\/system\/log\/$(hostname)"

SUB_LOG=("" "" "" "audit/audit.log" "message/message.log")

#ڵ־ļ
MessageDir="$CMLogDir""Messages/"

#ļStackĿ¼
StackDir="$CMLogDir""Other/Stack/"
MonDir="$CMLogDir""Other/monitor_map/"

#ű·
ScriptDir=`dirname $0`
ScriptDir_DLM="/opt/huawei/snas_cluster/bin"

#ļϵͳǷʶĬϱʶ
fileSystemFlag=1

#ini,dbϢ·
CONFIG_DEPLOY="/opt/huawei/snas/etc/"
CONFIG_STATIC="/opt/huawei/snas/static/"
CONFIG_CMINI="/opt/huawei/snas/etc/cm.ini"

#mmlļ·
G_MML_PATH="/opt/huawei/snas/script/inspect_mml"

#C01汾־ļ
c01File="/tmp/collectC01File"

let "TOTAL_SIZE=20*10*1024*1024"
SUB_WEIGHTS=()
product_type_vaule=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')
#DiskinfoڰմСռʱδڵѹԲأ0
if [ "X80" == "X${product_type_vaule}" ]; then
    SUB_WEIGHTS=(5 1 5 5 20 24 5 5 5 10 5 5 0 0 5 0)
else
    SUB_WEIGHTS=(5 5 5 5 30 10 5 5 5 10 5 5 0 0 5 0)
fi

MIN_VALUE=5120
SUB_SYSTEM=(DeviceManager_ToolKit OceanStorOS OM MON_BJM DFS_OBS OSS RPCUser Hardware OS WorkLoad Accesslog Gaussdblog DiskInfo DiskLog snas_CA DiskFaultInfo)

#־
#DFS_OBS
Collect_DFS_OBS_Log="snasmessages snas_obs snas_BASE snas_FCL snas_NOFS snas_CA sysmonitor.log snas_dab mds_state_check/log/"  #־ռ־Ŀ¼Ϊ/var/log/
Collect_DFS_OBS_SnasLog="obs|snasmessages|snas_BASE.log|snas_FCL.log|snas_NOFS.log|snas_CA"
Collect_DFS_OBS_Other_Log="snas.mds.sys.log snas.mds rpcmessages snas_TS" #δѹ־

    #Ϊ˼ʹ
Collect_DFS_OBS_C01Log="snasmessages snas_BASE snas_FCL snas.mds rpcmessages snas_TS"
#DeviceManager_ToolKit
Collect_ISM_Log=""          #־ռ־Ŀ¼Ϊ/var/log/
Collect_ISM_Other_Log=""    #δѹ־
#MON_BJM
Collect_MON_BJM_Log="snas_MON snas_BJM snas_fault" #־ռ־Ŀ¼Ϊ/var/log/
Collect_MON_BJM_SnasLog="snas_MON|snas_BJM|snas_fault"
Collect_MON_BJM_Other_Log="snas_mon_crit" #δѹ־
    #Ϊ˼ʹ
Collect_MON_BJM_C01Log="snas_MON.log"
#OceanStorOS
Collect_OceanStorOS_Log="snas_INFOEQUAL snas_REP snas_CMRSTORE" #־ռ־Ŀ¼Ϊ/var/log/
Collect_OceanStorOS_SnasLog="snas_INFOEQUAL.log|REP.log|snas_CLUSTER.log|snas_CMRSTORE.log|snas_REP"
Collect_OceanStorOS_Other_Log="snas_CLUSTER.log" #δѹ־
#OM
Collect_OM_Log="snas_CM snas_vrns snas_KMM" #־ռ־Ŀ¼Ϊ/var/log/
Collect_OM_SnasLog="snas_CM|snas_vrns|snas_KMM"
Collect_OM_Other_Log="cli_start dep.log upgrade.log upgrade/updparal_ start snas_env_check patch datasync logrotate/rsync_err.log logrotate/run_" #δѹ־
#Ϊ˼ʹ
Collect_OM_C01Log="snas_CM start"
#OS
Collect_OS_Log="messages message/message.log audit/audit.log audit/auditd.log logrotate/sudo.log snas_audit.log snas_audit_kernel.log snas_audit_expiredel.log" #־ռ־Ŀ¼Ϊ/var/log/
Collect_OS_SnasLog="message|audit|sudo|snas_audit|snas_audit_kernel|snas_audit_expiredel"
Collect_OS_Other_Log="ntp" #δѹ־
Collect_OM_Snmpagent="snmpagent.log monitor.log"
#OSS
Collect_OSS_Log="snas_NSD.log snas_S3FS.log snas_S3FSBILL.log snas_OBSNSMON.log snas_uds.log" #־ռ־Ŀ¼Ϊ/var/log/
#RPC
Collect_RPC_Log="rpc-" #־ռ־Ŀ¼Ϊ/var/log/
Collect_RPC_SnasLog="rpc-"
Collect_RPC_Other_Log="rpc_peer_log" #δѹ־
#Ϊ˼ʹ
Collect_RPC_C01Log="rpc-"
#Accesslog
Collect_Access_Log="obs.access.log"
#CA
Collect_CA_Log="snas_CA" #־ռ־Ŀ¼Ϊ/var/log/

#SSD
SSD_LOG_FILE="$CMLogDir"Messages/SSD_Log_File
#HDD
HDD_LOG_FILE="$CMLogDir"Messages/HDD_Log_File
#BDM
BDM_LOG_DIR="/OSM/coffer_data/fault_disklog/"
BDM_COLLECT_DIR="${CMLogDir}"Messages/fault_disklog
#MDS
G_MDS_MDB_FILE="$CMLogDir"Other/MDS_MDB_info
G_MDS_MDM_FILE="$CMLogDir"Other/MDS_MDM_info
G_MDS_MDE_FILE="$CMLogDir"Other/MDS_MDE_info
G_MDS_QM_FILE="$CMLogDir"Other/MDS_QM_info
G_MDS_MAIN_FILE="$CMLogDir"Other/MDS_MAIN_info
#CA
G_CA_MEM_FILE="$CMLogDir"Other/CA_MEM_info
G_CA_MML_FILE="$CMLogDir"Other/CA_MML_info
G_CA_EIO_FILE="$CMLogDir"Other/CA_EIO_info
#DS
G_DS_MEM_FILE="$CMLogDir"Other/DS_MEM_info
G_DS_MML_FILE="$CMLogDir"Other/DS_MML_info
G_DS_CMD_FILE="$CMLogDir"Other/DS_CMD_info
#MON
G_MON_MML_4004_FILE="$CMLogDir"Other/MON_MML_4004_info
G_MON_MML_988_FILE="$CMLogDir"Other/MON_MML_988_info
G_MON_MONSTORE_FILE="$CMLogDir"Other/MON_MONSTORE_info
G_MON_HOME_FILE="$CMLogDir"Other/MON_HOME_info
#CCDB
G_CCDB_PROCESS_FILE="$CMLogDir"Other/CCDB_PROCESS_info
G_HISTORY_FILE="$CMLogDir"Other/HISTORY_info
#REPLICATION
G_REPLICATION_FILE="$CMLogDir"Other/REPLICATION_info

#ű
ScriptCommName=collect_comm.sh
ScriptConfigFname=datacollect_config.sh
ScriptOMFname=datacollect_SubsysOM.sh
ScriptISMFname=datacollect_SubsysISM.sh
ScriptOceanStorOSFname=datacollect_SubsysOceanStorOS.sh
ScriptMONandBJMFname=datacollect_SubsysMON_BJM.sh
ScriptDFSandOBSFname=datacollect_SubsysDFS_OBS.sh
ScriptRPCUserFname=datacollect_SubsysRPCUser.sh
ScriptHardwareFname=datacollect_SubsysHardware.sh
ScriptOSFname=datacollect_SubsysOS.sh
ScriptWorkLoadFname=datacollect_SubsysWorkLoad.sh
ScriptDLMFname=dlm_collect_info.sh
ScriptAccessFname=datacollect_SubsysAccess.sh
ScriptGaussdbFname=datacollect_SubsysGaussdb.sh
ScriptDiskFname=datacollect_diskinfo.sh
ScriptDiskLogFname=datacollect_Disklog.sh
ScriptCAFname=datacollect_SubsysCA.sh
ScriptDiskFaultInfoFname=datacollect_diskfaultinfo.sh
S3LogDealFile="/opt/huawei/snas/bin/snas_log_deal.sh"
S3_CollectServiceType=0
DFS_CollectServiceType=0
Swift_CollectServiceType=0
S3LogtmpFile="/tmp/s3_log_tmp_file_$$"
currentpath=""

COMPONET_SCRIPT="$ScriptBaseFname $ScriptCaFname $ScriptMdsFname $ScriptObsFname $ScriptMonFname $ScriptIsmFname $ScriptPlatformFname $ScriptT3000Fname $ScriptNasFname $ScriptCmFname $ScriptConfigFname"

KEY_DATA_BK_DIR="/var/log/KeyData_Backup"
#DiskLogɵѹ
G_DISKLOG_PATH="/var/log/cm/DiskLog.zip" 
G_DISKLOG_PARM_FILE="/home/omuser/DiskLog_smartKit.ini"

#Ĭ0ʾ9000Ʒ1ʾudsƷ
ServiceType=0
. /opt/node_type_recognize.sh

#ɨ${BACKUP_DIR}Ŀ¼ļsizeС¼ڵȡһΣϵͳͨļȡӦϢ9000ļϵͳԪݲeg: OceanStorOS.log.2018-09-09_23.tar.gz ${BACKUP_DIR}/OceanStorOS.log.2018-09-09_23.tar.gz 6762
TMP_PATH_NEWWAY="${CMLogDir}../tmp"
LOG_INFO="${TMP_PATH_NEWWAY}/.dfs.log.info"

#Ҫļĳһֶνļб(ļ:ļֶε:ֶǷԵȺŵʽ)
SensitiveFieldList=(cipher.properties:factor:0  cm.ini:KeySec:0  cm.ini:deckey:0  cm.ini:EncPara:0  menu.lst:password:1  obs_sod.properties:kmsTrustStorePW:0 obs_sod.properties:kmsKeyStorePW:0  obs_sod.properties:jre_ca_certs_asp:0  obs_sod.hdb.properties:kmsTrustStorePW:0  obs_sod.hdb.properties:kmsKeyStorePW:0  obs_sod.ldb.properties:kmsTrustStorePW:0  obs_sod.ldb.properties:kmsKeyStorePW:0 \
POE.properties:ssl_keystore_pass:0  upf_adapter.properties:ks_defuser_pass:0  upf_adapter.properties:obs_svc_password:0  upf_adapter.properties:sso_user_pass:0  upf_adapter.properties:poe_ak:0  upf_adapter.properties:poe_sk:0)
#Ҫɾļб
SensitiveFileList=(cm_tool.ini cm_aum_man_user.ini)
#ؼб
OSKeyList="
phone number of the SM center
phone number of SM center
recipient phone number
email address
sender
recipient email address from
recipient phone number from
) to
"
#ÿһеĸʽΪ ƥһе#־йؼ#־λ
OMKeyList=(
'AuditLogWriteLogVa#email address#0'
'AuditLogWriteLogVa#email address from#0'
'AuditLogWriteLogVa#) to#0'
'AuditLogWriteLogVa#phone number from#0'
'AuditLogWriteLogVa#recipient phone number#0'
'AuditLogWriteLogVa#SM center#0'
'SendSMS#SMSCenterNo#0'
'SendSMS#SMSRecvNoList#0'
'ModifyReceiverList#acLevelAddrs#0'
'AddToReceiverList#acLevelAddrs#0'
'RemoveFromReceiverList#acLevelAddrs#0'
'ModifyReceiverList#acAddrs#0'
'AddToReceiverList#acAddrs#0'
'RemoveFromReceiverList#acAddrs#0'
'ModifyReceiverList#pcNewReceiver#0'
'AddToReceiverList#pcNewReceiver#0'
'RemoveFromReceiverList#pcNewReceiver#0'
'ModifyReceiverList#pcReceiverList#0'
'AddToReceiverList#pcReceiverList#0'
'RemoveFromReceiverList#pcReceiverList#0'
'ModifyReceiverList#pcReceiver#0'
'AddToReceiverList#pcReceiver#0'
'RemoveFromReceiverList#pcReceiver#0'
'ModifyReceiverList#pcOldReceiver#0'
'AddToReceiverList#pcOldReceiver#0'
'RemoveFromReceiverList#pcOldReceiver#0'
'DecodeSetAlarmSMSReceiver#acNewNumber#0'
'UpdateSmsReceiverList#acNewNumber#0'
'DecodeSetAlarmSMSReceiver#acOldNumber#0'
'UpdateSmsReceiverList#acOldNumber#0'
'UpdateSmsReceiverList#recevier list#0'
'UpdateEmailReceiverList#recevier list#0'
'DecodeSetAlarmSMS#acReceiverList#0'
'DecodeSetAlarmEmail#acReceiverList#0'
'SetAlmEmailCfgMsg#acReceiverList#0'
'SetAlmSmsCfgMsg#acReceiverList#0'
'DecodeSetAlarmSMS#acSMSC#0'
'SetAlmSmsCfgMsg#acSMSC#0'
'UpdateEmailReceiverList#acNewEmail#0'
'DecodeSetAlarmEmailReceiver#acNewEmail#0'
'DecodeSetAlarmEmailReceiver#acOldEmail#0'
'UpdateEmailReceiverList#acOldEmail#0'
'DecodeSetAlarmEmail#acSenderEmail#0'
'SetAlmEmailCfgMsg#acSenderEmail#0'
'AuditLogWriteLogVa#), sender#0'
'DoSendTstSmsThread#), sender#0'
'DoSendTstSmsThread#)->rcver#0'
'GetSMSCNoByUserSet#\[SMSC#0'
'DoSendTstEmailThread#,From#0'
'DoSendTstEmailThread#To#0'
'Multi_Modify_Operation#acUserContactInfo#0'
'SetSms_Operation#/SetSms_Operation/s/\(acAlarmCmd.*IP=[0-9a-fA-F.:]\+,\([0-9]\{1,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'acAlarmCmd.*IP.*SetSmsReceiverList_Operation#/SetSmsReceiverList_Operation/s/\(acAlarmCmd.*IP=[0-9a-fA-F.:]\+,\([0-9]\{1,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'acAlarmCmd.*IP.*SetEmail_Operation#/SetEmail_Operation/s/\(acAlarmCmd(\).*\().*\)/\1********\2/#1'
'acAlarmCmd.*IP.*SetEmailReceiverList_Operation#/SetEmailReceiverList_Operation/s/\(acAlarmCmd.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'acAlarmCmdTmp\(.*,[0-9a-zA-Z._-]+@[0-9a-zA-Z._-]+\)\].*Multi_Modify_Operation#/Multi_Modify_Operation/s/\(acAlarmCmdTmp.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'2000400213bc.*IP#s/\(2000400213bc.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'2000400213bd.*IP#s/\(2000400213bd.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'2000400213ba.*IP#s/\(2000400213ba.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'2000400213bb.*IP#s/\(2000400213bb.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'2000400213b8.*IP#s/\(2000400213b8.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'2000400213b9.*IP#s/\(2000400213b9.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'2000400213b6.*IP#s/\(2000400213b6.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'2000400213b7.*IP#s/\(2000400213b7.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'200040021063.*IP#s/\(200040021063.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'200040021064.*IP#s/\(200040021064.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'35185445966776.*IP#s/\(35185445966776.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(.*\)/\1*******\4/#1'
'35185445966777.*IP#s/\(35185445966777.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(,\?.*\)/\1*******\4/#1'
'35185445966780.*IP#s/\(35185445966780.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(,\?.*\)/\1*******\4/#1'
'35185445966781.*IP#s/\(35185445966781.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(,\?.*\)/\1*******\4/#1'
'35185445966778.*IP#s/\(35185445966778.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(,\?.*\)/\1*******\4/#1'
'35185445966779.*IP#s/\(35185445966779.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(,\?.*\)/\1*******\4/#1'
'35185445966774.*IP#s/\(35185445966774.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(,\?.*\)/\1*******\4/#1'
'35185445966775.*IP#s/\(35185445966775.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(,\?.*\)/\1*******\4/#1'
'35185445965923.*IP#s/\(35185445965923.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(,\?.*\)/\1*******\4/#1'
'35185445965924.*IP#s/\(35185445965924.*IP=[0-9a-fA-F.:]\+,\([0-9]\{0,2\},\)\?\)\([,;]\?[0-9+]\{7,\}\)\+\(,\?.*\)/\1*******\4/#1'
'2000400210f2.*IP.*@.*#s/\(2000400210f2.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'2000400210f3.*IP.*@.*#s/\(2000400210f3.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'200040021398.*IP.*@.*#s/\(200040021398.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'200040021399.*IP.*@.*#s/\(200040021399.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'2000400213c8.*IP.*@.*#s/\(2000400213c8.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'2000400213c9.*IP.*@.*#s/\(2000400213c9.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'2000400213be.*IP.*@.*#s/\(2000400213be.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'2000400213c0.*IP.*@.*#s/\(2000400213c0.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'2000400213c1.*IP.*@.*#s/\(2000400213c1.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'2000400213c2.*IP.*@.*#s/\(2000400213c2.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'2000400213c3.*IP.*@.*#s/\(2000400213c3.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'35185445966066.*IP.*@.*#s/\(35185445966066.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'35185445966067.*IP.*@.*#s/\(35185445966067.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'35185445966744.*IP.*@.*#s/\(35185445966744.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'35185445966745.*IP.*@.*#s/\(35185445966745.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'35185445966792.*IP.*@.*#s/\(35185445966792.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'35185445966793.*IP.*@.*#s/\(35185445966793.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'35185445966784.*IP.*@.*#s/\(35185445966784.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'35185445966785.*IP.*@.*#s/\(35185445966785.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'35185445966782.*IP.*@.*#s/\(35185445966782.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'35185445966783.*IP.*@.*#s/\(35185445966783.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'35185445966786.*IP.*@.*#s/\(35185445966786.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'35185445966787.*IP.*@.*#s/\(35185445966787.*IP=[0-9a-fA-F.:]\+,\([a-z0-9A-Z\._-]\+,\)*\)\([,;]\?[0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+\)\+\(.*\)/\1********\4/#1'
'v_pcParam#/v_pcParam/s/\(v_pcParam(\).*\().*\)/\1********\2/#1'
)

#ʽ: е#еĹؼ#־λ(1:޸ 0:ݹؼ޸)
ISMKeyList=(
'REMOVE_ALARM_SMS#REMOVE_ALARM_SMS#oldRecipientPhoneNumber#0'
'REMOVE_ALARM_EMAIL#REMOVE_ALARM_EMAIL#oldRecipientEmail#0'
'C=55847747654#C=55847747654#\({3,[0-9]*,S:\)\([+|%2B]\?[0-9]\+[,;]\?\)\+#1'
'C=55847747654#C=55847747654#\({4,[0-9]*,S:\)\([+|%2B]\?[0-9]\+[,;]\?\)\+#1'
'C=55847747641#C=55847747641#\({4,[0-9]*,S:\)\([+|%2B]\?[0-9]\+[,;]\?\)\+#1'
'C=56841469968#C=56841469968#\({6,[0-9]*,S:\)\([+|%2B]\?[0-9]\+[,;]\?\)\+#1'
'C=55847747642#C=55847747642#\({3,[0-9]*,S:\)\([+|%2B]\?[0-9]\+[,;]\?\)\+#1'
'C=55847747642#C=55847747642#\({4,[0-9]*,S:\)\([+|%2B]\?[0-9]\+[,;]\?\)\+#1'
'C=56841469969#C=56841469969#\({8,[0-9]*,S:\)\([+|%2B]\?[0-9]\+[,;]\?\)\+#1'
'C=56841469969#C=56841469969#\({6,[0-9]*,S:\)\([+|%2B]\?[0-9]\+[,;]\?\)\+#1'
'C=56841469970#C=56841469970#\({8,[0-9]*,S:\)\([+|%2B]\?[0-9]\+[,;]\?\)\+#1'
'C=55834583040{0,[0-9]+,E:202}#C=55834583040#\({73,[0-9]*,S:\)\([0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+[,;]\?\)\+#1'
'C=55834624000{0,[0-9]+,[a-zA-Z]+:202}#C=55834624000#\({73,[0-9]*,S:\)\([0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+[,;]\?\)\+#1'
'C=56841469965#C=56841469965#\({12,[0-9]*,S:\)\([0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+[,;]\?\)\+#1'
'C=55847747639#C=55847747639#\({1,[0-9]*,S:\)\([0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+[,;]\?\)\+#1'
'C=55847747640#C=55847747640#\({1,[0-9]*,S:\)\([0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+[,;]\?\)\+#1'
'C=55847747640#C=55847747640#\({7,[0-9]*,S:\)\([0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+[,;]\?\)\+#1'
'C=55847747653#C=55847747653#\({7,[0-9]*,S:\)\([0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+[,;]\?\)\+#1'
'C=55847747653#C=55847747653#\({1,[0-9]*,S:\)\([0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+[,;]\?\)\+#1'
'C=56841469967#C=56841469967#\({14,[0-9]*,S:\)\([0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+[,;]\?\)\+#1'
'C=56841469966#C=56841469966#\({12,[0-9]*,S:\)\([0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+[,;]\?\)\+#1'
'C=56841469966#C=56841469966#\({14,[0-9]*,S:\)\([0-9a-zA-Z\._-]\+@[0-9a-zA-Z\._-]\+[,;]\?\)\+#1'
)

function judge_product_type
{
    local value=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')
    if [ "80" = "$value" ];then
        ServiceType=1
        echo -e "[$(date "+%F %T")] ServiceType is uds" >> "${LOG_FILE}"
    fi
}

#===================================================
# ƣproduct_type
# ܣжϳ
# 
#===================================================
function product_type
{
    local NodeServiceType=""
    local value=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')
    #UDS
    if [ "X80" == "X${value}" ];then
        S3_CollectServiceType=1
        Collect_Product_Type="FusionStorage Object"
        log "${Collect_Product_Type}: CollectServiceType is FusionStorage Object"
    else
    #9000
        NodeServiceType=$(GetNodeServiceType)
        if [ $? -ne 0 ];then
            log "Get Node Service Type [$NodeServiceType] failed"
            exit 1
        fi
        if [ "X${NodeServiceType}" == "XS3Node" ];then
            S3_CollectServiceType=1
            Collect_Product_Type="S3"
            log "${Collect_Product_Type}: CollectServiceType is s3"
        elif [ "X${NodeServiceType}" == "XSwiftNode" ];then
            Swift_CollectServiceType=1
            Collect_Product_Type="SWIFT"
            log "${Collect_Product_Type}: CollectServiceType is swift"
        elif [ "${NodeServiceType}" == "FSNode" ];then
            DFS_CollectServiceType=1
            Collect_Product_Type="DFS"
            log "${Collect_Product_Type}: CollectServiceType is dfs"
        fi
    fi
}

#===================================================
# ƣsans.iniȡkeyӦvalue
# ܣ
# 1section 2key
#===================================================
function get_value_from_snas()
{
    local section=$1
    local key=$2
    local value=$(cat "/opt/huawei/snas/etc/snas.ini" |tr \\n ] |grep -Po '(?<=[[]'${section}'[]]).*' |tr ] \\n |grep -Po '(?<=^'${key}'=).*' |awk 'NR==1{print}')
    echo "${value}"
}

#===================================================
# ƣȡڵ
# ܣ
# 1section 2key
#===================================================
function get_node_service_type()
{
    local type=$(get_value_from_snas "NODE" "node_service_type")
    echo "${type}"
}

type=$(get_node_service_type)
BACKUP_DIR=""
if [ -n "${type}" -a "${type}" != "1"  ];then
    BACKUP_DIR=/mnt/s3fs/log/$(hostname)/archive*
else
    BACKUP_DIR=/mnt/fs/system/log/$(hostname)
fi

TIME_STAMP_PATTERN="\w{4}-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])_(0[0-9]|1[0-9]|2[0-4])(_\w{1,3}){0,1}"
CURRENT_TIME_DETAILF="$(date "+%Y-%m-%d %H:%M:%S")"
CURRENT_TIME=$(echo $CURRENT_TIME_DETAILF|awk -F ":" '{print $1}')
LOG_FS="/var/log"

SERVICE_TYPE=$(cat /opt/huawei/snas/etc/snas.ini |tr \\n ] |grep -Po '(?<=[[]'SYSTEM'[]]).*' |tr ] \\n |grep -Po '(?<=^'serviceType'=).*' |awk 'NR==1{print}' 2>/dev/null)

function adjustSize()
{
    used_size=$(du "${COLLECT_DIR}" | tail -n1 | cut -f1)
    let "TOTAL_SIZE=TOTAL_SIZE-used_size"
    return $?
}

#
function getWeights()
{
    sub=$1
    for i in $(seq 0 $(expr "${#SUB_SYSTEM[@]}" - 1))
    do
        if [ "${SUB_SYSTEM[$i]}" == "${sub}" ];then
            echo "${SUB_WEIGHTS[$i]}"
            return 0
        fi
    done
    echo 0
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

function getSize()
{
    sub=$1
    total_size=$2
    all_weights=0
    sub_size=0
    for i in ${SUB_TYPE//,/ }
    do
        weight=$(getWeights $i)
        let "all_weights=all_weights + weight"
    done
    sub_weight=$(getWeights "${sub}")
    if [ "${all_weights}" -eq 0 ];then
        sub_size=0
    else
        let "sub_size=total_size * sub_weight / all_weights"
    fi
    echo "${sub_size}"
}

log()
{
    echo -e "[$(date "+%F %T")][$$] ${@:1}" >> "${LOG_FILE}"
    return 0
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        log "[$FUNCNAME][$LINENO]:IP:$remote_ip,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#Զ첽ִУip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid="$$$2"
    local time_out=$3
    local cmd=$4
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
        local iRet=$?
        log "[$FUNCNAME][$LINENO]:IP:$remote_ip,le_pid:${le_pid},return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
    fi
    done
    return $iRet
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
        local iRet=$?
        if [ $iRet -eq 101 ]; then
            log "[$FUNCNAME] download ($remote_file) from ($remote_ip) to ($local_file) iRet:($iRet) time:$time"
            sleep 10
        else
            break
        fi
    done
    
    if [ $iRet -ne 0 ]; then
        log "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
    fi
    
    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        log "[$FUNCNAME] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi
    return $iRet
}

#ݽڵidȡһIP
function get_node_backnet_ip
{
    local nid=$1
    local temp=1
    local iRet=0
    local IpNum=0
    local BackendIp=""
    IpNum=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select COUNT(*) from (select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID);"`
    if [ "$IpNum" -eq 0 ]; then
        log "[$FUNCNAME][$LINENO]There is no back subnet IP of $nid in db"
        return 1
    fi

    while [ "$temp" -le "$IpNum" ]; 
    do
        BackendIp=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID limit $((temp - 1)), $temp;"`
        if [ "$BackendIp" = "" ]; then
            log "[$FUNCNAME][$LINENO] Get back ip of $nid failed"
            temp=$((temp + 1))
            continue
        else
            #try ping
            ping "${BackendIp}" -f -c 2 -w 2 >/dev/null 2>&1
            if [ $? -ne 0 ]; then
                temp=$((temp + 1))
                continue
            else
                break
            fi
        fi
    done
    echo ${BackendIp}
}


#===================================================
# ƣȡcm_conf.dbнڵӦĽڵ
# ܣͨڵĺIPݿȡڵ
# 
#===================================================
function get_node_hostname_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do
        sleep 1
        log "[$FUNCNAME][$LINENO]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 3 ];then
            temp=1
            break
        fi
    done
    temp=1
    local hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${hostname}" == "" ]]
    do
        sleep 1
        log "[$FUNCNAME][$LINENO]Failed to get node hostname from db ,temp=$temp"
        hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 3 ];then
            temp=1
            break
        fi
    done

    echo ${hostname}
}

MapDiskType()
{
    case $1 in
    0)
        echo "FC"
        ;;
    1)
        echo "SAS"
        ;;
    2)
        echo "SATA"
        ;;
    3)
        echo "SAS_SSD"
        ;;
    4)
        echo "NL_SAS"
        ;;
    5)
        echo "SLC_SSD"
        ;;
    6)
        echo "MLC_SSD"
        ;;
    15)
        echo "SMR_SATA"
        ;;
    16)
        echo "NVME_SSD"
        ;;
    17)
        echo "SATA_SSD"
        ;;
    *)
        echo "No this type"
        ;;
    esac
}

#=======================================================
# ƣʱʽת
# ܣ190919150000.949110ʽ
#           ת2019-09-19 15:00:00
# 
#=======================================================
function transTimeFormat()
{
    local tmp_time=$1
    local file_year=${tmp_time:0:2}
    local file_month=${tmp_time:2:2}
    local file_day=${tmp_time:4:2}
    local file_hour=${tmp_time:6:2}
    local file_min=${tmp_time:8:2}
    local file_sec=${tmp_time:10:2}
    
    echo "20${file_year}-${file_month}-${file_day} ${file_hour}:${file_min}:${file_sec}"
}

function getTimeZoneDiffSeconds()
{
    timeSeconds=$1
    curTimeZone="$(date +%z)"
    curTimeZoneSign="${curTimeZone:0:1}"
    curTimeZoneHour="${curTimeZone:1:2}"
    curTimeZoneMin="${curTimeZone:3:2}"
    diffSeconds=$(echo "${curTimeZoneHour} * 3600 + ${curTimeZoneMin} * 60" | bc)
    if [ "X${curTimeZoneSign}" == "X+" ];then
        timeSeconds=$(($timeSeconds - $diffSeconds))
    else
        timeSeconds=$(($timeSeconds + $diffSeconds))
    fi
    echo "${timeSeconds}"
}

function getSeconds()
{
    local secondsTime=0
    secondsTime=$(date -d "${@:1}" +%s)
	#ʱʱ䴦
    if [ $? -ne 0 ]; then
        log "[$FUNCNAME] Fail! Time para is ${@:1}"
        secondsTime=$(date -u -d "${@:1}" +%s)
        secondsTime=$(getTimeZoneDiffSeconds "${secondsTime}")
    fi
    echo "${secondsTime}"
}

#ȡ־
function GetYearTime()
{
    time="${@:1}"
    date -d "${time}" "+%Y-%m-%d"
}

#ȡ־
function GetOnlyYearTime()
{
    time="${@:1}"
    date -d "${time}" "+%Y"
}
function GetOnlyYearTime_y()
{
    time="${@:1}"
    date -d "${time}" "+%y"
}

#ȡ־
function GetMonthTime()
{
    time="${@:1}"
    date -d "${time}" "+%m"
}

#ȡ־
function GetDayTime()
{
    time="${@:1}"
    date -d "${time}" "+%d"
}

#ȡ־ʱ
function GetHourTime()
{
    time="${@:1}"
    date -d "${time}" "+%H"
}

#ȡ־
function GetMinuteTime()
{
    time="${@:1}"
    date -d "${time}" "+%M"
}

function diffTime()
{
    time1=$1
    time2=$2
    diff=0
    diff=$((($(getSeconds "${time2}")-$(getSeconds "${time1}"))/(60*60*24)))
    echo ${diff}
}

function getCurrentTime()
{
    local now_time=$(getSeconds "$(date "+%F %T")")
    echo $(date -d @"${now_time}" "+%Y-%m-%d %H:%M:%S")
}

function getTimeBeforeDays()
{
    time=$1
    days=$2
    seconds=$(($(getSeconds "${time}") - ${days}*24*60*60))
    echo $(date -d @${seconds} "+%Y-%m-%d %H:%M:%S")
}

function getTimeAfterDays()
{
    time=$1
    days=$2
    seconds=$(($(getSeconds "${time}") + ${days}*24*60*60))
    echo $(date -d @${seconds} "+%Y-%m-%d %H:%M:%S")
}

function plusHour()
{
    time="${@:1}"
    new_time=$(($(getSeconds "${time}") + 60 * 60))
    echo $(date -d @${new_time} "+%Y-%m-%d %H:%M:%S")
}

function getTimeStamp()
{
    time="${@:1}"
    date -d "${time}" "+%Y-%m-%d_%H"
}

function getTimeStampDay()
{
    time="${@:1}"
    date -d "${time}" "+%Y-%m-%d"
}

function caculateSizeOfFile()
{
    file=$1
    [ -f "${file}" ] && (ls -l ${file} 2>>/dev/null| cut -d' ' -f 5) || echo 0
}

function ddFile()
{
    infile=$1
    size=$2
    outfile="${infile}".out
    file_size=$(caculateSizeOfFile "${infile}")
    if [ -z "${file_size}" ];then
        return 1
    fi

    if [ "${file_size}" -lt "${size}" ];then
        return 1
    fi

    over_size=0
    let "over_size=file_size-size"
    if [ "${over_size}" -eq 0 ];then
        return 0
    fi
    log "infile=${infile};over_size=${over_size}"
    dd if=${infile} of=${outfile} skip=1 bs=${over_size}
    rm -rf "${infile}"
    mv ${outfile} ${infile} >/dev/null 2>&1
}

function caculateSizeOfDir()
{
    path=$1
    cd "${path}"
    size=0
    for file in $(ls)
    do
        file_size=$(caculateSizeOfFile "${file}")
        let "size=size+file_size"
    done
    echo $size
}

function isMainNode()
{
    local SubDomainNum=$(cat /opt/huawei/snas/etc/cm.ini |grep SubDomain|awk -F "=" '{print $2}')
    if [ "${SubDomainNum}" != "0" ]; then
        return 1
    fi
    local omip=$(cat /opt/huawei/snas/etc/cm.ini |grep omip|awk -F "=" '{print $2}')
    if [ -z "${omip}" ]; then
        return 1
    fi
    local virtualDevice=$(ip addr show|grep -w "${omip}"|awk -F " " '{print $NF}')
    if [ -z "${virtualDevice}" ]; then
        return 1
    fi
    return 0
}

#kill ָ
function killProc()
{
    local procList="datacollect_local.sh datacollect_Disklog.sh"
    local pidList=""
    local pid=""
    local childPid=""

    for proc in ${procList[*]}
    do
        pidList=$(ps -efww | egrep "[/ ](${proc}$|${proc} )" | grep -v grep | grep -v kill |  grep -v $$ | grep -v '/bin/sh -c' | grep -v "sudo"| grep -v "localexec" |awk '{print $2}')
        for pid in ${pidList}
        do
            childPid=$(ps -efww | grep $pid | awk '{if($3=='$pid') print $2}')
            kill -9 ${pid}
            for index in ${childPid}
            do
                grandsonPid=$(ps -efww | grep ${index} | awk '{if($3=='${index}') print $2}')
                kill -9 ${index}
                for index_i in ${grandsonPid}
                do
                    kill -9 ${index_i}
                    log "Kill old child proc ${index_i}"
                done
            done
        done
    done

    ps -efww | grep "zip -qr" | grep "${DATA_REMOTE_FileName}" | grep -v grep | grep -v kill >> ${LOG_FILE}
    zipPid=$(ps -efww | grep "zip -qr" | grep "${DATA_REMOTE_FileName}" | grep -v grep | grep -v kill | awk '{print $2}')
    if [ -z "${zipPid}" ];then
        log "Zip proc is not running."
    fi

    for i in ${zipPid}
    do
        kill -9 $i
        log "Kill zip proc $i"
    done
    rm -rf ${COLLECT_DIR}/*
    log "clean ${COLLECT_DIR}/*"

    #killʱ,localexecprocΪ100,ֹpidϵͳú,localexecΪִ.
    local le_proc_file="/var/log/le_tmp/getdatacollect.proc"
    [ -f ${le_proc_file} ] && sed -i "s/Progress:.*/Progress: 100/g" ${le_proc_file}
}

function killOldChildproc()
{
    local procList="datacollect_local.sh"
    local pid
    local childPid
    for proc in ${procList[*]}
    do
        ps -efww | grep $proc | grep -v grep | grep -v kill | grep -v $$ | grep -v '/bin/sh -c' | grep -v "localexec"
        pid=$(ps -efww | grep $proc | grep -v grep | grep -v kill |  grep -v $$ | grep -v '/bin/sh -c' | grep -v "localexec" |awk '{print $2}')
        childPid=$(ps -efww | grep $pid | awk '{if($3=='$pid') print $2}')
        for i in ${pid}
        do
            kill -9 $i
            log "Kill old proc $i"
        done
        for i in ${childPid}
        do
            kill -9 $i
            log "Kill old child proc $i"
        done
    done
}

#ļ
function addRecToIni()
{
    local new_create=$1
    shift
    local others=$@
    local myDir=`dirname $0`
    local ini_file=$myDir/collect.ini

    if [ "1" == $new_create ];then
        echo "$others" > $ini_file
    else
        if [ ! -f $ini_file ];then
            log "ERROR: in addRecToIni, ini file $ini_file not exist!"
            return 1
        fi
        echo "$others" >> $ini_file
    fi
    return $?
}

#ֶΣɾдµļ¼
function updRecToIni()
{
    local key=$1
    shift
    local rec=$@
    local myDir=`dirname $0`
    local ini_file=$myDir/collect.ini

    if [ -f $ini_file ] && [ ! -z "$key" ];then
        sed -i -e /"${key}"/d $ini_file
    fi
    echo $rec >> $ini_file
    return $?
}

#
function getFromIni()
{
    local myDir=`dirname $0`
    local ini_file=$myDir/collect.ini
    local tmp=""
    local key=""

    tmp=`grep "LOCAL_IP=" $ini_file`
    key=`echo ${tmp##*=}`
    if [ "$key" == "" ];then
        log "get LOCAL_IP from $ini_file fail"
        return 1
    fi
    LOCAL_IP=$key

    tmp=`grep "TIME_START=" $ini_file`
    key=`echo ${tmp##*=}`
    if [ "$key" == "" ];then
        log "get TIME_START from $ini_file fail"
        return 2
    fi
    TIME_START=$key

    tmp=`grep "TIME_END=" $ini_file`
    key=`echo ${tmp##*=}`
    if [ "$key" == "" ];then
        log "get TIME_END from $ini_file fail"
        return 2
    fi
    TIME_END=$key

    tmp=`grep "SUB_TYPE=" $ini_file`
    key=`echo ${tmp##*=}`
    if [ "$key" == "" ];then
        log "get SUB_TYPE from $ini_file fail"
        return 4
    fi
    SUB_TYPE=$key

    tmp=`grep "TOTAL_SIZE=" $ini_file`
    key=`echo ${tmp##*=}`
    if [ "$key" == "" ];then
        log "get TOTAL_SIZE from $ini_file fail"
        return 5
    fi
    let "TOTAL_SIZE=$key"

    tmp=`grep "FS_FLAG=" $ini_file`
    key=`echo ${tmp##*=}`
    if [ "$key" == "" ];then
        log "get FS_FLAG= from $ini_file fail"
        return 6
    fi
    fileSystemFlag=$key
    return 0
}

function getAvailableSize()
{
    total_size=$(df "${LOG_FS}" -k | grep "/var"| awk '{print $2}')
    used_size=$(df "${LOG_FS}" -k | grep "/var"| awk '{print $3}')
    avail_size=$(df "${LOG_FS}" -k | grep "/var"| awk  '{print $4}')
    left_size=$((${total_size} - ${used_size} - ${avail_size}))
    available_size=$(echo "scale=2;(${total_size}*0.9 - ${used_size} - ${left_size})*1024" | bc)
    echo ${available_size}
}

function getHour()
{
    time=$1
    time_seconds=$(getSeconds "${time}")
    hour_time=$(date -d "${time}" "+%Y-%m-%d %H")
    hour_time_seconds=$(getSeconds "${hour_time}")
    time=$(date -d @${hour_time_seconds} "+%Y-%m-%d %H:%M:%S")
    echo ${time}
}

#ȡǰһСʱʱ
function getHourBef()
{
    time=$1
    time_seconds=$(getSeconds "${time}")
    hour_time=$(date -d "${time}" "+%Y-%m-%d %H")
    hour_time_seconds=$(getSeconds "${hour_time}")
    time_seconds=$((${hour_time_seconds} - 1*60*60))
    time=$(date -d @${time_seconds} "+%Y-%m-%d %H:%M:%S")
    echo ${time}
}

#ȡһСʱʱ
function getHourAtf()
{
    time=$1
    time_seconds=$(getSeconds "${time}")
    hour_time=$(date -d "${time}" "+%Y-%m-%d %H")
    hour_time_seconds=$(getSeconds "${hour_time}")
    time_seconds=$((${hour_time_seconds} + 1*60*60))
    time=$(date -d @${time_seconds} "+%Y-%m-%d %H:%M:%S")
    echo ${time}
}

#ȡյ
function getDay()
{
    time=$1
    time_seconds=$(getSeconds "${time}")
    hour_time=$(date -d "${time}" "+%Y-%m-%d")
    hour_time_seconds=$(getSeconds "${hour_time}")
    time=$(date -d @${hour_time_seconds} "+%Y-%m-%d %H:%M:%S")
    echo ${time}
}

function getLogFile()
{
    sub=$1
    for i in $(seq 0 $(expr "${#SUB_SYSTEM[@]}" - 1))
    do
        if [ "${SUB_SYSTEM[$i]}" == "${sub}" ];then
            if [ -n "${SUB_LOG[$i]}" ];then
                echo "/var/log/""${SUB_LOG[$i]}"
            else
                echo ""
            fi
        fi
    done
    return 0
}

function clean()
{
    rm -rf ${CMLogDir}
    rm -f ${DATA_REMOTE_FileName}
    rm -rf /var/log/cm/*
    log "clean files"
}

function prepare()
{
    getFromIni
    return $?
}

#ļ
function CreateCollectDir()
{
    local Master_Node=""
    local result=""
    local tmpMasterNode="/tmp/collect_master_node.txt"
    #ڵɾļ
    /usr/local/bin/MmlBatch 4016 "cm master" >$tmpMasterNode
    result=$?
    if [ ${result} -ne 0 ];then
        log "get master node name failed"
    fi
    #MMLִн޷ֱdos2unixҪ
    sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $tmpMasterNode 2>&1

    /usr/bin/dos2unix $tmpMasterNode
	
    Master_Node=`cat $tmpMasterNode | grep "^Node Name" | awk -F":" '{print $2}' | tr -d ' '`
    if [ "X${Master_Node}" != "X$(hostname)" ] && [ ${result} -eq 0 ];then
        rm -rf /var/log/cm/*
        log "rm -rf /var/log/cm/*"
    fi
    rm $tmpMasterNode

    if [ -d "$CMLogDir" ];then
        rm -rf "$CMLogDir""*" >/dev/null 2>&1
        log "start del dir $CMLogDir"
    else
        mkdir -p "$CMLogDir"
        log "mkdir $CMLogDir"
    fi

    mkdir -p "$CMLogDir""Config"
    mkdir -p "$CMLogDir""Event"
    mkdir -p "$CMLogDir""Messages"
    mkdir -p "$CMLogDir""Other"
    mkdir -p "$CMLogDir""Other/Stack"
    mkdir -p "$CMLogDir""Kbox"
}

#жǷΪCMڵ
function isCMMainNode()
{
    local SubDomainNum=$(cat /opt/huawei/snas/etc/cm.ini |grep SubDomain|awk -F "=" '{print $2}')
    if [ "${SubDomainNum}" != "0" ]; then
        return 1
    fi
    local omip=$(cat /opt/huawei/snas/etc/cm.ini |grep omip|awk -F "=" '{print $2}')
    if [ -z "${omip}" ]; then
        return 1
    fi
    local virtualDevice=$(ip addr show|grep -w "${omip}"|awk -F " " '{print $NF}')
    if [ -z "${virtualDevice}" ]; then
        return 1
    fi
    return 0
}

function clloectVmmsUVPLog()
{
    local sub_path="${MessageDir}OM/VmmsUVP"
    mkdir -p ${sub_path}
    if [ "$SERVICE_TYPE" == "vm" ];then
        log "collet UVPLog"
        cp -f /var/log/openvswitch/ovs-vswitchd.log  $sub_path  >/dev/null 2>&1
        cp -f /var/log/openvswitch/ovsdb-server.log      $sub_path  >/dev/null 2>&1
        cp -f /var/log/evs   $sub_path  >/dev/null 2>&1
        cp -f /var/log/dpdk/dpdk.log                     $sub_path  >/dev/null 2>&1
        cp -f /var/log/UVPHostd.log   $sub_path  >/dev/null 2>&1
        cp -f /var/log/hirmd.log      $sub_path  >/dev/null 2>&1
        cp -f /var/log/libvirt/libvirtd.log  $sub_path  >/dev/null 2>&1
        cp -rf /var/log/libvirt/qemu/* $sub_path  >/dev/null 2>&1
    else
        log "SERVICE_TYPE is not vm"
    fi
}

function collectCurrentLog()
{
    local sub_path=""
    local files=""
    local file=""
    local sub=$1
    local cpfile=""
    sub_path=${MessageDir}${sub}
    mkdir -p ${sub_path}
    if [ "${sub}" == "DeviceManager_ToolKit" ]; then
        cd /var/log/ISM
        files=$(ls ./|grep -v ".tar.gz")
        cp -fp ${files}  ${sub_path}  >/dev/null 2>&1
    elif [ "${sub}" == "OceanStorOS" ]; then
        cd /var/log/platform
        files=$(ls -l ./ |grep -v "^d"|grep -v "tar\.gz$"|awk -F " " '{print $9}')
        for file in ${files[*]}
        do
            cp -fpr ${file} ${sub_path}  >/dev/null 2>&1
        done
        cd /var/log
        for file in ${Collect_OceanStorOS_Log} ${Collect_OceanStorOS_Other_Log}
        do
            cp -fpr ${file}* ${sub_path}  >/dev/null 2>&1
        done
    elif [ "${sub}" == "OM" ]; then
        cd /var/log
        files=${Collect_OM_Log}
        for file in ${files}
        do
            cp -fpr ${file}* "${sub_path}" >/dev/null 2>&1
        done
    elif [ "${sub}" == "MON_BJM" ]; then
        cd /var/log
        files=${Collect_MONBJM_Log}
        for file in ${files}
        do
            cp -fpr ${file}* "${sub_path}" >/dev/null 2>&1
        done
    elif [ "${sub}" == "DFS_OBS" ]; then
        cd /var/log
        for file in ${Collect_DFSOBS_Log}
        do
            cp -fpr ${file}* "${sub_path}" >/dev/null 2>&1
        done
    elif [ "${sub}" == "RPCUser" ]; then
        cd /var/log
        files=${Collect_RPC_Log}
        for file in ${files}
        do
            cp -fpr ${file}* "${sub_path}" >/dev/null 2>&1
        done
    elif [ "${sub}" == "OS" ]; then
        cd /var/log/
        files=${Collect_OS_Log}
        for file in ${files}
        do
            cp -fpr ${file}* "${sub_path}" >/dev/null 2>&1
        done
    elif [ "${sub}" == "OSS" ]; then
        cd /var/log/s3/servicelog/
        cp -fpr /var/log/s3/servicelog ${sub_path} >/dev/null 2>&1
        rm -f ${sub_path}/servicelog/osc/obs.access.log* >/dev/null 2>&1
        cp -fpr /var/log/s3/scriptlog ${sub_path} >/dev/null 2>&1
        cd /var/log
        files=${Collect_OSS_Log}
        for file in ${files}
        do
            cp -fpr ${file}* "${sub_path}" >/dev/null 2>&1
        done
    elif [ "${sub}" == "WorkLoad" ]; then
        cd /var/log/
        cp -fpr /var/log/snas_workload* ${sub_path} >/dev/null 2>&1
    elif [ "${sub}" == "Hardware" ]; then
        sleep 1
    elif [ "${sub}" == "Access" ]; then
        cp -fpr /var/log/s3/servicelog/osc/obs.access.log* ${sub_path}  >/dev/null 2>&1
    elif [ "${sub}" == "Gaussdb" ]; then
        cp -rf /var/uds/user/data_upf/pg_log/* ${sub_path}/upf_gaussdbLog/ >/dev/null 2>&1
        cp -rf /var/uds/user/data_mdc/pg_log/* ${sub_path}/mdc_gaussdbLog/ >/dev/null 2>&1
        cp -rf /var/uds/user/data_upf/pg_blackbox/* ${sub_path}/upf_gaussdbLog/ >/dev/null 2>&1
        cp -rf /var/uds/user/data_mdc/pg_blackbox/* ${sub_path}/mdc_gaussdbLog/ >/dev/null 2>&1
    elif [ "${sub}" == "snas_CA" ]; then
        cd /var/log/
        cp -fpr /var/log/snas_CA* ${sub_path} >/dev/null 2>&1
    else
       log_path=$(dirname $(getLogFile ${sub}))
       [ -d "${log_path}" ] && cp -fpr ${log_path}/*  ${sub_path}
       cd ${sub_path}
       merge_file_pattern="${sub}\.log\.${TIME_STAMP_PATTERN}$"
       split_file_pattern="${sub}\.log(.\w{1,2}){0,1}$"

       for file in $(ls | egrep "${merge_file_pattern}")
       do
           ls | egrep "${split_file_pattern}" | xargs -I{} rm -rf {}
           rm -rf ${file}.tar.gz >/dev/null 2>&1
           tar czf ${file}.tar.gz ${file} >/dev/null 2>&1 && rm -rf ${file} >/dev/null 2>&1
       done
    fi
    return 0
}

#·ת
function RenameMonth()
{
    local month=$1
    local monthEn=(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec)
    local monthDigit=(01 02 03 04 05 06 07 08 09 10 11 12)
    local index=0

    for index in 0 $(seq 11)
    do
        if [ ${month} -ge 0 ] >/dev/null 2>&1;then
            if [ ${month} -eq ${monthDigit[$index]} ];then
                echo ${monthEn[$index]}
            fi
        else
            if [ "X${month}" == "X${monthEn[$index]}" ];then
                echo ${monthDigit[$index]}
            fi
        fi
    done
}

#ȡҪȡĿʼʱ
function GetCutOutStartTime()
{
    file=$1
    year=$2
    hour=$3
    minute=$4
    HourFlag=""
    MinFlag=""

    OnlyYear=$(GetOnlyYearTime "${year}")
    OnlyYear_y=$(GetOnlyYearTime_y "${year}")
    month=$(GetMonthTime "${year}")
    day=$(GetDayTime "${year}")
    #ж־СʱǷ
    for index in 0 $(seq 23)
    do
        if [ "$(getSeconds "${year} ${index}")" -le "$(getSeconds "${year} ${hour}")" ];then
            if [ ${index} -lt 10 ];then
                tmp_index="0${index}"
            else
                tmp_index=${index}
            fi
            grep -E "^.${OnlyYear}.${month}.${day}.${tmp_index}|^${OnlyYear}${month}${day}.${tmp_index}|^.${OnlyYear_y}${month}${day}${tmp_index}|^${OnlyYear}.${month}.${day}.${tmp_index}|^.${OnlyYear}-${month}-${day}-${tmp_index}" ${file} >/dev/null 2>&1
            result=$?
            if [ ${result} -eq 0 ];then
                if [ ${index} -lt 10 ];then
                    HourFlag="0${index}"
                else
                    HourFlag=${index}
                fi
            fi
        fi
    done
    if [ "X${HourFlag}" != "X" ];then
        #ж־Ƿ
        for index in 0 $(seq 59)
        do
            if [ "$(getSeconds "${year} ${HourFlag}:${index}")" -le "$(getSeconds "${year} ${hour}:${minute}")" ];then
                if [ ${index} -lt 10 ];then
                    tmp_index="0${index}"
                else
                    tmp_index=${index}
                fi
                grep -E "^.${OnlyYear}.${month}.${day}.${HourFlag}:${tmp_index}|^${OnlyYear}${month}${day}.${HourFlag}:${tmp_index}|^.${OnlyYear_y}${month}${day}${HourFlag}${tmp_index}|^${OnlyYear}.${month}.${day}.${HourFlag}:${tmp_index}|^.${OnlyYear}-${month}-${day}-${HourFlag}:${tmp_index}" ${file} >/dev/null 2>&1
                result=$?
                if [ ${result} -eq 0 ];then
                    if [ ${index} -lt 10 ];then
                        MinFlag="0${index}"
                    else
                        MinFlag=${index}
                    fi
                fi
            fi
        done
    fi
    echo "${HourFlag}:${MinFlag}"
}

#ȡҪȡĽʱ
function GetCutOutEndTime()
{
    local file=$1
    local year=$2
    local hour=$3
    local minute=$4
    local HourFlag=""
    local MinFlag=""

    OnlyYear=$(GetOnlyYearTime "${year}")
    OnlyYear_y=$(GetOnlyYearTime_y "${year}")
    month=$(GetMonthTime "${year}")
    day=$(GetDayTime "${year}")
    #ж־СʱǷ
    for index in 0 $(seq 23)
    do
        if [ "$(getSeconds "${year} ${index}")" -ge "$(getSeconds "${year} ${hour}")" ];then
            if [ ${index} -lt 10 ];then
                tmp_index="0${index}"
            else
                tmp_index=${index}
            fi
            grep -E "^.${OnlyYear}.${month}.${day}.${tmp_index}|^${OnlyYear}${month}${day}.${tmp_index}|^.${OnlyYear_y}${month}${day}${tmp_index}|^${OnlyYear}.${month}.${day}.${tmp_index}|^.${OnlyYear}-${month}-${day}-${tmp_index}" ${file} >/dev/null 2>&1
            result=$?
            if [ ${result} -eq 0 ];then
                if [ ${index} -lt 10 ];then
                    HourFlag="0${index}"
                else
                    HourFlag=${index}
                fi
            break
            fi
        fi
    done
    if [ "X${HourFlag}" != "X" ];then
        #ж־Ƿ
        for index in 0 $(seq 59)
        do
            if [ "$(getSeconds "${year} ${HourFlag}:${index}")" -ge "$(getSeconds "${year} ${hour}:${minute}")" ];then
                if [ ${index} -lt 10 ];then
                    tmp_index="0${index}"
                else
                    tmp_index=${index}
                fi
                grep -E "^.${OnlyYear}.${month}.${day}.${HourFlag}:${tmp_index}|^${OnlyYear}${month}${day}.${HourFlag}:${tmp_index}|^.${OnlyYear_y}${month}${day}${HourFlag}${tmp_index}|^${OnlyYear}.${month}.${day}.${HourFlag}:${tmp_index}|^.${OnlyYear}-${month}-${day}-${HourFlag}:${tmp_index}" ${file} >/dev/null 2>&1
                result=$?
                if [ ${result} -eq 0 ];then
                    if [ ${index} -lt 10 ];then
                        MinFlag="0${index}"
                    else
                        MinFlag=${index}
                    fi
                break
                fi
            fi
        done
    fi
    echo "${HourFlag}:${MinFlag}"
}

#ݿʼʱȡļ־
function getTarLogByStartTime()
{
    local TarFile=$1
    local TmpDir=$2
    local FileNameList=$3
    local FirstTime=$4
    local system_type=$5
    local OMLogNuTmp=""
    local OMLogNu=""
    local TarName=""
    local count=0

     cd ${TmpDir}
    #Ͱлȡļ·ִļϵͳȡļʹͰȡļ
    echo "${TarFile}" | grep '/' >/dev/null 2>&1
    if [ $? -eq 0 ];then
        cp ${TarFile} ${TmpDir} >/dev/null 2>&1
    else
        ${S3LogDealFile} --option=get --nodeName=$(hostname) --fileName=${TarFile} --desDir=${TmpDir} >/dev/null 2>&1
    fi
    tar -zxf *.tar.gz >/dev/null 2>&1
    TarName=`ls *.tar.gz 2>>/dev/null`
    rm *.tar.gz
    if [ "X${system_type}" == "XDeviceManager_ToolKit" ];then
        cd var/log/ISM
    elif [ "X${system_type}" == "XOceanStorOS" ];then
        echo ${TarName} | grep "platform.log" >/dev/null 2>&1
        if [ $? -eq 0 ];then
            cd var/log/platform
        fi
    fi

    files=$(ls -l ./ | grep -v ".tar.gz$" | awk -F " " '{print $9}')
    for file in ${files[*]}
    do
        #ݵͰ汾־ɾ־
        if [ "X${system_type}" == "XOceanStorOS"  -o "X${system_type}" == "XDFS_OBS" ];then
            echo ${TarName} | grep "snas.log" >/dev/null 2>&1
            if [ $? -eq 0 ];then
                echo ${file} | grep -E "${FileNameList}" >/dev/null 2>&1
                if [ $? -ne 0 ];then
                    rm ${file}
                    continue
                fi
            fi
        else
            echo ${file} | grep -E "${FileNameList}" >/dev/null 2>&1
            if [ $? -ne 0 ];then
                rm ${file}
                continue
            fi
        fi

        year=$(GetYearTime "${FirstTime}")
        OnlyYear=$(GetOnlyYearTime "${FirstTime}")
        OnlyYear_y=$(GetOnlyYearTime_y "${FirstTime}")
        month=$(GetMonthTime "${FirstTime}")
        day=$(GetDayTime "${FirstTime}")
        hour=$(GetHourTime "${FirstTime}")
        minute=$(GetMinuteTime "${FirstTime}")
        grep -E "^.${OnlyYear}.${month}.${day}|^${OnlyYear}${month}${day}|^.${OnlyYear_y}${month}${day}|^${OnlyYear}.${month}.${day}|^.${OnlyYear}-${month}-${day}"  ${file} >/dev/null 2>&1
        result=$?
        if [ ${result} -eq 0 ];then
            HourMin=$(GetCutOutStartTime "${file}" "${year}" "${hour}" "${minute}")
            if [ "X${HourMin}" != "X:" ];then
                true_Hour=`echo ${HourMin} | awk -F":" '{print $1}'`
                true_Min=`echo ${HourMin} | awk -F":" '{print $2}'`
                OMLogNuTmp=`cat ${file} | grep -nE "^.${OnlyYear}.${month}.${day}.${HourMin}|^${OnlyYear}${month}${day}.${HourMin}|^.${OnlyYear_y}${month}${day}${true_Hour}${true_Min}|^${OnlyYear}.${month}.${day}.${HourMin}|^.${OnlyYear}-${month}-${day}-${HourMin}" | sort -n | head -1 | awk -F":" '{print $1}'`
                #ɾ
                let "OMLogNu=${OMLogNuTmp}-1"
                if [ ${OMLogNu} -ne 0 ];then
                    sed -i "1,${OMLogNu}d" ${file}
                fi
            fi
        fi
        count=1
    done

    cd ${TmpDir}
    #жѹǷҪ־
    if [ ${count} -eq 1 ];then
        tar -zcf ${TarName} ./ >/dev/null 2>&1
    fi
}

#ռ־ʼʱͽʱһ־
function getOneTarLogByTime()
{
    local TarFile=$1
    local TmpDir=$2
    local FileNameList=$3
    local StartTime=$4
    local EndTime=$5
    local system_type=$6
    local OMStartTimeNumTmp=""
    local OMStartTimeNum=""
    local OMEndTimeNumTmp=""
    local OMEndTimeNum=""
    local OMLogAllNum=""
    local TarName=""
    local count=0

    cd ${TmpDir}
    #Ͱлȡļ·ִļϵͳȡļʹͰȡļ
    echo "${TarFile}" | grep '/' >/dev/null 2>&1
    if [ $? -eq 0 ];then
        cp ${TarFile} ${TmpDir} >/dev/null 2>&1
    else
        ${S3LogDealFile} --option=get --nodeName=$(hostname) --fileName=${TarFile} --desDir=${TmpDir} >/dev/null 2>&1
    fi
    tar -zxf *.tar.gz >/dev/null 2>&1
    TarName=`ls *.tar.gz 2>>/dev/null`
    rm *.tar.gz

    if [ "X${system_type}" == "XDeviceManager_ToolKit" ];then
        cd var/log/ISM
    elif [ "X${system_type}" == "XOceanStorOS" ];then
        echo ${TarName} | grep "platform.log" >/dev/null 2>&1
        if [ $? -eq 0 ];then
            cd var/log/platform
        fi
    fi

    files=$(ls -l ./ | grep -v ".tar.gz$" | awk -F " " '{print $9}')
    for file in ${files[*]}
    do
        #ݵͰ汾־ɾ־
        if [ "X${system_type}" == "XOceanStorOS"  -o "X${system_type}" == "XDFS_OBS" ];then
            echo ${TarName} | grep "snas.log" >/dev/null 2>&1
            if [ $? -eq 0 ];then
                echo ${file} | grep -E "${FileNameList}" >/dev/null 2>&1
                if [ $? -ne 0 ];then
                    rm ${file}
                    continue
                fi
            fi
        else
            echo ${file} | grep -E "${FileNameList}" >/dev/null 2>&1
            if [ $? -ne 0 ];then
                rm ${file}
                continue
            fi
        fi

        start_OnlyYear_y=$(GetOnlyYearTime_y "${StartTime}")
        start_year=$(GetYearTime "${StartTime}")
        start_OnlyYear=$(GetOnlyYearTime "${StartTime}")
        start_month=$(GetMonthTime "${StartTime}")
        start_day=$(GetDayTime "${StartTime}")
        start_hour=$(GetHourTime "${StartTime}")
        start_minute=$(GetMinuteTime "${StartTime}")

        end_year=$(GetYearTime "${EndTime}")
        send_OnlyYear_y=$(GetOnlyYearTime_y "${EndTime}")
        end_OnlyYear=$(GetOnlyYearTime "${EndTime}")
        end_month=$(GetMonthTime "${EndTime}")
        end_day=$(GetDayTime "${EndTime}")
        end_hour=$(GetHourTime "${EndTime}")
        end_minute=$(GetMinuteTime "${EndTime}")

        grep -E "^.${start_OnlyYear}.${start_month}.${start_day}|^${start_OnlyYear}${start_month}${start_day}|^.${start_OnlyYear_y}${start_month}${start_day}|^${start_OnlyYear}.${start_month}.${start_day}|^.${start_OnlyYear}-${start_month}-${start_day}" ${file} >/dev/null 2>&1
        result=$?
        if [ ${result} -eq 0 ];then
            HourMin=$(GetCutOutStartTime "${file}" "${start_year}" "${start_hour}" "${start_minute}")
            if [ "X${HourMin}" != "X:" ];then
                true_Hour=`echo ${HourMin} | awk -F":" '{print $1}'`
                true_Min=`echo ${HourMin} | awk -F":" '{print $2}'`
                OMStartTimeNumTmp=`cat ${file} | grep -nE "^.${start_OnlyYear}.${start_month}.${start_day}.${HourMin}|^${start_OnlyYear}${start_month}${start_day}.${HourMin}|^.${start_OnlyYear_y}${start_month}${start_day}${true_Hour}${true_Min}|^${start_OnlyYear}.${start_month}.${start_day}.${HourMin}|^.${start_OnlyYear}-${start_month}-${start_day}-${HourMin}" | sort -n | head -1 | awk -F":" '{print $1}'`
                #ɾ
                let "OMStartTimeNum=${OMStartTimeNumTmp}-1"
                if [ ${OMStartTimeNum} -ne 0 ];then
                    sed -i "1,${OMStartTimeNum}d" ${file}
                fi
            fi
            HourMin=$(GetCutOutEndTime "${file}" "${end_year}" "${end_hour}" "${end_minute}")
            if [ "X${HourMin}" != "X:" ];then
                true_Hour=`echo ${HourMin} | awk -F":" '{print $1}'`
                true_Min=`echo ${HourMin} | awk -F":" '{print $2}'`
                OMEndTimeNumTmp=`cat ${file} | grep -nE "^.${end_OnlyYear}.${end_month}.${end_day}.${HourMin}|^${end_OnlyYear}${end_month}${end_day}.${HourMin}|^.${send_OnlyYear_y}${end_month}${end_day}${true_Hour}${true_Min}|^${end_OnlyYear}.${end_month}.${end_day}.${HourMin}|^.${end_OnlyYear}-${end_month}-${end_day}-${HourMin}" | sort -n | tail -1 | awk -F":" '{print $1}'`
                OMLogAllNum=`cat ${file} | wc -l`
                let "OMEndTimeNum=${OMEndTimeNumTmp}+1"
                if [ ${OMEndTimeNum} -lt ${OMLogAllNum} ];then
                    sed -i "${OMEndTimeNum},${OMLogAllNum}d" ${file}
                fi
            fi
        fi
        count=1
    done

    cd ${TmpDir}
    #жѹǷҪ־
    if [ ${count} -eq 1 ];then
        tar -zcf ${TarName} ./ >/dev/null 2>&1
    fi
}
#ݽʱȡļ־
function getTarLogByEndTime()
{
    local TarFile=$1
    local TmpDir=$2
    local FileNameList=$3
    local EndTime=$4
    local system_type=$5
    local OMLogNuTmp=""
    local OMAllLogNum=""
    local OMLogNu=""
    local TarName=""
    local count=0

    cd ${TmpDir}
    #Ͱлȡļ·ִļϵͳȡļʹͰȡļ
    echo "${TarFile}" | grep '/' >/dev/null 2>&1
    if [ $? -eq 0 ];then
        cp ${TarFile} ${TmpDir} >/dev/null 2>&1
    else
        ${S3LogDealFile} --option=get --nodeName=$(hostname) --fileName=${TarFile} --desDir=${TmpDir} >/dev/null 2>&1
    fi
    tar -zxf *.tar.gz
    TarName=`ls *.tar.gz 2>>/dev/null`
    rm *.tar.gz

    if [ "X${system_type}" == "XDeviceManager_ToolKit" ];then
        cd var/log/ISM
    elif [ "X${system_type}" == "XOceanStorOS" ];then
        echo ${TarName} | grep "platform.log" >/dev/null 2>&1
        if [ $? -eq 0 ];then
            cd var/log/platform
        fi
    fi

    files=$(ls -l ./ | grep -v ".tar.gz$" | awk -F " " '{print $9}')
    for file in ${files[*]}
    do
        #ݵͰ汾־ɾ־
        if [ "X${system_type}" == "XOceanStorOS"  -o "X${system_type}" == "XDFS_OBS" ];then
            echo ${TarName} | grep "snas.log" >/dev/null 2>&1
            if [ $? -eq 0 ];then
                echo ${file} | grep -E "${FileNameList}" >/dev/null 2>&1
                if [ $? -ne 0 ];then
                    rm ${file}
                    continue
                fi
            fi
        else
            echo ${file} | grep -E "${FileNameList}" >/dev/null 2>&1
            if [ $? -ne 0 ];then
                rm ${file}
                continue
            fi
        fi

        year=$(GetYearTime "${EndTime}")
        OnlyYear=$(GetOnlyYearTime "${EndTime}")
        OnlyYear_y=$(GetOnlyYearTime_y "${EndTime}")
        month=$(GetMonthTime "${EndTime}")
        day=$(GetDayTime "${EndTime}")
        hour=$(GetHourTime "${EndTime}")
        minute=$(GetMinuteTime "${EndTime}")

        grep -E "^.${OnlyYear}.${month}.${day}|^${OnlyYear}${month}${day}|^.${OnlyYear_y}${month}${day}|^${OnlyYear}.${month}.${day}|^.${OnlyYear}-${month}-${day}" ${file} >/dev/null 2>&1
        result=$?
        if [ ${result} -eq 0 ];then
            HourMin=$(GetCutOutEndTime "${file}" "${year}" "${hour}" "${minute}")
            if [ "X${HourMin}" != "X:" ];then
                true_Hour=`echo ${HourMin} | awk -F":" '{print $1}'`
                true_Min=`echo ${HourMin} | awk -F":" '{print $2}'`
                OMLogNuTmp=`cat ${file} | grep -n -nE "^.${OnlyYear}.${month}.${day}.${HourMin}|^${OnlyYear}${month}${day}.${HourMin}|^.${OnlyYear_y}${month}${day}${true_Hour}${true_Min}|^${OnlyYear}.${month}.${day}.${HourMin}|^.${OnlyYear}-${month}-${day}-${HourMin}" | sort -n | tail -1 | awk -F":" '{print $1}'`
                OMAllLogNum=`cat ${file} | wc -l`
                #ɾ
                let "OMLogNu=${OMLogNuTmp}+1"
                if [ ${OMLogNu} -lt ${OMAllLogNum} ];then
                    sed -i "${OMLogNu},${OMAllLogNum}d" ${file}
                fi
            fi
        fi
        count=1
    done

    cd ${TmpDir}
    #жѹǷҪ־
    if [ ${count} -eq 1 ];then
        tar -zcf ${TarName} ./ >/dev/null 2>&1
    fi
}

##########################################################
#жǷIBRoce
#룺netTypeIB Roce
#0-IBRoce   1-ûIBRoce
#ʵIsIBorRoceNet "IB"
##########################################################
function IsIBorRoceNet()
{
    local NetList=""
    local iret=0
    local mstinfo=""
    local tmpinfo=""
    local flintInfo=""
    local tmpPSID=""
    local curfwVersion=""
    local ofedConfigPath="/opt/driver/ib-driver"
    local netType="$1"
    local result=""
    local count=0
    mst start >/dev/null
    iret=$?
    if [ ${iret} -ne 0 ]; then
        log "[${FUNCNAME}][${LINENO}]mst start exec failed,iret=$iret."
        return 1
    fi
    
    #гǰϵͳ豸ϵROCEIBӦMST豸
    mstinfo=$(mst status)
    iret=$?
    if [ ${iret} -ne 0 ]; then
        log "[${FUNCNAME}][${LINENO}]mst status exec failed,iret=$iret."
        return 1
    fi
    
    NetList=$(echo "${mstinfo}" | grep "/dev/mst/mt" | awk '{print $1}')
    if [ -z "${NetList}" ] ; then
        log "[${FUNCNAME}][${LINENO}]No check is required because no IB/RoCE network adapter exists."
        return 1
    fi
    
    for idx in ${NetList[@]}; do
        #ȡǰ̼汾PSID
        flintInfo=$(flint -d ${idx} q 2>&1)
        iret=$?
        if [ $iret -ne 0 ];then
            log "[${FUNCNAME}][${LINENO}] Get network adapter information failed,idx=[${idx}],iret=${iret},flintInfo=[${flintInfo}]"
            continue
        fi

        tmpPSID=$(echo "${flintInfo}" | grep PSID | awk '{print $NF}')
        #IB Roce
        grep ";${tmpPSID};" ${ofedConfigPath}/ofed*.conf 2>&1 | grep -v '^#' | grep -iq "${netType}"
        if [ $? -eq 0 ];then
            log "[${FUNCNAME}][${LINENO}] ${netType},PSID is ${tmpPSID}"
            return 0
        fi
    done
 
    return 1
}

function GetFilePath()
{
    local file=$1
    local file_time=""
    local result=""
    #UDSִЧ
    result=`echo ${BACKUP_DIR} | grep "archive"`
    if [ "X" != "X${result}" ];then
        #־лȡʱ2016-9-13
        file_time=`echo ${file} | awk -F'.' '{print $3}' | awk -F'_' '{print $1}'`
        echo "${BACKUP_DIR}_${file_time}"
    else
        echo "${BACKUP_DIR}"
    fi
}

#ȡC01汾־
function C01GetAllFile()
{
    local collectFileList="snasmessages_ snas_BASE snas_FCL snas.mds rpcmessages snas_TS snas_MON.log_ snas_CM start messages- rpc-"
    local FileNameList=""
    local EndLine=""
    if [ -f ${c01File} ];then
        rm ${c01File}
    fi
    touch ${c01File}
    for collectFile in ${collectFileList}
    do
        if [ "${fileSystemFlag}" -eq 0 ]; then
            ls ${BACKUP_DIR}/${collectFile}* 2>>/dev/null| egrep "tar.gz|bz2" 2>>/dev/null >>${c01File}
        else
            find /var/log/backup/ -name "${collectFile}*" 2>>/dev/null | egrep "tar.gz|bz2" 2>>/dev/null >>${c01File}
        fi
        #ļϵͳԼĿ¼Ҳļ
        EndLine=`sed -n '$=' ${c01File} 2>/dev/null`
        if [ -z "$EndLine" ]; then
            ls /var/log/${collectFile}* 2>>/dev/null | egrep "tar.gz|bz2" 2>>/dev/null >>${c01File}
        fi
    done
}

#ռC01汾־
function C01FileCollect()
{
    local FileList=$1
    local FileTimeIn=$2
    local EndTime=$3
    local BackPath=$4
    local collectFile=""
    local FileName=""
    local time=${FileTimeIn}
    local TrueFileTime=""

    for collectFile in ${FileList}
    do
        while [ "$(getSeconds "${time}")" -le "$(getSeconds "${EndTime}")" ]
        do
            FileTime=${time}

            echo ${collectFile} | grep -w "rpc-" >/dev/null 2>&1
            if [ $? -eq 0 ];then
                FileName=""
                FileTimeTmp="$(getSeconds "${time}")"
                timeAfter=$(getTimeAfterDays "${time}" "1")
                timeAfterSec="$(getSeconds "${timeAfter}")"
                while read line
                do
                    #ԸʽΪrpc-****.year-mon-day-hour.minute.secondsĸʽת仯Ϊ
                    TrueMinuts=$(echo ${line} | grep ${collectFile} | egrep ".tar.gz|.bz2" | awk -F'.' '{print $3}')
                    if [ "Xlog" != "X${TrueMinuts}" ];then
                        TrueDate=$(echo ${line} | grep ${collectFile} | egrep ".tar.gz|.bz2" | awk -F'.' '{print $2}' | cut -c 1-10)
                        TrueHour=$(echo ${line} | grep ${collectFile} | egrep ".tar.gz|.bz2" | awk -F'.' '{print $2}' | cut -c 12-13)
                        TrueSeconds=$(echo ${line} | grep ${collectFile} | egrep ".tar.gz|.bz2" | awk -F'.' '{print $4}')
                        TrueFileTime="$TrueDate $TrueHour:$TrueMinuts:$TrueSeconds"
                        TrueFileTime=$(date -d "$TrueFileTime" +%s)
                    else
                    TrueFileTime=`echo ${line} | grep ${collectFile} | egrep ".tar.gz|.bz2" | awk -F'.' '{print $2}'`
                    fi
                    if [ "X" != "X${TrueFileTime}" ];then
                        if [ ${TrueFileTime} -ge ${FileTimeTmp} -a ${TrueFileTime} -le ${timeAfterSec} ];then
                            FileName="${FileName} ${line}"
                        fi
                    fi
                done <${c01File}
            else
                FileName=""
                echo ${collectFile} | grep -w "messages" >/dev/null 2>&1
                if [ $? -eq 0 ];then
                    FileTime=`date -d "${time}" "+%Y%m%d"`
                fi
                while read line
                do
                    echo ${line} | grep ${collectFile} | egrep ".tar.gz|.bz2" | grep ${FileTime} >/dev/null 2>&1
                    if [ $? -eq 0 ];then
                        FileName="${FileName} ${line}"
                    fi
                done <${c01File}
            fi

            if [ "X" == "X${FileName}" ];then
                time=$(getTimeAfterDays "${time}" "1")
            else
                break
            fi
        done

        if [ "X" != "X${FileName}" ];then
            for file_tmp in ${FileName}
            do
                cp -rpf ${file_tmp} ${BackPath} >/dev/null 2>&1
            done
        fi
    done
}

#Сռ־
function FilterLogDeal()
{
    local SystemType=$1
    local TarFilePath=$2
    local FilePath=$3
    local BackPath=$4
    local TarFileList=""
    local FileList=""
    local TarFile=""
    local File=""
    local file_count=0

    cd ${TarFilePath}
    TarFileList=$(ls -l ./|grep ".tar.gz$"|sort -r -k 3 -t "."|awk -F " " '{print $9}')
    for TarFile in ${TarFileList[*]}
    do
        tar xzvf $TarFile -C ${FilePath} >/dev/null 2>&1
        if [ -d "${FilePath}/var/log/platform" ]; then
            cd "${FilePath}/var/log/platform"
        else
            cd "${FilePath}"
        fi
        FileList=$(ls -l ./|grep -v ".tar.gz$"|sort -n -k 5 -t " "|awk -F " " '{print $9}')
        for File in ${FileList[*]}
        do
            if [ "${need_size}" -le "${MIN_VALUE}" ];then
                rm -rf ${File} >/dev/null 2>&1
                continue
            fi
            file_size=$(caculateSizeOfFile ${File})
            if [ "${file_size}" -ge "${need_size}" ];then
                ddFile ${File} ${need_size}
                file_size=$(caculateSizeOfFile ${File})
            fi
            need_list[${#need_list[@]}]=${File}
            let "need_size=need_size-file_size"
        done
        #һѹ
        if [ "${need_size}" -le "${MIN_VALUE}" ];then
            file_count=`ls ./* | wc -l`
            if [ ${file_count} -gt 0 ];then
                tar -zcf ${TarFile} ./* >/dev/null 2>&1
                mv ${TarFile} ${BackPath} >/dev/null 2>&1
            fi
            break
        fi
        mv ${TarFile} ${BackPath} >/dev/null 2>&1
        rm -rf "${FilePath}/*" >/dev/null 2>&1
        cd "${TarFilePath}"
    done
}

#ִ̨ռ񣬿趨ʱʱ
function execWithTimeout()
{
    #timeout error code
    local err_timeout=125
    #command to be executed
    local command=$1
    #timeout for executing
    local timeout=$2
    #checking interval
    local interval=$3
    #execute command
    eval "${command} &"
    sub_pid=$!
    #check sub-process
    local timeOut=$timeout
    while ((timeOut > 0)); do
        kill -0 $sub_pid 2>/dev/null
        if [ $? -ne 0 ]; then
            #get exit code of sub-process
            wait $sub_pid
            return $?
        fi
        ((timeOut -= interval))
        sleep $interval
    done
    #kill sub-process
    kill -9 $sub_pid 2>/dev/null
    return $err_timeout
}

#S3ļȡӦϵͳļմµ
function GetBucketLog
{
    local file=""
    local files=""
    local logType=$1
    local logTarget=$2
    local tmpFile="/tmp/s3_GetBucketLogResult.$$"
    touch ${tmpFile}
    while read line
    do
        #
        if [ "X" == "X${line}" ];then
            continue
        fi
        #:/mnt//var/
        echo ${line} | grep -E "/mnt/|/var/" >/dev/null 2>&1
        if [ $? -eq 0 ];then
            continue
        fi

        if [ "Xtrue" == "X${logTarget}" ];then
            if [ ${S3_CollectServiceType} -eq 1 ];then
                file=$(echo "${line}" | grep "${logType}" | awk -F"$(hostname)/" '{print $2}')
            else
                file=$(echo "${line}" | grep "${logType}")
            fi
        else
            if [ ${S3_CollectServiceType} -eq 1 ];then
                file=$(echo "${line}" | grep -v "${logType}" | awk -F"$(hostname)/" '{print $2}')
            else
                file=$(echo "${line}" | grep -v "${logType}")
            fi
        fi
        if [ ! -z "${file}" ];then
            echo ${file} >>${tmpFile}
        fi
    done <${S3LogtmpFile}
    if [ $(cat ${tmpFile} | wc -l) -ne 0 ];then
        files=$(cat ${tmpFile} | sort -k 3 -t "." -n -r)
    fi
    rm -rf ${tmpFile} >/dev/null 2>&1
    echo ${files}
}

#־
function CPBackupLog()
{
    local log_file=$1
    local log_path=$2
    #DFS_OBS.xxxx-xx-xx_xx.tar.gzļȥ
    #UDSִЧ
    if [ ${S3_CollectServiceType} -eq 1 ];then
        ${S3LogDealFile} --option=get --nodeName=$(hostname) --fileName=${log_file} --desDir=${log_path}
    else
        true_back_path=$(GetFilePath "${log_file}")
        cp -fpr ${true_back_path}/${log_file} "${log_path}" >/dev/null 2>&1
    fi
}

#־
function CPOtherBackupLog()
{
    local log_path=$1
    local log_target=$2
    local log_count=$3
    local count_max=0
    local log_tar_file=""
    local file=""

    if [ "XOceanStorOS.log" == "X${log_target}" -o "Xibase.log" == "X${log_target}" -o "Xplatform.log" == "X${log_target}" ];then
        count_max=50
    else
        count_max=12
    fi
    if [ ${log_count} -lt ${count_max} ];then
        log_tar_file=$(ls -l ${BACKUP_DIR}/ 2>>/dev/null|grep "${log_target}"|sort -r -k 3 -t "."|awk -F " " '{print $9}')
        for file in ${log_tar_file[*]}
        do
            if [ ${log_count} -ge ${count_max} ]; then
                break
            fi
            true_back_path=$(GetFilePath "${file}")
            cp -fpr ${true_back_path}/${file} "${log_path}" >/dev/null 2>&1
            log_count=$((${log_count}+1))
        done
    fi
    echo "${log_count}"
}

#===================================================================================================
#ƣIsDelSensitiveInfo
#ܣ#жǷҪ,ֱӲĵǰ汾Ҫ;İ汾ǰ汾180ڵҪ
#    1:Ҫ      0:Ҫ
#===================================================================================================
function IsDelSensitiveInfo()
{
    local UpdToNowTime=""
    local NowTime="$(date +%s)"
    local diffTime=0
    #180
    local MaxTime=15552000
    if [ -f "${CONFIG_CMINI}" ];then
        UpdToNowTime=$(grep "^time_oldver_upd=[0-9]\+" ${CONFIG_CMINI} | awk -F"=" '{print $2}')

        if [ "X${UpdToNowTime}" == "X" ];then
            log "[$FUNCNAME][$LINENO]need to Sensitive,UpdToNowTime is empty."
            return 1
        else
            if [ ${UpdToNowTime} -eq 0 ];then
                log "[$FUNCNAME][$LINENO]not need to Sensitive,UpdToNowTime is zero."
                return 0
            fi
        fi

        let diffTime=${NowTime}-${UpdToNowTime}
        if [ ${diffTime} -gt ${MaxTime} ];then
            log "[$FUNCNAME][$LINENO]no need to delete sensitive Info,exceed MAX time(${MaxTime}),NowTime=[${NowTime}],UpdToNowTime=[${UpdToNowTime}],diffTime=${diffTime}"
            return 0
        fi
    fi
    log "[$FUNCNAME][$LINENO]need to Sensitive"
    return 1
}

#־кv_pcParamн⴦
function DelSensitiveOMFilterv_pcParam()
{
    local sourcefile="$1"
    local newsourcefile="$2"
    local tmpfile="/var/log/coldata_v_pcParamtmp.log"
    local inum=0
    strkey="email,email sender,SMS sender,sms-number"
    grep -En -A 10 "v_pcParam.*v_pcParamDesc" ${sourcefile}  | grep -E "(v_pcParam|^[0-9]+\-\[[a-zA-Z])" >${tmpfile}
    inum=$(cat "${tmpfile}" | wc -l)
    if [ ${inum} -gt 0 ];then
        awk -v file="${newsourcefile}" -v strkey="${strkey}" 'BEGIN{Flag=0;split(strkey,keylist,",");}
                {
                    if(index($0,"v_pcParam"))
                    {
                       Flag=1
                       lineStr=$0
                       next
                    }
                    if(Flag==1)
                    {
                        if(match($0,"^[0-9]+-\[[a-zA-Z]+"))
                        {
                            for(i in keylist)
                            {
                               print "--" keylist[i]
                               if(index($0,keylist[i]))
                               {
                                   print lineStr >>file
                                   Flag=0
                                   lineStr=""
                                   next
                               }
                            }
                        }else
                        {
                           Flag=0
                        }
                    }
                }
                END{
                }' ${tmpfile}
    fi
    [ -f "${tmpfile}" ] && rm -f "${tmpfile}"
}

#ISMģ
function DelSensitiveISMInfo()
{
    local sourcefile="$1"
    local module="$2"
    local mask="********"
    local rowkey=""
    local rowreg=""
    local regstr=""
    local keycontentfile="/var/log/datacoll_Sensitive_${module}file$$"
    local keycontenttmpfile="/var/log/datacoll_Sensitive_${module}file.tmp$$"
    local newsourcefile="${sourcefile}.tmp"
    local formatkeylist=""
    local num=0

    >${keycontenttmpfile}
    for key in ${ISMKeyList[@]};do
        rowreg=$(echo "${key}" | awk -F'#' '{print $1}')
        rowkey=$(echo "${key}" | awk -F'#' '{print $2}')
        regstr="$(echo "${key}" | awk -F'#' '{print $3}')"
        Flag=$(echo "${key}" | awk -F'#' '{print $4}')
        if [ "X${rowkey}" == "X" ];then
            log "[$FUNCNAME][$LINENO]rowkey is empty"
            continue
        fi
        if [ ${Flag} -eq 0 ];then
            grep -nE "${rowreg}" ${sourcefile} | grep "${regstr}" >> ${keycontenttmpfile}
        else
            grep -niE "${rowreg}" ${sourcefile} | grep -E "([0-9a-zA-Z._-]+@[0-9a-zA-Z._-]+)|[+|%2B]?[0-9+]{2,}" >> ${keycontenttmpfile}
        fi
    done

    sort -u ${keycontenttmpfile} | sed "/^[ \t]*$/d" > ${keycontentfile}
    num=$(cat ${keycontentfile} | wc -l)

    if [ ${num} -gt 0 ];then
        for key in ${ISMKeyList[@]};do
            rowkey=$(echo "${key}" | awk -F'#' '{print $2}')
            regstr=$(echo "${key}" | awk -F'#' '{print $3}')
            Flag=$(echo "${key}" | awk -F'#' '{print $4}')
            if [ -z ${rowkey} ];then
                continue
            fi
            if [ ${Flag} -eq 0 ];then
                sed -i -e "/${rowkey}/s/\(${regstr}\s*[=\[(:]\+\s*\)\([0-9a-zA-Z._-]\+@[0-9a-zA-Z._-]\+[;,]\?\)\+/\1${mask}/g" -e "/${rowkey}/s/\(${regstr}\s*[=\[(:]\+\s*\)\([+|%2B]\?[0-9]\+[;,]\?\)\+/\1${mask}/g"  ${keycontentfile}
            else
                #ؼֵʼ,绰
                sed -i "/${rowkey}/s/${regstr}/\1${mask}/g" ${keycontentfile}
            fi
        done

        >${newsourcefile}
        awk -v file="${newsourcefile}" -F':' 'BEGIN{;}
        {
            if(FNR==NR && $1!="")
            {
              linenum=$1
              linestr=$0
              tmpreg=linenum":"
              sub(tmpreg,"",linestr)
              newlist[linenum]=linestr
            }else
            {
              if(FNR in newlist)
              {
                  print newlist[FNR] >> file
              }else
              {
                  print $0 >> file
              }
            }
        }
        END{
        }' ${keycontentfile} ${sourcefile}

        mv ${newsourcefile} ${sourcefile}
    fi

    if [ -f ${keycontentfile} ];then
        log "[$FUNCNAME][$LINENO]delete file [${keycontentfile}],total process (${num}) line"
        rm -rf ${keycontentfile}
    fi
    [ -f ${keycontenttmpfile} ] && rm -rf ${keycontenttmpfile}
}

#OMģ
#ƥʽ1: example[1]abc@example.com     LevelAddrs[1]=abc@example.com  LevelAddrs[1][abc@example.com]
#ƥʽ2:address (abc@example.com)
#ʽֱбд
function DelSensitiveOMInfo()
{
    local sourcefile="$1"
    local module="$2"
    local mask="********"
    local rowreg=""
    local rowkey=""
    local regstr=""
    local keycontentfile="/var/log/datacoll_Sensitive_${module}file$$"
    local keycontenttmpfile="/var/log/datacoll_Sensitive_${module}file.tmp$$"
    local newsourcefile="${sourcefile}.tmp"
    local formatkeylist=""
    local num=0
    formatkeylist="acLevelAddrs|acAddrs|"
    >${keycontenttmpfile}
    for key in ${OMKeyList[@]};do
        rowreg=$(echo "${key}" | awk -F'#' '{print $1}')
        rowkey=$(echo "${key}" | awk -F'#' '{print $2}')
        Flag=$(echo "${key}" | awk -F'#' '{print $3}')
        if [ "X${rowkey}" == "X" ];then
            log "[$FUNCNAME][$LINENO]rowkey is empty"
            continue
        fi
        if [ ${Flag} -eq 0 ];then
            grep -nE "${rowreg}" ${sourcefile} | grep "${rowkey}" >> ${keycontenttmpfile}
        else
            if [ "${rowreg}" != "v_pcParam" ];then
                grep -niE "${rowreg}" ${sourcefile} | grep -E "([0-9a-zA-Z._-]+@[0-9a-zA-Z._-]+)|(, *+?[0-9+]{5,} *,?)" >> ${keycontenttmpfile}
            else
                DelSensitiveOMFilterv_pcParam "${sourcefile}" "${keycontenttmpfile}"
            fi
        fi
    done

    sort -u ${keycontenttmpfile} | sed "/^[ \t]*$/d" > ${keycontentfile}
    num=$(cat ${keycontentfile} | wc -l)

    if [ ${num} -gt 0 ];then
        for key in ${OMKeyList[@]};do
            rowreg=$(echo "${key}" | awk -F'#' '{print $1}')
            rowkey=$(echo "${key}" | awk -F'#' '{print $2}')
            Flag=$(echo "${key}" | awk -F'#' '{print $3}')
            if [ -z ${rowkey} ];then
                continue
            fi
            if [ ${Flag} -eq 0 ];then
                echo "${formatkeylist}" | grep "${rowkey}|" >/dev/null
                if [ $? != 0 ];then
                    sed -i -e "/${rowreg}/s/\(${rowkey}\s*[=\[(:]\+\s*\)\([0-9a-zA-Z._-]\+@[0-9a-zA-Z._-]\+[;,]\?\)\+/\1${mask}/g" -e "/${rowreg}/s/\(${rowkey}\s*[=\[(:]\+\s*\)\([0-9+]\+[;,]\?\)\+/\1${mask}/g" ${keycontentfile}
                else
                    sed -i -e "/${rowreg}/s/\(${rowkey} *\[[0-9]\+\] *[:=\[(]\? *\)\([0-9a-zA-Z._-]\+@[0-9a-zA-Z._-]\+[;,]\?\)\+/\1${mask}/g" -e "/${rowreg}/s/\(${rowkey}\s*\[[0-9]\+\] *[=\[(:]\?\s*\)\([0-9+]\+[;,]\?\)\+/\1${mask}/g" ${keycontentfile}
                fi
            else
                #ؼֵʼ,绰
                sed -i "${rowkey}" ${keycontentfile}
            fi
        done

        >${newsourcefile}
        awk -v file="${newsourcefile}" -F':' 'BEGIN{;}
        {
            if(FNR==NR && $1!="")
            {
              linenum=$1
              linestr=$0
              tmpreg=linenum":"
              sub(tmpreg,"",linestr)
              newlist[linenum]=linestr
            }else
            {
              if(FNR in newlist)
              {
                  print newlist[FNR] >> file
              }else
              {
                  print $0 >> file
              }
            }
        }
        END{
        }' ${keycontentfile} ${sourcefile}

        mv ${newsourcefile} ${sourcefile}
    fi

    if [ -f "${keycontentfile}" ];then
        log "[$FUNCNAME][$LINENO]delete file [${keycontentfile}],total process (${num}) line"
        rm -rf ${keycontentfile}
    fi
    [ -f "${keycontenttmpfile}" ] && rm -rf "${keycontenttmpfile}"
}

#ݲͬmoduleļϢ
function DelSensitiveInfoBaseOnType()
{
    local module="$1"
    local sourcefile="$2"
    local mask="********"

    case "${module}" in
           "OS")
                for key in ${OSKeyList};do
                    log "[$FUNCNAME][$LINENO]key=[${key}]"
                    sed -i -e "s/\(${key}\s*[=\[(:]\+\s*\)\([0-9+]\+[;,]\?\)\+/\1${mask}/g" -e "s/\(${key}\s*[=\[(:]\+\s*\)\([0-9a-zA-Z._-]\+@[0-9a-zA-Z._-]\+[;,]\?\)\+/\1${mask}/g" ${sourcefile}
                done
                return 0
                ;;
           "OM")
                DelSensitiveOMInfo ${sourcefile} ${module}
                return 0
                ;;
           "ISM")
                DelSensitiveISMInfo ${sourcefile} ${module}
                return 0
                ;;
            *)
                return 1
                ;;
    esac
}

#ļ,ֶָεΪ
function DelSensitiveInfoForConfig()
{
    local tmppath=$1
    local filename=""
    local field=""
    local pathnameList=""
    local Flag=0
    #Թ涨ֶνѵȺźÿգ
    for item in ${SensitiveFieldList[@]};do
        filename=$(echo ${item} | awk -F':' '{print $1}')
        field=$(echo ${item} | awk -F':' '{print $2}')
        Flag=$(echo ${item} | awk -F':' '{print $3}')
        pathnameList=$(find ${tmppath} -name ${filename})
        log "[$FUNCNAME][$LINENO]item=[${item}],filename=[${filename},field=[$field],pathnameList=[$pathnameList]]"
        if [ ${#pathnameList[@]} -gt 0 ];then
            for pathname in ${pathnameList};do
                if [ ${Flag} -eq 0 ];then
                    sed -i "s/${field}\( *\)=.*/${field}\1=/" ${pathname}
                else
                    sed -i "s/^\( *\)${field}.*/\1${field}/" ${pathname}
                fi
            done
        else
            log "[$FUNCNAME][$LINENO]file:[${filename}] not exist!"
        fi
    done

    #Թ涨ļɾ
    for item in ${SensitiveFileList[@]};do
        pathnameList=$(find ${tmppath} -name ${item})
        if [ ${#pathnameList[@]} -ne 0 ];then
            for pathname in ${pathnameList};do
                rm -rf ${pathname}
                log "[$FUNCNAME][$LINENO]delete file=[${pathname}]"
            done
        fi
    done
}

#־ļеemail  phone
function DelSensitiveInfoForEmailAndPhone()
{
    local path=$1
    local subtype=$3
    local FilePreLists=$2
    local module=$4
    local zipfiles=""
    local TmpFilePath="${path}tmp_Sensitive_path/"

    #δѹļ
    log "[$FUNCNAME][$LINENO] start process subtype=[${subtype}],module=[${module}],path=[$path],FilePreLists=[$FilePreLists]"
    for item in ${FilePreLists};do
        filelist=($(ls ${path}${item}* | grep -v "tar.gz$"))
        log "[$FUNCNAME][$LINENO] tmppath=[$path],item=[$item],count=${#filelist[@]}"
        if [ ${#filelist[@]} -gt 0 ];then
            for file in ${filelist[@]};do
                IFS_OLD=$IFS
                IFS=$'\n'
                log "[$FUNCNAME][$LINENO] file=[${file}]"
                DelSensitiveInfoBaseOnType "${module}" "${file}"
                IFS=$IFS_OLD
            done
        fi
    done

    #Ѿѹļ
    if [ -z ${subtype} ];then
        log "[$FUNCNAME][$LINENO] miss subtype=[${subtype}]"
        return
    fi

    zipfiles=($(ls ${path}${subtype}*.tar.gz))
    if [ ${#zipfiles[@]} -le 0 ];then
        log "[$FUNCNAME][$LINENO] zipfiles count <= 0"
        return
    fi

    if [ -d ${TmpFilePath} ];then
        rm -rf ${TmpFilePath}* >/dev/null 2>&1
    else
        mkdir -p ${TmpFilePath} >/dev/null 2>&1
        log "[$FUNCNAME][$LINENO] create TmpFilePath=[${TmpFilePath}]"
    fi
    log "[$FUNCNAME][$LINENO] start process zip file,zipfiles=[${zipfiles[*]}]"
    for zipfile in ${zipfiles[@]};do
        log "[$FUNCNAME][$LINENO] process zipfile=[${zipfile}]"
        tar -zxf ${zipfile} -C "${TmpFilePath}" >/dev/null 2>&1
        for item in ${FilePreLists};do
            filelist=($(find "${TmpFilePath}" -name "${item}*"))
            log "[$FUNCNAME][$LINENO]filelist=[${filelist[*]}],item=[$item],count=${#filelist[@]}"
            if [ ${#filelist[@]} -gt 0 ];then
                for file in ${filelist[@]};do
                    IFS_OLD=$IFS
                    IFS=$'\n'
                    log "[$FUNCNAME][$LINENO] file=[${file}]"
                    DelSensitiveInfoBaseOnType "${module}" "${file}"
                    IFS=$IFS_OLD
                done
            fi
        done

        cd ${TmpFilePath}
        if [ $? -eq 0 ];then
            tar -zcf ${zipfile} ./* >/dev/null 2>&1
            rm -rf ./* >/dev/null 2>&1
        else
            log "[$FUNCNAME][$LINENO] tar error,TmpFilePath=[${TmpFilePath}],zipfile=[${zipfile}]"
        fi
    done
    [ -d "${TmpFilePath}" ] && rm -rf "${TmpFilePath}" >/dev/null 2>&1
    log "[$FUNCNAME][$LINENO] end process subtype=[${subtype}],module=[${module}],FilePreLists=[${FilePreLists}]"
}

##########################################################
#ڵѯȺ˵нڵĴϢ
#룺
#      
#
#ʵqueryDiskLog
##########################################################
function queryDiskLog()
{
    local tmpinfo=""
    local tmpfie=""
    local nodename=""
    local nodeid=""
    local slotid=""
    local vendor=""
    local SN=""
    local diskType=""
    local Model=""
    local tmptype=""
    local tmpdiskfile="/tmp/tmp_disklogfile$$"
    local tmpmmlfile="/tmp/tmp_nodename_mmlfile$$"

    tmpinfo="$(/usr/local/bin/MmlBatch 4016 "cm diskinfo")"
    /usr/local/bin/MmlBatch 4016 "cm node" | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g'| grep "Node_ID" >${tmpmmlfile} 2>/dev/null
    tmpfie=$(echo "${tmpinfo}" | grep -Po "/tmp/snas_debug[0-9]*")
    #ڵʱʱļ
    if [ "${tmpfie}X" != "X" ];then
        tmpinfo="$(cat ${tmpfie})"
    fi
    
    #״̬Ϊ0(δ֪) 4(λ)඼ʾ (Cһ)
    echo "${tmpinfo}" | grep "Disk_ID" |grep -v "Running_Status: 4" | grep -v "Running_Status: 0" | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' > ${tmpdiskfile}
    #node,nodeid,slotid,vendor,SN,diskType,Modelʽ
    awk -F '\\|\\|' '
    function getDiskType(type)
    {
        diskTypeName[0] = "FC"
        diskTypeName[1] = "SAS"
        diskTypeName[2] = "SATA"
        diskTypeName[3] = "SAS_SSD"
        diskTypeName[4] = "NL_SAS"
        diskTypeName[5] = "SLC_SSD"
        diskTypeName[6] = "MLC_SSD"
        diskTypeName[15] = "SMR_SATA"
        diskTypeName[16] = "NVME_SSD"
        diskTypeName[17] = "SATA_SSD"
        if (type>=0&&type<=17)
            return diskTypeName[type]
        else
            return "NULL"
    }
    BEGIN {namelist[0]="";}
    {
       if (NR==FNR)
       {
        split($1,aid," ")
        split($2,aname," ")
        namelist[aid[2]]=aname[2]
        delete aid
        delete aname
       }
       
       if(NR!=FNR)
       {
           split($2,aid," ")
           split($3,aslotid," ")
           split($12,avendor," ")
           split($13,aSN," ")
           split($6,atype," ")
           split($10,amodel," ")
           nodename=namelist[aid[2]]
           nodeid=aid[2]
           slotid=aslotid[2]
           vendor=avendor[2]
           SN=aSN[2]
           diskType=getDiskType(atype[2])
           Model=amodel[2]
           printf("node,%s,%s,%s,%s,%s,%s,%s\n",nodename,nodeid,slotid,vendor,SN,diskType,Model)
           delete aid
           delete aslotid
           delete avendor
           delete aSN
           delete atype
           delete amodel
       }

    }' ${tmpmmlfile} ${tmpdiskfile}
    
    [ -f "${tmpdiskfile}" ] && rm -f "${tmpdiskfile}"
    [ -f "${tmpmmlfile}" ] && rm -f "${tmpmmlfile}"
}

#DiskLog
function DiskLogParamCheck()
{
    local parmErrFlag=0
    local tmpinfo=""
    local diskfile="$1"
    if [ "${diskfile}X" != "${G_DISKLOG_PARM_FILE}X" ] || [ ! -s "${diskfile}" ];then
        log "[$FUNCNAME][$LINENO]disk param err,diskfile=(${diskfile})"
        return 1
    fi    
    
    dos2unix ${diskfile} >/dev/null 2>&1
    #У飬ÿһеĲʽ(ڵID1=SN1:SN2:SN3 )Կոβ
    set_ifs
    for line in $(cat "${diskfile}");do
        echo "${line}" | egrep  "^[-_a-z0-9A-Z.]{1,127}=[a-z0-9A-Z-]{1,64}(:[a-z0-9A-Z-]{1,64})* $" >/dev/null
        if [ $? -ne 0 ];then
            parmErrFlag=1
            tmpinfo="${line}"
            break
        fi
    done
    restore_ifs
    
    if [ ${parmErrFlag} -ne 0 ];then
         log "[$FUNCNAME][$LINENO]disk param err,line info=(${tmpinfo})"
        return 1
    fi
    return 0
}

##########################################################
#Ϣ
#룺Param1:ڵбļ
#      
#
#ʵgetDiskLogInfo
##########################################################
function getDiskLogInfo()
{
    local diskLogPath="/var/log/cm/DiskLog"  
    local ValidIP=""
    local allip=""
    local command=""
    local exec_taskid="getDiskLogInfo"
    local pid=$$
    local remotefile="/var/log/cm/DiskLog.tar.gz"
    local nodeid=""
    local nodeip=""
    local localdisklist=""
    local iRet=0
    local filename="$1"
    local nodenamelist=""
    local nodename=""
    local nodenum=0
    local resnum=0
    local tmpinfo=""
    local diskList=""
    
    #У鴫ļǷϷ
    DiskLogParamCheck "${filename}"
    if [ $? -ne 0 ];then
        log "[$FUNCNAME][$LINENO]coll.param.error"
        echo "coll.param.error"
        return
    fi
    
    if [ -d "/var/log/cm/" ];then
        rm -rf /var/log/cm/*
    fi
    mkdir -p "${diskLogPath}"
    > ${VALID_IP_FILE}
    
    #·ӦĽڵִ
    diskList="$(cat ${filename})"
    set_ifs
    for item in ${diskList};do
        nodeid=$(echo "${item}" | awk -F'=' '{print $1}')
        localdisklist=$(echo "${item}" | awk -F'=' '{print $2}')
        command="${G_COLL_SCRIPT_PATH}/datacollect_Disklog.sh collect ${localdisklist}"
        nodeip=$(get_node_backnet_ip "${nodeid}")
        let nodenum=nodenum+1
        if [ "${nodeip}X" == "X" ];then
            log "[$FUNCNAME][$LINENO]get node ip fail,nodeid=${nodeid}"
            continue
        fi
        #72̣ÿ̼2
        remote_exec_async ${nodeip} ${exec_taskid} 10800 "${command}"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            log "[$FUNCNAME][$LINENO] Node: $nodeip||Error: ${iRet}"
            continue
        fi
        
        echo "${nodeip}" >> ${VALID_IP_FILE}
    done
    restore_ifs
    allip=$(cat ${VALID_IP_FILE})
    log "[$FUNCNAME][$LINENO]:allip:(${allip})" 
    ValidIP="${allip}"
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            #1ȴlocalexec·,2̫Ƶ
            sleep 5
            #Ϊ100%֮ļ,н
            for time in ${RepeatTimes[*]}; do
                proresult=`/opt/huawei/deploy/script/localexec.py progress $Item ${pid}${exec_taskid}`
                iRet=$?
                log "[$FUNCNAME][$LINENO]:IP:$Item,return:$iRet,time:$time"
                if [ $iRet -eq 101 -o $iRet -eq 107 ]; then
                    sleep 10
                else
                    break
                fi
            done

            log "[$FUNCNAME][$LINENO]get data IP:$Item,iRet=${iRet},proresult:$proresult"
            process=`echo $proresult | awk '{print $1}'`
            errno=`echo $proresult | awk '{print $4}'`

            if [[ "${iRet}" -eq 0 && "$process" != "100" && "$process" != "" ]];then
                echo "$Item" >> ${VALID_IP_FILE}
                continue;
            elif [ "${iRet}" -ne 0 ] || [ $errno -ne 0 ] || [ "$process" == "" ];then
                log "[$FUNCNAME][$LINENO]get data from $Item fail"
                continue;
            fi
            
            nodeName=$(get_node_hostname_from_db "${Item}")
            mkdir -p ${diskLogPath}/${nodeName}
            remote_download ${Item} "${diskLogPath}/${nodeName}/DiskLog.tar.gz" "${remotefile}"
            iRet=$?
            if [ $iRet -ne 0 ];then
                log "[$FUNCNAME][$LINENO]iRet=${iRet},ip:${Item},down err"
                continue
            fi
        done
        ValidIP=$(cat $VALID_IP_FILE)
    done
    
    #Ƿռ
    tmpinfo="$(/usr/local/bin/MmlBatch 4016 "cm node" | grep Node_ID)"
    for item in ${allip};do
        nodeName=$(echo "${tmpinfo}" | grep Node_ID |grep -w "${item}" | awk -F'\\|\\|' '{print $2}' | awk '{print $2}')
        if [ ! -s "${diskLogPath}/${nodeName}/DiskLog.tar.gz" ];then
            log "[$FUNCNAME][$LINENO]coll disk error,nodeName=${nodeName},item=${item}"
            continue
        fi
        nodenamelist="${nodeName} ${nodenamelist}"
        let resnum=resnum+1
    done
    
    if [ ${resnum} -eq 0 ];then
        log "[$FUNCNAME][$LINENO]Collect Disk log err resnum=$resnum"
        echo "coll.disk.error"
    elif [ ${resnum} -gt 0 ] && [ ${resnum} -lt ${nodenum} ];then
        log "[$FUNCNAME][$LINENO]Collect Disk log info from (${nodenamelist}) Success,nodenum=${nodenum},resnum=${resnum}"
        echo "${ErrorInfoFlag}Collect Disk log info from (${nodenamelist}) Success!"
    fi
    
    #ɺѹɰDiskLog.zip,˴ɵļҪsmartKitһõһ
    cd /var/log/cm/ 
    zip -qr "${G_DISKLOG_PATH}" ./* >/dev/null 2>&1
    [ -f "${VALID_IP_FILE}" ] && rm -f "${VALID_IP_FILE}"
    [ -f "${G_DISKLOG_PARM_FILE}" ] && rm -f "${G_DISKLOG_PARM_FILE}"
    [ -d "${diskLogPath}" ] && rm -rf "${diskLogPath}"
    chown omuser:$OMGROUP -R /var/log/cm
    log "[$FUNCNAME][$LINENO]proc DiskLog done."
}

##########################################################
#Ϣ
#룺Param1:coll ռϢ   query:ѯȺϢ
#      Param2:̲ϢʽΪ(ڵ:)
#
#ʵcollDiskLog "coll"
##########################################################
function collDiskLog()
{
    local action="$1"
    local diskfile="$2"
    if [ "${action}" == "collect" ];then
        #ռ־Ϣ
        getDiskLogInfo "${diskfile}"
    elif [ "${action}" == "query" ];then
        #ѯϢ
        queryDiskLog
    else
        #pythonĴԴļ
        echo "coll.param.error"
    fi
   
}

#ں
function DelSensitiveInfo()
{
    local FilePreLists=""
    local Configpath="/var/log/cm/LocalDataCollect/$(hostname)/Config/"
    local Eventpath="/var/log/cm/LocalDataCollect/$(hostname)/Event/"
    local zipfiletype=""
    DelSensitiveInfoForConfig ${Configpath}

    #/var/log/cm/LocalDataCollect/ڵ/Event/event.txt,־Ĺһ
    FilePreLists="event.txt"
    DelSensitiveInfoForEmailAndPhone "${Eventpath}" "${FilePreLists}" "${zipfiletype}" "OS"
}

#ȡ־
function GetLocalBackupLog
{
    local file_path=$1
    local file_type=$2
    local log_path=$3
    local log_count=$4
    local count_max=0
    local log_tar_file=""
    local file=""

    if [ "XOceanStorOS.log" == "X${log_target}" -o "Xibase.log" == "X${log_target}" -o "Xplatform.log" == "X${log_target}" ];then
        count_max=50
    else
        count_max=12
    fi
    cd /var/log/backup/${file_path}
    log_tar_file=$(ls -l ./|grep "${file_type}"|sort -r -k 3 -t "."|awk -F " " '{print $9}')
    for file in ${log_tar_file}
    do
        if [ $log_count -ge ${count_max} ]; then
            break
        fi
        cp -fpr ${file} "${log_path}" >/dev/null 2>&1
        log_count=$(($log_count+1))
    done
    echo ${log_count}
}

INX_FNAME=1
INX_RECTYPE=2
INX_SIZE=3
INX_DESPAHT=4
INX_COMPRESSED=5
INX_DONE=6
INX_UTCSEC=7
#COLLECT_RECORD_FORMAT:ռ־¼ļм¼ʽΪ
#full_name(in DFS/S3, is short name) ("file"|"dir") size(unit: byte) des_path should_compress done utc_seconds
#full_name: ־ڱļϵͳдȫ·DFS/S3ֻṩļƣ
#rec_tyep:  "file"˵ռΪļ
#           "dir"ռΪĿ¼
#size     -1ʾһѹҪshould_compressͬʱΪ1
#           >0, λֽڡһѹļṩӦѹļС
#des_path:  ռõ־·should_compressΪ1ļѹҲֱӷŵĿ¼
#should_compress:   ǷҪѹ1Ҫѹڸɵļ¼ļռ־ʱԶѹŵdes_pathС0Ҫѹɵļ¼ļռ־ӦĿ¼
#done:      ¼ǷѾ. 
#           1:Ѿϡget_record_bysizeʱֱӽѹļ(should_compress==1)ѹdes_path,
#                   sizeΪʵѹļСΪ1ںڸݼ¼ļռ־ʱ¼Ϊ֮ǰѾˣ
#           0: ¼е־ûռڸݼ¼ļռ־ʱݼ¼ռ־
#utc_secondsڲֶΡֶʱֶռ־¼ʱԶļ.collect_compressed_logsĻصвҪֶ
#Using new method or not. 1: using new method. 0:using old method.
function should_collect_in_newway()
{
    local linenr=0
    if [ -f ${LOG_INFO} ];then
        linenr=$(cat ${LOG_INFO} | wc -l )
        if [ 0 -ne ${linenr} ];then
            return 1
        fi
    fi
    return 0
}

function ret_seconds()
{
    local second=${1}
    if [ "X" != "X${second}" ] && [ 0 -ne ${second} ];then
        echo "${second}"
        return 0
    else
        echo "0"
        return 1
    fi
}

#nas_klog_2018-05-24_12:00:01.0000003.tar.gz
#snas_CM.log_2018-10-15-08.00.00.303196.tar.gz
#snas_MON.log_2018-08-04-23.04.15.260694.tar.gz
#snasmessages_2018-05-15-17.48.32.516779.tar.gz
#firewall-20180712.bz2
#mdata_chk_210235G7J910D8000018.tar.gz
#messages-20180712.bz2
#rpc-4004.1526188856.log.tar.gz
#warn-20180712.bz2

#2018-10-15-11.00.00.561040 --> 1539673200
#C01ļеʱ䱾UTCʱ
function GetSecondForC01()
{
    local tm="$*"
    local dt=""
    local sec=""
    local rc=0
    
    if [ "X" != "X${tm}" ];then
        dt=$(echo "${tm}" | sed -r 's/([0-9]{4})-([0-9]{2})-([0-9]{2})-([0-9]{2}).([0-9]{2}).([0-9]{2}).([0-9]{6})/\1-\2-\3 \4:\5:\6/')
        sec=$(date -d "${dt}" +%s)
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$FUNCNAME][$LINENO]"Warning, get second from ${tm} fail"            
        fi
        return ${rc}
    fi
    return 0    
}

#parameters: ("with_src_dir"|"no_src_dir") "src_file_or_dir" "out_zip_file"
function add_to_zip_file()
{
    local option="$1"
    local src_file_or_dir="${2}"
    local out_zip_file="${3}"
    local zipflag="rj"
    local dirname=$(dirname ${out_zip_file})
    
    if [ "X" == "X${option}" ] || [ "X" == "X${src_file_or_dir}" ] || [ "X" == "X${out_zip_file}" ] || ([ "with_src_dir" != "${option}" ] && [ "no_src_dir" != "${option}" ]);then
        log [$FUNCNAME][$LINENO]"parameter invalid. option:${option}, src_file:${src_file_or_dir} zipfile:${out_zip_file}"
        return 1
    fi
    if [ ! -f ${src_file_or_dir} ] && [ ! -d ${src_file_or_dir} ];then
        log [$FUNCNAME][$LINENO]"parameter invalid. ${src_file_or_dir} is not exist!"
        return 1
    fi
    if [ ! -d ${dirname} ];then
        log [$FUNCNAME][$LINENO]"parameter invalid. destination path, ${dirname} is not exist!"
        return 1
    fi
    
    if [ "with_src_dir" == "${option}" ];then
        zipflag="r"
    fi;
    /usr/bin/zip -${zipflag} ${out_zip_file} ${src_file_or_dir}
    return $?
}

#parameters: left_size out_zip_file ignore_if_noexist "files"
#eg: 182555 /var/log/cm/LocalDataCollect/DFS-72-203/OM/omlog.zip "/var/log/snas_CM.log* /var/log/CLI/*"
function collect_files_to_tar()
{
    local left_size=$1
    local out_zip_file=$2
    local ignore_if_noexist=$3
    shift 3
    local files="$*"
    local basedir=$(dirname ${out_zip_file})
    local file=""
    local rc=0
    local need_size=${left_size}
    local new_size=0
    local old_size=0
    local delta_size=0
    
    if [ ${left_size} -le ${MIN_VALUE} ] || [ ! -d ${basedir} ];then
        log [$FUNCNAME][$LINENO]"ERROR, parameter invalid. ${left_size} le ${MIN_VALUE} or path ${basedir} not exist!"
        return 1
    fi
    if [ -f ${out_zip_file} ];then
        old_size=$(caculateSizeOfFile ${out_zip_file})
    fi
    
    for file in ${files}
    do
        if [ "${need_size}" -le "${MIN_VALUE}" ]; then
            log [$FUNCNAME][$LINENO]"Waring, space no enough. file:${file},current:${need_size}, min_size:${MIN_VALUE}."
            break
        fi
        if [ 1 -eq ${ignore_if_noexist} ] && [ ! -f ${file} ] && [ ! -d ${file} ];then
            continue
        fi
        add_to_zip_file no_src_dir "${file}" ${out_zip_file}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$FUNCNAME][$LINENO]"Waring, add_to_zip_file no_src_dir ${file} ${out_zip_file} fail with ${rc}"
            continue
        fi
        new_size=$(caculateSizeOfFile ${out_zip_file})
        let "delta_size=new_size - old_size"
        log [$FUNCNAME][$LINENO]"info: new:${new_size},old:${old_size}, delta:${delta_size},left:${need_size}, collected file: ${file}"
        if [ 0 -lt ${delta_size} ] && [ ${delta_size} -ge ${need_size} ];then
            log [$FUNCNAME][$LINENO]"Waring, space no enough. file:${file},delta:${delta_size},current:${need_size}, min_size:${MIN_VALUE}."
            break
        fi
        let "need_size=need_size-delta_size"
        let "old_size=new_size" 
    done
    return 0
}

#
function other_task_cp_from_dfs()
{
    local param=$@
    local local_sh="$(dirname $0)/datacollect_local.sh"
    if [ -f ${local_sh} ];then
        execWithTimeout "${local_sh} dfs_cp ${param}" 10 2
    fi
    return $?
}

#turn 2018-10-04_10 or 2018-10-04_10_1 tosecond
function getSecondsFromDate()
{
    local ori_time=$*
    local cur_time=$(echo ${ori_time} | sed 's/_/ /')
    local tmpdate=""
    local rc=0
    
    echo ${cur_time} | grep "_" > /dev/null
    if [ $? -eq 0 ];then
        #2018-10-11_13_1 --> 2018-10-11 13_1 --> 2018-10-11 13
        tmpdate=${cur_time}
        cur_time=${tmpdate%%_*}
    fi
    cur_sec=$(getSeconds "${cur_time}" )
    rc=$?
    if [ ${rc} -eq 0 ];then
        echo ${cur_sec}
    else
        echo "0"
        log [$FUNCNAME][$LINENO]"Waring: turn ${ori_time} to seconds fail with ${rc}"
    fi
    return ${rc}
}

#parameters: ${rec_out} ${om_tmp_local_info} ${callback_get_utcseconds}
#eg. /var/log/cm/LocalDataCollect/local.om.info /var/log/cm/LocalDataCollect/tmp.local.snas.log.info getUtcSecondsFromOMFileName
#the format of rec_out (om_tmp_local_info's record had no utc_seconds):
#           search COLLECT_RECORD_FORMAT in this file to see detail.
# full_name: 
#om_tmp_local_infoļ¼ļеʱĩβӶӦutc_secondsļûʱϢͰյǰʱ
#/var/log/cm/LocalDataCollect/../tmp/.tmp.OM.all.info /var/log/cm/LocalDataCollect/../tmp/tmp.OM.dfs.and.local.info  getUtcSecondsFromOMFileName
function sort_rec_bytime()
{
    local output_sorted_rec=${1}
    local input_rec=${2}
    local callback_get_utcseconds=${3}
    local rc=0
    local basepath=$(dirname ${output_sorted_rec})
    local rec=""
    local time=""
    local tmp=""
    local outsname=$(basename ${output_sorted_rec})
    local tmp_outfname="${TMP_PATH_NEWWAY}/.tmp.bfsort.${outsname}"
    local cur_second=""
    local fname=""
    
    if [ "X" == "X${output_sorted_rec}" ] || [ "X" == "X${callback_get_utcseconds}" ] || [ "X" == "X${input_rec}" ] || [ ! -f ${input_rec} ];then
        log [$FUNCNAME][$LINENO]"ERROR: invalid parameters. output:${output_sorted_rec}, input:${input_rec}, cb_utc_second:${callback_get_utcseconds}"
        return 1
    fi
    if [ ! -d ${basepath} ];then
        mkdir -p ${basepath}
    fi
    > ${output_sorted_rec}
    rc=$?
    if [ ${rc} -ne 0 ];then
        log [$FUNCNAME][$LINENO]"ERROR: > ${output_sorted_rec} fail with $rc"
        return ${rc}
    fi
    if [ -f ${tmp_outfname} ];then
        > ${tmp_outfname}
        if [ ${rc} -ne 0 ];then
            log [$FUNCNAME][$LINENO]"ERROR: > ${tmp_outfname} fail with $rc"
            return ${rc}
        fi 
    fi
    
    while read rec
    do
        #search COLLECT_RECORD_FORMAT in this file, to see detail.
        fname=$(echo ${rec} | awk -v inx=${INX_FNAME} '{print $inx}')
        if [ "X" == "X${fname}" ];then
            log [$FUNCNAME][$LINENO]"Warning, get file name from ${rec} fail."
            continue
        fi
        cur_second=$(${callback_get_utcseconds} ${fname})
        if [ 0 -eq ${cur_second} ];then
            log [$FUNCNAME][$LINENO]"Warning, ${callback_get_utcseconds} ${fname} fail."
            continue
        fi  
        echo "${rec} ${cur_second}" >> ${tmp_outfname}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$FUNCNAME][$LINENO]"ERROR: append record: ${rec} ${cur_second} to ${tmp_outfname} fail with ${rc}"
            return ${rc}
        fi
    done < ${input_rec}
    
    #sorted by current -> old. record: /var/log/backup/DFS_OBS/DFS_OBS.log.2018-10-04_11.tar.gz file 15486 /var/log/cm/LocalDataCollect/Messages/OM 1538650800
    cat ${tmp_outfname} | sort -n -r -k ${INX_UTCSEC} >> ${output_sorted_rec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$FUNCNAME][$LINENO]"ERROR: sort ${tmp_outfname} and redirect to ${output_sorted_rec} fail with ${rc}"
        return ${rc}
    fi
    return 0
}

#generate record file 
#Notes:
#   1, log file names in DFS/S3 are short names(NO path). log file's names are full names(had path)
#   2, be sure fileSystemFlag had been set by real before calling this function.
#   3, be sure the record file of ${LOG_INFO} (which had files' info on DFS/S3) had been exist.
#rec_out:
#  search COLLECT_RECORD_FORMAT in this file, to see detail.
#/var/log/snas_CM.log.2018-09-25_04. 67086 1 1538870400       <--on local, shuold compressed 
#/v.2018-09-25_04.tar.gz 67086 0 1538870400                          <--on DFS/S3
#
#parameters: ${out_rec} ${comp_name} ${callback_getloglist} ${callback_get_utcseconds}
#parameters: /var/log/cm/LocalDataCollect/../tmp/.tmp.OM.all.info" OM omGetLoglist getUtcSecondsFromOMFileName
function generate_compressed_record()
{
    local rec_out=${1}
    local comp_name=${2}
    local callback_getloglist=${3}
    local callback_get_utcseconds=${4}
    local rc=0
    local fs_local_info="${TMP_PATH_NEWWAY}/tmp.dfs.only.${comp_name}.info"
    local om_tmp_local_info="${TMP_PATH_NEWWAY}/tmp.${comp_name}.dfs.and.local.info"  
    local search_key=""
    local basedir=$(dirname ${om_tmp_local_info})
    local fname=""
    
    if [ "X" == "X${rec_out}" ] || [ "X" == "X${comp_name}" ] || [ "X" == "X${callback_getloglist}" ] || [ "X" == "X${callback_get_utcseconds}" ];then
        log [$FUNCNAME][$LINENO]"ERROR, invalid parameters. result_file:${rec_out}, component:${comp_name}, cb_loglist:${callback_getloglist}, cb_utcseconds:${callback_get_utcseconds}"
        return 1
    fi
    
    if [ -f ${rec_out} ];then
        > ${rec_out}
    fi
    if [ -f ${om_tmp_local_info} ];then
        rm ${om_tmp_local_info}
    fi
    if [ -f ${fs_local_info} ];then
        > ${fs_local_info}
    fi
    if [ ! -d ${basedir} ];then
        mkdir -p ${basedir}
    fi
    #collect log files on local
    ${callback_getloglist} ${om_tmp_local_info}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$FUNCNAME][$LINENO]"ERROR, ${callback_getloglist} ${om_tmp_local_info} fail with ${rc}"
        return 1
    fi
    
    #collect log files on DFS/S3, that are not exist on local
    if [ -f ${LOG_INFO} ];then
        log [$FUNCNAME][$LINENO]"filesystem file list is normal."
        if [ "${fileSystemFlag}" -eq 0 ];then            
            search_key=$(cat ${om_tmp_local_info} |grep -F .tar.gz | awk -v inx=${INX_FNAME} '{print $inx}' | while read fname;do basename ${fname} ; done | sed ':jix;N;s/\n/ |/g;b jix')
            if [ "X" != "X${search_key}" ];then
                ${callback_getloglist} ${fs_local_info} ${LOG_INFO}
                rc=$?
                if [ 0 -ne ${rc} ];then
                    log [$FUNCNAME][$LINENO]"ERROR, ${callback_getloglist} ${fs_local_info} ${LOG_INFO} fail with ${rc}"
                    return 1
                fi
                #û·ļϵͳµļ,طC20ͲҪټǰ·
                egrep -v "${search_key}" ${fs_local_info} | while read line;do echo "${line}" >> ${om_tmp_local_info} 2>&1 ;done  
                rc=$?
                log [$FUNCNAME][$LINENO]"merge local ${om_tmp_local_info} and dfs's ${fs_local_info} log, with $?"
                if [ 0 -ne ${rc} ];then
                    return 1
                fi
            else
                log [$FUNCNAME][$LINENO]"ERROR:get search key fail. cat ${om_tmp_local_info}"
                return 1
            fi
        fi
    fi
    #sort from file ${om_tmp_local_info} to ${rec_out}, ordered by time
    sort_rec_bytime ${rec_out} ${om_tmp_local_info} ${callback_get_utcseconds}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$FUNCNAME][$LINENO]"ERROR: sort_rec_bytime ${om_tmp_local_info} ${rec_out} fail with ${rc}"
        return 1
    fi
    
    return 0
}

#parameters: full_name des_path left_size
#Caution: full_name may be file or direction
function tar_file()
{
    local full_name=${1}
    local des_path=${2}    
    local left_size=${3}
    local size=0
    local sname=""
    local basedir=""
    local tar_size=0
    local rc=0
    local tmp_path="${des_path}/tmp"
    
    if [ "X" == "X${full_name}" ] || [ ! -f ${full_name} -a ! -d ${full_name} ] || [ "X" == "X${des_path}" ] || [ ! -d ${des_path} ] || [ "X" == "X${left_size}" ];then
        log [$FUNCNAME][$LINENO]"ERROR: invalid parameters. $* not exist"
        return 1
    fi
    #ѹȰ10:1,ԤѹᳬʣСֱӱͼѹ
    size=$(/usr/bin/du -sb ${full_name} | awk '{print $1}')
    let "tar_size=size/10"
    if [ "X" != "X${tar_size}" ] && [ ${tar_size} -ge ${left_size} ];then
        log [$FUNCNAME][$LINENO]"ERROR: left size not enough. size:${size}, left size:${left_size}, expect compressed size:${tar_size}. input: $*"
        return 1
    fi
    sname=$(basename ${full_name})
    basedir=$(dirname ${full_name})    
    tar -zcpf ${des_path}/${sname}.tar.gz -C ${basedir} ${sname} >> ${LOG_FILE} 2>&1
    rc=$?
    if [ 0 -ne ${rc} ];then
        #Իڸеļѹᱨ.ȿʱĿ¼ѹ
        if [ ! -d ${tmp_path} ];then
            mkdir -p  ${tmp_path} || log [$FUNCNAME][$LINENO]"ERROR: make dir of ${tmp_path} fail"
            cp -prf ${full_name}  ${tmp_path} 
            rc=$?
            if [ 0 -ne ${rc} ];then
                log [$FUNCNAME][$LINENO]"ERROR: cp -prf ${full_name}  ${tmp_path} fail with ${rc}"
            else
                tar -zcpf ${des_path}/${sname}.tar.gz -C ${tmp_path} ${sname} >> ${LOG_FILE} 2>&1
                rc=$?
                if [ 0 -ne ${rc} ];then
                   log [$FUNCNAME][$LINENO]"ERROR: tar -zcpf ${des_path}/${sname}.tar.gz -C ${basedir} ${sname} fail"
                fi
            fi
        fi
        #ʱĿ¼ʱļ
        if [ -d ${tmp_path} ];then
            echo ${tmp_path} | grep "LocalDataCollect" > /dev/null 2>&1
            if [ 0 -eq $? ];then
                rm -rf ${tmp_path}
            fi
        fi
    fi
    return ${rc}
}

#parameters:  ${input_rec} ${size_can_collect} ${record_to_collect}
#paras:  /var/log/cm/LocalDataCollect/../tmp/.tmp.OM.all.info    ${TOTAL_SIZE}  /var/log/cm/LocalDataCollect/../tmp/OM.tobe.collect.info
function get_record_bysize()
{
    local input_rec=$1
    local size_can_collect=$2
    local record_to_collect=$3
    local filename=""
    local record=""
    local size=0
    local should_compress=0
    local left_size=${size_can_collect}
    local rec_time=""
    local hour=""
    local rec_type=""
    local des_path=""
    local sname=""
    local basedir=""
    local done=0
    
    if [ ! -f ${input_rec} ];then
        log [$FUNCNAME][$LINENO]"ERROR: input file ${input_rec} not exist"
        return 1
    fi
    while read record
    do
        done=0
        #record format: full_name(in DFS/S3, is short name) ("file"|"dir") size(unit: byte) des_path should_compress utc_seconds        
        size=$(echo ${record} | awk -v inx=${INX_SIZE} '{print $inx}')        
        if [ ${left_size} -lt ${MIN_VALUE} ] ;then
            log [$FUNCNAME][$LINENO]"collect compressed log end ,left_size:${left_size}, record:${record}"
            return 0
        fi
        des_path=$(echo ${record} | awk -v inx=${INX_DESPAHT} '{print $inx}')
        if [ "X" == "X${des_path}" ] || [ ! -d ${des_path} ];then
            log [$FUNCNAME][$LINENO]"Waring, destination path:${des_path} not exist. ignore this record:${record}!"
            continue
        fi        
        filename=$(echo ${record} | awk -v inx=${INX_FNAME} '{print $inx}')
        if [ "X" == "X${filename}" ];then
            log [$FUNCNAME][$LINENO]"Waring, ignore:get file name from ${record} fail"
            continue
        fi
        should_compress=$(echo ${record} | awk -v inx=${INX_COMPRESSED} '{print $inx}')
        if [ "X" == "X${should_compress}" ];then
            should_compress=0
        fi
        rec_type=$(echo ${record} | awk -v inx=${INX_RECTYPE} '{print $inx}')
        if [ "X" == "X${rec_type}" ] || [ "file" != "${rec_type}" -a "dir" != ${rec_type} ];then
            log [$FUNCNAME][$LINENO]"Waring, record type invalid, set to file. record: ${record}"
            rec_type="file"
        fi
        
        #size-1, should_compress1ʾĿǰ֪СҪѹȷ
        if [ 0 -gt ${size} ] && [ 1 -ne ${should_compress} ];then
            log [$FUNCNAME][$LINENO]"Waring, invalid record, size(${size} <0 , but compressed(${should_compress}) is not 1). ignore record: ${record}"
            continue
        fi

        if [ 1 -eq ${should_compress} ];then
            sname=$(basename ${filename})
            basedir=$(dirname ${filename})
            tar_file ${filename} ${des_path} ${left_size}
            rc=$?
            if [ 0 -ne ${rc} ];then
                if [ -f ${des_path}/${sname}.tar.gz ];then
                    rm ${des_path}/${sname}.tar.gz || log [$FUNCNAME][$LINENO]"Warning, rm ${des_path}/${sname}.tar.gz fail."
                fi
                log [$FUNCNAME][$LINENO]"Waring, tar_file ${filename} ${basedir} ${left_size} fail with ${rc}.ignore this record:${record}"
                continue
            else
                if [ -f ${des_path}/${sname}.tar.gz ];then
                    size=$(ls -l ${des_path}/${sname}.tar.gz | awk '{print $5}')
                    if [ ${size} -ge ${left_size} ];then
                        rm ${des_path}/${sname}.tar.gz
                        log [$FUNCNAME][$LINENO]"Waring, ${des_path}/${sname}.tar.gz size:${size} > left size:${left_size}. ignore record: ${record},rm return $?."
                        continue
                    else
                        #ǰռҲռ־¼бü¼ΪѾռˡ
                        done=1
                        log [$FUNCNAME][$LINENO]"pre collect: ${des_path}/${sname}.tar.gz, size:${size}. record:${record}"
                    fi                     
                else                    
                    log [$FUNCNAME][$LINENO]"Waring, ${des_path}/${sname}.tar.gz not exist. ignore record:${record}"
                    continue
                fi
            fi
        fi
        
        if [ ${size} -ge ${left_size} ];then            
            if [ 1 -eq ${should_compress} ] && [ -f ${des_path}/${sname}.tar.gz ];then
                rm ${des_path}/${sname}.tar.gz
            fi
            #Ϊ˷ֹΪĳ־ļº޷ռ
            log [$FUNCNAME][$LINENO]"Waring, log file too large, ignore this file! file size(${size}) >=left size(${left_size}),record :${record}"
            continue
        fi
        echo "${filename} ${rec_type} ${size} ${des_path} ${should_compress} ${done}" >> ${record_to_collect}         
        let "left_size-=size"
        log [$FUNCNAME][$LINENO]"collect:${filename} ${rec_type} ${size} ${des_path} ${should_compress} ${done}, left size:${left_size}"
    done < ${input_rec}
    log [$FUNCNAME][$LINENO]"collect compressed log end, left_size:${left_size}, record:${record}"
    return 0
}
function GetKeyBySub()
{
    sub=$1
    case $sub in
    DeviceManager_ToolKit)
        echo "ibase.log.*.tar.gz"  
        ;;
    OceanStorOS)
        echo "OceanStorOS.log.*.tar.gz" 
        ;;
    OM)
        echo "snas.log.*.tar.gz"
        ;;
    MON_BJM)
        echo "MON_BJM.log.*.tar.gz"
        ;;
    DFS_OBS)
        echo "DFS_OBS.log.*.tar.gz"
        ;;
    RPCUser)
        echo "RPCUser.log.*.tar.gz"
        ;;
    OS)
        echo "audit.log.*.tar.gz"
        ;;
    OSS)
        echo "s3.log.*.tar.gz"
        ;;
    WorkLoad)
        echo "workload.log.*.tar.gz"
        ;;
    Accesslog)
        echo "Accesslog.log.*.tar.gz"
        ;;
    Gaussdblog)
        echo "Gaussdblog.log.*.tar.gz"
        ;;
    snas_CA)
        echo "snas_CA.log.*.tar.gz"
        ;;
    *)
        echo "snas.log.*.tar.gz"
        ;;
    esac
    
}

function GetLogNumLimit()
{
    local sub=$1 
    case $sub in
    DeviceManager_ToolKit)
        echo "50"  
        ;;
    OceanStorOS)
        echo "50" 
        ;;
    OM)
        echo "12"
        ;;
    MON_BJM)
        echo "12"
        ;;
    DFS_OBS)
        echo "12"
        ;;
    OSS)
        echo "12"
        ;;
    RPCUser)
        echo "12"
        ;;
    OS)
        echo "12"
        ;;
    WorkLoad)
        echo "12"
        ;;
    Accesslog)
        echo "12"
        ;;
    Gaussdblog)
        echo "12"
        ;;
    snas_CA)
        echo "12"
        ;;
    *)
        echo "12"
        ;;
    esac
}

function GetLimitFilebySize()
{
    local comp_name=$1
    local in_file=$2
    local in_tmp_file=${in_file}_tmp
    local out_file=$3
    local DFSNeedCheckSub="OceanStorOS DFS_OBS MON_BJM RPCUser"
    local S3NeedCheckSub="Accesslog Gaussdblog"
    local C01numLimit=0
    local DFSC01LogFile="snas.log.*.tar.gz"
    local S3C01LogFile="s3.log.*.tar.gz"
    local checkfile=${in_file}
    local NeedCheckSub=""
    local C01LogFile=""
    
    LogKeyTarName=$( GetKeyBySub ${comp_name} )
    LOGLimitNum=$( GetLogNumLimit ${comp_name} )
    
    if [[ ${DFSNeedCheckSub} =~ ${comp_name} ]];then
        NeedCheckSub="${DFSNeedCheckSub}"
        C01LogFile="${DFSC01LogFile}"
        checkflag=1   
    elif [[ ${S3NeedCheckSub} =~ ${comp_name} ]];then
        NeedCheckSub="${S3NeedCheckSub}"
        C01LogFile="${S3C01LogFile}"
        checkflag=1  
    fi
    if [ "X1" == "X${checkflag}" ];then
        grep -v "${C01LogFile}" ${in_file} > ${in_tmp_file} 2>&1 || log [$FUNCNAME][$LINENO]"Warning, grep -v  ${DFSC01LogFile}  ${in_file} > ${in_tmp_file} 2>&1 fail"
        #grep "${C01LogFile}" ${in_file} | head -n ${LOGLimitNum}  >> ${in_tmp_file} 2>&1 || log [$FUNCNAME][$LINENO]"Warning, grep  ${DFSC01LogFile}  ${in_file} | grep -n ${LOGLimitNum}  >> ${in_tmp_file} 2>&1 fail"
        checkfile=${in_tmp_file}
    fi 
    linenum=$( grep "${LogKeyTarName}" ${checkfile} | wc -l )
    
    if [  ${linenum}  -ge ${LOGLimitNum} ];then
        KEY=$( grep "${LogKeyTarName}"  ${checkfile} | sed -n  "${LOGLimitNum}p" | awk '{print $1}' |awk -F"/" '{print $NF}' )
        if [ "X" != "X${KEY}" ];then
            limitline=$( sed -n "/${KEY}/=" ${checkfile} )
            head -n ${limitline} ${checkfile} > ${out_file} 2>&1 
        fi
    else
        if [[ ${NeedCheckSub} =~ ${comp_name} ]];then
            let "C01numLimit=LOGLimitNum - linenum"
            grep "${C01LogFile}" ${in_file} | head -n ${C01numLimit}  >> ${in_tmp_file} 2>&1 || log [$FUNCNAME][$LINENO]"Warning, grep "${C01LogFile}" ${in_file} | grep -n ${C01numLimit}  >> ${in_tmp_file} 2>&1 fail"
            checkfile=${in_tmp_file}
        fi

        cp ${checkfile} ${out_file} > /dev/null 2>&1 
    fi 
    
}

function GetLimitFilebyTime()
{
    local in_file=$1
    local out_file=$2
    local C01LogFile=$3
    
    grep -v "${C01LogFile}" ${in_file} > ${out_file} 2>&1 || log [$FUNCNAME][$LINENO]"Warning, grep -v "${C01LogFile}" ${in_file} > ${out_file} fail"
 
}
#parameters:${out_rec} "${start_time}" "${end_time}" ${record_to_collect}
function get_record_bytime()
{
    local rec_fname=$1
    #2018-10-01 19:31:11
    local start_time=$2
    #2018-10-01 19:31:11
    local end_time=$3
    local record_to_collect=$4
    local start_sec=$(getSeconds "${start_time}")
    local end_sec=$(getSeconds "${end_time}")
    local cur_hour=""
    local cur_sec=""
    local record=""
    local filename=""
    local now_size=0
    local tmpdate=""
    local rc=0
    local should_compress=0
    local size=0
    local rec_type="file"
    local des_path=""
    
    if [ "null" == "${start_time}" ] || [ "null" == "${end_time}" ];then
        log [$FUNCNAME][$LINENO]"ERROR:start time:${start_time}, end time:${end_time} is null"
        return 1
    fi
    if [ ! -f ${rec_fname} ];then
        log [$FUNCNAME][$LINENO]"ERROR: input file ${rec_fname} not exist!"
        return 1
    fi
    
    while read record
    do
        rc=0
        ##record format: full_name(in DFS/S3, is short name) ("file"|"dir") size(unit: byte) des_path should_compress utc_seconds
        size=$(echo ${record} | awk -v inx=${INX_SIZE} '{print $inx}' )
        should_compress=$(echo ${record} | awk -v inx=${INX_COMPRESSED} '{print $inx}' )
        cur_sec=$(echo ${record} | awk -v inx=${INX_UTCSEC} '{print $inx}' )
        done=$( echo ${record} | awk -v inx=${INX_DONE} '{print $inx}')
        if [ "X" == "X${size}" ] ;then
            size=0
            log [$FUNCNAME][$LINENO]"Waring: get size from ${record} fail. set size to 0."
        fi
        if [ "X" == "X${should_compress}" ];then
            should_compress=0
            log [$FUNCNAME][$LINENO]"Waring: get should_compress from ${record} fail, set it to 0"
        fi
        if [ "X" == "X${cur_sec}" ] || [ 0 -eq ${cur_sec} ];then
            log [$FUNCNAME][$LINENO]"Waring: get second from ${record} fail, ignore this record."
            continue
        fi
        if [ ${start_sec} -le ${cur_sec} ] && [ ${end_sec} -ge ${cur_sec} ];then
            filename=$(echo ${record} | awk -v inx=${INX_FNAME} '{print $inx}')            
            if [ "X" == "X${filename}" ];then
                log [$FUNCNAME][$LINENO]"ignore this record.get file name from ${record} fail"
                continue
            fi
            rec_type=$(echo ${record} | awk -v inx=${INX_RECTYPE} '{print $inx}')
            if [ "X" == "${rec_type}" ] || [ "file" != "${rec_type}" -a "dir" != "${rec_type}" ];then
                log [$FUNCNAME][$LINENO]"get record type from ${record} fail. set it to file"
                rec_type="file"
            fi
            des_path=$(echo ${record} | awk -v inx=${INX_DESPAHT} '{print $inx}')
            if [ "X" == "X${des_path}" ] || [ ! -d ${des_path} ];then
                log [$FUNCNAME][$LINENO]"get destination path from ${record} fail. ignore this record."
                continue
            fi
            let "now_size+=size"
            echo "${filename} ${rec_type} ${size} ${des_path} ${should_compress} ${done}" >> ${record_to_collect}
            log [$FUNCNAME][$LINENO]"collect:${filename} ${rec_type} ${size} ${des_path} ${should_compress}"
        fi
    done < ${rec_fname}
    log [$FUNCNAME][$LINENO]"get log file list end"
    return 0
}

function dfs_s3_cp()
{
    local param=$*
    if [ -d ${BACKUP_DIR} ];then
        #support access DFS/S3
        cp -pf ${param}
        return $?
    fi
    log [$FUNCNAME][$LINENO]"ERROR, can't access DFS/S3."
    return 1
}
#input file record:
#full_name(in DFS/S3, is short name) ("file"|"dir") size(unit: byte) des_path should_compress utc_seconds
#if value at end of the record is 1, will compressed and put it into destination direction.
#/var/log/startnas.log 1846 1
#/var/log/snas_CM.log 178482 1
#/var/log/cli_start_root.log 1740 1
#/var/log/cli_start_omuser.log 2958 1
#/var/log/snas_CM.log_2018-10-24-00:00:00.132505 344456 1
#/var/log/backup/OM/snas.log.2018-10-23_23.tar.gz 32985 0
#/mnt/s3fs/log/

#paras: ${record_to_collect} ${dfs_cp}
function collect_by_recfile()
{
    local record_to_collect=$1
    local dfs_cp=$2
    local dfs_bak_path="${BACKUP_DIR_ForGrep}"
    local output=""
    local err_cnt=0
    local should_compress=0
    local des_path=""
    local dfs_rc=0
    local rc=0
    local done=0
    local left_size=${TOTAL_SIZE}
    
    if [ ! -f ${record_to_collect} ];then
        log [$FUNCNAME][$LINENO]"ERROR: the file containing log file list ${record_to_collect} is not exist!"
        return 1
    fi
    if [ "X" == "X${dfs_cp}" ];then
        dfs_cp=dfs_s3_cp
    fi
    
    while read record
    do
        output=""
        rc=0
        dfs_rc=0
        should_compress=0
        done=0
        des_path=""
        fname=$(echo ${record} | awk -v inx=${INX_FNAME} '{print $inx}')        
        if [ "X" != "X${fname}" ];then            
            done=$(echo  ${record} | awk -v inx=${INX_DONE} '{print $inx}')
            if [ "X1" == "X${done}" ];then
                log [$FUNCNAME][$LINENO]"Info, record had been collected. ${record}. just ignore it."
                continue
            fi
            should_compress=$(echo ${record} | awk -v inx=${INX_COMPRESSED} '{print $inx}')
            des_path=$(echo ${record} | awk -v inx=${INX_DESPAHT} '{print $inx}')
            if [ ! -d ${des_path} ] ; then
                log [$FUNCNAME][$LINENO]"Warning, destination path:${des_path} not exist! record:${record}"
                continue
            fi
            #жļļϵͳµ,ֻҪǷȫ·,ȫ·Ͳļϵͳ
            echo ${fname} | grep "^/" > /dev/null 2>&1
            if [ 0 -eq $? ] ;then            
                if [ 1 -eq ${should_compress} ];then                    
                    tar_file ${fname} ${des_path} ${left_size}
                    rc=$?
                    if [ 0 -ne ${rc} ];then
                        log [$FUNCNAME][$LINENO]"Warning, tar_file ${fname} ${des_path} ${left_size} fail with ${rc}"
                    fi
                else
                    output=$(cp -f ${fname} ${des_path})
                    rc=$?
                    if [ 0 -ne ${rc} ];then
                        log [$FUNCNAME][$LINENO]"Warning, cp -f ${fname} ${des_path} fail with ${rc}"
                    fi
                fi
                
            else
                #if file is in DFS/S3, using timeout method .ֹļϵͳϵ¿ļ
                if [ 10 -ge ${err_cnt} ];then
                    #in DFS/S3, may blocked for long time. 
                    #űȥȡļ,ǲǻ
                    filename="$( basename $fname )"
                    output=$(CPBackupLog ${filename} ${des_path})
                    dfs_rc=$?  
                else
                    dfs_rc=16
                    output="log file not be collected  for it is in DFS/S3 and alread fail with ${err_cnt} files"
                fi
            fi
            
            if [ 0 -ne ${dfs_rc} ];then
                let "err_cnt+=1"
                log [$FUNCNAME][$LINENO]"Warning: cp ${fname} to ${des_path} fail with ${rc}, error message:${output}"                
            fi
        fi
    done < ${record_to_collect}
    
    return ${err_cnt}
}

#parameters: component_name size start_time end_time callback_getloglist callback_get_utcseconds dfs_cp
#CAUTON:
#   callback_getloglist, the record formatt:
#           search COLLECT_RECORD_FORMAT in this file, to see detail.   
#paras: "OM" ${TOTAL_SIZE} "null" "null" omGetLoglist getUtcSecondsFromOMFileName dfs_s3_cp 
function collect_compressed_logs()
{
    local local_paths=${1}
    local comp_name=${1}
    local size_can_collect=${2}
    local start_time=${3}
    local end_time=${4}
    local callback_getloglist=${5}
    local callback_get_utcseconds=${6}
    local dfs_cp=${7}
    local rc=0
    local DFSNeedCheckSub="OceanStorOS DFS_OBS MON_BJM RPCUser"
    local DFSLowVerLog="snas.log.*.tar.gz"
    local S3NeedCheckSub="Access Gaussdb"
    local S3LowVerLog="s3.log.*.tar.gz"
    local record_to_collect="${TMP_PATH_NEWWAY}/${comp_name}.tobe.collect.info"
    local record_limit_collect="${TMP_PATH_NEWWAY}/${comp_name}.tobelimit.collect.info"
    local out_rec="${TMP_PATH_NEWWAY}/.tmp.${comp_name}.all.info"
    
    if [ "X" == "X${comp_name}" ] || [ "X" == "X${size_can_collect}" ] || [ "X" == "X${start_time}" ] || [ "X" == "X${end_time}" ]  || [ "X" == "X${callback_getloglist}" ] || [ "X" == "X${callback_get_utcseconds}" ] || [ "X" == "X${dfs_cp}" ] ;then
        log [$FUNCNAME][$LINENO]"ERROR: invalid parameters! component:${comp_name}, size:${size_can_collect}, start:${start_time}, end:${end_time}, cb_loglist:${callback_getloglist}, cb_seconds:${callback_get_utcseconds}, cb_cp:${dfs_cp}"
        return 1
    fi
    
    #1. get record which may be collect.
    if [ -f ${record_to_collect} ];then
        rm ${record_to_collect}
    fi
    if [ -f ${record_limit_collect} ];then
        rm ${record_limit_collect}
    fi
    if [ -f ${out_rec} ];then
        rm ${out_rec}
    fi
    if [ ! -d ${TMP_PATH_NEWWAY} ];then
        mkdir -p ${TMP_PATH_NEWWAY} 2>/dev/null
    fi    
    generate_compressed_record ${out_rec} ${comp_name} ${callback_getloglist} ${callback_get_utcseconds}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$FUNCNAME][$LINENO]"ERROR:  ${out_rec} ${comp_name} ${callback_getloglist} ${callback_get_utcseconds} fail with ${rc}"
        return 1
    fi
    
    #2. find compressed log files should be collected.
    if [ "null" == "${start_time}" -a "null" == "${end_time}" ];then
        #collect by size
        #Ӹļtar
        GetLimitFilebySize ${comp_name} ${out_rec} ${record_limit_collect}
        get_record_bysize ${record_limit_collect} ${size_can_collect} ${record_to_collect}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$FUNCNAME][$LINENO]"ERROR: get_record_bysize ${out_rec} ${size_can_collect} ${record_to_collect} fail with ${rc}"
            return 1
        fi
    else
        #collect by time
        if [ "null" == "${start_time}" ] || [ "null" == "${end_time}" ];then
            log [$FUNCNAME][$LINENO]"ERROR: start time:${start_time} or end time:${end_time} is null"
            return 1
        fi
        
        if [[ ${DFSNeedCheckSub} =~ ${comp_name} ]];then
            #DFSģռͰ汾snas.log.*.tar.gz
            GetLimitFilebyTime ${out_rec} ${record_limit_collect} "${DFSNeedCheckSub}"
            #ȡC01汾־
            time=$(getHourBef "${start_time}")
            start_time_Hour=${time}
            hour=$(GetHourTime "${end_time}")
            if [ ${hour} -ge 40 ];then
                end_time_Hour=$(getHour "${end_time}")
            else
                end_time_Hour=$(getHourBef "${end_time}")
            fi
            C01GetAllFile
            EndLine=$( sed -n '$=' ${c01File} 2>/dev/null )
            time_stamp_day=$(getTimeStampDay "${time}")
            endtime=$(getHourBef "${end_time}")
            endtime_stamp_day=$(getTimeStampDay "${endtime}")
            if [ ! -z "$EndLine" ]; then
                log "start collect C01 file"
                modulelist=$( eval echo '$'"Collect_${comp_name}_C01Log" )
                C01FileCollect "${modulelist}" "${time_stamp_day}" "${endtime_stamp_day}" "${MessageDir}/${comp_name}"
                log "end collect C01 file"
            fi
        elif [[ ${S3NeedCheckSub} =~ ${comp_name} ]];then
            #S3ģռͰ汾s3.log.*.tar.gz
            GetLimitFilebyTime ${out_rec} ${record_limit_collect} "${S3LowVerLog}"
        else
            record_limit_collect=${out_rec}
        fi 
        get_record_bytime ${record_limit_collect} "${start_time}" "${end_time}" ${record_to_collect}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$FUNCNAME][$LINENO]"ERROR: get_record_bytime ${out_rec} ${start_time} ${end_time} ${record_to_collect} fail with ${rc}"
            return 1
        fi        
    fi
    
    #3. collect files with the record file.
    collect_by_recfile ${record_to_collect} ${dfs_cp}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$FUNCNAME][$LINENO]"Waring, there are ${err_cnt} files can not collect."
    fi
    return ${rc}
}