#!/bin/bash
set +x

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh

sub_path="${CMLogDir}Disklog"
normal_path="${sub_path}/Normal/"
abnormal_path="${sub_path}/Abnormal/"

G_DISK_NAMESN=${sub_path}/diskname_sn
G_DISK_MML_NAMESN=${sub_path}/diskname_mml_sn
. /opt/node_type_recognize.sh
. /opt/install_os_common_func.sh

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

# 获取当前环境是否是全SAS SSD节点, 参考c代码LNM_GetAllSSDFlag
function IsAllSSDNode()
{
    TMP_NODE_INFO_FILE="/tmp/node_info.txt"
    /usr/local/bin/MmlBatch 4016 "cm node"> $TMP_NODE_INFO_FILE 2>&1
    backIP=$(grep "/opt/huawei/snas/sbin/mml" $TMP_NODE_INFO_FILE | awk -F' ' '{print $3}')
    log "[$FUNCNAME][$LINENO]backIP=${backIP}"
    
    OLD_IFS="$IFS"
    IFS=$'\n'
    nodeInfo=$(grep "Node_ID" $TMP_NODE_INFO_FILE | sed 's/^ *//g'|sed "/^$/d")
    rm -rf $TMP_NODE_INFO_FILE
    # Function_Type从0开始，-1表示没有查找到真正的Function_Type
    devFunType=-1

    for line in $nodeInfo
    do
        currentNodeInfo=$(echo "${line}" | grep "${backIP}")
        if [ "${currentNodeInfo}" = "" ];then
            continue
        else
            devFunType=$(echo "$line" |grep -Po '(?<=Function_Type: )[0-9]*' |tr -d ' ')
            break
        fi
    done
    IFS="$OLD_IFS"

    # NODE_S25A              = 30, /* V3全闪 */
    # NODE_S25B              = 31,
    # NODE_9000_S25X         = 41, /* 2288H V5-2U25全闪存 */
    # NODE_9000_S12A         = 42,
    # NODE_9000_S25A         = 43, /* Taishan 2280 V2-2U25全闪 */
    # NODE_9000_S36A         = 45, /* TaiShan 5280 V2-4U36 全闪 */
    if [ "${devFunType}" -eq 30 ] || [ "${devFunType}" -eq 31 ] || [ "${devFunType}" -eq 41 ] || [ "${devFunType}" -eq 42 ] || [ "${devFunType}" -eq 43 ] || [ "${devFunType}" -eq 45 ];then
        log "[$FUNCNAME][$LINENO]Function_Type:${devFunType}, current node's disk should be all ssd."
        return 0
    else
        log "[$FUNCNAME][$LINENO]Function_Type:${devFunType}, current node's disk should not be all ssd."
        return 1
    fi
}

#获取盘符和SN号，T3000用disktool，服务器用lsscsi和disktool组合
function Get_DISKMap()
{
    local isRH=0
    local isTS=0
    
    set_ifs
    diskDevice=$(/usr/local/bin/disktool -s)
    for line in $diskDevice;do
        diskname=$(echo $line | awk '{printf $1}')
    #排除sda，sdb的系统盘
        echo "$diskname" | grep "/dev/sd-" >/dev/null 2>&1
        if [ $? -eq 0 ];then
            if [ "$diskname" != "/dev/sd-56a" -a "$diskname" != "/dev/sd-57a" ];then
                disk_SN=$(/usr/local/bin/disktool -f i $diskname | grep "Serial Number" | tr -d " " | awk -F":" '{print $2}')
                echo "$diskname $disk_SN" >>$G_DISK_NAMESN
            fi
        else
            log "[$FUNCNAME][$LINENO]$diskname is system disk ,no need to collect."
        fi
    done
    restore_ifs
    
    # NVME需要单独查询
    IsRHV5Node
    isRHV5Node=$?
    IsAllSSDNode
    isAllSSDNode=$?

    if ([ ${isRHV5Node} -eq 0 ] || [ ${isTS} -eq 0 ]) && [ ${isAllSSDNode} -ne 0 ];then
        TMP_NVME_INFO_FILE="/tmp/nvmeinfo.txt"
        # NVME 指定槽位是44~47，最多4块，但是盘符会飘，参数c代码CM_Dev_DiskGetDiskInfo4Nvme遍历0~7
        for i in $(seq 0 7)
        do
            nvme id-ctrl "/dev/nvme${i}" > $TMP_NVME_INFO_FILE 2>&1
            if [ $? -ne 0 ]; then
                continue
            fi

            diskname="/dev/nvme${i}n1"
            disk_SN=$(grep 'sn' "$TMP_NVME_INFO_FILE" | awk '{print $3}')
            log "[$FUNCNAME][$LINENO]i=${i}, find nvme, diskname=${diskname}, disk_SN=${disk_SN}."
            echo "$diskname $disk_SN" >> "$G_DISK_NAMESN"
        done
        
        rm "${TMP_NVME_INFO_FILE}"
    fi
}
#通过cm localdiskinfo show来查询本节点所以正常磁盘的信息
function Get_DISK_MML_MAP()
{
    rm -f /tmp/tmpfilelocaldiskinfo
    /usr/local/bin/MmlBatch 4016 "cm localdiskinfo show" >/dev/null 2>&1
    for i in $(seq 1 15)
    do
        sleep 10
        if [ -f "/tmp/tmpfilelocaldiskinfo" ];then
            break
        else
            log "[$FUNCNAME][$LINENO]times($i) no file(/tmp/tmpfilelocaldiskinfo)."
        fi
    done
    #除了状态为0(未知) 和4(不在位)，其余都显示 (与C代码一致)
    if [ -L $G_DISK_MML_NAMESN ]
    then
        log "[$FUNCNAME][$LINENO]There are security risks, exit -1"
        rm -rf $G_DISK_MML_NAMESN
    fi
    grep -v "Running_Status: 4" /tmp/tmpfilelocaldiskinfo | grep -v "Running_Status: 0"  >$G_DISK_MML_NAMESN
}

get_disk_MANUFACT()
{
    diskManu=$1
    #首先匹配厂商字段
    if [ -n "$(echo "$diskManu" | grep -i "Toshiba")" ]; then
        echo "TB"
        return
    elif [ -n "$(echo "$diskManu" | grep -i "Seagate")" ]; then
        echo "ST"
        return
    elif [ -n "$(echo "$diskManu" | grep -iw "WD")" ]; then
        echo "WD"
        return
    elif [ -n "$(echo "$diskManu" | grep -i "HUASY")" -o -n "$(echo "$diskManu" | grep -i "HUASAI")" -o -n "$(echo "$diskManu" | grep -i "HUAWEI")" ]; then
        echo "HW"
        return
    elif [ -n "$(echo "$diskManu" | grep -i "Hitachi")" -o -n "$(echo "$diskManu" | grep -i "HGST")" -o -n "$(echo "$diskManu" | grep -iw "WDC")" ]; then
        echo "HG"
        return
    elif [ -n "$(echo "$diskManu" | grep -i "SanDisk")" -o -n "$(echo "$diskManu" | grep -i "Samsung")" ]; then
        echo "SD"
        return
    fi

    echo "UNKNOWN"
    return
}

function collect_HDD()
{
    local diskManu=$1
    local diskname=$2
    local diskType=$3
    local disksn=$4

    log "[$FUNCNAME][$LINENO]:$diskManu,$diskname,$diskType,$disksn"
    mkdir ${normal_path}${disksn}
    cd ${normal_path}${disksn}
    diskManu=$(get_disk_MANUFACT "$diskManu")
    if [ "$diskManu" = "ST" ];then
        if [ "$diskType" = "SATA" -o "$diskType" = "SMR_SATA" ];then
            /usr/local/bin/disktool -D ${normal_path}${disksn} -S M $diskname >/dev/null 2>&1
            /usr/local/bin/disktool -D ${normal_path}${disksn} -S U $diskname >/dev/null 2>&1
        else
            /usr/local/bin/disktool -D ${normal_path}${disksn} -A m $diskname >/dev/null 2>&1
            /usr/local/bin/disktool -D ${normal_path}${disksn} -A u $diskname >/dev/null 2>&1
        fi
    elif [ "$diskManu" = "HG" ];then
        if [ "$diskType" = "SATA" -o "$diskType" = "SMR_SATA" ];then
            /usr/local/bin/disktool -D ${normal_path}${disksn} -S H $diskname >/dev/null 2>&1
        else
            /usr/local/bin/disktool -D ${normal_path}${disksn} -A E $diskname >/dev/null 2>&1
        fi
    elif [ "$diskManu" = "WD" ];then
            /usr/local/bin/disktool -D ${normal_path}${disksn} -S R $diskname >/dev/null 2>&1
    elif [ "$diskManu" = "TB" ];then
        if [ "$diskType" = "SATA" -o "$diskType" = "SMR_SATA" ];then
            /usr/local/bin/disktool -D ${normal_path}${disksn} -A T $diskname >/dev/null 2>&1
        else
            /usr/local/bin/disktool -D ${normal_path}${disksn} -A F $diskname >/dev/null 2>&1
        fi
    else
        log "[$FUNCNAME][$LINENO]no this type.diskManu=${diskManu}"
    fi
}

function collect_SSD()
{
    local diskManu=$1
    local diskModel=$2
    local diskname=$3
    local disksn=$4

    diskManu=$(get_disk_MANUFACT "$diskManu")
    log "[$FUNCNAME][$LINENO]$diskManu,$diskModel,$diskname,$disksn"
    mkdir ${normal_path}${disksn}
    cd ${normal_path}${disksn}
    if [ "$diskManu" = "HW" ];then
        if [ "$diskType" = "NVME_SSD" ];then
            /usr/local/bin/disktool -D ${normal_path}${disksn} -f I -b NVME -z HW $diskname >/dev/null 2>&1
        fi
        # ${disksn^^}： convert all lowercase characters in disksn to uppercase.
        /usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn^^}_log.txt -A o -z log $diskname >/dev/null 2>&1
        /usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn^^}_log2.txt -A o -z log2 $diskname >/dev/null 2>&1
        /usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn^^}_log3.txt -A o -z log3 $diskname >/dev/null 2>&1
        /usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn^^}_log4.txt -A o -z log4 $diskname >/dev/null 2>&1
        echo "$diskModel" |grep "HSSD-D5"  >/dev/null 2>&1
        if [ $? -eq 0 ];then
            /usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn^^}_ExtendLog.txt  -A o -z getExtendLog $diskname >/dev/null 2>&1
        fi
    elif [ "$diskManu" = "HG" ];then
        #日立SSD
        /usr/local/bin/disktool -D ${normal_path}${disksn} -A E $diskname >/dev/null 2>&1
    elif [ "$diskManu" = "SD" ];then
        #sandisk SSD
        /usr/local/bin/disktool -D ${normal_path}${disksn} -A D $diskname >/dev/null 2>&1
    else
        log "[$FUNCNAME][$LINENO]no this SSD,diskManu=${diskManu}"
    fi
}
#SATA盘1块收集需要大概3分钟，如果满盘很有可能超时，所以将收集放在后台执行
function collect_log()
{
    log "[$FUNCNAME][$LINENO]start collect Disklog"
    Get_DISKMap
    Get_DISK_MML_MAP
    set_ifs
    diskinfo=$(cat ${G_DISK_NAMESN})
    local DataCollectFile="datacollect_DiskLog$$"
    #生成一个空的临时文件
    >/tmp/$DataCollectFile
    for line in $diskinfo
    do
        while [ 1 ];do
            thread_count=$(grep "begin" /tmp/$DataCollectFile |wc -l)
            if [ $thread_count -ge 5 ];then
                sleep 5
                continue
            else
                {
                    diskname=$(echo $line |awk -F" " '{print $1}')
                    disksn=$(echo $line |awk -F" " '{print $2}')
                    disktype=$(cat $G_DISK_MML_NAMESN | grep $disksn | awk -F'\\|\\|' '{print $6}' | awk -F':' '{print $2}' | tr -d ' ')
                    diskType=$(MapDiskType $disktype)
                    diskModel=$(cat $G_DISK_MML_NAMESN | grep $disksn | awk -F'\\|\\|' '{print $10}' | awk -F':' '{print $2}')
                    diskManu=$(cat $G_DISK_MML_NAMESN | grep $disksn | awk -F'\\|\\|' '{print $12}' | awk -F':' '{print $2}' | tr -d ' ')
                    echo "$disksn begin" >>/tmp/${DataCollectFile}
                    echo "$diskType" |grep "SSD" >/dev/null 2>&1
                    if [ $? -eq 0 ];then
                        collect_SSD "$diskManu" "$diskModel" "$diskname" "$disksn"
                    else
                        collect_HDD "$diskManu" "$diskname" "$diskType" "$disksn"
                    fi
                    move_line=$(cat /tmp/${DataCollectFile} |grep $disksn)
                    log "collect $disksn end."
                    sed -i s/"${move_line}"//g /tmp/${DataCollectFile}
                }&
                sleep 1
                break
            fi
        done
    done
    wait
    restore_ifs

    rm -rf /tmp/${DataCollectFile}
    rm -rf $G_DISK_MML_NAMESN
    rm -rf $G_DISK_NAMESN

    #收集故障盘的日志
    cd $sub_path
    cp -fr /OSM/coffer_data/fault_disklog/* $abnormal_path >/dev/null 2>&1
    tar zcvf ${output_file} ./* >/dev/null 2>&1
    if [ -d ${sub_path} ];then
        rm -rf  ${sub_path}
    fi
    log "[$FUNCNAME][$LINENO]end collect Disklog"
}

#查询本地节点的磁盘信息
function getLocalDiskLogInfo()
{
    local filename="/var/log/cm/DiskLog.tar.gz"
    local DataCollectFile="datacollect_DiskLog$$"
    local disklist="$(echo "$1" | sed 's/:/ /g')"
    local diskSn=""
    local diskname=""
    local diskinfo=""
    local disktype=""
    local diskModel=""
    local diskManu=""
    local tmptype=""
    local diskmmlino=""
    local thread_count=0

    if [ -d "${CMLogDir}" ];then
        rm -rf ${CMLogDir}
    fi
    mkdir -p "${sub_path}"
    mkdir -p "${normal_path}"
    mkdir -p "${abnormal_path}"
    
    log "[$FUNCNAME][$LINENO]start collect Disklog"
    Get_DISKMap
    Get_DISK_MML_MAP
    >/tmp/$DataCollectFile
    
    #保存磁盘盘符和sn
    diskinfo="$(cat $G_DISK_NAMESN)"
    diskmmlino="$(cat ${G_DISK_MML_NAMESN})"
    
    for item in ${disklist}
    do
        diskname=$(echo "${diskinfo}" | grep -w "${item}" | awk '{print $1}')
        if [ "${diskname}X" == "X" ];then
            log "[$FUNCNAME][$LINENO]miss sn=${item}."
        fi
        disksn=${item}
        tmptype=$(echo "${diskmmlino}" | grep -w "${disksn}" | awk -F'\\|\\|' '{print $6}' | awk '{print $2}')
        disktype=$(MapDiskType $tmptype)
        diskModel=$(echo "${diskmmlino}" | grep -w "${disksn}" | awk -F'\\|\\|' '{print $10}' | awk '{print $2}')
        diskManu=$(echo "${diskmmlino}" | grep -w "${disksn}" | awk -F'\\|\\|' '{print $12}' | awk '{print $2}')
        echo "$disksn begin" >>/tmp/${DataCollectFile}
        echo "$disktype" |grep "SSD" >/dev/null 2>&1
        if [ $? -eq 0 ];then
            # ${disksn,,}： convert all uppercase characters in disksn to lowercase.
            collect_SSD "$diskManu" "$diskModel" "$diskname" "${disksn,,}"
        else
            collect_HDD "$diskManu" "$diskname" "$disktype" "${disksn,,}"
        fi
        log "[$FUNCNAME][$LINENO]collect $disksn end."
        [[ -d "${normal_path}${disksn,,}" ]] && mv "${normal_path}${disksn,,}" "${normal_path}${disksn}"
        #收集时每个磁盘间隔120s，防止影响业务
        sleep 120
    done 
    
    rm -rf /tmp/${DataCollectFile}
    rm -rf $G_DISK_MML_NAMESN
    rm -rf $G_DISK_NAMESN

    #收集故障盘的日志
    cd ${sub_path}
    cp -fr /OSM/coffer_data/fault_disklog/* $abnormal_path >/dev/null 2>&1
    tar zcvf ${filename} ./* >/dev/null 2>&1
    if [ -d "${CMLogDir}" ];then
        rm -rf  ${CMLogDir}
    fi
    log "[$FUNCNAME][$LINENO]end collect Disklog"
}

function collect_log()
{
    local action="$1"
    local disklist=""
    if [ "${action}" == "collect" ];then
        #收集磁盘日志信息
        disklist="$2"
        getLocalDiskLogInfo "${disklist}"
    else
        log "[$FUNCNAME][$LINENO]DiskLog param error"
    fi
}

if [ ! -d "$(dirname ${LOG_FILE})" ];then
    mkdir -p $(dirname ${LOG_FILE})
fi 

collect_log "$1" "$2"
exit 0


