#!/bin/sh

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh
TMP_DFS_OBS_BASE_PATH="${CMLogDir}../tmp_DFS_OBS"
TMP_DFS_OBS_MSG_PATH="${TMP_DFS_OBS_BASE_PATH}/Messages"

g_DFS_OBS_collect_bysize=1
SUBNAME="DFS_OBS"
#ļ12
function usage()
{
    echo "$ScriptDFSandOBSFname <product_name> <version> <output_file> <begin_time> <end_time> [log_size]"
    echo "product_name          collect product name"
    echo "version               collect product version"
    echo "output_file           collect file to save the log, eg: *.tar.gz"
    echo "begin_time            collect start time, the default value is null"
    echo "end_time              collect end time, the default value is null"
    echo "log_size              collect size of file"
    return 0
}


#Ҫռ־ȷЩ־ļռ
function get_cfglog_seconds()
{
    local rc=0
    local cur_sec=0
    
    if [ 1 -eq ${g_DFS_OBS_collect_bysize} ];then
        cur_sec=$(date +%s)
        rc=$?
        ret_seconds ${cur_sec}
        return ${rc}
    else
        endtime_s=$( getSeconds "${end_time}" )
        let "cur_sec=endtime_s - 1"
        ret_seconds ${cur_sec}
        return $?
    fi
}
function getUtcSecondsFromDFSOBSFileName()
{
    local fname=$1
    local sname=$(basename ${fname})
    local tmp=""
    local cuttail=""
    local cur_sec=$(get_cfglog_seconds)
    local sec=0
    local rc=0
    
    echo ${sname} | grep "DFS_OBS.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #MON_BJM.log.2019-01-20_21.tar.gz  
        tmp=${sname##*DFS_OBS.log.}
        cuttail=$(echo ${tmp%.tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "DFS_OBS.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #platform.log.2019-01-08_04_1.tar.gz or platform.log.2019-01-08_04_2.tar.gz  
        tmp=${sname##*DFS_OBS.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    echo ${sname} | grep "obs.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #MON_BJM.log.2019-01-20_21.tar.gz  
        tmp=${sname##*obs.log.}
        cuttail=$(echo ${tmp%.tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "obs.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #platform.log.2019-01-08_04_1.tar.gz or platform.log.2019-01-08_04_2.tar.gz  
        tmp=${sname##*obs.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "snasmessages" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snasmessages_2019-01-21-00:00:00.073548 or snasmessages
        tmp=${sname##*snasmessages}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            #snasmessages
            sec=${cur_sec}
        else 
            #snasmessages_2019-01-21-00:00:00.073548 
            #tmp:_2019-01-21-00:00:00.073548
            sec=$(GetSecondForC01 ${tmp#*_})
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "snas_BASE.log" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas_BASE.log_2019-01-21-00:00:28.431003 or snas_BASE.log
        tmp=${sname##*snas_BASE.log}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            #snas_BASE.log
            sec=${cur_sec}
        else 
            #snas_BASE.log_2019-01-21-00:00:28.431003 
            #tmp: _2019-01-21-00:00:28.431003
            sec=$(GetSecondForC01 ${tmp#*_})
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi

    ##/var/log/snas_mon_crit.log snas_fault.log޺׺ʱ
    ret_seconds ${cur_sec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
    fi
    return ${rc}
}

 function DFSOBSGetLoglist()
{
    local out_file=${1}
    local sub_paths="/var/log/snas /var/log/backup/DFS_OBS /var/log/backup/obs"
    local in_rec_file=""
    local des_path="${MessageDir}DFS_OBS"
    local loc_cur_logs="${Collect_DFS_OBS_Other_Log} ${Collect_DFS_OBS_Log}"
    local loc_tar_logs="DFS_OBS.log obs.log"
    local loc_file=""
    local out_basedir=$(dirname ${out_file})
    
    if [ $# -gt 1 ];then
        in_rec_file=${2}
        if [ ! -f ${in_rec_file} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"ERROR, ${in_rec_file} is not exist!"
            return 1
        fi 
        #files in FileSystem ,ǲҪݵͰ汾C01,snas? ,12
        for file in ${loc_tar_logs}
        do
            grep "${file}.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get ${file}.*.tar.gz from ${rec_file} and redirect to ${out_file} fail"
        done
        return 0
    else
        #δѹļ
        for file in ${loc_cur_logs}
        do
            ls -l /var/log/${file}* 2> /dev/null | grep -v ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/${file} >> ${out_file} fail"
        done
       
        #ѹļDFS_OBS.log.2018-11-29_21.tar.gz DFS_OBS.log.2018-11-27_01_1.tar.gz obs.log.2018-12-20_23.tar.gz obs.log.2018-12-20_23_1.tar.gz
        for path in ${sub_paths}
        do
            for file in ${loc_tar_logs}
            do
                if [ -d "${path}" ];then
                    ls -l ${path}/${file}* 2> /dev/null | grep ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/${file}* >> ${out_file} fail"
                fi 
            done
        
        done
        return 0
    fi

}


function DFS_OBS_collect()
{
    log [$SUBNAME]"start collect DFS_OBS,size:${log_size},begin_time:${begin_time},end_time:${end_time}"
    local collect_sub=$1
    local begin_time=$2
    local end_time=$3
    local size=$4
    local need_size="${size}"
    local rc=0
    local sub_path="${MessageDir}DFS_OBS"
    available_size=$(getAvailableSize)
    log "available size is:${available_size}"
    if [ $(echo "${MIN_VALUE} > ${available_size}" | bc) -eq 1  ];then
        echo "collect size will over 90%, exit collect"
        log [$SUBNAME]"collect size will over 90%, exit collect."
        clean
        exit 1
    fi
    
    rm -rf ${sub_path}
    mkdir -p ${sub_path}
    
    collect_compressed_logs "${collect_sub}" "${size}" "${begin_time}" "${end_time}" DFSOBSGetLoglist getUtcSecondsFromDFSOBSFileName dfs_s3_cp
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect_compressed_logs ${collect_sub} ${collect_size} ${begin_time} ${end_time} DFSOBSGetLoglist getUtcSecondsFromDFSOBSFileName dfs_s3_cp fail with ${rc}"
    fi
    
    #delete tempory path.
    if [ -d ${TMP_DFS_OBS_BASE_PATH} ] ;then
        rm -rf ${TMP_DFS_OBS_BASE_PATH} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm ${TMP_DFS_OBS_BASE_PATH} fail"
    fi
    #ʹÿռ
    adjustSize
    real_size=$(du "${sub_path}" | tail -n1 | cut -f1)
    
    #
    cd ${sub_path}
    tar cf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, tar cvf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1  fail with ${rc}"
    fi
    if [ -d ${sub_path} ] ; then
        rm -rf ${sub_path}/* || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm -rf ${sub_path}/* fail"
    fi
    
    log [$SUBNAME]"end collect ${collect_sub},real size is ${real_size},"
    return 0
}

#ռmdsϢ
function collectMdsInfo()
{
    local CmdPort=988

    ##################ȡmdm״̬#########################
    log [$SUBNAME]"start collect mds mdm info"

    #ʾ״̬
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds show trk" > $G_MDS_MDM_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds show trk" > $G_MDS_MDM_FILE"

    #ʾlru״̬
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds show lru" >> $G_MDS_MDM_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds show lru" >> $G_MDS_MDM_FILE"

    #ʾbirthͳļĿ

    #ͳļСֲ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds show file size" >> $G_MDS_MDM_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds show file size" >> $G_MDS_MDM_FILE"

    #ʾԪ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds show meta hit rate" >> $G_MDS_MDM_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds show meta hit rate" >> $G_MDS_MDM_FILE"

    #mds ڲͳ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds statis all" >> $G_MDS_MDM_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds statis all" >> $G_MDS_MDM_FILE"

    ##################ȡmde״̬#########################
    log [$SUBNAME]"start collect mds mde info"

    #ʾMDSCAsession
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds session ca" > $G_MDS_MDE_FILE 2>&1 
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds session ca" > $G_MDS_MDE_FILE"

    #ʾMDSMDSsession
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds session mds" >> $G_MDS_MDE_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds session mds" >> $G_MDS_MDE_FILE"

    #ʾMDSDSsession
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds session ds" >> $G_MDS_MDE_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds session ds" >> $G_MDS_MDE_FILE"

    #ʾMDSMAP
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds map mds" >> $G_MDS_MDE_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds map mds" >> $G_MDS_MDE_FILE"

    #ʾMDS߳Ϣ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds thread show" >> $G_MDS_MDE_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds thread show" >> $G_MDS_MDE_FILE"

    ##################ȡQm״̬#########################
    log [$SUBNAME]"start collect qm mde info"

    #ʾqm serverϢ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds qm srvinfo" > $G_MDS_QM_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds qm srvinfo" > $G_MDS_QM_FILE"

    ##################ȡmain״̬#########################
    log [$SUBNAME]"start collect mds main info"

    #ʾMDSĻϢ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds info show" > $G_MDS_MAIN_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds info show" > $G_MDS_MAIN_FILE"

    #ʾmdsϢ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds cfg show" >> $G_MDS_MAIN_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds cfg show" >> $G_MDS_MAIN_FILE"

    ##################ȡmdb״̬#########################
    log [$SUBNAME]"start collect mds mdb info"

    #ʾǨƶϢ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds mig show" >> $G_MDS_MDB_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds mig show" >> $G_MDS_MDB_FILE"

    #ʾƬѺͷƬۺ϶Ϣ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds frag show" >> $G_MDS_MDB_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds frag show" >> $G_MDS_MDB_FILE"

    #ʾǰmdsǷ˸ؾ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds bal show" >> $G_MDS_MDB_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds bal show" >> $G_MDS_MDB_FILE"

    #ʾýڵվ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds recycle show" >> $G_MDS_MDB_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mds recycle show" >> $G_MDS_MDB_FILE"
    
    #ѼԪУϢ,Ѽ10
    local count=0
    local meta_vfy_files=""
    local rc=0
    
    meta_vfy_files=$(ls /var/log/meta_vfy*)
    rc=$?
    if [ $rc -ne 0 ] || [ -z "${meta_vfy_files}" ]; then
        return 
    fi
    for file in ${meta_vfy_files[*]}
    do
        if [ $count -ge 10 ]; then
            break;
        fi
        cp  -f  ${file}    "$CMLogDir"Other/ >/dev/null 2>&1
        count=$(($count+1))
    done
    rm -f /var/log/meta_vfy*
    
    return 0
}

#ռcaϢ
function collectCaInfo()
{
    local CmdPort=988

    if [ $ServiceType -eq 0 ];then
        cp -f "$CONFIG_DEPLOY"ca_d.ini "$CMLogDir""Config/" >/dev/null 2>&1
    fi
    ##################ȡmem״̬#########################
    log [$SUBNAME]"start collect ca mem info"

    #mml  988˿ִmem show stat 3
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mem show stat 3" > $G_CA_MEM_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "mem show stat 3" > $G_CA_MEM_FILE"

    ##################ȡCAģҵϢ#####################

    #ѯǰCAڵӵMDS״̬
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show mdslist" > $G_CA_MML_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show mdslist" > $G_CA_MML_FILE"

    #ѯquotaϢ    
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show QAInfo" >> $G_CA_MML_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show QAInfo" >> $G_CA_MML_FILE"

    #ѯCAȫֱ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show globalvar" >> $G_CA_MML_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show globalvar" >> $G_CA_MML_FILE"

    #ѯmcacheĻϢ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show mcache" >> $G_CA_MML_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show mcache" >> $G_CA_MML_FILE"

    #ȡλʱȶͳϢ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "gcache getHotStaticInfo" >> $G_CA_MML_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "gcache getHotStaticInfo" >> $G_CA_MML_FILE"

    #ȡܵȶͳϢ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "gcache getStaticInfo" >> $G_CA_MML_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "gcache getStaticInfo" >> $G_CA_MML_FILE"

    #ȡķʴ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "gcache getStripeReadStat" >> $G_CA_MML_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "gcache getStripeReadStat" >> $G_CA_MML_FILE"

    #ȡƽͳƵڴϻ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "gcache getFlatStatic" >> $G_CA_MML_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "gcache getFlatStatic" >> $G_CA_MML_FILE"    

    #ѯϵͳд򿪵ļ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show openfilecnt" >> $G_CA_MML_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show openfilecnt" >> $G_CA_MML_FILE"    

    ##################ȡEIOϢ#####################

    #ִmml鿴EIOϢ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show caerrInfo" > $G_CA_EIO_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show CAErrInfo" > $G_CA_EIO_FILE"   

    #ѯca mapϢ
    cp -f /proc/monc_camap  "$CMLogDir"Other/ 2>&1
    log [$SUBNAME]"cp -f /proc/monc_camap  "$CMLogDir"Other/"

}

#ռDsϢ
function collectDsInfo()
{
    local CmdPort=988

    ##################ȡmml״̬#########################
    log [$SUBNAME]"start collect ds mml info"

    #ȡڵǷ־
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show hln" > $G_DS_MML_FILE 2>&1
    log [$SUBNAME]"$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "show hln" > $G_DS_MML_FILE"

    ##################ȡcmd״̬#########################
    log [$SUBNAME]"start collect ds cmd info"

    #ȡϵͳpoolϢ
    /opt/huawei/snas/sbin/nofs-snas getpoolinfo > $G_DS_CMD_FILE 2>&1
    log [$SUBNAME]"/opt/huawei/snas/sbin/nofs-snas getpoolinfo> $G_DS_CMD_FILE > $G_DS_CMD_FILE"

    #ȡϵͳPOOLϢ
    /opt/huawei/snas/sbin/nofs-snas listpool >> $G_DS_CMD_FILE 2>&1
    log [$SUBNAME]"/opt/huawei/snas/sbin/nofs-snas listpool> $G_DS_CMD_FILE > $G_DS_CMD_FILE"

    #ȡϵͳĴϢ
    lsscsi >> $G_DS_CMD_FILE 2>&1
    log [$SUBNAME]"lsscsi >> $G_DS_CMD_FILE"

    ##################ȡfileϢ״̬#########################

    log [$SUBNAME]"start collect ds file info"

    #ȡ״̬
    cp -f /proc/diskstats "$CMLogDir"Other/ 2>&1
    log [$SUBNAME]"cp -f /proc/diskstats "$CMLogDir"Other/"

    #ȡDS MAP
    cp -f /proc/monc_dsmap "$CMLogDir"Other/ 2>&1
    log [$SUBNAME]"cp -f /proc/monc_dsmap "$CMLogDir"Other/"

    #ȡڻָNLUN״̬
    cp -f /proc/monc_recoverymap  "$CMLogDir"Other/ 2>&1
    log [$SUBNAME]"cp -f /proc/monc_recoverymap  "$CMLogDir"Other/"

    #ȡ/proc/drm_*
    cp -f /proc/drm_* "$CMLogDir"Other/ >/dev/null 2>&1
    log [$SUBNAME]"cp -f /proc/drm_*  "$CMLogDir"Other/"
    
    #ȡ/proc/dbm_*
    cp -f /proc/dbm_* "$CMLogDir"Other/ >/dev/null 2>&1
    log [$SUBNAME]"cp -f /proc/dbm_*  "$CMLogDir"Other/"
    
    #ȡ/proc/ds_*
    cp -f /proc/ds_* "$CMLogDir"Other/ >/dev/null 2>&1
    log [$SUBNAME]"cp -f /proc/ds_*  "$CMLogDir"Other/"
    
    #ȡ/proc/dab_*
    cp -f /proc/dab_* "$CMLogDir"Other/ >/dev/null 2>&1
    log [$SUBNAME]"cp -f /proc/dab_*  "$CMLogDir"Other/"
    
    #ȡproc/ccdb_statemap
    cp -f /proc/ccdb_statemap "$CMLogDir"Other/ >/dev/null 2>&1
    log [$SUBNAME]"cp -f /proc/ccdb_statemap  "$CMLogDir"Other/"
    
    numCnt=1
    while [ "${numCnt}" -le 2 ]; do 

        #ȡJEMеϢϢ
        cat /proc/JEM_Request >> "$CMLogDir"Other/JEM_Request_info 2>&1
        log [$SUBNAME]"cat /proc/JEM_Request >> "$CMLogDir"Other/JEM_Request_info"

        #ȡд
        cat /proc/opm_writemsg >> "$CMLogDir"Other/opm_writemsg_info 2>&1
        log [$SUBNAME]"cat /proc/opm_writemsg >> "$CMLogDir"Other/opm_writemsg_info"

        #ȡĶ
        cat /proc/opm_readmsg >> "$CMLogDir"Other/opm_readmsg_info 2>&1
        log [$SUBNAME]"cat /proc/opm_readmsg >> "$CMLogDir"Other/opm_readmsg_info"

        #ȡDSͳϢ
        cat /proc/diskstats >> "$CMLogDir"Other/drm_msg_static_info 2>&1
        log [$SUBNAME]"cat /proc/drm_msg_static >> "$CMLogDir"Other/drm_msg_static_info"

        #ȡڻָNLUN״̬Ǩ
        cat /proc/drm_need_recover >> "$CMLogDir"Other/drm_need_recover_info 2>&1
        log [$SUBNAME]"cat /proc/drm_need_recover >> "$CMLogDir"Other/drm_need_recover_info"

        #ȡָ߳еϢͳϢ
        cat /proc/drm_perf_info >> "$CMLogDir"Other/drm_perf_info_info 2>&1
        log [$SUBNAME]"cat /proc/drm_perf_info >> "$CMLogDir"Other/drm_perf_info_info"

        sleep 1
        numCnt=$((numCnt+1))
    done    

    #ȡеJEM̶߳ջϢ
    mkdir -p ${StackDir}
    ps=`ps -efww |grep JEM|grep -v grep |awk 'BEGIN {FS=" "} {print $2}'`
    for i in $ps
    do
        cat /proc/$i/stack > "$StackDir"/stack_JEM_$i 2>&1
    done
    log [$SUBNAME]"get JEM stack info"

    #ȡеDRM̶߳ջϢ
    ps=`ps -efww |grep drm|grep -v grep |awk 'BEGIN {FS=" "} {print $2}'` 2>&1
    for i in $ps
    do
        cat /proc/$i/stack > "$StackDir"/stack_drm_$i 2>&1
    done
    log [$SUBNAME]"get drm stack info"

    cp -f "$CONFIG_DEPLOY"ds.ini  "$CMLogDir""Config/" >/dev/null 2>&1
}

function main()
{
    if [ "X${type}" == "Xconfig" ];then
        collectDsInfo
        if [ $ServiceType -eq 0 ];then
            collectCaInfo
            collectMdsInfo
        fi
        return 0
    elif [ "X${type}" == "Xlog" ];then
        if [ "X$begin_time" != "Xnull" -o "X$end_time" != "Xnull" ];then
            g_DFS_OBS_collect_bysize=0
            log_size="0" 
        fi
        DFS_OBS_collect "DFS_OBS" "${begin_time}" "${end_time}" "${log_size}"
        return $?
    else
        usage
        return 1
    fi
    return 1
}

type=$1
product_name=$2
version=$3
output_file=$4
begin_time=$5
end_time=$6
log_size=$7

#жϲƷ
judge_product_type
product_type
prepare

main
exit $?