#!/bin/sh

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh
TMP_RPCUser_BASE_PATH="${CMLogDir}../tmp_RPCUser"
TMP_RPCUser_MSG_PATH="${TMP_RPCUser_BASE_PATH}/Messages"
g_RPCUser_collect_bysize=1
SUBNAME="RPCUser"
#12
function usage()
{
    echo "$ScriptRPCUserFname <product_name> <version> <output_file> <begin_time> <end_time> [log_size]"
    echo "product_name          collect product name"
    echo "version               collect product version"
    echo "output_file           collect file to save the log, eg: *.tar.gz"
    echo "begin_time            collect start time, the default value is null"
    echo "end_time              collect end time, the default value is null"
    echo "log_size              collect size of file"
    return 0
}

#Ҫռ־ȷЩ־ļռ
function get_cfglog_seconds()
{
    local rc=0
    local cur_sec=0
    
    if [ 1 -eq ${g_RPCUser_collect_bysize} ];then
        cur_sec=$(date +%s)
        rc=$?
        ret_seconds ${cur_sec}
        return ${rc}
    else
        endtime_s=$( getSeconds "${end_time}" )
        let "cur_sec=endtime_s - 1"
        ret_seconds ${cur_sec}
        return $?
    fi
}

function getUtcSecondsFromRPCUserFileName()
{
    local fname=$1
    local sname=$(basename ${fname})
    local tmp=""
    local cuttail=""
    local cur_sec=$(get_cfglog_seconds)
    local sec=0
    local rc=0
    
    echo ${sname} | grep "RPCUser.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #RPCUser.log.2019-01-18_04.tar.gz  
        tmp=${sname##*RPCUser.log.}
        cuttail=$(echo ${tmp%.tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "RPCUser.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #RPCUser.log.2019-01-18_04_1.tar.gz  
        tmp=${sname##*RPCUser.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    #Ͱ汾snas.log
    echo ${sname} | grep "snas.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas_CM.log_2018-10-15-23.00.00.234996.tar.gz
        #snas.log.2019-04-02_21.tar.gz 
        tmp=${sname##*snas.log.}
        cuttail=$(echo ${tmp%.tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "snas.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas.log.2019-01-08_04_1.tar.gz  
        tmp=${sname##*snas.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    ##/var/log/#rpc-4060.2019-01-20-23:40:48.logǰ־,ʱ䲻ļлȡ
    ret_seconds ${cur_sec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
    fi
    return ${rc}
}
 function RPCUserGetLoglist()
{
    local out_file=${1}
    local sub_paths="/var/log/snas /var/log/backup/RPCUser"
    local in_rec_file=""
    local des_path="${MessageDir}RPCUser"
    local loc_cur_logs="${Collect_RPC_Other_Log} ${Collect_RPC_Log}"
    local loc_tar_logs="RPCUser.log"
    #֮ǰĴ߼ﶼsnas.log־, C01汾snas_CM.log.*.tar.gz,Ͱ汾ǲһ
    local C01_file_paths="/var/log/snas /var/log/backup/snas"
    local loc_C01_logs="snas.log"
    local loc_file=""
    local out_basedir=$(dirname ${out_file})
    
    if [ $# -gt 1 ];then
        in_rec_file=${2}
        if [ ! -f ${in_rec_file} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"ERROR, ${in_rec_file} is not exist!"
            return 1
        fi 
        #files in FileSystem ,ǲҪݵͰ汾C01,snas? ,12
        for file in ${loc_tar_logs}
        do
            grep "${file}.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get ${file}.*.tar.gz from ${rec_file} and redirect to ${out_file} fail"
        done
        return 0
    else
        #δѹļʱĸļ,кܶ,cmr_auth.log,cmr_auth.log.1ʽ,Ҫע.1ʽ־
        for file in ${loc_cur_logs}
        do
            ls -l /var/log/${file}* 2> /dev/null | grep -v ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/${file} >> ${out_file} fail"
        done
       
        #ѹļRPCUser.log.2019-01-18_04.tar.gz 
        for path in ${sub_paths}
        do
            for file in ${loc_tar_logs}
            do
                if [ -d "${path}" ];then
                    ls -l ${path}/${file}* 2> /dev/null | grep ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/${file}* >> ${out_file} fail"
                fi 
            done
        
        done
        #C01Ͱ汾־ 
        #(C01汾ֻ/var/logsnas_CM.log,û/var/log/snas ,/var/log/backup/Ŀ¼, ֮C01汾־ȥ?)
        #Ͱ汾Ҫ:/var/log/snas/snas.log.*.tar.gz ,/var/log/backup/snas.log.*.tar.gz,/mnt/.../snas.log.*.tar.gz ,ڱģ־ûյ12ʱȥռsnas.log.*.tar.gz
        for C01path in ${C01_file_paths}
        do
            if [ -d ${C01path} ];then
                ls -l ${C01path}/${loc_C01_logs}* 2> /dev/null | grep ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/backup/ISM/ibase.log* >> ${out_file} fail"
            fi
        done
        return 0
    fi

}

function RPCUser_collect()
{
    log [$SUBNAME]"start collect RPCUser,size:${log_size},begin_time:${begin_time},end_time:${end_time}"
    local collect_sub=$1
    local begin_time=$2
    local end_time=$3
    local size=$4
    local need_size="${size}"
    local rc=0
    local sub_path="${MessageDir}RPCUser"
    available_size=$(getAvailableSize)
    log "available size is:${available_size}"
    if [ $(echo "${MIN_VALUE} > ${available_size}" | bc) -eq 1  ];then
        echo "collect size will over 90%, exit collect"
        log [$SUBNAME]"collect size will over 90%, exit collect."
        clean
        exit 1
    fi
    
    rm -rf ${sub_path}
    mkdir -p ${sub_path}

    # ָʱռRPCUser־RPCUser־ڰռԣstarttimeǰӳһСʱendtimeӳһСʱ
    begin_time_sec=$( date -d "${begin_time}" +%s )
    if [ $? -eq 0 ]; then
        begin_time_sec=$( expr ${begin_time_sec} - 3600 )
        [ $? -eq 0 ] && begin_time=$( date -d @"${begin_time_sec}" "+%Y-%m-%d %H:%M:%S" )
    fi

    end_time_sec=$( date -d "${end_time}" +%s )
    if [ $? -eq 0 ]; then
        end_time_sec=$( expr ${end_time_sec} + 3600 )
        [ $? -eq 0 ] && end_time=$( date -d @"${end_time_sec}" "+%Y-%m-%d %H:%M:%S" )
    fi
    
    if [ X"${size}" == X"0" ]; then
        log [$SUBNAME]"after change time. begin_time:${begin_time},end_time:${end_time}"
    fi

    collect_compressed_logs "${collect_sub}" "${size}" "${begin_time}" "${end_time}" RPCUserGetLoglist getUtcSecondsFromRPCUserFileName dfs_s3_cp
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect_compressed_logs ${collect_sub} ${collect_size} ${begin_time} ${end_time} RPCUserGetLoglist getUtcSecondsFromRPCUserFileName dfs_s3_cp fail with ${rc}"
    fi
    
    #delete tempory path.
    if [ -d ${TMP_RPCUser_BASE_PATH} ] ;then
        rm -rf ${TMP_RPCUser_BASE_PATH} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm ${TMP_RPCUser_BASE_PATH} fail"
    fi
    #ʹÿռ
    adjustSize
    real_size=$(du "${sub_path}" | tail -n1 | cut -f1)
    
    #
    cd ${sub_path}
    #tar zcvf ${output_file} ./* >/dev/null 2>&1
    tar cvf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, tar cvf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1  fail with ${rc}"
    fi
    if [ -d ${sub_path} ] ; then
        rm -rf ${sub_path}/* || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm -rf ${sub_path}/* fail"
    fi
    
    log "end collect ${collect_sub},real size is ${real_size},"
    return 0
}

#ռRPCUserϢ
function collectRPCUserInfo()
{
    return
}

function main()
{
    if [ "X${type}" == "Xconfig" ];then
        collectRPCUserInfo
        return 0
    elif [ "X${type}" == "Xlog" ];then
        if [ "X$begin_time" != "Xnull" -o "X$end_time" != "Xnull" ];then
            g_RPCUser_collect_bysize=0
            log_size="0" 
        fi
        RPCUser_collect "RPCUser" "${begin_time}" "${end_time}" "${log_size}"
        return $?
    else
        usage
        return 1
    fi
    return 1
}

type=$1
product_name=$2
version=$3
output_file=$4
begin_time=$5
end_time=$6
log_size=$7

#жϲƷ
judge_product_type
prepare

main
exit $?