#!/bin/bash
CUR_PATH=$(dirname $(readlink -f $BASH_SOURCE))
SCRIPTNAME=$(basename $0)
DSWARE_ROOT_DIR="/opt/fusionstorage"
FSM_AGENT_DIR="${DSWARE_ROOT_DIR}/agent"
#管理节点
REMOTE_USER="fsadmin"
REMOTE_PASSWD=""
CM_URL="cm_url"
LOCAL_IP="local_ip"
DLM_MM_LOCAL_IP="mm_local_ip"
LOCAL_DATA_IP="local_data_ip"
ZK_IP_LIST="zk_ip_list"
ZK_ESN="zk_esn"
ZK_SLOT="zk_slot"
CM_CFG_FILE="/opt/dsware/infrastructure/cm/config/cm.cfg"
ZK_SLOT_INFO="/opt/fusionstorage/agent/conf/zk_slot_info"
EDS_SLOT_INFO="/opt/fusionstorage/agent/conf/eds_ccdb_slot_info"
readonly OPERATE_FILE_SHELL_NAME="/opt/fusionstorage/agent_safe/script/rootScript/agent_operate_sys.sh"
readonly MULTI_POOL_OPER_SCRIPT="/opt/fusionstorage/agent/script/multi_pool_oper.sh"
source /etc/node_manager_ip
declare -A COMPONENT_SCRIPT=(\
["arb_ctrl_agent"]="/opt/dsware/infrastructure/cm/script/arb_ctrl_handle.sh" \
["cm"]="/opt/dsware/infrastructure/cm/script/cm_handle.sh" \
["cmsworker"]="/opt/dsware/infrastructure/snm/OSM/script/cmsworker_handle.sh" \
["ccdb_monitor"]="/opt/dsware/infrastructure/ccdb/ccdb_monitor/script/ccdb_monitor_handle.sh" \
["ccdb_server"]="/opt/dsware/infrastructure/ccdb/ccdb_server/script/ccdb_server_handle.sh" \
["ccdbx"]="/opt/dsware/infrastructure/ccdbx/script/ccdb_server_handle.sh" \
["djob"]="/opt/dsware/infrastructure/djob/script/djob_handle.sh" \
["dlm_vm"]="/opt/dsware/infrastructure/dlm_vm/script/dlm_vm_handle.sh" \
["dlm_mm"]="/opt/dsware/infrastructure/dlm_mm/script/dlm_mm_handle.sh" \
["kmm_server"]="/opt/dfv/oam/oam-u/kmm-server/script/kms_handle.sh" \
["EBSCtrl"]="/opt/dsware/eds/eds/script/appctl_fsa.sh" \
["nodesentry"]="/opt/dsware/infrastructure/snm/OSM/script/nodesentry_handle.sh" \
["fdsaCore"]="/opt/fusionstorage/fdsa/script/fdsa_cluster_srv_handle.sh" \
["ls"]="/opt/dfv/obs_service_layer/objectroutingservice/ls/bin/ls_dsware_agent.sh" \
)

declare -A arb_ctrl_agent_OPERATE_COMPONENT_SCRIPT=(\
["stop"]="/opt/dsware/infrastructure/cm/script/arb_ctrl_handle.sh" \
["start"]="/opt/dsware/infrastructure/cm/script/arb_ctrl_handle.sh" \
)
declare -A cm_OPERATE_COMPONENT_SCRIPT=(\
["disable_arb"]="/opt/dsware/infrastructure/cm/script/cm_handle.sh" \
["recover_arb"]="/opt/dsware/infrastructure/cm/script/cm_handle.sh" \
)
declare -A cmsworker_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A ccdb_monitor_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A ccdb_server_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A ccdbx_OPERATE_COMPONENT_SCRIPT=(\
["stopCcdbxArb"]="/opt/dsware/infrastructure/ccdbx/script/ccdb_transform_database.sh" \
["startCcdbxArb"]="/opt/dsware/infrastructure/ccdbx/script/ccdb_transform_database.sh" \
["transCcdbxDb"]="/opt/dsware/infrastructure/ccdbx/script/ccdb_transform_database.sh" \
["rollBackTransCcdbxDb"]="/opt/dsware/infrastructure/ccdbx/script/ccdb_transform_database.sh" \
)
declare -A djob_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A dlm_vm_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A dlm_mm_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A kmm_server_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A EBSCtrl_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A nodesentry_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A fdsaCore_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A osd_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A poe_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A volume_OPERATE_COMPONENT_SCRIPT=(\
)
declare -A arb_ctrl_agent_OPERATE_COMPONENT_FUNCTION=(\
)
declare -A cm_OPERATE_COMPONENT_FUNCTION=(\
)
declare -A cmsworker_OPERATE_COMPONENT_FUNCTION=(\
)
declare -A ccdb_monitor_OPERATE_COMPONENT_FUNCTION=(\
)
declare -A ccdb_server_OPERATE_COMPONENT_FUNCTION=(\
)
declare -A ccdbx_OPERATE_COMPONENT_FUNCTION=(\
)
declare -A djob_OPERATE_COMPONENT_FUNCTION=(\
)
declare -A dlm_vm_OPERATE_COMPONENT_FUNCTION=(\
)
declare -A dlm_mm_OPERATE_COMPONENT_FUNCTION=(\
)
declare -A kmm_server_OPERATE_COMPONENT_FUNCTION=(\
)
declare -A EBSCtrl_OPERATE_COMPONENT_FUNCTION=(\
["notify_process"]="NotifyEBSCtrlProcessBySignal" \
)
declare -A nodesentry_OPERATE_COMPONENT_FUNCTION=(\
)
declare -A fdsaCore_OPERATE_COMPONENT_FUNCTION=(\
)
declare -A osd_OPERATE_COMPONENT_FUNCTION=(\
["notify_process"]="NotifyOsdProcessBySignal" \
)
declare -A ls_OPERATE_COMPONENT_FUNCTION=(\
["notify_process"]="NotifyLsProcessByScript" \
)

declare -A ADD_COMPONENT_SCRIPT=(\
["arb_ctrl_agent"]="/opt/dsware/infrastructure/cm/script/arb_ctrl_handle.sh" \
["cm"]="/opt/dsware/infrastructure/cm/script/cm_handle.sh" \
["cmsworker"]="/opt/dsware/infrastructure/snm/OSM/script/cmsworker_handle.sh" \
["ccdb_monitor"]="/opt/dsware/infrastructure/ccdb/ccdb_monitor/script/ccdb_monitor_handle.sh" \
["ccdb_server"]="/opt/dsware/infrastructure/ccdb/ccdb_server/script/ccdb_server_handle.sh" \
["ccdbx"]="/opt/dsware/infrastructure/ccdbx/script/ccdb_server_handle.sh" \
["djob"]="/opt/dsware/infrastructure/djob/script/djob_handle.sh" \
["dlm_vm"]="/opt/dsware/infrastructure/dlm_vm/script/dlm_vm_handle.sh" \
["dlm_mm"]="/opt/dsware/infrastructure/dlm_mm/script/dlm_mm_handle.sh" \
["kmm_server"]="/opt/dfv/oam/oam-u/kmm-server/script/kms_handle.sh" \
["EBSCtrl"]="/opt/dsware/eds/eds/script/appctl_fsa.sh" \
["nodesentry"]="/opt/dsware/infrastructure/snm/OSM/script/nodesentry_handle.sh" \
["fdsaCore"]="/opt/fusionstorage/fdsa/script/fdsa_cluster_srv_handle.sh" \
["ls"]="/opt/dfv/obs_service_layer/objectroutingservice/ls/bin/ls_dsware_agent.sh" \
)
declare -A DELETE_COMPONENT_SCRIPT=(\
["arb_ctrl_agent"]="/opt/dsware/infrastructure/cm/script/arb_ctrl_handle.sh" \
["cm"]="/opt/dsware/infrastructure/cm/script/cm_handle.sh" \
["cmsworker"]="/opt/dsware/infrastructure/snm/OSM/script/cmsworker_handle.sh" \
["ccdb_monitor"]="/opt/dsware/infrastructure/ccdb/ccdb_monitor/script/ccdb_monitor_handle.sh" \
["ccdb_server"]="/opt/dsware/infrastructure/ccdb/ccdb_server/script/ccdb_server_handle.sh" \
["ccdbx"]="/opt/dsware/infrastructure/ccdbx/script/ccdb_server_handle.sh" \
["djob"]="/opt/dsware/infrastructure/djob/script/djob_handle.sh" \
["dlm_vm"]="/opt/dsware/infrastructure/dlm_vm/script/dlm_vm_handle.sh" \
["dlm_mm"]="/opt/dsware/infrastructure/dlm_mm/script/dlm_mm_handle.sh" \
["kmm_server"]="/opt/dfv/oam/oam-u/kmm-server/script/kms_handle.sh" \
["EBSCtrl"]="/opt/dsware/eds/eds/script/appctl_fsa.sh" \
["nodesentry"]="/opt/dsware/infrastructure/snm/OSM/script/nodesentry_handle.sh" \
["fdsaCore"]="/opt/fusionstorage/fdsa/script/fdsa_cluster_srv_handle.sh" \
["ls"]="/opt/dfv/obs_service_layer/objectroutingservice/ls/bin/ls_dsware_agent.sh" \
)
declare -A CHECK_COMPONENT_STATUS_MAP=(\
["ccdb_server"]="CheckCcdbServerStatus" \
["dlm_mm"]="CheckDlmMmStatus" \
["cm"]="CheckStatusByScript" \
["cmsworker"]="CheckStatusByScript" \
["osd"]="CheckOsdStatusByScript" \
)

declare -A RESTART_COMPONENT_MAP=(\
["cm"]="RestartCm" \
["vbs"]="RestartVbs" \
["cmsworker"]="RestartCmsWorker" \
["osd"]="ReloadProcessCfg" \
["EBSCtrl"]="ReloadProcessCfg" \
["fdsaCore"]="RestartComponentByStopStart" \
["ls"]="ReloadProcessCfg" \
["kmm_server"]="RestartComponentByStopStart" \
["zk"]="RestartZk" \
)

declare -A STOP_COMPONENT_MAP=(\
)

declare -A COMPONENT_PROCESS_NAME_MAP=(\
["cm"]="clustermanager" \
["cmsworker"]="cmsworker" \
["ccdbx"]="ccdb_server" \
["ccdb_monitor"]="ccdb_monitor" \
["ccdb_server"]="ccdb_server" \
["djob"]="djob" \
["dlm_vm"]="dlm_vm" \
["dlm_mm"]="dlm_mm" \
["kmm_server"]="kmm_server" \
["EBSCtrl"]="eds" \
["nodesentry"]="nodesentry" \
["vbs"]="dsware_vbs" \
["osd"]="dsware_osd" \
["fdsaCore"]="fdsacore" \
["ls"]="/opt/dfv/obs_service_layer/objectroutingservice/ls" \
)

declare -a arb_ctrl_agent_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/cm/config/arb_ctrl.cfg")
declare -a cm_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/cm/config/cm.cfg")
declare -a cmsworker_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/snm/OSM/config/cmsworker.cfg")
declare -a ccdbx_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/ccdbx/config/ccdb_server.cfg")
declare -a ccdb_monitor_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/ccdb/ccdb_monitor/config/ccdb_monitor.cfg")
declare -a ccdb_server_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/ccdb/ccdb_server/config/ccdb_server.cfg")
declare -a djob_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/djob/config/djob.cfg")
declare -a dlm_vm_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/dlm_vm/config/dlm_vm.cfg")
declare -a dlm_mm_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/dlm_mm/config/dlm_mm.cfg")
declare -a kmm_server_COMPONENT_CONFIGRATION=("/opt/dfv/oam/oam-u/data/kmm-server/kmm_server.cfg")
declare -a vbs_COMPONENT_CONFIGRATION=("/opt/dsware/vbs/conf/dr_driver.cfg" "/opt/dsware/vbs/conf/vbs_*_config.cfg")
declare -a EBSCtrl_COMPONENT_CONFIGRATION=("/opt/dsware/eds/eds/conf/ebs_server.conf")
declare -a nodesentry_COMPONENT_CONFIGRATION=("/opt/dsware/infrastructure/snm/OSM/config/nodesentry.cfg")
declare -a osd_COMPONENT_CONFIGRATION=("/opt/fusionstorage/persistence_layer/osd/conf/osd_*_conf.cfg")
declare -a fdsaCore_COMPONENT_CONFIGRATION=("/opt/fusionstorage/fdsa/conf/fdsa_cluster_srv.conf")
declare -a ls_COMPONENT_CONFIGRATION=("/opt/dfv/obs_service_layer/objectroutingservice/ls/conf/obs_sod_from_fsm.ini")
declare -a zk_COMPONENT_CONFIGRATION=("/opt/fusionstorage/persistence_layer/agent/zk/conf/zoo.cfg")

SHELL_LOG_FULL_PATH=""
MAX_LOG_NUM=5

function InitLogDirPermission()
{
    if [ ! -d ${ROOT_LOG_DIR} ]; then 
        mkdir -p ${ROOT_LOG_DIR}
        chmod 755 /var
        chmod 755 /var/log
        chmod 755 /var/log/oam
        chmod 750 /var/log/oam/fsa
    fi
    #add set dir user
    return 0
}

function InitLog()
{
    SHELL_LOG_DIR=$1
    SHELL_LOG_NAME=$2

    if [ ! -d "${ROOT_LOG_DIR}" ]; then
        InitLogDirPermission
    fi
    
    mkdir -p ${SHELL_LOG_DIR}
    SHELL_LOG_FULL_PATH="${SHELL_LOG_DIR}/${SHELL_LOG_NAME}"

    if [ ! -f "${SHELL_LOG_FULL_PATH}" ]; then
        touch "${SHELL_LOG_FULL_PATH}"
        chmod 640 ${SHELL_LOG_FULL_PATH}
    fi
}

function RotateLog()
{
    local logAFile=""
    local logBFile=""
    local logIndex=""
    for ((logIndex=${MAX_LOG_NUM}; logIndex>1; logIndex--));
    do
        logAFile="${SHELL_LOG_FULL_PATH}.$(expr ${logIndex} - 1).gz"
        logBFile="${SHELL_LOG_FULL_PATH}.${logIndex}.gz"
        if [ -f "${logAFile}" ]; then
            mv "${logAFile}" "${logBFile}" >>/dev/null 2>&1
            if [ $? -ne 0 ]; then
                echo "mv ${logAFile} ${logBFile} failed."
                return 1
            fi
        fi
    done

    gzip -f "${SHELL_LOG_FULL_PATH}" >>/dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "Compress ${SHELL_LOG_FULL_PATH} to gzip failed."
        return 1
    fi
    
    if [ ! -f "${SHELL_LOG_FULL_PATH}" ]; then
        touch "${SHELL_LOG_FULL_PATH}"
        chown ${OAME_USER_OMM}:${OAME_GROUP_OMM} ${SHELL_LOG_FULL_PATH}
        chmod 640 ${SHELL_LOG_FULL_PATH}
    fi
    
    chmod 440 ${SHELL_LOG_FULL_PATH}.gz
    chown ${OAME_USER_OMM}:${OAME_GROUP_OMM} ${SHELL_LOG_FULL_PATH}
    mv ${SHELL_LOG_FULL_PATH}.gz ${SHELL_LOG_FULL_PATH}.1.gz
    return 0
}

#===  FUNCTION  ================================================================
#         NAME: LOG
#      PURPOSE: print log
#   PARAMETERS: NA
#      RETURNS: NA
#===============================================================================
function ScriptExeLog()
{
    local param1=$1
    local param2=$2
    local param3=$3

    echo "[""$(date +'%F %T')""]""[${node_manager_ip}]""[""${param1}""]""[""${param2}""]""[""${param3}""]" >> "${SHELL_LOG_FULL_PATH}" 2>/dev/null

    local logFileSize=$(du -s "${SHELL_LOG_FULL_PATH}" | awk '{print $1}')
    if [ "${logFileSize}" -gt 1024 ]; then
        RotateLog
    fi
}

function ScriptPrintLog()
{
    local param1=$1
    local param2=$2
    local param3=$3

    echo "[""$(date +'%F %T')""]""[${node_manager_ip}]""[""${param1}""]""[""${param2}""]""[""${param3}""]"
    ScriptExeLog "${param1}" "${param2}" "${param3}"
}

function usage()
{
    ScriptPrintLog "Usage: ${0##*/} {start|restart|generateComponetCfg|refreshCfg|refreshCfgAndReboot|expandLs|addAcl|checkStatus}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    exit 1
}

function PrintResultFlag()
{
    local excuteResult=$1
    local operateName=$2
    local param=$3

    ScriptPrintLog "@@RESULT=${excuteResult}@@OPERATION=${operateName}@@PARAM=${param}@@. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function EchoResultFlag()
{
    local excuteResult=$1
    local operateName=$2
    local param=$3

    echo "@@RESULT=${excuteResult}@@OPERATION=${operateName}@@PARAM=${param}@@. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

#=== FUNCTION ================================================================
#     NAME: ModifyConf
#   PURPOSE: modify config file
#  PARAMETERS: componentName:
#        upgradeResult:
#   RETURNS: NA
#===============================================================================
function ModifyConf()
{
    local key=$1
    local value=$2
    local configFile=$3
    local configFileName=`basename "${configFile}"`
    
    if [ ! -f "${configFile}" ] ; then
        ScriptPrintLog "ERROR:${configFileName} does dot exist.[Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local isExist=$(grep "^\s*${key}\s*=" "${configFile}")
    if [ $? -ne 0 ] ; then
        ScriptPrintLog "ERROR:get ${key} from ${configFileName} failed.[Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    elif [ -z "${isExist}" ] ; then
        echo "${key}=${value}" >> "${configFile}"
    else
        sed -i "s#^\s*${key}\s*=.*#${key}=${value}#g" "${configFile}" 
    fi

    if [ $? -eq 0 ] ; then
        ScriptPrintLog "INFO:modify ${configFileName} ${key} successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    else
        ScriptPrintLog "ERROR:modify ${configFileName} ${key} failed.[Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
}

############################################################################
function Scp2Remote()
{
    local filename=$1
    local destIp=$2
    local user=$3
    local pass=$4
    local path=$5

    expect -c "
    set timeout 300;
    spawn scp -o StrictHostKeyChecking=no $filename $user@\[$destIp\]:${path}
    expect {
        *yes/no {
            send yes\r;
            exp_continue
        }
        *assword:* {
            send $pass\r;
        }
    }
    expect *#* {}
    "

    ret=$?
    return $ret
}

function SingleScp2Remote()
{
    local type=$1
    local file=$2
    local IP=$3
    local path=$4

    # cp script to remote
    Scp2Remote "${file}" $IP $REMOTE_USER $REMOTE_PASSWD $path
    if [ $? -ne 0 ];then
        ScriptPrintLog "scp ${file} to($IP) path($path) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "scp ${file} to($IP) path($path) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function GetCfg()
{
    if [ $# -ne 2 ]; then
        ScriptPrintLog "input parametor number($#) is not 2. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local processType=$1
    local desPath=$2
    local dswareManageIp=`cat /opt/fusionstorage/agent/conf/dsware_manager_ip |awk -F"=" '{print $2}'`
    if [ -z "${dswareManageIp}" ]; then
        ScriptPrintLog "dsware manager ip is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local var=$(eval declare -p "${processType}_COMPONENT_CONFIGRATION")
    eval "declare -a local componentCfgArray"=${var#*=}
    if [ ${#componentCfgArray[*]} -eq 0 ]; then
        ScriptPrintLog "find component(${processType}) process configration failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    for compCfgFile in ${componentCfgArray[@]}
    do
        if [ ! -f "${compCfgFile}" ]; then
            ScriptPrintLog "${compCfgFile} is not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        SingleScp2Remote "${FUNCNAME}_${processType}" "${compCfgFile}" "${dswareManageIp}" "${desPath}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "scp ${compCfgFile} to ${dswareManageIp} failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
    done
    ScriptPrintLog "scp process(${processType}) ${compCfgFile} to ${dswareManageIp} successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function GenerateComponetCfg()
{
    if [ $# -ne 3 ]; then
        ScriptPrintLog "input parametor number($#) is not 3. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local processType=$2
    local configrationFile=$3

    local var=$(eval declare -p "${processType}_COMPONENT_CONFIGRATION")
    eval "declare -a local componentCfgArray"=${var#*=}
    if [ ${#componentCfgArray[*]} -eq 0 ]; then
        ScriptPrintLog "no need refresh old component(${processType}) configration. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    local isExixt=0
    for compCfgFile in ${componentCfgArray[@]}
    do
        local compCfgName="${compCfgFile##*/}"
        if [ -z "${compCfgName}" ]; then
            ScriptPrintLog "${processType} cfg file name is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        local remoteCfgFile="${CUR_PATH}/${compCfgName}"

        if [ -f ${remoteCfgFile} ]; then
            if [ -f ${OPERATE_FILE_SHELL_NAME} ];then
                local currentTime=$(date "+%Y%m%d%H%M%S")
                local tmpCfgFile="/opt/fusionstorage/agent/conf/tmp_file_bak_${currentTime}_${compCfgName}"
                mv -f "${remoteCfgFile}" "${tmpCfgFile}"
                if [ $? -ne 0 ]; then
                    ScriptPrintLog "mv -f ${remoteCfgFile} ${tmpCfgFile} failed. [${LINENO}]" "${FUNCNAME[0]}" "${SCRIPTNAME}"
                    return 1
                fi
                ScriptPrintLog "mv -f ${remoteCfgFile} ${tmpCfgFile} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}

                local mvCfgFileResult=$(bash ${OPERATE_FILE_SHELL_NAME} mv_file "${tmpCfgFile}" "${compCfgFile}")
                echo "${mvCfgFileResult}" | grep -w "result=0"
                if [ $? -ne 0 ]; then
                    ScriptPrintLog "bash ${OPERATE_FILE_SHELL_NAME} mv_file ${tmpCfgFile} ${compCfgFile} failed. [${LINENO}]" "${FUNCNAME[0]}" "${SCRIPTNAME}"
                    return 1
                fi
                ScriptPrintLog "bash ${OPERATE_FILE_SHELL_NAME} mv_file ${tmpCfgFile} ${compCfgFile} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            else 
                \mv -rf "${remoteCfgFile}" "${compCfgFile}"
                if [ $? -ne 0 ]; then
                    ScriptPrintLog "mv -rf ${remoteCfgFile} ${compCfgFile} failed. [${LINENO}]" "${FUNCNAME[0]}" "${SCRIPTNAME}"
                    return 1
                fi
                chown eds:storage ${compCfgFile}
                chmod 600 ${compCfgFile}
                ScriptPrintLog "mv -rf ${remoteCfgFile} ${compCfgFile} successfully. [${LINENO}]" "${FUNCNAME[0]}" "${SCRIPTNAME}"
            fi
            isExixt=1
        else
            ScriptPrintLog "file(${remoteCfgFile}) not exist in local. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        fi
    done
    if [ "${isExixt}" -ne "1" ]; then
        ScriptPrintLog "can not find file(${componentCfgArray[@]}) in local. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    RefreshCfg ${processType} ${configrationFile}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Refresh conponent(${processType}) cfg(${configrationFile}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    RefreshCcdbVolume ${processType}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Refresh conponent(${processType}) ccdb volume item failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    if [ -n "${configrationFile}" -a -f "${CUR_PATH}/${configrationFile}" ]; then
        rm -f "${CUR_PATH}/${configrationFile}"
        ScriptPrintLog "rm -f ${CUR_PATH}/${configrationFile} result($?). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    fi
    ScriptPrintLog "Generate conponent(${processType}) cfg successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

###########################################################
function shellFileIsUsefullLine()
{
    # check the input line is a valid config item line
    #<!> something is assumed!
    local line=$@
    echo "${line}"|egrep -v ^"[ #[]"|grep = -q
}

function cfgfileGetItemName()
{
    local line=$@
    local name=`echo ${line} | awk -F= '{print $1}'|sed 's/[ \t]*$//'`
    stringStrip ${name}
}

function stringStrip()
{
    local input=$@
    echo ${input}|tr -s ["\n"]
}

function RefreshComponentCfg()
{ 
    # configuration file upgrading
    # assumed:
    # 1, all config item start at the begin of line

    local cfgOld=$1
    local cfgNew=$2
    
    export IFS=$'\n'
    local linenumber=0
    local continue_flag=1
    while read line || [[ -n ${line} ]]; do
        let linenumber++
        if ! shellFileIsUsefullLine ${line}; then
            continue
        fi
        
        ScriptPrintLog "in ${cfgOld} linenumber:${linenumber} line:${line}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        local cfgName=`cfgfileGetItemName ${line}`
        if [ -z "${cfgName}" ]; then
            continue
        fi
        
        #if cfgName is in key_blacklist,continue=0, skip, 
        continue_flag=1
        ScriptPrintLog "key_blacklist : ${key_blacklist}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        if [ ! -z ${keyBlacklist} ]; then
            for attr in ${keyBlacklist}
            do
                [[ -z $attr ]] && echo "attr is null." && continue
                [[ "$attr" == "${cfgName}" ]] && echo "${cfgName} is in key_blacklist, needn't to sync" && continue_flag=0 && break
            done
            
            [[ $continue_flag -eq 0 ]] && continue
        fi
        
        local cfgValue=`stringStrip $(echo ${line}|cut -d "=" -f2-) | awk -F "#" '{print $1}'`
       
        local isItem=${cfgName}
        local isItemValue=`stringStrip $(grep "^ *${cfgName} *=" ${cfgNew}|cut -d "=" -f2-) | awk -F "#" '{print $1}'`
        ScriptPrintLog "status:$?, item:$isItem, value:${isItemValue}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        ScriptPrintLog "$isItem. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        ScriptPrintLog "${isItemValue}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        
        grep -E "^ *${cfgName} *=" ${cfgNew} > /dev/null 2>&1
        if [ $? -ne 0 ]; then
            ScriptPrintLog "file ${cfgNew} does not contain item ${cfgName}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            #echo ${line} >> ${cfgNew}
            #ScriptPrintLog "insert config item [${cfgName}]=[${cfgValue}] into [${cfgNew}]" ${FUNCNAME} ${SCRIPTNAME}
        else
            ScriptPrintLog "file ${cfgNew} contains item ${cfgName}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            local cfgNewValue=${isItemValue}

            if [ "${cfgValue}" == "" ] && [ "${cfgNewValue}" == "" ]; then
                continue
            fi 
            
            if [ "${cfgValue}" == "${cfgNewValue}" ]; then
                continue
            fi

            sed -i "{s#^[ ]*${cfgName}[ ]*=[ ]*.*#${cfgName}=${cfgValue}#g;}" ${cfgNew}
            ScriptPrintLog "change config item [${cfgName}] from [${cfgNewValue}] to [${cfgValue}] in file ${cfgNew}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}  
        fi
    done<${cfgOld}
}


function RefreshCfg()
{
    local processType=$1
    local soureFile=$2

    if [ ! -f "${CUR_PATH}/${soureFile}" ]; then
        ScriptPrintLog "${CUR_PATH}/${soureFile} is not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local var=$(eval declare -p "${processType}_COMPONENT_CONFIGRATION")
    eval "declare -a local componentCfgArray"=${var#*=}
    if [ ${#componentCfgArray[*]} -eq 0 ]; then
        ScriptPrintLog "no need refresh old component(${processType}) configration. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    for compCfgFile in ${componentCfgArray[@]}
    do
        if [ ! -f "${compCfgFile}" ]; then
            ScriptPrintLog "${compCfgFile} is not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi

        RefreshComponentCfg "${CUR_PATH}/${soureFile}" "${compCfgFile}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "refresh component(${processType}) configration from (${CUR_PATH}/${soureFile}) to (${compCfgFile}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi

        #if [ "${processType}" == "cm" ]; then
        #    bash  /opt/dsware/infrastructure/cm/script/cm_handle.sh set_up
            #RefreshComponentCfg "${CUR_PATH}/${soureFile}" "/opt/dsware/infrastructure/cm/config/cm_cfg.cfg"
        #    if [ $? -ne 0 ]; then
        #        ScriptPrintLog "refresh component(${processType}) configration from (${CUR_PATH}/${soureFile}) to (/opt/dsware/infrastructure/cm/config/cm_cfg.cfg) failed." ${FUNCNAME} ${SCRIPTNAME}
        #        return 1
        #    fi
        #    ScriptPrintLog "refresh component(${processType}) configration from (${CUR_PATH}/${soureFile}) to (/opt/dsware/infrastructure/cm/config/cm_cfg.cfg) successfully." ${FUNCNAME} ${SCRIPTNAME}
        #fi
    done
    if [ -n "${soureFile}" -a -f "${CUR_PATH}/${soureFile}" ]; then
        rm -f ${CUR_PATH}/${soureFile}
        ScriptPrintLog "rm -f ${CUR_PATH}/${soureFile} result($?) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    fi
    ScriptPrintLog "refresh component(${processType}) configration from (${CUR_PATH}/${soureFile}) to (${compCfgFile}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}
######################################################
function StartVbs()
{
    bash /opt/fusionstorage/agent/script/dsware_vbs.sh "start_snm" "" "" ""
    if [ $? -ne 0 ]; then
        ScriptPrintLog "start_snm failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    return 0
}

function StopVbs()
{
    bash /opt/fusionstorage/agent/script/dsware_vbs.sh "stop_snm"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "stop_snm failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    return 0
}

function CheckVbsExist()
{
    local dswareManageIp=`cat /opt/fusionstorage/agent/conf/dsware_manager_ip |awk -F"=" '{print $2}'`
    if [ -z "${dswareManageIp}" ]; then
        ScriptPrintLog "dsware manager ip is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    for ((wait_time=0; wait_time<5; wait_time++))
    do
        bash /opt/fusionstorage/agent/script/dsware_vbs.sh "check_snm" "${dswareManageIp}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "check vbs exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 0
        fi
        sleep 1
    done
    ScriptPrintLog "check vbs not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function RestartVbs()
{
    CheckVbsExist
    if [ $? -ne 0 ]; then
        ScriptPrintLog "vbs is not exist, no need to restart. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    bash /opt/fusionstorage/repository/deploymanager_pkg/micro/vbs_*/action/vbs/change_master_vbs.sh
    if [ $? -ne 0 ]; then
        ScriptPrintLog "bash /opt/fusionstorage/repository/deploymanager_pkg/micro/vbs_*/action/vbs/change_master_vbs.sh failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local dswareManageIp
    dswareManageIp=`cat /opt/fusionstorage/agent/conf/dsware_manager_ip |awk -F"=" '{print $2}'`
    if [ -z "${dswareManageIp}" ]; then
        ScriptPrintLog "dsware manager ip is null. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    
    bash /opt/fusionstorage/agent/script/dsware_vbs.sh "restart_all" "${dswareManageIp}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "bash /opt/fusionstorage/agent/script/dsware_vbs.sh restart_all ${dswareManageIp}, restart vbs failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "bash /opt/fusionstorage/agent/script/dsware_vbs.sh restart_all ${dswareManageIp} successullfy, Wait vbs process ok sleep 10s. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    sleep 10
    return 0
}
#############################################################
function GetComponentScript()
{
    local processType=$1

    for key in ${!COMPONENT_SCRIPT[*]}
    do
        if [ "${key}" != "${processType}" ]; then
            continue
        fi
        echo "${COMPONENT_SCRIPT[$key]}"
        return 0
    done
    echo ""
    return 0
}

function GetAddComponentScript()
{
    local processType=$1

    for key in ${!ADD_COMPONENT_SCRIPT[*]}
    do
        if [ "${key}" != "${processType}" ]; then
            continue
        fi
        echo "${ADD_COMPONENT_SCRIPT[$key]}"
        return 0
    done
    echo ""
    return 0
}

function GetDeleteComponentScript()
{
    local processType=$1

    for key in ${!DELETE_COMPONENT_SCRIPT[*]}
    do
        if [ "${key}" != "${processType}" ]; then
            continue
        fi
        echo "${DELETE_COMPONENT_SCRIPT[$key]}"
        return 0
    done
    echo ""
    return 0
}

function ExcuteComponentScript()
{
    local scriptFile=$1
    local action=$2
    local matchStr=$3

    local scriptResult
    scriptResult=$(bash ${scriptFile} "${action}")
    echo "${scriptResult}" | grep -Ew "${matchStr}" 
    if [ $? -ne 0 ]; then
        ScriptPrintLog "excute cmd(${scriptFile} ${action}) for process(${processType}) result is ${scriptResult}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "excute cmd(${scriptFile} ${action}) for process(${processType}) result is ${scriptResult}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function CheckStartStatus()
{
    local scriptFile=$1
    local i=1
    local retryTimes=$2
    local subOperate=$3
    local checkOperate="check_status"
    if [ -n "${subOperate}" ]; then
      checkOperate="${subOperate}_${checkOperate}"
    fi
    while [ ${i} -le ${retryTimes} ]
    do
        ExcuteComponentScript ${scriptFile} "${checkOperate}" "running|runing"
        if [ $? -eq 0 ]
        then
            ScriptPrintLog "use script(${scriptFile} ${checkOperate}) check process start status is running. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 0   
        fi
        let i=i+1
        sleep 2
    done
    ScriptPrintLog "use script(${scriptFile} ${checkOperate}) check process start status is not running. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function CheckStopStatus()
{
    local scriptFile=$1
    local subOperate=$2
    local checkOperate="check_status"
    if [ -n "${subOperate}" ]; then
      checkOperate="${subOperate}_${checkOperate}"
    fi
    local i=1
    local retryTimes=100
    while [ ${i} -le ${retryTimes} ]
    do
        ExcuteComponentScript ${scriptFile} "${checkOperate}" "no_running|no_runing"
        if [ $? -eq 0 ]
        then
            ScriptPrintLog "use script(${scriptFile} ${checkOperate}) check process stop status is not running. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 0   
        fi
        let i=i+1
        sleep 2
    done
    ScriptPrintLog "use script(${scriptFile} ${checkOperate}) check process stop status is running. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function StartComponent()
{
    local processType=$2
    local subOperate=""
    if [ $# -eq 3 ]; then
        ScriptPrintLog "input parametor number($#) is 3($*). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        subOperate=$3
    fi
    local scriptFile
    scriptFile=$(GetComponentScript ${processType})
    if [ -z "${scriptFile}" ]; then
        ScriptPrintLog "process(${processType}) script file is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local startOperate="start"
    if [ -n "${subOperate}" ]; then
      startOperate="${subOperate}_${startOperate}"
    fi
    ExcuteComponentScript ${scriptFile} "${startOperate}" "success"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use ${scriptFile} ${startOperate} to start process failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    CheckStartStatus "${scriptFile}" "100" "${subOperate}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use ${scriptFile} ${subOperate} to check process start status failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    #CheckStatus ${processType}
    #if [ $? -ne 0 ]; then
    #    ScriptPrintLog "process(${processType}) use diagnose_usr to check process status failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    #    return 1
    #fi

    ScriptPrintLog "process(${processType}) use ${scriptFile} to start process successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function StopComponent()
{
    if [ $# -ne 2 ] && [ $# -ne 3 ]; then
        ScriptPrintLog "input parameter number($#) is not 2 or not 3. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local processType=$2
    local subOperate=""
    if [ $# -eq 3 ]; then
        ScriptPrintLog "input parameter number($#) is 3($*). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        subOperate=$3
    fi
    local scriptFile
    scriptFile=$(GetComponentScript ${processType})
    if [ -z "${scriptFile}" ]; then
        ScriptPrintLog "process(${processType}) script file is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    if [ -n "${subOperate}" ]; then
          ExcuteComponentScript ${scriptFile} "${subOperate}_stop" "success"
    else
          ExcuteComponentScript ${scriptFile} "stop" "success"
    fi

    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use ${scriptFile} to stop process failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    CheckStopStatus "${scriptFile}" "${subOperate}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use ${scriptFile} to check process stop status failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    ScriptPrintLog "process(${processType}) use ${scriptFile} to stop process successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function GetProcessName()
{
    local processType=$1
    for key in ${!COMPONENT_PROCESS_NAME_MAP[*]}
    do
        if [ "${key}" != "${processType}" ]; then
            continue
        fi
        echo "${COMPONENT_PROCESS_NAME_MAP[$key]}"
        return 0
    done
    echo ""
    return 0
}

function GetProcessPid()
{
    local processName=$1
    local processPid=""
    for ((wait_time=0; wait_time<10; wait_time++))
    do
        processPid=$(pidof -s ${processName})
        if [ -z "${processPid}" ]; then
            sleep 1
            continue
        fi
        echo "${processPid}"
        return 0
    done
    echo "${processPid}"
    return 0
}

function KillProcessPid()
{
    local processName=$1
    local oldProcessPid=$2
    for ((wait_time=0; wait_time<10; wait_time++))
    do
        kill -9 "${oldProcessPid}"
        if [ $? -eq 0 ]; then
            ScriptPrintLog "kill -9 ${oldProcessPid} excute successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 0
        fi
        local processPid=$(pidof -s ${processName})
        if [ -z "${processPid}" -o "${processPid}" != "${oldProcessPid}" ]; then
            ScriptPrintLog "process(${processName}) new process pid(${processPid}) old process pid(${oldProcessPid}), so kill successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 0
        fi
        ScriptPrintLog "kill -9 ${oldProcessPid} excute failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        sleep 1
    done
    ScriptPrintLog "kill process(name ${processName} pid ${processPid}) excute failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function RestartComponent()
{
    local action=$1
    local processType=$2
    local serverProcessType=$3
    local scriptFile
    scriptFile=$(GetComponentScript ${processType})
    if [ -z "${scriptFile}" ]; then
        ScriptPrintLog "can not get component(${processType}) script file. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    local processName
    processName=$(GetProcessName ${processType})
    if [ -z "${processName}" ]; then
        ScriptPrintLog "can not get component(${processType}) process name. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    # get process pid
    local processPid
    processPid=$(GetProcessPid "${processName}")
    if [ -z "${processPid}" ]; then
        ScriptPrintLog "proccess(${processName}) pid is not exist, no need to restart. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    # kill process
    KillProcessPid ${processName} ${processPid}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "proccess(name ${processName} pid ${processPid}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    if [ "${processType}" == "dlm_vm" ]; then
        ScriptPrintLog "${processType} no need to restart. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi 

    CheckStartStatus ${scriptFile} "100"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use ${scriptFile} to check process start status failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    #CheckStatus ${processType}
    #if [ $? -ne 0 ]; then
    #    ScriptPrintLog "process(${processType}) use diagnose_usr to check process status failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    #    return 1
    #fi

    if [ "${processType}" == "EBSCtrl" ]; then
        ScriptPrintLog "process(${processType}) restart process successfully, Wait process ok sleep 15s. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        sleep 15
    fi

    ScriptPrintLog "process(${processType}) use ${scriptFile} to restart process successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function AddSingleProcess()
{
    local processType=$1
    local subOperate=$2
    local operateSuffix=""
    if [ -n "${subOperate}" ]; then
      operateSuffix="${subOperate}_"
    fi
    # start to set lvm flow control
    if [ "${processType}" == "ccdb_server" ]; then
        local setFlowControlResult
        setFlowControlResult=$(bash /opt/fusionstorage/agent/script/dsware_agent_handle.sh "lvm_flow_control" "set_eds_ccdb_flow_control")
        echo "${setFlowControlResult}" | grep -w "result=0"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "cmd(bash /opt/fusionstorage/agent/script/dsware_agent_handle.sh lvm_flow_control set_eds_ccdb_flow_control) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
    fi

    local scriptFile
    scriptFile=$(GetAddComponentScript ${processType})
    if [ -z "${scriptFile}" ]; then
        ScriptPrintLog "can not get component(${processType}) script file. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    ExcuteComponentScript ${scriptFile} "${operateSuffix}stop" "success"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use script(${scriptFile}) to ${operateSuffix}stop process failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    ExcuteComponentScript ${scriptFile} "${operateSuffix}start" "success"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use script(${scriptFile}) to ${operateSuffix}start process failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    CheckStartStatus "${scriptFile}" "100" "${subOperate}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use ${scriptFile} to check process start ${operateSuffix}status failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    #CheckStatus ${processType}
    #if [ $? -ne 0 ]; then
    #    ScriptPrintLog "process(${processType}) use diagnose_usr to check process status failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    #    return 1
    #fi

    ScriptPrintLog "process(${processType}) use ${scriptFile} to add process successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function ExpandLs()
{
    if [ $# -ne 3 ]; then
        ScriptPrintLog "input parametor number($#) is not 3. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local processType=$2
    local position=$3
    local processLocalIpItemName="${LOCAL_IP}"

    if [ "${processType}" == "dlm_mm" ]; then
        processLocalIpItemName="${DLM_MM_LOCAL_IP}"
    fi

    local var
    var=$(eval declare -p "${processType}_COMPONENT_CONFIGRATION")
    eval "declare -a local componentCfgArray"=${var#*=}
    if [ ${#componentCfgArray[*]} -eq 0 ]; then
        ScriptPrintLog "no need refresh old component(${processType}) configration. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    for compCfgFile in ${componentCfgArray[@]}
    do
        if [ ! -f "${compCfgFile}" ]; then
            ScriptPrintLog "${compCfgFile} is not exist. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        local cmUrl=`grep -w "^${CM_URL}" ${compCfgFile} | awk -F "=" '{print $2}' 2>/dev/null`
        if [ -z "${cmUrl}" ]; then
            ScriptPrintLog "cm url is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        local localIp=`grep -w "^${processLocalIpItemName}" ${compCfgFile} | awk -F "=" '{print $2}' 2>/dev/null`
        if [ -z "${localIp}" ]; then
            ScriptPrintLog "local ip is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        local processLsId=`echo "${localIp}" | awk -F ":" '{print $1}' 2>/dev/null`
        if [ -z "${processLsId}" ]; then
            ScriptPrintLog "process ls id is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        local localDataIp=`grep -w "^${LOCAL_DATA_IP}" ${compCfgFile} | awk -F "=" '{print $2}' 2>/dev/null`
        if [ -z "${localDataIp}" ]; then
            ScriptPrintLog "local data ip is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        local localIpPortStr=${localIp#*:}
        local localIpStr=${localIpPortStr%:*}
        local localDataIpPortStr=${localDataIp#*:}
        local expandNodeInfo="lsk_addr=${localIpPortStr},lsk_data_addr=${localDataIpPortStr},lsk_position=${position}"
        export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:/opt/dsware/infrastructure/cm/lib_link
        local cmToolExpandResult
        cmToolExpandResult=$(/opt/dsware/infrastructure/cm/bin/cm_tool -s ${cmUrl} -d ${processType} -o expand -l ${processLsId} -I ${expandNodeInfo} -p "${localIpStr}")
        echo "${cmToolExpandResult}" |grep -w "Result=suc"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "/opt/dsware/infrastructure/cm/bin/cm_tool -s ${cmUrl} -d ${processType} -o expand -l ${processLsId} -I ${expandNodeInfo} -p ${localIpStr} (resutlt=${cmToolExpandResult}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "/opt/dsware/infrastructure/cm/bin/cm_tool -s ${cmUrl} -d ${processType} -o expand -l ${processLsId} -I ${expandNodeInfo} -p ${localIpStr} (resutlt=${cmToolExpandResult}) successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    done
    ScriptPrintLog "expan ls failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function AddAcl()
{
    local addedIp=$1
    local clusterId=$2
    local clusterType=$3

    local zkIpList
    zkIpList=`grep -w "^${ZK_IP_LIST}" ${CM_CFG_FILE} | awk -F "=" '{print $2}' 2>/dev/null`
    if [ -z "${zkIpList}" ]; then
        ScriptPrintLog "zk Ip List is null in ${zkIpList}. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local zkIdIpPortList=($(echo $zkIpList|awk -F ',' 'NR==1{for(i=1;i<=NF;i++){print $i}}'))
    if [ ${#zkIdIpPortList[*]} -eq 0 ]; then
        ScriptPrintLog "zk id ip port List is null in ${zkIpList}. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local zkIpListStr=""
    for idIpPort in ${zkIdIpPortList[@]}
    do
        local ipPort=${idIpPort#*:}
        if [ -n "${zkIpListStr}" ]; then
            zkIpListStr="${zkIpListStr},${ipPort}"
            continue
        fi
        zkIpListStr="${ipPort}"
    done
    export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:/opt/dsware/infrastructure/cm/lib_link
    local addResult
    addResult=$(/opt/dsware/infrastructure/cm/bin/cm_tool -o add_acl -z ${zkIpListStr} -a ${addedIp} -i ${clusterId} -t ${clusterType})
    echo ${addResult}|grep -w "Result=suc"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "/opt/dsware/infrastructure/cm/bin/cm_tool -o add_acl -z ${zkIpListStr} -a ${addedIp} -i ${clusterId} -t ${clusterType} failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "/opt/dsware/infrastructure/cm/bin/cm_tool -o add_acl -z ${zkIpListStr} -a ${addedIp} -i ${clusterId} -t ${clusterType} sucessfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function GenerateEdsCcdbSlotInfoFile()
{
    local edsCcdeSlot=$1
    local edsCcdbEsn=$2
    if [ ! -f "${EDS_SLOT_INFO}" ]; then
        touch "${EDS_SLOT_INFO}"
    fi
    ModifyConf "eds_ccdb_slot" "${edsCcdeSlot}" "${EDS_SLOT_INFO}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "modify eds_ccdb_slot(${edsCcdeSlot}) to file(${EDS_SLOT_INFO}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    ModifyConf "eds_ccdb_esn" "${edsCcdbEsn}" "${EDS_SLOT_INFO}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "modify eds_ccdb_esn(${edsCcdbEsn}) to file(${EDS_SLOT_INFO}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    chown root:root ${EDS_SLOT_INFO}
    chmod 600 ${EDS_SLOT_INFO}
    return 0
}

function RefreshCcdbVolume()
{
    local processType=$1

    if [ "${processType}" != "ccdb_server" ]; then
        ScriptPrintLog "process type(${processType}) no need to refresh ccdb volume. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    local zkSlot=`grep -w "^${ZK_SLOT}" ${ZK_SLOT_INFO} | awk -F "=" '{print $2}' 2>/dev/null`
    if [ -z "${zkSlot}" ]; then
        ScriptPrintLog "zk slot is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local zkEsn=`grep -w "^${ZK_ESN}" ${ZK_SLOT_INFO} | awk -F "=" '{print $2}' 2>/dev/null`
    if [ -z "${zkEsn}" ]; then
        ScriptPrintLog "zk esn is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    if [ x"${zkSlot}" == x"129" ]; then
        zkEsn="unknown"
    fi
    GenerateEdsCcdbSlotInfoFile ${zkSlot} ${zkEsn}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "generate eds ccdb slot info file by disk info(${zkSlot} ${zkEsn}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    # 设置目录部署场景下ccdb_volume和mediaDiskInfo的默认值
    local devSymlink="sys_disk_mode"
    local mediaDiskInfo="dir"
    # 设置系统盘分区场景下ccdb_volume和mediaDiskInfo的值
    if [ x"${zkSlot}" == x"130" ];then
        devSymlink="null"
        mediaDiskInfo="sys_disk"
    fi
    # 设置独立盘的ccdb_volume，及非m2盘的独立盘场景下的mediaDiskInfo
    if [ x"${zkSlot}" != x"129" ] && [ x"${zkSlot}" != x"130" ]; then
        local deviceName=$(cat /proc/smio_host | grep -w ${zkEsn} |awk -F'|' '{print$3}' | awk '{gsub(/^\s+|\s+$/, "");print}')
        local ccdbVolumeValue="/dev/${deviceName}"
        local devSymlinkResult=$(bash /opt/fusionstorage/agent/script/dsa_create_eds_ccdbdisk_symlink.sh create ${ccdbVolumeValue})
        local devSymlink=`echo ${devSymlinkResult} | awk -F "=|;" '{print $4}'`
        mediaDiskInfo="single_disk"
    fi
    # 设置m2盘场景下的mediaDiskInfo
    if [ x"${zkSlot}" == x"500" ] || [ x"${zkSlot}" == x"501"] || [ x"${zkSlot}" == x"502"]; then
        mediaDiskInfo="m2_disk"
    fi
    local var=$(eval declare -p "${processType}_COMPONENT_CONFIGRATION")
    eval "declare -a local componentCfgArray"=${var#*=}
    if [ ${#componentCfgArray[*]} -eq 0 ]; then
        ScriptPrintLog "no need refresh old component(${processType}) configration. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    for compCfgFile in ${componentCfgArray[@]}
    do
        if [ ! -f "${compCfgFile}" ]; then
            ScriptPrintLog "${compCfgFile} is not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        ModifyConf "ccdb_volume" "${devSymlink}" "${compCfgFile}"
        ModifyConf "mediaDiskInfo" "${mediaDiskInfo}" "${compCfgFile}"
        if [ $? -eq 0 ]; then
            ScriptPrintLog "modify config(${compCfgFile}) itme(ccdb_volume) value(${devSymlink}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 0
        fi
    done
    ScriptPrintLog "modify config itme(ccdb_volume) value(${devSymlink}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function RefreshMediaDiskInfo()
{
    local processType=$1
    if [ "${processType}" != "zk" ]; then
        ScriptPrintLog "process type(${processType}) no need to refresh mediaDiskInfo. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    local zkSlot=`grep -w "^${ZK_SLOT}" ${ZK_SLOT_INFO} | awk -F "=" '{print $2}' 2>/dev/null`
    if [ -z "${zkSlot}" ]; then
        ScriptPrintLog "zk slot is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "Zk slot is(${zkSlot}. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    # zk盘类型有dir(129),sys_disk(130),m2_disk(500/501/502),single_disk(其它独立盘)
    # 设置默认值为独立盘部署
    local mediaDiskInfo="single_disk"
    if [ x"${zkSlot}" == x"129" ];then
        mediaDiskInfo="dir"
    elif [ x"${zkSlot}" == x"130" ]; then
        mediaDiskInfo="sys_disk"
    elif [ x"${zkSlot}" == x"500" ] || [ x"${zkSlot}" == x"501"] || [ x"${zkSlot}" == x"502"]; then
        mediaDiskInfo="m2_disk"
    fi

    local var=$(eval declare -p "${processType}_COMPONENT_CONFIGRATION")
    eval "declare -a local componentCfgArray"=${var#*=}
    if [ ${#componentCfgArray[*]} -eq 0 ]; then
        ScriptPrintLog "no need refresh old component(${processType}) configration. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    for compCfgFile in ${componentCfgArray[@]}
    do
        if [ ! -f "${compCfgFile}" ]; then
            ScriptPrintLog "${compCfgFile} is not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        ModifyConf "mediaDiskInfo" "${mediaDiskInfo}" "${compCfgFile}"
        if [ $? -eq 0 ]; then
            ScriptPrintLog "modify config(${compCfgFile}) itme(mediaDiskInfo) value(${mediaDiskInfo}) successfully. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 0
        fi
    done
    ScriptPrintLog "modify config itme(mediaDiskInfo) value(${mediaDiskInfo}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function RefreshCfgAndStart()
{
    if [ $# -ne 3 ]; then
        ScriptPrintLog "input parametor number($#) is not 3. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local processType=$2
    local configrationFile=$3
    RefreshCfg ${processType} ${configrationFile}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "refresh conponent(${processType}) cfg(${configrationFile}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    RefreshCcdbVolume ${processType}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "refresh conponent(${processType}) ccdb volume item failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    if [ "${processType}" = "osd" ]; then
        return 0
    fi
    if [ "${processType}" = "vbs" ]; then
        RestartVbs
    else
        RestartComponent ${processType}
    fi
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Start conponent(${processType}) process failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    return 0
}

function RefreshCfgAndReboot()
{
    local processType=$2
    if [ $# -ne 3 ]; then
        ScriptPrintLog "input parametor number($#) is not 3" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local configrationFile=$3
    RefreshCfg ${processType} ${configrationFile}
    if [ $? -ne 0 ]; then
        ScriptPrintLog "refresh conponent(${processType}) cfg(${configrationFile}) failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    fi
    if [ "${processType}" = "osd" ]; then
        return 0
    fi
    if [ "${processType}" = "vbs" ]; then
        RestartVbs
    else
        RestartComponent ${processType}
    fi
    return $?
}

function AddProcess()
{
    if [ $# -ne 2 ] && [ $# -ne 3 ]; then
        ScriptPrintLog "input parametor number($#) is not 2 or not 3. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local subOperate=""
    if [ $# -eq 3 ]; then
        ScriptPrintLog "input parametor number($#) is 3($*). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        subOperate=$3
    fi
    local processType=$2
    if [ "${processType}" = "osd" ]; then
        return 0
    fi
    if [ "${processType}" = "vbs" ]; then
        RestartVbs
    else
        AddSingleProcess "${processType}" "${subOperate}"
    fi
    return $?
}
##########################################################################################
function ClearProcessConfigFile()
{
    local processType=$1
    local var=$(eval declare -p "${processType}_COMPONENT_CONFIGRATION")
    eval "declare -a local componentCfgArray"=${var#*=}
    if [ ${#componentCfgArray[*]} -eq 0 ]; then
        ScriptPrintLog "no need rollback component(${processType}) configration. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    for compCfgFile in ${componentCfgArray[@]}
    do
        if [ ! -f "${compCfgFile}" ]; then
            ScriptPrintLog "${compCfgFile} is not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        if [ "${compCfgFile}" == "/opt/dsware/vbs/conf/dr_driver.cfg" ]; then
            ScriptPrintLog "${compCfgFile} is no need to process roll back. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        rm -f "${compCfgFile}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "rm -f ${compCfgFile} failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "rm -f ${compCfgFile} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    done

    ScriptPrintLog "rm component(${processType}) new node configration successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}
function DeleteSingleProcess()
{
    local processType=$1
    local subOperate=""
    if [ $# -eq 2 ]; then
        ScriptPrintLog "input parameter number($#) is 2($*). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        subOperate=$2
    fi
    local scriptFile
    scriptFile=$(GetDeleteComponentScript "${processType}")
    if [ -z "${scriptFile}" ]; then
        ScriptPrintLog "can not get component(${processType}) script file. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    # eds_service_exec_script_stop_process
    if [ -n "${subOperate}" ]; then
      ExcuteComponentScript "${scriptFile}" "${subOperate}_stop" "success"
    else
      ExcuteComponentScript "${scriptFile}" "stop" "success"
    fi
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use script(${scriptFile}) to stop process failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    CheckStopStatus "${scriptFile}" "${subOperate}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use ${scriptFile} to check process stop status failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    # eds_service_exec_script_clear_process
    ExcuteComponentScript "${scriptFile}" "clear" "success"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use script(${scriptFile}) to clear process failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    fi

    if [ "${processType}" == "ccdb_server" ]; then
        # clear_lvm_flow_control
        local clearFlowControlResult
        clearFlowControlResult=$(bash /opt/fusionstorage/agent/script/dsware_agent_handle.sh "lvm_flow_control" "clear_eds_ccdb_flow_control")
        echo "${clearFlowControlResult}" | grep -w "result=0"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "cmd(bash /opt/fusionstorage/agent/script/dsware_agent_handle.sh lvm_flow_control clear_eds_ccdb_flow_control) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        fi
    fi

    if [ "${processType}" == "ccdb_server" ]; then
        bash /opt/fusionstorage/agent/script/dsa_create_eds_ccdbdisk_symlink.sh remove
        if [ $? -ne 0 ]; then
            ScriptPrintLog "cmd(bash /opt/fusionstorage/agent/script/dsa_create_eds_ccdbdisk_symlink.sh remove) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        if [ -f "${EDS_SLOT_INFO}" ]; then
            rm -f "${EDS_SLOT_INFO}"
            if [ $? -ne 0 ]; then
                ScriptPrintLog "rm -f ${EDS_SLOT_INFO} failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
                return 1
            fi
        fi
    fi

    ScriptPrintLog "delete process(${processType}) successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function DeleteProcess()
{
    if [ $# -ne 2 ] && [ $# -ne 3 ]; then
        ScriptPrintLog "input parametor number($#) is not 2 or not 3. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local subOperate=""
    if [ $# -eq 3 ]; then
        ScriptPrintLog "input parametor number($#) is 3($*). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        subOperate=$3
    fi

    local processType=$2
    if [ "${processType}" = "osd" ]; then
        return 0
    fi
    if [ "${processType}" = "vbs" ]; then
        StopVbs
    else
        DeleteSingleProcess "${processType}" "${subOperate}"
    fi
    return $?
}

function ReduceLs()
{
    local processType=$2
    local processLocalIpItemName="${LOCAL_IP}"

    if [ "${processType}" == "dlm_mm" ]; then
        processLocalIpItemName="${DLM_MM_LOCAL_IP}"
    fi

    local var
    var=$(eval declare -p "${processType}_COMPONENT_CONFIGRATION")
    eval "declare -a local componentCfgArray"=${var#*=}
    if [ ${#componentCfgArray[*]} -eq 0 ]; then
        ScriptPrintLog "no need refresh old component(${processType}) configration. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    for compCfgFile in ${componentCfgArray[@]}
    do
        if [ ! -f "${compCfgFile}" ]; then
            ScriptPrintLog "${compCfgFile} is not exist. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 0
        fi
        local cmUrl
        cmUrl=`grep -w "^${CM_URL}" ${compCfgFile} | awk -F "=" '{print $2}' 2>/dev/null`
        if [ -z "${cmUrl}" ]; then
            ScriptPrintLog "cm url is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        local localIp
        localIp=`grep -w "^${processLocalIpItemName}" ${compCfgFile} | awk -F "=" '{print $2}' 2>/dev/null`
        if [ -z "${localIp}" ]; then
            ScriptPrintLog "local ip is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        local processLsId
        processLsId=`echo "${localIp}" | awk -F ":" '{print $1}' 2>/dev/null`
        if [ -z "${processLsId}" ]; then
            ScriptPrintLog "process ls id is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            continue
        fi
        local localIpPortStr=${localIp#*:}
        local localIpStr=${localIpPortStr%:*}
        export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:/opt/dsware/infrastructure/cm/lib_link
        local cmToolReduceResult
        cmToolReduceResult=$(/opt/dsware/infrastructure/cm/bin/cm_tool -s ${cmUrl} -d ${processType} -o shrink -l ${processLsId} -p "${localIpStr}")
        echo "${cmToolReduceResult}" |grep -w "Result=suc"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "/opt/dsware/infrastructure/cm/bin/cm_tool -s ${cmUrl} -d ${processType} -o shrink -l ${processLsId} -p ${localIpStr} (resutlt=${cmToolReduceResult}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "/opt/dsware/infrastructure/cm/bin/cm_tool -s ${cmUrl} -d ${processType} -o shrink -l ${processLsId} -p ${localIpStr} (resutlt=${cmToolReduceResult}) successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    done
    ScriptPrintLog "no need to reduce ls. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function RemoveAcl()
{
    local addedIp=$1
    local clusterId=$2
    local clusterType=$3

    local zkIpList
    zkIpList=`grep -w "^${ZK_IP_LIST}" ${CM_CFG_FILE} | awk -F "=" '{print $2}' 2>/dev/null`
    if [ -z "${zkIpList}" ]; then
        ScriptPrintLog "zk Ip List is null in ${zkIpList}. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local zkIdIpPortList=($(echo $zkIpList|awk -F ',' 'NR==1{for(i=1;i<=NF;i++){print $i}}'))
    if [ ${#zkIdIpPortList[*]} -eq 0 ]; then
        ScriptPrintLog "zk id ip port List is null in ${zkIpList}. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local zkIpListStr=""
    for idIpPort in ${zkIdIpPortList[@]}
    do
        local ipPort=${idIpPort#*:}
        if [ -n "${zkIpListStr}" ]; then
            zkIpListStr="${zkIpListStr},${ipPort}"
            continue
        fi
        zkIpListStr="${ipPort}"
    done
    export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:/opt/dsware/infrastructure/cm/lib_link
    local deletedResult
    deletedResult=$(/opt/dsware/infrastructure/cm/bin/cm_tool -o del_acl -z ${zkIpListStr} -a ${addedIp} -i ${clusterId} -t ${clusterType})
    echo "${deletedResult}" |grep -w "Result=suc"
    if [ $? -ne 0 ]; then
        echo "${deletedResult}" |grep -w "Reason=noexist"
        if [ $? -eq 0 ]; then
            ScriptPrintLog "/opt/dsware/infrastructure/cm/bin/cm_tool -o del_acl -z ${zkIpListStr} -a ${addedIp} -i ${clusterId} -t ${clusterType}, result(${deletedResult}), not exist. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 0
        fi
        ScriptPrintLog "/opt/dsware/infrastructure/cm/bin/cm_tool -o del_acl -z ${zkIpListStr} -a ${addedIp} -i ${clusterId} -t ${clusterType} failed, result(${deletedResult}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    ScriptPrintLog "/opt/dsware/infrastructure/cm/bin/cm_tool -o del_acl -z ${zkIpListStr} -a ${addedIp} -i ${clusterId} -t ${clusterType} sucessfully, result(${deletedResult}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

###############################################################################################################
function CheckDlmMmStatus()
{
    local dlmMmlsId
    dlmMmlsId=`cat /opt/dsware/infrastructure/dlm_mm/config/dlm_mm.cfg | grep mm_local_ip | awk -F "=|:" {'print $2'}`
    local i=1
    local retryTimes=100
    while [ ${i} -le ${retryTimes} ]
    do
        local checkDlmMmResult
        checkDlmMmResult=$(echo "dlm election show status"|diagnose_usr --set-cli --attach=${dlmMmlsId} --auto)
        echo ${checkDlmMmResult} | grep -wE "Local_Status" | grep -wE "BeSlave|BeMaster"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "check dlm_mm status is not normal, result(${checkDlmMmResult}), retry times(${i}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            let i=i+1
            sleep 2
            continue
        fi
        ScriptPrintLog "check dlm_mm status is normal, result(${checkDlmMmResult}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    done

    ScriptPrintLog "check dlm_mm status is not normal, retry times(${i}) timeout. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function CheckCcdbServerStatus()
{
    local ccdbServerLsId
    ccdbServerLsId=`cat /opt/dsware/infrastructure/ccdb/ccdb_server/config/ccdb_server.cfg | grep local_ip | awk -F "=|:" {'print $2'}`
    local i=1
    local retryTimes=100
    while [ ${i} -le ${retryTimes} ]
    do
        local checkCcdbServerResult
        checkCcdbServerResult=$(echo "ccdb_server srvcls"|diagnose_usr --set-cli --attach=${ccdbServerLsId} --auto)
        echo ${checkCcdbServerResult} | grep -wE "WorkStatus" |grep -w "normal"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "check ccdb_server status is not normal, result(${checkCcdbServerResult}), retry times(${i}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            let i=i+1
            sleep 2
            continue
        fi
        ScriptPrintLog "check ccdb_server status is normal, result(${checkCcdbServerResult}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    done

    ScriptPrintLog "check ccdb_server status is not normal, retry times(${i}) timeout. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function CheckStatus()
{
    local processType=$1
    for key in ${!CHECK_COMPONENT_STATUS_MAP[*]}
    do
        if [ "${key}" != "${processType}" ]; then
            continue
        fi
        ${CHECK_COMPONENT_STATUS_MAP[$key]} ${processType}
        if [ $? -ne 0 ]; then
            ScriptPrintLog "check ${processType} status failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "check ${processType} status successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    done
    ScriptPrintLog "can not find check ${processType} function. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function CheckStatusByScript()
{
    local processType=$1
    local scriptFile
    scriptFile=$(GetComponentScript ${processType})
    if [ -z "${scriptFile}" ]; then
        ScriptPrintLog "can not get component(${processType}) script file. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    CheckStartStatus ${scriptFile} "100" ""
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use ${scriptFile} to check process start status failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    ScriptPrintLog "process(${processType}) use ${scriptFile} to process start status successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function RestartCm()
{
    if [ "${processType}" = "cm" ]; then
      local scriptFile="/opt/dsware/infrastructure/cm/script/cm_handle.sh"
      local setUpResult
      setUpResult=$(bash ${scriptFile} set_up)
      echo "${setUpResult}" | grep -Ew "result=0;value=success;"
      if [ $? -ne 0 ]; then
        ScriptPrintLog "excute cmd(${scriptFile} set_up) for process(${processType}) result is ${setUpResult} failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
      fi

       ScriptPrintLog "excute cmd(${scriptFile} set_up) for process(${processType}) result is ${scriptResult} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    fi

    local clusterType
    clusterType=`cat /opt/dsware/infrastructure/cm/config/cm.cfg | grep -v grep | grep ^cluster_type | awk -F '=' '{print $2}'`
    if [ x$clusterType = "x" ];then
        clusterType=EDS
    fi
    local clusterId
    clusterId=`cat /opt/dsware/infrastructure/cm/config/cm.cfg | grep -v grep | grep ^cm_cluster_id | awk -F '=' '{print $2}'`
    local oldCmPid=
    for ((wait_time=0; wait_time<10; wait_time++))
    do
        oldCmPid=`ps -efww | grep -v grep | grep clustermanager | grep "\-t ${clusterType}" | grep "\-i ${clusterId}" | awk '{print $2}'`
        if [ x$oldCmPid = x ]; then
            ScriptPrintLog "clustermanager is not exist. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            break
        fi
        ScriptPrintLog "clustermanager(${oldCmPid}) is exist. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        kill -9 ${oldCmPid} >/dev/null 2>&1
        if [ $? -eq 0 ]; then
           ScriptPrintLog "clustermanager kill -9 ${oldCmPid} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            break
        fi
        local tmpPid
        tmpPid=`ps -efww | grep -v grep | grep clustermanager | grep "\-t ${clusterType}" | grep "\-i ${clusterId}" | awk '{print $2}'`
        if [ "${oldCmPid}" != "${tmpPid}" ]; then
            ScriptPrintLog "clustermanager kill -9 ${oldCmPid} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            break
        fi
        sleep 1
    done
    for ((wait_time=0; wait_time<10; wait_time++))
    do
        local newCmPid
        newCmPid=`ps -efww | grep -v grep | grep clustermanager | grep "\-t ${clusterType}" | grep "\-i ${clusterId}" | awk '{print $2}'`
        if [ x$newCmPid != x -a "${oldCmPid}" != "${newCmPid}" ]; then
            ScriptPrintLog "clustermanager restart from old(${oldCmPid}) to new(${newCmPid}) successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 0
        fi
        sleep 0.5
    done
    ScriptPrintLog "clustermanager restart from old(${oldCmPid}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function RestartCmsWorker()
{
    local clusterType
    clusterType=`cat /opt/dsware/infrastructure/snm/OSM/config/cmsworker.cfg | grep -v grep | grep ^cluster_type | awk -F '=' '{print $2}'`
    if [ x$clusterType = "x" ];then
        clusterType=EDS
    fi
    local oldCmWorkerPid=
    for ((wait_time=0; wait_time<10; wait_time++))
    do
        oldCmWorkerPid=`ps -efww | grep -v grep | grep cmsworker | grep "\-t ${clusterType}" | awk '{print $2}'`
        if [ x$oldCmWorkerPid = x ]; then
            ScriptPrintLog "cmsworker is not exist. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            break
        fi
        ScriptPrintLog "cmsworker(${oldCmWorkerPid}) is exist. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        kill -9 ${oldCmWorkerPid} >/dev/null 2>&1
        if [ $? -eq 0 ]; then
           ScriptPrintLog "cmsworker kill -9 ${oldCmWorkerPid} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            break
        fi
        local tmpPid
        tmpPid=`ps -efww | grep -v grep | grep cmsworker | grep "\-t ${clusterType}" | awk '{print $2}'`
        if [ "${oldCmWorkerPid}" != "${tmpPid}" ]; then
            ScriptPrintLog "cmsworker kill -9 ${oldCmWorkerPid} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            break
        fi
        sleep 1
    done
    for ((wait_time=0; wait_time<10; wait_time++))
    do
        local newCmPid
        newCmPid=`ps -efww | grep -v grep | grep cmsworker | grep "\-t ${clusterType}" | awk '{print $2}'`
        if [ x$newCmPid != x -a "${oldCmWorkerPid}" != "${newCmPid}" ]; then
            ScriptPrintLog "cmsworker restart from old(${oldCmWorkerPid}) to new(${newCmPid}) successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 0
        fi
        sleep 0.5
    done
    ScriptPrintLog "cmsworker restart from old(${oldCmWorkerPid}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function RestartZk()
{
    # 是否需要这个检查，检查方法是否正确，处理是否正确
    local zk_path="/opt/fusionstorage/persistence_layer/agent/zk/"
    ps -efww | grep zookeeper | grep -i "QuorumPeerMain" |grep ${zk_path} |grep -v grep >/dev/null 2>&1
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Zk is not exist, no need to restart. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    # 检查是否为系统盘分区部署，是则重启，否则不重启
    local zkSlot=`grep -w "^${ZK_SLOT}" ${ZK_SLOT_INFO} | awk -F "=" '{print $2}' 2>/dev/null`
    if [ -z "${zkSlot}" ]; then
        ScriptPrintLog "Zk slot is null. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    if [ x"${zkSlot}" != x"130" ]; then
        ScriptPrintLog "Zk slot is(${zkSlot}), not sys_disk deploy, no need restart zk. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    ScriptPrintLog "Begin restart zk, zkSlot is ${zkSlot}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    bash /opt/fusionstorage/persistence_layer/agent/zk/bin/zkServer.sh "restart"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "Restart zk failed. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    local zk_role=""
    local num=1
    while [[ ${num} -le 30 ]]
    do
        # 直接调用脚本查询状态
        zk_role=$(/opt/fusionstorage/persistence_layer/agent/zk/bin/zkServer.sh status | grep "Mode" | awk '{print $2}' | sed 's/ //g' 2>/dev/null)
        ScriptPrintLog "The result, num is ${num}, role is ${zk_role}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        [[ -n "$zk_role" ]] && break
        sleep 1
        num=`expr $num + 1`
    done

    if [[ "${zk_role}" == "follower" ]] || [[ "${zk_role}" == "leader" ]]; then
        ScriptPrintLog "End restart zk succeed, role is ${zk_role}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    ScriptPrintLog "End restart zk failed, role is ${zk_role}. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function RestartComponentByFunc()
{
    local action=$1
    local processType=$2
    local serverProcessType=$3
    if [ "${processType}" == "fdsaCore" -a ! -f "/opt/fusionstorage/fdsa/conf/fdsa_cluster_srv.conf" ]; then
        ScriptPrintLog "/opt/fusionstorage/fdsa/conf/fdsa_cluster_srv.conf is not exist. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi

    for key in ${!RESTART_COMPONENT_MAP[*]}
    do
        if [ "${key}" != "${processType}" ]; then
            continue
        fi
        ${RESTART_COMPONENT_MAP[${key}]} "${processType}" "${serverProcessType}"
        if [ $? -ne 0 ]; then
            ScriptPrintLog "restart ${processType} failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "restart ${processType} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    done

    ScriptPrintLog "can not find restart ${processType} function. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 2
}

function StopComponentByFunc()
{
    local processType=$1
    for key in ${!STOP_COMPONENT_MAP[*]}
    do
        if [ "${key}" != "${processType}" ]; then
            continue
        fi
        ${STOP_COMPONENT_MAP[${key}]} ${processType}
        if [ $? -ne 0 ]; then
            ScriptPrintLog "stop ${processType} failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ScriptPrintLog "stop ${processType} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    done

    ScriptPrintLog "can not find stop ${processType} function. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
}

function OperateComponet()
{
    if [ $# -ne 2 ]; then
        ScriptPrintLog "input parametor number($#) is not 2" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local action=$1
    local processType=$2

    local var
    var=$(eval declare -p "${processType}_OPERATE_COMPONENT_SCRIPT")
    eval "declare -A local operateComponentScriptMap"=${var#*=}
    for operate in ${!operateComponentScriptMap[@]}
    do
        if [ "${operate}" != "${action}" ]; then
            continue
        fi
        local scriptFile
        scriptFile=${operateComponentScriptMap[${operate}]}
        if [ -z "${scriptFile}" ]; then
            ScriptPrintLog "can not get component(${processType}) operate(${action}) script file." ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        bash ${scriptFile} "${action}"
        if [ $? -ne 0 ]
        then
          ScriptPrintLog "operate(${scriptFile} ${action}) component(${processType}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
          return 1
        fi

        ScriptPrintLog "operate((${scriptFile} ${action}) component(${processType}) successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    done
    ScriptPrintLog "can not find component(${processType}) operate(${action}) script file." ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function OperateComponetByFunction()
{
    if [ $# -ne 2 ]; then
        ScriptPrintLog "input parametor number($#) is not 2" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    local action=$1
    local processType=$2

    local var
    var=$(eval declare -p "${processType}_OPERATE_COMPONENT_FUNCTION")
    eval "declare -A local operateComponentFunctionMap"=${var#*=}
    for operate in ${!operateComponentFunctionMap[@]}
    do
        if [ "${operate}" != "${action}" ]; then
            continue
        fi
        local scriptFunciton
        scriptFunciton=${operateComponentFunctionMap[${operate}]}
        if [ -z "${scriptFunciton}" ]; then
            ScriptPrintLog "can not get component(${processType}) operate(${action}) script file." ${FUNCNAME} ${SCRIPTNAME}
            return 1
        fi
        ${scriptFunciton} "${processType}"
        if [ $? -ne 0 ]
        then
          ScriptPrintLog "operate(${scriptFunciton} ${action}) component(${processType}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
          return 1
        fi

        ScriptPrintLog "operate((${scriptFunciton} ${action}) component(${processType}) successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 0
    done
    ScriptPrintLog "can not find component(${processType}) operate(${action}) script file." ${FUNCNAME} ${SCRIPTNAME}
    return 1
}


function ReloadProcessCfg()
{
  local processType=$1
  local serverProcessType=$2

  if [ "${serverProcessType}" = "cm" -a "${processType}" = "EBSCtrl" ]
  then
    RestartComponent "restart" "${processType}" "${serverProcessType}"
    if [ $? -ne 0 ]
    then
      ScriptPrintLog "execute(RestartComponent restart ${processType} ${serverProcessType}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
      return 1
    fi
    ScriptPrintLog "execute(RestartComponent restart ${processType} ${serverProcessType}) successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
  fi
  OperateComponetByFunction "notify_process" "${processType}"
  if [ $? -ne 0 ]
  then
    ScriptPrintLog "Operate Component By Function ${processType} notify_process failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
  fi
  ScriptPrintLog "Operate Component By Function ${processType} notify_process successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
  return 0
}

function CheckOsdStatusByScript()
{
    local scriptFile="/opt/fusionstorage/persistence_layer/osd/script/dsware_osd.sh"
    local i=1
    local retryTimes=100
    while [ ${i} -le ${retryTimes} ]
    do
        local pid=$(${scriptFile} check_process)
        if [ -n "${pid}" ]
        then
            ScriptPrintLog "use script(${scriptFile} check_process) check process start status is running(${pid}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            return 0
        fi

        let i=i+1
        sleep 2
    done
    ScriptPrintLog "use script(${scriptFile}) check process start status is not running. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
}

function NotifyEBSCtrlProcessBySignal()
{
  # eds进程不需要通知
  ScriptPrintLog "Eds ctrl no need notify process. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
  return 0
#  local processType=$1
#  local dswareConfEdsService="/opt/dsware/eds/eds/bin/eds"
#  ps -efww |grep "eds" | grep "${dswareConfEdsService}" |grep -v grep|awk '{print $2}'|xargs -r kill -SIGUSR2
#  if [ $? -ne 0 ]
#  then
#    ScriptPrintLog "ps -efww |grep eds | grep ${dswareConfEdsService} |grep -v grep|awk '{print $2}'|xargs -r kill -SIGUSR2 failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
#    return 1
#  fi
#  ScriptPrintLog "ps -efww |grep eds | grep ${dswareConfEdsService} |grep -v grep|awk '{print $2}'|xargs -r kill -SIGUSR2 successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
#  return 0
}

function RefreshConfigFileKmsIpListItem()
{
  local processType=$1
  local compCfgFile=$2
  local kmsIpListValue
  kmsIpListValue=`grep -w "^g_kms_ip_list" "${compCfgFile}" | awk -F "=" '{print $2}' 2>/dev/null`
  if [ -z "${kmsIpListValue}" ]; then
      ScriptPrintLog "g_kms_ip_list value is null in ${compCfgFile}, no need to refresh. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
      return 0
  fi
  local convertResult
  convertResult=$(bash ${MULTI_POOL_OPER_SCRIPT} "convert_process_index" "${processType}")
  local processIndex
  processIndex=$(echo "${convertResult}"| awk -F ";value=" '{print $2}')
  if [ -z "${processIndex}" -o  "${processIndex}" = "-1" ]
  then
    ScriptPrintLog "execute(bash ${MULTI_POOL_OPER_SCRIPT} convert_process_index ${processType}) convert process to index failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
  fi

  local poolIdStr
  poolIdStr=`cat /opt/fusionstorage/agent/conf/dsware_cluster_info | grep -w 'osd_pool_list' |awk -F'=' '{print $2}'`
  if [ -z "${poolIdStr}" ]; then
      ScriptPrintLog "pool id string(${poolIdStr}) is null, no need to operate. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
      return 0
  fi
  local dswareManagerIp
  local addFlag=1
  dswareManagerIp=$(cat "${FSM_AGENT_DIR}/conf/dsware_manager_ip" | grep -w dsware_manager_ip | awk -F '=' '{print $2}')
  local refreshConfigFile
  refreshConfigFile=$(/opt/fusionstorage/agent/script/multi_pool_oper.sh refresh_config_file "${dswareManagerIp}" "${processIndex}" g_kms_ip_list "${kmsIpListValue}" "${poolIdStr}" global "${addFlag}")
  echo "${refreshConfigFile}" | grep -E "^result=0;"
  if [ $? -ne 0 ]
  then
    ScriptPrintLog "execute(/opt/fusionstorage/agent/script/multi_pool_oper.sh refresh_config_file ${dswareManagerIp} ${processIndex} g_kms_ip_list ${kmsIpListValue} ${poolIdStr} global ${addFlag}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
  fi
  ScriptPrintLog "execute(/opt/fusionstorage/agent/script/multi_pool_oper.sh refresh_config_file ${dswareManagerIp} ${processIndex} g_kms_ip_list ${kmsIpListValue} ${poolIdStr} global ${addFlag}) successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
  return 0
}

function DynamicModKmsIpListPara()
{
  local processType=$1
  local compCfgFile=$2
  local kmsIpList
  kmsIpList=`grep -w "^g_kms_ip_list" ${compCfgFile} 2>/dev/null`
  if [ -z "${kmsIpList}" ]; then
      ScriptPrintLog "g_kms_ip_list is null in ${compCfgFile}, no need to refresh. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
      return 0
  fi

  local poolIdStr
  poolIdStr=`cat /opt/fusionstorage/agent/conf/dsware_cluster_info | grep -w 'osd_pool_list' |awk -F'=' '{print $2}'`
  if [ -z "${poolIdStr}" ]; then
      ScriptPrintLog "pool id string(${poolIdStr}) is null, no need to operate. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
      return 0
  fi
  local dswareManagerIp
  dswareManagerIp=$(cat ${FSM_AGENT_DIR}/conf/dsware_manager_ip | grep -w dsware_manager_ip | awk -F '=' '{print $2}')
  local modifyResult
  modifyResult=$(/opt/fusionstorage/agent/tool/dynamic_mod_para.sh "${processType}" global modify "${kmsIpList}" "${poolIdStr}" "${dswareManagerIp}")
  echo "${modifyResult}" | grep -E "^result=0;"
  if [ $? -ne 0 ]
  then
    ScriptPrintLog "execute(/opt/fusionstorage/agent/tool/dynamic_mod_para.sh ${processType} global modify ${kmsIpList} ${poolIdStr} ${dswareManagerIp}) failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
  fi
  ScriptPrintLog "execute(/opt/fusionstorage/agent/tool/dynamic_mod_para.sh ${processType} global modify ${kmsIpList} ${poolIdStr} ${dswareManagerIp}) successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
  return 0
}

function NotifyOsdProcessBySignal()
{
  local processType=$1
  local var
  var=$(eval declare -p "${processType}_COMPONENT_CONFIGRATION")
  eval "declare -a local componentCfgArray"=${var#*=}
  if [ ${#componentCfgArray[*]} -eq 0 ]; then
      ScriptPrintLog "no need refresh old component(${processType}) configration. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
      return 0
  fi
  for compCfgFile in ${componentCfgArray[@]}
  do
    if [ ! -f "${compCfgFile}" ]; then
        ScriptPrintLog "${compCfgFile} is not exist. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    RefreshConfigFileKmsIpListItem "${processType}" "${compCfgFile}"
    if [ $? -ne 0 ]
    then
      ScriptPrintLog "RefreshConfigFileKmsIpListItem failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
      return 1
    fi
    ScriptPrintLog "RefreshConfigFileKmsIpListItem successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
  done

  ScriptPrintLog "can not find process type(${processType}) configuration file fail. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
  return 1
}

function NotifyLsProcessByScript()
{
  local refreshResult
  local lsScriptFile="/opt/dfv/obs_service_layer/objectroutingservice/ls/bin/ls_dsware_agent.sh"
  local owner=$(stat -c '%U' ${lsScriptFile})
  if [[ ${owner} != "root" ]];then
    refreshResult=$(su - ${owner} -s /bin/bash -c "bash ${lsScriptFile} refresh_kms_ips")
  else
    refreshResult=$(bash ${lsScriptFile} refresh_kms_ips)
  fi

  echo "${refreshResult}" | grep -Ew "result=0;value=success;"
  if [ $? -ne 0 ]
  then
    ScriptPrintLog "execute(bash ${lsScriptFile} refresh_kms_ips) by ${owner} failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
  fi
  ScriptPrintLog "execute(bash ${lsScriptFile} refresh_kms_ips) by ${owner} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}

  if [[ ${owner} != "root" ]];then
    refreshResult=$(su - ${owner} -s /bin/bash -c "bash ${lsScriptFile} refresh_configs")
  else
    refreshResult=$(bash ${lsScriptFile} refresh_configs)
  fi

  echo "${refreshResult}" | grep -Ew "result=0;value=success;"
  if [ $? -ne 0 ]
  then
    ScriptPrintLog "execute(bash ${lsScriptFile} refresh_configs) by ${owner} failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
  fi
  ScriptPrintLog "execute(bash ${lsScriptFile} refresh_configs) by ${owner} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}

  if [[ ${owner} != "root" ]];then
    refreshResult=$(su - ${owner} -s /bin/bash -c "bash ${lsScriptFile} stop")
  else
    refreshResult=$(bash ${lsScriptFile} stop)
  fi

  echo "${refreshResult}" | grep -Ew "result=0;value=success;"
  if [ $? -ne 0 ]
  then
    ScriptPrintLog "execute(bash ${lsScriptFile} stop) by ${owner} failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
  fi
  ScriptPrintLog "execute(bash ${lsScriptFile} stop) by ${owner} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}

  if [[ ${owner} != "root" ]];then
    refreshResult=$(su - ${owner} -s /bin/bash -c "bash ${lsScriptFile} start")
  else
    refreshResult=$(bash ${lsScriptFile} start)
  fi

  echo "${refreshResult}" | grep -Ew "result=0;value=success;"
  if [ $? -ne 0 ]
  then
    ScriptPrintLog "execute(bash ${lsScriptFile} start) by ${owner} failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
  fi
  ScriptPrintLog "execute(bash ${lsScriptFile} start) by ${owner} successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
  return 0
}

function NotifyProcessBySignal()
{
  local processType=$1
  local dswareConfEdsService="/opt/dsware/eds/eds/bin/eds"
  if [ "${processType}" = "EBSCtrl" ]; then
    ps -efww |grep "eds" | grep "${dswareConfEdsService}" |grep -v grep|awk '{print $2}'|xargs -r kill -SIGUSR2
    if [ $? -ne 0 ]
    then
      ScriptPrintLog "ps -efww |grep eds | grep ${dswareConfEdsService} |grep -v grep|awk '{print $2}'|xargs -r kill -SIGUSR2 failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
      return 1
    fi
    ScriptPrintLog "ps -efww |grep eds | grep ${dswareConfEdsService} |grep -v grep|awk '{print $2}'|xargs -r kill -SIGUSR2 successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 0
  fi

  local convertResult
  convertResult=$(bash ${MULTI_POOL_OPER_SCRIPT} "convert_process_index" "${processType}")
  local processIndex
  processIndex=$(echo "${convertResult}"| awk -F ";value=" '{print $2}')
  if [ -z "${processIndex}" -o  "${processIndex}" = "-1" ]
  then
    ScriptPrintLog "execute(bash ${MULTI_POOL_OPER_SCRIPT} convert_process_index ${processType}) convert process to index failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
  fi

  local dswareManagerIp
  dswareManagerIp=$(cat ${FSM_AGENT_DIR}/conf/dsware_manager_ip | grep -w dsware_manager_ip | awk -F '=' '{print $2}')
  bash ${MULTI_POOL_OPER_SCRIPT} "notify_process" "${dswareManagerIp}" "${processIndex}" SIGUSR2 65535
  if [ $? -ne 0 ]
  then
    ScriptPrintLog "bash ${MULTI_POOL_OPER_SCRIPT} notify_process ${dswareManagerIp} ${processIndex} SIGUSR2 65535 failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    return 1
  fi
  ScriptPrintLog "bash ${MULTI_POOL_OPER_SCRIPT} notify_process ${dswareManagerIp} ${processIndex} SIGUSR2 65535 successfully. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
  return 0
}

function RestartComponentByStopStart()
{
    local processType=$1
    local serverProcessType=$2
    local subOperate=$3
    local operateSuffix=""
    if [ -n "${subOperate}" ]; then
      operateSuffix="${subOperate}_"
    fi

    local scriptFile
    scriptFile=$(GetComponentScript ${processType})
    if [ -z "${scriptFile}" ]; then
        ScriptPrintLog "can not get component(${processType}) script file." ${FUNCNAME} ${SCRIPTNAME}
        return 0
    fi
    ExcuteComponentScript ${scriptFile} "${operateSuffix}stop" "success"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use script(${scriptFile}) to ${operateSuffix}stop process failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    ExcuteComponentScript ${scriptFile} "${operateSuffix}start" "success"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use script(${scriptFile}) to ${operateSuffix}start process failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi

    CheckStartStatus "${scriptFile}" "100" "${subOperate}"
    if [ $? -ne 0 ]; then
        ScriptPrintLog "process(${processType}) use ${scriptFile} to check process start ${operateSuffix}status failed. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        return 1
    fi
    return 0
}

##################################### main #####################################
InitLog "${CUR_PATH}" "operateComponetInAgent.log"
if [ $# -lt 2 ]; then
    ScriptPrintLog "input parametor number($#) is less than two. [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
    usage
    RESULT=1
    PrintResultFlag ${RESULT} "parametor check"
    exit $RESULT
fi
RESULT=
ACTION=$1
case "$ACTION" in
    start)
        PROCESS_TYPE=$2
        if [ "${PROCESS_TYPE}" = "vbs" ]; then
            StartVbs
            RESULT=$?
        else
            StartComponent $@
            RESULT=$?
        fi
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    stop)
        PROCESS_TYPE=$2
        if [ "${PROCESS_TYPE}" = "vbs" ]; then
            StopVbs
            RESULT=$?
        else
            StopComponent $@
            RESULT=$?
        fi
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    restart)
        PROCESS_TYPE=$2
        RestartComponentByFunc $@
        RESULT=$?
        if [ "${RESULT}" -eq 2 ]; then
          ScriptPrintLog "can not find restart function for ${PROCESS_TYPE}, so restart by KillProcessPid. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
          RestartComponent $@
          RESULT=$?
        fi
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    addProcess)
        PROCESS_TYPE=$2
        AddProcess $@
        RESULT=$?
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    deleteProcess)
        PROCESS_TYPE=$2
        DeleteProcess $@
        RESULT=$?
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    checkStatus)
        PROCESS_TYPE=$2
        CheckStatus ${PROCESS_TYPE}
        RESULT=$?
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    getCfg)
        PROCESS_TYPE=$2
        if [ $# -ne 3 ]; then
            ScriptPrintLog "input parametor number($#) is not 3. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            RESULT=1
            PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
            exit $RESULT
        fi
        DEST_PATH=$3
        GetCfg ${PROCESS_TYPE} ${DEST_PATH}
        RESULT=$?
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;

    generateComponetCfg)
        PROCESS_TYPE=$2
        GenerateComponetCfg $@
        RESULT=$?
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    refreshCfg)
        PROCESS_TYPE=$2
        if [ $# -ne 3 ]; then
            ScriptPrintLog "input parametor number($#) is not 3. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            RESULT=1
            PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
            exit $RESULT
        fi
        CONFIGRATION_FILE=$3
        RefreshCfg ${PROCESS_TYPE} ${CONFIGRATION_FILE}
        RESULT=$?
        ScriptPrintLog "refresh conponent(${PROCESS_TYPE}) cfg(${CONFIGRATION_FILE}) result(${RESULT}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    clearProcessConfigFile)
        PROCESS_TYPE=$2
        ClearProcessConfigFile ${PROCESS_TYPE}
        RESULT=$?
        ScriptPrintLog "roll back conponent(${PROCESS_TYPE}) cfg result(${RESULT}). [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    refreshCfgAndReboot)
        PROCESS_TYPE=$2
        RefreshCfgAndReboot $@
        RESULT=$?
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    refreshCfgAndStart)
        PROCESS_TYPE=$2
        RefreshCfgAndStart $@
        RESULT=$?
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    expandLs)
        PROCESS_TYPE=$2
        ExpandLs $@
        RESULT=$?
        ScriptPrintLog "Expand conponent(${PROCESS_TYPE}) ls result(${RESULT}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    reduceLs)
        PROCESS_TYPE=$2
        ReduceLs $@
        RESULT=$?
        ScriptPrintLog "reduce conponent(${PROCESS_TYPE}) ls result(${RESULT}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    addAcl)
        if [ $# -ne 4 ]; then
            ScriptPrintLog "input parametor number($#) is not 4. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            RESULT=1
            PrintResultFlag ${RESULT} "${ACTION}"
            exit $RESULT
        fi
        ADDED_IP=$2
        AddAcl "${ADDED_IP}" $3 $4
        RESULT=$?
        PrintResultFlag ${RESULT} "${ACTION}_${ADDED_IP}"
        exit $RESULT
        ;;
    removeAcl)
        if [ $# -ne 4 ]; then
            ScriptPrintLog "input parametor number($#) is not 4. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            RESULT=1
            PrintResultFlag ${RESULT} "${ACTION}"
            exit $RESULT
        fi
        REMOVE_IP=$2
        RemoveAcl "${REMOVE_IP}" $3 $4
        RESULT=$?
        PrintResultFlag ${RESULT} "${ACTION}_${REMOVE_IP}"
        exit $RESULT
        ;;
    clearAgentLog)
        PROCESS_TYPE=$2
        rm -f ${SHELL_LOG_FULL_PATH}
        rm -f ${SHELL_LOG_FULL_PATH}.*.gz
        set +x
        EchoResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    getMasterFromMdc)
        PROCESS_TYPE=$2
        masterClusterIp=""
        if [ "${PROCESS_TYPE}" == "vbs" ]; then
            masterClusterIp=$(mdc_cmd.sh 109| grep -w -v "MASTER"|grep -w -v "dsware_insight"|awk -F'|' '{ print $3 }' | sed 's/[[:space:]]//g' | head -n 1)
            RESULT=$?
            ScriptPrintLog "get conponent(${PROCESS_TYPE}) master from mdc, result(${RESULT}), masterClusterIp(${masterClusterIp}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        elif [ "${PROCESS_TYPE}" == "EBSCtrl" ];then
            masterClusterIp=$(/opt/dsware/eds/eds/script/diagsh --set-cli --attach=EBS_273 "--cmd=sys showctrlview"|awk '/CtrlLsNum/{f=1;next} /diagsh/{f=0} f' |awk '$2 == 1' |awk -F' ' '{print $6}'|sed 's/\[//g;s/\]//g'|sed 's/[[:space:]]//g'|head -n 1)
            masterClusterIp=${masterClusterIp%:*}
            RESULT=$?
            ScriptPrintLog "get conponent(${PROCESS_TYPE}) master from eds, result(${RESULT}), masterClusterIp(${masterClusterIp}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        elif [ "${PROCESS_TYPE}" == "zk" ];then
            masterClusterIp=$(/opt/fusionstorage/persistence_layer/agent/zk/bin/zkServer.sh all_zk_status | grep leader | awk -F '[' '{print $2}' | awk -F ']' '{print $1}' 2>/dev/null)
            RESULT=$?
            ScriptPrintLog "get conponent(${PROCESS_TYPE}) master from ZK, result(${RESULT}), masterClusterIp(${masterClusterIp}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        else
            RESULT=1
        fi
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}" "${masterClusterIp}"
        exit $RESULT
        ;;
    getMediaDiskInfo)
        PROCESS_TYPE=$2
        mediaDiskInfo=""
        if [ "${PROCESS_TYPE}" == "zk" ]; then
            mediaDiskInfo=`cat /opt/fusionstorage/persistence_layer/agent/zk/conf/zoo.cfg | grep mediaDiskInfo | awk -F "=" '{print $2}'`
            RESULT=$?
            ScriptPrintLog "get conponent(${PROCESS_TYPE}) mediaDiskInfo(${mediaDiskInfo}), result(${RESULT}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        else
            RESULT=1
        fi
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}" "${mediaDiskInfo}"
        exit $RESULT
        ;;
    refreshMediaDiskInfo)
        PROCESS_TYPE=$2
        if [ $# -ne 2 ]; then
            ScriptPrintLog "input parametor number($#) is not 1. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
            RESULT=1
            PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
            exit $RESULT
        fi
        RefreshMediaDiskInfo ${PROCESS_TYPE}
        RESULT=$?
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    checkLink)
        PROCESS_TYPE=$2
        RESULT=0
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;
    getUpgradeZone)
        PROCESS_TYPE=$2
        upgradeZoneJsonStr=""
        if [ "${PROCESS_TYPE}" == "EBSCtrl" ]; then
            upgradeZoneJsonStr=$(/opt/dsware/eds/eds/script/nms_upgrade_zone.sh GetUpgradeZone)
            RESULT=$?
            ScriptPrintLog "get conponent(${PROCESS_TYPE}) upgrade zone, result(${RESULT}), upgrade zone ==(${upgradeZoneJsonStr}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        else
            RESULT=1
        fi
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}" "${upgradeZoneJsonStr}"
        exit $RESULT
        ;;

      recover_arb|disable_arb|stopCcdbxArb|startCcdbxArb|transCcdbxDb|rollBackTransCcdbxDb)
        PROCESS_TYPE=$2
        OperateComponet $@
        RESULT=$?
        ScriptPrintLog "component(${PROCESS_TYPE}) operate(${ACTION}) result(${RESULT}). [${LINENO}]" ${FUNCNAME} ${SCRIPTNAME}
        PrintResultFlag ${RESULT} "${ACTION}_${PROCESS_TYPE}"
        exit $RESULT
        ;;


    *)
        usage
        ;;
esac



