#!/bin/bash

. ./diag_lib.sh

FC_CA_MEM_THRESHOLD4DEF="65"  #65%
FC_CA_MEM_THRESHOLD4OTH="85"  #85%
FC_DS_MEM_THRESHOLD=900 #900MB

FC_CA_LOG='.*DHL_WaitIfBusy'
FC_OBS2NV_LOG='.*\[OBS.*(NV_CACHE_FcMergeCntCbTime|GetTokenRatio|NV_MetaFcToken|NV_FcTokenAlloc|NV_DataFcToken|FC_TokenAlloc|Write_IfToken|DelTrunc_IfToken)'
FC_TRNS_LOG='.*\[OBS.*Trns_LocalIfNvdimmEnough4Del'
FC_NOFS_LOG='.*\[NOFS.*FlowControl'

function FC_Diagnosis4CA()
{
	local p0UseMemPct=0
	local p0FcMemPct=0
	local pxMemInfo=""
	declare -a pxAllocFailNumBef=()
	declare -a pxAllocFailNumAft=()
	declare -a pxName=()
	
	# LOG
	COMM_SearchLog4Module "$SNAS_MSG_LOG" "$FC_CA_LOG" "FC#CA"
	
	# Percentage
	pxMemInfo=$(ALI_GetCAMemInfo |grep -P 'PooId \d+')
	p0UseMemPct=$(echo "$pxMemInfo" |grep 'PooId 0' | grep -oP 'Percent\s+\d+' | awk '{print $2}')
	p0FcMemPct=$(COMM_GetCAFcPct)
	COMM_NumComp $p0FcMemPct $p0UseMemPct "ge" && status="E" || status="I"
	COMM_CPrint "FC#CA#CMP|Pool0|UseMemPct/FcMemPct(${p0UseMemPct}%/${p0FcMemPct}%)"  "$status"  


    # Failed alloc num
	# Different version have different CA memory pools.
	#
	pxName=($(echo "$pxMemInfo" | grep -oP 'PooId \d+,' |sed -r 's/\s+//g'))
	pxAllocFailNumBef=($(echo "$pxMemInfo" | grep -P 'PooId \d+,' | awk '{print $NF}' | sed -r 's/\s+//g'))
	sleep $INTERVAL
	pxAllocFailNumAft=($(echo "$pxMemInfo" | grep -P 'PooId \d+,' | awk '{print $NF}' | sed -r 's/\s+//g'))

	
	for((i=0;i<${#pxName[@]};i++));do
		COMM_NumComp  ${pxAllocFailNumBef[$i]} ${pxAllocFailNumAft[$i]} "gt" && ret="E" || ret="I"
		COMM_CPrint "FC#CA#CMP|Pool${i}|AllocFailedNum(${pxAllocFailNumBef[$i]}/${pxAllocFailNumAft[$i]})"  "$ret"
	done

}
	
function FC_Diagnosis4MDS()
{
	declare -a fcReqPara=(SrvDiscardReq4Cnt SrvDiscardReq4Mem SrvDiscardReq4Cnt SrvDiscardReq4Mem)
	declare -a fcReqInfoBfe=()
	declare -a fcReqInfoAft=()
	
	fcReqInfoBfe=($(COMM_GetMDSFcInfo))
	sleep $INTERVAL
	fcReqInfoAft=($(COMM_GetMDSFcInfo))
	
	for ((i=0; i<${#fcReqPara[@]} ;i++)); do
		if COMM_NumComp ${fcReqInfoBfe[$i]} ${fcReqInfoAft[$i]} "gt" ;then
			COMM_CPrint "FC#MDS#CMP|Discard(${fcReqPara[$i]})(${fcReqInfoBfe[$i]}/${fcReqInfoAft[$i]})" "E"
			return $E_FC
		fi
	done
	COMM_CPrint  "FC#MDS#CMP|Discard(${fcReqPara[*]})(${fcReqInfoBfe[*]}/${fcReqInfoAft[*]})" "I"
	
	return $E_PASS
}

function FC_Diagnosis4OBS2NV()
{
	COMM_SearchLog4Module "$SNAS_MSG_LOG" "${FC_OBS2NV_LOG}" "FC#OBS2NV"
}

function FC_Diagnosis4TRNS()
{
	COMM_SearchLog4Module "$SNAS_MSG_LOG" "${FC_TRNS_LOG}" "FC#TRNS"
}

function FC_Diagnosis4NOFS()
{
	COMM_SearchLog4Module "$SNAS_MSG_LOG" "${FC_NOFS_LOG}" "FC#NOFS"
}

function FC_Diagnosis()
{
	(FC_Diagnosis4CA ) &
	(FC_Diagnosis4MDS) &
	(FC_Diagnosis4OBS2NV)&
	(FC_Diagnosis4TRNS)&
	(FC_Diagnosis4NOFS)&
	wait
}

