#!/bin/bash

. ./diag_lib.sh

function HANG_Diagnosis4PRO()
{
 	local hangInfo=""

	# The suspension duration exceeds 60 seconds. 
	# We think it need to be checked.
	hangInfo=$(ALI_GetProTmoutReq | sed -r -n '2,$p' | awk '{if($2 >=60) {print $0}}')
	
	[ -n "$hangInfo" ] && ret="E"||ret="I"

	COMM_CPrint "HANG#PRO#INF|VFSIOHang(${hangInfo})" "${ret}"
}

function HANG_Diagnosis4NOFS()
{	
	local diskHangInfo=""
	local stackHangInfo=""
	
	diskHangInfo=$(ALI_GetNOFSDiskInfo | egrep 'State:(1|5)' )
	
	if [ -n "$diskHangInfo" ];then
		stackHangInfo=$(ALI_GetNOFSStackInfo | egrep 'ImportOnePool|TXG_WaitSynced')
		ret="E"
	else	
		ret="I"
	fi
	
	COMM_CPrint "HANG#NOFS#INF|DiskImportStatus/StackInfo(${diskHangInfo}/${stackHangInfo})" "${ret}"
}


function HANG_Diagnosis()
{	
	HANG_Diagnosis4PRO
	HANG_Diagnosis4NOFS
}



