#!/bin/bash
set +x

# ********************************************** ***************************** #
# File Name: inspect.sh
# Description: Ѳ칤.
# Input:
# Output:
# Author:
# Created:
# Function:
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #
source /opt/huawei/snas/script/inspect_mml/CommonFunc.sh
IP_ROLE_FILE="${G_TMP_INSPECT_PATH}tmp_ip_role"
NID_ROLE_FILE="${G_TMP_INSPECT_PATH}tmp_nid_role"
RepeatTimes=(1 2 3)
LOG_FILE="/var/log/inspect.log"
Valid_IP_FILE="${G_TMP_INSPECT_PATH}tmp_value_ip$!"
version=$(cat /opt/huawei/deploy/package/version |grep "ProductVersion"|awk -F= '{print $2}')

function LOG
{
    echo [`date`][$$][$!]$@ >> $LOG_FILE
}

G_SCRIPT_PATH=""
L_TMP=$0
TMP_G_SCRIPT_PATH=$1
CHECK_ID=$3
G_SCRIPT_PATH=$(dirname "$0")

function ParamCheck()
{
    echo "${TMP_G_SCRIPT_PATH}" | sed "s/^ *//" | sed "s/ *$//" | egrep "^/tmp/inspect[0-9]+/$|^inspectcollect$|^ipcfg$|^precheck$|^getsphversion$"  >/dev/null
    if [ $? -ne 0 ];then
        LOG "[$FUNCNAME][$LINENO]param1(${TMP_G_SCRIPT_PATH}) is invalid,should be \"/tmp/inspect[0-9]+/\", inspectcollect, getsphversion, ipcfg or precheck"
        exit 1
    fi
    if [ ! -z ${CHECK_ID} ];then
        echo "${CHECK_ID}" | sed "s/^ *//" | sed "s/ *$//" | egrep "^[0-9]+$" >/dev/null
        if [ $? -ne 0 ];then
            LOG "[$FUNCNAME][$LINENO] inspect item ${CHECK_ID} error!"
            exit 1
        fi
    fi
    LOG "[$FUNCNAME][$LINENO]check param ok! Params=[${TMP_G_SCRIPT_PATH} ${CHECK_ID}]"
}

function execWithTimeout()
{
    #timeout error code
    local err_timeout=125
    #command to be executed
    local command=$1
    #timeout for executing
    local timeout=$2
    #checking interval
    local interval=$3
    #delay for kill -SIGKILL
    local delay=$4
    #execute command
    eval "${command} &"
    sub_pid=$!
    #check sub-process
    local t=$timeout
    while ((t > 0)); do
        kill -0 $sub_pid 2>/dev/null
        if [ $? -ne 0 ]; then
            #get exit code of sub-process
            wait $sub_pid
            return $?
        fi
        ((t -= interval))
        sleep $interval
    done
    #kill sub-process
    kill -15 $sub_pid 2>/dev/null && kill -0 $sub_pid 2>/dev/null || return $err_timeout
    sleep $delay
    kill -0 $sub_pid 2>/dev/null && kill -9 $sub_pid 2>/dev/null
    return $err_timeout
}


function tryagain()
{
    local checkfunc=$1
    local checkid=$2
    local command="$checkfunc $checkid"

    LOG "[${FUNCNAME}][${LINENO}]Retry inspect item ${checkid}"
    WRITE_XML_HEADER >/dev/null
    execWithTimeout "$command" 600 2 2 2>/dev/null
    rc=$?
    WRITE_XML_TAIL $checkid >/dev/null
    if [ "$rc" -eq 125 ];then # timeout=125
        WRITE_XML_HEADER >/dev/null
        WRITE_XML_CMD_HEADER $checkid >/dev/null
        WRITE_XML_SUBCMD_HEADER 0
        WRITE_XML_ERROR 0 "The item is over time and The result might not complete,Please check again!" >/dev/null
        WRITE_XML_JUDGE 1 >/dev/null
        WRITE_XML_SUBCMD_TAIL >/dev/null
        WRITE_XML_CMD_TAIL >/dev/null
        WRITE_XML_TAIL $checkid >/dev/null
    fi
    return ${rc}
}


function execOneCheck()
{
    . $G_SCRIPT_PATH/inspect_lib.sh
    local starttime=0
    local endtime=0
    local checkfunc=$1
    local checkid=$2
    local command="$checkfunc $checkid"
    starttime=$(date +%s)
    LOG "[${FUNCNAME}][${LINENO}]Enter inspect item ${checkid}, result file ${G_CHECK_RESULT_FILE}"
    if [ "$command" != "" ];then
        InspectBeginTime=$(date +%s)
        WRITE_XML_HEADER >/dev/null
        execWithTimeout "$command" 600 2 2 2>/dev/null # 10minutes
        rc1=$?
        grep -q "<judge>2<\/judge>" "$G_CHECK_RESULT_FILE"
        rc2=$?
        WRITE_XML_TAIL $checkid >/dev/null
        InspectEndTime=$(date +%s)
        difftime=$(($InspectEndTime - $InspectBeginTime))
        if [ "$rc1" -eq 125 ];then # timeout=125
            WRITE_XML_HEADER >/dev/null
            WRITE_XML_CMD_HEADER $checkid >/dev/null
            WRITE_XML_SUBCMD_HEADER 0
            WRITE_XML_ERROR 0 "The item is over time and The result might not complete,Please check again!" >/dev/null
            WRITE_XML_JUDGE 1 >/dev/null
            WRITE_XML_SUBCMD_TAIL >/dev/null
            WRITE_XML_CMD_TAIL >/dev/null
            WRITE_XML_TAIL $checkid >/dev/null
        elif [ "$rc2" -eq 0 ] && [ $difftime -lt 300 ];then
            # Check again when inner error encounter and left time is enough
            # ѲΪͨ<judge>1<\/judge>ǲͨﻹ飬Ѳڲ2Ȼʱ¼
            tryagain $checkfunc $checkid
            rc1=$?
        fi
    fi
    endtime=$(date +%s)
    LOG "[${FUNCNAME}][${LINENO}]Exit inspect item ${checkid}, return code ${rc1}, elapsed time:$((${endtime} - ${starttime}))s"
}
function GetIDparts()
{
    hardtaskids=`cat inspect_hardware.sh |grep -a "1[0-9][0-9])"|awk -F\) '{print $1}'|tr -d " "`
    softtaskids=`cat inspect_software.sh |grep -a "[2-3][0-9][0-9])"|awk -F\) '{print $1}'|tr -d " "`
    othertaskids=`cat /opt/huawei/snas/script/inspect_mml/CheckItems |grep -a "[1-3][0-9][0-9])"|awk -F\) '{print $1}'|tr -d " " | tr "\n" " " | sed "s/ $2//g" | sed 's/ /\n/g'`
    alltasks=$(echo "$hardtaskids $softtaskids $othertaskids" | sed 's/ /\n/g' | sort -n | tr "\n" " ")
    alltasks=($alltasks)
    allcounts=${#alltasks[*]}

    #Ѳз顣25Ϊһ
    loop=`expr $allcounts % 25`
    parts=`expr $allcounts / 25`

    if [ $loop -eq 0 ];then
        Maxparts=$parts
    else
        Maxparts=$((parts+1))
    fi

    for((count=0;count<$Maxparts;count++))
    do
        step=$((count*25))
        part=${alltasks[@]:$step:25}
        for item in $part
        do
            if [ $1 -eq $item ];then
                alltaskids=$part
                return 0
            fi
        done
    done
    alltaskids=$1
    return 0
}

function cleanup_temp_file()
{
    LOG "cleanup temp file $(ls /tmp/tmpfileResult*\
                                /tmp/tmpfile[0-9]*\
                                /tmp/tmpfilex[0-9]*\
                                /opt/inspect/tmpfile*\
                                /opt/inspect/tmpfilex*\
                                /tmp/tmpfileRemoteResult*\
                                /tmp/tmpfileLocalResult*\
                                /tmp/inspect_downloadfile*\
                                /tmp/tmp_valid_ip*\
                                /tmp/CheckMsgFile* 2>/dev/null)"
    rm -f /tmp/tmpfileResult*
    rm -f /tmp/tmpfile[0-9]*
    rm -f /tmp/tmpfilex[0-9]*
    rm -f /opt/inspect/tmpfile*
    rm -f /opt/inspect/tmpfilex*
    rm -f /tmp/tmpfileRemoteResult*
    rm -f /tmp/tmpfileLocalResult*
    rm -f /tmp/inspect_downloadfile*
    rm -f /tmp/tmp_valid_ip*
    rm -f /tmp/CheckMsgFile*
}

#SmartKitѲǰѲδӵ͵ߵ˳Ѳ
#ָһʼ֮Ѳ
#needLongTimeInspectͨѡִʱȽϳѲЩѲ飩Ѳ
function get_uninspect_list()
{
    local curItem=$1
    local hardItems=$(cat inspect_hardware.sh | grep -a "1[0-9][0-9])"|awk -F\) '{print $1}'|tr -d " ")
    local softItems=$(cat inspect_software.sh |grep -a "[2-3][0-9][0-9])"|awk -F\) '{print $1}'|tr -d " ")
    local otherItems=$(cat /opt/huawei/snas/script/inspect_mml/CheckItems |grep -a "[1-3][0-9][0-9])"|awk -F\) '{print $1}'|tr -d " ")
    local allItems=$(echo "$hardItems $softItems $otherItems" | sed 's/ /\n/g' | sort -n | tr "\n" " ")
    local uninspect="${curItem}"
    local resultfile=""
    #ָѲ֮
    allItems=${allItems#*${curItem}}
    #飬SmartKitָʱſʼ
    if [[ "${repairInspect}" =~ "${curItem}" ]];then
        echo ${uninspect}
        return
    fi
    for item in ${needLongTimeInspect}; do
        allItems=${allItems/${item} }
    done
    #ЧĲټ
    for item in ${allItems}; do
        resultfile="/opt/inspect/check_id_file${item}"
        if [ -f "${resultfile}" ];then
            local curttime=$(date +%s)
            local filedate=$(stat ${resultfile} | grep -i Modify | awk -F. '{print $1}' | awk '{print $2" "$3}')
            local filetime=$(date -d "${filedate}" +%s)
            local passtime=$(expr $curttime - $filetime)
            if [ ${passtime} -le 6000 ];then
                continue
            fi
        fi
        uninspect="${uninspect} ${item}"
    done

    echo ${uninspect}
}

function copy_toolpkg_to_master()
{
    local needCopyPkg_list="upd_patch_for_7.1.1.SPH201.zip"
    for pkgname in $needCopyPkg_list;do
        if [ -f $TMP_G_SCRIPT_PATH/$pkgname ]; then
            cp -f $TMP_G_SCRIPT_PATH/$pkgname $G_SCRIPT_PATH/
        fi
    done
}

function entry_main()
{
    local sessionstarttime=0
    local sessionendtime=0
    # needLongTimeInspectͨѡִʱȽϳѲЩѲ飩Ѳ
    # ****ҪʵĴ˱Сд****
    # 102 107 115 118 119 130 132 228ִʱϳȺͨ200ҡ
    # 134 Ⱥ350롣129 133 Ⱥ500롣⼸Ƚϼдһɡ
    # 214СȺִԽϾá
    # 229 275ݿϴʱִгʱ䣬δݲ롣
    # 5XXΪ޸Ѳ  ִ
    export needLongTimeInspect="129 214"
    export repairInspect="408 503 504"
    # Ѳڵڵ㼴Ѳļ
    export onlyInspectOnOneNode="270 294 312 329 353 355 356 357"
    export G_CHECK_IDLIST="$CHECK_ID"

    cp -f $TMP_G_SCRIPT_PATH/inspect.sh $G_SCRIPT_PATH/
    cp -f $TMP_G_SCRIPT_PATH/inspect_expand.sh $G_SCRIPT_PATH/
    cp -f $TMP_G_SCRIPT_PATH/expand_config.conf $G_SCRIPT_PATH/

    #ߵڵ
    copy_toolpkg_to_master

    chmod 550 $G_SCRIPT_PATH/inspect.sh
    chmod 550 $G_SCRIPT_PATH/inspect_expand.sh
    chmod 640 $G_SCRIPT_PATH/expand_config.conf

    dos2unix $G_SCRIPT_PATH/inspect_lib.sh > /dev/null 2>&1
    dos2unix $G_SCRIPT_PATH/inspect_hardware.sh > /dev/null 2>&1
    dos2unix $G_SCRIPT_PATH/inspect_software.sh > /dev/null 2>&1
    dos2unix $G_SCRIPT_PATH/inspect_map.sh > /dev/null 2>&1

    . $G_SCRIPT_PATH/inspect_lib.sh

    cd $G_SCRIPT_PATH 1>/dev/null

    #****ͬѲʹòͬḶ̌ļʹ$$֤ͻѲѲǰ͵̨****
    if [ "$CHECK_ID" != "" ]; then
        IsExist=$(ls $G_SCRIPT_PATH/inspect_expand.sh)
        if [ "${IsExist}""X" = "X" ]; then
            WRITE_XML_HEADER >/dev/null
            WRITE_XML_CMD_HEADER $checkid >/dev/null
            WRITE_XML_SUBCMD_HEADER 0
            WRITE_XML_ERROR 0 "Can not find the expand script!"
            WRITE_XML_JUDGE 1
            WRITE_XML_SUBCMD_TAIL
            WRITE_XML_CMD_TAIL
            WRITE_XML_TAIL $CHECK_ID >/dev/null
        else
            dos2unix $G_SCRIPT_PATH/inspect_expand.sh > /dev/null 2>&1
            . $G_SCRIPT_PATH/inspect_expand.sh

            isExpandSupported $CHECK_ID
            if [ $? -eq 0 ]; then
                G_CHECK_IDLIST="${CHECK_ID}"
                execOneCheck "checkExpandItemStatus" $CHECK_ID
            else
                local alltaskids=""
                local RemoteexetaskList=""
                local Lastalltaskids=""
                local maxthreadcount=0
                local threadcountall=0
                local groupLimit=0
                local firstItemPid=""
                local onOneNodePid=""
                local inspecting=""

                alltaskids=$(get_uninspect_list ${CHECK_ID})

                entrynodecnt=0
                entrynodes=`cat ${IP_ROLE_FILE}`
                for Item in $entrynodes; do
                    entrynodecnt=$((entrynodecnt+1))
                done

                # ԽCPUսԽ󡣴ȺʱҪƲԽСѲڶCPUռԽƽ
                # ѲԽԽʡCPUʱ䣬ǶSmartKitӦã׳ʱһʱӰѲ
                if [ $entrynodecnt -le 12 ]; then
                    maxthreadcount=8
                    groupLimit=6
                elif [ $entrynodecnt -le 36 ]; then
                    maxthreadcount=6
                    groupLimit=6
                else
                    maxthreadcount=5
                    groupLimit=6
                fi
                taskinterval=5
                threadcountall=0
                sessionstarttime=$(date +%s)
                RemoteexetaskList=""
                Lastalltaskids=$(echo "$alltaskids" | sed 's/ *$//' | awk -F' ' '{print $NF}')
                LOG "[$FUNCNAME][$LINENO]start process alltaskids=[${alltaskids}],entrynodecnt=[${entrynodecnt}]"

                for taskid in $alltaskids
                do
                    # ÿѲڽʱһļ˳ʱɾļͨͳļѯ
                    threadcountall=$(ls ${G_TMP_INSPECT_PATH}check_thread_count* 2>/dev/null|wc -l)
                    while [ $threadcountall -ge $maxthreadcount ]
                    do
                        LOG "[$FUNCNAME]wait: threadcountall=$threadcountall, wait item ${taskid}, wait pid ${firstItemPid}"
                        sleep ${taskinterval}
                        threadcountall=$(ls ${G_TMP_INSPECT_PATH}check_thread_count* 2>/dev/null|wc -l)
                    done

                    # SmartKitָѲм飬ѲɺѲ
                    # ˳ǰһ봴һѲ̣ѲִзǳǳɣʱʧȥͨneedLongTimeInspect
                    if [ "${firstItemPid}" != "" ]; then
                        inspecting=$(pidstat -l -p ${firstItemPid} |
                            awk -v pid=${firstItemPid} '{
                                if($10$11~/inspect_software_nomal.sh|inspect_hardware_nomal.sh|inspect_software_ex.sh|inspect_ex.sh|inspect_entry.sh/) {
                                    if($4==pid) {
                                        printf "yes"
                                    }
                                }
                            }')
                        if [ "${inspecting}" != "yes" ]; then
                            break
                        fi
                    fi

                    echo "${onlyInspectOnOneNode}" | grep -w "${taskid}" >/dev/null
                    if [ $? -eq 0 ]; then
                        if [ "${onOneNodePid}" == "" ];then #Ѳֻһ
                            G_CHECK_IDLIST="${taskid}"
                            $G_SCRIPT_PATH/inspect_software_ex.sh "${taskid}" &
                            onOneNodePid=$!
                            if [ "${CHECK_ID}" == "${taskid}" ]; then
                                firstItemPid=${onOneNodePid}
                            fi
                            sleep 2
                        fi
                        continue
                    fi

                    #ҪԶִеѲSmartKitָѲ̣ﵽ
                    IsInspectFun=$(GetInspectType ${taskid})
                    if [ "${IsInspectFun}" != "" ];then
                        RemoteexetaskList="${RemoteexetaskList} ${taskid}"
                        Remoteexetaskcount=$(echo "${RemoteexetaskList}" | sed 's/^ *//;s/ *$//;s/ /\n/g' | wc -l)
                        if [ "${CHECK_ID}" == "${taskid}" -o ${Remoteexetaskcount} -ge ${groupLimit} -o ${taskid} -eq ${Lastalltaskids} ];then
                            LOG "[$FUNCNAME][$LINENO]inspect item list ${RemoteexetaskList}"
                            $G_SCRIPT_PATH/inspect_ex.sh "$RemoteexetaskList" &
                            if [ "${CHECK_ID}" == "${taskid}" ]; then
                                firstItemPid=$!
                            fi
                            RemoteexetaskList=""
                            sleep 2
                        fi
                        continue
                    fi

                    {
                        local highnum=$(echo $RANDOM)
                        local lownum=$(date +%N | cut -c 1-4)
                        #н˷֧ѲָG_CHECK_RESULT_FILE
                        #inspect_hardware.sh/inspect_software.shʱֵG_CHECK_RESULT_FILEһġ$$ʹõentry_mainڵĽ
                        export G_CHECK_RESULT_FILE="${G_TMP_INSPECT_PATH}check_thread_file${highnum}${lownum}_${taskid}"
                        case $taskid in
                        1*)
                            execOneCheck "$G_SCRIPT_PATH/inspect_hardware_nomal.sh" $taskid
                            ;;
                        2*|3*|4*|5*)
                            execOneCheck "$G_SCRIPT_PATH/inspect_software_nomal.sh" $taskid
                            ;;
                        *)
                            ;;
                            esac
                    }&
                    if [ "${CHECK_ID}" == "${taskid}" ]; then
                        firstItemPid=$!
                    fi
                    sleep 2
                done
                wait
                sessionendtime=$(date +%s)
                LOG "[$FUNCNAME][$LINENO]end process alltaskids=[${alltaskids}],block total use time:$(expr ${sessionendtime} - ${sessionstarttime})s"
            fi
        fi
    fi
    # ʷڴ˴ʱļʱļоڽ̺($$)
    # Ѳ쳬ʱѲȻڸЩļSmartKit·µѲIDͿܴڶͬѲ
    # ǰʱļrm -f /opt/inspect/tmpfile*ģûƥ̺ţͿܵʱļ´ƬѲδɼ
    # һɽİ취ѲӽиԼʱļǿܴɾĿǰǾѲʱ
    cleanup_temp_file
    cd - 1>/dev/null
}

function inspect_precheck()
{
    local cpuHiThreshold=85
    local nodesNumCluster=3
    local nodesMax=40
    local confFile="/opt/inspect/inspect_precheck.conf"
    nodesNumCluster=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select NID from CM_NODE_IP_T" | sort -u | wc -l)
    if [ ! -f "${confFile}" ]; then
        echo "maximum_nodes_small_cluster=40"  >"${confFile}"
        echo "cpu_usage_small_cluster=85" >>"${confFile}"
        echo "cpu_usage_large_cluster=75" >>"${confFile}"
        if [ ${nodesNumCluster} -le ${nodesMax} ]; then
            cpuHiThreshold=85
        else
            cpuHiThreshold=75
        fi
    else
        nodesMax=$(grep -Po '(?<=maximum_nodes_small_cluster=)[0-9]+' "${confFile}")
        if [ ${nodesNumCluster} -le ${nodesMax:=40} ]; then
            cpuHiThreshold=$(grep -Po '(?<=cpu_usage_small_cluster=)[0-9]+' "${confFile}")
            cpuHiThreshold=${cpuHiThreshold:=85}
        else
            cpuHiThreshold=$(grep -Po '(?<=cpu_usage_large_cluster=)[0-9]+' "${confFile}")
            cpuHiThreshold=${cpuHiThreshold:=75}
        fi
    fi

    local cpuIdleUsage=0
    cpuIdleUsage=$(mpstat 1 2 | awk '{ if($1=="Average:"){print$NF} }')
    if [ $(echo "${cpuIdleUsage}+${cpuHiThreshold} > 100" | bc) -eq 1 ]; then
        echo "CPU CHECK PASS"
        return 0
    else
        echo "CPU CHECK FAIL"
        return 1
    fi
}

function inspect_getsphversion()
{
    sphVersion=$( cat /opt/huawei/deploy/package/version | grep -aw ExternalVersion | awk -F '=' '{print $2}' )
    packagehistoryconf="/var/huawei/patch/package_history/sph/package_history.conf"
    if [ -f "$packagehistoryconf" ];then
        lastversion=$( cat /var/huawei/patch/package_history/sph/package_history.conf | head -1 | awk -F_ '{print $NF}' )
        if [ ! -z "$lastversion" ];then
            sphVersion="$lastversion"
        fi
    fi
    echo "${sphVersion}"
    return 0
}

function LOG_Rotate()
{
    [ -f /var/log/inspect_1.log ] && mv /var/log/inspect_1.log /var/log/inspect_2.log
    [ -f /var/log/inspect.log   ] && mv /var/log/inspect.log /var/log/inspect_1.log
    touch /var/log/inspect.log
}

. $G_SCRIPT_PATH/inspect_map.sh
ParamCheck
#preinspect.pyãÿѲ쿪ʼǰһΣɺIPбļ
if [ "$TMP_G_SCRIPT_PATH" == "ipcfg" ];then
    # Ŀǰ־ԣ10MΪinspect_1.logȺѲʱ־ɴﵽ14M
    # ÿѲǰʷ2Ѳ¼
    LOG_Rotate
    #ϴѲļ
    rm -f /opt/inspect/check_id_file*
    [ ! -d "${G_TMP_INSPECT_PATH}" ] && mkdir -p "${G_TMP_INSPECT_PATH}"
    rm -f ${G_TMP_INSPECT_PATH}*
    GetIPAndRoleFromDB
    ##ÿѲ֮ǰʱļĿ¼
    makeInspectDir
    exit 0
fi

#ԤCPUֵֹѲ
if [ "$TMP_G_SCRIPT_PATH" == "precheck" ];then
    inspect_precheck
    exit 0
fi

#ԤȲ汾
if [ "$TMP_G_SCRIPT_PATH" == "getsphversion" ];then
    inspect_getsphversion
    exit 0
fi

#ѲѼ豸Ϣ:Ĳinspectcollect,ʾѼ
if [ "$TMP_G_SCRIPT_PATH" == "inspectcollect" ];then
    LOG "inspect_entry.sh start inspectcollect ********"
    sh /opt/inspect/inspect_collect_systeminfo.sh > /dev/null 2>&1
    exit 0
fi

checkfile="/opt/inspect/check_id_file$CHECK_ID"
needcheck=1

if [ -f "$checkfile" ];then
    curttime="`date +%s`"
    filedate="`stat $checkfile | grep -i Modify |grep -i Modify | awk -F. '{print $1}' | awk '{print $2" "$3}'`"
    filetime="`date -d "$filedate" +%s`"
    passtime=`expr $curttime - $filetime`
    #ȺѲʱɴ100ӡʹѲھЧ
    if [ $passtime -le 6000 ];then
        needcheck=0
    fi
fi

if [ -f "$G_SCRIPT_PATH/inspect_expand.sh" ];then
    . $G_SCRIPT_PATH/inspect_expand.sh
    isExpandSupported $CHECK_ID
    if [ $? -eq 0 ]; then
        needcheck=1
    fi
fi

LOG "User start inspect item ${CHECK_ID}. Flag ${needcheck}"
if [ $needcheck -eq 1 ];then
    entry_main
fi

# checkfileʹúļ´ʹ
cat $checkfile
LOG "User end inspect item ${CHECK_ID}."

exit 0

