#!/bin/bash

rm -rf /var/tmp/nofs_pool_listmemberinfo*
rm -rf tmpfile*
echo "poolname type chunkcnt chunkalloc percent"

for pool in `/opt/huawei/snas/sbin/nofs-snas listpool | awk '{print $1}' | grep -a P`
do
    tmpfile1=`/opt/huawei/snas/sbin/nofs-snas listdiskmemberinfo $pool`
    tmpfile2=`echo $tmpfile1 | awk -F 'file' '{print $2}'`
    cat $tmpfile2 | grep -a index > tmpfile3

    str="pool:$pool"

    for((i=0;i<=7;i++))
    do
        str1=`cat tmpfile3 | awk '{if($3=='"$i"')print}'| awk '{sum+=$4}END{if(NR>0){printf "%d %d %d(MB) %1.2f\n",'$i',NR,sum*4/1024,sum/NR/16384}else{printf "%d %d %d %1.2f\n",'$i',0,0,0}}'`
        str="$str| $str1"
    done

    datacnt=`cat tmpfile3 | awk '{if($3==1||$3==2||$3==3)print}' | wc -l`
    metacnt=`cat tmpfile3 | awk '{if($3==4||$3==5||$3==6)print}' | wc -l`
    mixfree=`cat tmpfile3 | awk '{if($3==0||$3==7)print}' | wc -l`

    totalcnt=$[${datacnt}+${metacnt}+${mixfree}]
    datalimit=$[${totalcnt}*93/100+1]
    metalimit=$[${totalcnt}*8/100+1]
    str="$str| $datacnt($datalimit) $metacnt($metalimit) ${totalcnt}"
    
    echo $str
done

rm -rf tmpfile*