DROP TABLE IF EXISTS t_user_authenticate_info;
CREATE TABLE IF NOT EXISTS t_user_authenticate_info (
  id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
  windows_account            VARCHAR(256)                      COMMENT 'windows账号',
  login_account              VARCHAR(64)                      COMMENT '用户账号',
  login_account_name         VARCHAR(128)                     COMMENT '用户账号全名',
  region                     VARCHAR(64)                      COMMENT '地区部',
  rep_office                 VARCHAR(64)                      COMMENT '代表处',
  product_line               VARCHAR(1024)                      COMMENT '产品线',
  region_en                  VARCHAR(64)                      COMMENT '地区部英文',
  rep_office_en              VARCHAR(64)                      COMMENT '代表处英文',
  productLine_en             VARCHAR(1024)                      COMMENT '产品线英文',
  region_code                VARCHAR(64)                      COMMENT '地区部编码',
  rep_office_Code            VARCHAR(64)                      COMMENT '代表处编码',
  productLine_code           VARCHAR(1024)                      COMMENT '产品线编码',
  responsible_network        VARCHAR(128)                      COMMENT '网络',
  responsible_network_en     VARCHAR(128)                      COMMENT '网络英文',
  responsible_network_code   VARCHAR(128)                      COMMENT '网络编码',
  esn                        VARCHAR(64)                      COMMENT 'esn码',
  device_id                  VARCHAR(128)                      COMMENT '设备码',
  is_public_om_terminal      BOOLEAN                          COMMENT '是否公共运维终端',
  auth_id                    VARCHAR(64)                      COMMENT '认证码',
  not_structural_component_policy  VARCHAR(64)                COMMENT '结构组件非变更策略',
  structural_component_policy  VARCHAR(64)                    COMMENT '结构组件变更策略',
  datacom_network_tied_policy   VARCHAR(64)                   COMMENT '数通并网策略',
  operation_preparation_inside_policy   VARCHAR(64)           COMMENT '变更准备阶段NetCare Inside管控策略',
  command_version            VARCHAR(256)                     COMMENT '命令版本号',
  auth_type                  VARCHAR(64)                      COMMENT '认证方式',
  current_status             INTEGER                          COMMENT '当前状态',
  auth_validate_period       VARCHAR(64)                      COMMENT '认证有效期时间',
  create_time                TIMESTAMP                            COMMENT '创建时间',
  update_time                TIMESTAMP                            COMMENT '更新时间',
  operator                   VARCHAR(64)                      COMMENT '操作人',
  site                   VARCHAR(16)                      COMMENT '站点信息',
  is_default_user                   VARCHAR(16)                      COMMENT '是否缺省用户',
  init_manage_control_policy                   VARCHAR(16)                      COMMENT '管控策略',
  customer_group                      VARCHAR(128)                      COMMENT '客户群code',
  customer_group_cn                   VARCHAR(128)                      COMMENT '客户群中文',
  customer_group_en                   VARCHAR(128)                      COMMENT '客户群英文',
  operate_permission                  VARCHAR(128)                      COMMENT '操作权限',
  expiration_time                  VARCHAR(64)                      COMMENT '离线认证文件过期时间',
  CONSTRAINT t_user_authenticate_info PRIMARY KEY (id)
);
COMMENT ON TABLE t_user_authenticate_info IS '用户认证信息表';


DROP TABLE IF EXISTS t_task_info;
CREATE TABLE IF NOT EXISTS t_task_info (
  id                         INTEGER  NOT NULL AUTO_INCREMENT  COMMENT 'id',
  task_id                    VARCHAR(64)                       COMMENT '任务id',
  task_name                  VARCHAR(512)                       COMMENT '任务名称',
  rfc_num                    VARCHAR(64)                       COMMENT '变更单号',
  task_executor              VARCHAR(64)                       COMMENT '任务执行人',
  task_executor_name         VARCHAR(128)                      COMMENT '任务执行人全名',
  task_status                INTEGER                           COMMENT '任务状态',
  task_control_type          VARCHAR(64)                       COMMENT '任务管控类型',
  task_type                  VARCHAR(64)                       COMMENT '任务类型',
  intercept_policy           VARCHAR(64)                       COMMENT '拦截策略',
  risk_level                 INTEGER                           COMMENT '拦截策略风险级别',
  task_start_time            DATETIME                          COMMENT '任务开始时间',
  task_end_time              DATETIME                          COMMENT '任务结束时间',
  delay_num                  INTEGER                           COMMENT '变更任务延期次数',
  is_cur_task                BOOLEAN                           COMMENT '是否当前任务',
  task_obtain_mode           VARCHAR(64)                       COMMENT '任务获取方式',
  region                     VARCHAR(64)                       COMMENT '地区部',
  rep_office                 VARCHAR(64)                       COMMENT '代表处',
  product_line               VARCHAR(1024)                       COMMENT '产品线',
  region_en                  VARCHAR(64)                       COMMENT '地区部英文',
  rep_office_en              VARCHAR(64)                       COMMENT '代表处英文',
  productLine_en             VARCHAR(1024)                       COMMENT '产品线英文',
  region_code                VARCHAR(64)                       COMMENT '地区部编码',
  rep_office_Code            VARCHAR(64)                       COMMENT '代表处编码',
  productLine_code           VARCHAR(1024)                     COMMENT '产品线编码',
  planned_nes                VARCHAR(64)                       COMMENT '计划网元数',
  auth_start_time            TIMESTAMP                         COMMENT '授权开始时间',
  auth_end_time              TIMESTAMP                         COMMENT '授权结束时间',
  customer                   VARCHAR(64)                       COMMENT '客户',
  create_time                DATETIME                          COMMENT '创建时间',
  update_time                DATETIME                          COMMENT '更新时间',
  operator                   VARCHAR(64)                       COMMENT '操作人',
  operation_preparation_time DATETIME                          COMMENT '操作前准备时间',
  task_project_type          VARCHAR(64)                       COMMENT '中英文方案标识',
  CONSTRAINT t_task_info PRIMARY KEY (id)
);
COMMENT ON TABLE t_task_info IS '任务信息表';


DROP TABLE IF EXISTS t_high_risk_command_info;
CREATE TABLE IF NOT EXISTS t_high_risk_command_info (
  id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
  region                     VARCHAR(64)                      COMMENT '地区部',
  rep_office                 VARCHAR(64)                      COMMENT '代表处',
  product_line               VARCHAR(1024)                      COMMENT '产品线',
  region_en                  VARCHAR(64)                      COMMENT '地区部英文',
  rep_office_en              VARCHAR(64)                      COMMENT '代表处英文',
  productLine_en             VARCHAR(1024)                      COMMENT '产品线英文',
  region_code                VARCHAR(64)                      COMMENT '地区部编码',
  rep_office_Code            VARCHAR(64)                      COMMENT '代表处编码',
  productLine_code           VARCHAR(1024)                      COMMENT '产品线编码',
  full_command               VARCHAR(1024)                      COMMENT '命令全拼',
  command_regex              VARCHAR(1024)                      COMMENT '命令正则',
  create_time                TIMESTAMP                            COMMENT '创建时间',
  update_time                TIMESTAMP                            COMMENT '更新时间',
  operator                   VARCHAR(64)                      COMMENT '操作人',
  risk_level                 INTEGER                          COMMENT '风险级别',
  CONSTRAINT t_high_risk_command_info PRIMARY KEY (id)
);
COMMENT ON TABLE t_high_risk_command_info IS '高危命令信息表';

DROP TABLE IF EXISTS t_white_list_command_info;
CREATE TABLE IF NOT EXISTS t_white_list_command_info (
  id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
  region                     VARCHAR(64)                      COMMENT '地区部',
  rep_office                 VARCHAR(64)                      COMMENT '代表处',
  product_line               VARCHAR(1024)                      COMMENT '产品线',
  region_en                  VARCHAR(64)                      COMMENT '地区部英文',
  rep_office_en              VARCHAR(64)                      COMMENT '代表处英文',
  productLine_en             VARCHAR(1024)                      COMMENT '产品线英文',
  region_code                VARCHAR(64)                      COMMENT '地区部编码',
  rep_office_Code            VARCHAR(64)                      COMMENT '代表处编码',
  productLine_code           VARCHAR(1024)                      COMMENT '产品线编码',
  full_command               VARCHAR(1024)                      COMMENT '命令全拼',
  command_regex              VARCHAR(1024)                      COMMENT '命令正则',
  create_time                TIMESTAMP                            COMMENT '创建时间',
  update_time                TIMESTAMP                            COMMENT '更新时间',
  operator                   VARCHAR(64)                      COMMENT '操作人',
  risk_level                 INTEGER                          COMMENT '风险级别',
  CONSTRAINT t_white_list_command_info PRIMARY KEY (id)
);
COMMENT ON TABLE t_white_list_command_info IS '白名单命令信息表';

DROP TABLE IF EXISTS t_control_policy_config;
CREATE TABLE IF NOT EXISTS t_control_policy_config (
  id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
  region                     VARCHAR(64)                      COMMENT '地区部',
  rep_office                 VARCHAR(64)                      COMMENT '代表处',
  region_en                  VARCHAR(64)                      COMMENT '地区部英文',
  rep_office_en              VARCHAR(64)                      COMMENT '代表处英文',
  region_code                VARCHAR(64)                      COMMENT '地区部编码',
  rep_office_Code            VARCHAR(64)                      COMMENT '代表处编码',
  network                    VARCHAR(128)                      COMMENT '网络',
  account_check_type         VARCHAR(64)                      COMMENT '账号校验策略',
  create_time                TIMESTAMP                            COMMENT '创建时间',
  update_time                TIMESTAMP                            COMMENT '更新时间',
  operator                   VARCHAR(64)                      COMMENT '操作人',
  CONSTRAINT t_control_policy_config PRIMARY KEY (id)
);
COMMENT ON TABLE t_control_policy_config IS '管控策略配置表';

DROP TABLE IF EXISTS t_verify_code_record;
CREATE TABLE IF NOT EXISTS t_verify_code_record (
  id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
  verify_type                VARCHAR(64)                      COMMENT '验证类型',
  task_id                    VARCHAR(64)                      COMMENT '任务id',
  account                    VARCHAR(64)                      COMMENT '账号',
  verify_status              INTEGER                          COMMENT '验证状态',
  active_period              VARCHAR(64)                      COMMENT '有效期',
  verify_fail_cause          VARCHAR(256)                     COMMENT '验证失败原因',
  verify_code                VARCHAR(64)                      COMMENT '验证码',
  verify_code_type           INTEGER                          COMMENT '验证码类型,日常动网使用 0 不拦截 1拦截',
  verify_time                TIMESTAMP                        COMMENT '验证时间',
  create_time                TIMESTAMP                        COMMENT '验证码创建时间',
  operator                   VARCHAR(64)                      COMMENT '操作人',
  CONSTRAINT t_verify_code_record PRIMARY KEY (id)
);
COMMENT ON TABLE t_verify_code_record IS '验证码验证记录表';

DROP TABLE IF EXISTS t_device_id_info;
CREATE TABLE IF NOT EXISTS t_device_id_info (
  id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
  windows_account                     VARCHAR(256)                      COMMENT 'Windows账号',
  device_id                 VARCHAR(128)                      COMMENT '工具ID',
  esn                  VARCHAR(64)                      COMMENT 'esn编号',
  tool_version               VARCHAR(128)                      COMMENT '工具版本号',
  net_care_role_code                  VARCHAR(16)                      COMMENT 'netcare角色code',
  CONSTRAINT t_device_id_info PRIMARY KEY (id)
);
COMMENT ON TABLE t_device_id_info IS '设备信息表';

DROP TABLE IF EXISTS t_task_account_bound;
CREATE TABLE IF NOT EXISTS t_task_account_bound (
  id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
  task_id                    VARCHAR(64)                      COMMENT '关联执行任务',
  task_executor              VARCHAR(64)                      COMMENT '任务执行人',
  ne_account                 TEXT                             COMMENT '网元账号',
  ne_pass                    TEXT                             COMMENT '网元密码',
  account_holder             VARCHAR(256)                      COMMENT '账号持有人',
  create_time                TIMESTAMP                        COMMENT '创建时间',
  update_time                TIMESTAMP                        COMMENT '更新时间',
  operator                   VARCHAR(64)                      COMMENT '操作人',
  CONSTRAINT t_task_account_bound PRIMARY KEY (id)
);
COMMENT ON TABLE t_task_account_bound IS '任务账号绑定表';

DROP TABLE IF EXISTS t_high_risk_intercept_record;
CREATE TABLE IF NOT EXISTS t_high_risk_intercept_record (
  id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
  account                    VARCHAR(64)                      COMMENT '账号',
  input_command              TEXT                             COMMENT '输入命令',
  full_command               TEXT                             COMMENT '命令全拼',
  command_regex              TEXT                             COMMENT '命令正则',
  intercept_time             TIMESTAMP                        COMMENT '拦截时间',
  post_intercept_mode        VARCHAR(64)                      COMMENT '拦截后处理方式',
  un_lock_time               TIMESTAMP                        COMMENT '解锁时间',
  lock_code                  VARCHAR(64)                      COMMENT '输入的解锁码',
  guid	                     VARCHAR(64)                      COMMENT 'guid',
  operator                   VARCHAR(64)                      COMMENT '操作人',
  intercept_type             VARCHAR(64)                      COMMENT '拦截类型',
  task_id                    VARCHAR(64)                      COMMENT '关联执行任务',
  command_type               VARCHAR(10)                      COMMENT '命令类型 menu或command',
  CONSTRAINT t_high_risk_intercept_record PRIMARY KEY (id)
);
COMMENT ON TABLE t_high_risk_intercept_record IS '高危命令拦截记录表';

DROP TABLE IF EXISTS t_high_risk_full_command;
CREATE TABLE IF NOT EXISTS t_high_risk_full_command (
  id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
  full_command               VARCHAR(1024)                    COMMENT '命令全拼',
  intercept_type             VARCHAR(64)                      COMMENT '拦截类型',
  operator                   VARCHAR(64)                      COMMENT '操作人',
  CONSTRAINT t_high_risk_full_command PRIMARY KEY (id)
);
COMMENT ON TABLE t_high_risk_full_command IS '高危命令全称记录表';

DROP TABLE IF EXISTS t_account_login_check_record;
CREATE TABLE IF NOT EXISTS t_account_login_check_record (
  id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
  login_account              VARCHAR(64)                      COMMENT '登录账号',
  login_time                 TIMESTAMP                        COMMENT '登录时间',
  login_ne                   VARCHAR(64)                      COMMENT '登录网元',
  check_type                 VARCHAR(64)                      COMMENT '账号校验策略',
  user_account               VARCHAR(64)                      COMMENT '用户账号',
  task_id                    VARCHAR(64)                      COMMENT '关联执行任务',
  check_time                 TIMESTAMP                        COMMENT '校验时间',
  check_result               VARCHAR(64)                      COMMENT '校验结果',
  verify_code                VARCHAR(64)                      COMMENT '扫码验证通过验证码',
  create_time                TIMESTAMP                        COMMENT '创建时间',
  operator                   VARCHAR(64)                      COMMENT '操作人',
  CONSTRAINT t_account_login_check_record PRIMARY KEY (id)
);
COMMENT ON TABLE t_account_login_check_record IS '账号登录校验记录表';

DROP TABLE IF EXISTS t_component_policy_version;
CREATE TABLE IF NOT EXISTS t_component_policy_version (
  id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
  component_policy           VARCHAR(64)                      COMMENT '高危或白名单拦截策略',
  product_line_code          VARCHAR(64)                      COMMENT '产品线code',
  version                    VARCHAR(64)                      COMMENT '命令拦截策略版本',
  update_time                TIMESTAMP                        COMMENT '更新时间',
  operator                   VARCHAR(64)                      COMMENT '操作人',
  CONSTRAINT t_component_policy_version PRIMARY KEY (id)
);

DROP TABLE IF EXISTS t_task_subtype_info;
CREATE TABLE IF NOT EXISTS t_task_subtype_info (
  id                         INTEGER NOT NULL AUTO_INCREMENT  COMMENT 'id',
  task_id                    VARCHAR ( 64 )                   COMMENT '任务单号',
  task_process               CLOB                             COMMENT '子任务数据信息',
  task_process_stages        VARCHAR ( 1024 )                 COMMENT '方案中的打点数据信息',
  dot_info                   VARCHAR ( 1024 )                 COMMENT '打点信息',
  ne_info_list               CLOB                             COMMENT '网元信息',
  create_time                TIMESTAMP                        COMMENT '创建时间',
  task_subtype               VARCHAR ( 8 )                    COMMENT '任务子类型',
  operator                   VARCHAR ( 64 )                   COMMENT '操作人',
  CONSTRAINT t_task_subtype_info PRIMARY KEY (id)
);
COMMENT ON TABLE t_task_subtype_info IS '任务子类型信息表';

DROP TABLE IF EXISTS t_dot_info;
CREATE TABLE IF NOT EXISTS t_dot_info (
  id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
  task_id                    VARCHAR(64)                      COMMENT '任务单号',
  dot_stage_id               VARCHAR(64)                      COMMENT '点位编号',
  dot_stage_name             VARCHAR(64)                      COMMENT '点位名称',
  task_subtype               VARCHAR(64)                      COMMENT '子任务类型',
  dot_stage_time             TIMESTAMP                        COMMENT '打点时间',
  operator                   VARCHAR(64)                      COMMENT '操作人',
  CONSTRAINT t_dot_info PRIMARY KEY (id)
);
COMMENT ON TABLE t_dot_info IS '打点数据记录表';

-- 产品线管理
DROP TABLE IF EXISTS T_SYS_PRODUCT_LINE;
CREATE TABLE T_SYS_PRODUCT_LINE(
  PRODUCT_LINE_ID            INTEGER NOT NULL AUTO_INCREMENT  COMMENT '主键',
  PRODUCT_LINE_NAME_CN       VARCHAR(256) UNIQUE              COMMENT '产品线中文名称',
  PRODUCT_LINE_NAME_EN       VARCHAR(256) UNIQUE              COMMENT '产品线英文名称',
  PRODUCT_LINE_CODE          VARCHAR(256) UNIQUE              COMMENT '产品线编码',
  DESCRIPTION                VARCHAR(1024)                    COMMENT '描述',
  IS_DEFAULT                 INT                              COMMENT '是否系统默认（不能编辑）：1.是，0.否',
  CREATE_TIME                TIMESTAMP                        COMMENT '创建时间',
  CONSTRAINT T_SYS_PRODUCT_LINE_PRIMARY PRIMARY KEY (PRODUCT_LINE_ID)
);
COMMENT ON TABLE T_SYS_PRODUCT_LINE IS '产品线管理';

DROP TABLE IF EXISTS T_SYS_DATA;
CREATE TABLE T_SYS_DATA (
  DATA_ID                    INTEGER NOT NULL AUTO_INCREMENT  COMMENT '主键' ,
  DATA_NAME_CN               VARCHAR(256)                     COMMENT '数据资源中文名称',
  DATA_NAME_EN               VARCHAR(256)                     COMMENT '数据资源英文名称',
  DATA_TYPE                  VARCHAR(256)                     COMMENT '数据资源类型，例：REGION',
  DATA_CODE                  VARCHAR(256)                     COMMENT '数据资源编码',
  PARENT_ID                  INTEGER                          COMMENT '父节点ID',
  ROOT_ID                    INTEGER                          COMMENT '根节点ID',
  SORT                       INTEGER                          COMMENT '排序',
  SECURITY_FLAG              INTEGER                          COMMENT '标识：0-省市县；1-地代办',
  DESCRIPTION                VARCHAR(1024)                    COMMENT '描述',
  CONSTRAINT T_SYS_DATA PRIMARY KEY (DATA_ID)
);
COMMENT ON TABLE T_SYS_DATA IS '数据资源表';

DROP TABLE IF EXISTS t_datacom_network_tied_commands;
CREATE TABLE IF NOT EXISTS t_datacom_network_tied_commands (
    id                         INTEGER  NOT NULL AUTO_INCREMENT  COMMENT 'id',
    product_type               VARCHAR(128)                      COMMENT '产品类型',
    command_type               VARCHAR(128)                      COMMENT '命令类型',
    command              	   VARCHAR(1024)                      COMMENT '命令',
    description                VARCHAR(128)                      COMMENT '命令描述',
    create_time                TIMESTAMP                         COMMENT '创建时间',
    operator                   VARCHAR(64)                       COMMENT '操作人',
    CONSTRAINT t_datacom_network_tied_commands PRIMARY KEY (id)
    );
COMMENT ON TABLE t_datacom_network_tied_commands IS '数通并网管理检查命令配置表';

DROP TABLE IF EXISTS t_crt_scheme_command_info;
CREATE TABLE IF NOT EXISTS t_crt_scheme_command_info (
    id                         INTEGER  NOT NULL AUTO_INCREMENT   COMMENT 'id',
    is_run              	   BOOLEAN                     		  COMMENT '是否执行',
    scheme_command             VARCHAR(1024)                      COMMENT '方案内命令',
    create_time                TIMESTAMP                          COMMENT '创建时间',
    task_id                    VARCHAR(64)                        COMMENT '任务Id',
    CONSTRAINT t_crt_scheme_command_info PRIMARY KEY (id)
);
COMMENT ON TABLE t_crt_scheme_command_info IS '方案内命令信息表';

DROP TABLE IF EXISTS t_datacom_network_tied_intercept_record;
CREATE TABLE IF NOT EXISTS t_datacom_network_tied_intercept_record (
    id                         INTEGER  NOT NULL AUTO_INCREMENT  COMMENT 'id',
    product_type               VARCHAR(128)                      COMMENT '产品类型',
    command_type               VARCHAR(128)                      COMMENT '命令类型',
    command              	   TEXT                              COMMENT '命令',
    un_lock_time               TIMESTAMP                         COMMENT '解锁时间',
    lock_code                  VARCHAR(64)                       COMMENT '输入的解锁码',
    post_intercept_mode        VARCHAR(64)                       COMMENT '拦截后处理方式',
    intercept_time             TIMESTAMP                         COMMENT '拦截时间',
    guid	                   VARCHAR(64)                       COMMENT 'guid',
    sub_reason                 VARCHAR(256)                      COMMENT '提交原因',
    analysis_results           VARCHAR(256)                      COMMENT '检查结果',
    handling_method            VARCHAR(256)                      COMMENT '检查结果',
    task_id                    VARCHAR(64)                       COMMENT '关联执行任务',
    operator                   VARCHAR(64)                       COMMENT '操作人',
    CONSTRAINT t_datacom_network_tied_intercept_record PRIMARY KEY (id)
    );
COMMENT ON TABLE t_datacom_network_tied_intercept_record IS '数通并网管理检查命令拦截记录表';

-- 国际化字典数据表
DROP TABLE IF EXISTS T_SYS_DICT_DATA;
CREATE TABLE IF NOT EXISTS T_SYS_DICT_DATA (
    DATA_ID 		 INTEGER NOT NULL AUTO_INCREMENT  COMMENT 'ID',
    DICT_TYPE 		 VARCHAR(256)  					  COMMENT '字典类型',
    DICT_CODE 		 VARCHAR(256)  					  COMMENT '字典编码',
    DICT_VALUE 		 VARCHAR(512)  					  COMMENT '字典值',
    DICT_LANG 		 VARCHAR(256)  					  COMMENT '语言',
    CREATOR 		 VARCHAR(256)  					  COMMENT '创建者',
    CREATE_TIME 	 TIMESTAMP  					  COMMENT '创建时间',
    CONSTRAINT T_SYS_DICT_DATA_PRIMARY PRIMARY KEY (DATA_ID)
);
COMMENT ON TABLE T_SYS_DICT_DATA IS '国际化字典数据表';

-- 数通并网数据源
DROP TABLE IF EXISTS T_DATACOM_NETWORK_TIED_DATA;
CREATE TABLE IF NOT EXISTS T_DATACOM_NETWORK_TIED_DATA (
    ID 		 INTEGER NOT NULL AUTO_INCREMENT  COMMENT 'ID',
    SOURCE_DATA 	 TEXT 					          COMMENT '数据源',
    CREATE_TIME 	 TIMESTAMP  					  COMMENT '创建时间',
    CONSTRAINT T_DATACOM_NETWORK_TIED_DATA_PRIMARY PRIMARY KEY (ID)
);
COMMENT ON TABLE T_DATACOM_NETWORK_TIED_DATA IS '数通并网数据源';

-- 调测组内网元
DROP TABLE IF EXISTS T_ENGINEERING_COMMISSIONING_NES;
CREATE TABLE IF NOT EXISTS T_ENGINEERING_COMMISSIONING_NES(
    ID 		 	   INTEGER NOT NULL AUTO_INCREMENT  COMMENT 'ID',
    NE_NAME 		 VARCHAR(256)  					COMMENT '网元名称',
    NE_IP	 		 VARCHAR(256)  					COMMENT '网元ip',
    APPROVAL_TAG 	 BOOLEAN  						COMMENT '审批标签',
    CREATE_TIME 	 TIMESTAMP  					COMMENT '创建时间',
    TASK_ID 		 VARCHAR(256)  					COMMENT '任务Id',
    CONSTRAINT T_ENGINEERING_COMMISSIONING_NES_PRIMARY PRIMARY KEY (ID)
    );
COMMENT ON TABLE T_ENGINEERING_COMMISSIONING_NES IS '调测组内网元';

DROP TABLE IF EXISTS t_stm_info;
CREATE TABLE IF NOT EXISTS t_stm_info (
    id                         INTEGER  NOT NULL AUTO_INCREMENT 	  COMMENT 'id',
    stm_info            	   TEXT			                          COMMENT '认证信息',
    create_time                TIMESTAMP                              COMMENT '创建时间',
    CONSTRAINT t_stm_info PRIMARY KEY (id)
    );
COMMENT ON TABLE t_stm_info IS '认证信息';

DROP TABLE IF EXISTS t_operation_record;
CREATE TABLE IF NOT EXISTS t_operation_record (
    id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
    guid	                   VARCHAR(64)                      COMMENT 'guid',
    inteface                   VARCHAR(64)                      COMMENT '接口名称',
    trigger_source             VARCHAR(64)                      COMMENT '默认NetCare',
    close_type                 VARCHAR(64)                      COMMENT 'complete：完成；cancel：取消',
    moudle					   VARCHAR(64)                      COMMENT '模块：初始化|高危|数通|工单',
    operate_time               TIMESTAMP                        COMMENT '操作时间',
    operator                   VARCHAR(64)                      COMMENT '操作人',
    CONSTRAINT t_operation_record PRIMARY KEY (id)
    );
COMMENT ON TABLE t_operation_record IS 'inside操作记录表';

insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4003,'行业咨询与应用集成','Industry Consulting & Application Integration','101764',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4004,'无线','Wireless','100001',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4005,'ICT服务与软件','ICT Services & Software','100005',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4006,'数字能源','Digital Power','100010',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4007,'云核心网','Cloud Core Network','100011',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4008,'数据存储','Data Storage','101775',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4009,'IRB直管团队','IRB Directly managed Team','104237',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4010,'华为云计算','Huawei Cloud Computing','121085',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4011,'计算','Computing','133277',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4012,'OPMT','OPMT','133341',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4013,'光','Optical Business','134557',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4014,'数据通信','Data Communication','137565',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4016,'机器视觉','Intelligent Vision','153930',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4017,'其他','other','999999999',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4018,'数据中心能源及关键供电','Data Center Facility & Critical Power','164174',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4019,'智能电动','mPower','164176',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4020,'智能光伏','Smart PV','164178',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4021,'数字能源TMT','Digital Power TMT','102115',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4022,'能源公共-New','Energy Common Field-New','135613',NULL,1);
insert INTO T_SYS_PRODUCT_LINE (PRODUCT_LINE_ID,PRODUCT_LINE_NAME_CN,PRODUCT_LINE_NAME_EN,PRODUCT_LINE_CODE,DESCRIPTION,IS_DEFAULT) VALUES (
4023,'DGHW综合业务','DGHW Integrated Business','152125',NULL,1);

insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3001','中国','China',NULL,'022471','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3002','北京','Beijing','region','110000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3003','北京市','Beijing','office','110100','3002','3001','20','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3004','天津','Tianjin','region','120000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3005','天津市','Tianjin','office','120100','3004','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3006','河北','Hebei','region','130000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3007','石家庄','Shijiazhuang','office','130100','3006','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3008','唐山','Tangshan','office','130200','3006','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3009','秦皇岛','Qinhuangdao','office','130300','3006','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3010','邯郸','Handan','office','130400','3006','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3011','邢台','Xingtai','office','130500','3006','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3012','保定','Baoding','office','130600','3006','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3013','张家口','Zhangjiakou','office','130700','3006','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3014','承德','Chengde','office','130800','3006','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3015','沧州','Cangzhou','office','130900','3006','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3016','廊坊','Langfang','office','131000','3006','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3017','衡水','Hengshui','office','131100','3006','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3018','山西','Shanxi','region','140000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3019','太原','Taiyuan','office','140100','3018','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3020','大同','Datong','office','140200','3018','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3021','阳泉','Yangquan','office','140300','3018','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3022','长治','Changzhi','office','140400','3018','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3023','晋城','Jincheng','office','140500','3018','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3024','朔州','Shuozhou','office','140600','3018','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3025','晋中','Jinzhong','office','140700','3018','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3026','运城','Yuncheng','office','140800','3018','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3027','忻州','Xinzhou','office','140900','3018','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3028','临汾','Linfen','office','141000','3018','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3029','吕梁','Lvliang','office','141100','3018','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3030','内蒙古','Nei Mongol','region','150000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3031','呼和浩特','Hohhot','office','150100','3030','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3032','包头','Baotou','office','150200','3030','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3033','乌海','Wuhai','office','150300','3030','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3034','赤峰','Chifeng','office','150400','3030','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3035','通辽','Tongliao','office','150500','3030','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3036','鄂尔多斯','Ordos','office','150600','3030','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3037','呼伦贝尔','Hulun Buir','office','150700','3030','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3038','巴彦淖尔','Bayannur','office','150800','3030','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3039','乌兰察布','Ulanqab','office','150900','3030','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3040','兴安盟','Hinggan Meng','office','152200','3030','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3041','锡林郭勒盟','Xilin Gol Meng','office','152500','3030','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3042','阿拉善盟','Alxa Meng','office','152900','3030','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3043','辽宁','Liaoning','region','210000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3044','沈阳','Shenyang','office','210100','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3045','大连','Dalian','office','210200','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3046','鞍山','Anshan','office','210300','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3047','抚顺','Fushun','office','210400','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3048','本溪','Benxi','office','210500','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3049','丹东','Dandong','office','210600','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3050','锦州','Jinzhou','office','210700','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3051','营口','Yingkou','office','210800','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3052','阜新','Fuxin','office','210900','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3053','辽阳','Liaoyang','office','211000','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3054','盘锦','Panjin','office','211100','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3055','铁岭','Tieling','office','211200','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3056','朝阳','Chaoyang','office','211300','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3057','葫芦岛','Huludao','office','211400','3043','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3058','吉林','Jilin','region','220000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3059','长春','Changchun','office','220100','3058','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3060','吉林','Jilin','office','220200','3058','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3061','四平','Siping','office','220300','3058','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3062','辽源','Liaoyuan','office','220400','3058','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3063','通化','Tonghua','office','220500','3058','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3064','白山','Baishan','office','220600','3058','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3065','松原','Songyuan','office','220700','3058','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3066','白城','Baicheng','office','220800','3058','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3067','延边','Yanbian','office','222400','3058','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3068','黑龙江','Heilongjiang','region','230000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3069','哈尔滨','Harbin','office','230100','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3070','齐齐哈尔','Qiqihar','office','230200','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3071','鸡西','Jixi','office','230300','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3072','鹤岗','Hegang','office','230400','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3073','双鸭山','Shuangyashan','office','230500','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3074','大庆','Daqing','office','230600','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3075','伊春','Yichun','office','230700','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3076','佳木斯','Jiamusi','office','230800','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3077','七台河','Qitaihe','office','230900','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3078','牡丹江','Mudanjiang','office','231000','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3079','黑河','Heihe','office','231100','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3080','绥化','Suihua','office','231200','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3081','大兴安岭','Daxinganling','office','232700','3068','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3082','上海','Shanghai','region','310000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3083','上海市','Shanghai','office','310100','3082','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3084','江苏','Jiangsu','region','320000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3085','南京','Nanjing','office','320100','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3086','无锡','Wuxi','office','320200','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3087','徐州','Xuzhou','office','320300','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3088','常州','Changzhou','office','320400','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3089','苏州','Suzhou','office','320500','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3090','南通','Nantong','office','320600','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3091','连云港','Lianyungang','office','320700','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3092','淮安','Huai an','office','320800','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3093','盐城','Yancheng','office','320900','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3094','扬州','Yangzhou','office','321000','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3095','镇江','Zhenjiang','office','321100','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3096','泰州','Taizhou','office','321200','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3097','宿迁','Suqian','office','321300','3084','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3098','浙江','Zhejiang','region','330000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3099','杭州','Hangzhou','office','330100','3098','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3100','宁波','Ningbo','office','330200','3098','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3101','温州','Wenzhou','office','330300','3098','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3102','嘉兴','Jiaxing','office','330400','3098','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3103','湖州','Huzhou','office','330500','3098','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3104','绍兴','Shaoxing','office','330600','3098','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3105','金华','Jinhua','office','330700','3098','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3106','衢州','Quzhou','office','330800','3098','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3107','舟山','Zhoushan','office','330900','3098','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3108','台州','Taizhou','office','331000','3098','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3109','丽水','Lishui','office','331100','3098','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3110','安徽','Anhui','region','340000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3111','合肥','Hefei','office','340100','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3112','芜湖','Wuhu','office','340200','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3113','蚌埠','Bengbu','office','340300','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3114','淮南','Huainan','office','340400','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3115','马鞍山','Ma anshan','office','340500','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3116','淮北','Huaibei','office','340600','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3117','铜陵','Tongling','office','340700','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3118','安庆','Anqing','office','340800','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3119','黄山','Huangshan','office','341000','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3120','滁州','Chuzhou','office','341100','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3121','阜阳','Fuyang','office','341200','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3122','宿州','Suzhou','office','341300','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3123','巢湖','Chaohu','office','341400','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3124','六安','Lu an','office','341500','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3125','亳州','Bozhou','office','341600','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3126','池州','Chizhou','office','341700','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3127','宣城','Xuancheng','office','341800','3110','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3128','福建','Fujian','region','350000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3129','福州','Fuzhou','office','350100','3128','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3130','厦门','Xiamen','office','350200','3128','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3131','莆田','Putian','office','350300','3128','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3132','三明','Sanming','office','350400','3128','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3133','泉州','Quanzhou','office','350500','3128','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3134','漳州','Zhangzhou','office','350600','3128','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3135','南平','Nanping','office','350700','3128','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3136','龙岩','Longyan','office','350800','3128','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3137','宁德','Ningde','office','350900','3128','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3138','江西','Jiangxi','region','360000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3139','南昌','Nanchang','office','360100','3138','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3140','景德镇','Jingdezhen','office','360200','3138','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3141','萍乡','Pingxiang','office','360300','3138','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3142','九江','Jiujiang','office','360400','3138','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3143','新余','Xinyu','office','360500','3138','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3144','鹰潭','Yingtan','office','360600','3138','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3145','赣州','Ganzhou','office','360700','3138','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3146','吉安','Ji an','office','360800','3138','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3147','宜春','Yichun','office','360900','3138','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3148','抚州','Fuzhou','office','361000','3138','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3149','上饶','Shangrao','office','361100','3138','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3150','山东','Shandong','region','370000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3151','济南','Jinan','office','370100','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3152','青岛','Qingdao','office','370200','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3153','淄博','Zibo','office','370300','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3154','枣庄','Zaozhuang','office','370400','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3155','东营','Dongying','office','370500','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3156','烟台','Yantai','office','370600','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3157','潍坊','Weifang','office','370700','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3158','济宁','Jining','office','370800','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3159','泰安','Tai an','office','370900','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3160','威海','Weihai','office','371000','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3161','日照','Rizhao','office','371100','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3162','莱芜','Laiwu','office','371200','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3163','临沂','Linyi','office','371300','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3164','德州','Dezhou','office','371400','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3165','聊城','Liaocheng','office','371500','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3166','滨州','Binzhou','office','371600','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3167','菏泽','Heze','office','371700','3150','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3168','河南','Henan','region','410000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3169','郑州','Zhengzhou','office','410100','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3170','开封','Kaifeng','office','410200','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3171','洛阳','Luoyang','office','410300','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3172','平顶山','Pingdingshan','office','410400','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3173','安阳','Anyang','office','410500','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3174','鹤壁','Hebi','office','410600','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3175','新乡','Xinxiang','office','410700','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3176','焦作','Jiaozuo','office','410800','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3177','济源','Jiyuan','office','410881','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3178','濮阳','Puyang','office','410900','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3179','许昌','Xuchang','office','411000','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3180','漯河','Luohe','office','411100','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3181','三门峡','Sanmenxia','office','411200','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3182','南阳','Nanyang','office','411300','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3183','商丘','Shangqiu','office','411400','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3184','信阳','Xinyang','office','411500','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3185','周口','Zhoukou','office','411600','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3186','驻马店','Zhumadian','office','411700','3168','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3187','湖北','Hubei','region','420000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3188','武汉','Wuhan','office','420100','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3189','黄石','Huangshi','office','420200','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3190','十堰','Shiyan','office','420300','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3191','宜昌','Yichang','office','420500','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3192','襄樊','Xiangfan','office','420600','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3193','鄂州','Ezhou','office','420700','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3194','荆门','Jingmen','office','420800','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3195','孝感','Xiaogan','office','420900','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3196','荆州','Jingzhou','office','421000','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3197','黄冈','Huanggang','office','421100','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3198','咸宁','Xianning','office','421200','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3199','随州','Suizhou','office','421300','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3200','恩施','Enshi','office','422800','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3201','仙桃','Xiantao','office','429004','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3202','潜江','Qianjiang','office','429005','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3203','天门','Tianmen','office','429006','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3204','神农架林区','Shennongjia','office','429021','3187','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3205','湖南','Hunan','region','430000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3206','长沙','Changsha','office','430100','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3207','株洲','Zhuzhou','office','430200','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3208','湘潭','Xiangtan','office','430300','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3209','衡阳','Hengyang','office','430400','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3210','邵阳','Shaoyang','office','430500','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3211','岳阳','Yueyang','office','430600','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3212','常德','Changde','office','430700','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3213','张家界','Zhangjiajie','office','430800','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3214','益阳','Yiyang','office','430900','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3215','郴州','Chenzhou','office','431000','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3216','永州','Yongzhou','office','431100','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3217','怀化','Huaihua','office','431200','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3218','娄底','Loudi','office','431300','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3219','湘西','Xiangxi','office','433100','3205','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3220','广东','Guangdong','region','440000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3221','广州','Guangzhou','office','440100','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3222','韶关','Shaoguan','office','440200','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3223','深圳','Shenzhen','office','440300','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3224','珠海','Zhuhai','office','440400','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3225','汕头','Shantou','office','440500','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3226','佛山','Foshan','office','440600','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3227','江门','Jiangmen','office','440700','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3228','湛江','Zhanjiang','office','440800','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3229','茂名','Maoming','office','440900','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3230','肇庆','Zhaoqing','office','441200','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3231','惠州','Huizhou','office','441300','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3232','梅州','Meizhou','office','441400','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3233','汕尾','Shanwei','office','441500','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3234','河源','Heyuan','office','441600','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3235','阳江','Yangjiang','office','441700','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3236','清远','Qingyuan','office','441800','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3237','东莞','Dongguan','office','441900','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3238','中山','Zhongshan','office','442000','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3239','潮州','Chaozhou','office','445100','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3240','揭阳','Jieyang','office','445200','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3241','云浮','Yunfu','office','445300','3220','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3242','广西','Guangxi','region','450000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3243','南宁','Nanning','office','450100','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3244','柳州','Liuzhou','office','450200','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3245','桂林','Guilin','office','450300','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3246','梧州','Wuzhou','office','450400','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3247','北海','Beihai','office','450500','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3248','防城港','Fangchenggang','office','450600','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3249','钦州','Qinzhou','office','450700','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3250','贵港','Guigang','office','450800','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3251','玉林','Yulin','office','450900','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3252','百色','Baise','office','451000','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3253','贺州','Hezhou','office','451100','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3254','河池','Hechi','office','451200','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3255','来宾','Laibin','office','451300','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3256','崇左','Chongzuo','office','451400','3242','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3257','海南','Hainan','region','460000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3258','海口','Haikou','office','460100','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3259','三亚','Sanya','office','460200','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3260','五指山','Wuzhishan','office','469001','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3261','琼海','Qionghai','office','469002','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3262','儋州','Danzhou','office','469003','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3263','文昌','Wenchang','office','469005','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3264','万宁','Wanning','office','469006','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3265','东方','Dongfang','office','469007','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3266','定安','Dingan','office','469025','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3267','屯昌','Tunchang','office','469026','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3268','澄迈','Chengmai','office','469027','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3269','临高','Lingao','office','469028','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3270','白沙','Baisha','office','469030','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3271','昌江','Changjiang','office','469031','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3272','乐东','Ledong','office','469033','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3273','陵水','Lingshui','office','469034','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3274','保亭','Baoting','office','469035','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3275','琼中','Qiongzhong','office','469036','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3276','西沙','Xisha','office','469037','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3277','南沙','Nansha','office','469038','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3278','中沙','Zhongsha','office','469039','3257','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3279','重庆','Chongqing','region','500000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3280','重庆市','Chongqing','office','500100','3279','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3281','四川','Sichuan','region','510000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3282','成都','Chengdu','office','510100','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3283','自贡','Zigong','office','510300','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3284','攀枝花','Panzhihua','office','510400','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3285','泸州','Luzhou','office','510500','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3286','德阳','Deyang','office','510600','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3287','绵阳','Mianyang','office','510700','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3288','广元','Guangyuan','office','510800','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3289','遂宁','Suining','office','510900','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3290','内江','Neijiang','office','511000','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3291','乐山','Leshan','office','511100','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3292','南充','Nanchong','office','511300','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3293','眉山','Meishan','office','511400','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3294','宜宾','Yibin','office','511500','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3295','广安','Guang an','office','511600','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3296','达州','Dazhou','office','511700','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3297','雅安','Ya an','office','511800','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3298','巴中','Bazhong','office','511900','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3299','资阳','Ziyang','office','512000','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3300','阿坝','Aba','office','513200','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3301','甘孜','Ganzi','office','513300','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3302','凉山','Liangshan','office','513400','3281','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3303','贵州','Guizhou','region','520000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3304','贵阳','Guiyang','office','520100','3303','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3305','六盘水','Liupanshui','office','520200','3303','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3306','遵义','Zunyi','office','520300','3303','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3307','安顺','Anshun','office','520400','3303','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3308','铜仁','Tongren','office','522200','3303','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3309','黔西','Qianxi','office','522300','3303','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3310','毕节','Bijie','office','522400','3303','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3311','黔东','Qiandong','office','522600','3303','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3312','黔南','Qiannan','office','522700','3303','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3313','云南','Yunnan','region','530000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3314','昆明','Kunming','office','530100','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3315','曲靖','Qujing','office','530300','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3316','玉溪','Yuxi','office','530400','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3317','保山','Baoshan','office','530500','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3318','昭通','Zhaotong','office','530600','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3319','丽江','Lijiang','office','530700','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3320','思茅','Simao','office','530800','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3321','临沧','Lincang','office','530900','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3322','楚雄','Chuxiong','office','532300','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3323','红河','Honghe','office','532500','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3324','文山','Wenshan','office','532600','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3325','西双版纳','Xishuangbanna','office','532800','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3326','大理','DAli','office','532900','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3327','德宏','Dehong','office','533100','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3328','怒江','Nujiang','office','533300','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3329','迪庆','Diqing','office','533400','3313','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3330','西藏','Tibet','region','540000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3331','拉萨','Lhasa','office','540100','3330','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3332','昌都','Qamdo','office','542100','3330','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3333','山南','Shannan','office','542200','3330','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3334','日喀则','Xigaze','office','542300','3330','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3335','那曲','Nagqu Diqu','office','542400','3330','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3336','阿里','ALi','office','542500','3330','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3337','林芝','Nyingchi','office','542600','3330','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3338','中国地区部','China Region','region','027425','3001','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3339','上海代表处','Shanghai Rep Office, CN','office','028174','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3340','北京代表处','Beijing Rep Office, CN','office','027848','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3341','天津代表处','Tianjin Rep Office, CN','office','027862','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3342','中国地区部','China Region','office','027425','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3343','重庆代表处','Chongqing Rep Office, CN','office','028117','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3344','湖南代表处','Hunan Rep Office, CN','office','028059','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3345','福建代表处','Fujian Rep Office, CN','office','028045','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3346','广东代表处','Guangdong Rep Office, CN','office','028073','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3347','湖北代表处','Hubei Rep Office, CN','office','028031','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3348','四川代表处','Sichuan Rep Office, CN','office','028088','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3349','云南代表处','Yunnan Rep Office, CN','office','028131','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3350','贵州代表处','Guizhou Rep Office, CN','office','028103','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3351','广西代表处','Guangxi Rep Office, CN','office','028145','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3353','青海代表处','Qinghai Rep Office, CN','office','042818','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3355','内蒙古代表处','Inner Mongolia Rep Office, CN','office','027904','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3356','河北代表处','Hebei Rep Office, CN','office','027890','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3357','山西代表处','Shanxi Rep Office, CN','office','027876','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3358','辽宁代表处','Liaoning Rep Office, CN','office','027947','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3359','吉林代表处','Jilin Rep Office, CN','office','027918','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3360','黑龙江代表处','Heilongjiang Rep Office, CN','office','027961','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3361','陕西代表处','Shaanxi Rep Office, CN','office','028003','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3362','山东代表处','Shandong Rep Office, CN','office','027932','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3363','新疆代表处','Xinjiang Rep Office, CN','office','027975','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3364','甘肃代表处','Gansu Rep Office, CN','office','028017','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3365','河南代表处','Henan Rep Office, CN','office','027989','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3366','江苏代表处','Jiangsu Rep Office, CN','office','028159','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3367','安徽代表处','Anhui Rep Office, CN','office','028217','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3368','浙江代表处','Zhejiang Rep Office, CN','office','028188','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3369','江西代表处','Jiangxi Rep Office, CN','office','028203','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3370','测试代表处','Test Customer','office','027847','3338','3001','0','1',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3371','陕西','Shaanxi','region','610000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3372','西安','Xi an','office','610100','3371','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3373','铜川','Tongchuan','office','610200','3371','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3374','宝鸡','Baoji','office','610300','3371','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3375','咸阳','Xianyang','office','610400','3371','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3376','渭南','Weinan','office','610500','3371','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3377','延安','Yan an','office','610600','3371','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3378','汉中','Hanzhong','office','610700','3371','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3379','榆林','Yulin','office','610800','3371','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3380','安康','Ankang','office','610900','3371','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3381','商洛','Shangluo','office','611000','3371','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3382','甘肃','Gansu','region','620000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3383','兰州','Lanzhou','office','620100','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3384','嘉峪关','Jiayuguan','office','620200','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3385','金昌','Jinchang','office','620300','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3386','白银','Baiyin','office','620400','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3387','天水','Tianshui','office','620500','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3388','武威','Wuwei','office','620600','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3389','张掖','Zhangye','office','620700','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3390','平凉','Pingliang','office','620800','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3391','酒泉','Jiuquan','office','620900','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3392','庆阳','Qingyang','office','621000','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3393','定西','Dingxi','office','621100','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3394','陇南','Longnan','office','621200','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3395','临夏','Linxia','office','622900','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3396','甘南','Gannan','office','623000','3382','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3397','青海','Qinghai','region','630000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3398','西宁','Xining','office','630100','3397','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3399','海东','Haidong','office','632100','3397','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3400','海北','Haibei','office','632200','3397','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3401','黄南','Huangnan','office','632300','3397','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3402','海南','Hainan','office','632500','3397','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3403','果洛','Guoluo','office','632600','3397','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3404','玉树','Yushu','office','632700','3397','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3405','海西','Haixi','office','632800','3397','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3406','宁夏','Ningxia','region','640000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3407','银川','Yinchuan','office','640100','3406','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3408','石嘴山','Shizuishan','office','640200','3406','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3409','吴忠','Wuzhong','office','640300','3406','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3410','固原','Guyuan','office','640400','3406','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3411','中卫','Zhongwei','office','640500','3406','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3412','新疆','Xinjiang','region','650000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3413','乌鲁木齐','Urumqi','office','650100','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3414','克拉玛依','Karamay','office','650200','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3415','吐鲁番','Turpan','office','652100','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3416','哈密','Hami(Kumul)','office','652200','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3417','昌吉','Changji','office','652300','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3418','博尔塔拉','Boertali','office','652700','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3419','巴音郭楞','Bayinguoleng','office','652800','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3420','阿克苏','Akesu','office','652900','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3421','克孜勒苏柯尔克孜','Kizilsu Kirgiz','office','653000','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3422','喀什','Kashen','office','653100','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3423','和田','HeTian','office','653200','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3424','伊犁','Yili','office','654000','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3425','塔城','Tacheng','office','654200','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3426','阿勒泰','Aletai','office','654300','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3427','石河子','Shihezi','office','659001','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3428','阿拉尔','Ala er','office','659002','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3429','图木舒克','Tumushuke','office','659003','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3430','五家渠','Wujiaqu','office','659004','3412','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3431','台湾','Taiwan','region','710000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3432','台北','Taipei','office','710100','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3433','高雄','Kaohsiung','office','710200','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3434','台南','Tainan','office','710300','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3435','台中','Taichung','office','710400','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3436','金门(县)','Jinmen','office','710500','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3437','南投(县)','Nantou','office','710600','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3438','基隆','Keelung','office','710700','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3439','新竹','Hsinchu','office','710800','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3440','嘉义','Chiayi','office','710900','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3441','台北(县)','Taibei','office','711100','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3442','宜兰(县)','Yilan','office','711200','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3443','新竹(县)','Xinzhu','office','711300','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3444','桃园(县)','Taoyuan','office','711400','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3445','苗栗(县)','Miaoli','office','711500','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3446','台中(县)','Taizhong','office','711600','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3447','彰化(县)','Zhanghua','office','711700','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3448','嘉义(县)','Jiayi','office','711900','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3449','云林(县)','Yunlin','office','712100','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3450','台南(县)','Tainan','office','712200','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3451','高雄(县)','Gaoxiong','office','712300','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3452','屏东(县)','Pingdong','office','712400','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3453','台东(县)','Taidong','office','712500','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3454','花莲(县)','Hualian','office','712600','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3455','澎湖(县)','Penghu','office','712700','3431','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3456','香港','Hong Kong','region','810000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3457','香港岛','Hong Kong Island','office','810100','3456','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3458','九龙','Kowloon','office','810200','3456','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3459','新界','New Territories','office','810300','3456','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3460','澳门','Macao','region','820000','3001','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3461','澳门','Macao','office','820100','3460','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3462','离岛','outlying islands','office','820200','3460','3001','0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3463','common','common','office','common','3338','3001','0','1',NULL);

-- 数通并网策略
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('datacomNetworkTiedPolicy', 'NoIntercept','No Intercept','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('datacomNetworkTiedPolicy', 'NoIntercept','不拦截','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('datacomNetworkTiedPolicy', 'HintOnly','Hint only','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('datacomNetworkTiedPolicy', 'HintOnly','仅提示','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('datacomNetworkTiedPolicy', 'ScanPass','Interception Scanning Bypass','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('datacomNetworkTiedPolicy', 'ScanPass','拦截扫码放通','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('datacomNetworkTiedPolicy', 'ApprovalPass','Intercept Approval Bypass','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('datacomNetworkTiedPolicy', 'ApprovalPass','拦截审批放通','zh-CN','system',now());

-- 任务策略
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('interceptPolicy', 'nointercept','Non-intercept','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('interceptPolicy', 'nointercept','不拦截','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('interceptPolicy', 'blocklist','Blocklist Interception','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('interceptPolicy', 'blocklist','黑名单拦截','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('interceptPolicy', 'trustlist','Trustlist Blocking','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('interceptPolicy', 'trustlist','白名单拦截','zh-CN','system',now());


-- 任务状态
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskStatus', '1','Ready','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskStatus', '1','待办','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskStatus', '2','Ongoing','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskStatus', '2','进行中','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskStatus', '3','Completed','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskStatus', '3','已完成','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskStatus', '4','Canceled','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskStatus', '4','已取消','zh-CN','system',now());


-- 任务类型
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskType', 'Query','Network Query','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskType', 'Query','网络查询','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskType', 'microNetworkChange','Routine Operation','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskType', 'microNetworkChange','日常动网','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskType', 'Project','Engineering Commissioning','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskType', 'Project','工程调测','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskType', 'networkChange','Network Change','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskType', 'networkChange','变更操作','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskType', 'Emergency','Emergency Channel','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('taskType', 'Emergency','应急通道','zh-CN','system',now());

-- 是否公共终端运维
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('isPublicOmTerminal', 'true','Yes','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('isPublicOmTerminal', 'true','是','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('isPublicOmTerminal', 'false','No','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('isPublicOmTerminal', 'false','否','zh-CN','system',now());

-- 风险级别
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('riskLevel', '0','Low','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('riskLevel', '0','低风险','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('riskLevel', '1','Medium','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('riskLevel', '1','中风险','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('riskLevel', '2','High','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('riskLevel', '2','高风险','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '1','Blocklist - Intercept low risks and above','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '1','黑名单-低风险及以上拦截','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '2','Blocklist - Intercept medium risks and above','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '2','黑名单-中风险及以上拦截','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '3','Blocklist - Intercept high risks','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '3','黑名单-高风险拦截','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '4','Trustlist - Not intercept high risks and below','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '4','白名单-高风险及以下放通','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '5','Trustlist - Not intercept medium risks and below','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '5','白名单-中风险及以下放通','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '6','Trustlist - Not intercept low risks','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '6','白名单-低风险放通','zh-CN','system',now());

insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '7','Not intercept','en-US','system',now());
insert into T_SYS_DICT_DATA
(dict_type, dict_code, dict_value, dict_lang, creator, create_time)
values
    ('insidePolicy', '7','不拦截','zh-CN','system',now());

-- 海外地区部、代表处公共数据
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3464','全屋智能产品线','Smart Space Product Line','region','049503',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3465','智选车业务发展部','Smart Selection Auto Business Development Dept','region','069422',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3466','A类区域管理部','Category-A Region Mgmt Dept','region','072133',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3467','OpenHarmony部','OpenHarmony Dept','region','068882',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3468','HarmonyOS部','HarmonyOS Dept','region','068881',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3469','OpenHarmony使能部','OpenHarmony Usage Dept','region','068883',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3470','电商产品部','E-commerce Product Dept','region','041069',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3471','华为品牌销售运营部','Huawei Brand Sales Operation Dept','region','041068',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3472','终端云服务小艺产品部','Consumer Cloud Service Celia Product Dept','region','067420',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3473','海外商城','Overseas E-Mall','region','041071',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3474','电商用户沟通与服务部','E-commerce User Communication and Service Dept','region','041070',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3475','终端云服务海外一部','Consumer Cloud Service International Dept 1','region','050147',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3476','终端云服务海外二部','Consumer Cloud Service International Dept 2','region','050148',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3477','亚太地区部','Asia Pacific Region','region','050133',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3478','欧洲地区部','European Region','region','071217',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3479','B类区域管理部总裁','Category-B Region Mgmt Dept President','region','049682',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3480','终端BG模组销售','Consumer BG Module Sales','region','071344',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3481','车载&模块','Telematics','region','049340',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3482','终端云服务生态发展部','Consumer Cloud Service Ecosystem Development Dept','region','068851',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3483','终端云服务浏览器与云空间BU','Consumer Cloud Service Browser & Mobile Cloud BU','region','068800',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3484','终端云服务广告BU','Consumer Cloud Service Advertising BU','region','068802',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3485','终端云服务云安全与隐私工程部','Consumer Cloud Service Cloud Security & Privacy Engineering Dept','region','041046',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3486','终端云服务搜索与地图BU','Consumer Cloud Service Search & Maps BU','region','068801',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3487','终端云服务应用生态BU','Consumer Cloud Service Application Ecosystem BU','region','068799',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3488','终端云服务商业销售部','Consumer Cloud Service Commercial Sales Dept','region','046875',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3489','终端云服务服务生态与支付BU','Consumer Cloud Service Service Ecosystem & Payment BU','region','068803',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3490','终端云服务互动媒体BU','Consumer Cloud Service Interactive Media BU','region','068798',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3491','北部非洲地区部','Northern Africa Region','region','026902',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3492','中东中亚地区部','Middle East & Central Asia Region','region','026699',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3493','拉美地区部','Latin America Region','region','040593',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3494','南部非洲地区部','Southern Africa Region','region','025899',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3495','智慧出行解决方案部','Smart Travel Solution Dept','region','069994',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3496','智能穿戴与运动健康产品线','Smart Wearable and Health Product Line','region','041049',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3497','电商营销部','E-Commerce Marketing Dept','region','067520',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3498','终端BG采购认证部','Consumer BG Procurement Qualification Dept','region','024666',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3499','智选车解决方案部','Smart Selection Auto Solutions Dept','region','071751',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3500','电商行业运营部','E-Commerce Industry Operation Dept','region','067522',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3501','终端云服务全场景云服务解决方案部','Consumer Cloud Service All-Scenario Cloud Service Solution Dept','region','049700',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3502','TX','TX','region','042528',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3503','欧洲终端业务部','European Device Business Dept','region','070613',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3504','终端BG渠道部','Consumer BG Channel Dept','region','069644',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3505','欧亚终端业务部','Eurasia Device Business Dept','region','024574',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3506','中东非洲终端业务部','Middle East & Africa Device Business Dept','region','042402',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3507','智选车业务发展部','Smart Selection Auto Business Development Dept','office','069422',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3508','西班牙代表处','Spain Rep Office','office','047897',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3509','台湾办事处','Taiwan Office','office','026358',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3510','HarmonyOS部','HarmonyOS Dept','office','068881',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3511','OpenHarmony使能部','OpenHarmony Usage Dept','office','068883',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3512','OpenHarmony部','OpenHarmony Dept','office','068882',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3513','华为品牌销售运营部','Huawei Brand Sales Operation Dept','office','041068',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3514','电商产品部','E-commerce Product Dept','office','041069',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3515','终端云服务小艺产品部','Consumer Cloud Service Celia Product Dept','office','067420',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3516','海外商城','Overseas E-Mall','office','041071',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3517','电商用户沟通与服务部','E-commerce User Communication and Service Dept','office','041070',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3518','终端云服务海外一部','Consumer Cloud Service International Dept 1','office','050147',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3519','终端云服务海外二部','Consumer Cloud Service International Dept 2','office','050148',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3520','东南亚试点代表处','Southern-East Asia Trial Rep Office','office','900000',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3521','南太试点代表处','Southern Pacific Trial Rep Office','office','800000',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3522','拉美试点代表处','Latin America Trial Rep Office','office','700000',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3523','中东试点代表处','Middle East Trial Rep Office','office','600000',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3524','西欧试点代表处','West European Trial Rep Office','office','500000',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3525','欧亚试点代表处','Eurasia Trial Rep Office','office','400000',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3526','东北欧试点代表处','CEE&Nordic European Trial Rep Office','office','300000',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3527','北非试点代表处','Northern Africa Trial Rep Office','office','200000',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3528','南非试点代表处','Southern Africa Trial Rep Office','office','100000',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3529','B类区域管理部总裁','Category-B Region Mgmt Dept President','office','049682',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3530','北欧代表处','Nordic Rep Office','office','050101',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3531','终端BG模组销售','Consumer BG Module Sales','office','071344',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3532','A6办事处','A6 Office','office','025718',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3533','A7办事处','A7 Office','office','045222',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3534','阿塞拜疆终端办事处','Azerbaijan Device Office','office','070175',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3535','乌兹别克斯坦终端办事处','Uzbekistan Device Office','office','070174',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3536','车载&模块','Telematics','office','049340',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3537','终端云服务生态发展部','Consumer Cloud Service Ecosystem Development Dept','office','068851',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3538','终端云服务广告BU','Consumer Cloud Service Advertising BU','office','068802',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3539','终端云服务浏览器与云空间BU','Consumer Cloud Service Browser & Mobile Cloud BU','office','068800',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3540','终端云服务应用生态BU','Consumer Cloud Service Application Ecosystem BU','office','068799',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3541','终端云服务互动媒体BU','Consumer Cloud Service Interactive Media BU','office','068798',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3542','终端云服务云安全与隐私工程部','Consumer Cloud Service Cloud Security & Privacy Engineering Dept','office','041046',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3543','终端云服务服务生态与支付BU','Consumer Cloud Service Service Ecosystem & Payment BU','office','068803',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3544','终端云服务商业销售部','Consumer Cloud Service Commercial Sales Dept','office','046875',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3545','终端云服务搜索与地图BU','Consumer Cloud Service Search & Maps BU','office','068801',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3546','大中华终端服务部','Greater China Device Service Dept','office','024241',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3547','大中华终端业务部','Greater China Device Business Dept','office','024207',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3548','北京终端业务部','Beijing Device Business Dept','office','024231',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3549','黑龙江终端业务部','Heilongjiang Device Business Dept','office','024239',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3550','福建终端业务部','Fujian Device Business Dept','office','024256',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3551','海南终端业务部','Hainan Device Business Dept','office','041589',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3552','广西终端业务部','Guangxi Device Business Dept','office','024211',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3553','宁夏终端业务部','Ningxia Device Business Dept','office','041590',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3554','青海终端业务部','Qinghai Device Business Dept','office','041591',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3555','河北终端业务部','Hebei Device Business Dept','office','024234',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3556','河南终端业务部','Henan Device Business Dept','office','024235',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3557','江西终端业务部','Jiangxi Device Business Dept','office','024253',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3558','内蒙古终端业务部','Inner Mongolia Device Business Dept','office','024236',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3559','山东终端业务部','Shandong Device Business Dept','office','024237',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3560','辽宁终端业务部','Liaoning Device Business Dept','office','024238',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3561','山西终端业务部','Shanxi Device Business Dept','office','024233',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3562','上海终端业务部','Shanghai Device Business Dept','office','024251',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3563','重庆终端业务部','Chongqing Device Business Dept','office','024213',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3564','北欧终端业务部','Nordic Device Business Dept','office','037941',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3565','中东中亚多国管理部','Middle East & Central Asia Multi-country Mgmt Dept','office','047197',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3566','哈萨克代表处','Kazakhstan Rep Office','office','026467',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3567','白俄罗斯办事处','Belarus Office','office','026679',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3568','乌兹别克代表处','Uzbekistan Rep Office','office','026393',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3569','巴西终端业务部','Brazil Device Business Dept','office','046937',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3570','喀麦隆代表处','Cameroon Rep Office','office','025813',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3571','塞内加尔代表处','Senegal Rep Office','office','027118',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3573','海湾北代表处','Gulf North Rep Office','office','046593',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3574','大中华终端电商部','Greater China Device E-commerce Dept','office','045544',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3575','北非多国终端业务部','Northern Africa Multi-country Device Business Dept','office','045258',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3576','新西兰办事处','New Zealand Office','office','037924',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3577','地中海南代表处','Mediterranean South Rep Office','office','038261',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3578','东南亚多国终端业务部','Southern-East Asia Multinational Countries Device Business Dept','office','045270',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3579','埃及代表处','Egypt Rep Office','office','026921',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3580','菲律宾终端业务部','Philippines Device Business Dept','office','024449',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3581','波兰终端业务部','Poland Device Business Dept','office','024493',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3582','吉林终端业务部','Jilin Device Business Dept','office','024240',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3583','安徽终端业务部','Anhui Device Business Dept','office','024252',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3584','法国终端业务部','France Device Business Dept','office','024646',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3585','湖北终端业务部','Hubei Device Business Dept','office','024254',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3586','江苏终端业务部','Jiangsu Device Business Dept','office','024249',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3587','贵州终端业务部','Guizhou Device Business Dept','office','024214',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3588','甘肃终端业务部','Gansu Device Business Dept','office','024209',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3589','大中华终端渠道部','Greater China Device Channel Dept','office','045535',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3590','大中华终端手机GTM部','Greater China Device Handsets GTM Dept','office','034194',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3591','德国终端业务部','Germany Device Business Dept','office','024644',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3592','湖南终端业务部','Hunan Device Business Dept','office','024255',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3593','天津终端业务部','Tianjin Device Business Dept','office','024232',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3594','四川终端业务部','Sichuan Device Business Dept','office','024212',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3595','新疆终端业务部','Xinjiang Device Business Dept','office','024210',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3596','云南终端业务部','Yunnan Device Business Dept','office','024215',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3597','西藏终端业务部','Tibet Device Business Dept','office','041592',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3598','陕西终端业务部','Shaanxi Device Business Dept','office','024208',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3599','浙江终端业务部','Zhejiang Device Business Dept','office','024250',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3600','乌克兰代表处','Ukraine Rep Office','office','026660',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3601','俄罗斯代表处','Russia Rep Office','office','037370',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3602','土耳其代表处','Turkey Rep Office','office','026418',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3603','拉美多国管理部','Latin America Multi-country Mgmt Dept','office','046661',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3604','东非多国终端业务部','Eastern Africa Multi-country Device Business Dept','office','046169',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3605','法国代表处','France Rep Office','office','024989',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3606','意大利代表处','Italy Rep Office','office','024932',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3607','香港代表处','Hong Kong Rep Office','office','026356',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3608','中东多国终端业务部','Middle East Multi-country Device Business Dept','office','043597',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3609','罗马尼亚代表处','Romania Rep Office','office','025134',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3610','坦桑尼亚代表处','Tanzania Rep Office','office','037890',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3611','南非代表处','South Africa Rep Office','office','025900',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3612','南非多国管理部','Southern Africa Multi-country Mgmt Dept','office','025918',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3613','乌干达代表处','Uganda Rep Office','office','026030',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3614','墨西哥终端业务部','Mexico Device Business Dept','office','024607',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3615','印度尼西亚代表处','Indonesia Rep Office','office','026130',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3616','哥伦比亚终端业务部','Colombia Device Business Dept','office','024604',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3617','约旦代表处','Jordan Rep Office','office','045180',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3618','安哥拉代表处','Angola Rep Office','office','025938',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3619','阿联酋多国终端业务部','United Arab Emirates Multinational Device Business Dept','office','024542',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3620','阿曼代表处','Oman Rep Office','office','026719',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3621','马来西亚终端业务部','Malaysia Device Business Dept','office','024439',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3622','泰国代表处','Thailand Rep Office','office','026283',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3623','泰国终端业务部','Thailand Device Business Dept','office','024450',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3624','巴西代表处','Brazil Rep Office','office','034925',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3625','印度尼西亚终端业务部','Indonesia Device Business Dept','office','024437',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3626','菲律宾代表处','Philippines Rep Office','office','026219',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3627','土耳其终端业务部','Türkiye Device Business Dept','office','024586',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3628','东南亚多国管理部','Southeast Asia Multi-country Mgmt Dept','office','026261',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3629','新加坡代表处','Singapore Rep Office','office','026087',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3630','德国代表处','Germany Rep Office','office','024965',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3631','加纳代表处','Ghana Rep Office','office','025793',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3632','智利代表处','Chile Rep Office','office','025436',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3633','希腊代表处','Greece Rep Office','office','025346',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3634','阿根廷代表处','Argentina Rep Office','office','025457',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3635','英国终端业务部','UK Device Business Dept','office','024643',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3636','罗马尼亚终端业务部','Romania Device Business Dept','office','024497',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3637','哥伦比亚代表处','Colombia Rep Office','office','025681',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3638','澳大利亚办事处','Australia Office','office','026063',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3639','加拿大办事处','Canada Office','office','027339',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3640','广东终端业务部','Guangdong Device Business Dept','office','035628',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3641','墨西哥代表处','Mexico Rep Office','office','025613',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3642','香港终端业务部','Hong Kong Device Business Dept','office','042519',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3643','瑞士代表处','Switzerland Rep Office','office','037909',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3644','韩国代表处','Korea Rep Office','office','027167',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3645','A2代表处','A2 Rep Office','office','026700',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3646','伊拉克代表处','Iraq Rep Office','office','026876',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3647','日本代表处','Japan Rep Office','office','027161',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3648','沙特代表处','Saudi Arabia Rep Office','office','026783',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3649','摩洛哥代表处','Morocco Rep Office','office','027058',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3650','阿尔及利亚代表处','Algeria Rep Office','office','027078',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3651','阿联酋代表处','United Arab Emirates Rep Office','office','026734',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3652','波兰代表处','Poland Rep Office','office','025277',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3653','秘鲁代表处','Peru Rep Office','office','025582',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3654','巴基斯坦代表处','Pakistan Rep Office','office','026850',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3655','刚果代表处','Congo Rep Office','office','026011',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3656','马来西亚代表处','Malaysia Rep Office','office','026160',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3657','捷克代表处','Czech Rep Office','office','025232',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3658','南非终端业务部','South Africa Device Business Dept','office','024557',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3659','尼日利亚代表处','Nigeria Rep Office','office','025767',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3660','南亚代表处','South Asia Rep Office','office','026107',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3661','英国代表处','United Kingdom Rep Office','office','025072',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3662','印度代表处','India Rep Office','office','037304',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3663','沙特终端业务部','Saudi Arabia Device Business Dept','office','024537',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3664','肯尼亚代表处','Kenya Rep Office','office','025991',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3665','智慧出行解决方案部','Smart Travel Solution Dept','office','069994',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3666','智能穿戴与运动健康产品线','Smart Wearable and Health Product Line','office','041049',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3667','电商营销部','E-Commerce Marketing Dept','office','067520',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3668','南美洲多国终端业务部','South America Multi-country Device Business Dept','office','071027',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3669','终端BG采购认证部','Consumer BG Procurement Qualification Dept','office','024666',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3670','塞匈终端业务部','Serbia & Hungary Device Business Dept','office','070530',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3671','希保终端业务部','Greece & Bulgaria Device Business Dept','office','070522',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3672','大中华智选车业务部','Greater China Smart Selection Auto Business Department','office','069428',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3673','全屋智能政策与产业发展部','Smart Space Policy & Industry Development Dept','office','070630',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3674','全屋智能解决方案部','Smart Space Solution Dept','office','069471',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3675','大中华终端零售部','Greater China Device Retail Dept','office','045536',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3676','智选车解决方案部','Smart Selection Auto Solutions Dept','office','071751',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3677','电商行业运营部','E-Commerce Industry Operation Dept','office','067522',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3678','终端云服务全场景云服务解决方案部','Consumer Cloud Service All-Scenario Cloud Service Solution Dept','office','049700',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3679','深圳终端业务部','Shenzhen Device Business Dept','office','049135',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3680','BELS终端办事处','BELS Device Office','office','047763',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3681','哈萨克斯坦终端办事处','Kazakhstan Device Office','office','047762',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3682','大中华终端全屋智能业务部','Greater China Device Smart Home Business Dept','office','068669',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3683','西欧多国管理部','West European Multi-country Mgmt Dept','office','049807',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3684','终端云服务亚太生态发展运营中心','Consumer Cloud Service Asia Pacific Ecosystem Development Operations Center','office','071687',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3685','终端云服务欧亚生态发展运营中心','Consumer Cloud Service Eurasia Ecosystem Development Operations Center','office','071685',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3686','终端云服务中东非洲生态发展运营中心','Consumer Cloud Service Middle East & Africa Ecosystem Development Operations Center','office','071686',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3687','终端云服务拉美生态发展运营中心','Consumer Cloud Service Latin America Ecosystem Development Operations Center','office','071688',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3688','终端云服务欧洲生态发展运营中心','Consumer Cloud Service European Ecosystem Development Operations Center','office','071684',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3689','大中华终端政企业务部','Greater China Device Government & Enterprise Business Dept','office','050886',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3690','0号代表处','0# Rep Office, CN','office','071465',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3691','TX','TX','office','042528',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3692','塞匈代表处','Serbia & Hungary Rep Office','office','048626',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3693','A5代表处','A5 Rep Office','office','048625',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3694','南欧终端业务部','Southern Europe Device Business Dept','office','071333',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3695','深圳政企代表处','Guangdong Shenzhen Government & Enterprise Business Dept, CN','office','043655',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3696','终端BG渠道部','Consumer BG Channel Dept','office','069644',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3697','拉美终端业务部','Latin America Device Business Dept','office','040605',NULL,NULL,'0','0',NULL);
insert into T_SYS_DATA (DATA_ID, DATA_NAME_CN, DATA_NAME_EN, DATA_TYPE, DATA_CODE, PARENT_ID, ROOT_ID, SORT, SECURITY_FLAG, DESCRIPTION) values('3698','欧亚终端业务部','Eurasia Device Business Dept','office','024574',NULL,NULL,'0','0',NULL);

DROP TABLE IF EXISTS t_schedule_task;
CREATE TABLE IF NOT EXISTS t_schedule_task (
    id  INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
    task_num VARCHAR(64)      COMMENT '任务单号',
    module_name VARCHAR(512)       COMMENT '上报模块key',
    param   TEXT                   COMMENT '参数',
    upload_num VARCHAR(128)        COMMENT '上报次数',
    creator VARCHAR(64)            COMMENT '创建人',
    create_time TIMESTAMP          COMMENT '创建时间',
    upload_time TIMESTAMP          COMMENT '上报重试时间',
    additional_field  VARCHAR(512)      COMMENT '附加备用字段',
    CONSTRAINT t_schedule_task PRIMARY KEY (id)
);

DROP TABLE IF EXISTS t_block_list_menu_info;
CREATE TABLE IF NOT EXISTS t_block_list_menu_info(
    id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
    region_code                VARCHAR(64)                      COMMENT '地区部编码',
    rep_office_Code            VARCHAR(64)                      COMMENT '代表处编码',
    productLine_code           VARCHAR(64)                      COMMENT '产品线编码',
    tool_name                  VARCHAR(128)                     COMMENT '工具名称',
    tool_version               VARCHAR(128)                     COMMENT '工具版本',
    menu_cn                    VARCHAR(256)                     COMMENT '中文菜单名称',
    menu_en                    VARCHAR(256)                     COMMENT '英文菜单名称',
    menu_code                  VARCHAR(128)                     COMMENT '菜单识别码',
    risk_level                 INTEGER                          COMMENT '风险级别',
    operator                   VARCHAR(64)                      COMMENT '操作人',
    create_time                TIMESTAMP                        COMMENT '创建时间',
    CONSTRAINT t_block_list_menu_info PRIMARY KEY (id)
);

DROP TABLE IF EXISTS t_white_list_menu_info;
CREATE TABLE IF NOT EXISTS t_white_list_menu_info(
    id                         INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
    region_code                VARCHAR(64)                      COMMENT '地区部编码',
    rep_office_Code            VARCHAR(64)                      COMMENT '代表处编码',
    productLine_code           VARCHAR(64)                      COMMENT '产品线编码',
    tool_name                  VARCHAR(128)                     COMMENT '工具名称',
    tool_version               VARCHAR(128)                     COMMENT '工具版本',
    menu_cn                    VARCHAR(256)                     COMMENT '中文菜单名称',
    menu_en                    VARCHAR(256)                     COMMENT '英文菜单名称',
    menu_code                  VARCHAR(128)                     COMMENT '菜单识别码',
    risk_level                 INTEGER                          COMMENT '风险级别',
    operator                   VARCHAR(64)                      COMMENT '操作人',
    create_time                TIMESTAMP                        COMMENT '创建时间',
    CONSTRAINT t_white_list_menu_info PRIMARY KEY (id)
);


DROP TABLE IF EXISTS t_sys_config;
CREATE TABLE IF NOT EXISTS t_sys_config (
                                            id  INTEGER  NOT NULL AUTO_INCREMENT COMMENT 'id',
                                            sys_key           VARCHAR(64)               COMMENT '系统配置key',
    sys_value         VARCHAR(512)              COMMENT '系统配置值',
    description       VARCHAR(128)              COMMENT '描述信息',
    CONSTRAINT t_sys_config PRIMARY KEY (sys_key)
    );

insert into t_sys_config(sys_key, sys_value, description) values ('agingDay', '180', '数据老化时间，默认180天');

DROP TABLE IF EXISTS t_feature_record_info;
CREATE TABLE IF NOT EXISTS t_feature_record_info (
     id                         INTEGER  NOT NULL AUTO_INCREMENT  COMMENT 'id',
     create_time      		    TIMESTAMP                         COMMENT '创建时间',
     feature_operate_time       TIMESTAMP                         COMMENT '特性操作时间',
     feature_record_times       INTEGER                      	  COMMENT '特性操作记录次数',
     service_volume             INTEGER                      	  COMMENT '业务量',
     feature_code               VARCHAR(64)                       COMMENT '特性编码',
    CONSTRAINT t_feature_record_info PRIMARY KEY (id)
);
COMMENT ON TABLE t_feature_record_info IS '特性操作记录表';